/**
 * Module for the list of discussions on when viewing a forum.
 *
 * @module     mod_forum/discussion_list
 * @copyright  2019 Andrew Nicols <andrew@nicols.co.uk>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_forum/discussion_list",["jquery","core/templates","core/str","core/notification","mod_forum/subscription_toggle","mod_forum/selectors","mod_forum/repository","core/pubsub","mod_forum/forum_events","core_form/changechecker"],(function($,Templates,Str,Notification,SubscriptionToggle,Selectors,Repository,PubSub,ForumEvents,FormChangeChecker){return{init:function(root){SubscriptionToggle.init(root,!1,(function(toggleElement,context){var toggleId=toggleElement.attr("id"),newTargetState=context.userstate.subscribed?0:1;toggleElement.data("targetstate",newTargetState);var stringKey=context.userstate.subscribed?"unsubscribediscussion":"subscribediscussion";return Str.get_string(stringKey,"mod_forum").then((function(string){return toggleElement.closest("td").find('label[for="'+toggleId+'"]').find("span").text(string),string}))})),function(root){PubSub.subscribe(ForumEvents.SUBSCRIPTION_TOGGLED,(function(data){var discussionId=data.discussionId,subscribed=data.subscriptionState,discussionListItem=root.find(Selectors.discussion.item+"[data-discussionid= "+discussionId+"]"),subscribedLabel=discussionListItem.find(Selectors.discussion.subscribedLabel);subscribed?(discussionListItem.addClass("subscribed"),subscribedLabel.removeAttr("hidden")):(discussionListItem.removeClass("subscribed"),subscribedLabel.attr("hidden",!0))})),root.on("click",Selectors.post.inpageCancelButton,(function(e){FormChangeChecker.resetFormDirtyState(e.currentTarget)})),root.on("click",Selectors.favourite.toggle,(function(e){e.preventDefault();var toggleElement=$(this),forumId=toggleElement.data("forumid"),discussionId=toggleElement.data("discussionid"),subscriptionState=toggleElement.data("targetstate");Repository.setFavouriteDiscussionState(forumId,discussionId,subscriptionState).then((function(){return location.reload()})).catch(Notification.exception)})),root.on("click",Selectors.pin.toggle,(function(e){e.preventDefault();var toggleElement=$(this),forumId=toggleElement.data("forumid"),discussionId=toggleElement.data("discussionid"),state=toggleElement.data("targetstate");Repository.setPinDiscussionState(forumId,discussionId,state).then((function(){return location.reload()})).catch(Notification.exception)})),root.on("click",Selectors.lock.toggle,(function(e){var toggleElement=$(this),forumId=toggleElement.data("forumid"),discussionId=toggleElement.data("discussionid"),state=toggleElement.data("state");Repository.setDiscussionLockState(forumId,discussionId,state).then((function(context){var icon=toggleElement.parents(Selectors.summary.actions).find(Selectors.lock.icon),lockedLabel=toggleElement.parents(Selectors.discussion.item).find(Selectors.discussion.lockedLabel);return context.locked?(icon.removeClass("hidden"),lockedLabel.removeAttr("hidden")):(icon.addClass("hidden"),lockedLabel.attr("hidden",!0)),context})).then((function(context){return context.forumid=forumId,Templates.render("mod_forum/discussion_lock_toggle",context)})).then((function(html,js){return Templates.replaceNode(toggleElement,html,js)})).then((function(){return Str.get_string("lockupdated","forum").done((function(s){return Notification.addNotification({message:s,type:"info"})}))})).catch(Notification.exception),e.preventDefault()}))}(root)}}}));

//# sourceMappingURL=discussion_list.min.js.map