

define(['block_smowl/interact'], function (interact) {
    /**
     *
     */
    function makeCornerDraggable() {
        const cornerId = "block_smowl_content";
        const draggingFromId = "block_smowl_content_header";
        interact(`#${cornerId}`).draggable({
            inertia: true,
            allowFrom: `#${draggingFromId}`,
            modifiers: [
                interact.modifiers.restrictRect({
                    restriction: "body",
                    endOnly: true,
                }),
            ],
            listeners: {
                move(event) {
                    const target = event.target;
                    // Keep the dragged position in the data-x/data-y attributes
                    const x = (parseFloat(target.getAttribute("data-x")) || 0) + event.dx;
                    const y = (parseFloat(target.getAttribute("data-y")) || 0) + event.dy;

                    // Translate the element
                    target.style.transform = "translate(" + x + "px, " + y + "px)";

                    // Update the posiion attributes
                    target.setAttribute("data-x", x);
                    target.setAttribute("data-y", y);
                },
            },
        });
    }

    /**
     *
     */
    function moveCornerToBodyTag() {
        const cornerId = "block_smowl_content";
        const corner = document.getElementById(cornerId);
        const body = document.getElementsByTagName("body")[0];
        body.appendChild(corner);
    }

    return {
        init: function () {
            if (!document.getElementById("block_smowl_content")) {
                return;
            }
            makeCornerDraggable();
            moveCornerToBodyTag();
        },
    };
});