/*! For license information please see 730-amd.js.LICENSE.txt */
(self.webpackChunkmedimg_viewer=self.webpackChunkmedimg_viewer||[]).push([[730],{6882:(e,r,t)=>{var n=t(4015),o=t(3645)(n);o.push([e.id,"\n.medimg-viewer-image-wrapper[data-v-85be1442] {\r\n    position: relative;\r\n    float: left;\r\n    padding: 10px;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-annotation-menu[data-v-85be1442] {\r\n        position: absolute;\r\n        display: inline-block;\r\n        border: 2px solid var(--medimg-viewer-border);\r\n        background-color: var(--medimg-viewer-background);\r\n        cursor: pointer;\r\n        z-index: 2;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-annotation-menu > div[data-v-85be1442] {\r\n            line-height: 30px;\r\n            padding: 0 10px;\n}\n.medimg-viewer-image-wrapper .medimg-viewer-annotation-action[data-v-85be1442] {\r\n            color: var(--medimg-viewer-text-highlight);\n}\n.medimg-viewer-image-wrapper .medimg-viewer-annotation-action[data-v-85be1442]:hover {\r\n            background-color: var(--medimg-viewer-background-emphasize);\n}\n.medimg-viewer-image-wrapper .medimg-viewer-annotation-compare-row[data-v-85be1442] {\r\n            width: 200px;\r\n            opacity: 0.9;\r\n            font-size: 90%;\n}\n.medimg-viewer-image-wrapper .medimg-viewer-annotation-compare-row > span[data-v-85be1442]:nth-child(2) {\r\n                float: right;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker[data-v-85be1442] {\r\n        position: absolute;\r\n        display: inline-block;\r\n        width: 40px;\r\n        height: 40px;\r\n        line-height: 40px;\r\n        text-align: center;\r\n        z-index: 1; /* Below delete button toolbar button groups */\r\n        pointer-events: none;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-bottom[data-v-85be1442] {\r\n            bottom: 0;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-left[data-v-85be1442] {\r\n            left: 0;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-right[data-v-85be1442] {\r\n            right: 0;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-top[data-v-85be1442] {\r\n            top: 0;\n}\n.medimg-viewer-image-loading-progress[data-v-85be1442] {\r\n        position: absolute;\r\n        top: 0;\r\n        left: 0;\r\n        width: 100%;\r\n        height: 10px;\r\n        border-bottom: solid 1px var(--medimg-viewer-border-faint);\n}\n.medimg-viewer-image-loading-progress > div[data-v-85be1442] {\r\n            width: 0px;\r\n            height: 9px;\r\n            background-color: var(--medimg-viewer-background-emphasize);\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-tool-icons[data-v-85be1442] {\r\n        position: absolute;\r\n        top: 40px;\r\n        right: 10px;\r\n        font-size: 20px;\r\n        color: var(--medimg-viewer-text-faint);\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-tool-icons > svg[data-v-85be1442] {\r\n            cursor: pointer;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-link-icon-active[data-v-85be1442] {\r\n            color: var(--medimg-viewer-text-main);\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-meta-topleft[data-v-85be1442] {\r\n        position: absolute;\r\n        left: 10px;\r\n        top: 10px;\r\n        display: flex;\r\n        flex-direction: column;\r\n        line-height: 20px;\r\n        pointer-events: none;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-meta-topright[data-v-85be1442] {\r\n        position: absolute;\r\n        right: 10px;\r\n        top: 10px;\r\n        display: flex;\r\n        flex-direction: column;\r\n        line-height: 20px;\r\n        text-align: right;\r\n        pointer-events: none;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-meta-bottomleft[data-v-85be1442] {\r\n        position: absolute;\r\n        left: 10px;\r\n        bottom: 10px;\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        line-height: 20px;\r\n        pointer-events: none;\n}\n.medimg-viewer-image-wrapper > .medimg-viewer-meta-bottomright[data-v-85be1442] {\r\n        position: absolute;\r\n        right: 10px;\r\n        bottom: 10px;\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        text-align: right;\r\n        height: calc(100% - 10px);\r\n        line-height: 20px;\r\n        pointer-events: none;\n}\n.medimg-viewer-meta-bottomright > .medimg-viewer-topogram[data-v-85be1442] {\r\n        position: relative;\r\n        right: -11px; /* cover the default image border */\r\n        bottom: -11px;\r\n        height: 20%;\r\n        pointer-events: none;\r\n        border: solid 1px var(--medimg-viewer-border-faint);\r\n        background-color: var(--medimg-viewer-background);\r\n        transform-origin: bottom right;\n}\n.medimg-viewer-image-container > div[data-v-85be1442] {\r\n            font-size: 24px;\r\n            font-family: sans-serif;\r\n            font-weight: bold;\r\n            font-style: italic;\r\n            color: var(--medimg-viewer-text-faint);\r\n            text-align: center;\n}\n.medimg-viewer-image-disabled[data-v-85be1442] {\r\n            pointer-events: none;\n}\r\n","",{version:3,sources:["webpack://./src/components/Radiology/Dicom/DicomImageDisplay.vue"],names:[],mappings:";AAslCA;IACA,kBAAA;IACA,WAAA;IACA,aAAA;AACA;AACA;QACA,kBAAA;QACA,qBAAA;QACA,6CAAA;QACA,iDAAA;QACA,eAAA;QACA,UAAA;AACA;AACA;YACA,iBAAA;YACA,eAAA;AACA;AACA;YACA,0CAAA;AACA;AACA;YACA,2DAAA;AACA;AACA;YACA,YAAA;YACA,YAAA;YACA,cAAA;AACA;AACA;gBACA,YAAA;AACA;AACA;QACA,kBAAA;QACA,qBAAA;QACA,WAAA;QACA,YAAA;QACA,iBAAA;QACA,kBAAA;QACA,UAAA,EAAA,8CAAA;QACA,oBAAA;AACA;AACA;YACA,SAAA;AACA;AACA;YACA,OAAA;AACA;AACA;YACA,QAAA;AACA;AACA;YACA,MAAA;AACA;AACA;QACA,kBAAA;QACA,MAAA;QACA,OAAA;QACA,WAAA;QACA,YAAA;QACA,0DAAA;AACA;AACA;YACA,UAAA;YACA,WAAA;YACA,2DAAA;AACA;AACA;QACA,kBAAA;QACA,SAAA;QACA,WAAA;QACA,eAAA;QACA,sCAAA;AACA;AACA;YACA,eAAA;AACA;AACA;YACA,qCAAA;AACA;AACA;QACA,kBAAA;QACA,UAAA;QACA,SAAA;QACA,aAAA;QACA,sBAAA;QACA,iBAAA;QACA,oBAAA;AACA;AACA;QACA,kBAAA;QACA,WAAA;QACA,SAAA;QACA,aAAA;QACA,sBAAA;QACA,iBAAA;QACA,iBAAA;QACA,oBAAA;AACA;AACA;QACA,kBAAA;QACA,UAAA;QACA,YAAA;QACA,aAAA;QACA,8BAAA;QACA,iBAAA;QACA,oBAAA;AACA;AACA;QACA,kBAAA;QACA,WAAA;QACA,YAAA;QACA,aAAA;QACA,8BAAA;QACA,iBAAA;QACA,yBAAA;QACA,iBAAA;QACA,oBAAA;AACA;AACA;QACA,kBAAA;QACA,YAAA,EAAA,mCAAA;QACA,aAAA;QACA,WAAA;QACA,oBAAA;QACA,mDAAA;QACA,iDAAA;QACA,8BAAA;AACA;AACA;YACA,eAAA;YACA,uBAAA;YACA,iBAAA;YACA,kBAAA;YACA,sCAAA;YACA,kBAAA;AACA;AACA;YACA,oBAAA;AACA",sourcesContent:["<template>\r\n\r\n    <div ref=\"wrapper\" class=\"medimg-viewer-image-wrapper\" @mouseleave=\"mouseLeftImageArea\">\r\n        <div ref=\"annotation-menu\"\r\n            :class=\"[\r\n                'medimg-viewer-annotation-menu',\r\n                { 'medimg-viewer-hidden': !annotationMenu },\r\n            ]\"\r\n            :style=\"getAnnotationMenuStyles()\"\r\n            @contextmenu.prevent\r\n        >\r\n            <div v-if=\"!isSelectedAnnotation && annotationMenu && annotationMenu.type === 'len'\"  class=\"medimg-viewer-annotation-action\" @click=\"annotationMenu.select()\">\r\n                {{ t('Select as reference #{n}', { n: getNextFreeReferenceNum() }) }}\r\n            </div>\r\n            <div v-else-if=\"annotationMenu && annotationMenu.type === 'len'\" class=\"medimg-viewer-annotation-action\" @click=\"annotationMenu.unselect()\">\r\n                {{ t('Unselect reference #{n}', { n: getReferenceNumber() }) }}\r\n            </div>\r\n            <div v-for=\"(ref, idx) in getReferenceAnnotations()\" :key=\"`medimg-viewer-compare-annotations-${id}-${instanceNum}-${idx}`\">\r\n                <div v-if=\"ref\" class=\"medimg-viewer-annotation-compare-title\">{{ t('Compared to reference #{n}', { n: (idx + 1) }) }}</div>\r\n                <div v-if=\"ref\" class=\"medimg-viewer-annotation-compare-row\">\r\n                    <span>{{ t('Length') }}</span>\r\n                    <span>{{ getAnnotationLengthDiff(ref, annotationMenu.data) }}</span>\r\n                </div>\r\n                <div v-if=\"ref\" class=\"medimg-viewer-annotation-compare-row\">\r\n                    <span>{{ t('Angle') }}</span>\r\n                    <span>{{ getAnnotationAngleBetween(ref, annotationMenu.data) }}</span>\r\n                </div>\r\n            </div>\r\n            <div @click=\"annotationMenu.remove()\" class=\"medimg-viewer-annotation-action\">\r\n                {{ t('Delete') }}\r\n            </div>\r\n        </div>\r\n        <div ref=\"orientation-marker-top\"\r\n            :class=\"[\r\n                'medimg-viewer-orientation-marker',\r\n                'medimg-viewer-orientation-marker-top',\r\n                { 'medimg-viewer-hidden': !orientationMarkers.top },\r\n            ]\"\r\n        >\r\n            {{ orientationMarkers.top }}\r\n        </div>\r\n        <div ref=\"orientation-marker-left\"\r\n            :class=\"[\r\n                'medimg-viewer-orientation-marker',\r\n                'medimg-viewer-orientation-marker-left',\r\n                { 'medimg-viewer-hidden': !orientationMarkers.left },\r\n            ]\"\r\n        >\r\n            {{ orientationMarkers.left }}\r\n        </div>\r\n        <div ref=\"orientation-marker-bottom\"\r\n            :class=\"[\r\n                'medimg-viewer-orientation-marker',\r\n                'medimg-viewer-orientation-marker-bottom',\r\n                { 'medimg-viewer-hidden': !orientationMarkers.bottom },\r\n            ]\"\r\n        >\r\n            {{ orientationMarkers.bottom }}\r\n        </div>\r\n        <div ref=\"orientation-marker-right\"\r\n            :class=\"[\r\n                'medimg-viewer-orientation-marker',\r\n                'medimg-viewer-orientation-marker-right',\r\n                { 'medimg-viewer-hidden': !orientationMarkers.right },\r\n            ]\"\r\n        >\r\n            {{ orientationMarkers.right }}\r\n        </div>\r\n        <div ref=\"container\" :id=\"`container-${id}-${instanceNum}`\"\r\n            :class=\"[\r\n                'medimg-viewer-image-container',\r\n                { 'medimg-viewer-image-disabled': $store.state.imageResourceLoading }\r\n            ]\"\r\n            @contextmenu.prevent\r\n            @mouseup=\"resizeImage(true)\"\r\n        >\r\n            <div v-if=\"!mainImageLoaded\" class=\"medimg-viewer-image-loading\">\r\n                {{ t('Loading') }}\r\n                <span ref=\"loading-dot-1\" style=\"visibility: hidden\">.</span>\r\n                <span ref=\"loading-dot-2\" style=\"visibility: hidden\">.</span>\r\n                <span ref=\"loading-dot-3\" style=\"visibility: hidden\">.</span>\r\n            </div>\r\n        </div>\r\n        \x3c!-- Image tools --\x3e\r\n        <span class=\"medimg-viewer-tool-icons\">\r\n            <font-awesome-icon v-if=\"resource.isStack && isFirstLoaded\"\r\n                :icon=\"resource.isLinked ? ['fal', 'link'] : ['fal', 'unlink']\"\r\n                :title=\"t('Link this image stack')\"\r\n                @click=\"linkImageStack()\"\r\n                :class=\"{ 'medimg-viewer-link-icon-active' : resource.isLinked }\"\r\n                fixed-width\r\n            />\r\n            <font-awesome-icon v-if=\"isFirstLoaded\"\r\n                :icon=\"['fal', 'reply-all']\"\r\n                :title=\"t('Reset all adjustments')\"\r\n                @click=\"displayImage(true)\"\r\n                fixed-width\r\n            />\r\n        </span>\r\n        \x3c!-- Metadata --\x3e\r\n        <div v-if=\"isFirstLoaded\" class=\"medimg-viewer-meta-topleft\">\r\n            <div>{{ resource.name }}</div>\r\n        </div>\r\n        <div v-if=\"isFirstLoaded\" class=\"medimg-viewer-meta-topright\">\r\n            <div>{{ resource.dimensions[0] }} x {{ resource.dimensions[1] }}</div>\r\n        </div>\r\n        <div v-if=\"isFirstLoaded\" class=\"medimg-viewer-meta-bottomleft\">\r\n            <div v-if=\"resource.currentImage.tubeCurrent && resource.currentImage.exposureTime && resource.currentImage.exposure\">\r\n                Exp: {{ resource.currentImage.tubeCurrent }} mA,\r\n                     {{ resource.currentImage.exposureTime }} msec,\r\n                     {{ resource.currentImage.exposure }} mAs\r\n            </div>\r\n            <div v-if=\"resource.isStack\">\r\n                {{ t('Slice') }}: {{ resource.currentPosition + 1 }}/{{ resource.images.length }}\r\n            </div>\r\n            <div v-if=\"resource.isStack && resource.currentImage.sliceLocation\">\r\n                Loc: {{ resource.currentImage.sliceLocation }} mm\r\n            </div>\r\n            <div v-if=\"resource.isStack && resource.currentImage.sliceThickness\">\r\n                Thk: {{ resource.currentImage.sliceThickness.toFixed(1) }} mm\r\n            </div>\r\n            <div v-if=\"resource.isStack && resource.currentImage.KVP\">\r\n                KVP: {{ resource.currentImage.KVP }} kV\r\n            </div>\r\n        </div>\r\n        <div class=\"medimg-viewer-meta-bottomright\">\r\n            \x3c!-- Topogram --\x3e\r\n            <div v-if=\"resource.topogram\" ref=\"topogram\" :id=\"`topogram-${id}-${instanceNum}`\"\r\n                :class=\"[\r\n                    'medimg-viewer-topogram',\r\n                    { 'medimg-viewer-hidden': !topoImageLoaded }\r\n                ]\"\r\n                @contextmenu.prevent\r\n            >\r\n            </div>\r\n            <div v-if=\"isFirstLoaded && resource.imageOrientation &&\r\n                       (!isNaN(resource.imageOrientation[0]) || !isNaN(resource.imageOrientation[1]))\r\n            \">\r\n                Orient: {{ !isNaN(resource.imageOrientation[0]) ? resource.imageOrientation[0] : '-- ' }}°\r\n                        / {{ !isNaN(resource.imageOrientation[1]) ? resource.imageOrientation[1] : '-- ' }}°\r\n            </div>\r\n        </div>\r\n        \x3c!-- Loading indicator --\x3e\r\n        <div :class=\"[\r\n            'medimg-viewer-image-loading-progress',\r\n            { 'medimg-viewer-hidden': mainImageLoaded || !resource.isStack }\r\n        ]\">\r\n            <div ref=\"loading-progress-bar\"></div>\r\n        </div>\r\n    </div>\r\n\r\n</template>\r\n\r\n<script lang=\"ts\">\r\nimport Vue from 'vue'\r\nimport * as cornerstone from 'cornerstone-core'\r\nimport cornerstoneTools from 'cornerstone-tools'\r\nimport cornerstoneMath from 'cornerstone-math'\r\nimport DicomImage from '../../../assets/dicom/DicomImage'\r\nimport TopogramReferenceLineTool from '../../../assets/tools/TopogramReferenceLineTool'\r\n// Some additional Cornerstone Tools methods\r\nconst convertToVector3 = cornerstoneTools.importInternal('util/convertToVector3')\r\n\r\nlet INSTANCE_NUM = 0\r\nconst CLICK_DISTANCE_THRESHOLD = 7.5\r\n\r\nexport default Vue.extend({\r\n    components: {\r\n    },\r\n    props: {\r\n        containerSize: Array, // The size of the entire image media container as [width, height]\r\n        layoutPosition: Array, // Element position in layout grid [[colPos, cols], [rowPos, rows]]\r\n        linkedStackPos: Number, // Linked stack position\r\n        resource: Object, // DICOMResource or DicomImageStack\r\n        topogram: Object, // DicomImage\r\n        synchronizers: {\r\n            type: Object,\r\n            default: null\r\n        },\r\n    },\r\n    data () {\r\n        return {\r\n            dicomWrapper: null as unknown as HTMLDivElement, // DICOM image wrapper\r\n            dicomEl: null as unknown as HTMLDivElement, // DICOM image element\r\n            topoEl: null as unknown as HTMLDivElement, // Topogram element\r\n            isFirstLoaded: false, // At least one image is loaded\r\n            isLinked: false, // Whether this image is linked or not\r\n            annotationMenu: null as any, // Annotation selected by the user\r\n            orientationMarkers: { top: '', right: '', bottom: '', left: '' },\r\n            // Keep track when the main and possible topogram images have loaded\r\n            mainImageLoaded: false,\r\n            topoImageLoaded: false,\r\n            topoImageBounds: { x: [0, 0], y: [0, 0] },\r\n            // Topogram reference line\r\n            topogramSynchronizer: null as any,\r\n            loadingDotCycle: 0,\r\n            // Cache some viewport properties\r\n            viewportProps: null as any,\r\n            // Don't continue async operations if component has been destroyed\r\n            destroyed: false,\r\n            // Store unsubscribe methods\r\n            unsubscribeActions: null as unknown as Function,\r\n            unsubscribeMutations: null as unknown as Function,\r\n            // We need a way to uniquely identify this component instance's elements\r\n            // from other iterations of the same resource\r\n            instanceNum: INSTANCE_NUM++,\r\n        }\r\n    },\r\n    watch: {\r\n        containerSize (value: Array<number>, old: Array<number>) {\r\n            this.resizeImage()\r\n        },\r\n        layoutPosition (value: Array<number>, old: Array<number>) {\r\n            // This REALLY has to be called twice or annotation menu position breaks.\r\n            // It has something to do with the viewport scale not updating on the first go.\r\n            this.resizeImage()\r\n            this.resizeImage(true)\r\n        },\r\n        resource: {\r\n            deep: true,\r\n            handler (value: any) {\r\n                if (!this.mainImageLoaded && this.$refs['loading-progress-bar']) {\r\n                    (this.$refs['loading-progress-bar'] as HTMLDivElement).style.width = `${100*value.preloaded/value.images.length}%`\r\n                }\r\n            }\r\n        }\r\n    },\r\n    computed: {\r\n        /**\r\n         * Shorthand for image resource id\r\n         */\r\n        id () {\r\n            return this.resource.id\r\n        },\r\n        isSelectedAnnotation () {\r\n            if (!this.annotationMenu) {\r\n                return false\r\n            }\r\n            const refs = this.resource.referenceAnnotations // Stupid trick to avoid TS error\r\n            if (!this.resource.referenceAnnotations[this.annotationMenu.type as keyof typeof refs].length ||\r\n                this.resource.referenceAnnotations[this.annotationMenu.type as keyof typeof refs].indexOf(this.annotationMenu.data) === -1\r\n            ) {\r\n                return false\r\n            }\r\n            return true\r\n        },\r\n    },\r\n    methods: {\r\n        /** Shorthand for component-specific translations */\r\n        t: function (str: string, args?: any) {\r\n            if (args) {\r\n                return this.$t(`components.Radiology.Dicom.DicomImageDisplay.${str}`, args)\r\n            } else {\r\n                return (this.$t('components.Radiology.Dicom.DicomImageDisplay') as any)[str]\r\n            }\r\n        },\r\n        /**\r\n         * Adjust image levels (window width and center) by given values.\r\n         * @param {number} x amount to adjust window width.\r\n         * @param {number} y amount to adjust window center.\r\n         */\r\n        adjustLevels: function (x: number, y: number) {\r\n            this.resource.viewport.voi.windowWidth += (x / this.resource.viewport.scale)\r\n            this.resource.viewport.voi.windowCenter += (y / this.resource.viewport.scale)\r\n            cornerstone.setViewport(this.dicomEl, this.resource.viewport)\r\n        },\r\n        /**\r\n         * Display the single image from this.resource or current image (this.resource.currentPosition) from image stack.\r\n         * @param {boolean} defaultVP use the default viewport settings (resetting any modifications).\r\n         */\r\n        displayImage: async function (defaultVP: boolean = false, stackPos?: number): Promise<void|object> {\r\n            const imageUrl = this.resource.currentImage.url\r\n            return await cornerstone.loadImage(imageUrl).then((image: any) => {\r\n                if (defaultVP || !this.resource.viewport) {\r\n                    // Set viewport to default settings\r\n                    this.resource.viewport = cornerstone.getDefaultViewportForImage(this.dicomEl, image)\r\n                    if (this.viewportProps) {\r\n                        this.resource.viewport = Object.assign({...this.resource.viewport}, {...this.viewportProps})\r\n                        this.viewportProps = null\r\n                    }\r\n                    // Resize the image to align and display topogram\r\n                    this.resizeImage()\r\n                }\r\n                if (this.resource.viewport) {\r\n                    cornerstone.displayImage(this.dicomEl, image, this.resource.viewport)\r\n                }\r\n            })\r\n        },\r\n        flipHorizontally: function () {\r\n            if (this.dicomEl && this.resource.viewport) {\r\n                this.resource.viewport.hflip = !this.resource.viewport.hflip\r\n                this.displayImage()\r\n                this.updateOrientationMarkers()\r\n            }\r\n        },\r\n        flipVertically: function () {\r\n            if (this.dicomEl && this.resource.viewport) {\r\n                this.resource.viewport.vflip = !this.resource.viewport.vflip\r\n                this.displayImage()\r\n                this.updateOrientationMarkers()\r\n            }\r\n        },\r\n        getAnnotationAngleBetween: function (ref: any, act: any) {\r\n            // Calculate active line angle to x-axis\r\n            const actX = act.handles.end.x - act.handles.start.x\r\n            const actY = act.handles.end.y - act.handles.start.y\r\n            const actAng = actY !== 0 || actX > 0 ? 2*Math.atan(actY/(actX + Math.sqrt(actX**2 + actY**2)))*180/Math.PI\r\n                           : actX === 0 ? 0 : 180 // Special cases\r\n            // Calculate reference line angle to x-axis\r\n            const refX = ref.handles.end.x - ref.handles.start.x\r\n            const refY = ref.handles.end.y - ref.handles.start.y\r\n            const refAng = refY !== 0 || refX > 0 ? 2*Math.atan(refY/(refX + Math.sqrt(refX**2 + refY**2)))*180/Math.PI\r\n                           : refX === 0 ? 0 : 180\r\n            const angBtwn = (actAng - refAng + 360)%360\r\n            const angMinMax = [angBtwn%180, 180 - angBtwn%180]\r\n            return (Math.min(...angMinMax)).toFixed(1) + '° / ' + (Math.max(...angMinMax)).toFixed(1) + '°';\r\n        },\r\n        getAnnotationLengthDiff: function (ref: any, act: any) {\r\n            if (act.unit !== ref.unit) {\r\n                return '???'\r\n            }\r\n            const lenDiff = Math.abs(act.length - ref.length)\r\n            const diffSign = ref.length > act.length ? '-' : '+'\r\n            return `${diffSign}${lenDiff.toFixed(1)}${act.unit} (${diffSign}${(lenDiff/ref.length*100).toFixed(1)}%)`\r\n        },\r\n        getAnnotationMenuStyles () {\r\n            if (!this.annotationMenu) {\r\n                return 'display: none'\r\n            } else {\r\n                const offset = cornerstone.pageToPixel(this.dicomEl, 0, 0)\r\n                const osLeft = this.dicomEl.getBoundingClientRect().left\r\n                const osTop = this.dicomEl.getBoundingClientRect().top\r\n                const top = (this.annotationMenu.anchor.y - offset.y)*this.resource.viewport.scale - osTop + 20\r\n                const left = (this.annotationMenu.anchor.x - offset.x)*this.resource.viewport.scale - osLeft + 20\r\n                return `top: ${top}px; left: ${left}px`\r\n            }\r\n        },\r\n        getNextFreeReferenceNum () {\r\n            if (!this.annotationMenu) {\r\n                return 0\r\n            }\r\n            const refs = this.resource.referenceAnnotations\r\n            return this.resource.referenceAnnotations[this.annotationMenu.type as keyof typeof refs].length + 1\r\n        },\r\n        getReferenceAnnotations () {\r\n            if (!this.annotationMenu) {\r\n                return []\r\n            }\r\n            const refs = this.resource.referenceAnnotations\r\n            const valid = []\r\n            for (const anno of this.resource.referenceAnnotations[this.annotationMenu.type as keyof typeof refs]) {\r\n                // Note! This method must return the same amount of elements as there are annotations, otherwise\r\n                // annotation numbering will be off\r\n                if (anno !== this.annotationMenu.data) {\r\n                    valid.push(anno)\r\n                } else {\r\n                    valid.push(null)\r\n                }\r\n            }\r\n            return valid\r\n        },\r\n        getReferenceNumber () {\r\n            if (!this.annotationMenu) {\r\n                return 0\r\n            }\r\n            const refs = this.resource.referenceAnnotations\r\n            return this.resource.referenceAnnotations[this.annotationMenu.type as keyof typeof refs].indexOf(this.annotationMenu.data) + 1\r\n        },\r\n        /**\r\n         * Get topogram dimensions, scaled down if needed.\r\n         * @return [width, height, scale]\r\n         */\r\n        getTopogramDimensions: function (): any {\r\n            if (!this.resource.topogram || !this.topoImageLoaded) {\r\n                return undefined\r\n            }\r\n            const dimensions = this.containerSize as number[]\r\n            const colPos = this.layoutPosition[0] as number[]\r\n            const rowPos = this.layoutPosition[1] as number[]\r\n            const isRowFirst = (colPos[0] === 0)\r\n            const isColLast = (rowPos[0] === rowPos[1] - 1)\r\n            // Remove 20 px for padding\r\n            let hPad = isRowFirst ? 20 : 21\r\n            let vPad = isColLast ? 20 : 21\r\n            const topoBounds = this.resource.topogramPaddedBounds\r\n            const topoW = topoBounds.x[1]-topoBounds.x[0]\r\n            const topoH = topoBounds.y[1]-topoBounds.y[0]\r\n            // Scale it down for smaller viewports\r\n            const maxW = (dimensions[0]/colPos[1] - hPad)*0.25\r\n            const maxH = (dimensions[1]/rowPos[1] - vPad)*0.25\r\n            const scale = Math.min(1, maxW/topoW, maxH/topoH)\r\n            return { width: scale*topoW, height: scale*topoH, scale: scale }\r\n        },\r\n        /**\r\n         * Handle right click (or context menu triggering) event on the image.\r\n         */\r\n        handleRightClick: function (e: any) {\r\n            e.event.preventDefault()\r\n            //const getHandleNearImagePoint = cornerstoneTools.importInternal('manipulators/getHandleNearImagePoint')\r\n            const toolStates = cornerstoneTools.globalImageIdSpecificToolStateManager.saveToolState()\r\n            // Get tool state for currently displayed image\r\n            const localState = toolStates[this.resource.currentImage.url]\r\n            // Clicked image coordinates\r\n            const coords = {...e.lastPoints.image}\r\n            if (localState) {\r\n                const annoTypes = {\r\n                    //ang: `Angle-${this.$store.state.appName}`,\r\n                    len: `Length-${this.$store.state.appName}`,\r\n                    roiE: `EllipticalRoi-${this.$store.state.appName}`,\r\n                }\r\n                // Remove annotation method\r\n                const removeAnnotation = (type: string, index: number) => {\r\n                    const anno = localState[annoTypes[type as keyof typeof annoTypes]].data[index]\r\n                    const annoIdx = this.resource.referenceAnnotations[type as keyof typeof annoTypes].indexOf(anno)\r\n                    if (annoIdx !== -1) {\r\n                        this.resource.referenceAnnotations[type as keyof typeof annoTypes].splice(annoIdx, 1)\r\n                    }\r\n                    localState[annoTypes[type as keyof typeof annoTypes]].data.splice(index, 1)\r\n                    cornerstoneTools.globalImageIdSpecificToolStateManager.restoreToolState(toolStates)\r\n                    cornerstone.updateImage(this.dicomEl, false)\r\n                    this.annotationMenu = null\r\n                }\r\n                // Select annotation method\r\n                const selectAnnotation = (type: string, index: number) => {\r\n                    if (type === 'roi') {\r\n                        const anno = localState[`EllipticalRoi-${this.$store.state.appName}`].data[index]\r\n                        if (this.resource.referenceAnnotations.roiE.indexOf(anno) === -1) {\r\n                            this.resource.referenceAnnotations.roiE.push(anno)\r\n                        }\r\n                    } else if (type === 'len') {\r\n                        const anno = localState[`Length-${this.$store.state.appName}`].data[index]\r\n                        if (this.resource.referenceAnnotations.len.indexOf(anno) === -1) {\r\n                            this.resource.referenceAnnotations.len.push(anno)\r\n                        }\r\n                    }\r\n                }\r\n                // Check if there are any angles, RoIs or lengths on the active image\r\n                for (const [key, index] of Object.entries(annoTypes)) {\r\n                    if (localState[index]) {\r\n                        for (let i=0; i<localState[index].data.length; i++) {\r\n                            const anno = localState[index].data[i]\r\n                            const threshold = CLICK_DISTANCE_THRESHOLD/this.resource.viewport.scale // Take scale into account\r\n                            if (cornerstoneMath.point.distance(anno.handles.start, coords) <= threshold ||\r\n                                cornerstoneMath.point.distance(anno.handles.end, coords) <= threshold\r\n                            ) {\r\n                                this.annotationMenu = {\r\n                                    anchor: cornerstoneMath.point.distance(anno.handles.start, coords) <= threshold\r\n                                            ? anno.handles.start : anno.handles.end,\r\n                                    data: anno,\r\n                                    remove: () => {\r\n                                        removeAnnotation(key, i)\r\n                                    },\r\n                                    select: () => {\r\n                                        selectAnnotation(key, i)\r\n                                    },\r\n                                    type: key,\r\n                                    unselect: () => {\r\n                                        const annoIdx = this.resource.referenceAnnotations[key as keyof typeof annoTypes].indexOf(anno)\r\n                                        if (annoIdx !== -1) {\r\n                                            this.resource.referenceAnnotations[key as keyof typeof annoTypes].splice(annoIdx, 1)\r\n                                        }\r\n                                    },\r\n                                }\r\n                                return\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n            this.hideAnnotationMenu()\r\n        },\r\n        hideAnnotationMenu: function () {\r\n            this.annotationMenu = null\r\n        },\r\n        /**\r\n         * Invert the image colors values.\r\n         */\r\n        invertImage: function () {\r\n            this.resource.viewport.invert = !this.resource.viewport.invert\r\n            this.displayImage()\r\n        },\r\n        /**\r\n         * Link image stack at current index. The link is used both to check if this\r\n         * image stack is linked and to reset its position.\r\n         * @param {boolean} value set this stack as linked or not; toggle if omitted\r\n         */\r\n        linkImageStack: function (value?: boolean) {\r\n            if (!this.resource.isStack) {\r\n                return\r\n            } else if (value === undefined) {\r\n                value = !this.resource.isLinked\r\n            }\r\n            if (this.resource.isLinked !== value) {\r\n                if (value) {\r\n                    this.resource.link(this.$store.state.linkedScrollPosition)\r\n                } else {\r\n                    this.resource.unlink()\r\n                }\r\n            }\r\n        },\r\n        /**\r\n         * Mouse has left the image area.\r\n         */\r\n        mouseLeftImageArea: function () {\r\n            this.hideAnnotationMenu()\r\n            // Re-enable currently active tool (this is not really needed for all tools)\r\n            this.$store.dispatch('tools:re-enable-active')\r\n        },\r\n        /**\r\n         * Pan image by given coordinates.\r\n         * @param {number} x distance on the x-axis.\r\n         * @param {number} y distance on the y-axis.\r\n         */\r\n        panImage: function (x: number, y: number) {\r\n            this.resource.viewport.translation.x -= (x / this.resource.viewport.scale)\r\n            this.resource.viewport.translation.y -= (y / this.resource.viewport.scale)\r\n            cornerstone.setViewport(this.dicomEl, this.resource.viewport)\r\n        },\r\n        /**\r\n         * Reset the viewport to default state.\r\n         */\r\n        resetViewport: function () {\r\n            this.displayImage(true)\r\n            this.updateOrientationMarkers()\r\n        },\r\n        /**\r\n         * Resize the displayed image into given dimensions.\r\n         */\r\n        resizeImage: function (first = false) {\r\n            if (!this.dicomEl || !this.dicomWrapper) {\r\n                return\r\n            }\r\n            const dimensions = this.containerSize as number[]\r\n            const colPos = this.layoutPosition[0] as number[]\r\n            const rowPos = this.layoutPosition[1] as number[]\r\n            const isRowFirst = (colPos[0] === 0)\r\n            const isColLast = (rowPos[0] === rowPos[1] - 1)\r\n            // Remove 20 px for padding\r\n            let hPad = isRowFirst ? 20 : 21\r\n            let vPad = isColLast ? 20 : 21\r\n            this.dicomEl.style.width = `${dimensions[0]/colPos[1] - hPad}px`\r\n            this.dicomEl.style.height = `${dimensions[1]/rowPos[1] - vPad}px`\r\n            this.dicomWrapper.style.borderLeft\r\n                = isRowFirst? 'none' : '1px solid var(--medimg-viewer-border-faint)'\r\n            this.dicomWrapper.style.borderBottom\r\n                = isColLast ? 'none' : '1px solid var(--medimg-viewer-border-faint)'\r\n            // Resize image if it is done loading\r\n            if (this.mainImageLoaded) {\r\n                if (first) {\r\n                    this.viewportProps = this.resource.viewport ?\r\n                        {\r\n                            hflip: this.resource.viewport.hflip,\r\n                            vflip: this.resource.viewport.vflip,\r\n                            invert: this.resource.viewport.invert,\r\n                            translation: {...this.resource.viewport.translation},\r\n                            rotation: this.resource.viewport.rotation,\r\n                            voi: {...this.resource.viewport.voi},\r\n                            voiLUT: this.resource.viewport.voiLUT\r\n                        } : null\r\n                    this.resource.viewport = cornerstone.getViewport(this.dicomEl)\r\n                }\r\n                cornerstone.resize(this.dicomEl, false)\r\n            } else {\r\n                // Update the loading text position\r\n                const loadingText = (document.querySelector(\r\n                        `#container-${this.id}-${this.instanceNum} > .medimg-viewer-image-loading`\r\n                    ) as HTMLDivElement)\r\n                loadingText.style.width = `${dimensions[0]/colPos[1] - hPad}px`\r\n                loadingText.style.height = `${dimensions[1]/rowPos[1] - vPad}px`\r\n                loadingText.style.lineHeight = `${dimensions[1]/rowPos[1] - vPad}px`\r\n            }\r\n            // Resize possible topogram image\r\n            if (this.resource.topogram && this.topoImageLoaded) {\r\n                const topoSize = this.getTopogramDimensions()\r\n                // Add 2 pixels for borders\r\n                this.topoEl.style.width = `${topoSize.width + 2}px`\r\n                this.topoEl.style.height = `${topoSize.height + 2}px`\r\n                //this.topoEl.style.transform = `scale(${Math.min(1, maxW/topoW, maxH/topoH)})`\r\n                cornerstone.resize(this.topoEl, false)\r\n            }\r\n            this.updateOrientationMarkers()\r\n        },\r\n        rotateBy: function (angle: number) {\r\n            if (this.dicomEl && this.resource.viewport) {\r\n                this.resource.viewport.rotation += angle\r\n                this.displayImage()\r\n                this.updateOrientationMarkers()\r\n            }\r\n        },\r\n        /**\r\n         * Scroll the linked image stack, returning a promise that is fulfilled when the scrolling is\r\n         * complete. Promise will call true on success, false on failure.\r\n         * @param {string} oId id of the origin resource\r\n         * @param {number} relPos the relative master link position\r\n         */\r\n        scrollLinkedStack: async function (oId: string, relPos: number) {\r\n            if (!this.resource.isStack || !this.resource.isLinked || oId === this.id) {\r\n                return\r\n            }\r\n            // Position must be computed relative to linking point and master linking position\r\n            const locPos = (this.resource.linkedPosition || 0)/this.resource.images.length\r\n                           + relPos - (this.resource.masterLinkPosition || 0)\r\n            // Corrected local position must be between 0 and 1 (= 0 and 100% of image stack)\r\n            if (locPos >= 0 && locPos <= 1) {\r\n                // Check if we're already at the position.\r\n                // This is very likely if the origin stack has more images than this stack\r\n                // -> several origin stack images will map to the same local image\r\n                const absPos = Math.round(locPos*this.resource.images.length)\r\n                if (absPos !== this.resource.currentPosition) {\r\n                    // Don't scroll out of bounds\r\n                    if (absPos < 0 ) {\r\n                        this.resource.currentPosition = 0\r\n                    } else if (absPos >= this.resource.images.length) {\r\n                        this.resource.currentPosition = this.resource.images.length - 1\r\n                    } else {\r\n                        this.resource.currentPosition = absPos\r\n                    }\r\n                    await this.displayImage()\r\n                    // Fetch the current tool state properties and update current image index\r\n                    // to keep the scroll stack tool in sync with these changes\r\n                    const opts = cornerstoneTools.getToolState(this.dicomEl, 'stack').data[0]\r\n                    opts.currentImageIdIndex = this.resource.currentPosition\r\n                    cornerstoneTools.clearToolState(this.dicomEl, 'stack') // Remove old and add new\r\n                    cornerstoneTools.addToolState(this.dicomEl, 'stack', opts)\r\n                }\r\n            }\r\n            return true\r\n        },\r\n        /**\r\n         * Update the displayed orientation markers when image orientation has changed.\r\n         * Cornerstone Tools orientation markers prints the markers at the edges of the image, which can be troublesome\r\n         * when zooming and panning the image.\r\n         * This method is mostly copied from the aforementioned tool.\r\n         */\r\n        updateOrientationMarkers: function () {\r\n            if (!this.mainImageLoaded) {\r\n                return\r\n            }\r\n            const imagePlane = cornerstone.metaData.get(\r\n                                    'imagePlaneModule',\r\n                                    this.resource.isStack\r\n                                    ? this.resource.currentImage.url\r\n                                    : this.resource.url\r\n                                ) as any\r\n            if (!imagePlane || !imagePlane.rowCosines || !imagePlane.columnCosines) {\r\n                return\r\n            }\r\n            const rowVec3 = convertToVector3(imagePlane.rowCosines)\r\n            const rowAbs = new cornerstoneMath.Vector3(\r\n                Math.abs(rowVec3.x), Math.abs(rowVec3.y), Math.abs(rowVec3.z)\r\n            )\r\n            const ds = [this.t('orientation_right'), this.t('orientation_left')]\r\n            const ap = [this.t('orientation_anterior'), this.t('orientation_posterior')]\r\n            const cc = [this.t('orientation_cranial'), this.t('orientation_caudal')]\r\n            if (rowVec3.x < 0) ds.reverse()\r\n            if (rowVec3.y < 0) ap.reverse()\r\n            if (rowVec3.z < 0) cc.reverse()\r\n            const colVec3 = convertToVector3(imagePlane.columnCosines)\r\n            const colAbs = new cornerstoneMath.Vector3(\r\n                Math.abs(colVec3.x), Math.abs(colVec3.y), Math.abs(colVec3.z)\r\n            )\r\n            // Here is the main difference: I feel the default tool uses way too small a threshold for the\r\n            // image plane angle and shows confusing values if it is even the slightest bit askew\r\n            const MIN = 0.5 // Has to be within 60 deg of the axis (cos(60deg))\r\n            const markers = {\r\n                bottom: '', left: '', right: '', top: '' // Start with empty labels\r\n            }\r\n            // First left and right markers\r\n            for (let i = 0; i < 3; i++) {\r\n                if (rowAbs.x >= MIN && rowAbs.x > rowAbs.y && rowAbs.x > rowAbs.z) {\r\n                    markers.left += ds[0].toString()\r\n                    markers.right += ds[1].toString()\r\n                    rowAbs.x = 0\r\n                } else if (rowAbs.y >= MIN && rowAbs.y > rowAbs.x && rowAbs.y > rowAbs.z) {\r\n                    markers.left += ap[0].toString()\r\n                    markers.right += ap[1].toString()\r\n                    rowAbs.y = 0\r\n                } else if (rowAbs.z >= MIN && rowAbs.z > rowAbs.x && rowAbs.z > rowAbs.y) {\r\n                    markers.left += cc[0].toString()\r\n                    markers.right += cc[1].toString()\r\n                    rowAbs.z = 0\r\n                } else if (rowAbs.x >= MIN && rowAbs.y >= MIN && rowAbs.x === rowAbs.y) {\r\n                    markers.left += ds[0].toString() + ap[0].toString()\r\n                    markers.right += ds[1].toString() + ap[1].toString()\r\n                    rowAbs.x = 0\r\n                    rowAbs.y = 0\r\n                } else if (rowAbs.x >= MIN && rowAbs.z >= MIN && rowAbs.x === rowAbs.z) {\r\n                    markers.left += ds[0].toString() + cc[0].toString()\r\n                    markers.right += ds[1].toString() + cc[1].toString()\r\n                    rowAbs.x = 0\r\n                    rowAbs.z = 0\r\n                } else if (rowAbs.y >= MIN && rowAbs.z >= MIN && rowAbs.y === rowAbs.z) {\r\n                    markers.left += ap[0].toString() + cc[0].toString()\r\n                    markers.right += ap[1].toString() + cc[1].toString()\r\n                    rowAbs.y = 0\r\n                    rowAbs.z = 0\r\n                } else {\r\n                    break\r\n                }\r\n            }\r\n            // Then top and bottom markers\r\n            for (let i = 0; i < 3; i++) {\r\n                if (colAbs.x >= MIN && colAbs.x > colAbs.y && colAbs.x > colAbs.z) {\r\n                    markers.top += ds[0].toString()\r\n                    markers.bottom += ds[1].toString()\r\n                    colAbs.x = 0\r\n                } else if (colAbs.y >= MIN && colAbs.y > colAbs.x && colAbs.y > colAbs.z) {\r\n                    markers.top += ap[0].toString()\r\n                    markers.bottom += ap[1].toString()\r\n                    colAbs.y = 0\r\n                } else if (colAbs.z >= MIN && colAbs.z > colAbs.x && colAbs.z > colAbs.y) {\r\n                    markers.top += cc[0].toString()\r\n                    markers.bottom += cc[1].toString()\r\n                    colAbs.z = 0\r\n                } else if (colAbs.x >= MIN && colAbs.y >= MIN && colAbs.x === colAbs.y) {\r\n                    markers.top += ds[0].toString() + ap[0].toString()\r\n                    markers.bottom += ds[1].toString() + ap[1].toString()\r\n                    colAbs.x = 0\r\n                    colAbs.y = 0\r\n                } else if (colAbs.x >= MIN && colAbs.z >= MIN && colAbs.x === colAbs.z) {\r\n                    markers.top += ds[0].toString() + cc[0].toString()\r\n                    markers.bottom += ds[1].toString() + cc[1].toString()\r\n                    colAbs.x = 0\r\n                    colAbs.z = 0\r\n                } else if (colAbs.y >= MIN && colAbs.z >= MIN && colAbs.y === colAbs.z) {\r\n                    markers.top += ap[0].toString() + cc[0].toString()\r\n                    markers.bottom += ap[1].toString() + cc[1].toString()\r\n                    colAbs.y = 0\r\n                    colAbs.z = 0\r\n                } else {\r\n                    break\r\n                }\r\n            }\r\n            // Detect and correct for inversion and rotation of the image.\r\n            // There should be a way to get the initial vector to include this, but I haven't found it.\r\n            if (this.resource.viewport) {\r\n                if (this.resource.viewport.hflip) {\r\n                    [markers.left, markers.right] = [markers.right, markers.left]\r\n                }\r\n                if (this.resource.viewport.vflip) {\r\n                    [markers.top, markers.bottom] = [markers.bottom, markers.top]\r\n                }\r\n                if (this.resource.viewport.rotation > 45) {\r\n                    for (let i=this.resource.viewport.rotation; i>45; i=i-90) {\r\n                        // Rotate markers 90 degrees at a time\r\n                        [markers.top, markers.right, markers.bottom, markers.left]\r\n                            = [markers.left, markers.top, markers.right, markers.bottom]\r\n                    }\r\n                } else if (this.resource.viewport.rotation < -45) {\r\n                    for (let i=this.resource.viewport.rotation; i<-45; i=i+90) {\r\n                        [markers.top, markers.right, markers.bottom, markers.left]\r\n                        = [markers.right, markers.bottom, markers.left, markers.top]\r\n                    }\r\n                }\r\n            }\r\n            this.orientationMarkers = {...markers}\r\n            // Update marker positions\r\n            const leftOffset = `${this.dicomEl.offsetWidth/2 - 20}px`\r\n            const topOffset = `${this.dicomEl.offsetHeight/2 - 20}px`\r\n            ;(this.$refs['orientation-marker-top'] as HTMLElement).style.left = leftOffset\r\n            ;(this.$refs['orientation-marker-bottom'] as HTMLElement).style.left = leftOffset\r\n            ;(this.$refs['orientation-marker-left'] as HTMLElement).style.top = topOffset\r\n            ;(this.$refs['orientation-marker-right'] as HTMLElement).style.top = topOffset\r\n        },\r\n    },\r\n    mounted () {\r\n        this.dicomWrapper = this.$refs[`wrapper`] as HTMLDivElement\r\n        this.dicomEl = this.$refs[`container`] as HTMLDivElement\r\n        this.topoEl = this.$refs[`topogram`] as HTMLDivElement\r\n        if (!this.dicomEl) {\r\n            // This obviously should not happen, but let's humor Typescript\r\n            return\r\n        }\r\n        // Trigger first component resize to show the borders and loading text\r\n        this.resizeImage()\r\n        // Add event listener\r\n        this.dicomEl.addEventListener('cornerstonetoolsmouseclick', (e: any) => {\r\n            if (e.detail.event.button === 2) {\r\n                // Right mouse click\r\n                this.handleRightClick(e.detail)\r\n            } else if (!e.detail.event.button && this.annotationMenu) {\r\n                // Hide annotation menu on left mouse click.\r\n                // This doesn't seem to stop an active tool from triggering a click event, unfortunately.\r\n                // One solution would be to insert an overlay on top of the image element to catch\r\n                // clicks when the annotation menu is open. Something to consider in the future...\r\n                e.detail.event.preventDefault()\r\n                e.detail.event.stopPropagation()\r\n                this.annotationMenu = null\r\n            }\r\n        }, true)\r\n        this.dicomEl.addEventListener('cornerstonetoolsmousedoubleclick', (e: any) => {\r\n            // For mobile compatibility, handle double click as right mouse click\r\n            this.handleRightClick(e.detail)\r\n        })\r\n        // Start loading dot cycle every half second until the image is done loading\r\n        let cyclePos = 1\r\n        this.loadingDotCycle = window.setInterval(() => {\r\n            for (let i=0; i<3; i++) {\r\n                (this.$refs[`loading-dot-${i+1}`] as HTMLElement).style.visibility\r\n                    = i < cyclePos ? 'visible' : 'hidden'\r\n            }\r\n            cyclePos = cyclePos < 3 ? cyclePos + 1 : 0\r\n        }, 500)\r\n        const showLoadingError = (reason: any) => {\r\n            window.clearInterval(this.loadingDotCycle)\r\n            //;(document.querySelector(\r\n            //        `#container-${this.id}-${this.instanceNum} > .medimg-viewer-image-loading`\r\n            //    ) as HTMLDivElement).innerText = this.$t('ERROR').toString()\r\n            console.error(reason)\r\n            this.$emit('done-loading')\r\n        }\r\n        // Enable the element\r\n        try {\r\n            cornerstone.enable(this.dicomEl)\r\n        } catch (e) {\r\n            // This is a very stange error.\r\n            // It turns up rarely and I have only ever seen it in the preset layout view, making me think\r\n            // it is some weird race-condition bug. It may have to do with cornerstone not being able to\r\n            // remove some event listener when a tool is in use, but until I'm sure this has been eliminated\r\n            // I will keep this here.\r\n            this.$emit('enable-element-error')\r\n            this.$emit('done-loading')\r\n            return\r\n        }\r\n        // Save viewport\r\n        // Conerstone tool options\r\n        const zoomOpts = {\r\n            name: `Zoom-${this.$store.state.appName}`,\r\n            configuration: {\r\n                invert: true,\r\n                preventZoomOutsideImage: false,\r\n                minScale: .1,\r\n                maxScale: 20.0,\r\n            }\r\n        }\r\n        // Set up basic tools\r\n        cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.EllipticalRoiTool,\r\n            { name: `EllipticalRoi-${this.$store.state.appName}` },\r\n        )\r\n        cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.LengthTool,\r\n            { name: `Length-${this.$store.state.appName}` },\r\n        )\r\n        cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.PanTool,\r\n            { name: `Pan-${this.$store.state.appName}` },\r\n        )\r\n        cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.WwwcTool,\r\n            { name: `Wwwc-${this.$store.state.appName}` },\r\n        )\r\n        cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.ZoomTool, zoomOpts)\r\n        // Restore possible cached tool states.\r\n        // We need to set annotation tools active for the duration of image rendering, or the\r\n        // annotation will not be displayd.\r\n        cornerstoneTools.setToolActive(`EllipticalRoi-${this.$store.state.appName}`, { })\r\n        cornerstoneTools.setToolActive(`Length-${this.$store.state.appName}`, { })\r\n        const toolStates = cornerstoneTools.globalImageIdSpecificToolStateManager.saveToolState()\r\n        // Sort the images if the resource is an image stack\r\n        if (this.resource.isStack) {\r\n            // Add stack state manager to loaded images\r\n            this.resource.preloadAndSortImages().then((response: { success: boolean, reason?: any }) => {\r\n                // Check that dicomEl still exists, in case the container has been destroyed during the load\r\n                if (response.success && !this.destroyed) {\r\n                    // Fetch possible cached tool states\r\n                    for (const img of this.resource.images) {\r\n                        if (img.toolState) {\r\n                            // Move tool state to cornerstone tool state manager and reset cache\r\n                            toolStates[img.url] = {...img.toolState}\r\n                            img.toolState = null\r\n                        }\r\n                    }\r\n                    // Stop loading dot cycler\r\n                    window.clearInterval(this.loadingDotCycle)\r\n                    this.mainImageLoaded = true\r\n                    // Set up cornerstone stack scroll tool\r\n                    const imageIds = this.resource.images.map((img: DicomImage) => img.url)\r\n                    const stackOpts = {\r\n                        currentImageIdIndex: this.resource.currentPosition,\r\n                        imageIds\r\n                    }\r\n                    cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.CrosshairsTool,\r\n                        { name: `Crosshairs-${this.$store.state.appName}` },\r\n                    )\r\n                    this.synchronizers.crosshairs.add(this.dicomEl)\r\n                    cornerstoneTools.addStackStateManager(this.dicomEl, ['stack', 'Crosshairs'])\r\n                    cornerstoneTools.addToolState(this.dicomEl, 'stack', stackOpts)\r\n                    cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.StackScrollTool,\r\n                        { name: `StackScroll-${this.$store.state.appName}` }\r\n                    )\r\n                    cornerstoneTools.addToolForElement(this.dicomEl, cornerstoneTools.StackScrollMouseWheelTool,\r\n                        { name: `StackScrollMouseWheel-${this.$store.state.appName}` }\r\n                    )\r\n                    // Register element to synchronizers\r\n                    this.synchronizers.stackScroll.add(this.dicomEl)\r\n                    this.resource.currentPosition = this.resource.currentPosition\r\n                    const displayMainImage = () => {\r\n                        // Shorthand for these operations, as they are needed in a few (async) paths.\r\n                        // Don't trigger resize if the container has been destroyed\r\n                        if (!this.destroyed) {\r\n                            this.resizeImage(true)\r\n                        }\r\n                        this.displayImage().then(() => {\r\n                            this.$emit('done-loading')\r\n                            this.$nextTick(() => {\r\n                                // Set annotation tools passive before re-enabling the active tools.\r\n                                cornerstoneTools.setToolPassive(`EllipticalRoi-${this.$store.state.appName}`)\r\n                                cornerstoneTools.setToolPassive(`Length-${this.$store.state.appName}`)\r\n                                this.$store.dispatch('tools:re-enable-active')\r\n                            })\r\n                        })\r\n                    }\r\n                    // Display possible topogram\r\n                    if (this.resource.topogram !== null) {\r\n                        try {\r\n                            cornerstone.enable(this.topoEl)\r\n                        } catch (e) {\r\n                            this.$emit('enable-element-error')\r\n                            return\r\n                        }\r\n                        cornerstone.loadImage(this.resource.topogram.url).then((image: any) => {\r\n                            this.topoImageLoaded = true\r\n                            const vp = cornerstone.getDefaultViewportForImage(this.topoEl, image)\r\n                            // Set displayed area on the topogram\r\n                            const topoBounds = this.resource.topogramPaddedBounds\r\n                            vp.displayedArea.tlhc.x = topoBounds.x[0]\r\n                            vp.displayedArea.tlhc.y = topoBounds.y[0]\r\n                            vp.displayedArea.brhc.x = topoBounds.x[1]\r\n                            vp.displayedArea.brhc.y = topoBounds.y[1]\r\n                            vp.displayedArea.columnPixelSpacing = 1\r\n                            vp.displayedArea.rowPixelSpacing = 1\r\n                            vp.displayedArea.presentationSizeMode = 'SCALE TO FIT'\r\n                            cornerstone.setViewport(this.topoEl, vp)\r\n                            // Display the topogram and set up synchronizer\r\n                            cornerstone.displayImage(this.topoEl, image, vp)\r\n                            this.topogramSynchronizer = new cornerstoneTools.Synchronizer(\r\n                                'cornerstonenewimage',\r\n                                (synchronizer: any, source: any, target: any, event: any) => {\r\n                                    cornerstone.updateImage(this.topoEl, false)\r\n                                }\r\n                            )\r\n                            this.topogramSynchronizer.add(this.dicomEl)\r\n                            cornerstoneTools.addToolForElement(this.topoEl, TopogramReferenceLineTool,\r\n                                // Unique name to prevent tools from different topograms from conflicting with each other\r\n                                { name: `TopogramReferenceLines-${this.instanceNum}` }\r\n                            )\r\n                            cornerstoneTools.setToolEnabled(`TopogramReferenceLines-${this.instanceNum}`, {\r\n                                synchronizationContext: this.topogramSynchronizer,\r\n                                // Pass a custom method to the reference line tool to get cropped and scaled line dimensions\r\n                                getReferenceLine: () => {\r\n                                    const refLine = this.resource.getRefLineForImage()\r\n                                    const topoDims = this.getTopogramDimensions()\r\n                                    if (!refLine || !topoDims) {\r\n                                        return undefined\r\n                                    }\r\n                                    if (topoDims.scale < 1) {\r\n                                        refLine.start = {\r\n                                            x: refLine.start.x/topoDims.scale,\r\n                                            y: refLine.start.y/topoDims.scale\r\n                                        },\r\n                                        refLine.end = {\r\n                                            x: refLine.end.x/topoDims.scale,\r\n                                            y: refLine.end.y/topoDims.scale\r\n                                        }\r\n                                    }\r\n                                    return refLine\r\n                                },\r\n                            })\r\n                            displayMainImage()\r\n                        }).catch((reason: any) => {\r\n                            console.error('Loading topogram failed!', reason)\r\n                            displayMainImage()\r\n                        })\r\n                    } else {\r\n                        displayMainImage()\r\n                    }\r\n                    this.$store.commit('set-cache-status', cornerstone.imageCache.getCacheInfo())\r\n                    this.isFirstLoaded = true\r\n                    // Save new position\r\n                    this.dicomEl.addEventListener('cornerstonenewimage', (e: any) => {\r\n                        this.resource.setCurrentPositionByUrl(e.detail.image.imageId)\r\n                    })\r\n                } else if (!this.destroyed) {\r\n                    // TODO: Return the reason somehow?\r\n                    showLoadingError(response.reason)\r\n                }\r\n            }).catch((reason: any) => {\r\n                showLoadingError(reason)\r\n            })\r\n        } else {\r\n            // Restore possible image tool state and reset cache value\r\n            if (this.resource.toolState) {\r\n                toolStates[this.resource.url] = {...this.resource.toolState}\r\n                this.resource.toolState = null\r\n            }\r\n            // Display first image with default settings\r\n            this.displayImage().then(image => {\r\n                window.clearInterval(this.loadingDotCycle)\r\n                this.resource.readMetadataFromImage(image)\r\n                this.mainImageLoaded = true\r\n                // Set annotation tools passive and re-enable the active tool to include this image\r\n                cornerstoneTools.setToolPassive(`EllipticalRoi-${this.$store.state.appName}`)\r\n                cornerstoneTools.setToolPassive(`Length-${this.$store.state.appName}`)\r\n                this.$store.dispatch('tools:re-enable-active')\r\n                this.isFirstLoaded = true\r\n                this.resizeImage()\r\n            }).catch((reason: any) => {\r\n                showLoadingError(reason)\r\n            })\r\n        }\r\n        cornerstoneTools.globalImageIdSpecificToolStateManager.restoreToolState(toolStates)\r\n        // Subscribe to store dispatch events\r\n        this.unsubscribeActions = this.$store.subscribeAction((action) => {\r\n            switch (action.type) {\r\n                case 'image:flip-horizontally':\r\n                    this.flipHorizontally()\r\n                    break\r\n                case 'image:flip-vertically':\r\n                    this.flipVertically()\r\n                    break\r\n                case 'image:invert-colors':\r\n                    this.invertImage()\r\n                    break\r\n                case 'image:link-stacks':\r\n                    this.linkImageStack(action.payload)\r\n                    break\r\n                case 'image:restore-default-settings':\r\n                    this.resetViewport()\r\n                    break\r\n                case 'image:rotate-by':\r\n                    this.rotateBy(action.payload)\r\n                    break\r\n            }\r\n        })\r\n        // Subscribe to store commit events\r\n        this.unsubscribeMutations = this.$store.subscribe((mutation) => {\r\n            switch (mutation.type) {\r\n                case 'set-linked-scroll-position':\r\n                    this.scrollLinkedStack(mutation.payload.origin, mutation.payload.position)\r\n                    break\r\n            }\r\n        })\r\n    },\r\n    beforeDestroy () {\r\n        this.destroyed = true\r\n        // Clear loading indicator interval if it is running\r\n        if (this.loadingDotCycle) {\r\n            window.clearInterval(this.loadingDotCycle)\r\n        }\r\n        if (this.resource.isStack && this.resource.isLinked) {\r\n            // Break linking\r\n            this.resource.unlink()\r\n        }\r\n        // Save possible tool state\r\n        const toolStates = cornerstoneTools.globalImageIdSpecificToolStateManager.saveToolState()\r\n        if (this.resource.isStack) {\r\n            // Get tool state for currently displayed image\r\n            for (const img of this.resource.images) {\r\n                if (toolStates[img.url]) {\r\n                    img.toolState = toolStates[img.url]\r\n                }\r\n            }\r\n        } else if (toolStates[this.resource.url]) {\r\n            this.resource.toolState = toolStates[this.resource.url]\r\n        }\r\n        // Remove tools\r\n        if (this.mainImageLoaded) {\r\n            try {\r\n                // If the component is destroyed before all of the setup is done, some of these may throw errors\r\n                cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.EllipticalRoiTool)\r\n                cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.LengthTool)\r\n                cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.PanTool)\r\n                cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.WwwcTool)\r\n                cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.ZoomTool)\r\n                if (this.resource.isStack) {\r\n                    // Remove stack-specific tools\r\n                    cornerstoneTools.clearToolState(this.dicomEl, 'stack')\r\n                    cornerstoneTools.clearToolState(this.dicomEl, 'Crosshairs')\r\n                    cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.CrosshairsTool)\r\n                    cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.StackScrollTool)\r\n                    cornerstoneTools.removeToolForElement(this.dicomEl, cornerstoneTools.StackScrollMouseWheelTool)\r\n                    // Unregister synchronizers\r\n                    this.synchronizers.stackScroll.remove(this.dicomEl)\r\n                }\r\n            } catch (e) {}\r\n        }\r\n        // Disable the element\r\n        try {\r\n            // This can error if the enable-element errored...\r\n            cornerstone.disable(this.dicomEl)\r\n        } catch (e) {\r\n        }\r\n        if (this.resource.topogram && this.topoImageLoaded) {\r\n            try {\r\n                // Same for topogram\r\n                cornerstoneTools.setToolDisabled(`TopogramReferenceLines-${this.instanceNum}`)\r\n                cornerstoneTools.removeToolForElement(this.topoEl, TopogramReferenceLineTool)\r\n                cornerstone.disable(this.topoEl)\r\n            } catch (e) {}\r\n        }\r\n        // Unsubscribe from store\r\n        if (this.unsubscribeActions !== null) {\r\n            this.unsubscribeActions()\r\n        }\r\n        if (this.unsubscribeMutations !== null) {\r\n            this.unsubscribeMutations()\r\n        }\r\n    },\r\n})\r\n\r\n<\/script>\r\n\r\n<style scoped>\r\n.medimg-viewer-image-wrapper {\r\n    position: relative;\r\n    float: left;\r\n    padding: 10px;\r\n}\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-annotation-menu {\r\n        position: absolute;\r\n        display: inline-block;\r\n        border: 2px solid var(--medimg-viewer-border);\r\n        background-color: var(--medimg-viewer-background);\r\n        cursor: pointer;\r\n        z-index: 2;\r\n    }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-annotation-menu > div {\r\n            line-height: 30px;\r\n            padding: 0 10px;\r\n        }\r\n        .medimg-viewer-image-wrapper .medimg-viewer-annotation-action {\r\n            color: var(--medimg-viewer-text-highlight);\r\n        }\r\n        .medimg-viewer-image-wrapper .medimg-viewer-annotation-action:hover {\r\n            background-color: var(--medimg-viewer-background-emphasize);\r\n        }\r\n        .medimg-viewer-image-wrapper .medimg-viewer-annotation-compare-row {\r\n            width: 200px;\r\n            opacity: 0.9;\r\n            font-size: 90%;\r\n        }\r\n            .medimg-viewer-image-wrapper .medimg-viewer-annotation-compare-row > span:nth-child(2) {\r\n                float: right;\r\n            }\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker {\r\n        position: absolute;\r\n        display: inline-block;\r\n        width: 40px;\r\n        height: 40px;\r\n        line-height: 40px;\r\n        text-align: center;\r\n        z-index: 1; /* Below delete button toolbar button groups */\r\n        pointer-events: none;\r\n    }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-bottom {\r\n            bottom: 0;\r\n        }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-left {\r\n            left: 0;\r\n        }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-right {\r\n            right: 0;\r\n        }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-orientation-marker-top {\r\n            top: 0;\r\n        }\r\n    .medimg-viewer-image-loading-progress {\r\n        position: absolute;\r\n        top: 0;\r\n        left: 0;\r\n        width: 100%;\r\n        height: 10px;\r\n        border-bottom: solid 1px var(--medimg-viewer-border-faint);\r\n    }\r\n        .medimg-viewer-image-loading-progress > div {\r\n            width: 0px;\r\n            height: 9px;\r\n            background-color: var(--medimg-viewer-background-emphasize);\r\n        }\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-tool-icons {\r\n        position: absolute;\r\n        top: 40px;\r\n        right: 10px;\r\n        font-size: 20px;\r\n        color: var(--medimg-viewer-text-faint);\r\n    }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-tool-icons > svg {\r\n            cursor: pointer;\r\n        }\r\n        .medimg-viewer-image-wrapper > .medimg-viewer-link-icon-active {\r\n            color: var(--medimg-viewer-text-main);\r\n        }\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-meta-topleft {\r\n        position: absolute;\r\n        left: 10px;\r\n        top: 10px;\r\n        display: flex;\r\n        flex-direction: column;\r\n        line-height: 20px;\r\n        pointer-events: none;\r\n    }\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-meta-topright {\r\n        position: absolute;\r\n        right: 10px;\r\n        top: 10px;\r\n        display: flex;\r\n        flex-direction: column;\r\n        line-height: 20px;\r\n        text-align: right;\r\n        pointer-events: none;\r\n    }\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-meta-bottomleft {\r\n        position: absolute;\r\n        left: 10px;\r\n        bottom: 10px;\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        line-height: 20px;\r\n        pointer-events: none;\r\n    }\r\n    .medimg-viewer-image-wrapper > .medimg-viewer-meta-bottomright {\r\n        position: absolute;\r\n        right: 10px;\r\n        bottom: 10px;\r\n        display: flex;\r\n        flex-direction: column-reverse;\r\n        text-align: right;\r\n        height: calc(100% - 10px);\r\n        line-height: 20px;\r\n        pointer-events: none;\r\n    }\r\n    .medimg-viewer-meta-bottomright > .medimg-viewer-topogram {\r\n        position: relative;\r\n        right: -11px; /* cover the default image border */\r\n        bottom: -11px;\r\n        height: 20%;\r\n        pointer-events: none;\r\n        border: solid 1px var(--medimg-viewer-border-faint);\r\n        background-color: var(--medimg-viewer-background);\r\n        transform-origin: bottom right;\r\n    }\r\n        .medimg-viewer-image-container > div {\r\n            font-size: 24px;\r\n            font-family: sans-serif;\r\n            font-weight: bold;\r\n            font-style: italic;\r\n            color: var(--medimg-viewer-text-faint);\r\n            text-align: center;\r\n        }\r\n        .medimg-viewer-image-disabled {\r\n            pointer-events: none;\r\n        }\r\n</style>\r\n"],sourceRoot:""}]),e.exports=o},1067:(e,r,t)=>{"use strict";t.d(r,{Z:()=>g});var n=t(5798),o=t.n(n),i=t(1653),s=t(2790),a=t.n(s),l=t(7368),c=t.n(l),m=t(8588);const d=a().importInternal("util/convertToVector3");let h=0;const g=o().extend({components:{},props:{containerSize:Array,layoutPosition:Array,linkedStackPos:Number,resource:Object,topogram:Object,synchronizers:{type:Object,default:null}},data:()=>({dicomWrapper:null,dicomEl:null,topoEl:null,isFirstLoaded:!1,isLinked:!1,annotationMenu:null,orientationMarkers:{top:"",right:"",bottom:"",left:""},mainImageLoaded:!1,topoImageLoaded:!1,topoImageBounds:{x:[0,0],y:[0,0]},topogramSynchronizer:null,loadingDotCycle:0,viewportProps:null,destroyed:!1,unsubscribeActions:null,unsubscribeMutations:null,instanceNum:h++}),watch:{containerSize(e,r){this.resizeImage()},layoutPosition(e,r){this.resizeImage(),this.resizeImage(!0)},resource:{deep:!0,handler(e){!this.mainImageLoaded&&this.$refs["loading-progress-bar"]&&(this.$refs["loading-progress-bar"].style.width=100*e.preloaded/e.images.length+"%")}}},computed:{id(){return this.resource.id},isSelectedAnnotation(){if(!this.annotationMenu)return!1;this.resource.referenceAnnotations;return!(!this.resource.referenceAnnotations[this.annotationMenu.type].length||-1===this.resource.referenceAnnotations[this.annotationMenu.type].indexOf(this.annotationMenu.data))}},methods:{t:function(e,r){return r?this.$t(`components.Radiology.Dicom.DicomImageDisplay.${e}`,r):this.$t("components.Radiology.Dicom.DicomImageDisplay")[e]},adjustLevels:function(e,r){this.resource.viewport.voi.windowWidth+=e/this.resource.viewport.scale,this.resource.viewport.voi.windowCenter+=r/this.resource.viewport.scale,i.setViewport(this.dicomEl,this.resource.viewport)},displayImage:async function(e=!1,r){const t=this.resource.currentImage.url;return await i.loadImage(t).then((r=>{!e&&this.resource.viewport||(this.resource.viewport=i.getDefaultViewportForImage(this.dicomEl,r),this.viewportProps&&(this.resource.viewport=Object.assign(Object.assign({},this.resource.viewport),Object.assign({},this.viewportProps)),this.viewportProps=null),this.resizeImage()),this.resource.viewport&&i.displayImage(this.dicomEl,r,this.resource.viewport)}))},flipHorizontally:function(){this.dicomEl&&this.resource.viewport&&(this.resource.viewport.hflip=!this.resource.viewport.hflip,this.displayImage(),this.updateOrientationMarkers())},flipVertically:function(){this.dicomEl&&this.resource.viewport&&(this.resource.viewport.vflip=!this.resource.viewport.vflip,this.displayImage(),this.updateOrientationMarkers())},getAnnotationAngleBetween:function(e,r){const t=r.handles.end.x-r.handles.start.x,n=r.handles.end.y-r.handles.start.y,o=0!==n||t>0?2*Math.atan(n/(t+Math.sqrt(t**2+n**2)))*180/Math.PI:0===t?0:180,i=e.handles.end.x-e.handles.start.x,s=e.handles.end.y-e.handles.start.y,a=(o-(0!==s||i>0?2*Math.atan(s/(i+Math.sqrt(i**2+s**2)))*180/Math.PI:0===i?0:180)+360)%360,l=[a%180,180-a%180];return Math.min(...l).toFixed(1)+"° / "+Math.max(...l).toFixed(1)+"°"},getAnnotationLengthDiff:function(e,r){if(r.unit!==e.unit)return"???";const t=Math.abs(r.length-e.length),n=e.length>r.length?"-":"+";return`${n}${t.toFixed(1)}${r.unit} (${n}${(t/e.length*100).toFixed(1)}%)`},getAnnotationMenuStyles(){if(this.annotationMenu){const e=i.pageToPixel(this.dicomEl,0,0),r=this.dicomEl.getBoundingClientRect().left,t=this.dicomEl.getBoundingClientRect().top;return`top: ${(this.annotationMenu.anchor.y-e.y)*this.resource.viewport.scale-t+20}px; left: ${(this.annotationMenu.anchor.x-e.x)*this.resource.viewport.scale-r+20}px`}return"display: none"},getNextFreeReferenceNum(){if(!this.annotationMenu)return 0;this.resource.referenceAnnotations;return this.resource.referenceAnnotations[this.annotationMenu.type].length+1},getReferenceAnnotations(){if(!this.annotationMenu)return[];this.resource.referenceAnnotations;const e=[];for(const r of this.resource.referenceAnnotations[this.annotationMenu.type])r!==this.annotationMenu.data?e.push(r):e.push(null);return e},getReferenceNumber(){if(!this.annotationMenu)return 0;this.resource.referenceAnnotations;return this.resource.referenceAnnotations[this.annotationMenu.type].indexOf(this.annotationMenu.data)+1},getTopogramDimensions:function(){if(!this.resource.topogram||!this.topoImageLoaded)return;const e=this.containerSize,r=this.layoutPosition[0],t=this.layoutPosition[1];let n=0===r[0]?20:21,o=t[0]===t[1]-1?20:21;const i=this.resource.topogramPaddedBounds,s=i.x[1]-i.x[0],a=i.y[1]-i.y[0],l=.25*(e[0]/r[1]-n),c=.25*(e[1]/t[1]-o),m=Math.min(1,l/s,c/a);return{width:m*s,height:m*a,scale:m}},handleRightClick:function(e){e.event.preventDefault();const r=a().globalImageIdSpecificToolStateManager.saveToolState(),t=r[this.resource.currentImage.url],n=Object.assign({},e.lastPoints.image);if(t){const e={len:`Length-${this.$store.state.appName}`,roiE:`EllipticalRoi-${this.$store.state.appName}`},o=(n,o)=>{const s=t[e[n]].data[o],l=this.resource.referenceAnnotations[n].indexOf(s);-1!==l&&this.resource.referenceAnnotations[n].splice(l,1),t[e[n]].data.splice(o,1),a().globalImageIdSpecificToolStateManager.restoreToolState(r),i.updateImage(this.dicomEl,!1),this.annotationMenu=null},s=(e,r)=>{if("roi"===e){const e=t[`EllipticalRoi-${this.$store.state.appName}`].data[r];-1===this.resource.referenceAnnotations.roiE.indexOf(e)&&this.resource.referenceAnnotations.roiE.push(e)}else if("len"===e){const e=t[`Length-${this.$store.state.appName}`].data[r];-1===this.resource.referenceAnnotations.len.indexOf(e)&&this.resource.referenceAnnotations.len.push(e)}};for(const[r,i]of Object.entries(e))if(t[i])for(let e=0;e<t[i].data.length;e++){const a=t[i].data[e],l=7.5/this.resource.viewport.scale;if(c().point.distance(a.handles.start,n)<=l||c().point.distance(a.handles.end,n)<=l)return void(this.annotationMenu={anchor:c().point.distance(a.handles.start,n)<=l?a.handles.start:a.handles.end,data:a,remove:()=>{o(r,e)},select:()=>{s(r,e)},type:r,unselect:()=>{const e=this.resource.referenceAnnotations[r].indexOf(a);-1!==e&&this.resource.referenceAnnotations[r].splice(e,1)}})}}this.hideAnnotationMenu()},hideAnnotationMenu:function(){this.annotationMenu=null},invertImage:function(){this.resource.viewport.invert=!this.resource.viewport.invert,this.displayImage()},linkImageStack:function(e){this.resource.isStack&&(void 0===e&&(e=!this.resource.isLinked),this.resource.isLinked!==e&&(e?this.resource.link(this.$store.state.linkedScrollPosition):this.resource.unlink()))},mouseLeftImageArea:function(){this.hideAnnotationMenu(),this.$store.dispatch("tools:re-enable-active")},panImage:function(e,r){this.resource.viewport.translation.x-=e/this.resource.viewport.scale,this.resource.viewport.translation.y-=r/this.resource.viewport.scale,i.setViewport(this.dicomEl,this.resource.viewport)},resetViewport:function(){this.displayImage(!0),this.updateOrientationMarkers()},resizeImage:function(e=!1){if(!this.dicomEl||!this.dicomWrapper)return;const r=this.containerSize,t=this.layoutPosition[0],n=this.layoutPosition[1],o=0===t[0],s=n[0]===n[1]-1;let a=o?20:21,l=s?20:21;if(this.dicomEl.style.width=r[0]/t[1]-a+"px",this.dicomEl.style.height=r[1]/n[1]-l+"px",this.dicomWrapper.style.borderLeft=o?"none":"1px solid var(--medimg-viewer-border-faint)",this.dicomWrapper.style.borderBottom=s?"none":"1px solid var(--medimg-viewer-border-faint)",this.mainImageLoaded)e&&(this.viewportProps=this.resource.viewport?{hflip:this.resource.viewport.hflip,vflip:this.resource.viewport.vflip,invert:this.resource.viewport.invert,translation:Object.assign({},this.resource.viewport.translation),rotation:this.resource.viewport.rotation,voi:Object.assign({},this.resource.viewport.voi),voiLUT:this.resource.viewport.voiLUT}:null,this.resource.viewport=i.getViewport(this.dicomEl)),i.resize(this.dicomEl,!1);else{const e=document.querySelector(`#container-${this.id}-${this.instanceNum} > .medimg-viewer-image-loading`);e.style.width=r[0]/t[1]-a+"px",e.style.height=r[1]/n[1]-l+"px",e.style.lineHeight=r[1]/n[1]-l+"px"}if(this.resource.topogram&&this.topoImageLoaded){const e=this.getTopogramDimensions();this.topoEl.style.width=`${e.width+2}px`,this.topoEl.style.height=`${e.height+2}px`,i.resize(this.topoEl,!1)}this.updateOrientationMarkers()},rotateBy:function(e){this.dicomEl&&this.resource.viewport&&(this.resource.viewport.rotation+=e,this.displayImage(),this.updateOrientationMarkers())},scrollLinkedStack:async function(e,r){if(!this.resource.isStack||!this.resource.isLinked||e===this.id)return;const t=(this.resource.linkedPosition||0)/this.resource.images.length+r-(this.resource.masterLinkPosition||0);if(t>=0&&t<=1){const e=Math.round(t*this.resource.images.length);if(e!==this.resource.currentPosition){e<0?this.resource.currentPosition=0:e>=this.resource.images.length?this.resource.currentPosition=this.resource.images.length-1:this.resource.currentPosition=e,await this.displayImage();const r=a().getToolState(this.dicomEl,"stack").data[0];r.currentImageIdIndex=this.resource.currentPosition,a().clearToolState(this.dicomEl,"stack"),a().addToolState(this.dicomEl,"stack",r)}}return!0},updateOrientationMarkers:function(){if(!this.mainImageLoaded)return;const e=i.metaData.get("imagePlaneModule",this.resource.isStack?this.resource.currentImage.url:this.resource.url);if(!e||!e.rowCosines||!e.columnCosines)return;const r=d(e.rowCosines),t=new(c().Vector3)(Math.abs(r.x),Math.abs(r.y),Math.abs(r.z)),n=[this.t("orientation_right"),this.t("orientation_left")],o=[this.t("orientation_anterior"),this.t("orientation_posterior")],s=[this.t("orientation_cranial"),this.t("orientation_caudal")];r.x<0&&n.reverse(),r.y<0&&o.reverse(),r.z<0&&s.reverse();const a=d(e.columnCosines),l=new(c().Vector3)(Math.abs(a.x),Math.abs(a.y),Math.abs(a.z)),m=.5,h={bottom:"",left:"",right:"",top:""};for(let e=0;e<3;e++)if(t.x>=m&&t.x>t.y&&t.x>t.z)h.left+=n[0].toString(),h.right+=n[1].toString(),t.x=0;else if(t.y>=m&&t.y>t.x&&t.y>t.z)h.left+=o[0].toString(),h.right+=o[1].toString(),t.y=0;else if(t.z>=m&&t.z>t.x&&t.z>t.y)h.left+=s[0].toString(),h.right+=s[1].toString(),t.z=0;else if(t.x>=m&&t.y>=m&&t.x===t.y)h.left+=n[0].toString()+o[0].toString(),h.right+=n[1].toString()+o[1].toString(),t.x=0,t.y=0;else if(t.x>=m&&t.z>=m&&t.x===t.z)h.left+=n[0].toString()+s[0].toString(),h.right+=n[1].toString()+s[1].toString(),t.x=0,t.z=0;else{if(!(t.y>=m&&t.z>=m&&t.y===t.z))break;h.left+=o[0].toString()+s[0].toString(),h.right+=o[1].toString()+s[1].toString(),t.y=0,t.z=0}for(let e=0;e<3;e++)if(l.x>=m&&l.x>l.y&&l.x>l.z)h.top+=n[0].toString(),h.bottom+=n[1].toString(),l.x=0;else if(l.y>=m&&l.y>l.x&&l.y>l.z)h.top+=o[0].toString(),h.bottom+=o[1].toString(),l.y=0;else if(l.z>=m&&l.z>l.x&&l.z>l.y)h.top+=s[0].toString(),h.bottom+=s[1].toString(),l.z=0;else if(l.x>=m&&l.y>=m&&l.x===l.y)h.top+=n[0].toString()+o[0].toString(),h.bottom+=n[1].toString()+o[1].toString(),l.x=0,l.y=0;else if(l.x>=m&&l.z>=m&&l.x===l.z)h.top+=n[0].toString()+s[0].toString(),h.bottom+=n[1].toString()+s[1].toString(),l.x=0,l.z=0;else{if(!(l.y>=m&&l.z>=m&&l.y===l.z))break;h.top+=o[0].toString()+s[0].toString(),h.bottom+=o[1].toString()+s[1].toString(),l.y=0,l.z=0}if(this.resource.viewport)if(this.resource.viewport.hflip&&([h.left,h.right]=[h.right,h.left]),this.resource.viewport.vflip&&([h.top,h.bottom]=[h.bottom,h.top]),this.resource.viewport.rotation>45)for(let e=this.resource.viewport.rotation;e>45;e-=90)[h.top,h.right,h.bottom,h.left]=[h.left,h.top,h.right,h.bottom];else if(this.resource.viewport.rotation<-45)for(let e=this.resource.viewport.rotation;e<-45;e+=90)[h.top,h.right,h.bottom,h.left]=[h.right,h.bottom,h.left,h.top];this.orientationMarkers=Object.assign({},h);const g=this.dicomEl.offsetWidth/2-20+"px",p=this.dicomEl.offsetHeight/2-20+"px";this.$refs["orientation-marker-top"].style.left=g,this.$refs["orientation-marker-bottom"].style.left=g,this.$refs["orientation-marker-left"].style.top=p,this.$refs["orientation-marker-right"].style.top=p}},mounted(){if(this.dicomWrapper=this.$refs.wrapper,this.dicomEl=this.$refs.container,this.topoEl=this.$refs.topogram,!this.dicomEl)return;this.resizeImage(),this.dicomEl.addEventListener("cornerstonetoolsmouseclick",(e=>{2===e.detail.event.button?this.handleRightClick(e.detail):!e.detail.event.button&&this.annotationMenu&&(e.detail.event.preventDefault(),e.detail.event.stopPropagation(),this.annotationMenu=null)}),!0),this.dicomEl.addEventListener("cornerstonetoolsmousedoubleclick",(e=>{this.handleRightClick(e.detail)}));let e=1;this.loadingDotCycle=window.setInterval((()=>{for(let r=0;r<3;r++)this.$refs[`loading-dot-${r+1}`].style.visibility=r<e?"visible":"hidden";e=e<3?e+1:0}),500);const r=e=>{window.clearInterval(this.loadingDotCycle),console.error(e),this.$emit("done-loading")};try{i.enable(this.dicomEl)}catch(e){return this.$emit("enable-element-error"),void this.$emit("done-loading")}const t={name:`Zoom-${this.$store.state.appName}`,configuration:{invert:!0,preventZoomOutsideImage:!1,minScale:.1,maxScale:20}};a().addToolForElement(this.dicomEl,a().EllipticalRoiTool,{name:`EllipticalRoi-${this.$store.state.appName}`}),a().addToolForElement(this.dicomEl,a().LengthTool,{name:`Length-${this.$store.state.appName}`}),a().addToolForElement(this.dicomEl,a().PanTool,{name:`Pan-${this.$store.state.appName}`}),a().addToolForElement(this.dicomEl,a().WwwcTool,{name:`Wwwc-${this.$store.state.appName}`}),a().addToolForElement(this.dicomEl,a().ZoomTool,t),a().setToolActive(`EllipticalRoi-${this.$store.state.appName}`,{}),a().setToolActive(`Length-${this.$store.state.appName}`,{});const n=a().globalImageIdSpecificToolStateManager.saveToolState();this.resource.isStack?this.resource.preloadAndSortImages().then((e=>{if(e.success&&!this.destroyed){for(const e of this.resource.images)e.toolState&&(n[e.url]=Object.assign({},e.toolState),e.toolState=null);window.clearInterval(this.loadingDotCycle),this.mainImageLoaded=!0;const e=this.resource.images.map((e=>e.url)),r={currentImageIdIndex:this.resource.currentPosition,imageIds:e};a().addToolForElement(this.dicomEl,a().CrosshairsTool,{name:`Crosshairs-${this.$store.state.appName}`}),this.synchronizers.crosshairs.add(this.dicomEl),a().addStackStateManager(this.dicomEl,["stack","Crosshairs"]),a().addToolState(this.dicomEl,"stack",r),a().addToolForElement(this.dicomEl,a().StackScrollTool,{name:`StackScroll-${this.$store.state.appName}`}),a().addToolForElement(this.dicomEl,a().StackScrollMouseWheelTool,{name:`StackScrollMouseWheel-${this.$store.state.appName}`}),this.synchronizers.stackScroll.add(this.dicomEl),this.resource.currentPosition=this.resource.currentPosition;const t=()=>{this.destroyed||this.resizeImage(!0),this.displayImage().then((()=>{this.$emit("done-loading"),this.$nextTick((()=>{a().setToolPassive(`EllipticalRoi-${this.$store.state.appName}`),a().setToolPassive(`Length-${this.$store.state.appName}`),this.$store.dispatch("tools:re-enable-active")}))}))};if(null!==this.resource.topogram){try{i.enable(this.topoEl)}catch(e){return void this.$emit("enable-element-error")}i.loadImage(this.resource.topogram.url).then((e=>{this.topoImageLoaded=!0;const r=i.getDefaultViewportForImage(this.topoEl,e),n=this.resource.topogramPaddedBounds;r.displayedArea.tlhc.x=n.x[0],r.displayedArea.tlhc.y=n.y[0],r.displayedArea.brhc.x=n.x[1],r.displayedArea.brhc.y=n.y[1],r.displayedArea.columnPixelSpacing=1,r.displayedArea.rowPixelSpacing=1,r.displayedArea.presentationSizeMode="SCALE TO FIT",i.setViewport(this.topoEl,r),i.displayImage(this.topoEl,e,r),this.topogramSynchronizer=new(a().Synchronizer)("cornerstonenewimage",((e,r,t,n)=>{i.updateImage(this.topoEl,!1)})),this.topogramSynchronizer.add(this.dicomEl),a().addToolForElement(this.topoEl,m.Z,{name:`TopogramReferenceLines-${this.instanceNum}`}),a().setToolEnabled(`TopogramReferenceLines-${this.instanceNum}`,{synchronizationContext:this.topogramSynchronizer,getReferenceLine:()=>{const e=this.resource.getRefLineForImage(),r=this.getTopogramDimensions();if(e&&r)return r.scale<1&&(e.start={x:e.start.x/r.scale,y:e.start.y/r.scale},e.end={x:e.end.x/r.scale,y:e.end.y/r.scale}),e}}),t()})).catch((e=>{console.error("Loading topogram failed!",e),t()}))}else t();this.$store.commit("set-cache-status",i.imageCache.getCacheInfo()),this.isFirstLoaded=!0,this.dicomEl.addEventListener("cornerstonenewimage",(e=>{this.resource.setCurrentPositionByUrl(e.detail.image.imageId)}))}else this.destroyed||r(e.reason)})).catch((e=>{r(e)})):(this.resource.toolState&&(n[this.resource.url]=Object.assign({},this.resource.toolState),this.resource.toolState=null),this.displayImage().then((e=>{window.clearInterval(this.loadingDotCycle),this.resource.readMetadataFromImage(e),this.mainImageLoaded=!0,a().setToolPassive(`EllipticalRoi-${this.$store.state.appName}`),a().setToolPassive(`Length-${this.$store.state.appName}`),this.$store.dispatch("tools:re-enable-active"),this.isFirstLoaded=!0,this.resizeImage()})).catch((e=>{r(e)}))),a().globalImageIdSpecificToolStateManager.restoreToolState(n),this.unsubscribeActions=this.$store.subscribeAction((e=>{switch(e.type){case"image:flip-horizontally":this.flipHorizontally();break;case"image:flip-vertically":this.flipVertically();break;case"image:invert-colors":this.invertImage();break;case"image:link-stacks":this.linkImageStack(e.payload);break;case"image:restore-default-settings":this.resetViewport();break;case"image:rotate-by":this.rotateBy(e.payload)}})),this.unsubscribeMutations=this.$store.subscribe((e=>{if("set-linked-scroll-position"===e.type)this.scrollLinkedStack(e.payload.origin,e.payload.position)}))},beforeDestroy(){this.destroyed=!0,this.loadingDotCycle&&window.clearInterval(this.loadingDotCycle),this.resource.isStack&&this.resource.isLinked&&this.resource.unlink();const e=a().globalImageIdSpecificToolStateManager.saveToolState();if(this.resource.isStack)for(const r of this.resource.images)e[r.url]&&(r.toolState=e[r.url]);else e[this.resource.url]&&(this.resource.toolState=e[this.resource.url]);if(this.mainImageLoaded)try{a().removeToolForElement(this.dicomEl,a().EllipticalRoiTool),a().removeToolForElement(this.dicomEl,a().LengthTool),a().removeToolForElement(this.dicomEl,a().PanTool),a().removeToolForElement(this.dicomEl,a().WwwcTool),a().removeToolForElement(this.dicomEl,a().ZoomTool),this.resource.isStack&&(a().clearToolState(this.dicomEl,"stack"),a().clearToolState(this.dicomEl,"Crosshairs"),a().removeToolForElement(this.dicomEl,a().CrosshairsTool),a().removeToolForElement(this.dicomEl,a().StackScrollTool),a().removeToolForElement(this.dicomEl,a().StackScrollMouseWheelTool),this.synchronizers.stackScroll.remove(this.dicomEl))}catch(e){}try{i.disable(this.dicomEl)}catch(e){}if(this.resource.topogram&&this.topoImageLoaded)try{a().setToolDisabled(`TopogramReferenceLines-${this.instanceNum}`),a().removeToolForElement(this.topoEl,m.Z),i.disable(this.topoEl)}catch(e){}null!==this.unsubscribeActions&&this.unsubscribeActions(),null!==this.unsubscribeMutations&&this.unsubscribeMutations()}})},8588:(e,r,t)=>{"use strict";t.d(r,{Z:()=>h});var n=t(1653),o=t(2790),i=t.n(o);const s=i().importInternal("base/BaseTool"),a=i().importInternal("drawing/draw"),l=i().importInternal("drawing/drawLine"),c=i().importInternal("drawing/getNewContext"),m=i().importInternal("util/waitForEnabledElementImageToLoad"),d=(e,r,t,n)=>{const o=r.image.imageId,s=i().toolColors.getActiveColor();o&&t&&n&&e&&s&&a(e,(e=>{l(e,n,t.start,t.end,{color:s})}))};class h extends s{constructor(e={}){super(e,{name:"TopogramReferenceLines",mixins:["enabledOrDisabledBinaryTool"],configuration:{renderer:d}}),this.renderer=null,this.synchronizationContext=null,this.getReferenceLine=null}async enabledCallback(e,r={}){const t=this.configuration.renderer;await m(e)&&t&&(this.renderer=t,this.synchronizationContext=r.synchronizationContext||null,this.getReferenceLine=r.getReferenceLine||null,this.forceImageUpdate(e))}disabledCallback(e){this.forceImageUpdate(e)}forceImageUpdate(e){n.getEnabledElement(e).image&&n.updateImage(e,!1)}renderToolData(e){if(!this.renderer||!this.getReferenceLine)return;const r=e.detail,t=c(r.canvasContext.canvas);n.setToPixelCoordinateSystem(r.enabledElement,t),this.renderer(t,r,this.getReferenceLine(),r.element)}}},2730:(e,r,t)=>{"use strict";t.r(r),t.d(r,{default:()=>i});var n=t(9419),o=t(9066);t(6375);const i=(0,t(8758).Z)(o.Z,n.s,n.x,!1,null,"85be1442",null).exports},9066:(e,r,t)=>{"use strict";t.d(r,{Z:()=>n});const n=t(1067).Z},9419:(e,r,t)=>{"use strict";t.d(r,{s:()=>n.s,x:()=>n.x});var n=t(5638)},6375:(e,r,t)=>{"use strict";t(9313)},5638:(e,r,t)=>{"use strict";t.d(r,{s:()=>n,x:()=>o});var n=function(){var e=this,r=e._self._c;e._self._setupProxy;return r("div",{ref:"wrapper",staticClass:"medimg-viewer-image-wrapper",on:{mouseleave:e.mouseLeftImageArea}},[r("div",{ref:"annotation-menu",class:["medimg-viewer-annotation-menu",{"medimg-viewer-hidden":!e.annotationMenu}],style:e.getAnnotationMenuStyles(),on:{contextmenu:function(e){e.preventDefault()}}},[!e.isSelectedAnnotation&&e.annotationMenu&&"len"===e.annotationMenu.type?r("div",{staticClass:"medimg-viewer-annotation-action",on:{click:function(r){return e.annotationMenu.select()}}},[e._v("\n            "+e._s(e.t("Select as reference #{n}",{n:e.getNextFreeReferenceNum()}))+"\n        ")]):e.annotationMenu&&"len"===e.annotationMenu.type?r("div",{staticClass:"medimg-viewer-annotation-action",on:{click:function(r){return e.annotationMenu.unselect()}}},[e._v("\n            "+e._s(e.t("Unselect reference #{n}",{n:e.getReferenceNumber()}))+"\n        ")]):e._e(),e._v(" "),e._l(e.getReferenceAnnotations(),(function(t,n){return r("div",{key:`medimg-viewer-compare-annotations-${e.id}-${e.instanceNum}-${n}`},[t?r("div",{staticClass:"medimg-viewer-annotation-compare-title"},[e._v(e._s(e.t("Compared to reference #{n}",{n:n+1})))]):e._e(),e._v(" "),t?r("div",{staticClass:"medimg-viewer-annotation-compare-row"},[r("span",[e._v(e._s(e.t("Length")))]),e._v(" "),r("span",[e._v(e._s(e.getAnnotationLengthDiff(t,e.annotationMenu.data)))])]):e._e(),e._v(" "),t?r("div",{staticClass:"medimg-viewer-annotation-compare-row"},[r("span",[e._v(e._s(e.t("Angle")))]),e._v(" "),r("span",[e._v(e._s(e.getAnnotationAngleBetween(t,e.annotationMenu.data)))])]):e._e()])})),e._v(" "),r("div",{staticClass:"medimg-viewer-annotation-action",on:{click:function(r){return e.annotationMenu.remove()}}},[e._v("\n            "+e._s(e.t("Delete"))+"\n        ")])],2),e._v(" "),r("div",{ref:"orientation-marker-top",class:["medimg-viewer-orientation-marker","medimg-viewer-orientation-marker-top",{"medimg-viewer-hidden":!e.orientationMarkers.top}]},[e._v("\n        "+e._s(e.orientationMarkers.top)+"\n    ")]),e._v(" "),r("div",{ref:"orientation-marker-left",class:["medimg-viewer-orientation-marker","medimg-viewer-orientation-marker-left",{"medimg-viewer-hidden":!e.orientationMarkers.left}]},[e._v("\n        "+e._s(e.orientationMarkers.left)+"\n    ")]),e._v(" "),r("div",{ref:"orientation-marker-bottom",class:["medimg-viewer-orientation-marker","medimg-viewer-orientation-marker-bottom",{"medimg-viewer-hidden":!e.orientationMarkers.bottom}]},[e._v("\n        "+e._s(e.orientationMarkers.bottom)+"\n    ")]),e._v(" "),r("div",{ref:"orientation-marker-right",class:["medimg-viewer-orientation-marker","medimg-viewer-orientation-marker-right",{"medimg-viewer-hidden":!e.orientationMarkers.right}]},[e._v("\n        "+e._s(e.orientationMarkers.right)+"\n    ")]),e._v(" "),r("div",{ref:"container",class:["medimg-viewer-image-container",{"medimg-viewer-image-disabled":e.$store.state.imageResourceLoading}],attrs:{id:`container-${e.id}-${e.instanceNum}`},on:{contextmenu:function(e){e.preventDefault()},mouseup:function(r){return e.resizeImage(!0)}}},[e.mainImageLoaded?e._e():r("div",{staticClass:"medimg-viewer-image-loading"},[e._v("\n            "+e._s(e.t("Loading"))+"\n            "),r("span",{ref:"loading-dot-1",staticStyle:{visibility:"hidden"}},[e._v(".")]),e._v(" "),r("span",{ref:"loading-dot-2",staticStyle:{visibility:"hidden"}},[e._v(".")]),e._v(" "),r("span",{ref:"loading-dot-3",staticStyle:{visibility:"hidden"}},[e._v(".")])])]),e._v(" "),r("span",{staticClass:"medimg-viewer-tool-icons"},[e.resource.isStack&&e.isFirstLoaded?r("font-awesome-icon",{class:{"medimg-viewer-link-icon-active":e.resource.isLinked},attrs:{icon:e.resource.isLinked?["fal","link"]:["fal","unlink"],title:e.t("Link this image stack"),"fixed-width":""},on:{click:function(r){return e.linkImageStack()}}}):e._e(),e._v(" "),e.isFirstLoaded?r("font-awesome-icon",{attrs:{icon:["fal","reply-all"],title:e.t("Reset all adjustments"),"fixed-width":""},on:{click:function(r){return e.displayImage(!0)}}}):e._e()],1),e._v(" "),e.isFirstLoaded?r("div",{staticClass:"medimg-viewer-meta-topleft"},[r("div",[e._v(e._s(e.resource.name))])]):e._e(),e._v(" "),e.isFirstLoaded?r("div",{staticClass:"medimg-viewer-meta-topright"},[r("div",[e._v(e._s(e.resource.dimensions[0])+" x "+e._s(e.resource.dimensions[1]))])]):e._e(),e._v(" "),e.isFirstLoaded?r("div",{staticClass:"medimg-viewer-meta-bottomleft"},[e.resource.currentImage.tubeCurrent&&e.resource.currentImage.exposureTime&&e.resource.currentImage.exposure?r("div",[e._v("\n            Exp: "+e._s(e.resource.currentImage.tubeCurrent)+" mA,\n                 "+e._s(e.resource.currentImage.exposureTime)+" msec,\n                 "+e._s(e.resource.currentImage.exposure)+" mAs\n        ")]):e._e(),e._v(" "),e.resource.isStack?r("div",[e._v("\n            "+e._s(e.t("Slice"))+": "+e._s(e.resource.currentPosition+1)+"/"+e._s(e.resource.images.length)+"\n        ")]):e._e(),e._v(" "),e.resource.isStack&&e.resource.currentImage.sliceLocation?r("div",[e._v("\n            Loc: "+e._s(e.resource.currentImage.sliceLocation)+" mm\n        ")]):e._e(),e._v(" "),e.resource.isStack&&e.resource.currentImage.sliceThickness?r("div",[e._v("\n            Thk: "+e._s(e.resource.currentImage.sliceThickness.toFixed(1))+" mm\n        ")]):e._e(),e._v(" "),e.resource.isStack&&e.resource.currentImage.KVP?r("div",[e._v("\n            KVP: "+e._s(e.resource.currentImage.KVP)+" kV\n        ")]):e._e()]):e._e(),e._v(" "),r("div",{staticClass:"medimg-viewer-meta-bottomright"},[e.resource.topogram?r("div",{ref:"topogram",class:["medimg-viewer-topogram",{"medimg-viewer-hidden":!e.topoImageLoaded}],attrs:{id:`topogram-${e.id}-${e.instanceNum}`},on:{contextmenu:function(e){e.preventDefault()}}}):e._e(),e._v(" "),!e.isFirstLoaded||!e.resource.imageOrientation||isNaN(e.resource.imageOrientation[0])&&isNaN(e.resource.imageOrientation[1])?e._e():r("div",[e._v("\n            Orient: "+e._s(isNaN(e.resource.imageOrientation[0])?"-- ":e.resource.imageOrientation[0])+"°\n                    / "+e._s(isNaN(e.resource.imageOrientation[1])?"-- ":e.resource.imageOrientation[1])+"°\n        ")])]),e._v(" "),r("div",{class:["medimg-viewer-image-loading-progress",{"medimg-viewer-hidden":e.mainImageLoaded||!e.resource.isStack}]},[r("div",{ref:"loading-progress-bar"})])])},o=[];n._withStripped=!0},9313:(e,r,t)=>{var n=t(6882);n.__esModule&&(n=n.default),"string"==typeof n&&(n=[[e.id,n,""]]),n.locals&&(e.exports=n.locals);(0,t(7913).Z)("6127741d",n,!1,{})}}]);
//# sourceMappingURL=730-amd.js.map?v=7d9153f8e9c0d3011cc5