(self.webpackChunkmedimg_viewer=self.webpackChunkmedimg_viewer||[]).push([[818],{6363:(t,n,o)=>{var e=o(4015),r=o(3645)(e);r.push([t.id,"\n.medimg-viewer-toolbar > div[data-v-21da0db5] {\r\n    position: relative;\r\n    display: flex;\r\n    padding: 10px 0;\n}\n.medimg-viewer-toolbar-buttongroup[data-v-21da0db5] {\r\n    position: absolute;\r\n    top: 80px;\r\n    display: flex;\r\n    background-color: var(--medimg-viewer-background);\r\n    border-left: solid 1px var(--medimg-viewer-border-faint);\r\n    border-right: solid 1px var(--medimg-viewer-border-faint);\r\n    border-bottom: solid 1px var(--medimg-viewer-border-faint);\r\n    padding: 0px 0px 10px 10px;\r\n    z-index: 5;\n}\r\n","",{version:3,sources:["webpack://./src/components/Radiology/RadiologyToolbar.vue"],names:[],mappings:";AAuzBA;IACA,kBAAA;IACA,aAAA;IACA,eAAA;AACA;AACA;IACA,kBAAA;IACA,SAAA;IACA,aAAA;IACA,iDAAA;IACA,wDAAA;IACA,yDAAA;IACA,0DAAA;IACA,0BAAA;IACA,UAAA;AACA",sourcesContent:["<template>\r\n\r\n    <div :id=\"`${$store.state.appName}-medimg-viewer-radiology-toolbar`\">\r\n        <div v-if=\"activeGroup\"\r\n            :class=\"[\r\n                'medimg-viewer-toolbar-buttongroup',\r\n            ]\"\r\n            :style=\"`left:${activeGroupOffset}px`\"\r\n        >\r\n            <toolbar-button v-for=\"(button, idx) in activeGroupButtons\" :key=\"`toolbar-button-${activeGroup}-${idx}`\"\r\n                :id=\"button.id\"\r\n                :emit=\"button.emit\"\r\n                :enabled=\"button.enabled\"\r\n                :icon=\"button.icon\"\r\n                :overlay=\"button.overlay\"\r\n                :tooltip=\"`Radiology.${button.tooltip}`\"\r\n                :class=\"[\r\n                    { 'medimg-viewer-disabled': !button.enabled },\r\n                    { 'element-active': typeof button.active === 'function' ? button.active() : button.active },\r\n                    { 'medimg-viewer-toolbar-setfirst': button.setFirst }\r\n                ]\"\r\n                @button-clicked=\"buttonClicked($event, activeGroup)\"\r\n            />\r\n        </div>\r\n        <toolbar-button v-for=\"(button, idx) in buttonRow\" :key=\"`toolbar-button-${idx}`\"\r\n            :id=\"button.id\"\r\n            :activeGroup=\"activeGroup\"\r\n            :emit=\"button.emit\"\r\n            :enabled=\"button.enabled\"\r\n            :icon=\"button.icon\"\r\n            :overlay=\"button.overlay\"\r\n            :tooltip=\"`Radiology.${button.tooltip}`\"\r\n            :class=\"[\r\n                { 'medimg-viewer-disabled': !button.enabled },\r\n                { 'element-active': typeof button.active === 'function' ? button.active() : button.active },\r\n                { 'medimg-viewer-toolbar-setfirst': button.setFirst }\r\n            ]\"\r\n            @button-clicked=\"buttonClicked\"\r\n        />\r\n    </div>\r\n\r\n</template>\r\n\r\n<script lang=\"ts\">\r\n\r\nimport Vue from 'vue'\r\nimport cornerstoneTools from 'cornerstone-tools'\r\nimport { ToolbarControlElement } from '../../types/viewer'\r\n// We need an interface for buttons to access them dynamically\r\ninterface ButtonState {\r\n    active: boolean\r\n    enabled: boolean\r\n    visible: boolean\r\n}\r\ninterface ButtonRow {\r\n    'group:layout': ButtonState\r\n        'layout:auto': ButtonState\r\n        'layout:custom': ButtonState\r\n    'group:measurement': ButtonState\r\n        //'tool:Angle': ButtonState\r\n        'tool:EllipticalRoi': ButtonState\r\n        'tool:Length': ButtonState\r\n        //'tool:SquareRoi': ButtonState\r\n    'group:orientation': ButtonState\r\n        'action:fliph': ButtonState\r\n        'action:flipv': ButtonState\r\n        'action:left': ButtonState\r\n        'action:right': ButtonState\r\n    'tool:Crosshairs': ButtonState\r\n    'action:invert': ButtonState\r\n    'action:link': ButtonState\r\n    'tool:Pan': ButtonState\r\n    'action:reset': ButtonState\r\n    'tool:StackScroll': ButtonState\r\n    'action:undo': ButtonState\r\n    'tool:Wwwc': ButtonState\r\n    'tool:Zoom': ButtonState\r\n}\r\ninterface ButtonGroups {\r\n    'layout': LayoutGroup\r\n    'measurement': MeasurementGroup\r\n    'orientation': OrientationGroup\r\n}\r\n// Different preset button groups\r\ninterface LayoutGroup {\r\n    'layout:auto': ButtonState\r\n    'layout:custom': ButtonState\r\n    'layout:customcols': NumberInput\r\n    'layout:customrows': NumberInput\r\n}\r\ninterface MeasurementGroup {\r\n    'tool:Angle': ButtonState\r\n    'tool:EllipticalRoi': ButtonState\r\n    'tool:Length': ButtonState\r\n    'tool:SquareRoi': ButtonState\r\n}\r\ninterface OrientationGroup {\r\n    'flip:horizontal': ButtonState\r\n    'flip:vertical': ButtonState\r\n    'rotate:clockwise': ButtonState\r\n    'rotate:counterclockwise': ButtonState\r\n}\r\ninterface NumberInput {\r\n    value: number\r\n}\r\nexport default Vue.extend({\r\n    components: {\r\n        ToolbarButton: () => import('../ToolbarButton.vue'),\r\n    },\r\n    props: {\r\n        allLinked: {\r\n            type: Boolean,\r\n            default: false\r\n        },\r\n        anyActive: {\r\n            type: Boolean,\r\n            default: false,\r\n        },\r\n        anyItem: {\r\n            type: Boolean,\r\n            default: false,\r\n        },\r\n        anyStack: {\r\n            type: Boolean,\r\n            default: false,\r\n        },\r\n        gridLayout: {\r\n            type: Array,\r\n            default: null\r\n        },\r\n        synchronizers: {\r\n            type: Object,\r\n            default: null\r\n        },\r\n    },\r\n    data () {\r\n        return {\r\n            // This array is used to build the button row\r\n            buttons: [] as { id: string, set: number, groups: string[], icon: string[][] | null, tooltip: any[] }[],\r\n            groups: {} as ButtonGroups,\r\n            buttonStates: {} as any,\r\n            imageLink: null as number[] | null,\r\n            // Button group that is currently open\r\n            activeGroup: null as string | null,\r\n            // This is needed to keep the button row up to date\r\n            buttonsUpdated: 0,\r\n            // Current grid layout\r\n            currentLayout: 0,\r\n            // State of the custom layout\r\n            customLayout: [2, 2],\r\n            // Default options for different tool types\r\n            toolOptions: {\r\n                //'tool:Angle': {\r\n                //    active: { mouseButtonMask: 1 },\r\n                //    default: {},\r\n                //},\r\n                'tool:Crosshairs': {\r\n                    active: {\r\n                        mouseButtonMask: 1,\r\n                        synchronizationContext: this.synchronizers.crosshairs\r\n                    },\r\n                    default: {},\r\n                },\r\n                'tool:EllipticalRoi': {\r\n                    active: { mouseButtonMask: 1 },\r\n                    default: {},\r\n                },\r\n                'tool:Length': {\r\n                    active: { mouseButtonMask: 1 },\r\n                    default: {},\r\n                },\r\n                'tool:Pan': {\r\n                    active: { mouseButtonMask: 1 },\r\n                    default: { mouseButtonMask: 1 },\r\n                },\r\n                'tool:StackScroll': {\r\n                    active: {\r\n                        mouseButtonMask: 1,\r\n                        synchronizationContext: this.synchronizers.stackScroll\r\n                    },\r\n                    default: {},\r\n                },\r\n                'tool:Wwwc': {\r\n                    active: { mouseButtonMask: 1 },\r\n                    default: { mouseButtonMask: 2 },\r\n                },\r\n                'tool:Zoom': {\r\n                    active: { mouseButtonMask: 1 },\r\n                    default: { mouseButtonMask: 4 },\r\n                },\r\n            },\r\n            // Unsubscribe from store actions\r\n            unsubscribeActions: null as any,\r\n            unsubscribeMutations: null as any,\r\n        }\r\n    },\r\n    computed: {\r\n        activeGroupButtons (): ToolbarControlElement[] {\r\n            if (!this.activeGroup) {\r\n                return []\r\n            }\r\n            const buttons = [] as ToolbarControlElement[]\r\n            let buttonSet = null as number | null\r\n            ;(this.groups as any)[this.activeGroup].buttons.forEach((button: any) => {\r\n                // Add visible buttons\r\n                if (this.buttonStates[button.id as keyof ButtonRow].visible) {\r\n                    let newSet = false\r\n                    if (buttonSet === null) {\r\n                        buttonSet = button.set\r\n                    } else if (button.set > buttonSet) {\r\n                        newSet = true\r\n                        buttonSet = button.set\r\n                    }\r\n                    buttons.push({\r\n                        id: button.id,\r\n                        active: this.isActive(button.id) || this.buttonStates[button.id as keyof ButtonRow].active,\r\n                        enabled: this.buttonStates[button.id as keyof ButtonRow].enabled,\r\n                        set: buttonSet || 0,\r\n                        setFirst: newSet,\r\n                        label: button.label,\r\n                        options: button.options,\r\n                        icon: this.getButtonIcon(button),\r\n                        overlay: this.getButtonOverlay(button),\r\n                        tooltip: this.getButtonTooltip(button),\r\n                    })\r\n                }\r\n            })\r\n            return buttons\r\n        },\r\n        activeGroupOffset (): number {\r\n            if (!this.activeGroup) {\r\n                return 0\r\n            } else {\r\n                return (this.groups as any)[this.activeGroup].offset\r\n            }\r\n        },\r\n        buttonRow (): ToolbarControlElement[] {\r\n            this.buttonsUpdated // Trigger refresh when this value changes\r\n            const buttons = [] as ToolbarControlElement[]\r\n            let buttonSet = null as number | null\r\n            this.buttons.forEach((button) => {\r\n                // Add visible buttons\r\n                if (this.buttonStates[button.id as keyof ButtonRow].visible) {\r\n                    let newSet = false\r\n                    if (buttonSet === null) {\r\n                        buttonSet = button.set\r\n                    } else if (button.set > buttonSet) {\r\n                        newSet = true\r\n                        buttonSet = button.set\r\n                    }\r\n                    buttons.push({\r\n                        id: button.id,\r\n                        active: this.isActive(button.id) || this.buttonStates[button.id as keyof ButtonRow].active,\r\n                        enabled: this.isEnabled(button.id) && this.buttonStates[button.id as keyof ButtonRow].enabled,\r\n                        set: buttonSet || 0,\r\n                        setFirst: newSet,\r\n                        label: '',\r\n                        options: [],\r\n                        icon: this.getButtonIcon(button),\r\n                        overlay: this.getButtonOverlay(button),\r\n                        tooltip: this.getButtonTooltip(button),\r\n                    })\r\n                }\r\n            })\r\n            return buttons\r\n        },\r\n    },\r\n    methods: {\r\n        /** Shorthand for component-specific translations */\r\n        t: function (str: string, args?: any) {\r\n            if (args) {\r\n                return this.$t(`components.Radiology.RadiologyToolbar.${str}`, args)\r\n            } else {\r\n                return (this.$t('components.Radiology.RadiologyToolbar') as any)[str]\r\n            }\r\n        },\r\n        /**\r\n         * A button was clicked.\r\n         * @param buttonId string ID of the button\r\n         */\r\n        buttonClicked: function (buttonId: string, group?: keyof ButtonGroups) {\r\n            const [type, id] = buttonId.split(':')\r\n            // First check if this is a group button\r\n            if (type === 'group') {\r\n                this.toggleGroup(id)\r\n            // Check if it is one of the special action buttons\r\n            } else if (type === 'action') {\r\n                if (id === 'invert') {\r\n                    this.invertColors()\r\n                } else if (id === 'fliph') {\r\n                    this.flip('x')\r\n                } else if (id === 'flipv') {\r\n                    this.flip('y')\r\n                } else if (id === 'left') {\r\n                    this.rotate(-90)\r\n                } else if (id === 'link') {\r\n                    this.toggleLink()\r\n                } else if (id === 'reset') {\r\n                    this.resetAll()\r\n                } else if (id === 'right') {\r\n                    this.rotate(90)\r\n                } else if (id === 'undo') {\r\n                    this.undoLast()\r\n                }\r\n            } else if (type === 'layout') {\r\n                if (id === 'auto') {\r\n                    this.setLayout(null)\r\n                } else if (id === 'custom') {\r\n                    this.setLayout(this.customLayout)\r\n                }\r\n                // Close the button group\r\n                this.activeGroup = null\r\n            } else if (type === 'tool') {\r\n                // Otherwise, toggle the appropriate tool\r\n                this.toggleTool(id, group)\r\n                // Deactivate other tools that share a group with this one\r\n                const button = this.findButtonById(buttonId, group)\r\n                if (button && button.groups.length) {\r\n                    this.buttons.forEach((btn) => {\r\n                        if (btn.id !== button?.id && btn.groups.length &&\r\n                            btn.groups.filter(a => button?.groups.indexOf(a) !== -1).length\r\n                        ) {\r\n                            this.buttonStates[btn.id as keyof ButtonRow].active = false\r\n                        }\r\n                    })\r\n                    const groups = Object.values(this.groups)\r\n                    groups.forEach((group) => {\r\n                        group.buttons.forEach((groupBtn: any) => {\r\n                            if (groupBtn.id !== button?.id && groupBtn.groups.length &&\r\n                                groupBtn.groups.filter((a: string) => button?.groups.indexOf(a) !== -1).length\r\n                            ) {\r\n                                this.buttonStates[groupBtn.id as keyof ButtonRow].active = false\r\n                            }\r\n                        })\r\n                    })\r\n                }\r\n            }\r\n            this.$nextTick(() => {\r\n                // Refresh button row\r\n                this.buttonsUpdated++\r\n            })\r\n        },\r\n        disableActiveTools: function () {\r\n            if (this.$store.state.activeTool) {\r\n                cornerstoneTools.setToolDisabled(\r\n                    `${this.$store.state.activeTool}-${this.$store.state.appName}`\r\n                )\r\n            } else {\r\n                cornerstoneTools.setToolDisabled(`Pan-${this.$store.state.appName}`)\r\n            }\r\n            cornerstoneTools.setToolDisabled(`Wwwc-${this.$store.state.appName}`)\r\n            cornerstoneTools.setToolDisabled(`Zoom-${this.$store.state.appName}`)\r\n        },\r\n        enableActiveTools: function () {\r\n            if (this.$store.state.imageResourceLoading) {\r\n                return // Don't enable tools until images are done loading\r\n            }\r\n            // This is a workaround to prevent the Zoom tool from becoming the default tool\r\n            this.disableActiveTools()\r\n            if (this.$store.state.activeTool) {\r\n                // The active tool needs to be re-set to active state when a new enabled element is added to cornerstone\r\n                this.enableDefaults(true)\r\n            } else {\r\n                // Enable all defaults\r\n                this.enableDefaults()\r\n            }\r\n            cornerstoneTools.setToolActive(`StackScrollMouseWheel-${this.$store.state.appName}`, { })\r\n        },\r\n        enableDefaults: function (onlySecondary = false) {\r\n            // Make sure all tools are disable to start with\r\n            if (!onlySecondary) {\r\n                // This just doesn't work for some reason, it keeps enabling the Zoom tool\r\n                cornerstoneTools.setToolActive(`Pan-${this.$store.state.appName}`, this.toolOptions['tool:Pan'].default)\r\n                this.buttonStates[`tool:Pan`].active = true\r\n            }\r\n            cornerstoneTools.setToolActive(`Wwwc-${this.$store.state.appName}`, this.toolOptions['tool:Wwwc'].default)\r\n            cornerstoneTools.setToolActive(`Zoom-${this.$store.state.appName}`, this.toolOptions['tool:Zoom'].default)\r\n        },\r\n        findButtonById: function (buttonId: string, group?: keyof ButtonGroups) {\r\n            if (group) {\r\n                return (this.groups[group] as any).buttons.find((btn: any) => { return btn.id === buttonId })\r\n            } else {\r\n                return this.buttons.find((btn) => { return btn.id === buttonId })\r\n            }\r\n        },\r\n        flip: function (axis: 'x' | 'y') {\r\n            if (axis === 'x') {\r\n                this.$store.dispatch('image:flip-horizontally')\r\n            } else if (axis === 'y') {\r\n                this.$store.dispatch('image:flip-vertically')\r\n            }\r\n        },\r\n        /**\r\n         * Get the button icon appropriate for button state.\r\n         * @param button this.buttons array member or button ID string\r\n         * @return [] | undefined\r\n         */\r\n        getButtonIcon: function (button: any, group?: keyof ButtonGroups): string[] {\r\n            if (typeof button === 'string') {\r\n                button = this.findButtonById(button, group)\r\n            }\r\n            if (button) {\r\n                // Check for active button group icon\r\n                if (button.id === 'group:measurement') {\r\n                    // Check which measurement is active (if any)\r\n                    //if (this.buttonStates['tool:Angle'].active) {\r\n                    //    return this.getButtonIcon('tool:Angle', 'measurement')\r\n                    if (this.buttonStates['tool:EllipticalRoi'].active) {\r\n                        return this.getButtonIcon('tool:EllipticalRoi', 'measurement')\r\n                    //} else if (this.buttonStates['tool:SquareRoi'].active) {\r\n                    //    return this.getButtonIcon('tool:SquareRoi', 'measurement')\r\n                    } else {\r\n                        return this.getButtonIcon('tool:Length', 'measurement')\r\n                    }\r\n                } else {\r\n                    return button.icon[\r\n                        button.icon.length === 1 ||\r\n                        !this.isActive(button.id) ? 0 : 1\r\n                    ]\r\n                }\r\n            }\r\n            return []\r\n        },\r\n        /**\r\n         * Get the appropriate overlay for the given button.\r\n         * @param button this.buttons array member or button ID string\r\n         * @return string\r\n         */\r\n        getButtonOverlay: function (button: any, group?: keyof ButtonGroups): string {\r\n            if (typeof button === 'string') {\r\n                button = this.findButtonById(button, group)\r\n            }\r\n            switch (button.id) {\r\n                case 'group:layout':\r\n                    return this.gridLayout ?\r\n                           `${this.gridLayout[0] || '?'}x${this.gridLayout[1] || '?'}` : 'A'\r\n                case 'layout:auto':\r\n                    return 'A'\r\n                case 'layout:custom':\r\n                    return `${this.customLayout[0] || '?'}x${this.customLayout[1] || '?'}`\r\n            }\r\n            return ''\r\n        },\r\n        /**\r\n         * Get the button tooltip appropriate for button state.\r\n         * @param button this.buttons array member or button ID string\r\n         * @return string\r\n         */\r\n        getButtonTooltip: function (button: any, group?: keyof ButtonGroups): string {\r\n            if (typeof button === 'string') {\r\n                button = this.findButtonById(button, group)\r\n            }\r\n            if (typeof button !== undefined) {\r\n                return button.tooltip[\r\n                    button.tooltip.length === 1 ||\r\n                    !this.isActive(button.id) ? 0 : 1\r\n                ]?.toString()\r\n            }\r\n            return ''\r\n        },\r\n        /**\r\n         * Invert image colors.\r\n         */\r\n        invertColors: function () {\r\n            this.$store.dispatch('image:invert-colors')\r\n        },\r\n        /**\r\n         * Check button active state dynamically if needed, else return false.\r\n         */\r\n        isActive (button: string): boolean {\r\n            switch (button) {\r\n                case 'group:measurement':\r\n                    return /*this.buttonStates['tool:Angle'].active ||*/ this.buttonStates['tool:EllipticalRoi'].active\r\n                           || this.buttonStates['tool:Length'].active /*|| this.buttonStates['tool:SquareRoi'].active*/\r\n                case 'action:link':\r\n                    return this.allLinked\r\n                default:\r\n                    return this.buttonStates[button as keyof ButtonRow].active\r\n            }\r\n        },\r\n        /**\r\n         * Check if button should be enabled.\r\n         */\r\n        isEnabled (button: string): boolean {\r\n            if (this.$store.state.imageResourceLoading) {\r\n                return false\r\n            }\r\n            switch (button) {\r\n                case 'group:layout':\r\n                    return this.anyItem\r\n                case 'tool:Crosshairs':\r\n                case 'tool:StackScroll':\r\n                case 'action:link':\r\n                    return this.anyStack\r\n                default:\r\n                    return this.anyActive\r\n            }\r\n        },\r\n        /**\r\n         * Reset all modifications, returning the media to default state.\r\n         */\r\n        resetAll: function () {\r\n            this.$store.dispatch('image:restore-default-settings')\r\n        },\r\n        rotate: function (angle: number) {\r\n            this.$store.dispatch('image:rotate-by', angle)\r\n        },\r\n        /**\r\n         * Disable a set of buttons.\r\n         * @param buttonIds string[] IDs of the buttons to disable. Providing an empty array will enable all buttons.\r\n         */\r\n        setDisabledButtons: function (buttonIds: string[]): void {\r\n            // First set all buttons as enabled\r\n            Object.keys(this.buttonStates).map(key => {\r\n                this.buttonStates[key as keyof ButtonRow].enabled = true\r\n            })\r\n            buttonIds.forEach((button) => {\r\n                let match = this.buttons.find((btn) => { return btn.id === button })\r\n                if (match !== undefined) {\r\n                    this.buttonStates[match.id as keyof ButtonRow].enabled = false\r\n                }\r\n            })\r\n            // Refresh button row\r\n            this.buttonsUpdated++\r\n        },\r\n        /**\r\n         * Hide a set of buttons.\r\n         * @param buttonIds string[] IDs of the buttons to hide. Providing an empty array will show all buttons.\r\n         */\r\n        setHiddenButtons: function (buttonIds: string[]): void {\r\n            // First set all buttons as visible\r\n            Object.keys(this.buttonStates).map(key => {\r\n                this.buttonStates[key as keyof ButtonRow].visible = true\r\n            })\r\n            buttonIds.forEach((button) => {\r\n                let match = this.buttons.find((btn) => { return btn.id === button })\r\n                if (match !== undefined) {\r\n                    this.buttonStates[match.id as keyof ButtonRow].active = false // Can't leave an invisible button active\r\n                    this.buttonStates[match.id as keyof ButtonRow].visible = false\r\n                }\r\n            })\r\n            // Refresh button row\r\n            this.buttonsUpdated++\r\n        },\r\n        setLayout: function (layout: null | number[]) {\r\n            //const layouts = [null, [1, 0], [0, 1]]\r\n            //this.currentLayout = this.currentLayout < layouts.length - 1 ? this.currentLayout + 1 : 0\r\n            this.$emit('update:gridLayout', layout)\r\n        },\r\n        toggleGroup: function (id: string) {\r\n            if (id === this.activeGroup) {\r\n                this.activeGroup = null\r\n            } else {\r\n                this.activeGroup = id\r\n            }\r\n        },\r\n        toggleLink: function () {\r\n            if (this.isActive('action:link')) {\r\n                // Unlink stacks\r\n                this.$emit('link-all-resources', false)\r\n            } else {\r\n                // Link stacks\r\n                this.$emit('link-all-resources', true)\r\n            }\r\n        },\r\n        toggleTool: function (toolName: string, group?: keyof ButtonGroups) {\r\n            const toolId = `tool:${toolName}` as keyof ButtonRow\r\n            if (!this.buttonStates[toolId].active) {\r\n                this.$store.commit('set-active-tool', toolName)\r\n                cornerstoneTools.setToolActive(\r\n                    `${toolName}-${this.$store.state.appName}`,\r\n                    (this.toolOptions as any)[toolId].active\r\n                )\r\n                this.buttonStates[toolId].active = true\r\n            } else {\r\n                cornerstoneTools.setToolPassive(`${toolName}-${this.$store.state.appName}`)\r\n                this.$store.commit('set-active-tool', null)\r\n                this.buttonStates[toolId].active = false\r\n                this.$nextTick(() => {\r\n                    this.enableDefaults()\r\n                })\r\n            }\r\n            // Close possible button group\r\n            if (group) {\r\n                this.activeGroup = null\r\n            }\r\n        },\r\n        undoLast: function () {\r\n\r\n        },\r\n    },\r\n    mounted () {\r\n        // Populate button row buttons: [\r\n        this.buttons = [\r\n            {\r\n                // A unique identifier for the button, in the format of <type>:<name>. Must match a key in the ButtonRow interface.\r\n                id: 'tool:Pan',\r\n                // Button set number (incremental). A small separator is placed on the button row between adjacent sets.\r\n                set: 1,\r\n                // Groups this button belongs to. When a button is activated, all other buttons in the group are disabled.\r\n                // Tools that use the same mouse button must all share the same group as well!\r\n                groups: ['interact'],\r\n                // The first element in the icon array is used when the button is inactive (required), the second when it's active (optional).\r\n                icon: [ ['fal', 'hand-paper'] ],\r\n                // The first element in the tooltip array is used when the button is inactive (required), the second when it's active (optional).\r\n                tooltip: [ 'Pan image' ]\r\n            },\r\n            {\r\n                id: 'tool:Zoom',\r\n                set: 1,\r\n                groups: ['interact'],\r\n                icon: [ ['fal', 'search'] ],\r\n                tooltip: [ 'Zoom' ],\r\n            },\r\n            {\r\n                id: 'tool:StackScroll',\r\n                set: 1,\r\n                groups: ['interact'],\r\n                icon: [ ['fal', 'layer-group'] ],\r\n                tooltip:[ 'Scroll image stack' ]\r\n            },\r\n            {\r\n                id: 'tool:Crosshairs',\r\n                set: 1,\r\n                groups: ['interact'],\r\n                icon: [ ['fal', 'crosshairs'] ],\r\n                tooltip: [ 'Crosshairs' ],\r\n            },\r\n            {\r\n                id: 'group:orientation',\r\n                set: 2,\r\n                groups: ['orientation'],\r\n                icon: [ ['fal', 'arrows'] ],\r\n                tooltip: [ 'Orientation tools' ],\r\n            },\r\n            {\r\n                id: 'group:measurement',\r\n                set: 3,\r\n                groups: ['measurement'],\r\n                icon: null,\r\n                tooltip: [ 'Measurement tools' ],\r\n            },\r\n            {\r\n                id: 'action:invert',\r\n                set: 4,\r\n                groups: [],\r\n                icon: [ ['fad', 'clone'] ],\r\n                tooltip: [ 'Invert image' ],\r\n            },\r\n            {\r\n                id: 'tool:Wwwc',\r\n                set: 4,\r\n                groups: ['interact'],\r\n                icon: [ ['fad', 'adjust'] ],\r\n                tooltip: [ 'Adjust window' ],\r\n            },\r\n            {\r\n                id: 'group:layout',\r\n                set: 5,\r\n                groups: ['layout'],\r\n                icon: [ ['fal', 'border-all'] ],\r\n                tooltip: [ 'Layout tools' ],\r\n            },\r\n            {\r\n                id: 'action:link',\r\n                set: 6,\r\n                groups: [],\r\n                icon: [ ['fal', 'link'], ['fal', 'unlink'] ],\r\n                tooltip: [ 'Link image stacks', 'Unlink image stacks' ],\r\n            },\r\n            {\r\n                id: 'action:reset',\r\n                set: 7,\r\n                groups: ['undo'],\r\n                icon: [ ['fal', 'reply-all'] ],\r\n                tooltip: [ 'Reset all adjustments' ],\r\n            },\r\n        ]\r\n        this.groups = {\r\n            layout: {\r\n                buttons: [\r\n                    {\r\n                        id: 'layout:auto',\r\n                        set: 0,\r\n                        groups: [],\r\n                        icon: [ ['fal', 'border-all'] ],\r\n                        tooltip: [ 'Automatic layout' ],\r\n                    },\r\n                    {\r\n                        id: 'layout:custom',\r\n                        set: 0,\r\n                        groups: [],\r\n                        icon: [ ['fal', 'border-all'] ],\r\n                        tooltip: [ 'Custom layout' ],\r\n                    },\r\n                ],\r\n                // Offset is the distance from the left end of the toolbar row (in pixels).\r\n                offset: 660,\r\n            },\r\n            measurement:  {\r\n                buttons: [\r\n                    {\r\n                        id: 'tool:Length',\r\n                        set: 0,\r\n                        groups: ['interact'],\r\n                        icon: [ ['fal', 'ruler'] ],\r\n                        tooltip: [ 'Measure distance' ],\r\n                    },\r\n                    //{\r\n                    //    id: 'tool:Angle',\r\n                    //    set: 0,\r\n                    //    groups: ['interact'],\r\n                    //    icon: [ ['fal', 'ruler-triangle'] ],\r\n                    //    tooltip: [ this.t('Measure angle') ],\r\n                    //},\r\n                    {\r\n                        id: 'tool:EllipticalRoi',\r\n                        set: 0,\r\n                        groups: ['interact'],\r\n                        icon: [ ['fal', 'draw-circle'] ],\r\n                        tooltip: [ 'Measure area' ],\r\n                    },\r\n                ],\r\n                offset: 400,\r\n            },\r\n            orientation:  {\r\n                buttons: [\r\n                    {\r\n                        id: 'action:left',\r\n                        set: 0,\r\n                        groups: [],\r\n                        icon: [ ['far', 'undo-alt'] ],\r\n                        tooltip: [ 'Rotate counter-clockwise' ],\r\n                    },\r\n                    {\r\n                        id: 'action:right',\r\n                        set: 0,\r\n                        groups: [],\r\n                        // Could also just flip the above icon, but don't want to create an extra option just for this\r\n                        icon: [ ['far', 'redo-alt'] ],\r\n                        tooltip: [ 'Rotate clockwise' ],\r\n                    },\r\n                    {\r\n                        id: 'action:fliph',\r\n                        set: 0,\r\n                        groups: [],\r\n                        icon: [ ['far', 'arrows-alt-h'] ],\r\n                        tooltip: [ 'Flip horizontally' ],\r\n                    },\r\n                    {\r\n                        id: 'action:flipv',\r\n                        set: 0,\r\n                        groups: [],\r\n                        icon: [ ['far', 'arrows-alt-v'] ],\r\n                        tooltip: [ 'Flip vertically' ],\r\n                    },\r\n                ],\r\n                offset: 290,\r\n            },\r\n        } as any\r\n        // Button states\r\n        this.buttonStates = {\r\n            'group:layout':         { active: false, visible: true, enabled: true } as ButtonState,\r\n            'layout:auto':          { active: false, visible: true, enabled: true } as ButtonState,\r\n            'layout:custom':        { active: false, visible: true, enabled: true } as ButtonState,\r\n            'group:measurement':    { active: false, visible: true, enabled: true } as ButtonState,\r\n            //'tool:Angle':           { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:Crosshairs':      { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:EllipticalRoi':   { active: false, visible: true, enabled: true } as ButtonState,\r\n            //'tool:SquareRoi':       { active: false, visible: true, enabled: true } as ButtonState,\r\n            'group:orientation':    { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:fliph':         { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:flipv':         { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:left':          { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:right':         { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:invert':        { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:Length':          { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:link':          { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:Pan':             { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:reset':         { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:StackScroll':     { active: false, visible: true, enabled: true } as ButtonState,\r\n            'action:undo':          { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:Wwwc':            { active: false, visible: true, enabled: true } as ButtonState,\r\n            'tool:Zoom':            { active: false, visible: true, enabled: true } as ButtonState,\r\n        }\r\n        // Subscribe to store commits and dispatches\r\n        this.unsubscribeActions = this.$store.subscribeAction((action) => {\r\n            switch (action.type) {\r\n                case 'tools:re-enable-active':\r\n                    this.enableActiveTools()\r\n                    break\r\n                case 'tools:disable-active':\r\n                    this.disableActiveTools()\r\n                    break\r\n            }\r\n        })\r\n        this.unsubscribeMutations = this.$store.subscribe((mutation, state) => {\r\n            if (mutation.type === 'set-image-resource-loading') {\r\n                if (mutation.payload) {\r\n                    // This is a failsafe against a bug in cornerstone.js or cornerstoneTools.\r\n                    // If a tool is active and in use (i.e. the mouse button controlling that tool\r\n                    // is down) when a new image resource is loaded and displayed, cornerstone will\r\n                    // fail to remove some event listener and the component will not load.\r\n                    this.disableActiveTools()\r\n                } else {\r\n                    this.enableActiveTools()\r\n                }\r\n            }\r\n        })\r\n        // Enable default tools\r\n        this.enableDefaults()\r\n    },\r\n    beforeDestroy () {\r\n        this.$store.commit('set-active-tool', null)\r\n        this.unsubscribeActions()\r\n    },\r\n})\r\n\r\n\r\n\r\n<\/script>\r\n\r\n<style scoped>\r\n.medimg-viewer-toolbar > div {\r\n    position: relative;\r\n    display: flex;\r\n    padding: 10px 0;\r\n}\r\n.medimg-viewer-toolbar-buttongroup {\r\n    position: absolute;\r\n    top: 80px;\r\n    display: flex;\r\n    background-color: var(--medimg-viewer-background);\r\n    border-left: solid 1px var(--medimg-viewer-border-faint);\r\n    border-right: solid 1px var(--medimg-viewer-border-faint);\r\n    border-bottom: solid 1px var(--medimg-viewer-border-faint);\r\n    padding: 0px 0px 10px 10px;\r\n    z-index: 5;\r\n}\r\n</style>\r\n"],sourceRoot:""}]),t.exports=r},1401:(t,n,o)=>{"use strict";o.d(n,{Z:()=>a});var e=o(5798),r=o.n(e),i=o(2790),s=o.n(i);const a=r().extend({components:{ToolbarButton:()=>o.e(566).then(o.bind(o,7566))},props:{allLinked:{type:Boolean,default:!1},anyActive:{type:Boolean,default:!1},anyItem:{type:Boolean,default:!1},anyStack:{type:Boolean,default:!1},gridLayout:{type:Array,default:null},synchronizers:{type:Object,default:null}},data(){return{buttons:[],groups:{},buttonStates:{},imageLink:null,activeGroup:null,buttonsUpdated:0,currentLayout:0,customLayout:[2,2],toolOptions:{"tool:Crosshairs":{active:{mouseButtonMask:1,synchronizationContext:this.synchronizers.crosshairs},default:{}},"tool:EllipticalRoi":{active:{mouseButtonMask:1},default:{}},"tool:Length":{active:{mouseButtonMask:1},default:{}},"tool:Pan":{active:{mouseButtonMask:1},default:{mouseButtonMask:1}},"tool:StackScroll":{active:{mouseButtonMask:1,synchronizationContext:this.synchronizers.stackScroll},default:{}},"tool:Wwwc":{active:{mouseButtonMask:1},default:{mouseButtonMask:2}},"tool:Zoom":{active:{mouseButtonMask:1},default:{mouseButtonMask:4}}},unsubscribeActions:null,unsubscribeMutations:null}},computed:{activeGroupButtons(){if(!this.activeGroup)return[];const t=[];let n=null;return this.groups[this.activeGroup].buttons.forEach((o=>{if(this.buttonStates[o.id].visible){let e=!1;null===n?n=o.set:o.set>n&&(e=!0,n=o.set),t.push({id:o.id,active:this.isActive(o.id)||this.buttonStates[o.id].active,enabled:this.buttonStates[o.id].enabled,set:n||0,setFirst:e,label:o.label,options:o.options,icon:this.getButtonIcon(o),overlay:this.getButtonOverlay(o),tooltip:this.getButtonTooltip(o)})}})),t},activeGroupOffset(){return this.activeGroup?this.groups[this.activeGroup].offset:0},buttonRow(){this.buttonsUpdated;const t=[];let n=null;return this.buttons.forEach((o=>{if(this.buttonStates[o.id].visible){let e=!1;null===n?n=o.set:o.set>n&&(e=!0,n=o.set),t.push({id:o.id,active:this.isActive(o.id)||this.buttonStates[o.id].active,enabled:this.isEnabled(o.id)&&this.buttonStates[o.id].enabled,set:n||0,setFirst:e,label:"",options:[],icon:this.getButtonIcon(o),overlay:this.getButtonOverlay(o),tooltip:this.getButtonTooltip(o)})}})),t}},methods:{t:function(t,n){return n?this.$t(`components.Radiology.RadiologyToolbar.${t}`,n):this.$t("components.Radiology.RadiologyToolbar")[t]},buttonClicked:function(t,n){const[o,e]=t.split(":");if("group"===o)this.toggleGroup(e);else if("action"===o)"invert"===e?this.invertColors():"fliph"===e?this.flip("x"):"flipv"===e?this.flip("y"):"left"===e?this.rotate(-90):"link"===e?this.toggleLink():"reset"===e?this.resetAll():"right"===e?this.rotate(90):"undo"===e&&this.undoLast();else if("layout"===o)"auto"===e?this.setLayout(null):"custom"===e&&this.setLayout(this.customLayout),this.activeGroup=null;else if("tool"===o){this.toggleTool(e,n);const o=this.findButtonById(t,n);if(o&&o.groups.length){this.buttons.forEach((t=>{t.id!==(null==o?void 0:o.id)&&t.groups.length&&t.groups.filter((t=>-1!==(null==o?void 0:o.groups.indexOf(t)))).length&&(this.buttonStates[t.id].active=!1)}));Object.values(this.groups).forEach((t=>{t.buttons.forEach((t=>{t.id!==(null==o?void 0:o.id)&&t.groups.length&&t.groups.filter((t=>-1!==(null==o?void 0:o.groups.indexOf(t)))).length&&(this.buttonStates[t.id].active=!1)}))}))}}this.$nextTick((()=>{this.buttonsUpdated++}))},disableActiveTools:function(){this.$store.state.activeTool?s().setToolDisabled(`${this.$store.state.activeTool}-${this.$store.state.appName}`):s().setToolDisabled(`Pan-${this.$store.state.appName}`),s().setToolDisabled(`Wwwc-${this.$store.state.appName}`),s().setToolDisabled(`Zoom-${this.$store.state.appName}`)},enableActiveTools:function(){this.$store.state.imageResourceLoading||(this.disableActiveTools(),this.$store.state.activeTool?this.enableDefaults(!0):this.enableDefaults(),s().setToolActive(`StackScrollMouseWheel-${this.$store.state.appName}`,{}))},enableDefaults:function(t=!1){t||(s().setToolActive(`Pan-${this.$store.state.appName}`,this.toolOptions["tool:Pan"].default),this.buttonStates["tool:Pan"].active=!0),s().setToolActive(`Wwwc-${this.$store.state.appName}`,this.toolOptions["tool:Wwwc"].default),s().setToolActive(`Zoom-${this.$store.state.appName}`,this.toolOptions["tool:Zoom"].default)},findButtonById:function(t,n){return n?this.groups[n].buttons.find((n=>n.id===t)):this.buttons.find((n=>n.id===t))},flip:function(t){"x"===t?this.$store.dispatch("image:flip-horizontally"):"y"===t&&this.$store.dispatch("image:flip-vertically")},getButtonIcon:function(t,n){return"string"==typeof t&&(t=this.findButtonById(t,n)),t?"group:measurement"===t.id?this.buttonStates["tool:EllipticalRoi"].active?this.getButtonIcon("tool:EllipticalRoi","measurement"):this.getButtonIcon("tool:Length","measurement"):t.icon[1!==t.icon.length&&this.isActive(t.id)?1:0]:[]},getButtonOverlay:function(t,n){switch("string"==typeof t&&(t=this.findButtonById(t,n)),t.id){case"group:layout":return this.gridLayout?`${this.gridLayout[0]||"?"}x${this.gridLayout[1]||"?"}`:"A";case"layout:auto":return"A";case"layout:custom":return`${this.customLayout[0]||"?"}x${this.customLayout[1]||"?"}`}return""},getButtonTooltip:function(t,n){var o;return"string"==typeof t&&(t=this.findButtonById(t,n)),void 0!==typeof t?null===(o=t.tooltip[1!==t.tooltip.length&&this.isActive(t.id)?1:0])||void 0===o?void 0:o.toString():""},invertColors:function(){this.$store.dispatch("image:invert-colors")},isActive(t){switch(t){case"group:measurement":return this.buttonStates["tool:EllipticalRoi"].active||this.buttonStates["tool:Length"].active;case"action:link":return this.allLinked;default:return this.buttonStates[t].active}},isEnabled(t){if(this.$store.state.imageResourceLoading)return!1;switch(t){case"group:layout":return this.anyItem;case"tool:Crosshairs":case"tool:StackScroll":case"action:link":return this.anyStack;default:return this.anyActive}},resetAll:function(){this.$store.dispatch("image:restore-default-settings")},rotate:function(t){this.$store.dispatch("image:rotate-by",t)},setDisabledButtons:function(t){Object.keys(this.buttonStates).map((t=>{this.buttonStates[t].enabled=!0})),t.forEach((t=>{let n=this.buttons.find((n=>n.id===t));void 0!==n&&(this.buttonStates[n.id].enabled=!1)})),this.buttonsUpdated++},setHiddenButtons:function(t){Object.keys(this.buttonStates).map((t=>{this.buttonStates[t].visible=!0})),t.forEach((t=>{let n=this.buttons.find((n=>n.id===t));void 0!==n&&(this.buttonStates[n.id].active=!1,this.buttonStates[n.id].visible=!1)})),this.buttonsUpdated++},setLayout:function(t){this.$emit("update:gridLayout",t)},toggleGroup:function(t){t===this.activeGroup?this.activeGroup=null:this.activeGroup=t},toggleLink:function(){this.isActive("action:link")?this.$emit("link-all-resources",!1):this.$emit("link-all-resources",!0)},toggleTool:function(t,n){const o=`tool:${t}`;this.buttonStates[o].active?(s().setToolPassive(`${t}-${this.$store.state.appName}`),this.$store.commit("set-active-tool",null),this.buttonStates[o].active=!1,this.$nextTick((()=>{this.enableDefaults()}))):(this.$store.commit("set-active-tool",t),s().setToolActive(`${t}-${this.$store.state.appName}`,this.toolOptions[o].active),this.buttonStates[o].active=!0),n&&(this.activeGroup=null)},undoLast:function(){}},mounted(){this.buttons=[{id:"tool:Pan",set:1,groups:["interact"],icon:[["fal","hand-paper"]],tooltip:["Pan image"]},{id:"tool:Zoom",set:1,groups:["interact"],icon:[["fal","search"]],tooltip:["Zoom"]},{id:"tool:StackScroll",set:1,groups:["interact"],icon:[["fal","layer-group"]],tooltip:["Scroll image stack"]},{id:"tool:Crosshairs",set:1,groups:["interact"],icon:[["fal","crosshairs"]],tooltip:["Crosshairs"]},{id:"group:orientation",set:2,groups:["orientation"],icon:[["fal","arrows"]],tooltip:["Orientation tools"]},{id:"group:measurement",set:3,groups:["measurement"],icon:null,tooltip:["Measurement tools"]},{id:"action:invert",set:4,groups:[],icon:[["fad","clone"]],tooltip:["Invert image"]},{id:"tool:Wwwc",set:4,groups:["interact"],icon:[["fad","adjust"]],tooltip:["Adjust window"]},{id:"group:layout",set:5,groups:["layout"],icon:[["fal","border-all"]],tooltip:["Layout tools"]},{id:"action:link",set:6,groups:[],icon:[["fal","link"],["fal","unlink"]],tooltip:["Link image stacks","Unlink image stacks"]},{id:"action:reset",set:7,groups:["undo"],icon:[["fal","reply-all"]],tooltip:["Reset all adjustments"]}],this.groups={layout:{buttons:[{id:"layout:auto",set:0,groups:[],icon:[["fal","border-all"]],tooltip:["Automatic layout"]},{id:"layout:custom",set:0,groups:[],icon:[["fal","border-all"]],tooltip:["Custom layout"]}],offset:660},measurement:{buttons:[{id:"tool:Length",set:0,groups:["interact"],icon:[["fal","ruler"]],tooltip:["Measure distance"]},{id:"tool:EllipticalRoi",set:0,groups:["interact"],icon:[["fal","draw-circle"]],tooltip:["Measure area"]}],offset:400},orientation:{buttons:[{id:"action:left",set:0,groups:[],icon:[["far","undo-alt"]],tooltip:["Rotate counter-clockwise"]},{id:"action:right",set:0,groups:[],icon:[["far","redo-alt"]],tooltip:["Rotate clockwise"]},{id:"action:fliph",set:0,groups:[],icon:[["far","arrows-alt-h"]],tooltip:["Flip horizontally"]},{id:"action:flipv",set:0,groups:[],icon:[["far","arrows-alt-v"]],tooltip:["Flip vertically"]}],offset:290}},this.buttonStates={"group:layout":{active:!1,visible:!0,enabled:!0},"layout:auto":{active:!1,visible:!0,enabled:!0},"layout:custom":{active:!1,visible:!0,enabled:!0},"group:measurement":{active:!1,visible:!0,enabled:!0},"tool:Crosshairs":{active:!1,visible:!0,enabled:!0},"tool:EllipticalRoi":{active:!1,visible:!0,enabled:!0},"group:orientation":{active:!1,visible:!0,enabled:!0},"action:fliph":{active:!1,visible:!0,enabled:!0},"action:flipv":{active:!1,visible:!0,enabled:!0},"action:left":{active:!1,visible:!0,enabled:!0},"action:right":{active:!1,visible:!0,enabled:!0},"action:invert":{active:!1,visible:!0,enabled:!0},"tool:Length":{active:!1,visible:!0,enabled:!0},"action:link":{active:!1,visible:!0,enabled:!0},"tool:Pan":{active:!1,visible:!0,enabled:!0},"action:reset":{active:!1,visible:!0,enabled:!0},"tool:StackScroll":{active:!1,visible:!0,enabled:!0},"action:undo":{active:!1,visible:!0,enabled:!0},"tool:Wwwc":{active:!1,visible:!0,enabled:!0},"tool:Zoom":{active:!1,visible:!0,enabled:!0}},this.unsubscribeActions=this.$store.subscribeAction((t=>{switch(t.type){case"tools:re-enable-active":this.enableActiveTools();break;case"tools:disable-active":this.disableActiveTools()}})),this.unsubscribeMutations=this.$store.subscribe(((t,n)=>{"set-image-resource-loading"===t.type&&(t.payload?this.disableActiveTools():this.enableActiveTools())})),this.enableDefaults()},beforeDestroy(){this.$store.commit("set-active-tool",null),this.unsubscribeActions()}})},5818:(t,n,o)=>{"use strict";o.r(n),o.d(n,{default:()=>i});var e=o(5598),r=o(1996);o(2296);const i=(0,o(8758).Z)(r.Z,e.s,e.x,!1,null,"21da0db5",null).exports},1996:(t,n,o)=>{"use strict";o.d(n,{Z:()=>e});const e=o(1401).Z},5598:(t,n,o)=>{"use strict";o.d(n,{s:()=>e.s,x:()=>e.x});var e=o(7298)},2296:(t,n,o)=>{"use strict";o(7357)},7298:(t,n,o)=>{"use strict";o.d(n,{s:()=>e,x:()=>r});var e=function(){var t=this,n=t._self._c;t._self._setupProxy;return n("div",{attrs:{id:`${t.$store.state.appName}-medimg-viewer-radiology-toolbar`}},[t.activeGroup?n("div",{class:["medimg-viewer-toolbar-buttongroup"],style:`left:${t.activeGroupOffset}px`},t._l(t.activeGroupButtons,(function(o,e){return n("toolbar-button",{key:`toolbar-button-${t.activeGroup}-${e}`,class:[{"medimg-viewer-disabled":!o.enabled},{"element-active":"function"==typeof o.active?o.active():o.active},{"medimg-viewer-toolbar-setfirst":o.setFirst}],attrs:{id:o.id,emit:o.emit,enabled:o.enabled,icon:o.icon,overlay:o.overlay,tooltip:`Radiology.${o.tooltip}`},on:{"button-clicked":function(n){return t.buttonClicked(n,t.activeGroup)}}})})),1):t._e(),t._v(" "),t._l(t.buttonRow,(function(o,e){return n("toolbar-button",{key:`toolbar-button-${e}`,class:[{"medimg-viewer-disabled":!o.enabled},{"element-active":"function"==typeof o.active?o.active():o.active},{"medimg-viewer-toolbar-setfirst":o.setFirst}],attrs:{id:o.id,activeGroup:t.activeGroup,emit:o.emit,enabled:o.enabled,icon:o.icon,overlay:o.overlay,tooltip:`Radiology.${o.tooltip}`},on:{"button-clicked":t.buttonClicked}})}))],2)},r=[];e._withStripped=!0},7357:(t,n,o)=>{var e=o(6363);e.__esModule&&(e=e.default),"string"==typeof e&&(e=[[t.id,e,""]]),e.locals&&(t.exports=e.locals);(0,o(7913).Z)("0fffd892",e,!1,{})}}]);
//# sourceMappingURL=818-amd.js.map?v=9f5a97236b8fa3a987b1