(self.webpackChunkmedimg_viewer=self.webpackChunkmedimg_viewer||[]).push([[896],{7570:(e,t,i)=>{var r=i(4015),n=i(3645)(r);n.push([e.id,"\n.medimg-viewer-sidebar > div[data-v-047ff96c] {\r\n    position: relative;\r\n    padding: 80px 10px 10px 10px;\r\n    width: 300px;\r\n    height: calc(100% - 50px);\r\n    margin-top: 0; /* Unset possible margin from another scope */\n}\n.medimg-viewer-sidebar-loadstudies[data-v-047ff96c],\r\n.medimg-viewer-sidebar-loading[data-v-047ff96c] {\r\n    height: 50px;\r\n    line-height: 50px;\r\n    text-align: center;\r\n    font-weight: bold;\r\n    color: var(--medimg-viewer-text-faint);\n}\n.medimg-viewer-sidebar-loadstudies[data-v-047ff96c] {\r\n    cursor: pointer;\n}\n.medimg-viewer-sidebar-items[data-v-047ff96c] {\r\n    display: flex;\r\n    flex-direction: column;\r\n    height: 100%;\r\n    overflow-y: scroll;\n}\n.medimg-viewer-dropzone[data-v-047ff96c] {\r\n    flex-grow: 1;\r\n    margin-bottom: 10px;\r\n    min-height: 100px;\n}\n.medimg-viewer-dropzone.medimg-viewer-highlight[data-v-047ff96c] {\r\n        background-color: var(--medimg-viewer-background-emphasize);\n}\n.medimg-viewer-statusbar[data-v-047ff96c] {\r\n    height: 50px;\r\n    line-height: 25px;\r\n    color: var(--medimg-viewer-text-faint);\n}\n.medimg-viewer-statusbar > span[data-v-047ff96c]:nth-child(1) {\r\n        display: block;\n}\r\n","",{version:3,sources:["webpack://./src/components/Radiology/RadiologySidebar.vue"],names:[],mappings:";AA2PA;IACA,kBAAA;IACA,4BAAA;IACA,YAAA;IACA,yBAAA;IACA,aAAA,EAAA,6CAAA;AACA;AACA;;IAEA,YAAA;IACA,iBAAA;IACA,kBAAA;IACA,iBAAA;IACA,sCAAA;AACA;AACA;IACA,eAAA;AACA;AACA;IACA,aAAA;IACA,sBAAA;IACA,YAAA;IACA,kBAAA;AACA;AACA;IACA,YAAA;IACA,mBAAA;IACA,iBAAA;AACA;AACA;QACA,2DAAA;AACA;AACA;IACA,YAAA;IACA,iBAAA;IACA,sCAAA;AACA;AACA;QACA,cAAA;AACA",sourcesContent:['<template>\r\n    <div :id="`${$store.state.appName}-medimg-viewer-radiology-sidebar`">\r\n        <div class="medimg-viewer-sidebar-items">\r\n            <vue-draggable v-model="items" ref="draggable-list" :sort="allowSorting" @change="listChanged" @end="itemDropped">\r\n                <radiology-sidebar-item v-for="(item, idx) in items" :key="`sidebaritem-${idx}-${item.id}`"\r\n                    ref="sidebar-item"\r\n                    :active="item.isActive"\r\n                    :count="item.size"\r\n                    :cover="item.coverImage"\r\n                    :id="item.id"\r\n                    :index="idx"\r\n                    :label="item.modality"\r\n                    :notice="notices[idx]"\r\n                    :stack="item.isStack"\r\n                    :title="item.name"\r\n                    :type="item.type"\r\n                    v-on:second-item-mounted="secondItemMounted"\r\n                    v-on:toggle-active-item="toggleActiveItem"\r\n                />\r\n            </vue-draggable>\r\n            <div v-if="hasStudiesToLoad && !$store.state.loadingStudies" class="medimg-viewer-sidebar-loadstudies" @click="$emit(\'load-studies\')">\r\n                {{ t(\'Load studies\')}}\r\n            </div>\r\n            <div v-else :class="[\r\n                \'medimg-viewer-sidebar-loading\',\r\n                { \'medimg-viewer-hidden\': !$store.state.loadingStudies }\r\n            ]">\r\n                <font-awesome-icon :icon="[\'fad\', \'spinner-third\']" spin></font-awesome-icon>\r\n                {{ t(\'LOADING STUDIES\') }}\r\n            </div>\r\n            <div :id="`${$store.state.appName}-medimg-viewer-radiology-dropzone`" :style="dropZoneStyles" class="medimg-viewer-dropzone"></div>\r\n        </div>\r\n        <div :id="`${$store.state.appName}-medimg-viewer-radiology-statusbar`" class="medimg-viewer-statusbar">\r\n            <span>{{ t(\'Cache status\') }}</span>\r\n            <span>{{ cacheImages === 1 ? t(\'1 image\') : t(\'{n} images\', { n: cacheImages }) }}</span>\r\n            <span v-if="cacheSize">\r\n                - {{ t(\'{n}% used\', { n: cacheUtil }) }}\r\n            </span>\r\n        </div>\r\n    </div>\r\n</template>\r\n\r\n<script lang="ts">\r\n\r\nimport Vue from \'vue\'\r\nimport { ImageResource } from \'../../types/radiology\'\r\nimport VueDraggable from \'vuedraggable\'\r\n\r\nexport default Vue.extend({\r\n    components: {\r\n        RadiologySidebarItem: () => import(\'./RadiologySidebarItem.vue\'),\r\n        VueDraggable,\r\n    },\r\n    props: {\r\n        allowSorting: Boolean,\r\n        dicomItems: Array,\r\n        hasStudiesToLoad: Boolean,\r\n    },\r\n    data () {\r\n        return {\r\n            dropZone: null as HTMLElement | null,\r\n            lastActivated: null as number | null,\r\n            listShuffled: false,\r\n            mediaItems: [] as ImageResource[],\r\n            notices: [] as string[],\r\n        }\r\n    },\r\n    computed: {\r\n        cacheImages () {\r\n            return this.$store.state.cacheStatus.count\r\n        },\r\n        cacheMax () {\r\n            return this.$store.state.cacheStatus.max\r\n        },\r\n        cacheSize () {\r\n            return this.$store.state.cacheStatus.size\r\n        },\r\n        cacheUtil () {\r\n            if (!this.$store.state.cacheStatus.max) {\r\n                return \'~\' // Don\'t want division by zero\r\n            }\r\n            const util = Math.round(1000*this.$store.state.cacheStatus.size/this.$store.state.cacheStatus.max)/10\r\n            // Prepend a tilde if rounded utilization is 0% (but there are items in the cache)\r\n            return this.$store.state.cacheStatus.count && !util ? `~${util}` : `${util}`\r\n        },\r\n        dropZoneStyles () {\r\n            const heightTaken = 10 + 60 + 60 + this.dicomItems.length*149 + 20\r\n            return `width: 100%; height: calc(100% - ${heightTaken}px`\r\n        },\r\n        items: {\r\n            get (): ImageResource[] {\r\n                return this.dicomItems as ImageResource[]\r\n            },\r\n            set (value: ImageResource[]) {\r\n                // Get the new item order\r\n                const order = value.map(item => item.id)\r\n                this.$emit(\'update-item-order\', order)\r\n            },\r\n        },\r\n    },\r\n    methods: {\r\n        /** Shorthand for component-specific translations */\r\n        t: function (str: string, args?: any) {\r\n            if (args) {\r\n                return this.$t(`components.Radiology.RadiologySidebar.${str}`, args)\r\n            } else {\r\n                return (this.$t(\'components.Radiology.RadiologySidebar\') as any)[str]\r\n            }\r\n        },\r\n        clearDropZoneHighlight: function () {\r\n            if (this.dropZone) {\r\n                this.dropZone.classList.remove(\'medimg-viewer-highlight\')\r\n            }\r\n        },\r\n        secondItemMounted: function () {\r\n            // Make sure there really are more than one item and that it hasn\'t been shuffled yet\r\n            if (this.dicomItems.length > 1 && !this.listShuffled) {\r\n                this.listShuffled = true\r\n                this.$nextTick(() => {\r\n                    // This silly hack is needed because otherwise the first dragged item would always\r\n                    // end up at the start of the list. May probably be removed if:\r\n                    // https://github.com/SortableJS/Vue.Draggable/issues/419 and/or\r\n                    // https://github.com/SortableJS/Vue.Draggable/issues/603\r\n                    // are resolved in the future.\r\n                    ;(this.$refs[\'draggable-list\'] as any).updatePosition(0, 1)\r\n                    ;(this.$refs[\'draggable-list\'] as any).updatePosition(1, 0)\r\n                })\r\n            }\r\n        },\r\n        handleFileDrag: function (event: DragEvent) {\r\n            // Prevent default event effects\r\n            event.stopPropagation()\r\n            event.preventDefault()\r\n            if (event.dataTransfer) {\r\n                // Show that dropping the file "copies" it\r\n                event.dataTransfer.dropEffect = \'copy\'\r\n                // Highlight the dropzone\r\n                if (this.dropZone) {\r\n                    this.dropZone.classList.add(\'medimg-viewer-highlight\')\r\n                }\r\n            }\r\n        },\r\n        handleFileDrop: function (event: DragEvent) {\r\n            // Clear the highlight\r\n            this.clearDropZoneHighlight()\r\n            // Pass file drop event to parent component\r\n            this.$emit(\'file-dropped\', event)\r\n        },\r\n        itemDropped: function (evt: any) {\r\n            const targetId = evt?.originalEvent?.target?.id\r\n            if (targetId && targetId.startsWith(`${this.$store.state.appName}-medimg-viewer-image-drop-`)) {\r\n                // Image resource was dropped on one of the placeholder elements\r\n                const targetIdx = parseInt(targetId.replace(`${this.$store.state.appName}-medimg-viewer-image-drop-`, \'\'))\r\n                ;(this.dicomItems[evt.oldIndex] as ImageResource).isActive = true\r\n                this.$emit(\'item-dropped\', { item: evt.oldIndex, target: targetIdx })\r\n            }\r\n        },\r\n        listChanged: function (evt: any) {\r\n            // If last activated item was reordered, adjust the cached index\r\n            if (this.lastActivated === null || !evt.moved) {\r\n                return\r\n            }\r\n            if (evt.moved.oldIndex === this.lastActivated) {\r\n                this.lastActivated = evt.moved.newIndex\r\n            } else if (evt.moved.oldIndex < this.lastActivated && evt.moved.newIndex >= this.lastActivated) {\r\n                // Last activated has moved up on the list\r\n                this.lastActivated--\r\n            } else if (evt.moved.oldIndex > this.lastActivated && evt.moved.newIndex <= this.lastActivated) {\r\n                // Last activated has moved down on the list\r\n                this.lastActivated++\r\n            }\r\n        },\r\n        setItemNotice: function (itemIdx: number, message: string) {\r\n            this.notices[itemIdx] = message\r\n        },\r\n        toggleActiveItem: function (itemIdx: number, event: MouseEvent) {\r\n            const item = this.items[itemIdx] as ImageResource\r\n            const otherActive = [] as ImageResource[]\r\n            // See if there are other active items\r\n            for (const otherItem of this.dicomItems as ImageResource[]) {\r\n                if (item !== otherItem && otherItem.isActive) {\r\n                    otherActive.push(otherItem)\r\n                }\r\n            }\r\n            if (!item.isActive) {\r\n                // If the element is being activated, two things must be checked:\r\n                // - is it a ctrl-click, in which case we will leave other active items active\r\n                // - is it a shift-click, in which case we will activate a range of elements\r\n                if (this.lastActivated !== null  && this.lastActivated !== itemIdx && event.shiftKey) {\r\n                    const diff = this.lastActivated - itemIdx\r\n                    for (let i=1; i<=Math.abs(diff); i++) {\r\n                        // Either add or substract i from starting index\r\n                        const curIdx = itemIdx + (diff < 0 ? -i : i)\r\n                        if (!(this.items[curIdx] as ImageResource).isActive) {\r\n                            (this.items[curIdx] as ImageResource).isActive = true\r\n                        }\r\n                    }\r\n                } else if (!event.ctrlKey) {\r\n                    // Not a control click, deactivate other active items\r\n                    for (const otherItem of otherActive) {\r\n                        otherItem.isActive = false\r\n                    }\r\n                }\r\n                // Mark as last activated\r\n                this.lastActivated = itemIdx\r\n                item.isActive = true\r\n            } else {\r\n                // If the element is being deactivated, check if there are other active items\r\n                if (otherActive.length) {\r\n                    // In this case, keep the element active, but deactivate the others, or\r\n                    // if control is pressed, just deactivate this item\r\n                    if (!event.ctrlKey) {\r\n                        for (const otherItem of otherActive) {\r\n                            otherItem.isActive = false\r\n                            if (otherItem.isStack && otherItem.isLinked) {\r\n                                // Unlink deactivated items\r\n                                (otherItem as ImageResource).unlink()\r\n                            }\r\n                        }\r\n                        // Mark as last activated\r\n                        this.lastActivated = itemIdx\r\n                    } else {\r\n                        // Deactivate item, but keep last activated intact\r\n                        item.isActive = false\r\n                    }\r\n                } else {\r\n                    // Simply deactivate, unlink (if needed) and unset last activated item\r\n                    item.isActive = false\r\n                    if (item.isStack && item.isLinked) {\r\n                        (item as ImageResource).unlink()\r\n                    }\r\n                    this.lastActivated = null\r\n                }\r\n            }\r\n            this.$emit(\'element-status-changed\')\r\n        },\r\n    },\r\n    mounted () {\r\n        // Set up DICOM file dropzone\r\n        this.dropZone = document.getElementById(`${this.$store.state.appName}-medimg-viewer-radiology-dropzone`)\r\n        if (this.dropZone) {\r\n            this.dropZone.addEventListener(\'dragover\', this.handleFileDrag, false)\r\n            this.dropZone.addEventListener(\'drop\', this.handleFileDrop, false)\r\n            this.dropZone.addEventListener(\'dragleave\', this.clearDropZoneHighlight, false)\r\n        }\r\n    },\r\n})\r\n\r\n<\/script>\r\n\r\n<style scoped>\r\n.medimg-viewer-sidebar > div {\r\n    position: relative;\r\n    padding: 80px 10px 10px 10px;\r\n    width: 300px;\r\n    height: calc(100% - 50px);\r\n    margin-top: 0; /* Unset possible margin from another scope */\r\n}\r\n.medimg-viewer-sidebar-loadstudies,\r\n.medimg-viewer-sidebar-loading {\r\n    height: 50px;\r\n    line-height: 50px;\r\n    text-align: center;\r\n    font-weight: bold;\r\n    color: var(--medimg-viewer-text-faint);\r\n}\r\n.medimg-viewer-sidebar-loadstudies {\r\n    cursor: pointer;\r\n}\r\n.medimg-viewer-sidebar-items {\r\n    display: flex;\r\n    flex-direction: column;\r\n    height: 100%;\r\n    overflow-y: scroll;\r\n}\r\n.medimg-viewer-dropzone {\r\n    flex-grow: 1;\r\n    margin-bottom: 10px;\r\n    min-height: 100px;\r\n}\r\n    .medimg-viewer-dropzone.medimg-viewer-highlight {\r\n        background-color: var(--medimg-viewer-background-emphasize);\r\n    }\r\n.medimg-viewer-statusbar {\r\n    height: 50px;\r\n    line-height: 25px;\r\n    color: var(--medimg-viewer-text-faint);\r\n}\r\n    .medimg-viewer-statusbar > span:nth-child(1) {\r\n        display: block;\r\n    }\r\n</style>\r\n'],sourceRoot:""}]),e.exports=n},1494:(e,t,i)=>{"use strict";i.d(t,{Z:()=>o});var r=i(5798),n=i.n(r),s=i(9980),a=i.n(s);const o=n().extend({components:{RadiologySidebarItem:()=>i.e(391).then(i.bind(i,3348)),VueDraggable:a()},props:{allowSorting:Boolean,dicomItems:Array,hasStudiesToLoad:Boolean},data:()=>({dropZone:null,lastActivated:null,listShuffled:!1,mediaItems:[],notices:[]}),computed:{cacheImages(){return this.$store.state.cacheStatus.count},cacheMax(){return this.$store.state.cacheStatus.max},cacheSize(){return this.$store.state.cacheStatus.size},cacheUtil(){if(!this.$store.state.cacheStatus.max)return"~";const e=Math.round(1e3*this.$store.state.cacheStatus.size/this.$store.state.cacheStatus.max)/10;return this.$store.state.cacheStatus.count&&!e?`~${e}`:`${e}`},dropZoneStyles(){return`width: 100%; height: calc(100% - ${130+149*this.dicomItems.length+20}px`},items:{get(){return this.dicomItems},set(e){const t=e.map((e=>e.id));this.$emit("update-item-order",t)}}},methods:{t:function(e,t){return t?this.$t(`components.Radiology.RadiologySidebar.${e}`,t):this.$t("components.Radiology.RadiologySidebar")[e]},clearDropZoneHighlight:function(){this.dropZone&&this.dropZone.classList.remove("medimg-viewer-highlight")},secondItemMounted:function(){this.dicomItems.length>1&&!this.listShuffled&&(this.listShuffled=!0,this.$nextTick((()=>{this.$refs["draggable-list"].updatePosition(0,1),this.$refs["draggable-list"].updatePosition(1,0)})))},handleFileDrag:function(e){e.stopPropagation(),e.preventDefault(),e.dataTransfer&&(e.dataTransfer.dropEffect="copy",this.dropZone&&this.dropZone.classList.add("medimg-viewer-highlight"))},handleFileDrop:function(e){this.clearDropZoneHighlight(),this.$emit("file-dropped",e)},itemDropped:function(e){var t,i;const r=null===(i=null===(t=null==e?void 0:e.originalEvent)||void 0===t?void 0:t.target)||void 0===i?void 0:i.id;if(r&&r.startsWith(`${this.$store.state.appName}-medimg-viewer-image-drop-`)){const t=parseInt(r.replace(`${this.$store.state.appName}-medimg-viewer-image-drop-`,""));this.dicomItems[e.oldIndex].isActive=!0,this.$emit("item-dropped",{item:e.oldIndex,target:t})}},listChanged:function(e){null!==this.lastActivated&&e.moved&&(e.moved.oldIndex===this.lastActivated?this.lastActivated=e.moved.newIndex:e.moved.oldIndex<this.lastActivated&&e.moved.newIndex>=this.lastActivated?this.lastActivated--:e.moved.oldIndex>this.lastActivated&&e.moved.newIndex<=this.lastActivated&&this.lastActivated++)},setItemNotice:function(e,t){this.notices[e]=t},toggleActiveItem:function(e,t){const i=this.items[e],r=[];for(const e of this.dicomItems)i!==e&&e.isActive&&r.push(e);if(i.isActive)if(r.length)if(t.ctrlKey)i.isActive=!1;else{for(const e of r)e.isActive=!1,e.isStack&&e.isLinked&&e.unlink();this.lastActivated=e}else i.isActive=!1,i.isStack&&i.isLinked&&i.unlink(),this.lastActivated=null;else{if(null!==this.lastActivated&&this.lastActivated!==e&&t.shiftKey){const t=this.lastActivated-e;for(let i=1;i<=Math.abs(t);i++){const r=e+(t<0?-i:i);this.items[r].isActive||(this.items[r].isActive=!0)}}else if(!t.ctrlKey)for(const e of r)e.isActive=!1;this.lastActivated=e,i.isActive=!0}this.$emit("element-status-changed")}},mounted(){this.dropZone=document.getElementById(`${this.$store.state.appName}-medimg-viewer-radiology-dropzone`),this.dropZone&&(this.dropZone.addEventListener("dragover",this.handleFileDrag,!1),this.dropZone.addEventListener("drop",this.handleFileDrop,!1),this.dropZone.addEventListener("dragleave",this.clearDropZoneHighlight,!1))}})},5896:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var r=i(6514),n=i(4832);i(5441);const s=(0,i(8758).Z)(n.Z,r.s,r.x,!1,null,"047ff96c",null).exports},4832:(e,t,i)=>{"use strict";i.d(t,{Z:()=>r});const r=i(1494).Z},6514:(e,t,i)=>{"use strict";i.d(t,{s:()=>r.s,x:()=>r.x});var r=i(4924)},5441:(e,t,i)=>{"use strict";i(6671)},4924:(e,t,i)=>{"use strict";i.d(t,{s:()=>r,x:()=>n});var r=function(){var e=this,t=e._self._c;e._self._setupProxy;return t("div",{attrs:{id:`${e.$store.state.appName}-medimg-viewer-radiology-sidebar`}},[t("div",{staticClass:"medimg-viewer-sidebar-items"},[t("vue-draggable",{ref:"draggable-list",attrs:{sort:e.allowSorting},on:{change:e.listChanged,end:e.itemDropped},model:{value:e.items,callback:function(t){e.items=t},expression:"items"}},e._l(e.items,(function(i,r){return t("radiology-sidebar-item",{key:`sidebaritem-${r}-${i.id}`,ref:"sidebar-item",refInFor:!0,attrs:{active:i.isActive,count:i.size,cover:i.coverImage,id:i.id,index:r,label:i.modality,notice:e.notices[r],stack:i.isStack,title:i.name,type:i.type},on:{"second-item-mounted":e.secondItemMounted,"toggle-active-item":e.toggleActiveItem}})})),1),e._v(" "),e.hasStudiesToLoad&&!e.$store.state.loadingStudies?t("div",{staticClass:"medimg-viewer-sidebar-loadstudies",on:{click:function(t){return e.$emit("load-studies")}}},[e._v("\n            "+e._s(e.t("Load studies"))+"\n        ")]):t("div",{class:["medimg-viewer-sidebar-loading",{"medimg-viewer-hidden":!e.$store.state.loadingStudies}]},[t("font-awesome-icon",{attrs:{icon:["fad","spinner-third"],spin:""}}),e._v("\n            "+e._s(e.t("LOADING STUDIES"))+"\n        ")],1),e._v(" "),t("div",{staticClass:"medimg-viewer-dropzone",style:e.dropZoneStyles,attrs:{id:`${e.$store.state.appName}-medimg-viewer-radiology-dropzone`}})],1),e._v(" "),t("div",{staticClass:"medimg-viewer-statusbar",attrs:{id:`${e.$store.state.appName}-medimg-viewer-radiology-statusbar`}},[t("span",[e._v(e._s(e.t("Cache status")))]),e._v(" "),t("span",[e._v(e._s(1===e.cacheImages?e.t("1 image"):e.t("{n} images",{n:e.cacheImages})))]),e._v(" "),e.cacheSize?t("span",[e._v("\n            - "+e._s(e.t("{n}% used",{n:e.cacheUtil}))+"\n        ")]):e._e()])])},n=[];r._withStripped=!0},6671:(e,t,i)=>{var r=i(7570);r.__esModule&&(r=r.default),"string"==typeof r&&(r=[[e.id,r,""]]),r.locals&&(e.exports=r.locals);(0,i(7913).Z)("40b03f29",r,!1,{})}}]);
//# sourceMappingURL=896-amd.js.map?v=ffd992b795795a138fc0