(self.webpackChunkmedimg_viewer=self.webpackChunkmedimg_viewer||[]).push([[962],{7093:(e,r,n)=>{var t=n(4015),i=n(3645)(t);i.push([e.id,"\n.medimg-viewer-image-placeholder[data-v-93556b7c] {\r\n    position: relative;\r\n    float: left;\r\n    padding: 10px;\n}\n.medimg-viewer-image-dropzone[data-v-93556b7c] {\r\n    width: 100%;\r\n    height: 100%;\n}\n.medimg-viewer-image-placeholder-info[data-v-93556b7c] {\r\n    position: absolute;\r\n    top: 0;\r\n    left: 0;\r\n    right: 0;\r\n    bottom: 0;\r\n    text-align: center;\r\n    color: var(--medimg-viewer-text-faint);\r\n    pointer-events: none;\n}\r\n","",{version:3,sources:["webpack://./src/components/Radiology/Dicom/DicomImagePlaceholder.vue"],names:[],mappings:";AA4FA;IACA,kBAAA;IACA,WAAA;IACA,aAAA;AACA;AACA;IACA,WAAA;IACA,YAAA;AACA;AACA;IACA,kBAAA;IACA,MAAA;IACA,OAAA;IACA,QAAA;IACA,SAAA;IACA,kBAAA;IACA,sCAAA;IACA,oBAAA;AACA",sourcesContent:["<template>\r\n\r\n    <div ref=\"wrapper\" class=\"medimg-viewer-image-placeholder\">\r\n        <div ref=\"content\">\r\n            <vue-draggable v-model=\"items\"\r\n                :id=\"`${$store.state.appName}-medimg-viewer-image-drop-${listIndex}`\"\r\n                class=\"medimg-viewer-image-dropzone\"\r\n            />\r\n        </div>\r\n        <div ref=\"info-text\" class=\"medimg-viewer-image-placeholder-info\">\r\n            <span v-if=\"resource === false\">{{ t('Opening failed, please activate the resource manually') }}</span>\r\n            <span v-else-if=\"resource === null\">{{ t('Drop to display an image resource') }}</span>\r\n        </div>\r\n    </div>\r\n\r\n</template>\r\n\r\n<script lang=\"ts\">\r\nimport Vue from 'vue'\r\nimport VueDraggable from 'vuedraggable'\r\n\r\nexport default Vue.extend({\r\n    components: {\r\n        VueDraggable,\r\n    },\r\n    props: {\r\n        containerSize: Array, // The size of the entire image media container as [width, height]\r\n        layoutPosition: Array, // Element position in layout grid [[colPos, cols], [rowPos, rows]]\r\n        resource: Boolean,\r\n    },\r\n    data () {\r\n        return {\r\n            items: [null],\r\n        }\r\n    },\r\n    watch: {\r\n        containerSize (value: Array<number>, old: Array<number>) {\r\n            this.resizeContainer(value)\r\n        },\r\n        layoutPosition (value: Array<number>, old: Array<number>) {\r\n            this.resizeContainer()\r\n        },\r\n    },\r\n    computed: {\r\n        listIndex () {\r\n            const pos = [(this.layoutPosition[0] as number[]), (this.layoutPosition[1] as number[])]\r\n            return pos[0][1]*pos[1][0] + pos[0][0]\r\n        },\r\n    },\r\n    methods: {\r\n        /** Shorthand for component-specific translations */\r\n        t: function (str: string, args?: any) {\r\n            if (args) {\r\n                return this.$t(`components.Radiology.Dicom.DicomImagePlaceholder.${str}`, args)\r\n            } else {\r\n                return (this.$t('components.Radiology.Dicom.DicomImagePlaceholder') as any)[str]\r\n            }\r\n        },\r\n        /**\r\n         * Resize the displayed image into given dimensions.\r\n         * @param {number[]} dimensions [width, height].\r\n         */\r\n        resizeContainer: function (dimensions?: number[]) {\r\n            dimensions = dimensions || this.containerSize as number[]\r\n            const colPos = this.layoutPosition[0] as number[]\r\n            const rowPos = this.layoutPosition[1] as number[]\r\n            const isRowFirst = (colPos[0] === 0)\r\n            const isColLast = (rowPos[0] === rowPos[1] - 1)\r\n            // Remove 20 px for padding\r\n            let hPad = isRowFirst ? 20 : 21\r\n            let vPad = isColLast ? 20 : 21\r\n            ;(this.$refs['content'] as HTMLElement).style.width = `${dimensions[0]/colPos[1] - hPad}px`\r\n            ;(this.$refs['content'] as HTMLElement).style.height = `${dimensions[1]/rowPos[1] - vPad}px`\r\n            ;(this.$refs['wrapper'] as HTMLElement).style.borderLeft\r\n                = isRowFirst ? 'none' : '1px solid var(--medimg-viewer-border-faint)'\r\n            ;(this.$refs['wrapper'] as HTMLElement).style.borderBottom\r\n                = isColLast ? 'none' : '1px solid var(--medimg-viewer-border-faint)'\r\n            // Update possible info text\r\n            const loadingText = this.$refs['info-text'] as HTMLDivElement\r\n            loadingText.style.width = `${dimensions[0]/colPos[1] - hPad}px`\r\n            loadingText.style.height = `${dimensions[1]/rowPos[1] - vPad}px`\r\n            loadingText.style.lineHeight = `${dimensions[1]/rowPos[1] - vPad}px`\r\n        },\r\n    },\r\n    mounted () {\r\n        this.resizeContainer()\r\n    }\r\n})\r\n\r\n<\/script>\r\n\r\n<style scoped>\r\n.medimg-viewer-image-placeholder {\r\n    position: relative;\r\n    float: left;\r\n    padding: 10px;\r\n}\r\n.medimg-viewer-image-dropzone {\r\n    width: 100%;\r\n    height: 100%;\r\n}\r\n.medimg-viewer-image-placeholder-info {\r\n    position: absolute;\r\n    top: 0;\r\n    left: 0;\r\n    right: 0;\r\n    bottom: 0;\r\n    text-align: center;\r\n    color: var(--medimg-viewer-text-faint);\r\n    pointer-events: none;\r\n}\r\n</style>\r\n"],sourceRoot:""}]),e.exports=i},2544:(e,r,n)=>{"use strict";n.d(r,{Z:()=>a});var t=n(5798),i=n.n(t),o=n(9980),s=n.n(o);const a=i().extend({components:{VueDraggable:s()},props:{containerSize:Array,layoutPosition:Array,resource:Boolean},data:()=>({items:[null]}),watch:{containerSize(e,r){this.resizeContainer(e)},layoutPosition(e,r){this.resizeContainer()}},computed:{listIndex(){const e=[this.layoutPosition[0],this.layoutPosition[1]];return e[0][1]*e[1][0]+e[0][0]}},methods:{t:function(e,r){return r?this.$t(`components.Radiology.Dicom.DicomImagePlaceholder.${e}`,r):this.$t("components.Radiology.Dicom.DicomImagePlaceholder")[e]},resizeContainer:function(e){e=e||this.containerSize;const r=this.layoutPosition[0],n=this.layoutPosition[1],t=0===r[0],i=n[0]===n[1]-1;let o=t?20:21,s=i?20:21;this.$refs.content.style.width=e[0]/r[1]-o+"px",this.$refs.content.style.height=e[1]/n[1]-s+"px",this.$refs.wrapper.style.borderLeft=t?"none":"1px solid var(--medimg-viewer-border-faint)",this.$refs.wrapper.style.borderBottom=i?"none":"1px solid var(--medimg-viewer-border-faint)";const a=this.$refs["info-text"];a.style.width=e[0]/r[1]-o+"px",a.style.height=e[1]/n[1]-s+"px",a.style.lineHeight=e[1]/n[1]-s+"px"}},mounted(){this.resizeContainer()}})},1962:(e,r,n)=>{"use strict";n.r(r),n.d(r,{default:()=>o});var t=n(151),i=n(7340);n(7177);const o=(0,n(8758).Z)(i.Z,t.s,t.x,!1,null,"93556b7c",null).exports},7340:(e,r,n)=>{"use strict";n.d(r,{Z:()=>t});const t=n(2544).Z},151:(e,r,n)=>{"use strict";n.d(r,{s:()=>t.s,x:()=>t.x});var t=n(1997)},7177:(e,r,n)=>{"use strict";n(3560)},1997:(e,r,n)=>{"use strict";n.d(r,{s:()=>t,x:()=>i});var t=function(){var e=this,r=e._self._c;e._self._setupProxy;return r("div",{ref:"wrapper",staticClass:"medimg-viewer-image-placeholder"},[r("div",{ref:"content"},[r("vue-draggable",{staticClass:"medimg-viewer-image-dropzone",attrs:{id:`${e.$store.state.appName}-medimg-viewer-image-drop-${e.listIndex}`},model:{value:e.items,callback:function(r){e.items=r},expression:"items"}})],1),e._v(" "),r("div",{ref:"info-text",staticClass:"medimg-viewer-image-placeholder-info"},[!1===e.resource?r("span",[e._v(e._s(e.t("Opening failed, please activate the resource manually")))]):null===e.resource?r("span",[e._v(e._s(e.t("Drop to display an image resource")))]):e._e()])])},i=[];t._withStripped=!0},3560:(e,r,n)=>{var t=n(7093);t.__esModule&&(t=t.default),"string"==typeof t&&(t=[[e.id,t,""]]),t.locals&&(e.exports=t.locals);(0,n(7913).Z)("088c3a64",t,!1,{})}}]);
//# sourceMappingURL=962-amd.js.map?v=d12165b3ee88c9e18c3a