(self.webpackChunkmedimg_viewer=self.webpackChunkmedimg_viewer||[]).push([[527],{1424:(e,r,n)=>{var t=n(4015),i=n(3645)(t);i.push([e.id,"\n.medimg-viewer-dicom-image-interface {\r\n    position: absolute;\r\n    top: 0px;\r\n    left: 0px;\r\n    right: 0px;\r\n    bottom: 0px;\r\n    display: grid;\r\n    grid-template-columns: [left-edge] 300px [divider] auto [right-edge];\r\n    grid-template-rows: [top-edge] 80px [divider] auto [bottom-edge];\r\n    font-family: sans-serif;\r\n    overflow: auto;\r\n    transition: left 0.5s;\n}\n.medimg-viewer-dicom-image-interface.medimg-viewer-sidebar-closed {\r\n        left: -240px;\n}\n.medimg-viewer-dicom-image-interface > .medimg-viewer-sidebar {\r\n        grid-column-start: left-edge;\r\n        grid-column-end: divider;\r\n        grid-row-start: top-edge;\r\n        grid-row-end: bottom-edge;\r\n        overflow: auto;\n}\n.medimg-viewer-dicom-image-interface > .medimg-viewer-toolbar {\r\n        grid-column-start: divider;\r\n        grid-row-start: top-edge;\r\n        grid-row-end: divider;\n}\n.medimg-viewer-dicom-image-interface > .medimg-viewer-media {\r\n        grid-column-start: divider;\r\n        grid-row-start: divider;\r\n        margin: 0 10px 10px 0;\r\n        border: 1px solid var(--medimg-viewer-border-faint);\r\n        overflow: hidden; /* Without this DICOM elements do not scale down */\n}\r\n","",{version:3,sources:["webpack://./src/components/Radiology/Dicom/DicomImageInterface.vue"],names:[],mappings:";AA2lBA;IACA,kBAAA;IACA,QAAA;IACA,SAAA;IACA,UAAA;IACA,WAAA;IACA,aAAA;IACA,oEAAA;IACA,gEAAA;IACA,uBAAA;IACA,cAAA;IACA,qBAAA;AACA;AACA;QACA,YAAA;AACA;AACA;QACA,4BAAA;QACA,wBAAA;QACA,wBAAA;QACA,yBAAA;QACA,cAAA;AACA;AACA;QACA,0BAAA;QACA,wBAAA;QACA,qBAAA;AACA;AACA;QACA,0BAAA;QACA,uBAAA;QACA,qBAAA;QACA,mDAAA;QACA,gBAAA,EAAA,kDAAA;AACA",sourcesContent:["<template>\r\n\r\n    <div :id=\"`${$store.state.appName}-medimg-viewer-dicom-radiology-interface`\"\r\n        :class=\"[\r\n            'medimg-viewer-dicom-image-interface',\r\n            { 'medimg-viewer-sidebar-closed': !sidebarOpen },\r\n        ]\"\r\n    >\r\n        <div class=\"medimg-viewer-toolbar\">\r\n            <radiology-toolbar\r\n                :allLinked=\"allResourcesLinked\"\r\n                :anyActive=\"anyActiveItem\"\r\n                :anyItem=\"resources.length > 0\"\r\n                :anyStack=\"anyActiveStack\"\r\n                :gridLayout.sync=\"gridLayout\"\r\n                :synchronizers=\"synchronizers\"\r\n                v-on:link-all-resources=\"linkAllResources\"\r\n            />\r\n        </div>\r\n        <div class=\"medimg-viewer-sidebar\">\r\n            <radiology-sidebar\r\n                ref=\"sidebar\"\r\n                :allowSorting=\"!gridLayout || !gridLayout[0] || !gridLayout[1]\"\r\n                :dicomItems=\"resources\"\r\n                :hasStudiesToLoad=\"hasStudiesToLoad\"\r\n                v-on:element-status-changed=\"updateElements\"\r\n                v-on:file-dropped=\"handleFileDrop\"\r\n                v-on:item-dropped=\"itemDropped\"\r\n                v-on:load-studies=\"$emit('load-studies')\"\r\n                v-on:update-item-order=\"$emit('update-item-order', $event)\"\r\n            />\r\n        </div>\r\n        <div ref=\"media\" class=\"medimg-viewer-media\">\r\n            <div class=\"medimg-viewer-images\">\r\n                \x3c!-- Add active DICOM images and placeholders --\x3e\r\n                <component v-for=\"(resource, idx) in activeItems\"\r\n                    :is=\"resource ? 'dicom-image-display' : 'dicom-image-placeholder'\"\r\n                    :key=\"`${$store.state.appName}-medimg-viewer-element-${resource ? resource.id : idx}`\"\r\n                    ref=\"dicom-element\"\r\n                    :containerSize=\"mediaContainerSize\"\r\n                    :layoutPosition=\"getElementLayoutPosition(idx)\"\r\n                    :resource=\"resource\"\r\n                    :topogram=\"topogramElement\"\r\n                    :synchronizers=\"synchronizers\"\r\n                    v-on:done-loading=\"updateElements()\"\r\n                    v-on:enable-element-error=\"enableElementError(idx)\"\r\n                />\r\n                \x3c!-- Add a necessary amount of placeholder elements --\x3e\r\n                <dicom-image-placeholder v-for=\"idx in getEmptyLayoutCells()\"\r\n                    :key=\"`${$store.state.appName}-medimg-viewer-placeholder-${idx}`\"\r\n                    :containerSize=\"mediaContainerSize\"\r\n                    :layoutPosition=\"getElementLayoutPosition(idx)\"\r\n                    :resource=\"undefined\"\r\n                />\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n</template>\r\n\r\n<script lang=\"ts\">\r\n\r\nimport Vue from 'vue'\r\nimport * as cornerstone from 'cornerstone-core'\r\nimport cornerstoneMath from 'cornerstone-math'\r\nimport cornerstoneTools from 'cornerstone-tools'\r\nimport Hammer from 'hammerjs'\r\nimport cornerstoneWADOImageLoader from 'cornerstone-wado-image-loader'\r\nimport dicomParser from 'dicom-parser'\r\nimport ResizeObserver from 'resize-observer-polyfill'\r\nimport { FileSystemItem } from '../../../types/common'\r\nimport { DicomImageResource } from '../../../types/radiology'\r\nimport DicomImage from '../../../assets/dicom/DicomImage'\r\nimport DicomImageStack from '../../../assets/dicom/DicomImage'\r\nimport LocalFileLoader from '../../../assets/loaders/LocalFileLoader'\r\n\r\nconst TOOL_COLORS = {\r\n    BLUE: '#C0DDF0',\r\n    GRAY: '#E0E0E0',\r\n    GREEN: '#C0FFC0',\r\n    ORANGE: '#F0DDC0',\r\n    RED: '#FFC0C0',\r\n    WHITE: '#FFFFFF',\r\n    YELLOW: '#FFFFC0',\r\n}\r\nconst TOPOGRAM_NAME = '_topogram'\r\n\r\nexport default Vue.extend({\r\n    components: {\r\n        RadiologySidebar: () => import('../RadiologySidebar.vue'),\r\n        RadiologyToolbar: () => import('../RadiologyToolbar.vue'),\r\n        DicomImageDisplay: () => import('./DicomImageDisplay.vue'),\r\n        DicomImagePlaceholder: () => import('./DicomImagePlaceholder.vue'),\r\n    },\r\n    props: {\r\n        hasStudiesToLoad: Boolean,\r\n        resources: Array,\r\n        sidebarOpen: Boolean,\r\n    },\r\n    data () {\r\n        return {\r\n            synchronizers: {\r\n                crosshairs: null as unknown,\r\n                referenceLines: null as unknown,\r\n                stackScroll: null as unknown,\r\n                lastUpdatedTopo: null as any,\r\n            },\r\n            // Loaded elements\r\n            topogramElement: null as null | DicomImage,\r\n            gridLayout: null as null | number[],\r\n            elementPositions: [] as number[],\r\n            failedElement: null as number | null,\r\n            pendingElements: [] as number[],\r\n            // Other properties\r\n            ctrlDown: false,\r\n            ctrlRegistered: false,\r\n            mediaContainerSize: [0, 0],\r\n            themeChange: 0,\r\n            wadoImageLoader: null,\r\n            // React to some property changes\r\n            elementsChanged: 0,\r\n        }\r\n    },\r\n    watch: {\r\n        gridLayout: function (value: any, old: any) {\r\n            // If we switch from automatic layout to a set layout, reset element positions\r\n            // and active elements\r\n            if (value && value[0] && value[1] && (!old || !old[0] || !old[1])) {\r\n                this.elementPositions = []\r\n                ;(this.resources as DicomImageResource[]).forEach((res) => {\r\n                    res.isActive = false\r\n                })\r\n            }\r\n        },\r\n    },\r\n    computed: {\r\n        activeItems (): (DicomImage | null | false)[] {\r\n            this.elementsChanged\r\n            if (!this.mediaContainerSize[0] || !this.mediaContainerSize[1]) {\r\n                // Wait until container DOM is done loading\r\n                return []\r\n            }\r\n            // Array.filter is a pain to make work in TypeScript\r\n            const items = [] as (DicomImage | null | false)[]\r\n            if (this.gridLayout === null || !this.gridLayout[0] || !this.gridLayout[1]) {\r\n                // Now, element display depends on the display mode\r\n                // For simple, automatic arrangement we will display any active images\r\n                for (let i=0; i<this.resources.length; i++) {\r\n                    const resource = this.resources[i] as DicomImage\r\n                    if (resource.isActive) {\r\n                        items.push(resource)\r\n                    }\r\n                    // Make sure we don't exceed predefined grid dimensions\r\n                    if (this.gridLayout && this.gridLayout[0] && this.gridLayout[1]\r\n                        && i === this.gridLayout[0]*this.gridLayout[1]\r\n                    ) {\r\n                        return items\r\n                    }\r\n                }\r\n            } else {\r\n                // For preset grid dimensions, we will have to keep track of image positions\r\n                // within the grid and fill the gaps with empty elements.\r\n                layout_loop:\r\n                for (let i=0; i<this.gridLayout[0]*this.gridLayout[1]; i++) {\r\n                    // If an element is positioned here, show it; else show a placeholder.\r\n                    for (let j=0; j<this.resources.length; j++) {\r\n                        if (this.elementPositions[j] === i && (this.resources[j] as DicomImage).isActive) {\r\n                            items.push(this.resources[j] as DicomImage)\r\n                            continue layout_loop\r\n                        }\r\n                    }\r\n                    items.push(null)\r\n                }\r\n            }\r\n            // Check if we need to reload an element\r\n            if (this.failedElement !== null) {\r\n                const failEl = this.gridLayout === null || !this.gridLayout[0] || !this.gridLayout[1]\r\n                               ? items.splice(this.failedElement, 1)[0]\r\n                               : items.splice(this.failedElement, 1, false)[0]\r\n                ;(failEl as DicomImage).isActive = false\r\n                // Remove from position list\r\n                const failIdx = this.resources.indexOf(failEl)\r\n                if (this.pendingElements.indexOf(failIdx) === -1) {\r\n                    this.pendingElements.push(failIdx)\r\n                }\r\n                ;(this.$refs['sidebar'] as any).setItemNotice(failIdx, this.t('Activate item manually'))\r\n                this.failedElement = null\r\n            } else if (this.pendingElements.length) {\r\n                // Clear possible reactivated pending elements\r\n                for (let i=0; i<this.pendingElements.length; i++) {\r\n                    if ((this.resources[this.pendingElements[i]] as DicomImage).isActive) {\r\n                        ;(this.$refs['sidebar'] as any).setItemNotice(this.pendingElements[i], null)\r\n                        this.pendingElements.splice(i, 1)\r\n                        i--\r\n                    }\r\n                }\r\n            }\r\n            return items\r\n        },\r\n        allResourcesLinked (): boolean {\r\n            this.elementsChanged\r\n            if (!this.resources.length) {\r\n                // Show link icon if there are no elements\r\n                return false\r\n            }\r\n            let someLinkable = false\r\n            const items = this.activeItems\r\n            for (let i=0; i<items.length; i++) {\r\n                if (items[i] && (items[i] as DicomImage).isStack) {\r\n                    if (!(items[i] as DicomImage).isLinked) {\r\n                        return false\r\n                    } else if (!someLinkable) {\r\n                        // Check that at least some of the active elements can be linked;\r\n                        // show the unlinked icon otherwise\r\n                        someLinkable = true\r\n                    }\r\n                }\r\n            }\r\n            return someLinkable\r\n        },\r\n        anyActiveItem (): boolean {\r\n            // Active items array may include null items, so check if there are any actual items\r\n            for (const item of this.activeItems) {\r\n                if (item) {\r\n                    return true\r\n                }\r\n            }\r\n            return false\r\n        },\r\n        anyActiveStack (): boolean {\r\n            for (const item of this.activeItems) {\r\n                if (item && item.isStack) {\r\n                    return true\r\n                }\r\n            }\r\n            return false\r\n        }\r\n    },\r\n    methods: {\r\n        /** Shorthand for component-specific translations */\r\n        t: function (str: string, args?: any) {\r\n            if (args) {\r\n                return this.$t(`components.Radiology.Dicom.DicomImageInterface.${str}`, args)\r\n            } else {\r\n                return (this.$t('components.Radiology.Dicom.DicomImageInterface') as any)[str]\r\n            }\r\n        },\r\n        addFileAsImage: function (file: File, overrideName?: string) {\r\n            const imageId = cornerstoneWADOImageLoader.wadouri.fileManager.add(file)\r\n            if (imageId) {\r\n                // Check if this image is a topogram\r\n                if (file.name === TOPOGRAM_NAME || overrideName === TOPOGRAM_NAME) {\r\n                    this.topogramElement = new DicomImage('', file.name, file.size, 'image:topogram', imageId)\r\n                } else {\r\n                    (this.resources as DicomImage[]).push(new DicomImage(\r\n                        '',\r\n                        overrideName ? overrideName : file.name,\r\n                        file.size,\r\n                        '',\r\n                        imageId\r\n                    ))\r\n                    this.updateElements()\r\n                }\r\n            }\r\n        },\r\n        addFilesAsImageStack: function (files: File[], name: string) {\r\n            if (!files.length) {\r\n                return\r\n            }\r\n            const imgStack = new DicomImage('', name || 'Image stack', files.length, 'image:stack', '')\r\n            for (let i=0; i<files.length; i++) {\r\n                const imageId = cornerstoneWADOImageLoader.wadouri.fileManager.add(files[i])\r\n                if (imageId) {\r\n                    imgStack.push(\r\n                        new DicomImage('', files[i].name, files[i].size, 'image', imageId)\r\n                    )\r\n                }\r\n            }\r\n            // Don't add an empty image stack\r\n            if (imgStack.length) {\r\n                // Add cover image\r\n                (this.resources as DicomImage[]).push(imgStack)\r\n            }\r\n            this.updateElements()\r\n        },\r\n        /**\r\n         * Enabling an image element failed for some reason, retry\r\n         */\r\n        enableElementError: function (idx: number) {\r\n            this.failedElement = idx\r\n        },\r\n        getElementLayoutPosition: function (idx: number): number[][] {\r\n            const activeNum = this.activeItems.length\r\n            const layout = this.gridLayout ? [...this.gridLayout] : [0, 0]\r\n            if (!layout[0] && !layout[1]) {\r\n                // Calculate grid dimensions automatically.\r\n                // Number of colums >= number of rows, i.e. expand columns before rows.\r\n                layout[0] = Math.ceil(Math.sqrt(activeNum))\r\n            } else if (!layout[0]) {\r\n                // Only cols are undefined\r\n                layout[0] = Math.ceil(activeNum/layout[1])\r\n            }\r\n            if (!layout[1]) {\r\n                // Calculate grid rows\r\n                layout[1] = Math.ceil(activeNum/layout[0])\r\n            }\r\n            // Calculate element position within the layout grid\r\n            const colPos = Math.floor(idx/layout[0])\r\n            const rowPos = idx%layout[0]\r\n            return [[rowPos, layout[0]], [colPos, layout[1]]]\r\n        },\r\n        getEmptyLayoutCells: function (): number[] {\r\n            const activeNum = this.activeItems.length\r\n            const layout = this.gridLayout ? [...this.gridLayout] : [0, 0]\r\n            if (!layout[0] && !layout[1]) {\r\n                // Calculate grid dimensions automatically.\r\n                // Number of colums >= number of rows, i.e. expand columns before rows.\r\n                layout[0] = Math.ceil(Math.sqrt(activeNum))\r\n            } else if (!layout[0]) {\r\n                // Only cols are undefined\r\n                layout[0] = Math.ceil(activeNum/layout[1])\r\n            }\r\n            if (!layout[1]) {\r\n                // Calculate grid rows\r\n                layout[1] = Math.ceil(activeNum/layout[0])\r\n            }\r\n            const totalCells = layout[0]*layout[1]\r\n            const indices = []\r\n            for (let i=activeNum; i<totalCells; i++) {\r\n                indices.push(i)\r\n            }\r\n            return indices\r\n        },\r\n        getItemById: function (id: string): DicomImage | undefined {\r\n            for (let i=0; i<this.resources.length; i++) {\r\n                const resource = this.resources[i] as DicomImage\r\n                if (resource.id === id) {\r\n                    return resource\r\n                }\r\n            }\r\n            return undefined\r\n        },\r\n        /**\r\n         * Handle a file or directory dropped in the dropzone\r\n         * @param event\r\n         */\r\n        handleFileDrop: async function (event: DragEvent) {\r\n            (this.$root as any).handleFileDrop(event)\r\n        },\r\n        isElementActive: function (id: string): boolean {\r\n            const items = this.activeItems\r\n            for (let i=0; i<items.length; i++) {\r\n                if (items[i] && (items[i] as DicomImage).id === id) {\r\n                    return true\r\n                }\r\n            }\r\n            return false\r\n        },\r\n        isElementLinked: function (id: string): boolean {\r\n            const items = this.activeItems\r\n            for (let i=0; i<items.length; i++) {\r\n                if (items[i] && (items[i] as DicomImage).id === id) {\r\n                    // @ts-ignore: TSLint doesn't understand that items[i] cannot be null\r\n                    return items[i].isStack ? items[i].isLinked : false\r\n                }\r\n            }\r\n            return false\r\n        },\r\n        itemDropped: function (props: any) {\r\n            // Check if there is an inactive element already assigned to the slot\r\n            for (let i=0; i<this.resources.length; i++) {\r\n                if (this.elementPositions[i] === props.target) {\r\n                    delete this.elementPositions[i]\r\n                }\r\n            }\r\n            this.elementPositions[props.item] = props.target\r\n            this.elementsChanged++\r\n        },\r\n        linkAllResources: function (value: boolean) {\r\n            for (let i=0; i<this.resources.length; i++) {\r\n                const resource = this.resources[i] as DicomImage\r\n                if (resource.isActive && resource.isStack\r\n                    && resource.isLinked !== value\r\n                ) {\r\n                    if (value) {\r\n                        (this.resources[i] as DicomImage)\r\n                        .link(this.$store.state.linkedScrollPosition)\r\n                    } else {\r\n                        (this.resources[i] as DicomImage).unlink()\r\n                    }\r\n                }\r\n            }\r\n        },\r\n        mediaResized: function () {\r\n            // Check that the element still exists (this method is also fired when the component is destroyed)\r\n            const mediaEl = this.$refs['media'] as HTMLElement\r\n            if (!mediaEl) {\r\n                return\r\n            }\r\n            // Deduct padding and borders from element dimensions\r\n            this.mediaContainerSize = [\r\n                mediaEl.offsetWidth - 2,\r\n                mediaEl.offsetHeight - 2\r\n            ]\r\n        },\r\n        removeDICOMResource: function (id: string) {\r\n            for (let i=0; i<this.resources.length; i++) {\r\n                const resource = this.resources[i] as DicomImage\r\n                if (resource.id === id) {\r\n                    resource.removeFromCache()\r\n                    this.resources.splice(i, 1)\r\n                    this.updateElements()\r\n                }\r\n            }\r\n        },\r\n        setGridLayout: function (layout: number[] | null) {\r\n            this.gridLayout = layout\r\n        },\r\n        toggleColorTheme: function (light?: boolean) {\r\n            const appEl = document.getElementById(`${this.$store.state.appName}-medimg-viewer`)\r\n            if (appEl) {\r\n                appEl.classList.add('medimg-viewer-theme-change')\r\n                this.$nextTick(() => {\r\n                    if (light === undefined) {\r\n                        if (appEl.classList.contains('medimg-viewer-dark-mode')) {\r\n                            appEl.classList.remove('medimg-viewer-dark-mode')\r\n                            appEl.classList.add('medimg-viewer-light-mode')\r\n                        } else {\r\n                            appEl.classList.remove('medimg-viewer-light-mode')\r\n                            appEl.classList.add('medimg-viewer-dark-mode')\r\n                        }\r\n                    } else if (light) {\r\n                        appEl.classList.remove('medimg-viewer-dark-mode')\r\n                        appEl.classList.add('medimg-viewer-light-mode')\r\n                    } else {\r\n                        appEl.classList.remove('medimg-viewer-light-mode')\r\n                        appEl.classList.add('medimg-viewer-dark-mode')\r\n                    }\r\n                })\r\n                if (this.themeChange) {\r\n                    window.clearTimeout(this.themeChange)\r\n                }\r\n                // Two reasons for the timeout:\r\n                // 1. Don't want the transition outside of color theme change\r\n                // 2. It forces Chromium browsers to update the color of text and icons\r\n                //    (which sometimes takes AGES, for some reason)\r\n                this.themeChange = window.setTimeout(() => {\r\n                    appEl.classList.remove('medimg-viewer-theme-change')\r\n                }, 2100)\r\n            }\r\n        },\r\n        /**\r\n         * Keep track of loaded elements and force a reactive update on the element list.\r\n         */\r\n        updateElements: function () {\r\n            this.$nextTick(() => {\r\n                this.elementsChanged++\r\n            })\r\n            for (const res of (this.resources as DicomImage[])) {\r\n                if (res.isActive && res.preloaded !== res.images.length &&\r\n                    !this.$store.state.imageResourceLoading\r\n                ) {\r\n                    // This image resource is not yet done loading\r\n                    this.$store.commit('set-image-resource-loading', true)\r\n                    return\r\n                }\r\n            }\r\n            this.$store.commit('set-image-resource-loading', false)\r\n        },\r\n    },\r\n    mounted () {\r\n        // Set up Cornerstone Tools\r\n        cornerstoneTools.external.cornerstone = cornerstone\r\n        cornerstoneTools.external.cornerstoneMath = cornerstoneMath\r\n        cornerstoneTools.external.Hammer = Hammer\r\n        cornerstoneTools.init({\r\n            showSVGCursors: true\r\n        })\r\n        // Set a more neutral tool color\r\n        // TODO: Allow selecting the tool color?\r\n        cornerstoneTools.toolColors.setToolColor(TOOL_COLORS.YELLOW)\r\n        cornerstoneTools.toolColors.setActiveColor(TOOL_COLORS.YELLOW)\r\n        // Set up WADO Image Loader\r\n        cornerstoneWADOImageLoader.external.cornerstone = cornerstone\r\n        cornerstoneWADOImageLoader.external.dicomParser = dicomParser\r\n        // Reference lines synchronizer\r\n        this.synchronizers.crosshairs = new cornerstoneTools.Synchronizer(\r\n            'cornerstonenewimage',\r\n            (synchronizer: any, source: any, target: any, event: any) => {\r\n                if (source === target) {\r\n                    return\r\n                }\r\n                // Get the item id from element id\r\n                const srcId = source.id.split('-')\r\n                const tgtId = target.id.split('-')\r\n                // Only synchronize linked elements\r\n                if (!this.isElementLinked(srcId[1]) || !this.isElementLinked(tgtId[1])) {\r\n                    // Source or target is not linked, or they are the same element\r\n                    // This doesn't work at the moment, because an update is triggered via the reference line synchronizer\r\n                    return\r\n                }\r\n                cornerstoneTools.updateImageSynchronizer(synchronizer, source, target, event)\r\n            }\r\n        )\r\n        // Stack scroll synchronizer\r\n        this.synchronizers.stackScroll = new cornerstoneTools.Synchronizer(\r\n            'cornerstonetoolsstackscroll',\r\n            (synchronizer: any, source: any, target: any, event: any) => {\r\n                if (source === target) {\r\n                    return\r\n                }\r\n                // Get the item id from element id\r\n                const srcId = source.id.split('-')\r\n                const tgtId = target.id.split('-')\r\n                let srcEl, tgtEl = null\r\n                for (let i=0; i<this.resources.length; i++) {\r\n                    const resource = this.resources[i] as DicomImage\r\n                    if (resource.id === srcId[1]) {\r\n                        srcEl = this.resources[i]\r\n                    } else if (resource.id === tgtId[1]) {\r\n                        tgtEl = this.resources[i]\r\n                    }\r\n                }\r\n                // Make sure that this is an actual active element and an actual scroll event\r\n                if (srcEl === null || !this.isElementActive(srcId[1]) || !event) {\r\n                    return\r\n                }\r\n                // Synchronize stack position\r\n                srcEl = (srcEl as DicomImageStack)\r\n                srcEl.currentPosition = event.newImageIdIndex\r\n                // Check if control key is down (force scroll)\r\n                if (this.ctrlDown) {\r\n                    const relPos = (srcEl.currentPosition - (srcEl.linkedPosition || 0))/srcEl.images.length\r\n                            + (srcEl.masterLinkPosition || 0)\r\n                    this.$store.commit('set-linked-scroll-position', { origin: srcId[1], position: relPos })\r\n                    return\r\n                }\r\n                // Determine if target element should be synchronized with source element\r\n                if (!this.isElementLinked(srcId[1]) || !this.isElementLinked(tgtId[1])) {\r\n                    // Source or target is not linked\r\n                    return\r\n                }\r\n                const enabledSrc: any = cornerstone.getEnabledElement(source)\r\n                const enabledTgt: any = cornerstone.getEnabledElement(target)\r\n                // Check that all required metadata is available\r\n                if (!enabledSrc.image || !enabledTgt.image ||\r\n                    !enabledSrc.image.imageId || !enabledTgt.image.imageId\r\n                ) {\r\n                    return\r\n                }\r\n                const sourcePlane: any = (cornerstone.metaData.get('imagePlaneModule', enabledSrc.image.imageId) as any)\r\n                const targetPlane: any = (cornerstone.metaData.get('imagePlaneModule', enabledTgt.image.imageId) as any)\r\n                if (!sourcePlane || !sourcePlane.columnCosines || !sourcePlane.rowCosines ||\r\n                    !targetPlane || !targetPlane.columnCosines || !targetPlane.rowCosines\r\n                ) {\r\n                    return\r\n                }\r\n                // The built-in synchronizer may attemp to synchronize images in different orientations, which may lead to weird results.\r\n                // Check for compatible orientations by calculating the angle between the two image plane vectors.\r\n                const sourceV = (new cornerstoneMath.Vector3(...sourcePlane.columnCosines))\r\n                                .cross(new cornerstoneMath.Vector3(...sourcePlane.rowCosines))\r\n                const targetV = (new cornerstoneMath.Vector3(...targetPlane.columnCosines))\r\n                                .cross(new cornerstoneMath.Vector3(...targetPlane.rowCosines))\r\n                // Tolerance of Pi/12 = 15 degrees.\r\n                // A difference of 1*Pi means the vectors are inverted, but at least flipping the view doesn't result in this.\r\n                // Will have to consider adding a special case if such examples turn up later.\r\n                if (sourceV.angleTo(targetV) > Math.PI/12) {\r\n                    return\r\n                }\r\n                // We can use the built-in synchronizer for images that have nearly or examptly the same orientation\r\n                cornerstoneTools.stackImagePositionSynchronizer(synchronizer, source, target, event)\r\n            }\r\n        )\r\n        // Set up resize observer for the media container\r\n        new ResizeObserver(this.mediaResized).observe((this.$refs['media'] as Element))\r\n        // Monitor control key down state\r\n        document.addEventListener('keydown', (e) => {\r\n            if (e.key === 'Control' && !this.ctrlRegistered) {\r\n                // Refresh linked position and master stack position in each active stack element\r\n                const items = this.activeItems\r\n                for (let i=0; i<items.length; i++) {\r\n                    if (items[i] && (items[i] as DicomImage).isStack && (items[i] as DicomImage).isLinked) {\r\n                        (items[i] as DicomImage).link(this.$store.state.linkedScrollPosition)\r\n                    }\r\n                }\r\n                this.ctrlDown = true\r\n                this.ctrlRegistered = true // Prevent event from registering repeatedly\r\n            }\r\n        })\r\n        // Listen to root emits\r\n        this.$root.$on('remove-dicom-resource', this.removeDICOMResource)\r\n        document.addEventListener('keyup', (e) => {\r\n            if (e.key === 'Control') {\r\n                this.ctrlDown = false\r\n                this.ctrlRegistered = false\r\n            }\r\n        })\r\n    },\r\n})\r\n\r\n<\/script>\r\n\r\n<style>\r\n.medimg-viewer-dicom-image-interface {\r\n    position: absolute;\r\n    top: 0px;\r\n    left: 0px;\r\n    right: 0px;\r\n    bottom: 0px;\r\n    display: grid;\r\n    grid-template-columns: [left-edge] 300px [divider] auto [right-edge];\r\n    grid-template-rows: [top-edge] 80px [divider] auto [bottom-edge];\r\n    font-family: sans-serif;\r\n    overflow: auto;\r\n    transition: left 0.5s;\r\n}\r\n    .medimg-viewer-dicom-image-interface.medimg-viewer-sidebar-closed {\r\n        left: -240px;\r\n    }\r\n    .medimg-viewer-dicom-image-interface > .medimg-viewer-sidebar {\r\n        grid-column-start: left-edge;\r\n        grid-column-end: divider;\r\n        grid-row-start: top-edge;\r\n        grid-row-end: bottom-edge;\r\n        overflow: auto;\r\n    }\r\n    .medimg-viewer-dicom-image-interface > .medimg-viewer-toolbar {\r\n        grid-column-start: divider;\r\n        grid-row-start: top-edge;\r\n        grid-row-end: divider;\r\n    }\r\n    .medimg-viewer-dicom-image-interface > .medimg-viewer-media {\r\n        grid-column-start: divider;\r\n        grid-row-start: divider;\r\n        margin: 0 10px 10px 0;\r\n        border: 1px solid var(--medimg-viewer-border-faint);\r\n        overflow: hidden; /* Without this DICOM elements do not scale down */\r\n    }\r\n</style>\r\n"],sourceRoot:""}]),e.exports=i},5296:(e,r,n)=>{"use strict";n.d(r,{Z:()=>w});var t=n(5798),i=n.n(t),s=n(1653),o=n(7368),a=n.n(o),l=n(2790),m=n.n(l),d=n(7448),c=n.n(d),u=n(2263),g=n.n(u),h=n(7542),f=n.n(h),p=n(1033),y=n(3226);const v="#FFFFC0",A="_topogram",w=i().extend({components:{RadiologySidebar:()=>Promise.all([n.e(980),n.e(896)]).then(n.bind(n,5896)),RadiologyToolbar:()=>n.e(818).then(n.bind(n,5818)),DicomImageDisplay:()=>n.e(730).then(n.bind(n,2730)),DicomImagePlaceholder:()=>Promise.all([n.e(980),n.e(962)]).then(n.bind(n,1962))},props:{hasStudiesToLoad:Boolean,resources:Array,sidebarOpen:Boolean},data:()=>({synchronizers:{crosshairs:null,referenceLines:null,stackScroll:null,lastUpdatedTopo:null},topogramElement:null,gridLayout:null,elementPositions:[],failedElement:null,pendingElements:[],ctrlDown:!1,ctrlRegistered:!1,mediaContainerSize:[0,0],themeChange:0,wadoImageLoader:null,elementsChanged:0}),watch:{gridLayout:function(e,r){!(e&&e[0]&&e[1])||r&&r[0]&&r[1]||(this.elementPositions=[],this.resources.forEach((e=>{e.isActive=!1})))}},computed:{activeItems(){if(this.elementsChanged,!this.mediaContainerSize[0]||!this.mediaContainerSize[1])return[];const e=[];if(null!==this.gridLayout&&this.gridLayout[0]&&this.gridLayout[1])e:for(let r=0;r<this.gridLayout[0]*this.gridLayout[1];r++){for(let n=0;n<this.resources.length;n++)if(this.elementPositions[n]===r&&this.resources[n].isActive){e.push(this.resources[n]);continue e}e.push(null)}else for(let r=0;r<this.resources.length;r++){const n=this.resources[r];if(n.isActive&&e.push(n),this.gridLayout&&this.gridLayout[0]&&this.gridLayout[1]&&r===this.gridLayout[0]*this.gridLayout[1])return e}if(null!==this.failedElement){const r=null!==this.gridLayout&&this.gridLayout[0]&&this.gridLayout[1]?e.splice(this.failedElement,1,!1)[0]:e.splice(this.failedElement,1)[0];r.isActive=!1;const n=this.resources.indexOf(r);-1===this.pendingElements.indexOf(n)&&this.pendingElements.push(n),this.$refs.sidebar.setItemNotice(n,this.t("Activate item manually")),this.failedElement=null}else if(this.pendingElements.length)for(let e=0;e<this.pendingElements.length;e++)this.resources[this.pendingElements[e]].isActive&&(this.$refs.sidebar.setItemNotice(this.pendingElements[e],null),this.pendingElements.splice(e,1),e--);return e},allResourcesLinked(){if(this.elementsChanged,!this.resources.length)return!1;let e=!1;const r=this.activeItems;for(let n=0;n<r.length;n++)if(r[n]&&r[n].isStack){if(!r[n].isLinked)return!1;e||(e=!0)}return e},anyActiveItem(){for(const e of this.activeItems)if(e)return!0;return!1},anyActiveStack(){for(const e of this.activeItems)if(e&&e.isStack)return!0;return!1}},methods:{t:function(e,r){return r?this.$t(`components.Radiology.Dicom.DicomImageInterface.${e}`,r):this.$t("components.Radiology.Dicom.DicomImageInterface")[e]},addFileAsImage:function(e,r){const n=g().wadouri.fileManager.add(e);n&&(e.name===A||r===A?this.topogramElement=new y.Z("",e.name,e.size,"image:topogram",n):(this.resources.push(new y.Z("",r||e.name,e.size,"",n)),this.updateElements()))},addFilesAsImageStack:function(e,r){if(!e.length)return;const n=new y.Z("",r||"Image stack",e.length,"image:stack","");for(let r=0;r<e.length;r++){const t=g().wadouri.fileManager.add(e[r]);t&&n.push(new y.Z("",e[r].name,e[r].size,"image",t))}n.length&&this.resources.push(n),this.updateElements()},enableElementError:function(e){this.failedElement=e},getElementLayoutPosition:function(e){const r=this.activeItems.length,n=this.gridLayout?[...this.gridLayout]:[0,0];n[0]||n[1]?n[0]||(n[0]=Math.ceil(r/n[1])):n[0]=Math.ceil(Math.sqrt(r)),n[1]||(n[1]=Math.ceil(r/n[0]));const t=Math.floor(e/n[0]);return[[e%n[0],n[0]],[t,n[1]]]},getEmptyLayoutCells:function(){const e=this.activeItems.length,r=this.gridLayout?[...this.gridLayout]:[0,0];r[0]||r[1]?r[0]||(r[0]=Math.ceil(e/r[1])):r[0]=Math.ceil(Math.sqrt(e)),r[1]||(r[1]=Math.ceil(e/r[0]));const n=r[0]*r[1],t=[];for(let r=e;r<n;r++)t.push(r);return t},getItemById:function(e){for(let r=0;r<this.resources.length;r++){const n=this.resources[r];if(n.id===e)return n}},handleFileDrop:async function(e){this.$root.handleFileDrop(e)},isElementActive:function(e){const r=this.activeItems;for(let n=0;n<r.length;n++)if(r[n]&&r[n].id===e)return!0;return!1},isElementLinked:function(e){const r=this.activeItems;for(let n=0;n<r.length;n++)if(r[n]&&r[n].id===e)return!!r[n].isStack&&r[n].isLinked;return!1},itemDropped:function(e){for(let r=0;r<this.resources.length;r++)this.elementPositions[r]===e.target&&delete this.elementPositions[r];this.elementPositions[e.item]=e.target,this.elementsChanged++},linkAllResources:function(e){for(let r=0;r<this.resources.length;r++){const n=this.resources[r];n.isActive&&n.isStack&&n.isLinked!==e&&(e?this.resources[r].link(this.$store.state.linkedScrollPosition):this.resources[r].unlink())}},mediaResized:function(){const e=this.$refs.media;e&&(this.mediaContainerSize=[e.offsetWidth-2,e.offsetHeight-2])},removeDICOMResource:function(e){for(let r=0;r<this.resources.length;r++){const n=this.resources[r];n.id===e&&(n.removeFromCache(),this.resources.splice(r,1),this.updateElements())}},setGridLayout:function(e){this.gridLayout=e},toggleColorTheme:function(e){const r=document.getElementById(`${this.$store.state.appName}-medimg-viewer`);r&&(r.classList.add("medimg-viewer-theme-change"),this.$nextTick((()=>{void 0===e?r.classList.contains("medimg-viewer-dark-mode")?(r.classList.remove("medimg-viewer-dark-mode"),r.classList.add("medimg-viewer-light-mode")):(r.classList.remove("medimg-viewer-light-mode"),r.classList.add("medimg-viewer-dark-mode")):e?(r.classList.remove("medimg-viewer-dark-mode"),r.classList.add("medimg-viewer-light-mode")):(r.classList.remove("medimg-viewer-light-mode"),r.classList.add("medimg-viewer-dark-mode"))})),this.themeChange&&window.clearTimeout(this.themeChange),this.themeChange=window.setTimeout((()=>{r.classList.remove("medimg-viewer-theme-change")}),2100))},updateElements:function(){this.$nextTick((()=>{this.elementsChanged++}));for(const e of this.resources)if(e.isActive&&e.preloaded!==e.images.length&&!this.$store.state.imageResourceLoading)return void this.$store.commit("set-image-resource-loading",!0);this.$store.commit("set-image-resource-loading",!1)}},mounted(){m().external.cornerstone=s,m().external.cornerstoneMath=a(),m().external.Hammer=c(),m().init({showSVGCursors:!0}),m().toolColors.setToolColor(v),m().toolColors.setActiveColor(v),g().external.cornerstone=s,g().external.dicomParser=f(),this.synchronizers.crosshairs=new(m().Synchronizer)("cornerstonenewimage",((e,r,n,t)=>{if(r===n)return;const i=r.id.split("-"),s=n.id.split("-");this.isElementLinked(i[1])&&this.isElementLinked(s[1])&&m().updateImageSynchronizer(e,r,n,t)})),this.synchronizers.stackScroll=new(m().Synchronizer)("cornerstonetoolsstackscroll",((e,r,n,t)=>{if(r===n)return;const i=r.id.split("-"),o=n.id.split("-");let l,d=null;for(let e=0;e<this.resources.length;e++){const r=this.resources[e];r.id===i[1]?l=this.resources[e]:r.id===o[1]&&(d=this.resources[e])}if(null===l||!this.isElementActive(i[1])||!t)return;if(l.currentPosition=t.newImageIdIndex,this.ctrlDown){const e=(l.currentPosition-(l.linkedPosition||0))/l.images.length+(l.masterLinkPosition||0);return void this.$store.commit("set-linked-scroll-position",{origin:i[1],position:e})}if(!this.isElementLinked(i[1])||!this.isElementLinked(o[1]))return;const c=s.getEnabledElement(r),u=s.getEnabledElement(n);if(!(c.image&&u.image&&c.image.imageId&&u.image.imageId))return;const g=s.metaData.get("imagePlaneModule",c.image.imageId),h=s.metaData.get("imagePlaneModule",u.image.imageId);if(!(g&&g.columnCosines&&g.rowCosines&&h&&h.columnCosines&&h.rowCosines))return;const f=new(a().Vector3)(...g.columnCosines).cross(new(a().Vector3)(...g.rowCosines)),p=new(a().Vector3)(...h.columnCosines).cross(new(a().Vector3)(...h.rowCosines));f.angleTo(p)>Math.PI/12||m().stackImagePositionSynchronizer(e,r,n,t)})),new p.Z(this.mediaResized).observe(this.$refs.media),document.addEventListener("keydown",(e=>{if("Control"===e.key&&!this.ctrlRegistered){const e=this.activeItems;for(let r=0;r<e.length;r++)e[r]&&e[r].isStack&&e[r].isLinked&&e[r].link(this.$store.state.linkedScrollPosition);this.ctrlDown=!0,this.ctrlRegistered=!0}})),this.$root.$on("remove-dicom-resource",this.removeDICOMResource),document.addEventListener("keyup",(e=>{"Control"===e.key&&(this.ctrlDown=!1,this.ctrlRegistered=!1)}))}})},1543:(e,r,n)=>{"use strict";n.r(r),n.d(r,{default:()=>s});var t=n(3437),i=n(3130);n(5405);const s=(0,n(8758).Z)(i.Z,t.s,t.x,!1,null,null,null).exports},3130:(e,r,n)=>{"use strict";n.d(r,{Z:()=>t});const t=n(5296).Z},3437:(e,r,n)=>{"use strict";n.d(r,{s:()=>t.s,x:()=>t.x});var t=n(2042)},5405:(e,r,n)=>{"use strict";n(5357)},2042:(e,r,n)=>{"use strict";n.d(r,{s:()=>t,x:()=>i});var t=function(){var e=this,r=e._self._c;e._self._setupProxy;return r("div",{class:["medimg-viewer-dicom-image-interface",{"medimg-viewer-sidebar-closed":!e.sidebarOpen}],attrs:{id:`${e.$store.state.appName}-medimg-viewer-dicom-radiology-interface`}},[r("div",{staticClass:"medimg-viewer-toolbar"},[r("radiology-toolbar",{attrs:{allLinked:e.allResourcesLinked,anyActive:e.anyActiveItem,anyItem:e.resources.length>0,anyStack:e.anyActiveStack,gridLayout:e.gridLayout,synchronizers:e.synchronizers},on:{"update:gridLayout":function(r){e.gridLayout=r},"update:grid-layout":function(r){e.gridLayout=r},"link-all-resources":e.linkAllResources}})],1),e._v(" "),r("div",{staticClass:"medimg-viewer-sidebar"},[r("radiology-sidebar",{ref:"sidebar",attrs:{allowSorting:!e.gridLayout||!e.gridLayout[0]||!e.gridLayout[1],dicomItems:e.resources,hasStudiesToLoad:e.hasStudiesToLoad},on:{"element-status-changed":e.updateElements,"file-dropped":e.handleFileDrop,"item-dropped":e.itemDropped,"load-studies":function(r){return e.$emit("load-studies")},"update-item-order":function(r){return e.$emit("update-item-order",r)}}})],1),e._v(" "),r("div",{ref:"media",staticClass:"medimg-viewer-media"},[r("div",{staticClass:"medimg-viewer-images"},[e._l(e.activeItems,(function(n,t){return r(n?"dicom-image-display":"dicom-image-placeholder",{key:`${e.$store.state.appName}-medimg-viewer-element-${n?n.id:t}`,ref:"dicom-element",refInFor:!0,tag:"component",attrs:{containerSize:e.mediaContainerSize,layoutPosition:e.getElementLayoutPosition(t),resource:n,topogram:e.topogramElement,synchronizers:e.synchronizers},on:{"done-loading":function(r){return e.updateElements()},"enable-element-error":function(r){return e.enableElementError(t)}}})})),e._v(" "),e._l(e.getEmptyLayoutCells(),(function(n){return r("dicom-image-placeholder",{key:`${e.$store.state.appName}-medimg-viewer-placeholder-${n}`,attrs:{containerSize:e.mediaContainerSize,layoutPosition:e.getElementLayoutPosition(n),resource:void 0}})}))],2)])])},i=[];t._withStripped=!0},5357:(e,r,n)=>{var t=n(1424);t.__esModule&&(t=t.default),"string"==typeof t&&(t=[[e.id,t,""]]),t.locals&&(e.exports=t.locals);(0,n(7913).Z)("428b7064",t,!1,{})}}]);
//# sourceMappingURL=radiology-amd.js.map?v=c72897ad71b73595b4fd