/*! For license information please see viewer-amd.js.LICENSE.txt */
(self.webpackChunkmedimg_viewer=self.webpackChunkmedimg_viewer||[]).push([[428],{6355:(e,t,i)=>{var r=i(4015),n=i(3645)(r);n.push([e.id,"\r\n/* Global app styles */\n.medimg-viewer-theme-change, .medimg-viewer-theme-change * {\r\n    -ms-transition: background-color 1.0s ease, border-color 1.0s ease;\r\n    -moz-transition: background-color 1.0s ease, border-color 1.0s ease;\r\n    -webkit-transition: background-color 1.0s ease, border-color 1.0s ease;\r\n    transition: background-color 1.0s ease, border-color 1.0s ease;\n}\n.medimg-viewer-dark-mode, .medimg-viewer-dark-mode * {\r\n    --medimg-viewer-background: #000000;\r\n    --medimg-viewer-background-highlight: #181818;\r\n    --medimg-viewer-background-emphasize: #303030;\r\n    --medimg-viewer-background-modal: rgba(0, 0, 0, 0.7);\r\n    --medimg-viewer-border: #C0C0C0;\r\n    --medimg-viewer-border-faint: #606060;\r\n    --medimg-viewer-border-highlight: #F0F0F0;\r\n    --medimg-viewer-text-main: #E0E0E0;\r\n    --medimg-viewer-text-highlight: #F0F0F0;\r\n    --medimg-viewer-text-minor: #C0C0C0;\r\n    --medimg-viewer-text-faint: #808080;\n}\n.medimg-viewer-light-mode, .medimg-viewer-light-mode * {\r\n    --medimg-viewer-background: #FFFFFF;\r\n    --medimg-viewer-background-highlight: #F8F8F8;\r\n    --medimg-viewer-background-emphasize: #F0F0F0;\r\n    --medimg-viewer-background-modal: rgba(255, 255, 255, 0.7);\r\n    --medimg-viewer-border: #808080;\r\n    --medimg-viewer-border-faint: #A0A0A0;\r\n    --medimg-viewer-border-highlight: #404040;\r\n    --medimg-viewer-text-main: #303030;\r\n    --medimg-viewer-text-highlight: #101010;\r\n    --medimg-viewer-text-minor: #606060;\r\n    --medimg-viewer-text-faint: #909090;\n}\r\n/* Use prettier and more consistent scrollbars */\n.medimg-viewer *::-webkit-scrollbar {\r\n    width: 0px;\r\n    height: 0px;\n}\n.medimg-viewer *::-webkit-scrollbar-thumb {\r\n    color: var(--medimg-viewer-border-faint);\r\n    border-radius: 5px;\n}\n.medimg-viewer *::-webkit-scrollbar-track-piece {\r\n    background-color: transparent;\n}\r\n/* Main app view component styles */\n.medimg-viewer {\r\n    position: relative;\r\n    width: 100%;\r\n    height: 100%;\r\n    color: var(--medimg-viewer-text-main);\r\n    background-color: var(--medimg-viewer-background);\n}\n.medimg-viewer * {\r\n    /* Don't allow selecting text by default */\r\n    -webkit-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    user-select: none;\r\n    font-family: sans-serif;\r\n    /* Set scrollbar width for Firefox */\r\n    scrollbar-width: none;\n}\n.medimg-viewer div {\r\n        box-sizing: border-box;\n}\n.medimg-viewer-disabled {\r\n        opacity: 0.5;\r\n        cursor: default;\n}\n.medimg-viewer-hidden {\r\n        display: none !important;\n}\n.medimg-viewer-oneliner {\r\n        overflow: hidden !important;\r\n        text-overflow: ellipsis !important;\r\n        white-space: nowrap !important;\n}\n.medimg-viewer-settings {\r\n        position: absolute;\r\n        inset: 0;\r\n        z-index: 9;\r\n        background-color: var(--medimg-viewer-background-modal);\n}\n.medimg-viewer-interface-dropdown {\r\n        position: absolute;\r\n        top: 10px;\r\n        left: 10px;\r\n        height: 60px;\r\n        width: 280px;\r\n        border: solid 2px var(--medimg-viewer-border);\r\n        border-radius: 5px;\r\n        background-color: var(--medimg-viewer-background);\r\n        font-size: 24px;\r\n        line-height: 56px;\r\n        font-size: 16px;\r\n        cursor: pointer;\r\n        opacity: 0.8;\r\n        z-index: 1;\r\n        transition: left 0.5s;\n}\n.medimg-viewer-interface-dropdown-open {\r\n            opacity: 1.0;\r\n            height: auto;\n}\n.medimg-viewer-interface-dropdown.medimg-viewer-sidebar-closed {\r\n            left: -230px;\n}\n.medimg-viewer-interface-dropdown > div {\r\n            width: 210px;\r\n            height: 56px;\r\n            margin: 0 10px;\r\n            font-size: 18px;\n}\n.medimg-viewer-interface-dropdown > svg {\r\n            position: absolute;\r\n            right: 10px;\r\n            top: 10px;\r\n            font-size: 36px;\r\n            opacity: 0.5;\n}\n.medimg-viewer-interface-dropdown > svg:hover {\r\n                opacity: 0.75;\n}\n.medimg-viewer-interface-dropdown > ul {\r\n            display: none;\r\n            width: 100%;\r\n            list-style-type: none;\r\n            margin: 0;\r\n            padding: 0;\r\n            margin-block-start: 0;\r\n            margin-block-end: 0;\r\n            padding-inline-start: 0;\n}\n.medimg-viewer-interface-dropdown > ul > li > div {\r\n                line-height: 30px;\r\n                padding: 5px 10px;\n}\n.medimg-viewer-interface-dropdown > ul > li > .medimg-viewer-visit-title {\r\n                    font-weight: bold;\r\n                    cursor: default;\r\n                    border-top: solid 1px var(--medimg-viewer-border-faint);\r\n                    background-color: var(--medimg-viewer-background-emphasize);\n}\n.medimg-viewer-interface-dropdown > ul > li .medimg-viewer-visit-date {\r\n                    height: 20px;\r\n                    line-height: 20px;\r\n                    font-size: 80%;\r\n                    font-weight: normal;\r\n                    color: var(--medimg-viewer-text-minor);\r\n                    background-color: var(--medimg-viewer-background-emphasize);\n}\n.medimg-viewer-interface-dropdown > ul > li > .medimg-viewer-visit-studies {\r\n                    padding-left: 15px;\n}\n.medimg-viewer-interface-dropdown > ul > li > .medimg-viewer-visit-studies:hover {\r\n                    background-color: var(--medimg-viewer-background-highlight);\n}\n.medimg-viewer-interface-dropdown-open > ul {\r\n            display: block;\n}\n.medimg-viewer-settings-button {\r\n        position: absolute;\r\n        right: 0px;\r\n        top: 10px;\r\n        padding-left: 10px;\r\n        z-index: 10; /* On top of modal */\r\n        background-color: var(--medimg-viewer-background);\n}\n.medimg-viewer-settings-menu {\r\n        position: absolute;\r\n        top: 80px;\r\n        right: 10px;\r\n        background-color: var(--medimg-viewer-background);\r\n        border-left: solid 1px var(--medimg-viewer-border-faint);\r\n        border-bottom: solid 1px var(--medimg-viewer-border-faint);\r\n        z-index: 5;\n}\n.medimg-viewer-settings-menu-row {\r\n            height: 32px;\r\n            line-height: 32px;\r\n            padding: 0 10px;\r\n            cursor: pointer;\n}\n.medimg-viewer-settings-menu-row:hover {\r\n                background-color: var(--medimg-viewer-background-emphasize);\n}\n.medimg-viewer-settings-menu-row > svg {\r\n                margin-right: 5px;\n}\r\n","",{version:3,sources:["webpack://./src/components/App.vue"],names:[],mappings:";AAqYA,sBAAA;AACA;IACA,kEAAA;IACA,mEAAA;IACA,sEAAA;IACA,8DAAA;AACA;AACA;IACA,mCAAA;IACA,6CAAA;IACA,6CAAA;IACA,oDAAA;IACA,+BAAA;IACA,qCAAA;IACA,yCAAA;IACA,kCAAA;IACA,uCAAA;IACA,mCAAA;IACA,mCAAA;AACA;AACA;IACA,mCAAA;IACA,6CAAA;IACA,6CAAA;IACA,0DAAA;IACA,+BAAA;IACA,qCAAA;IACA,yCAAA;IACA,kCAAA;IACA,uCAAA;IACA,mCAAA;IACA,mCAAA;AACA;AACA,gDAAA;AACA;IACA,UAAA;IACA,WAAA;AACA;AACA;IACA,wCAAA;IACA,kBAAA;AACA;AACA;IACA,6BAAA;AACA;AACA,mCAAA;AACA;IACA,kBAAA;IACA,WAAA;IACA,YAAA;IACA,qCAAA;IACA,iDAAA;AACA;AACA;IACA,0CAAA;IACA,yBAAA;IACA,sBAAA;IACA,qBAAA;IACA,iBAAA;IACA,uBAAA;IACA,oCAAA;IACA,qBAAA;AACA;AACA;QACA,sBAAA;AACA;AACA;QACA,YAAA;QACA,eAAA;AACA;AACA;QACA,wBAAA;AACA;AACA;QACA,2BAAA;QACA,kCAAA;QACA,8BAAA;AACA;AACA;QACA,kBAAA;QACA,QAAA;QACA,UAAA;QACA,uDAAA;AACA;AACA;QACA,kBAAA;QACA,SAAA;QACA,UAAA;QACA,YAAA;QACA,YAAA;QACA,6CAAA;QACA,kBAAA;QACA,iDAAA;QACA,eAAA;QACA,iBAAA;QACA,eAAA;QACA,eAAA;QACA,YAAA;QACA,UAAA;QACA,qBAAA;AACA;AACA;YACA,YAAA;YACA,YAAA;AACA;AACA;YACA,YAAA;AACA;AACA;YACA,YAAA;YACA,YAAA;YACA,cAAA;YACA,eAAA;AACA;AACA;YACA,kBAAA;YACA,WAAA;YACA,SAAA;YACA,eAAA;YACA,YAAA;AACA;AACA;gBACA,aAAA;AACA;AACA;YACA,aAAA;YACA,WAAA;YACA,qBAAA;YACA,SAAA;YACA,UAAA;YACA,qBAAA;YACA,mBAAA;YACA,uBAAA;AACA;AACA;gBACA,iBAAA;gBACA,iBAAA;AACA;AACA;oBACA,iBAAA;oBACA,eAAA;oBACA,uDAAA;oBACA,2DAAA;AACA;AACA;oBACA,YAAA;oBACA,iBAAA;oBACA,cAAA;oBACA,mBAAA;oBACA,sCAAA;oBACA,2DAAA;AACA;AACA;oBACA,kBAAA;AACA;AACA;oBACA,2DAAA;AACA;AACA;YACA,cAAA;AACA;AACA;QACA,kBAAA;QACA,UAAA;QACA,SAAA;QACA,kBAAA;QACA,WAAA,EAAA,oBAAA;QACA,iDAAA;AACA;AACA;QACA,kBAAA;QACA,SAAA;QACA,WAAA;QACA,iDAAA;QACA,wDAAA;QACA,0DAAA;QACA,UAAA;AACA;AACA;YACA,YAAA;YACA,iBAAA;YACA,eAAA;YACA,eAAA;AACA;AACA;gBACA,2DAAA;AACA;AACA;gBACA,iBAAA;AACA",sourcesContent:["<template>\r\n\r\n    <div :id=\"`${$store.state.appName}-medimg-viewer`\" ref=\"app\" class=\"medimg-viewer medimg-viewer-dark-mode\">\r\n        <div :class=\"[\r\n                'medimg-viewer-settings',\r\n                { 'medimg-viewer-hidden': !$store.state.settingsOpen },\r\n            ]\"\r\n            @click=\"handleModalClick\"\r\n        >\r\n            <viewer-settings :scope=\"scope\"></viewer-settings>\r\n        </div>\r\n        <div :class=\"[\r\n                'medimg-viewer-interface-dropdown',\r\n                { 'medimg-viewer-interface-dropdown-open' : menuOpen },\r\n                { 'medimg-viewer-sidebar-closed': !sidebarOpen },\r\n            ]\"\r\n            @mouseleave=\"toggleMenu(false)\"\r\n        >\r\n            <div v-if=\"activeVisit\"\r\n                class=\"medimg-viewer-oneliner\"\r\n                @click=\"toggleMenu()\"\r\n            >\r\n                {{ getVisitTitle() }}\r\n            </div>\r\n            <div v-else\r\n                class=\"medimg-viewer-oneliner\"\r\n                @click=\"toggleMenu()\"\r\n            >\r\n                {{ t('No visit selected') }}\r\n            </div>\r\n            <font-awesome-icon\r\n                :icon=\"sidebarOpen ? ['fas', 'chevron-square-left'] : ['fas', 'chevron-square-right']\"\r\n                :title=\"sidebarOpen ? t('Close sidebar') : t('Open sidebar')\"\r\n                @click=\"toggleSidebar\"\r\n            />\r\n            <ul>\r\n                <li v-for=\"(visit, idx) in visits\" :key=\"`${$store.state.appName}-visit-option-${idx}`\">\r\n                    <div class=\"medimg-viewer-visit-title medimg-viewer-oneliner\">\r\n                        {{ getVisitTitle(idx) }}\r\n                        <div v-if=\"visit.date\" class=\"medimg-viewer-visit-date medimg-viewer-oneliner\">\r\n                            {{ getLocalDatetime(visit.date) }}\r\n                        </div>\r\n                    </div>\r\n                    <div v-if=\"visit.studies.radiology.length\"\r\n                        class=\"medimg-viewer-visit-studies medimg-viewer-oneliner\"\r\n                         @click=\"selectActiveResource(visit, 'radiology')\"\r\n                    >\r\n                        {{\r\n                            visit.studies.radiology.length === 1 ? t('1 radiology study') :\r\n                            t('{n} radiology studies', { n: visit.studies.radiology.length })\r\n                        }}\r\n                    </div>\r\n                </li>\r\n            </ul>\r\n        </div>\r\n        <div class=\"medimg-viewer-settings-button\">\r\n            <toolbar-button\r\n                id=\"settings\"\r\n                :enabled=\"true\"\r\n                :icon=\"['fal', 'cog']\"\r\n                :overlay=\"null\"\r\n                tooltip=\"Settings\"\r\n                @button-clicked=\"toggleSettingsMenu()\"\r\n            />\r\n        </div>\r\n        <div :class=\"[\r\n                'medimg-viewer-settings-menu',\r\n                { 'medimg-viewer-hidden' : !settingsMenuOpen }\r\n            ]\"\r\n        >\r\n            <div v-if=\"fullscreen !== null\" class=\"medimg-viewer-settings-menu-row\" @click=\"toggleFullscreen()\">\r\n                <font-awesome-icon :icon=\"['far', fullscreen ? 'compress' : 'expand']\" />\r\n                {{ t('Fullscreen') }}\r\n            </div>\r\n            <div class=\"medimg-viewer-settings-menu-row\" @click=\"toggleSettings()\">\r\n                <font-awesome-icon :icon=\"['far', 'cog']\" />\r\n                {{ t('Settings') }}\r\n            </div>\r\n        </div>\r\n        <dicom-image-interface v-if=\"scope==='radiology'\"\r\n            ref=\"dicom-image-interface\"\r\n            :hasStudiesToLoad=\"studiesToLoad !== null\"\r\n            :resources=\"activeVisit ? activeVisit.studies.radiology : []\"\r\n            :sidebarOpen=\"sidebarOpen\"\r\n            v-on:load-studies=\"loadStudiesFromFsItem()\"\r\n            v-on:update-item-order=\"updateDicomImageOrder\"\r\n        />\r\n    </div>\r\n\r\n</template>\r\n\r\n<script lang=\"ts\">\r\n\r\nimport Vue from 'vue'\r\nimport { FileSystemItem, PatientVisit } from '../types/common'\r\nimport GenericVisitLoader from '../assets/loaders/GenericVisitLoader'\r\nimport LocalFileLoader from '../assets/loaders/LocalFileLoader'\r\n\r\nexport default Vue.extend({\r\n    components: {\r\n        DicomImageInterface: () => import(/* webpackChunkName: \"radiology\" */'./Radiology/Dicom/DicomImageInterface.vue'),\r\n        ViewerSettings: () => import('./ViewerSettings.vue'),\r\n        ToolbarButton: () => import('./ToolbarButton.vue'),\r\n    },\r\n    data () {\r\n        return {\r\n            fullscreen: false as boolean | null,\r\n            menuOpen: false,\r\n            scope: this.$store.state.SETTINGS.scopePriority[0] || 'radiology',\r\n            selectedVisit: null as PatientVisit|null,\r\n            settingsMenuOpen: false,\r\n            sidebarOpen: true,\r\n            studiesToLoad: null as null | FileSystemItem,\r\n            visits: [] as PatientVisit[],\r\n            // Theme change trigger\r\n            themeChange: 0,\r\n        }\r\n    },\r\n    watch: {\r\n        fullscreen: function (val, old) {\r\n            if (val === null) {\r\n                return\r\n            } else if (val) {\r\n                (this.$refs['app'] as HTMLDivElement).requestFullscreen()\r\n            } else {\r\n                document.exitFullscreen()\r\n            }\r\n        },\r\n        scope: function (val, old) {\r\n            if (old === 'radiology' || val === 'radiology') {\r\n                this.toggleColorTheme()\r\n            }\r\n        },\r\n    },\r\n    computed: {\r\n        activeVisit (): PatientVisit | null {\r\n            return this.selectedVisit\r\n        },\r\n    },\r\n    methods: {\r\n        /** Shorthand for component-specific translations */\r\n        t: function (str: string, args?: any) {\r\n            if (args) {\r\n                return this.$t(`components.App.${str}`, args)\r\n            } else {\r\n                return (this.$t('components.App') as any)[str]\r\n            }\r\n        },\r\n        cacheStudyFsItem: function (fsItem: FileSystemItem | null) {\r\n            this.studiesToLoad = fsItem\r\n        },\r\n        getLocalDatetime: function (datetimeStr: string): string {\r\n            if (datetimeStr.length !== 12) {\r\n                return datetimeStr\r\n            }\r\n            const y = datetimeStr.substring(0, 4)\r\n            const m = datetimeStr.substring(4, 6)\r\n            const d = datetimeStr.substring(6, 8)\r\n            const hr = datetimeStr.substring(8, 10)\r\n            const min = datetimeStr.substring(10)\r\n            return this.$t(\r\n                'datetime',\r\n                { y: y, m: m.replace(/^0/, ''), d: d.replace(/^0/, ''), h: hr, min: min }\r\n            ).toString()\r\n        },\r\n        getVisitTitle: function (idx?: number): string {\r\n            // Return the actual visit title, or a numbered generic title if no actual title is set\r\n            let visit\r\n            if (idx === undefined && this.activeVisit) {\r\n                idx = this.visits.indexOf(this.activeVisit)\r\n            } else if (idx === undefined || idx >= this.visits.length) {\r\n                return ''\r\n            }\r\n            if (!this.visits[idx].title || this.visits[idx].title === '/') {\r\n                return `Visit #${(idx as number) + 1}`\r\n            }\r\n            return this.visits[idx].title\r\n        },\r\n        handleFileDrag: function (event: DragEvent) {\r\n            // Prevent default event effects\r\n            event.stopPropagation()\r\n            event.preventDefault()\r\n            if (event.dataTransfer) {\r\n                // Show that dropping the file \"copies\" it\r\n                event.dataTransfer.dropEffect = 'copy'\r\n            }\r\n        },\r\n        /**\r\n         * Handle a file or directory dropped in the dropzone\r\n         * @param event\r\n         */\r\n        handleFileDrop: async function (event: DragEvent) {\r\n            // Generic file drop, check each resource type?\r\n            const fileLoader = new LocalFileLoader()\r\n            this.$store.state.loadingStudies = true\r\n            fileLoader.readFilesFromSource(event).then((fileTree) => {\r\n                if (fileTree) {\r\n                    this.loadStudiesFromFsItem(fileTree)\r\n                } else {\r\n                    this.$store.state.loadingStudies = false\r\n                }\r\n            }).catch((error) => {\r\n                this.$store.state.loadingStudies = false\r\n                // TODO: Implement errors in the file loader\r\n            })\r\n        },\r\n        handleModalClick: function (ev: any) {\r\n            // Close the settings modal if the underlying (semi-transparent) background was clicked\r\n            if (ev.target === document.querySelector('div.medimg-viewer-settings')) {\r\n                this.$store.commit('toggle-settings', false)\r\n            }\r\n        },\r\n        /**\r\n         * Load studies from a given FilesystemItem.\r\n         * @param fsItem FilesystemItem to load\r\n         * @param config External visit configuration\r\n         */\r\n        loadStudiesFromFsItem: async function (fsItem?: FileSystemItem, config?: any) {\r\n            this.$store.state.loadingStudies = true\r\n            if (!fsItem) {\r\n                // Retrieve possible cached item\r\n                if (this.studiesToLoad) {\r\n                    fsItem = {...this.studiesToLoad}\r\n                    this.studiesToLoad = null\r\n                } else {\r\n                    return\r\n                }\r\n            }\r\n            // Display loading studies indicator\r\n            if (!this.$store.state.loadingStudies) {\r\n                this.$store.state.loadingStudies = true\r\n            }\r\n            // Fall back to loading the visit in main thread (bad user experience!)\r\n            const visitLoader = new GenericVisitLoader()\r\n            visitLoader.loadFromFsItem(fsItem, config).then(async visits => {\r\n                this.visits.push(...visits)\r\n                for (const visit of visits) {\r\n                    // Check that the visit has a proper title\r\n                    if (!this.selectedVisit) {\r\n                        this.selectedVisit = visit\r\n                        // Open the study with the highest priority\r\n                        let bestScope = ''\r\n                        const scopePrio = this.$store.state.SETTINGS.scopePriority\r\n                        for (const scope in visit.studies) {\r\n                            if (scopePrio.indexOf(scope) !== -1 &&\r\n                                visit.studies[scope as keyof typeof visit.studies].length &&\r\n                                (bestScope === '' || scopePrio.indexOf(scope) < scopePrio.indexOf(bestScope))\r\n                            ) {\r\n                                bestScope = scope\r\n                            }\r\n                            // 0.1 release only supports radiology studies; print warning for others\r\n                            if (scope !== 'radiology') {\r\n                                console.warn(`A ${scope} study was included in the dataset, but this feature is not yet available!`)\r\n                            }\r\n                        }\r\n                        if (bestScope !== '') {\r\n                            this.scope = bestScope\r\n                        }\r\n                    }\r\n                }\r\n                this.$store.state.loadingStudies = false\r\n            }).catch((error) => {\r\n                console.error(error)\r\n                this.$store.state.loadingStudies = false\r\n            })\r\n        },\r\n        selectActiveResource(visit: PatientVisit, scope: string) {\r\n            if (visit !== this.selectedVisit) {\r\n                this.selectedVisit = visit\r\n            }\r\n            if (scope !== this.scope) {\r\n                this.scope = scope\r\n            }\r\n            if (this.$refs['dicom-image-interface']) {\r\n                (this.$refs['dicom-image-interface'] as any).updateElements()\r\n            }\r\n            if (this.$refs['dicom-waveform-interface']) {\r\n                (this.$refs['dicom-waveform-interface'] as any).updateElements()\r\n            }\r\n            if (this.$refs['dicom-eeg-interface']) {\r\n                (this.$refs['dicom-eeg-interface'] as any).updateElements()\r\n            }\r\n            this.toggleMenu(false)\r\n        },\r\n        toggleColorTheme: function (light?: boolean) {\r\n            const appEl = document.getElementById(`${this.$store.state.appName}-medimg-viewer`)\r\n            if (appEl) {\r\n                appEl.classList.add('medimg-viewer-theme-change')\r\n                this.$nextTick(() => {\r\n                    if (light === undefined) {\r\n                        if (appEl.classList.contains('medimg-viewer-dark-mode')) {\r\n                            appEl.classList.remove('medimg-viewer-dark-mode')\r\n                            appEl.classList.add('medimg-viewer-light-mode')\r\n                        } else {\r\n                            appEl.classList.remove('medimg-viewer-light-mode')\r\n                            appEl.classList.add('medimg-viewer-dark-mode')\r\n                        }\r\n                    } else if (light) {\r\n                        appEl.classList.remove('medimg-viewer-dark-mode')\r\n                        appEl.classList.add('medimg-viewer-light-mode')\r\n                    } else {\r\n                        appEl.classList.remove('medimg-viewer-light-mode')\r\n                        appEl.classList.add('medimg-viewer-dark-mode')\r\n                    }\r\n                })\r\n                if (this.themeChange) {\r\n                    window.clearTimeout(this.themeChange)\r\n                }\r\n                // Two reasons for the timeout:\r\n                // 1. Don't want the transition outside of color theme change\r\n                // 2. It forces Chromium browsers to update the color of text and icons\r\n                //    (which sometimes takes AGES, for some reason)\r\n                this.themeChange = window.setTimeout(() => {\r\n                    appEl.classList.remove('medimg-viewer-theme-change')\r\n                }, 2100)\r\n            }\r\n        },\r\n        toggleFullscreen: function () {\r\n            if (this.fullscreen === null) {\r\n                return\r\n            }\r\n            this.fullscreen = !this.fullscreen\r\n        },\r\n        toggleMenu: function (value?: boolean) {\r\n            if (value !== undefined) {\r\n                this.menuOpen = value\r\n            } else {\r\n                this.menuOpen = !this.menuOpen\r\n            }\r\n        },\r\n        toggleSettings: function () {\r\n            this.$store.commit('toggle-settings')\r\n            if (this.$store.state.settingsOpen && this.settingsMenuOpen) {\r\n                this.settingsMenuOpen = false\r\n            }\r\n        },\r\n        toggleSettingsMenu: function () {\r\n            if (this.$store.state.settingsOpen) {\r\n                this.$store.commit('toggle-settings', false)\r\n            } else {\r\n                this.settingsMenuOpen = !this.settingsMenuOpen\r\n            }\r\n        },\r\n        toggleSidebar: function () {\r\n            this.sidebarOpen = !this.sidebarOpen\r\n        },\r\n        updateDicomImageOrder: function(order: string[]) {\r\n            if (!this.activeVisit || order.length !== this.activeVisit.studies.radiology.length) {\r\n                return\r\n            }\r\n            const names = []\r\n            for (let i=0; i<order.length; i++) {\r\n                for (let j=0; j<this.activeVisit.studies.radiology.length; j++) {\r\n                    if (this.activeVisit.studies.radiology[j].id === order[i]) {\r\n                        names.push(this.activeVisit.studies.radiology[j].name)\r\n                        this.activeVisit.studies.radiology.push(\r\n                            this.activeVisit.studies.radiology.splice(j, 1)[0] as any\r\n                        )\r\n                        break\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    },\r\n    mounted () {\r\n        // Check that fullscreen API is available\r\n        if (!Element.prototype.requestFullscreen) {\r\n            Element.prototype.requestFullscreen = (Element.prototype as any).mozRequestFullscreen ||\r\n                                                  (Element.prototype as any).webkitRequestFullscreen ||\r\n                                                  (Element.prototype as any).msRequestFullscreen\r\n        }\r\n        if (!document.exitFullscreen) {\r\n            document.exitFullscreen = (document as any).webkitExitFullscreen ||\r\n                                      (document as any).mozCancelFullScreen ||\r\n                                      (document as any).msExitFullscreen\r\n        }\r\n        if (!Element.prototype.requestFullscreen || !document.exitFullscreen) {\r\n            console.warn(\"Fullscreen API is not available\")\r\n            this.fullscreen = null\r\n        }\r\n        this.$store.commit('set-settings-value', { field: 'eeg.yPadding', value: 1.5 })\r\n        this.$store.commit('set-settings-value', { field: 'eeg.channelSpacing', value: 1 })\r\n        this.$store.commit('set-settings-value', { field: 'eeg.groupSpacing', value: 1.25 })\r\n    },\r\n})\r\n\r\n<\/script>\r\n\r\n<style>\r\n/* Global app styles */\r\n.medimg-viewer-theme-change, .medimg-viewer-theme-change * {\r\n    -ms-transition: background-color 1.0s ease, border-color 1.0s ease;\r\n    -moz-transition: background-color 1.0s ease, border-color 1.0s ease;\r\n    -webkit-transition: background-color 1.0s ease, border-color 1.0s ease;\r\n    transition: background-color 1.0s ease, border-color 1.0s ease;\r\n}\r\n.medimg-viewer-dark-mode, .medimg-viewer-dark-mode * {\r\n    --medimg-viewer-background: #000000;\r\n    --medimg-viewer-background-highlight: #181818;\r\n    --medimg-viewer-background-emphasize: #303030;\r\n    --medimg-viewer-background-modal: rgba(0, 0, 0, 0.7);\r\n    --medimg-viewer-border: #C0C0C0;\r\n    --medimg-viewer-border-faint: #606060;\r\n    --medimg-viewer-border-highlight: #F0F0F0;\r\n    --medimg-viewer-text-main: #E0E0E0;\r\n    --medimg-viewer-text-highlight: #F0F0F0;\r\n    --medimg-viewer-text-minor: #C0C0C0;\r\n    --medimg-viewer-text-faint: #808080;\r\n}\r\n.medimg-viewer-light-mode, .medimg-viewer-light-mode * {\r\n    --medimg-viewer-background: #FFFFFF;\r\n    --medimg-viewer-background-highlight: #F8F8F8;\r\n    --medimg-viewer-background-emphasize: #F0F0F0;\r\n    --medimg-viewer-background-modal: rgba(255, 255, 255, 0.7);\r\n    --medimg-viewer-border: #808080;\r\n    --medimg-viewer-border-faint: #A0A0A0;\r\n    --medimg-viewer-border-highlight: #404040;\r\n    --medimg-viewer-text-main: #303030;\r\n    --medimg-viewer-text-highlight: #101010;\r\n    --medimg-viewer-text-minor: #606060;\r\n    --medimg-viewer-text-faint: #909090;\r\n}\r\n/* Use prettier and more consistent scrollbars */\r\n.medimg-viewer *::-webkit-scrollbar {\r\n    width: 0px;\r\n    height: 0px;\r\n}\r\n.medimg-viewer *::-webkit-scrollbar-thumb {\r\n    color: var(--medimg-viewer-border-faint);\r\n    border-radius: 5px;\r\n}\r\n.medimg-viewer *::-webkit-scrollbar-track-piece {\r\n    background-color: transparent;\r\n}\r\n/* Main app view component styles */\r\n.medimg-viewer {\r\n    position: relative;\r\n    width: 100%;\r\n    height: 100%;\r\n    color: var(--medimg-viewer-text-main);\r\n    background-color: var(--medimg-viewer-background);\r\n}\r\n.medimg-viewer * {\r\n    /* Don't allow selecting text by default */\r\n    -webkit-user-select: none;\r\n    -moz-user-select: none;\r\n    -ms-user-select: none;\r\n    user-select: none;\r\n    font-family: sans-serif;\r\n    /* Set scrollbar width for Firefox */\r\n    scrollbar-width: none;\r\n}\r\n    .medimg-viewer div {\r\n        box-sizing: border-box;\r\n    }\r\n    .medimg-viewer-disabled {\r\n        opacity: 0.5;\r\n        cursor: default;\r\n    }\r\n    .medimg-viewer-hidden {\r\n        display: none !important;\r\n    }\r\n    .medimg-viewer-oneliner {\r\n        overflow: hidden !important;\r\n        text-overflow: ellipsis !important;\r\n        white-space: nowrap !important;\r\n    }\r\n    .medimg-viewer-settings {\r\n        position: absolute;\r\n        inset: 0;\r\n        z-index: 9;\r\n        background-color: var(--medimg-viewer-background-modal);\r\n    }\r\n    .medimg-viewer-interface-dropdown {\r\n        position: absolute;\r\n        top: 10px;\r\n        left: 10px;\r\n        height: 60px;\r\n        width: 280px;\r\n        border: solid 2px var(--medimg-viewer-border);\r\n        border-radius: 5px;\r\n        background-color: var(--medimg-viewer-background);\r\n        font-size: 24px;\r\n        line-height: 56px;\r\n        font-size: 16px;\r\n        cursor: pointer;\r\n        opacity: 0.8;\r\n        z-index: 1;\r\n        transition: left 0.5s;\r\n    }\r\n        .medimg-viewer-interface-dropdown-open {\r\n            opacity: 1.0;\r\n            height: auto;\r\n        }\r\n        .medimg-viewer-interface-dropdown.medimg-viewer-sidebar-closed {\r\n            left: -230px;\r\n        }\r\n        .medimg-viewer-interface-dropdown > div {\r\n            width: 210px;\r\n            height: 56px;\r\n            margin: 0 10px;\r\n            font-size: 18px;\r\n        }\r\n        .medimg-viewer-interface-dropdown > svg {\r\n            position: absolute;\r\n            right: 10px;\r\n            top: 10px;\r\n            font-size: 36px;\r\n            opacity: 0.5;\r\n        }\r\n            .medimg-viewer-interface-dropdown > svg:hover {\r\n                opacity: 0.75;\r\n            }\r\n        .medimg-viewer-interface-dropdown > ul {\r\n            display: none;\r\n            width: 100%;\r\n            list-style-type: none;\r\n            margin: 0;\r\n            padding: 0;\r\n            margin-block-start: 0;\r\n            margin-block-end: 0;\r\n            padding-inline-start: 0;\r\n        }\r\n            .medimg-viewer-interface-dropdown > ul > li > div {\r\n                line-height: 30px;\r\n                padding: 5px 10px;\r\n            }\r\n                .medimg-viewer-interface-dropdown > ul > li > .medimg-viewer-visit-title {\r\n                    font-weight: bold;\r\n                    cursor: default;\r\n                    border-top: solid 1px var(--medimg-viewer-border-faint);\r\n                    background-color: var(--medimg-viewer-background-emphasize);\r\n                }\r\n                .medimg-viewer-interface-dropdown > ul > li .medimg-viewer-visit-date {\r\n                    height: 20px;\r\n                    line-height: 20px;\r\n                    font-size: 80%;\r\n                    font-weight: normal;\r\n                    color: var(--medimg-viewer-text-minor);\r\n                    background-color: var(--medimg-viewer-background-emphasize);\r\n                }\r\n                .medimg-viewer-interface-dropdown > ul > li > .medimg-viewer-visit-studies {\r\n                    padding-left: 15px;\r\n                }\r\n                .medimg-viewer-interface-dropdown > ul > li > .medimg-viewer-visit-studies:hover {\r\n                    background-color: var(--medimg-viewer-background-highlight);\r\n                }\r\n        .medimg-viewer-interface-dropdown-open > ul {\r\n            display: block;\r\n        }\r\n    .medimg-viewer-settings-button {\r\n        position: absolute;\r\n        right: 0px;\r\n        top: 10px;\r\n        padding-left: 10px;\r\n        z-index: 10; /* On top of modal */\r\n        background-color: var(--medimg-viewer-background);\r\n    }\r\n    .medimg-viewer-settings-menu {\r\n        position: absolute;\r\n        top: 80px;\r\n        right: 10px;\r\n        background-color: var(--medimg-viewer-background);\r\n        border-left: solid 1px var(--medimg-viewer-border-faint);\r\n        border-bottom: solid 1px var(--medimg-viewer-border-faint);\r\n        z-index: 5;\r\n    }\r\n        .medimg-viewer-settings-menu-row {\r\n            height: 32px;\r\n            line-height: 32px;\r\n            padding: 0 10px;\r\n            cursor: pointer;\r\n        }\r\n            .medimg-viewer-settings-menu-row:hover {\r\n                background-color: var(--medimg-viewer-background-emphasize);\r\n            }\r\n            .medimg-viewer-settings-menu-row > svg {\r\n                margin-right: 5px;\r\n            }\r\n</style>\r\n"],sourceRoot:""}]),e.exports=n},3645:e=>{"use strict";e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var i=e(t);return t[2]?"@media ".concat(t[2]," {").concat(i,"}"):i})).join("")},t.i=function(e,i,r){"string"==typeof e&&(e=[[null,e,""]]);var n={};if(r)for(var s=0;s<this.length;s++){var o=this[s][0];null!=o&&(n[o]=!0)}for(var a=0;a<e.length;a++){var d=[].concat(e[a]);r&&n[d[0]]||(i&&(d[2]?d[2]="".concat(i," and ").concat(d[2]):d[2]=i),t.push(d))}},t}},4015:e=>{"use strict";function t(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var i=e&&("undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"]);if(null==i)return;var r,n,s=[],o=!0,a=!1;try{for(i=i.call(e);!(o=(r=i.next()).done)&&(s.push(r.value),!t||s.length!==t);o=!0);}catch(e){a=!0,n=e}finally{try{o||null==i.return||i.return()}finally{if(a)throw n}}return s}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return i(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(e);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return i(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function i(e,t){(null==t||t>e.length)&&(t=e.length);for(var i=0,r=new Array(t);i<t;i++)r[i]=e[i];return r}e.exports=function(e){var i=t(e,4),r=i[1],n=i[3];if(!n)return r;if("function"==typeof btoa){var s=btoa(unescape(encodeURIComponent(JSON.stringify(n)))),o="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(s),a="/*# ".concat(o," */"),d=n.sources.map((function(e){return"/*# sourceURL=".concat(n.sourceRoot||"").concat(e," */")}));return[r].concat(d).concat([a]).join("\n")}return[r].join("\n")}},6713:(e,t,i)=>{"use strict";i.d(t,{Z:()=>a});var r=i(5798),n=i.n(r),s=i(606),o=i(6411);const a=n().extend({components:{DicomImageInterface:()=>Promise.all([i.e(33),i.e(527)]).then(i.bind(i,1543)),ViewerSettings:()=>i.e(114).then(i.bind(i,2114)),ToolbarButton:()=>i.e(566).then(i.bind(i,7566))},data(){return{fullscreen:!1,menuOpen:!1,scope:this.$store.state.SETTINGS.scopePriority[0]||"radiology",selectedVisit:null,settingsMenuOpen:!1,sidebarOpen:!0,studiesToLoad:null,visits:[],themeChange:0}},watch:{fullscreen:function(e,t){null!==e&&(e?this.$refs.app.requestFullscreen():document.exitFullscreen())},scope:function(e,t){"radiology"!==t&&"radiology"!==e||this.toggleColorTheme()}},computed:{activeVisit(){return this.selectedVisit}},methods:{t:function(e,t){return t?this.$t(`components.App.${e}`,t):this.$t("components.App")[e]},cacheStudyFsItem:function(e){this.studiesToLoad=e},getLocalDatetime:function(e){if(12!==e.length)return e;const t=e.substring(0,4),i=e.substring(4,6),r=e.substring(6,8),n=e.substring(8,10),s=e.substring(10);return this.$t("datetime",{y:t,m:i.replace(/^0/,""),d:r.replace(/^0/,""),h:n,min:s}).toString()},getVisitTitle:function(e){if(void 0===e&&this.activeVisit)e=this.visits.indexOf(this.activeVisit);else if(void 0===e||e>=this.visits.length)return"";return this.visits[e].title&&"/"!==this.visits[e].title?this.visits[e].title:`Visit #${e+1}`},handleFileDrag:function(e){e.stopPropagation(),e.preventDefault(),e.dataTransfer&&(e.dataTransfer.dropEffect="copy")},handleFileDrop:async function(e){const t=new o.Z;this.$store.state.loadingStudies=!0,t.readFilesFromSource(e).then((e=>{e?this.loadStudiesFromFsItem(e):this.$store.state.loadingStudies=!1})).catch((e=>{this.$store.state.loadingStudies=!1}))},handleModalClick:function(e){e.target===document.querySelector("div.medimg-viewer-settings")&&this.$store.commit("toggle-settings",!1)},loadStudiesFromFsItem:async function(e,t){if(this.$store.state.loadingStudies=!0,!e){if(!this.studiesToLoad)return;e=Object.assign({},this.studiesToLoad),this.studiesToLoad=null}this.$store.state.loadingStudies||(this.$store.state.loadingStudies=!0);(new s.Z).loadFromFsItem(e,t).then((async e=>{this.visits.push(...e);for(const t of e)if(!this.selectedVisit){this.selectedVisit=t;let e="";const i=this.$store.state.SETTINGS.scopePriority;for(const r in t.studies)-1!==i.indexOf(r)&&t.studies[r].length&&(""===e||i.indexOf(r)<i.indexOf(e))&&(e=r),"radiology"!==r&&console.warn(`A ${r} study was included in the dataset, but this feature is not yet available!`);""!==e&&(this.scope=e)}this.$store.state.loadingStudies=!1})).catch((e=>{console.error(e),this.$store.state.loadingStudies=!1}))},selectActiveResource(e,t){e!==this.selectedVisit&&(this.selectedVisit=e),t!==this.scope&&(this.scope=t),this.$refs["dicom-image-interface"]&&this.$refs["dicom-image-interface"].updateElements(),this.$refs["dicom-waveform-interface"]&&this.$refs["dicom-waveform-interface"].updateElements(),this.$refs["dicom-eeg-interface"]&&this.$refs["dicom-eeg-interface"].updateElements(),this.toggleMenu(!1)},toggleColorTheme:function(e){const t=document.getElementById(`${this.$store.state.appName}-medimg-viewer`);t&&(t.classList.add("medimg-viewer-theme-change"),this.$nextTick((()=>{void 0===e?t.classList.contains("medimg-viewer-dark-mode")?(t.classList.remove("medimg-viewer-dark-mode"),t.classList.add("medimg-viewer-light-mode")):(t.classList.remove("medimg-viewer-light-mode"),t.classList.add("medimg-viewer-dark-mode")):e?(t.classList.remove("medimg-viewer-dark-mode"),t.classList.add("medimg-viewer-light-mode")):(t.classList.remove("medimg-viewer-light-mode"),t.classList.add("medimg-viewer-dark-mode"))})),this.themeChange&&window.clearTimeout(this.themeChange),this.themeChange=window.setTimeout((()=>{t.classList.remove("medimg-viewer-theme-change")}),2100))},toggleFullscreen:function(){null!==this.fullscreen&&(this.fullscreen=!this.fullscreen)},toggleMenu:function(e){this.menuOpen=void 0!==e?e:!this.menuOpen},toggleSettings:function(){this.$store.commit("toggle-settings"),this.$store.state.settingsOpen&&this.settingsMenuOpen&&(this.settingsMenuOpen=!1)},toggleSettingsMenu:function(){this.$store.state.settingsOpen?this.$store.commit("toggle-settings",!1):this.settingsMenuOpen=!this.settingsMenuOpen},toggleSidebar:function(){this.sidebarOpen=!this.sidebarOpen},updateDicomImageOrder:function(e){if(!this.activeVisit||e.length!==this.activeVisit.studies.radiology.length)return;const t=[];for(let i=0;i<e.length;i++)for(let r=0;r<this.activeVisit.studies.radiology.length;r++)if(this.activeVisit.studies.radiology[r].id===e[i]){t.push(this.activeVisit.studies.radiology[r].name),this.activeVisit.studies.radiology.push(this.activeVisit.studies.radiology.splice(r,1)[0]);break}}},mounted(){Element.prototype.requestFullscreen||(Element.prototype.requestFullscreen=Element.prototype.mozRequestFullscreen||Element.prototype.webkitRequestFullscreen||Element.prototype.msRequestFullscreen),document.exitFullscreen||(document.exitFullscreen=document.webkitExitFullscreen||document.mozCancelFullScreen||document.msExitFullscreen),Element.prototype.requestFullscreen&&document.exitFullscreen||(console.warn("Fullscreen API is not available"),this.fullscreen=null),this.$store.commit("set-settings-value",{field:"eeg.yPadding",value:1.5}),this.$store.commit("set-settings-value",{field:"eeg.channelSpacing",value:1}),this.$store.commit("set-settings-value",{field:"eeg.groupSpacing",value:1.25})}})},3226:(e,t,i)=>{"use strict";i.d(t,{Z:()=>d});var r=i(1653),n=i(2790),s=i.n(n);const o=.2,a=null===s()||void 0===s()?void 0:s().importInternal("util/convertToVector3");const d=class{constructor(e,t,i,n,s){this._active=!1,this._coverImage=null,this._currentPosition=0,this._dimensions=[0,0],this._linkedPosition=-1,this._masterLinkPosition=-1,this._preloadProcess=null,this._preloaded=0,this._referenceAnnotations={ang:[],len:[],roiE:[]},this._toolState=null,this._topogram=null,this._topogramBounds={x:[-1,-1],y:[-1,-1]},this._topogramIntersections={},this._viewport=null,this.removeFromCache=()=>{if(this.isStack&&this._images.length)for(const e of this._images)try{r.imageCache.removeImageLoadObject(e.url)}catch(e){}else if(this._url)try{r.imageCache.removeImageLoadObject(this._url)}catch(e){}},this._id=Math.random().toString(36).substr(2,8),this._images=[],this._modality=e,this._name=t,this._size=i,this._type=n,this._url=s}get columns(){return this._columns}set columns(e){this._columns=e}get coverImage(){return this._coverImage?this._coverImage:!this.isStack&&this._url?this:null}set coverImage(e){this._coverImage=e}get currentImage(){return this.isStack?this._images[this._currentPosition]||null:this}get currentPosition(){return this._currentPosition}set currentPosition(e){e>=0&&e<this._images.length&&(this._currentPosition=e)}get dimensions(){return this._dimensions}get exposure(){return this._exposure}get exposureTime(){return this._exposureTime}get id(){return this._id}get imageOrientation(){return this._imageOrientation}get images(){return this._images}get instanceLength(){return this._instanceLength}set instanceLength(e){this._instanceLength=e}get instanceNumber(){return this._instanceNumber}set instanceNumber(e){this._instanceNumber=e}get isActive(){return this._active}set isActive(e){this._active=e}get isCollation(){return this._type.endsWith(":collation")}get isLinked(){return-1!==this._linkedPosition}get isStack(){return this._type.endsWith(":series")}get KVP(){return this._KVP}get linkedPosition(){return this._linkedPosition}set linkedPosition(e){e>=0&&e<this._images.length&&(this._linkedPosition=e)}get masterLinkPosition(){return this._masterLinkPosition}set masterLinkPosition(e){this._masterLinkPosition=e}get modality(){return this._modality}set modality(e){this._modality=e}get name(){return this._name}set name(e){this._name=e}get numberOfFrames(){return this._numberOfFrames}set numberOfFrames(e){this._numberOfFrames=e}get length(){return this._images.length}get preloaded(){return this._preloaded}get referenceAnnotations(){return this._referenceAnnotations}get rows(){return this._rows}set rows(e){this._rows=e}get size(){return this.length}get sliceLocation(){return this._sliceLocation}get sliceThickness(){return this._sliceThickness}get sopClassUID(){return this._sopClassUID}set sopClassUID(e){this._sopClassUID=e}get sopInstanceUID(){return this._sopInstanceUID}set sopInstanceUID(e){this._sopInstanceUID=e}get studyID(){return this._studyID}set studyID(e){this._studyID=e}get studyNumber(){return this._studyNumber}set studyNumber(e){this._studyNumber=e}get toolState(){return this._toolState}set toolState(e){this._toolState=e}get topogram(){return this._topogram}set topogram(e){this._topogram=e}get topogramBounds(){return this._topogramBounds}set topogramBounds(e){this._topogramBounds=e}get topogramPaddedBounds(){if(null===this._topogram)return;const e=this._topogramBounds.x[1]-this._topogramBounds.x[0],t=this._topogramBounds.y[1]-this._topogramBounds.y[0],i=this._topogramBounds.x[0]-e*o,r=this._topogramBounds.x[1]+e*o,n=this._topogramBounds.y[0]-t*o,s=this._topogramBounds.y[1]+t*o,a=n>0?n:0;return{x:[i>0?i:0,r<this._topogram.dimensions[0]?r:this._topogram.dimensions[0]],y:[a,s<this._topogram.dimensions[1]?s:this._topogram.dimensions[1]]}}get tubeCurrent(){return this._tubeCurrent}get type(){return this._type.split(":")[0]}set type(e){this._type=e}get url(){return this._url}set url(e){this._url=e}get viewport(){return this._viewport}set viewport(e){this._viewport=e}add(e){this.push(e)}async calculateTopogramIntersectPoints(){if(null===this._topogram)return!1;if(this._preloaded!==this._images.length)return!1;const e=r.metaData.get("imagePlaneModule",this._images[0].url),t=r.metaData.get("imagePlaneModule",this._topogram.url);if(!(e&&e.rowCosines&&e.columnCosines&&e.imagePositionPatient&&t&&t.rowCosines&&t.columnCosines&&t.imagePositionPatient))return console.warn("Unable to calculate topogram intersections: Invalid image planes."),!1;if(e.frameOfReferenceUID!==t.frameOfReferenceUID)return console.warn("Unable to calculate topogram intersections: Different frames of reference."),!1;e.columnCosines=a(e.columnCosines),t.columnCosines=a(t.columnCosines),e.rowCosines=a(e.rowCosines),t.rowCosines=a(t.rowCosines);const i=e.rowCosines.clone().cross(e.columnCosines),n=t.rowCosines.clone().cross(t.columnCosines);let o=i.angleTo(n);if(Math.abs(o)<1)return this._topogram=null,console.warn(`Removing topogram image: Angle is too narrow (${o.toFixed(1)} radians).`),!1;const d=s().importInternal("util/planePlaneIntersection");let l=d(t,e);const m=s().importInternal("util/projectPatientPointToImagePlane");let c=m(l.start,t),g=m(l.end,t);this._topogramIntersections[this._images[0].url]=[c,g],this._topogramBounds={x:[Math.min(c.x,g.x),Math.max(c.x,g.x)],y:[Math.min(c.y,g.y),Math.max(c.y,g.y)]};for(let e=1;e<this._images.length;e++){const i=r.metaData.get("imagePlaneModule",this._images[e].url);i&&i.rowCosines&&i.columnCosines&&i.imagePositionPatient&&(i.frameOfReferenceUID===t.frameOfReferenceUID&&(l=d(t,i),c=m(l.start,t),g=m(l.end,t),this._topogramIntersections[this._images[e].url]=[c,g],this._topogramBounds.x[0]>c.x&&(this._topogramBounds.x[0]=c.x),this._topogramBounds.x[0]>g.x&&(this._topogramBounds.x[0]=g.x),this._topogramBounds.x[1]<c.x&&(this._topogramBounds.x[1]=c.x),this._topogramBounds.x[1]<g.x&&(this._topogramBounds.x[1]=g.x),this._topogramBounds.y[0]>c.y&&(this._topogramBounds.y[0]=c.y),this._topogramBounds.y[0]>g.y&&(this._topogramBounds.y[0]=g.y),this._topogramBounds.y[1]<c.y&&(this._topogramBounds.y[1]=c.y),this._topogramBounds.y[1]<g.y&&(this._topogramBounds.y[1]=g.y)))}return!0}getIndexById(e){for(let t=0;t<this._images.length;t++)if(this._images[t].id===e)return t;return-1}getIndexByUrl(e){for(let t=0;t<this._images.length;t++)if(this._images[t].url===e)return t;return-1}getRefLineForImage(e){if(e&&!this._topogramIntersections.hasOwnProperty(e)||!e&&!this.currentImage)return;const t=e?this._topogramIntersections[e]:this._topogramIntersections[this.currentImage.url],i=this.topogramPaddedBounds;if(!t||!i)return;const r=i.x[0],n=i.y[0];return{start:{x:t[0].x-r,y:t[0].y-n},end:{x:t[1].x-r,y:t[1].y-n}}}link(e,t){void 0===t&&(t=this._currentPosition),this._linkedPosition=t,this._masterLinkPosition=e}push(e){this._images.push(e)}async preloadAndCacheImage(){return!this.isStack&&this._url?await r.loadAndCacheImage(this._url).then((e=>(this.readMetadataFromImage(e),e))):{}}async preloadAndSortImages(){return this._images.length?(this._preloadProcess||(this._preloadProcess=new Promise((async e=>{for(let t=0;t<this._images.length;t++)await r.loadAndCacheImage(this._images[t].url).then((e=>{this._images[t].readMetadataFromImage(e),this._preloaded++,t||(this._dimensions=[e.width,e.height])})).catch((t=>{e({success:!1,reason:t})})),this._preloaded===this._images.length&&(this.sortImages("i"),null!==this._topogram&&await r.loadAndCacheImage(this._topogram.url).then((e=>{var t;null===(t=this._topogram)||void 0===t||t.readMetadataFromImage(e),this.calculateTopogramIntersectPoints()})),e({success:!0}));e({success:!0})}))),this._preloadProcess):{success:!1,reason:"Image stack doesn't contain any images"}}async readMetadataFromImage(e){var t;if(!e){if(this.isStack||!this._url)return!1;e=await r.loadAndCacheImage(this._url).then((e=>e))}this._dimensions=[e.width,e.height],this._studyID=e.data.string("x00200010")||void 0,this._studyNumber=parseInt(e.data.string("x00200011")||"0",10)||void 0,this._instanceLength=parseInt(e.data.string("x00201208")||"0",10)||void 0,this._instanceNumber=parseInt(e.data.string("x00200013")||"0",10)||void 0,this._numberOfFrames=e.data.string("x00280008")||void 0,this._sopClassUID=e.data.string("x00080016")||void 0,this._sopInstanceUID=e.data.string("x00080018")||void 0,this._rows=e.data.string("x00280010")||void 0,this._columns=e.data.string("x00280011")||void 0;const i=(null===(t=e.data.string("x00200037"))||void 0===t?void 0:t.split("\\"))||void 0;if(6===(null==i?void 0:i.length)){const e=a([parseFloat(i[0]),parseFloat(i[1]),parseFloat(i[2])]),t=a([parseFloat(i[3]),parseFloat(i[4]),parseFloat(i[5])]),r=a([1,0,0]),n=a([0,1,0]),s=180/Math.PI;this._imageOrientation=[Math.round(e.angleTo(r)*s),Math.round(t.angleTo(n)*s)]}return this._sliceThickness=parseFloat(e.data.string("x00180050")||"0")||void 0,this._sliceLocation=parseFloat(e.data.string("x00201041")||"0")||void 0,this._KVP=parseFloat(e.data.string("x00180060")||"0")||void 0,this._exposureTime=parseInt(e.data.string("x00181150")||"0",10)||void 0,this._tubeCurrent=parseInt(e.data.string("x00181151")||"0",10)||void 0,this._exposure=parseInt(e.data.string("x00181152")||"0",10)||void 0,!0}async setCoverImage(e){if("number"==typeof e&&this._images[e]?this._coverImage=this._images[e]:this._coverImage=e,this._coverImage){const e=await this._coverImage.preloadAndCacheImage();this._preloaded||await this.readMetadataFromImage(e)}}setCurrentPositionById(e){const t=this.getIndexById(e);this._currentPosition=t>=0?t:0}setCurrentPositionByUrl(e){const t=this.getIndexByUrl(e);this._currentPosition=t>=0?t:0}sortImages(e){this._images.sort(((t,i)=>"i"===e?(t.instanceNumber||0)-(i.instanceNumber||0):"n"===e?t.name.localeCompare(i.name):0))}unlink(){this._linkedPosition=-1,this._masterLinkPosition=-1}}},2874:(e,t,i)=>{"use strict";i.d(t,{Z:()=>o});var r=i(7542),n=i.n(r);const s={RADIOLOGY:["CR","CT","MR","US"]};const o=class{getStudyObjectTemplate(){return{data:null,files:[],format:"",meta:{},name:"",scope:"",type:"",urls:[],version:"1.0"}}async loadFromFile(e,t){var i;let r=this.getStudyObjectTemplate();t&&(r=Object.assign(r,t));const o=["format","meta","scope","type"];for(const t of o)if("meta"!==t&&!r[t]||"meta"===t&&0===Object.keys(r[t]).length)try{const t=new Uint8Array(await e.arrayBuffer()),o=n().parseDicom(t);r.format||(r.format="dicom"),r.meta.instanceId||(r.meta.instanceId=o.string("x0020000d")||""),r.meta.modality||(r.meta.modality=(o.string("x00080060")||"").toUpperCase());const a=o.string("x00080008"),d=o.string("x00080060");if(a||d&&-1!==s.RADIOLOGY.indexOf(d)){if(r.scope||(r.scope="radiology"),r.data=e,!r.type){"localizer"===(null===(i=(a||"\\\\").split("\\")[2])||void 0===i?void 0:i.toLowerCase())?r.type="image:topogram":r.type="image"}if(r.meta.type=a,r.meta.modality=d,o.elements.x00081140&&o.elements.x00081140.items)for(const e of o.elements.x00081140.items)e.dataSet&&(r.meta.relatedStudies||(r.meta.relatedStudies=[]),r.meta.relatedStudies.push(e.dataSet.string("x00081150")))}else o.elements.x00420011&&(r.scope||(r.scope="document"),r.name||(r.name=o.string("x00420010")||""),r.meta.mime||(r.meta.mime=o.string("x00420012")||""))}catch(e){"string"==typeof e&&e.indexOf("DICM prefix not found")>=0||console.error(e)}return r.name||(r.name=e.name),r}async loadFromFsItem(e,t={}){if(!e)return[];const i=[];let r=e;for(;!r.files.length&&1===r.directories.length;)r=r.directories[0];if(r.files.length)for(let e=0;e<r.files.length;e++)if("medimg_study_config.json"===r.files[e].name){const i=r.files.splice(e,1)[0];await new Promise(((e,r)=>{const n=new FileReader;n.onloadend=t=>{const i=JSON.parse(t.target.result);e(i)},n.onerror=e=>{r(e)},t=n.readAsText(i.file)})).then((e=>{t=Object.assign(e,t)})).catch((e=>{console.error(`Could not load config from ${i.path}:`),console.error(e.message)}));break}t.hasOwnProperty("visits")||(t.visits={}),t.hasOwnProperty("studies")||(t.studies={});r.name;if(!r.directories.length&&r.files.length){const e=[];if(r.path){let i;if(r.files[0].file?i=await this.loadFromFile(r.files[0].file,Object.assign({name:r.name},t.studies[r.name],t.studies[r.path])):r.files[0].url&&await fetch(r.files[0].url).then((e=>e.blob())).then((async e=>{i=await this.loadFromFile(new File([e],r.files[0].name),Object.assign({name:r.name},t.studies[r.name],t.studies[r.path]))})),i){for(let e=0;e<r.files.length;e++)r.files[e].file?i.files.push(r.files[e].file):r.files[e].url&&i.urls.push(r.files[e].url);(i.files.length>1||i.urls.length>1&&!i.type.endsWith(":series"))&&(i.type+=":series"),e.push(i)}}else for(let i=0;i<r.files.length;i++){const n=r.files[i];let s;n.file?s=await this.loadFromFile(n.file,Object.assign({name:n.name},t.studies[n.name],t.studies[n.path])):n.url&&await fetch(n.url).then((e=>e.blob())).then((async e=>{s=await this.loadFromFile(new File([e],n.name),Object.assign({name:n.name},t.studies[n.name],t.studies[n.path]))})),e.push(s)}i.push(Object.assign({studies:e},{title:r.name},t.visits[r.name],t.visits[r.path]))}else if(r.directories.length){let e=[r];for(let t=0;t<r.directories.length;t++){for(;!r.directories[t].files.length&&1===r.directories[t].directories.length;)r.directories[t]=r.directories[t].directories[0];r.directories[t].directories.length&&(e=r.directories)}for(let r of e){const e=[];for(let i=0;i<r.directories.length;i++){const n=r.directories[i];if(n.directories.length)console.warn(`${n.path} was omitted because it contained subdirectories.`);else if(n.files.length){const i=n.files[0];let r;if(i.file?r=await this.loadFromFile(i.file,Object.assign({name:n.name},t.studies[n.name],t.studies[n.path])):i.url&&await fetch(i.url).then((e=>e.blob())).then((async e=>{r=await this.loadFromFile(new File([e],i.name),Object.assign({name:n.name},t.studies[n.name],t.studies[n.path]))})),r){for(let e=0;e<n.files.length;e++)n.files[e].file?r.files.push(n.files[e].file):n.files[e].url&&r.urls.push(n.files[e].url);(r.files.length>1||r.urls.length>1&&!r.type.endsWith(":series"))&&(r.type+=":series"),e.push(r)}}else console.warn(`${n.path} was omitted because it was empty.`)}const n=Object.assign({studies:e},{title:r.name},t.visits[r.name],t.visits[r.path]);i.push(n)}}else console.warn("Dropped item had an empty root directory!");return i.sort(((e,t)=>(parseInt(e.date)||0)-(parseInt(t.date)||0)))}}},606:(e,t,i)=>{"use strict";i.d(t,{Z:()=>a});var r=i(2263),n=i.n(r),s=i(3226),o=i(2874);const a=class{async loadFromFsItem(e,t){return(new o.Z).loadFromFsItem(e,t).then((async e=>{let t=1;const i=[];for(const{title:r,date:o,studies:a}of e){if(!a.length){console.warn(`Imported visit ${r} did not have any valid imaging studies, the visit was not added.`);continue}const e={title:r||"",counter:r?0:t,date:o||"",studies:{eeg:[],ekg:[],radiology:[]}};let d=[],l=!1;for(const t of a){const i=t.type.split(":");if("radiology"===t.scope&&"image"===i[0]&&"dicom"===t.format){const r=n().wadouri.fileManager.add(t.data);if(r)if(1===i.length)e.studies.radiology.push(new s.Z(t.meta.modality,t.name,t.data.size,t.type,r)),l=!0;else if("series"===i[1]){const i=new s.Z(t.meta.modality,t.name,t.files.length,t.type,"");e.studies.radiology.push(i);const o=e.studies.radiology.length-1;for(let e=0;e<t.files.length;e++){const r=n().wadouri.fileManager.add(t.files[e]);r&&i.push(new s.Z(t.meta.modality,t.files[e].name,t.files[e].size,t.type.split(":")[0],r))}for(let e=0;e<t.urls.length;e++)r&&i.push(new s.Z(t.meta.modality,`${t.name}-${e}`,0,t.type.split(":")[0],`wadouri:${t.urls[e]}`));if(i.length){const e=Math.floor(i.length/2);await i.setCoverImage(e),l=!0}else e.studies.radiology.splice(o,1),console.warn(`Imported study ${e.studies.radiology[o]} did not have any valid images, the study was not added.`)}else if("topogram"===i[1]){const e=new s.Z(t.meta.modality,t.name,t.data.size,t.type,r);await e.preloadAndCacheImage(),d.push(e)}else l=!0}}if(d.length)for(const t of e.studies.radiology)for(const e of d)if(t.isStack&&e.modality===t.modality&&e.studyID===t.coverImage.studyID){t.topogram=e;break}e&&l?(i.push(e),t++):console.warn(`Imported visit ${r} did not have any valid imaging studies, the visit was not added.`)}return i}))}}},6411:(e,t,i)=>{"use strict";i.d(t,{Z:()=>r});const r=class{constructor(){this.readDirectoryItems=async(e,t,i,r)=>{var n;const s={name:e,path:t,type:"directory",directories:[],files:[]};let o=[];if(i){let e=await this.readItems(i);for(;e&&e.length;)o.push(...e.splice(0)),e=e.concat(await this.readItems(i))}else if(r&&r.length)for(let e=0;e<r.length;e++)o.push(r[e].webkitGetAsEntry());if(!Array.isArray(o))throw new Error("Reader did not return a file list!");for(;o.length>0;){const e=o.shift();if(e.isFile){const t=await new Promise(((t,i)=>e.file(t,i)));s.files.push({name:t.name,path:`${s.path}/${t.name}`,type:"file",file:t,directories:[],files:[]})}else if(e.isDirectory){const t=e.createReader();o.push(await this.readDirectoryItems(e.name,`${s.path}/${e.name}`,t))}else null===(n=s.directories)||void 0===n||n.push(e)}return s}}async readFilesFromSource(e){if(e.stopPropagation(),e.preventDefault(),e.dataTransfer&&e.dataTransfer.items){return await this.readDirectoryItems("/","",null,e.dataTransfer.items)}}async readItems(e){try{return await new Promise(((t,i)=>{e.readEntries(t,i)}))}catch(e){throw new Error(e.message)}}}},9388:(e,t,i)=>{"use strict";i.r(t),i.d(t,{default:()=>s});var r=i(2615),n=i(2867);i(1465);const s=(0,i(8758).Z)(n.Z,r.s,r.x,!1,null,null,null).exports},2867:(e,t,i)=>{"use strict";i.d(t,{Z:()=>r});const r=i(6713).Z},2615:(e,t,i)=>{"use strict";i.d(t,{s:()=>r.s,x:()=>r.x});var r=i(3042)},1465:(e,t,i)=>{"use strict";i(7189)},3042:(e,t,i)=>{"use strict";i.d(t,{s:()=>r,x:()=>n});var r=function(){var e=this,t=e._self._c;e._self._setupProxy;return t("div",{ref:"app",staticClass:"medimg-viewer medimg-viewer-dark-mode",attrs:{id:`${e.$store.state.appName}-medimg-viewer`}},[t("div",{class:["medimg-viewer-settings",{"medimg-viewer-hidden":!e.$store.state.settingsOpen}],on:{click:e.handleModalClick}},[t("viewer-settings",{attrs:{scope:e.scope}})],1),e._v(" "),t("div",{class:["medimg-viewer-interface-dropdown",{"medimg-viewer-interface-dropdown-open":e.menuOpen},{"medimg-viewer-sidebar-closed":!e.sidebarOpen}],on:{mouseleave:function(t){return e.toggleMenu(!1)}}},[e.activeVisit?t("div",{staticClass:"medimg-viewer-oneliner",on:{click:function(t){return e.toggleMenu()}}},[e._v("\n            "+e._s(e.getVisitTitle())+"\n        ")]):t("div",{staticClass:"medimg-viewer-oneliner",on:{click:function(t){return e.toggleMenu()}}},[e._v("\n            "+e._s(e.t("No visit selected"))+"\n        ")]),e._v(" "),t("font-awesome-icon",{attrs:{icon:e.sidebarOpen?["fas","chevron-square-left"]:["fas","chevron-square-right"],title:e.sidebarOpen?e.t("Close sidebar"):e.t("Open sidebar")},on:{click:e.toggleSidebar}}),e._v(" "),t("ul",e._l(e.visits,(function(i,r){return t("li",{key:`${e.$store.state.appName}-visit-option-${r}`},[t("div",{staticClass:"medimg-viewer-visit-title medimg-viewer-oneliner"},[e._v("\n                    "+e._s(e.getVisitTitle(r))+"\n                    "),i.date?t("div",{staticClass:"medimg-viewer-visit-date medimg-viewer-oneliner"},[e._v("\n                        "+e._s(e.getLocalDatetime(i.date))+"\n                    ")]):e._e()]),e._v(" "),i.studies.radiology.length?t("div",{staticClass:"medimg-viewer-visit-studies medimg-viewer-oneliner",on:{click:function(t){return e.selectActiveResource(i,"radiology")}}},[e._v("\n                    "+e._s(1===i.studies.radiology.length?e.t("1 radiology study"):e.t("{n} radiology studies",{n:i.studies.radiology.length}))+"\n                ")]):e._e()])})),0)],1),e._v(" "),t("div",{staticClass:"medimg-viewer-settings-button"},[t("toolbar-button",{attrs:{id:"settings",enabled:!0,icon:["fal","cog"],overlay:null,tooltip:"Settings"},on:{"button-clicked":function(t){return e.toggleSettingsMenu()}}})],1),e._v(" "),t("div",{class:["medimg-viewer-settings-menu",{"medimg-viewer-hidden":!e.settingsMenuOpen}]},[null!==e.fullscreen?t("div",{staticClass:"medimg-viewer-settings-menu-row",on:{click:function(t){return e.toggleFullscreen()}}},[t("font-awesome-icon",{attrs:{icon:["far",e.fullscreen?"compress":"expand"]}}),e._v("\n            "+e._s(e.t("Fullscreen"))+"\n        ")],1):e._e(),e._v(" "),t("div",{staticClass:"medimg-viewer-settings-menu-row",on:{click:function(t){return e.toggleSettings()}}},[t("font-awesome-icon",{attrs:{icon:["far","cog"]}}),e._v("\n            "+e._s(e.t("Settings"))+"\n        ")],1)]),e._v(" "),"radiology"===e.scope?t("dicom-image-interface",{ref:"dicom-image-interface",attrs:{hasStudiesToLoad:null!==e.studiesToLoad,resources:e.activeVisit?e.activeVisit.studies.radiology:[],sidebarOpen:e.sidebarOpen},on:{"load-studies":function(t){return e.loadStudiesFromFsItem()},"update-item-order":e.updateDicomImageOrder}}):e._e()],1)},n=[];r._withStripped=!0},8758:(e,t,i)=>{"use strict";function r(e,t,i,r,n,s,o,a){var d,l="function"==typeof e?e.options:e;if(t&&(l.render=t,l.staticRenderFns=i,l._compiled=!0),r&&(l.functional=!0),s&&(l._scopeId="data-v-"+s),o?(d=function(e){(e=e||this.$vnode&&this.$vnode.ssrContext||this.parent&&this.parent.$vnode&&this.parent.$vnode.ssrContext)||"undefined"==typeof __VUE_SSR_CONTEXT__||(e=__VUE_SSR_CONTEXT__),n&&n.call(this,e),e&&e._registeredComponents&&e._registeredComponents.add(o)},l._ssrRegister=d):n&&(d=a?function(){n.call(this,(l.functional?this.parent:this).$root.$options.shadowRoot)}:n),d)if(l.functional){l._injectStyles=d;var m=l.render;l.render=function(e,t){return d.call(t),m(e,t)}}else{var c=l.beforeCreate;l.beforeCreate=c?[].concat(c,d):[d]}return{exports:e,options:l}}i.d(t,{Z:()=>r})},7189:(e,t,i)=>{var r=i(6355);r.__esModule&&(r=r.default),"string"==typeof r&&(r=[[e.id,r,""]]),r.locals&&(e.exports=r.locals);(0,i(7913).Z)("1463cbd4",r,!1,{})},7913:(e,t,i)=>{"use strict";i.d(t,{Z:()=>h});var r=i(5319),n="undefined"!=typeof document;if("undefined"!=typeof DEBUG&&DEBUG&&!n)throw new Error("vue-style-loader cannot be used in a non-browser environment. Use { target: 'node' } in your Webpack config to indicate a server-rendering environment.");var s={},o=n&&(document.head||document.getElementsByTagName("head")[0]),a=null,d=0,l=!1,m=function(){},c=null,g="data-vue-ssr-id",u="undefined"!=typeof navigator&&/msie [6-9]\b/.test(navigator.userAgent.toLowerCase());function h(e,t,i,n){l=i,c=n||{};var o=(0,r.Z)(e,t);return A(o),function(t){for(var i=[],n=0;n<o.length;n++){var a=o[n];(d=s[a.id]).refs--,i.push(d)}t?A(o=(0,r.Z)(e,t)):o=[];for(n=0;n<i.length;n++){var d;if(0===(d=i[n]).refs){for(var l=0;l<d.parts.length;l++)d.parts[l]();delete s[d.id]}}}}function A(e){for(var t=0;t<e.length;t++){var i=e[t],r=s[i.id];if(r){r.refs++;for(var n=0;n<r.parts.length;n++)r.parts[n](i.parts[n]);for(;n<i.parts.length;n++)r.parts.push(v(i.parts[n]));r.parts.length>i.parts.length&&(r.parts.length=i.parts.length)}else{var o=[];for(n=0;n<i.parts.length;n++)o.push(v(i.parts[n]));s[i.id]={id:i.id,refs:1,parts:o}}}}function p(){var e=document.createElement("style");return e.type="text/css",o.appendChild(e),e}function v(e){var t,i,r=document.querySelector("style["+g+'~="'+e.id+'"]');if(r){if(l)return m;r.parentNode.removeChild(r)}if(u){var n=d++;r=a||(a=p()),t=y.bind(null,r,n,!1),i=y.bind(null,r,n,!0)}else r=p(),t=b.bind(null,r),i=function(){r.parentNode.removeChild(r)};return t(e),function(r){if(r){if(r.css===e.css&&r.media===e.media&&r.sourceMap===e.sourceMap)return;t(e=r)}else i()}}var f,w=(f=[],function(e,t){return f[e]=t,f.filter(Boolean).join("\n")});function y(e,t,i,r){var n=i?"":r.css;if(e.styleSheet)e.styleSheet.cssText=w(t,n);else{var s=document.createTextNode(n),o=e.childNodes;o[t]&&e.removeChild(o[t]),o.length?e.insertBefore(s,o[t]):e.appendChild(s)}}function b(e,t){var i=t.css,r=t.media,n=t.sourceMap;if(r&&e.setAttribute("media",r),c.ssrId&&e.setAttribute(g,t.id),n&&(i+="\n/*# sourceURL="+n.sources[0]+" */",i+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(n))))+" */"),e.styleSheet)e.styleSheet.cssText=i;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(i))}}},5319:(e,t,i)=>{"use strict";function r(e,t){for(var i=[],r={},n=0;n<t.length;n++){var s=t[n],o=s[0],a={id:e+":"+n,css:s[1],media:s[2],sourceMap:s[3]};r[o]?r[o].parts.push(a):i.push(r[o]={id:o,parts:[a]})}return i}i.d(t,{Z:()=>r})}}]);
//# sourceMappingURL=viewer-amd.js.map?v=983cd1ff9c91cab4215d