<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

 $string['pluginname'] = 'IntelliBoard.net Plugin';
 $string['tracking_title'] = 'Zeiterfassung ';
 $string['tracking'] = 'Sessionerfassung';
 $string['dashboard'] = 'Dashboard';
 $string['settings'] = 'Grundeinstellungen';
 $string['adv_settings'] = 'Erweiterte Einstellungen';
 $string['intelliboardroot'] = 'IntelliBoard';
 $string['intelliboard_reports'] = 'IntelliBoard Berichte';
 $string['report'] = 'Bericht ';
 $string['reports'] = 'Berichte';
 $string['learners'] = 'Lerner';
 $string['courses'] = 'Kurse';
 $string['load'] = 'Leisting';
 $string['inactivity'] = 'Inaktivität';
 $string['inactivity_desc'] = 'Benützerinaktivitätzeit';
 $string['ajax'] = 'Frequenz';
 $string['ajax_desc'] = 'Frequenz der Sessionspeicherung durch AJAX.0-AJAX wurde deaktiviert (in Sekunden)';
 $string['enabled'] = 'Verfolgung wurde aktiviert';
 $string['enabled_desc'] = 'Verfolgung aktivierten';
 $string['trackadmin'] = 'Verfolgung des AdministratorsTracking Admins';
 $string['logs'] = 'Migrazionwerkzeug Migration Tool';
 $string['trackadmin_desc'] = 'Zeitverfolgung für die Administatorbenützer aktivieren( ist nicht empfehlt)';
 $string['intelliboard:instructors'] = 'IntelliBoard  [Lehrer ]';
 $string['intelliboard:students'] = 'IntelliBoard  [Student]';
 $string['intelliboard:view'] = 'IntelliBoard  [Sicht]';
 $string['intelliboard:manage'] = 'IntelliBoard  [Manager]';
 $string['intelliboard:competency'] = 'IntelliBoard [Kompetenz]';
 $string['intelliboard:attendanceadmin'] = 'Anwesenheitsverwaltung Admin';
 $string['intelliboard:browseallcohorts'] = 'IntelliBoard  [Alle Kohorten browsen]';
 $string['tls12'] = 'TLS v1.2';
 $string['tls12_desc'] = 'erweiterte Einstellungen TLS v1.2';
 $string['sso'] = 'SSO Link';
 $string['sso_desc'] = 'SSO Link für IntelliBoard.net';
 $string['ssomenu'] = 'SSO Menü Item';
 $string['ssomenu_desc'] = 'SSO Link im Block der Navigazionmenü( für nicht -Lerner/ nicht -Lehrer)';
 $string['api'] = 'Alternative API';
 $string['api_desc'] = 'alternative API Server verwenden ( um die Firewallsperrezu vermeiden)';
 $string['server'] = 'IntelliBoard Server';
 $string['server_usa'] = 'IntelliBoard USA';
 $string['server_au'] = 'IntelliBoard Australien ';
 $string['server_eu'] = 'IntelliBoard Europa';
 $string['show_dashboard_tab'] = 'Dashboardseite';
 $string['filters'] = 'Dashboardfilters';
 $string['filter1'] = 'ausgelöschte Benützer';
 $string['filter2'] = 'suspendierete Benützer';
 $string['filter3'] = 'Gast Benützer';
 $string['filter4'] = 'Kurs Filter';
 $string['filter5'] = 'Immatrikulazion Art und Weise Filter';
 $string['filter6'] = 'Benützer Immatrikulation Filter';
 $string['filter7'] = 'Aktivitäten/Ressourcen Filter';
 $string['filter8'] = 'immatrikulirte Benützer Filter';
 $string['filter1_desc'] = 'ausgelöschte Benützer zeigen';
 $string['filter2_desc'] = 'suspendierete Benützer zeigen';
 $string['filter3_desc'] = 'Gast Benützer in Bericht zeigen';
 $string['filter4_desc'] = 'nichtsichtbarekurse zeigen';
 $string['filter5_desc'] = 'nicht aktive Methoden der Matrikullazion zeigen';
 $string['filter6_desc'] = 'Benützer mit den nichtaktivien Matrikullazionstatus zeigen';
 $string['filter7_desc'] = 'nich sichtbare Aktivitäten/Ressourcen zeigen';
 $string['filter8_desc'] = 'nur matrikullierte Benützer zeigen ( wird nicht epfehlt)';
 $string['intelliboardaccess'] = 'Sie haben keine Zugriffsberechtigung zu dieser Seite.Kontaktieren Sie bitte den Administrator für die Hilfe';
 $string['tex1'] = 'IntelliBoard  Lerner Dashboard ist nicht aktiviert';
 $string['account'] = 'Die Information der Subskription';
 $string['te12'] = 'Vorname';
 $string['te13'] = 'Nachname';
 $string['te1'] = 'Email';
 $string['te1_desc'] = 'Geben Sie die E-Mail-Adresse ein, die mit dem IntelliBoard.net-Abonnement verwendet wird. Wenn Sie kein aktives Abonnement haben, registrieren Sie sich bitte unter <a target="_blank" href="https://intelliboard.net"> IntelliBoard.net </a>. Das Lerner- und Kursleiter-Dashboard ist mit einem Abonnement ab Stufe 4 verfügbar';
 $string['n1'] = 'Überblick[ Lerner´Fortschritt]';
 $string['n2'] = 'Überblick [Fortschritt der Notengrad ]';
 $string['n3'] = 'Überblick [Forschritt der Aktivität ]';
 $string['n12'] = 'Überblick[Überblick des Kurse ]';
 $string['n4'] = 'Überblick[ Summen]';
 $string['n5'] = 'Aktueller Fortschritt';
 $string['n13'] = 'Studenten insgesampt';
 $string['n6'] = 'Widget: Korrelationen';
 $string['n14'] = 'Widget: Learer';
 $string['n18'] = 'Widget: Der Fortschritt der Note des Leners';
 $string['n7'] = 'Widget: die Verwendung der Veranstaltung';
 $string['n15'] = 'Widget: die Verwendung der Aktivität';
 $string['n16'] = 'Widget: die Verwendung des Themas';
 $string['n8'] = 'Seite der Kurse';
 $string['n9'] = 'Seite der Berichten';
 $string['n19'] = 'Link der Kursnavigation für Berichte';
 $string['n10'] = 'Dashboard des Lehrers';
 $string['n101'] = 'Dashboard des Lehrers aktivieren';
 $string['n11'] = 'Alternativer Text für Menü des Navigationblock';
 $string['ts1'] = 'Dashboard des Lerners ';
 $string['ts2'] = 'Dashboardseite des Lerners';
 $string['ts3'] = 'Dashboard für Kurse des Lerners';
 $string['ts4'] = 'Dashboard für Noten der Lerners';
 $string['ts5'] = 'Dashboard des Lehrers für Berichte';
 $string['learner_tf_last_week'] = 'Zeitfilter: 7 Tage';
 $string['t01'] = 'Zeitfilter: letzte 30 Tage';
 $string['t02'] = 'Zeitfilter: letzte 3 Monate';
 $string['t03'] = 'Zeitfilter: letzte 6 Monate';
 $string['t04'] = 'abgeschlossene Kurse [Überschrift] aktivieren';
 $string['t05'] = 'Kurse im Progress  [Überschrift] aktivieren';
 $string['t06'] = 'durchschnittliche Note des Kurses  [Überschrift] aktivieren';
 $string['t07'] = 'Nachrichten [Überschrift] aktivieren';
 $string['t08'] = 'Summe der Note des Kurses [Überschrift] aktivieren';
 $string['t09'] = 'Lehrer kann die eigene Studenten sehen';
 $string['t1'] = 'Dashboard des Lehrers aktivieren';
 $string['t2'] = 'Dashboard aktivieren';
 $string['t3'] = 'Kurse aktivieren';
 $string['t4'] = 'Noten aktivieren';
 $string['t48'] = 'Berichte aktivieren';
 $string['t5'] = 'Chart  [Der Fortschritt der Aktivität] aktivieren';
 $string['t53'] = 'Chart  [Der Fortschritt der Aktivität] aktivieren';
 $string['t6'] = 'Chart  [Der Fortschritt der Kurse] aktivieren';
 $string['t7'] = '[Mein Kursdurchschnitt] aktivieren';
 $string['t8'] = '[Gesamtkursdurchschnitt] aktivieren';
 $string['t9'] = 'Widget  [Aufgaben] aktivieren';
 $string['t10'] = 'Widget  [Quizien] aktivieren';
 $string['t11'] = 'Widget  [der Fortschritt des Kurses] aktivieren';
 $string['t12'] = 'Widget  [die Teilnahme an der Aktivität] aktivieren';
 $string['t13'] = 'Widget  [Der Lernprozess] aktivieren';
 $string['t14'] = 'Widget  [der Erfolg des Kurses] aktivieren';
 $string['t15'] = 'Widget  [Korrelationen] aktivieren';
 $string['t16'] = 'Lehrer des Kurses aktivieren';
 $string['t17'] = 'Die Kategorie des Kurses aktivieren ';
 $string['t18'] = 'Kursabschluss aktivieren ';
 $string['t19'] = 'Kursnote aktivieren';
 $string['t20'] = 'Klassendurchschnitt des Kurses aktivieren';
 $string['t21'] = 'verbrachte Zeit des Kurses aktivieren';
 $string['t22'] = 'Zeit des Kursanfanges aktivieren';
 $string['t23'] = 'Spalte [die zeit des Kursanfanges] aktivieren';
 $string['t24'] = 'Spalte [das Immatrikullationdatum] aktivieren';
 $string['t25'] = 'Spalte [der Fortschritt] aktivieren';
 $string['t26'] = 'Spalte [der Buchstabe] aktivieren';
 $string['t27'] = 'Spalte [abgeschlossene Aktivitäten] aktivieren';
 $string['t28'] = 'Spalte [ die Note ] aktivieren';
 $string['t29'] = 'Spalte [der Vertigungsstatus des Kurses] aktivieren';
 $string['t30'] = 'Spalte [die Noten der Aktivität] aktivieren';
 $string['t31'] = 'Spalte [ die Aufgaben ][ die Note] aktivieren';
 $string['t32'] = 'Spalte [ die Aufgaben ][ das Fälligkeitsdatum] aktivieren';
 $string['t33'] = 'Spalte [ Quizen][ die Note] aktivieren';
 $string['t34'] = 'Widget´ Spalte [ die Quizen ][ das Fälligkeitsdatum] aktivieren';
 $string['t35'] = 'Widget´ Spalte [ der Kursfortschritt ][das Progress ] aktivieren';
 $string['t36'] = 'Widget´ Spalte [ der Kursfortschritt ][die Note ] aktivieren';
 $string['t37'] = 'Widget´ Spalte [ der Kursfortschritt ][ist matrikuliert ] aktivieren';
 $string['t38'] = 'Widget´ Spalte [ der Kursfortschritt ][ist beendet ] aktivieren';
 $string['t52'] = 'Widget´ Spalte [ der Kursfortschritt ][die Kategorie ] aktivieren';
 $string['t39'] = 'Option [ der Fortschritt ][das Noteziel ] aktivieren';
 $string['t40'] = 'Option[ der Fortschritt ][der Klassdurchschnitt ] aktivieren';
 $string['t41'] = 'beendet am [ der Titel der Aktivitätnote] aktivieren';
 $string['t42'] = 'letzte Zugriff zum Kurs  [der Titel der Activitätnote ] aktivieren';
 $string['t43'] = 'Spalte der Art  [Die Note der Aktivität] aktivieren';
 $string['t44'] = 'Spalte der Note [ die Noten der Aktivität] aktivieren';
 $string['t45'] = 'Spalte der Benotung[ die Noten der Aktivität ]aktivieren';
 $string['t46'] = 'Spalte ist beendet [ die Noten der Aktivität ] aktivieren';
 $string['t54'] = 'Spalte der verbringte zeit [die Note der Aktivität] aktivieren';
 $string['t47'] = '[ Netz ] die Farbe der Hintergrund der Kurse';
 $string['t49'] = 'Spalten des Berichtfilters';
 $string['t50'] = 'Rolle der Lehrer';
 $string['t51'] = 'Rolle des Studenten';
 $string['current_grade'] = 'aktuelle Note';
 $string['average_grade'] = 'durchschnittliche Note';
 $string['type_here'] = 'tippen hier ';
 $string['enrolled_date'] = 'Matrikullationdatum';
 $string['teacher'] = 'Lehrer ';
 $string['category'] = 'Kategorie ';
 $string['current_grade'] = 'aktuelle Note';
 $string['completion'] = 'Abschluss';
 $string['class_average'] = 'Klassendurchschnitt ';
 $string['time_spent'] = 'verbrachte Zeit ';
 $string['completed_on'] = 'Ist beendet am {$a } ';
 $string['passed_on'] = 'Ist beendet  (geschafft )am {$a } ';
 $string['failed_on'] = 'Ist beendet  (scheitern )am {$a } ';
 $string['last_access_on_course'] = 'Letzter Zugriff zum Kurs {$a } ';
 $string['you_have_certificates'] = 'Sie haben {$a } Zertifikats';
 $string['close'] = 'Geschlossen';
 $string['view_course_details'] = 'Kursdetails anshauen';
 $string['incomplete'] = 'Imkomplett';
 $string['return_to_grades'] = 'zurück zu Noten';
 $string['grade'] = 'Note';
 $string['last_week'] = 'letzte 7 Tage';
 $string['last_month'] = 'letzte 30 Tage';
 $string['last_quarter'] = 'letzte 3 Monate';
 $string['last_semester'] = 'letzte 6 Monate';
 $string['all_time'] = 'alle Zeit';
 $string['activity_progress'] = 'Aktivitätfortschritt';
 $string['course_progress'] = 'Kursfortschritt';
 $string['my_course_average_all'] = 'mein Kursdurchschnitt ( alle Kurse)';
 $string['overall_course_average'] = 'allgemeiner Kursdurchschnitt ( alle Lerner; alle Kurse)';
 $string['assignments'] = 'Aufgaben';
 $string['quizzes'] = 'Quizen';
 $string['assignment_name'] = 'Name der Aufgabe';
 $string['due_date'] = 'Fälligkeitstermin';
 $string['no_data'] = 'kein Datum';
 $string['quiz_name'] = 'Quizname';
 $string['all_courses'] = 'alle Kurse';
 $string['time_period_due'] = 'Die Zeitgrenze (der Fälligkeitstermin)';
 $string['all_data'] = 'alle Daten';
 $string['progress'] = 'Fortschritt ';
 $string['enrolled'] = 'ist matrikulliert';
 $string['completed'] = 'ist kompletet ';
 $string['activity_participation'] = 'Teilnahme an der Aktivität';
 $string['learning'] = 'Lernen';
 $string['course_success'] = 'Kursfortschritt';
 $string['correlations'] = 'Korrelationen ';
 $string['course_start_date'] = 'Kursanfang';
 $string['letter'] = 'Buchstabe';
 $string['completed_activities'] = 'Abgeshlossene Aktivitäten';
 $string['score'] = 'Note';
 $string['course_completion_status'] = 'Kursabschluss Status';
 $string['activity_grades'] = 'Noten der Aktivität';
 $string['completion_is_not_enabled'] = 'Abschluss ist not aktiviert für diesen Kurs';
 $string['activities'] = 'Aktivitäten';
 $string['activity_name'] = 'Name der Aktivität';
 $string['type'] = 'Typ';
 $string['graded'] = 'Bewertet';
 $string['passed'] = 'Bestanden';
 $string['failed'] = 'Gescheitert';
 $string['completed_courses'] = 'Abgeschlossene Kurse';
 $string['courses_in_progress'] = 'Laufende Kurse';
 $string['courses_avg_grade'] = 'Notenschnitt der Kurse';
 $string['courses_sum_grade'] = 'Gesamte Kursnote von Skalenwert der Noten';
 $string['grades'] = 'Noten';
 $string['messages'] = 'Nachrichten';
 $string['x_completions'] = '{$a} Abschlüsse';
 $string['completion_status'] = 'Abschluss Status';
 $string['users_activity'] = 'Benutzeraktivität';
 $string['daily'] = 'Letzte 10 Tage';
 $string['weekly'] = 'Letzte 90 Tage';
 $string['monthly'] = 'Letzte 365 Tage';
 $string['number_of_sessions'] = 'Zahl der Sitzungen';
 $string['number_today'] = '{$a} heute';
 $string['number_this_week'] = '{$a} diese Woche';
 $string['course_completions'] = 'Kursabschlüsse';
 $string['user_enrolments'] = 'Benutzeranmeldungen';
 $string['users'] = 'Benutzer';
 $string['modules'] = 'Module';
 $string['categories'] = 'Kategorien';
 $string['total'] = 'Total';
 $string['users_overview'] = 'Übersicht über Benutzer';
 $string['enable_time_and_visits_users_overview'] = 'Verbrachte Zeit und Besuche aktivieren in Übersicht über Benutzer';
 $string['disable_time_and_visits_users_overview'] = 'Verbrachte Zeit und Besuche deaktivieren in Übersicht über Benutzer';
 $string['loading'] = 'Laden...';
 $string['loading2'] = 'Bitte warten, laden...';
 $string['enrollments'] = 'Anmeldungen';
 $string['registrations'] = 'Registrierung';
 $string['participation'] = 'Teilnahme';
 $string['time'] = 'Zeit';
 $string['enrolment_method'] = 'Art der Anmeldung ';
 $string['intelliBoard_migration_tool'] = 'IntelliBoard Migration Instrument ';
 $string['importing_totals'] = 'allgemein laden';
 $string['total_numbers'] = 'Datum: {$a->timepoint}, Sitzungen: {$a->sessions}, Besuche: {$a->visits}, Zeitaufwand: {$a->timespend}';
 $string['total_numbers2'] = 'USER: {$a->userid}, Seite: {$a->page}, Parameter: {$a->param}, Besuche: {$a->visits}, Zeitaufwand: {$a->timespend} ';
 $string['total_numbers3'] = '--- Datum: {$a->timecreated}, Track-ID: {$a->trackid}, Besuche: {$a->visits}, Zeitaufwand: {$a->timespend} ';
 $string['logs_to_process'] = 'Logs zur Verarbeitung von {$a}';
 $string['please_wait_or_cancel'] = 'Bitte warten um weiter zu arbeiten oder <href="{$a}">Stornieren</a>';
 $string['done'] = 'abgeschlossen';
 $string['return_to_home'] = 'zurück zur Startseite';
 $string['importing_logs'] = 'Logs des Ladens';
 $string['intelliBoard_migration_tool_info'] = 'IntelliBoard migration tool is used to migrate historical data from Moodle logs table into new format. Please note, Moodle logs storing procedure will not change. Once historical data migrated to new format, historical values like \'Time Spent\' and \'Visits\' will be available for preview at IntelliBoard.net.';
 $string['moodle_logs'] = 'Moodle Logs';
 $string['intelliboard_tracking'] = 'IntelliBoard Verfolgung';
 $string['intelliboard_logs'] = 'IntelliBoard Logs';
 $string['intelliboard_totals'] = 'IntelliBoard allgemein';
 $string['intelliboard_start_tracking'] = 'IntelliBoard Verfolgungsanfang';
 $string['total_values_include'] = 'Gesamtwerte umfassen eindeutige Sitzungen, Kurse, Besuche und aufgewendete Zeit';
 $string['items_per_query'] = 'Artikel pro Anfrage';
 $string['import'] = 'Herunterladen';
 $string['log_values_include'] = 'Protokollwerte umfassen Protokolle für jeden Benutzer pro Tag';
 $string['powered_by'] = 'Unterstützt von <a href="https://intelliboard.net/"> IntelliBoard.net </a>';
 $string['intelliboardnet'] = 'Intelliboard.net';
 $string['visits'] = 'Besuche';
 $string['registered'] = 'angemeldet';
 $string['disabled'] = 'deaktiviert';
 $string['enrolled_completed'] = 'Eingeschrieben: {$a->courses}, Abgeschlossen: {$a->completed_courses} ';
 $string['enrolled_users_completed'] = 'Registrierte Benutzer: {$a->users}, Abgeschlossen: {$a->completed}';
 $string['user_grade_avg'] = '{$a->user} Note: {$a->grade}, Durchschnittsnote: {$a->avg_grade_site})';
 $string['user_visit_avg'] = '{$a->user} Besuche: {$a->visits}, Durchschnittliche Besuche: {$a->avg_visits_site}';
 $string['user_time_avg'] = '{$a->user} Zeit: {$a->timespend}, Durchschnittliche Zeit: {$a->avg_timespend_site}';
 $string['more_users'] = 'Mehr Benützer';
 $string['more_courses'] = 'Mehr Kurse';
 $string['showing_1_to_10'] = 'Vorstellung 1 zu 10';
 $string['course_grade'] = 'Kursgrad';
 $string['completed_activities_resourses'] = 'abgeschlossene Aktivitäten/Ressourcen';
 $string['save'] = 'speichern';
 $string['help'] = 'Braichen Sie die Hilfe?';
 $string['in1'] = 'Übersicht';
 $string['in2'] = 'aktueller Fortschritt';
 $string['in3'] = 'Kurse allgemein';
 $string['in4'] = 'Lerners allgemein';
 $string['in5'] = 'Kursgrade allgemein';
 $string['in6'] = 'LernerInnen beendeten';
 $string['in7'] = 'LernerInnen nicht beendeten';
 $string['in8'] = 'durchschnittlicher Grad des Lerners';
 $string['in9'] = 'Korrelationen';
 $string['in10'] = 'Veranstaltung Verwendung';
 $string['in11'] = 'Fortschritt des Lerners';
 $string['in12'] = 'Gradprogress';
 $string['in13'] = 'verbrachte Zeit (%)';
 $string['in14'] = '% Progress';
 $string['in15'] = 'Abschlüsse des Lerners';
 $string['in16'] = 'lelter Zugriff';
 $string['in17'] = 'verbrachte Zeit allgemein';
 $string['in18'] = 'allgemein Besuchen';
 $string['in19'] = 'durchschnittlicher Grad';
 $string['in20'] = 'zurück zu Lerners';
 $string['in201'] = 'zurück zu Aktivitäten';
 $string['in21'] = 'Durchschnittlicher Grad des Kurses';
 $string['in22'] = 'Aktiviert';
 $string['in23'] = 'Sie haben keine Lerners';
 $string['in24'] = 'das Module';
 $string['in25'] = 'ausreichende Note';
 $string['in26'] = 'Engagement des Lerners ';
 $string['in34'] = 'Noteprogression des Studenten';
 $string['in27'] = 'Studierende algemein ';
 $string['in28'] = 'verbrachte Zeit durchschnittlich';
 $string['in29'] = 'Aktive Studente';
 $string['in30'] = 'Nich aktive Studente';
 $string['in31'] = 'Verwendung der Aktivität';
 $string['in32'] = 'durchschnittliche Zeit innerhalb des ausgewählten Zeitraum';
 $string['in33'] = 'Verwendng das Thema';
 $string['status'] = 'Status';
 $string['course_category'] = 'Kategorie des Kurses';
 $string['course_started'] = 'Kurs ist angefangen';
 $string['total_time_spent_enrolled_learners'] = 'Algemeinverbrachte Zeit von den matrikullierten Lerners innerhalb des Kurses';
 $string['total_visits_enrolled_learners'] = 'gesamptaufrufe der matrikullierten Lerners innerhalb des Kurses';
 $string['learners_enrolled'] = 'matrikullierte Lerners';
 $string['learners_enrolled_period'] = 'matrikullierte Lerners innerhalb des audgewählte Zeitraum';
 $string['learning_progress'] = 'Progress des Lernen';
 $string['sections'] = 'Sektionen';
 $string['section'] = 'Sektionen';
 $string['total_activities_resources'] = 'Algemeine Aktivitäten/Ressourcen';
 $string['completions'] = 'Completionen';
 $string['return_to_courses'] = 'zurück zu den Kursen';
 $string['click_link_below_support_pages'] = 'Klicken Sie auf den Link unten, um zur IntelliBoard  Support-Seite zu gelangen';
 $string['support'] = 'Hilfe';
 $string['course_name'] = 'Kurstitel';
 $string['enrolled_completed_learners'] = 'ist matrikuliert/ist abgeschlossen';
 $string['activities_resources'] = 'Aktivitäten/Ressourcen';
 $string['actions'] = 'Maßnahmen';
 $string['learner_name'] = 'Name des Lerners';
 $string['completed_activities_resources'] = 'abgeschlossene Aktivitäten/Ressourcen';
 $string['filter_dates'] = 'Datenfilter';
 $string['select_date'] = 'Datum auswählen ';
 $string['select'] = 'Auswahl ';
 $string['selectall'] = 'alle auswählen';
 $string['ok'] = 'OK';
 $string['moodle'] = 'Moodle';
 $string['totara'] = 'Totara';
 $string['monitors'] = 'Monitors';
 $string['cohorts'] = 'Cohorts';
 $string['course_overview'] = 'die Übersicht des Kurses';
 $string['topics'] = 'Themas ';
 $string['a31'] = 'Rahmenbedingungen';
 $string['a32'] = 'Lernplan';
 $string['a33'] = 'ist bewertet, kompetent';
 $string['a34'] = 'ist bewertet, nicht kompetent';
 $string['a35'] = 'ist nicht bewertet ';
 $string['a36'] = 'Kompetenzüberblick';
 $string['a37'] = 'die Kompetenz wurde nicht erstattet. Bitte, kontaktieren Sie  den System Administrator ';
 $string['a38'] = 'die Kursen die mit Kompetenzen verknüpft sind';
 $string['a39'] = 'Kompetezen allgemein';
 $string['a40'] = 'verknüpfte Kurse';
 $string['no_competency'] = 'Es sieht so aus, als ob Sie keine Kompetenzen wurde am Moodle verknüpft';
 $string['scalesettings'] = 'Grundeinstellungen skalieren';
 $string['scales'] = 'individuelle Skalierung aktivieren';
 $string['scale_raw'] = 'Skalierung  deaktivieren';
 $string['scale_real'] = 'Aktuelle Note anstatt des Prozentes';
 $string['scale_total'] = 'Noten allgemein ';
 $string['scale_value'] = 'Wert';
 $string['scale_percentage'] = 'Prozente';
 $string['a0'] = 'Dashboard der Kompetez';
 $string['a1'] = 'Kompetenzen';
 $string['a2'] = 'Leistung ';
 $string['a3'] = 'Zugewiesene aufgaben';
 $string['a4'] = 'Progress der Leistung';
 $string['a5'] = 'bewertete Kompetenzen ';
 $string['a6'] = 'Beweise ';
 $string['a7'] = 'bewertete Lerner';
 $string['a8'] = 'Fortschritt';
 $string['a9'] = 'fähige Lerner';
 $string['a10'] = 'fähige Lerner';
 $string['a11'] = 'Liste von Kompetenzen zugestellte ';
 $string['a12'] = 'Status des Lerners';
 $string['a13'] = 'Kompetenzname ';
 $string['a14'] = 'ist erstellt am';
 $string['a15'] = 'ist zugeordnet am ';
 $string['a16'] = 'angegeben fähig ';
 $string['a17'] = 'Bewertung ';
 $string['a18'] = 'Kompetenzfähig ';
 $string['a19'] = ' Datum die Kompetenz wurde bewertet';
 $string['a20'] = 'Kompetenzrater';
 $string['a21'] = 'zugewiesene Aktivitäten';
 $string['a22'] = 'erreichte Leistung ';
 $string['a23'] = 'bewertete Kompetenzen ';
 $string['a24'] = 'Beweise ';
 $string['a25'] = 'Lerners mit den abgeschlossene Aufgaben';
 $string['a27'] = 'außerhalb';
 $string['a28'] = 'Detail';
 $string['a29'] = 'Dashboard der Kompetez aktivieren ';
 $string['a30'] = 'Berichte der Kompetenz aktivieren';
 $string['a26'] = 'Diese Tabelle zeigt die Anzahl der einem Kurs zugewiesenen Kompetenzen, die bewerteten Lernenden (ob kompetent oder nicht) und die als kompetent eingestuften Lernenden';
 $string['s25'] = 'verbrachte Zeit auf Aktivität ';
 $string['s45'] = 'Aktivität';
 $string['s46'] = 'Prozent von den Versuchs der Studenten';
 $string['s47'] = 'Thema';
 $string['s48'] = 'verbrachte Zeit auf dem Thema';
 $string['completions'] = 'Status des Aktivitätsabschlusses';
 $string['completions_completed'] = 'Status des Abschlusses (abgeschlossen)';
 $string['completions_pass'] = 'Status des Abschlusses (bestehen)';
 $string['completions_fail'] = 'Status des Abschlusses (nicht bestehen)';
 $string['completions_desc'] = '1)Benutzer hat diese Aktivität abgeschlossen. Es ist nicht angegeben, ob sie es bestanden haben oder nicht. <br>
2)Benutzer hat diese Aktivität mit einer Note über der Bestehensnote abgeschlossen. <br>
3)Benutzer hat diese Aktivität abgeschlossen, aber seine Note liegt unter der Mindestpunktzahl';
 $string['widget_name27'] = "kumulierte Signups";
 $string['widget_name28'] = "Engagement";
 $string['widget_name29'] = "einmalige Logins";
 $string['widget_name30'] = "Immatrikulation per Kurs";
 $string['widget_name31'] = "Registrare & Supervisor nehmen auf";
 $string['role1'] = "erste Rolle";
 $string['role2'] = "zweite Rolle";
 $string['select_course'] = "Kurs wählen";
 $string['select_quiz'] = "Quiz wählen";
 $string['not_quiz'] = "Hoppla, anscheinend haben Sie keine Quizern für den ausgewählten Kurs erstellt";
 $string['enter_course_and_quiz'] = "Bitte den Kurs and das Quiz wählen";
 $string['enter_quiz'] = "Bitte dein Quiz wählen";
 $string['analityc_3_name'] = "Quiz Überblick und Fragendetails";
 $string['course_name_a'] = 'Kurs: { $a}';
 $string['quiz_name_a'] = 'Quiz: { $a}';
 $string['cor_incor_answers'] = 'richtige/nicht richtige Antworten';
 $string['quiz_finished'] = 'Quiz ist abgeschlossen';
 $string['quiz_grades'] = 'Grad des Quizes';
 $string['correct_number'] = 'richtig: { $a}';
 $string['incorrect_number'] = 'nicht richtig: { $a}';
 $string['correct'] = 'richtig';
 $string['incorrect'] = 'nicht richtig';
 $string['weekday_0'] = "Montag";
 $string['weekday_1'] = "Dienstag";
 $string['weekday_2'] = "Mittwoch";
 $string['weekday_3'] = "Donnerstag";
 $string['weekday_4'] = "Fritag";
 $string['weekday_5'] = "Samstag";
 $string['weekday_6'] = "Sonstag ";
 $string['time_1'] = "Morgen";
 $string['time_2'] = "Nachmittag";
 $string['time_3'] = "Abend";
 $string['time_4'] = "außerhalb der Arbeitszeiten";
 $string['passing_score_for'] = 'Bestehen der Note für {$a}';
 $string['name'] = 'Name';
 $string['answers'] = 'Antworten';
 $string['ques_breakdown'] = 'Aufgliederung der Fragen';
 $string['n17'] = 'Analyseseite';
 $string['analytics'] = 'Analyse';
 $string['pdf'] = 'PDF';
 $string['csv'] = 'CSV';
 $string['excel'] = 'Excel';
 $string['grades_alt_text'] = 'Alternativer Text für Navigationmenu ';
 $string['course_chart'] = 'Kurs Chart aktivieren';
 $string['course_activities'] = 'Kurs Aktivitäten aktivieren ';
 $string['filter_this_year'] = 'Zeitfilter: dieses Jahr';
 $string['filter_last_year'] = 'Zeitfilter: letztes Jahr';
 $string['filter_all_time'] = 'Zeitfilter: Zeit allgemein';
 $string['this_year'] = 'dieses Jahr';
 $string['last_year'] = 'letztes Jahr';
 $string['reportselect'] = 'Bitte mindestens eine Bericht von App.IntelliBoard.net wählen. An Bericht klicken, dann Berichtgrundeinstellungen, danach "sichtbar in Moodle" wählen';
 $string['monitorselect'] = 'Bitte mindestens einen Report von App.IntelliBoard.net wählen. Auf Report klicken, dann Reportgrundeinstellungen, danach "sichtbar in Moodle" wählen';
 $string['select_user'] = 'Nutzer wählen';
 $string['course_max_grade'] = 'max Grad  des Kurses';
 $string['no_data_notification'] = 'Es gibt keine neue Daten für [ Datum]';
 $string['last_hour'] = 'Stunde';
 $string['last_day'] = 'Tag';
 $string['privacy:metadata:local_intelliboard_assign'] = 'IntelliBoard Tabelle für zugewiesene Subaccounten';
 $string['privacy:metadata:local_intelliboard_details'] = 'IntelliBoard Tabelle alt/logs/stundenweise';
 $string['privacy:metadata:local_intelliboard_logs'] = 'IntelliBoard Tabelle alt/logs/tagsüber';
 $string['privacy:metadata:local_intelliboard_totals'] = 'IntelliBoard Tabelle alt/logs/allgemein';
 $string['privacy:metadata:local_intelliboard_tracking'] = 'IntelliBoard Tabelle alt/für alle Zeit';
 $string['privacy:metadata:local_intelliboard_reports'] = 'Intelliboard kundenspeziefish sql Berichte Tabelle';
 $string['privacy:metadata:local_intelliboard_ntf'] = 'IntelliBoard Mitteilungen Haupttabelle';
 $string['privacy:metadata:local_intelliboard_ntf_hst'] = 'IntelliBoard Mitteilungengeschichte  Tabelle';
 $string['privacy:metadata:local_intelliboard_ntf_pms'] = 'IntelliBoard Mitteilungen Dynamik Params Tabelle';
 $string['privacy:metadata:local_intelliboard_assign:userid'] = 'BENUTZER ID des Eintrags';
 $string['privacy:metadata:local_intelliboard_assign:rel'] = 'Rel Typ des Eintrages';
 $string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodle Instanz Typ';
 $string['privacy:metadata:local_intelliboard_assign:instance'] = 'angeschlossene Moodle Instanz ID';
 $string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Zeitstempel Aufzeichnungen';
 $string['privacy:metadata:local_intelliboard_reports:status'] = 'Berichtstatus -aktiviert/nicht aktiviert ';
 $string['privacy:metadata:local_intelliboard_reports:name'] = 'Name der kundenspezifischen Bericht';
 $string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64 kodiert SQL Kode';
 $string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Erstellungszeit';
 $string['privacy:metadata:local_intelliboard_details:logid'] = 'Tabelle ID [local_intelliboard_logs ]';
 $string['privacy:metadata:local_intelliboard_details:visits'] = 'Seitenaufrufe, Mausklicks, per Tag';
 $string['privacy:metadata:local_intelliboard_details:timespend'] = 'verbrachte Zeit per Stunde';
 $string['privacy:metadata:local_intelliboard_details:timepoint'] = 'Stunde';
 $string['privacy:metadata:local_intelliboard_logs:trackid'] = 'Tabelle ID [lokalle_intelliboard_Verfassungs]';
 $string['privacy:metadata:local_intelliboard_logs:visits'] = 'Besuche, Mausklick, per Tag';
 $string['privacy:metadata:local_intelliboard_logs:timespend'] = 'verbrachte Zeit, täglich';
 $string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Zeitstempel vom Tag im Jahr';
 $string['privacy:metadata:local_intelliboard_totals:sessions'] = 'allgemeine Anzahl der Benützersessionen in Moodle';
 $string['privacy:metadata:local_intelliboard_totals:courses'] = 'Kurse allgemein in Moodle';
 $string['privacy:metadata:local_intelliboard_totals:visits'] = 'Besuch allgemein von allen Benützern in Moodle';
 $string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Allgemeine Zeitverbrechnung des Benützer in Moodle';
 $string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Zeitstempel des Tages des Jahres';
 $string['privacy:metadata:local_intelliboard_tracking:userid'] = 'Benützer ID der busucht Moodle Seite ';
 $string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Kurs ID den Bunützer besucht ';
 $string['privacy:metadata:local_intelliboard_tracking:page'] = 'Seite Art';
 $string['privacy:metadata:local_intelliboard_tracking:param'] = 'Die Art von der Seite ID ';
 $string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Benützer ID der busucht Moodle Seite ';
 $string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Die verbrachte Zeit vom Benützer auf der Seite';
 $string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Erster Zugriff bei Benützer';
 $string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Letzter Zugriff bei Benützer';
 $string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Die Art des Browssers des Benützers';
 $string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Die Art der Betriebssysteme des Benützers';
 $string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Art der Sprache des Browssers des Benützers';
 $string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Letzte IP-Adresse des Benützer';
 $string['privacy:metadata:local_intelliboard_ntf:id'] = 'Mitteilung ID';
 $string['privacy:metadata:local_intelliboard_ntf:type'] = 'Art der Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'externeINID Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf:userid'] = 'externeAppID Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf:email'] = 'BenachrichtigungEmail';
 $string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Mittleiling cc';
 $string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Betref der Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf:message'] = 'Nachricht der Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf:state'] = 'Status der Mitteilung ';
 $string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Anhang der Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Tag der Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'Geschichte der Mitteilung ID';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Mitteilung ID';
 $string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'externeAppID Mitteilung ';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Titel der Mittleilung';
 $string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Email der Geschichte der Mitteilung';
 $string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Mitteilung der Zeitstempelgeschichte';
 $string['select_manager_role'] = 'Auswahl der Funktion des Managers ';
 $string['group_aggregation'] = 'Gruppeaggregation';
 $string['ssodomain'] = 'SSO der Subdomäne';
 $string['ssodomain_desc'] = 'Single Sign On mit dem getrennten Server/Account';
 $string['instructor_redirect'] = 'Umleitung des Lehrers ';
 $string['student_redirect'] = 'Umleitung des Studenten';
 $string['myorders'] = 'Bestellungen';
 $string['myseats'] = 'Sitzplätze';
 $string['mywaitlist'] = 'Warteliste';
 $string['mysubscriptions'] = 'Subskriptione';
 $string['seatscode'] = 'Sitzplätzecode';
 $string['numberofseats'] = 'Nummer der Sitzplätze';
 $string['downloadinvoice'] = 'Rechnung hinterladen';
 $string['product'] = 'Produkt';
 $string['key'] = 'Schlüssel ';
 $string['created'] = 'erstelltet';
 $string['seatnumber'] = 'Nummer der Sitzplätze';
 $string['seatsused'] = 'verwendete Sitzplätze';
 $string['details'] = 'Details';
 $string['username'] = 'Name des Benützers';
 $string['used'] = 'verwendte ';
 $string['status'] = 'Status ';
 $string['subscriptiondate'] = 'Datum der Subscription';
 $string['price'] = 'Prise ';
 $string['recurringperiod'] = 'wiederkehrende Zetraum';
 $string['billingcycles'] = 'Abrechnungszeitraum';
 $string['active'] = 'Aktiv';
 $string['suspended'] = 'suspendiert';
 $string['canceled'] = 'storniert';
 $string['expired'] = 'abgeläuft';
 $string['process'] = 'Prozess';
 $string['cancel_subscription'] = 'Subskriptionestornierung';
 $string['sqlreport'] = 'SQL Bericht';
 $string['sqlreportcreate'] = 'erstellen den Bericht';
 $string['sqlreports'] = 'SQL Berichte';
 $string['sqlreportname'] = 'Berichtname';
 $string['sqlreportcode'] = 'SQL';
 $string['sqlreportdate'] = 'erstellt am ';
 $string['sqlreportactive'] = 'aktiviert';
 $string['sqlreportinactive'] = 'deaktiviert ';
 $string['remove_message'] = 'SQL Bericht ist gelöscht ';
 $string['delete_message'] = 'Löschen den SQL Bericht?';
 $string['success_message'] = 'SQL Bericht wurde gespeichert ';
 $string['scale_percentage_round'] = 'Prozenten rund ';
 $string['instructor_show_suspended_enrollments'] = 'suspendierte Anmeldungen zeigen';
 $string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
 // BigBlueButton Treffungen
 $string['bbbapiendpoint'] = 'BBB API Endpunkt';
 $string['bbbserversecret'] = 'BBB Server Hehl';
 $string['check_active_meetings'] = 'Aktieve Treffungen überprüfen';
 $string['bbbmeetings'] = 'BigBlueButton Treffungen';
 $string['enablebbbmeetings'] = 'Verfassung der BigBlueButton aktivieren ';
 $string['enablebbbdebug'] = 'BigBlueButton Debugging Mode';
 $string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Loggen Sie über BigBlueButton Besprechung';
 $string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID der Besprechung log';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Name der Besprechung';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'Besprechung-ID';
 $string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'Interne (in BBB-Server) Besprechung-ID';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Erstellen Sie die Zeit (Zeitstempel)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Erstellungsdatum (string)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Nebenstellennummer für die Sprachbrücke (Verwenden Sie, wenn Telefonsystem angeschlossen ist)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Einwahlnummer, die Teilnehmer mit regulärem Telefon anrufen können.';
 $string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Passwort, das erforderlich wird für die Teilnehmer die Besprechung zu betreten';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Passwort, das für Moderatoren erforderlich wird die Besprechung oder bestimmte administrative Aktionen zu betreten';
 $string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Status der Besprechung (aktiv | gestoppt)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Besprechungsdauer';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Flag. Benutzer haben die Besprechung beigetreten';
 $string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Flag. Besprechung wird aufgezeichnet';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Flag. Besprechung wurde gewaltsam beendet';
 $string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Startzeit der Besprechung';
 $string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Endzeit der Besprechung';
 $string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Anzahl der Teilnehmer';
 $string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Anzahl der Zuhörer';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Anzahl der Teilnehmer mit angeschlossenem Mikrofon';
 $string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Anzahl der Teilnehmer mit angeschlossener Videokamera';
 $string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Maximale Teilnehmerzahl';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Anzahl der Moderatoren';
 $string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'Kurs-ID';
 $string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'Kursmodul ID';
 $string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'Zeilen-ID in der Tabelle bigbluebuttonbn';
 $string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'Besitzer-ID (Benutzer, der die Besprechung erstellt wurde)';
 $string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Loggen Sie über BigBlueButton Besprechung';
 $string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'Teilnehmer-ID';
 $string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'Benutzer-ID (Zeile in der Tabelle "user")';
 $string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Voller Name des Besprechungsteilnehmer';
 $string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Funktion der Besprechungsteilnehmer';
 $string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Flag. Teilnehmer ist Moderator';
 $string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Flag. Teilnehmer hat kein angeschlossenes Mikrofon oder keine angeschlossene Webcam';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Flag. Teilnehmer hat angeschlossenes Mikrofon';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Flag. Teilnehmer hat angeschlossene Webcam';
 $string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'Besprechung-ID (ID in BigBlueButton Server)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'Besprechung-ID (ID in Tabelle local_intelliboard_bbb_meet)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Zeit, wenn der Benutzer mit der Besprechung die Verbindung hergestellt hat';
 $string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Zeit, wenn der Benutzer von der Besprechung getrennt hat';
 $string['messageprovider:intelliboard_notification'] = "IntelliBoard Anmeldung";
 $string['privacy:metadata:local_intelliboard_bb_partic'] = 'Liste der Teilnehmer der gemeinsamen Sitzung';
 $string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID der Teilnahme der Sitzung';
 $string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Sitzung UUID';
 $string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'Benutzer-UUID (Blackboard Collaborate Service)';
 $string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'Benutzer-ID (Moodle)';
 $string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Sitzungsfunktion';
 $string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Benutzername';
 $string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Erste Beitretung der Sitzung';
 $string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Letzter Abschied der Sitzung';
 $string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Verbrachte Zeit in der Sitzung';
 $string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Anzahl der erneuten Beitritte der Sitzung';
 $string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Liste der getrackten Sitzungen';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID von Track Log';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Sitzung UUID';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Track-Zeit';
 $string['privacy:metadata:local_intelliboard_att_sync'] = 'Liste der synchronisierten Sitzungen';
 $string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID des Synchronisierungsprotokolls';
 $string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Sitzungstyp';
 $string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle Sitzung-ID';
 $string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Zusätzliche Sync-Daten';
 $string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
 $string['verifypeer_desc'] = "S-Zertifikat. ";
 $string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
 $string['verifyhost_desc'] = "Diese Option bestimmt, ob libcurl überprüft, ob das Serverzertifikat für den Server bestimmt ist, als den es bezeichnet wird.";
 $string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
 $string['cipherlist_desc'] = "Geben Sie für TLS die verwendenden Chiffren an";
 $string['sslversion'] = "CURLOPT SSLVERSION";
 $string['sslversion_desc'] = "Übergeben Sie den Parameter long, um zu steuern, welcher Versionsbereich der SSL / TLS-Versionen verwendet soll";
 $string['debug'] = "Debug CURL Anfragen";
 $string['debug_desc'] = "";
 /* IntelliCart */
 $string['intellicart'] = "IntelliCart Integration";
 $string['intellicart_desc'] = "Ermöglichen Sie den Lernern, IntelliCart-Berichte anzuzeigen.";
 $string['coursessessionspage'] = "Kurssitzungsseite";
 $string['coursessessions'] = "Kurssitzungen";
 $string['session_name'] = "Sitzungsname";
 $string['session_time'] = "Sitzungszeit";
 $string['return_to_sessions'] = "Rückkehr zu den Sitzungen";
 $string['intellicart_student_integration'] = 'Integration mit Lerner Dashboard';
 $string['intellicart_instructor_integration'] = 'Integration mit Lehrer Dashboard';
 $string['intellicart_app_reports_integration'] = 'Integration mit IntelliBoard-Berichte';
 /* IntelliCart END*/
 $string['allmod'] = "Alle Aktivitäten";
 $string['customod'] = "Custom Aktivitäten";
 $string['timespent'] = "------ Verbrachte Zeit ----";
 $string['inprogress'] = "In Arbeit";
 $string['notstarted'] = "Nicht gestartet";
 $string['modulename'] = "Name des Modules";
 $string['viewed'] = "Betrachtet";
 $string['course'] = "Kurs";
 $string['courseaverage'] = "Kursdurschschnitt";
 $string['mygrade'] = "Meine Note";
 $string['myprogress'] = "Fortschritt der Note";
 $string['instructor_course_shortname'] = "Kurskurznamen statt der vollen Kursnamen anzeigen";
 $string['trackmedia'] = "Track HTML5 media";
 $string['trackmedia_desc'] = "Track HTML5 video und audio";
 $string['ianalytics'] = 'Intelliboard Analytik';
 $string['instructor_course_visibility'] = 'Zeig versteckte / ausgesetzte Kurse für [Lehrer]';
 $string['instructor_mode'] = 'Zeig alle Kurse für [Lehrer]';
 $string['instructor_mode_access'] = 'Zeig alle Kurse für [Lehrer] mit [Update] Genehmigungen';
 $string['student_course_visibility'] = 'Zeig versteckte / suspendierte Kurse für [Studenten]';
 $string['support_text1'] = "Alle Ihre Moodle-Daten: einfach, gemeinsam nutzbar, verständlich und attraktiv. IntelliBoard ist ein Moodle-Plugin, mit dem Sie <strong> 120+ </strong> Berichte und Monitore in Ihre Hände bekommen.";
 $string['support_text2'] = "Alle Ihre Moodle-Daten: einfach, gemeinsam nutzbar, verständlich und attraktiv. IntelliBoard ist Ihre Moodle-Berichts- und Analytik Lösung, mit der Sie über 120 Berichte und Analytik erhalten, um Ihre geschäftlichen Entscheidungen zu treffen können.";
 $string['support_info1'] = "Sie können an unseren <a target='_blank' href='https://intelliboard.net/events'> Webinaren </a> teilnehmen, während wir laden Sie für eine Tour durch IntelliBoard 5.0-Berichte und -Analytik ein!";
 $string['support_info2'] = "Nehmen Sie an unseren <a target='_blank' href='https://intelliboard.net/events'> Webinaren </a> teil oder planen Sie eine persönliche Tour durch Ihre eigenen Daten. Mit unserem erstklassigen Support und Service sehen Sie Ihr LernPlattform in einem ganzen neuen Licht.";
 $string['support_terms'] = "Alle Rechte vorbehalten";
 $string['support_page'] = "Dokumentation überprüfen";
 $string['support_demo'] = "Ein Demo vereinbaren";
 $string['support_trial'] = "Verbindung & Upgrade";
 $string['support_close'] = "Schließen";
 $string['instructor_custom_groups'] = "Lehrer Custom Gruppen";
 // settings of tables
 $string['table_set_icg'] = 'Lehrer Kurse';
 $string['table_set_icg_c1'] = 'Kursname';
 $string['table_set_icg_c2'] = 'Kurzname';
 $string['table_set_icg_c3'] = 'Kategorie';
 $string['table_set_icg_c4'] = 'Eingeschriebene / Abgeschlossene Lerner';
 $string['table_set_icg_c5'] = 'Kurs Durchschn. Note';
 $string['table_set_icg_c6'] = 'Abschnitte';
 $string['table_set_icg_c7'] = 'Aktivitäten / Ressourcen';
 $string['table_set_icg_c8'] = 'Besuche';
 $string['table_set_icg_c9'] = 'Verbrachte Zeit';
 $string['table_set_icg_c11'] = 'Aktionen - Aktivitäten';
 $string['table_set_icg_c12'] = 'Aktionen - Lerner';
 $string['percentage_completed_learners'] = 'Prozentsatz der abgeschlossenen Lerner';
 $string['avg_visits_per_stud'] = 'Durchschnittliche Besuche pro Lerner';
 $string['avg_time_spent_per_stud'] = 'Durchschnittliche verbrachte Zeit pro Lerner';
 $string['table_set_ilg'] = 'Lehrer-Kurse> Lerner';
 $string['table_set_ilg_c1'] = 'Name der Lerner';
 $string['table_set_ilg_c2'] = 'E-Mail-Addresse';
 $string['table_set_ilg_c3'] = 'Eingeschriebene';
 $string['table_set_ilg_c4'] = 'Letzter Zutritt';
 $string['table_set_ilg_c5'] = 'Status';
 $string['table_set_ilg_c6'] = 'Note';
 $string['table_set_ilg_c7'] = 'Abgeschlossene Aktivitäten / Ressourcen';
 $string['table_set_ilg_c8'] = 'Besuche';
 $string['table_set_ilg_c9'] = 'Verbrachte Zeit';
 $string['table_set_ilg_c10'] = 'Aktionen';
 $string['table_set_ilg1'] = 'Lehrer-Kurse> Lerner> Noten';
 $string['table_set_ilg1_c1'] = 'Aktivitätsname';
 $string['table_set_ilg1_c2'] = 'Art';
 $string['table_set_ilg1_c3'] = 'Note';
 $string['table_set_ilg1_c4'] = 'Bewertet';
 $string['table_set_ilg1_c5'] = 'Status';
 $string['table_set_ilg1_c6'] = 'Besuche';
 $string['table_set_ilg1_c7'] = 'Verbrachte Zeit';
 $string['table_set_iag'] = 'Lehrer Kurs> Aktivitäten';
 $string['table_set_iag_c1'] = 'Aktivitätsname';
 $string['table_set_iag_c2'] = 'Art';
 $string['table_set_iag_c3'] = 'Lerner abgeschlossen';
 $string['table_set_iag_c4'] = 'Durchschnittsnote';
 $string['table_set_iag_c5'] = 'Besuche';
 $string['table_set_iag_c6'] = 'Verbrachte Zeit';
 $string['table_set_iag_c7'] = 'Aktionen';
 $string['table_set_iag1'] = 'Lehrer Kurse> Aktivitäten> Noten';
 $string['table_set_iag1_c1'] = 'Name der Lerner';
 $string['table_set_iag1_c2'] = 'E-Mail-Addresse';
 $string['table_set_iag1_c3'] = 'Status';
 $string['table_set_iag1_c4'] = 'Note';
 $string['table_set_iag1_c5'] = 'Bewertet';
 $string['table_set_iag1_c6'] = 'Besuche';
 $string['table_set_iag1_c7'] = 'Verbrachte Zeit';
 $string['student_grades'] = 'Note der Lerner';
 $string['grid_view'] = 'Gitterdarstellung';
 $string['list_view'] = 'Listenansicht';
 $string['grade_activities_overview'] = 'Überblick der bewerteten Aktivitäten';
 $string['activity'] = 'Aktivität';
 $string['date_format'] = 'Datumsformat';
 $string['user_enrollments_sessions_completion'] = 'Benutzerregistrierung, Sitzung, Abscluss Aktivitätsstufen';
 $string['user_site_summary_detail'] = 'Detaillierte Zusammenfassung Benutzer Seite';
 $string['course_enrollment_types'] = 'Kursanmeldung Typen';
 $string['user_map'] = 'Benutzerkarte';
 $string['course_enrollments_with_completion_overview'] = 'Kurs Einschreibungen mit Abschluss Übersicht';
 $string['all_modules'] = 'Alle Module';

 /* Attendance */
 $string['attendance'] = 'Teilnahme';
 $string['enableattendance'] = 'Teilnahme aktivieren';
 $string['attendancetoolurl'] = 'Werkzeug URL';
 $string['attendanceconsumerkey'] = 'Verbraucher Schlüssel';
 $string['attendancesharedsecret'] = 'Geteiltes Geheimnis';
 $string['sync_data_with_attendance'] = 'Sync-Daten mit Teilnahme';
 $string['attendanceapibase'] = 'Teilnahme API Basispfad';
 $string['attendanceapikey'] = 'Teilnahme API-Schlüssel';
 $string['attendanceapisecret'] = 'Teilnahme API Geheimnis';
 $string['enablesyncattendance'] = 'Aktivieren BB Collaborate Sitzungen Synchronisation mit InAttendance';
 /* BlackBoard Collaborate and InAttendance */
 $string['bb_col_meetings'] = 'Blackboard Collaborate Besprechung';
 $string['enable_bb_col_debug'] = 'Aktivieren Blackboard Collaborate Debug';
 $string['bb_col_api_endpoint'] = 'Blackboard Collaborate API-Endpunkt';
 $string['bb_col_consumer_key'] = 'Blackboard Collaborate Verbraucher-Schlüssel';
 $string['bb_col_secret'] = 'Blackboard Collaborate Geheimnis';
 $string['enable_bb_col_meetings'] = 'Aktivieren Blackboard Collaborate Besprechungen';
 $string['check_active_bb_col_meetings'] = 'Aktive Blackboard Collaborate Sitzung überprüfen';
 $string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Started tracking of BB collaborate session';
 $string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Finished tracking of BB collaborate session';
 $string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Finished API request to BB collaborate';

/* Admin dashboard */
$string['admin_dashboard'] = 'Admin-Dashboard';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Benutzerregistrierung, Sitzung, Abscluss Aktivitätsstufen';
$string['adm_dshb_adm_dashb_totals'] = 'Summen';
$string['adm_dshb_user_site_summary_details'] = 'Detaillierte Zusammenfassung Benutzer Seite';
$string['adm_dshb_course_enrollments_types'] = 'Kursanmeldung Typen';
$string['adm_dshb_user_map'] = 'Benutzerkarte';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Kurs Einschreibungen mit Abschluss Übersicht';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = '„Brauchen Sie Hilfe“ Button verstecken';
$string['names_order'] = 'Namen Ordnung';
$string['firstname_lastname'] = '{Vorname} {Nachname}';
$string['lastname_firstname'] = '{Nachname} {Vorname}';
$string['issuer'] = 'Ermittent';
$string['criteria_method'] = 'Kriterien Methode';
$string['criteria_all_courses'] = 'Alle folgenden Kurse müssen abgeschlossen werden';
$string['criteria_any_course'] = 'Jede der folgenden Kurse müssen abgeschlossen werden';
$string['dashboard_settings'] = 'Dashboard-Einstellungen';


$string['tracklogs'] = 'Verfolgen Sie Zeit von Benutzer - Täglich';
$string['trackdetails'] = 'Verfolgen Sie Zeit von Benutzer - Stündlich';
$string['tracktotals'] = 'Verfolgen Sie Zeit Aggregat  - Täglich';

$string['enable_badges_report'] = '"Abzeichen" Bericht aktivieren';
$string['sizemode'] = 'Größe Mode: Groß (> 5.000 Benutzer)';
$string['cachedef_bb_collaborate_access_token'] = 'BB collaborate Zugriffstoken';


$string['learner_menu'] = '„Lerner-Dashboard“ in Navigationsblock Menü nur angemeldete Lerner zeige';
$string['learning_plan_filter'] = 'Lernplan Filte';
$string['learning_plan_viewer_role'] = 'Lernplan Zuschauer-Funktio';
$string['all_cohorts'] = 'Alle Kohorte';
$string['privacy_shield_policy'] = 'Datenverarbeitung Addendu';
$string['privacy_policy'] = 'Datenschutz-Bestimmunge';
$string['confirm_and_sign_up'] = 'Bestätigen und Registriere';
$string['term_of_use'] = 'Nutzungsbedingunge';
$string['setup'] = ' jetzt verbinden+B826B813:B813:B82';
$string['protocol'] = 'Protoko';
$string['rest'] = 'RES';
$string['soap'] = 'SOA';
$string['next'] = 'Nex';
$string['terms_msg'] = 'Durch Aktivieren dieses Kontrollkästchens bestätigen Sie, dass Sie unsere Nutzungsbedingungen gelesen haben und diesen zustimme';
$string['privacy_msg'] = 'Durch Aktivieren dieses Kontrollkästchens bestätigen Sie, dass Sie unsere Datenschutzrichtlinie gelesen haben und dieser zustimme';
$string['shield_msg'] = 'Wenn Sie dieses Kontrollkästchen aktivieren, bestätigen Sie, dass Sie unser Addendum zur Datenverarbeitung gelesen haben und damit einverstanden sin';
$string['enable_webservice'] = 'Wenn Sie dieses Kontrollkästchen betreffen, haben Sie, dass Sie unser Addendum zur Datenverarbeitung gelesen haben und damit verbunden sin';
$string['you_need_to_enable_at_least_one_protocol'] = 'Sie müssen mindestens ein Protokoll aktiviere';
$string['invalid_user'] = 'Nicht richtiger Benütze';
$string['sign_in'] = 'Anmeldun';
$string['email'] = 'Emai';
$string['password'] = 'Passwor';
$string['all_fields_required'] = 'Alle Felder benötig';
$string['server_error'] = 'Ups! Es ist etwas Unerwartetes passiert. Bitte kontaktieren Sie uns unter support@intelliboard.net';
$string['country'] = 'Lan';
$string['please_accept_terms_and_conditions'] = 'Bitte akzeptieren Sie die Allgemeinen Geschäftsbedingunge';
$string['congratulations_intb_register'] = 'Herzliche Glückwünsch';
$string['congratulations_intb_register_msg'] = 'Vielen Dank, dass Sie Ihre 15-tägige kostenlose Testversion mit IntelliBoard gestartet haben! Bitte überprüfen Sie Ihre E-Mails, um Ihr IntelliBoard-Konto zu bestätigen. Verwenden Sie zunächst den SSO-Link (Single Sign On), falls dieser über Site Administration> IntelliBoard aktiviert ist, oder melden Sie sich <a href="https://app.intelliboard.net/signin"> hier </a> an. Der SSO-Link lautet "INTELLIBOARD.NET" und befindet sich in der oberen rechten Ecke des Dashboard';
$string['sign_up'] = 'Anmelde';
$string['sign_in'] = 'Anmelde';
$string['intelliboard_settings'] = 'IntelliBoard Einstellunge';
$string['moodle_settings'] = 'Moodle Einstellunge';
$string['email_is_required'] = 'E-Mail ist erforderlic';
$string['invalid_email'] = 'Ungültige E-Mai';
$string['intelliboard_terms'] = 'IntelliBoard Verträg';
$string['authentication'] = 'Erstellung eines Accounts';
$string['intb_settings_descr'] = "Für IntelliBoard ist eine eindeutige Hauptabonnement-E-Mail erforderlich. Geben Sie unten die E-Mail ein, die Sie als Abonnement-E-Mail verwenden möchten. Die E-Mail muss vor der Verwendung durch eine E-Mail-Bestätigung doppelt überprüft werden. Bei Fragen wenden Sie sich bitte an Wenden Sie sich an <a href='mailto:Support@IntelliBoard.net'> Support@IntelliBoard.net </a>. Eine vollständige Liste der IntelliBoard-Einstellungen finden Sie unter Site Administration> Plugins> Local Plugins> IntelliBoard";
$string['hosting_provider'] = 'Hosting Anbiete';
$string['self_hosted'] = 'selbst gehosted';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = 'Benutzerstatus';
$string['report2_name'] = 'Kursstatistik';
$string['report3_name'] = 'Zusammenfassung der Aktivitätsstatistiken';
$string['report45_name'] = 'Quizaktivitätsdetail';
$string['report_activity_stats_summary'] = 'Zusammenfassung der Aktivitätsstatistiken';
$string['report_user_profile_information'] = 'Benutzerprofilinformationen';
$string['course_name'] = 'Kursname';
$string['course_short_name'] = 'KurskurzName';
$string['course_idnumber'] = 'ID Nummer';
$string['course_status'] = 'Status';
$string['number_of_learners'] = 'Anzahl der registrierten Benutzer';
$string['number_of_modules'] = '# of Activitäten';
$string['number_of_completed_learners'] = 'Anzahl der abgeschlossenen Benutzer';
$string['number_of_visits'] = 'Besuche';
$string['num_completed_activity'] = 'Anzahl der Benutzer, die diese Aktivität abgeschlossen haben';
$string['total_time_spent'] = 'Allgemeinverbrachtezahl';
$string['date_created'] = 'Erstellungsdatum';
$string['initial_reports'] = 'Erstberichte';
$string['avg_score'] = 'Durchschnittliche Punktzahl';
$string['first_access'] = 'Erster Zugriff';
$string['completion_not_enabled'] = ' ';
$string['first_name'] = 'Vorname';
$string['last_name'] = 'Nachname';
$string['num_attempts'] = 'Anzahl der Versuche';
$string['highest_grade'] = 'Highest Grade';
$string['lowest_grade'] = 'niedrigste Note';
$string['initial_reports_warning'] = 'Um diese Berichte per E-Mail zu versenden, zu planen und weiter zu personalisieren, klicken Sie auf "<a href="{$a}"> Connect & Upgrade </a>';
$string['last_access'] = 'Letzter Zugriff';
$string['enrolment_expiration'] = 'Ablauf der Registrierung';
$string['id_number'] = 'ID Number';
$string['telephone1'] = 'Telefon 1';
$string['telephone2'] = 'Telefon 2';
$string['institution'] = 'Institution';
$string['department'] = 'Abteilung';
$string['address'] = 'Address';
$string['city'] = 'Stadt';
$string['enroled_on'] = 'Registrierungsdatum';

$string['dashboard_link'] = 'Klicken, um Analytics anzuzeigen';
$string['support_connect'] = 'Klicken Sie auf die Berichtsschaltflächen im Rechteck unten. Erhalten Sie einen Einblick in die Leistungsfähigkeit von IntelliBoard: 1-Tasten-Zugriff auf Ihre LMS-Einblicke. Mehr wollen? Klicken Sie auf "Klicken, um Analytics anzuzeigen". Willst du noch mehr? <a href="{$a->connect_link} ">" Connect & Upgrade "</a> oben rechts oder an einer beliebigen Stelle, an der Sie den Link sehen';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Benötigen Sie weitere Informationen? Klicken Sie auf eine der blauen Schaltflächen, um eine Verbindung mit uns herzustellen';

$string['web_services_descr'] = 'Für IntelliBoard müssen Webdienste aktiviert sein. Mit Webdiensten können andere Systeme (z. B. IntelliBoard) auf dieses LMS-System zugreifen und Vorgänge ausführen. Aus Sicherheitsgründen sollte dies deaktiviert werden, wenn es nicht verwendet wird. Weitere Informationen finden Sie unter Site Administration> Erweiterte Funktionen> Webdienste';
$string['protocol_descr'] = 'Für IntelliBoard muss entweder das REST- oder das SOAP-Protokoll aktiviert sein. Aus Sicherheitsgründen sollten nur Protokolle aktiviert werden, die verwendet werden. Weitere Informationen finden Sie unter Site Administration> Plugins> Webdienste> Protokolle verwalten';
$string['authorized_user_descr'] = 'IntelliBoard benötigt einen autorisierten Benutzer. Der autorisierte Benutzer ist wahrscheinlich ein Site-Administrator und muss über Berechtigungen zum Verwalten von Webdiensten, Protokollen und Token verfügen. Weitere Informationen finden Sie unter Site Administration> Plugins> Webdienste> Externe Dienste> IntelliBoard-Dienst> Autorisierter Benutzer';
$string['email_subscr'] = 'Abonnement-E-Mail';
$string['protocols_descr'] = 'Für IntelliBoard muss entweder das REST- oder das SOAP-Protokoll aktiviert sein. Aus Sicherheitsgründen sollten nur Protokolle aktiviert werden, die verwendet werden. Weitere Informationen finden Sie unter Site Administration> Plugins> Webdienste> Protokolle verwalten';
$string['enable_time_tracking'] = 'Zeiterfassung aktivieren';
$string['enable_time_tracking_descr'] = 'Aktivieren Sie die Zeiterfassung, um zusätzliche Einblicke in Benutzerzugriff, Besuche und aufgewendete Zeit zu erhalten. IntelliBoard bietet zusätzliche Einblicke in die Zeiterfassung, getrennt von den Moodle-Zeittabellen';
$string['enable_sso'] = 'SSO-Link (Single Sign On) aktivieren';
$string['enable_sso_descr'] = 'Single Sign On Link für One-Click-Zugriff für Site-Administratoren auf den IntelliBoard SuperAdmin-Zugriff auf app.IntelliBoard.net aktivieren';
$string['join_a_webinar'] = 'An einem Webinar teilnehmen';
$string['review_support_doc'] = 'Support-Dokumentation überprüfen';
$string['setup_subheading'] = 'Stellen Sie eine Verbindung her, um die Leistung Ihrer Daten zu erfahren. Keine Kreditkarte. Keine Verpflichtung. Nur 15 freie Tage Datenglück';

$string['instructor_courses_table_name'] = 'Course Grades';
$string['instructor_courses_table_name_learner'] = 'Kurs {$a->course}, Lernender {$a->learner}, Noten';
$string['instructor_courses_table_name_activity'] = 'Kurs {$a->course}, Aktivität {$a->name}, Noten';
$string['instructor_courses_table_name_learners'] = 'Kurse{$a->fullname}, Learners';
$string['instructor_courses_table_name_activities'] = 'Kurse {$a->fullname}, Activities';

$string['successfull_connected'] = 'Erfolgreich verbunden';
$string['not_connected'] = 'Nicht verbunden';

$string['transcripts'] = 'Transkripte';
$string['enable_transcripts'] = 'Transkripte aktivieren';
$string['closed'] = 'Geschlossen';
$string['synctranscriptstask'] = 'Transkripte synchronisieren Aufgabe';
$string['transcriptssyncrecordsnum'] = 'Größe der Transkriptverarbeitung';
$string['transcriptssyncrecordsnum_desc'] = 'Die Anzahl der Benutzerregistrierungsdatensätze, die gleichzeitig verarbeitet werden';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transkripte Kursdatensätze';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'Benützer ID';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Benutzer-E-Mail';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Benützer Vornahme';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Benützer Nachnahme';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transkripte Benutzerregistrierungs-ID';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Datensatz-ID registrieren';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Registrierungsmethode';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Kurse ID';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Vollständiger Name des Kurses';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Registrierungsdatum';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Datum der Nichtregistrierung';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Abschlussdatum';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transcripten Status';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Note Item ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = ' Note der Note ID';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Max Note';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Min Note';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Abschlussnote';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Formatierte Note';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Benutzerrollen';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Benutzergruppen';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Zeitstempel beim Erstellen des Datensatzes';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Zeitstempel, als der Datensatz das letzte Mal aktualisiert wurde';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transkripte Kursaufzeichnungen';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transkripte Benutzerregistrierungs-ID';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Kurs ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'Benutzer ID';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Kurs Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Module ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Aktivitätsname';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Module Type';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Startdatum';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Abschlussdatum';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Status';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Note Item ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Note Grade ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Max Note';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Min Note ';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Abschlussnote';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Formattierte Note';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Zeitstempel beim Erstellen des Datensatzes';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Zeitstempel, als der Datensatz das letzte Mal aktualisiert wurde';
$string['goal_grade'] = 'Zielnote';
$string['importtrackingtask'] = 'Tracking-Aufgabe importieren';
$string['compresstracking'] = 'Tracking komprimieren';
$string['compresstracking_desc'] = 'Zeiterfassungsdaten in Datei schreiben und Daten mit Cron-Job in die Datenbank übertragen (Standard: alle 15 Minuten)';
$string['cachedef_instructor_course_data'] = 'Cache für Kursdaten';
$string['cachedef_reports_list'] = 'Cache für Berichtsliste';
$string['do_not_use_compresstracking'] = 'Verwenden Sie Compress Tracking nicht';
$string['cache_compresstracking'] = 'Im Moodle-Cache speichern';
$string['file_compresstracking'] = 'In MoodleData speichern';
$string['cachedef_tracking'] = 'Intelliboard Tracking-Daten';
$string['cachedef_track_config'] = 'Intelliboard Tracking total data';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = 'Japanisch/China-kompatible Schriftart';
$string['all_selected'] = 'Alle ausgewählt';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
