<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

$string['a0'] = 'Tableau de bord des Compétences';
$string['a1'] = 'Compétences';
$string['a10'] = 'Étudiants inscrits';
$string['a11'] = 'Liste des compétences assignées au cours';
$string['a12'] = 'Statut de l\'Étudiant';
$string['a13'] = 'Nom de la compétence';
$string['a14'] = 'Date de création';
$string['a15'] = 'Attribué à';
$string['a16'] = 'Technicien Indiqué';
$string['a17'] = 'Classement';
$string['a18'] = 'Compétences acquises';
$string['a19'] = 'Classement de la compétence par Date';
$string['a2'] = 'Compétence';
$string['a20'] = 'Évaluateur de compétence';
$string['a21'] = 'Activités assignées';
$string['a22'] = 'Compétence atteinte/acquise';
$string['a23'] = 'Compétences évaluées';
$string['a25'] = 'Étudiants ayant achevé';
$string['a24'] = 'Evidences';
$string['a26'] = 'Ce tableau affiche le nombre de compétences attribuées à un cours, les étudiants qui ont été évalués (qu\'ils soient compétents ou non) et les étudiants qui ont été désignés compétents dans la compétence.';
$string['a27'] = 'de';
$string['a28'] = 'Détails';
$string['a29'] = 'Activer le tableau de bord des compétences';
$string['a3'] = 'Activités assignées';
$string['a30'] = 'Activer les rapports de compétences';
$string['a31'] = 'Structures';
$string['a32'] = 'Plans d\'apprentissage';
$string['a33'] = 'Évalué,Compétent';
$string['a34'] = 'Évalué, Non Compétent';
$string['a35'] = 'Non Évalué';
$string['a36'] = 'Aperçu des compétences';
$string['a37'] = 'Une compétence n\'a pas été créée. Veuillez contacter votre administrateur du système';
$string['a38'] = 'Cours liés aux compétences';
$string['a39'] = 'Nombre total de compétences';
$string['a4'] = 'Progrès de la compétence';
$string['a40'] = 'Cours liés';
$string['a5'] = 'Compétences évaluées';
$string['a6'] = 'Evidences';
$string['a7'] = 'Étudiants évalués';
$string['a8'] = 'Progrès';
$string['a9'] = 'Étudiants compétents';
$string['account'] = 'Information d\'abonnement';
$string['actions'] = 'Aller à';
$string['activities'] = 'Activités';
$string['activities_resources'] = 'Activités / Ressources';
$string['activity_grades'] = 'Notes d\'activité';
$string['activity_name'] = 'Nom d\'activité';
$string['activity_participation'] = 'Participation à une activité';
$string['activity_progress'] = 'Progrès d\'activité';
$string['adv_settings'] = 'Paramètres avancé';
$string['ajax'] = 'Fréquence du suivi';
$string['ajax_desc'] = 'Fréquence de stockage des sessions via AJAX. 0 - AJAX désactivé (en secondes))';
$string['all_courses'] = 'Tous les cours';
$string['all_data'] = 'Toutes les données';
$string['assignment_name'] = 'Nom du devoir';
$string['assignments'] = 'Devoirs';
$string['average_grade'] = 'la note moyenne';
$string['categories'] = 'Catégories';
$string['category'] = 'Catégorie';
$string['class_average'] = 'Moyenne de la classe';
$string['click_link_below_support_pages'] = 'Cliquez sur le lien ci-dessous pour accéder aux pages de support IntelliBoard:';
$string['close'] = 'Fermer';
$string['cohorts'] = 'Les cohortes';
$string['completed'] = 'Achevé';
$string['completed_activities'] = 'Activités achevés';
$string['completed_activities_resources'] = 'Activités achevés';
$string['completed_activities_resourses'] = 'Activités achevés';
$string['completed_courses'] = 'Cours Achevés';
$string['completed_on'] = 'Achevé le {$a}';
$string['completion'] = 'Achèvement';
$string['completion_is_not_enabled'] = 'l\'achèvement n\'est pas activé pour ce cours';
$string['completions'] = 'Statut d\'achèvement d\'activité';
$string['completions_completed'] = 'État d\'achèvement (terminé)';
$string['completions_desc'] = '1\'utilisateur a terminé cette activité. Il n\'est pas spécifié s\'ils a réussi ou échoué. <br> <br>
2) utilisateur a terminé cette activité avec une note supérieure à la note de passage. <br> <br>
3) utilisateur a terminé cette activité mais sa note est inférieure à la note de passage.';
$string['completions_fail'] = 'Statut d\'achèvement (échoué)';
$string['completions_pass'] = 'Statut d\'achèvement (réussite)';
$string['completion_status'] = 'état d\'achèvement';
$string['correlations'] = 'Corrélations: temps passé Vs note moyenne';
$string['course_category'] = 'Catégorie du cours';
$string['course_completions'] = 'Achèvement des cours';
$string['course_completion_status'] = 'État d\'achèvement du cours';
$string['course_grade'] = 'Note de cours';
$string['course_name'] = 'Nom du cours';
$string['course_overview'] = 'Aperçu du cours';
$string['course_progress'] = 'Avancement du cours';
$string['courses'] = 'Cours';
$string['courses_avg_grade'] = 'Note moyenne des cours';
$string['courses_sum_grade'] = 'Valeur de la somme de cours par échelle';
$string['courses_in_progress'] = 'Cours en déroulement';
$string['course_start_date'] = 'Date de début du cours';
$string['course_started'] = 'Cours démarré';
$string['course_success'] = 'Réussite du cours';
$string['current_grade'] = 'Note actuel';
$string['daily'] = 'Dernier 90 jours';
$string['dashboard'] = 'Tableau de bord';
$string['disabled'] = 'désactivé';
$string['disable_time_and_visits_users_overview'] = 'Désactiver le temps passé et les visites dans la vue d\'ensemble des utilisateurs';
$string['done'] = 'Fait!';
$string['due_date'] = 'Date d\'échéance';
$string['enabled'] = 'Suivi activé';
$string['enabled_desc'] = 'Activer le suivi';
$string['enable_time_and_visits_users_overview'] = 'Activer le temps passé et les visites dans la vue d\'ensemble des utilisateurs';
$string['enrolled'] = 'Inscrit';
$string['enrolled_completed'] = 'Inscrit: {$a->courses}, Achevé: {$a->completed_courses';
$string['enrolled_completed_learners'] = 'Étudiants inscrits / ayant achevé';
$string['enrolled_date'] = 'Date d\'inscription';
$string['enrolled_users_completed'] = 'Utilisateurs inscrits: {$a->users}, Achevé: {$a->completed}';
$string['enrollments'] = 'Inscriptions';
$string['enrolment_method'] = 'Méthode d\'inscription';
$string['failed'] = 'Échoué';
$string['failed_on'] = 'Achevé (échoué) sur {$a}';
$string['filter1'] = 'Utilisateurs supprimés';
$string['filter1_desc'] = 'Afficher les utilisateurs supprimés';
$string['filter2'] = 'Utilisateurs suspendus';
$string['filter2_desc'] = 'Afficher les utilisateurs suspendus';
$string['filter3'] = 'Utilisateur invité';
$string['filter3_desc'] = 'Afficher les utilisateur [guest] dans les rapports';
$string['filter4'] = 'Filtre de cours';
$string['filter4_desc'] = 'Afficher les cours cachés';
$string['filter5'] = 'Filtre de méthode d\'inscription';
$string['filter5_desc'] = 'Afficher les méthodes d\'inscription inactives';
$string['filter6'] = 'Filtre inscription utilisateur';
$string['filter6_desc'] = 'Afficher les utilisateurs dont l\'inscription est inactive';
$string['filter7'] = 'Activités / Ressources filter';
$string['filter7_desc'] = 'Afficher les activités / ressources cachés';
$string['filter8'] = 'Filtre des utilisateurs inscrits';
$string['filter8_desc'] = 'Afficher uniquement les utilisateurs inscrits (non recommandé)';
$string['filter_dates'] = 'Filtrer les dates:';
$string['filters'] = 'Filtres du tableau de bord';
$string['grade'] = 'Note';
$string['graded'] = 'Noté';
$string['grades'] = 'Notes';
$string['help'] = 'Besoin d\'aide?';
$string['import'] = 'Importer';
$string['importing_logs'] = 'Importer les journaux';
$string['importing_totals'] = 'Importer des totaux';
$string['in1'] = 'Aperçu';
$string['in10'] = 'Utilisation d\'événements';
$string['in11'] = 'Progrès de l\'étudiant';
$string['in12'] = 'Progression de la note';
$string['in13'] = 'Temps passé (%)';
$string['in14'] = '% progression';
$string['in15'] = 'Achèvement des étudiants';
$string['in16'] = 'Dernier accès';
$string['in17'] = 'Temps total passé';
$string['in18'] = 'Nombre total des visites';
$string['in19'] = 'Note moyenne';
$string['in2'] = 'Avancement actuel';
$string['in20'] = 'Retour à la page Étudiants';
$string['in201'] = 'Retour à la page Activités';
$string['in21'] = 'Note moyenne du cours';
$string['in22'] = 'Activé';
$string['in23'] = 'Vous n\'avez aucun étudiant à afficher.';
$string['in24'] = 'Section';
$string['in25'] = 'Note de passage';
$string['in26'] = 'Engagement des étudiants';
$string['in27'] = 'Nombre total d\'étudiants';
$string['in28'] = 'Temps moyen passé';
$string['in29'] = 'Étudiants actifs';
$string['in3'] = 'Nombre de cours';
$string['in30'] = 'Étudiants inactifs';
$string['in31'] = 'Utilisation de l\'activité';
$string['in32'] = 'Temps moyen passé dans la période sélectionnée';
$string['in33'] = 'Utilisation du sujet';
$string['in4'] = 'Nombre d\'étudiants';
$string['in5'] = 'Les cours et les notes';
$string['in6'] = 'Étudiants ayant achevés';
$string['in7'] = 'Étudiants qui n\'ont pas achevé';
$string['in8'] = 'Note moyenne de l\étudiant';
$string['in9'] = 'Corrélations: temps passé Vs note moyenne';
$string['inactivity'] = 'Inactivité';
$string['inactivity_desc'] = 'Temps d\'inactivité de l\'utilisateur (en secondes)';
$string['incomplete'] = 'Pas achevé';
$string['intelliboardaccess'] = 'Vous n\'êtes pas autorisé à voir cette page. Veuillez contacter votre administrateur du site pour obtenir de l\'aide.';
$string['intelliboard:competency'] = 'IntelliBoard [compétence]';
$string['intelliboard:instructors'] = 'IntelliBoard [instructeur]';
$string['intelliboard_logs'] = 'Journaux IntelliBoard';
$string['intelliboard:manage'] = 'IntelliBoard [gérer]';
$string['intelliBoard_migration_tool'] = 'Outil de migration IntelliBoard';
$string['intelliBoard_migration_tool_info'] = 'l\'outil de migration IntelliBoard est utilisé pour migrer les données historiques de la table des journaux Moodle vers un nouveau format. Veuillez noter que la procédure de stockage des journaux Moodle ne changera pas. Une fois les données historiques migrées vers un nouveau format, des valeurs historiques telles que «Temps passé» et «Visites» seront disponibles pour un aperçu sur IntelliBoard.net.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intelliboard_start_tracking'] = 'commencer le suivi IntelliBoard';
$string['intelliboard:students'] = 'IntelliBoard [étudiant]';
$string['intelliboard_totals'] = 'Totaux IntelliBoard';
$string['intelliboard_tracking'] = 'Suivi IntelliBoard';
$string['intelliboard:view'] = 'IntelliBoard [vue]';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Parcourir toutes les cohortes]';
$string['items_per_query'] = 'Éléments par requête';
$string['last_access_on_course'] = 'Dernier accès au cours: {$a}';
$string['last_month'] = 'Le mois dernier';
$string['last_quarter'] = 'Dernier trimestre';
$string['last_semester'] = 'Dernier semestre';
$string['last_week'] = 'La semaine dernière';
$string['learner_name'] = 'Nom de l\'étudiant';
$string['learners'] = 'étudiants';
$string['learners_enrolled'] = 'Étudiants inscrits';
$string['learners_enrolled_period'] = 'Étudiants inscrits pendant la période sélectionnée';
$string['learning'] = 'Apprentissage';
$string['learning_progress'] = 'Progrès d\'apprentissage';
$string['letter'] = 'Note de lettre';
$string['load'] = 'Performance';
$string['loading'] = 'Chargement...';
$string['logs'] = 'Outil de migration';
$string['logs_to_process'] = 'Journaux à traiter {$a}';
$string['log_values_include'] = 'Les valeurs de journal incluent des journaux pour chaque utilisateur par jour.';
$string['messages'] = 'Messages';
$string['modules'] = 'Sections';
$string['monitors'] = 'Moniteurs';
$string['monthly'] = 'Dernier 365 jours';
$string['moodle'] = 'Moodle';
$string['moodle_logs'] = 'Journaux Moodle';
$string['more_courses'] = 'Plus de cours';
$string['more_users'] = 'Plus d\'utilisateurs';
$string['my_course_average_all'] = 'Note moyenne de tous mes cours';
$string['n1'] = 'Aperçu [Progrès des étudiants]';
$string['n10'] = 'Tableau de bord de l\'instructeur';
$string['n11'] = 'Texte alternatif pour le menu de navigation';
$string['n12'] = 'Aperçu [Aperçu du cours]';
$string['n13'] = 'Nombre total d\'étudiants';
$string['n14'] = 'Widget: Engagement des étudiants';
$string['n15'] = 'Widget: Utilisation des activités';
$string['n16'] = 'Widget: Utilisation du sujet';
$string['n2'] = 'Aperçu [Progression de la note]';
$string['n3'] = 'Aperçu [Progression activité]';
$string['n4'] = 'Aperçu [Totaux]';
$string['n5'] = 'Progrès actuel';
$string['n6'] = 'Widget: Corrélations temps passé Vs note moyenne';
$string['n7'] = 'Widget: Utilisation événement';
$string['n8'] = 'Page des cours';
$string['n9'] = 'Page des rapports';
$string['no_competency'] = 'Il semble que vous n\'ayez pas de compétences activées sur votre site Moodle.';
$string['no_data'] = 'Pas de données';
$string['number_of_sessions'] = 'Nombre de sessions';
$string['number_this_week'] = '{$a} cette semaine';
$string['number_today'] = '{$a} aujourd\'hui';
$string['ok'] = 'Ok';
$string['overall_course_average'] = 'Moyenne générale des cours (tous les étudiants, tous les cours)';
$string['participation'] = 'Participation';
$string['passed'] = 'Passé';
$string['passed_on'] = 'Achevé (réussite) sur {$a}';
$string['please_wait_or_cancel'] = 'Veuillez patienter pour continuer ou <a href="{$a}"> Annuler </a>';
$string['pluginname'] = 'IntelliBoard.net Plugin';
$string['powered_by'] = 'Fait par <a href="https://intelliboard.net/"> IntelliBoard.net </a>';
$string['progress'] = 'Progrès';
$string['quiz_name'] = 'Nom du quiz';
$string['quizzes'] = 'Quiz';
$string['registered'] = 'Inscrit';
$string['registrations'] = 'Inscriptions';
$string['report'] = 'rapport';
$string['reports'] = 'rapports';
$string['return_to_courses'] = 'Retour à la page cours';
$string['return_to_grades'] = 'Retour à la page notes';
$string['return_to_home'] = 'Retour à la page d\'accueil';
$string['role1'] = 'Premier rôle';
$string['role2'] = 'Deuxième rôle';
$string['s25'] = 'Temps passé dans l\'activité';
$string['s45'] = 'Activité';
$string['s46'] = 'Pourcentage de tentatives des étudiants';
$string['s47'] = 'Sujet';
$string['s48'] = 'Temps passé sur le sujet';
$string['save'] = 'sauvegarder';
$string['scale_percentage'] = 'Pourcentage';
$string['scale_raw'] = 'Désactiver l\'échelle';
$string['scale_real'] = 'Afficher la note réelle au lieu du pourcentage';
$string['scales'] = 'Activer échelle personnalisée';
$string['scalesettings'] = 'Paramètres échelle';
$string['scale_total'] = 'note totale';
$string['scale_value'] = 'Valeur';
$string['score'] = 'Score';
$string['section'] = 'Section';
$string['sections'] = 'Sections';
$string['select'] = 'Sélectionner';
$string['selectall'] = 'Tout sélectionner';
$string['select_date'] = 'Sélectionner une date';
$string['server'] = 'Serveur IntelliBoard';
$string['server_au'] = 'IntelliBoard Australie';
$string['server_eu'] = 'IntelliBoard Europe';
$string['server_usa'] = 'IntelliBoard USA';
$string['settings'] = 'Paramètres';
$string['showing_1_to_10'] = 'Afficher 1 à 10';
$string['sso'] = 'lien SSO';
$string['sso_desc'] = 'lien SSO vers IntelliBoard.net';
$string['ssomenu'] = 'Élément de menu SSO';
$string['ssomenu_desc'] = 'Lien SSO dans le menu de navigation (réservé aux administrateurs)';
$string['status'] = 'Statut';
$string['support'] = 'Assistance Clientèle';
$string['learner_tf_last_week'] = 'Filtre temporel: la semaine dernière';
$string['t01'] = 'Filtre temporel: 30 derniers jours';
$string['t02'] = 'Filtre temporel: 3 derniers mois';
$string['t03'] = 'Filtre temporel: 6 derniers mois';
$string['t04'] = 'Activer [en-tête] Cours achevés';
$string['t05'] = 'Activer [en-tête] Cours en déroulement';
$string['t06'] = 'Activer [en-tête] Notes moyenne des cours';
$string['t07'] = 'Activer [en-tête] Messages';
$string['t08'] = 'Activer [en-tête] Notes des cours';
$string['t09'] = 'l\'instructeur peut voir ses propres étudiants';
$string['t1'] = 'Activer le tableau de bord Étudiants';
$string['t10'] = 'Activer le widget [Quiz]';
$string['t11'] = 'Activer le widget [Progression du cours]';
$string['t12'] = 'Activer le widget [Participation à une activité]';
$string['t13'] = 'Activer le widget [Progrès d\'apprentissage]';
$string['t14'] = 'Activer le widget [Réussite du cours]';
$string['t15'] = 'Activer le widget [Corrélations: temps passé Vs note moyenne]';
$string['t16'] = 'Activer le enseignant du cours';
$string['t17'] = 'Activer la catégorie de cours';
$string['t18'] = 'Activer achèvement du cours';
$string['t19'] = 'Activer la note';
$string['t2'] = 'Activer le tableau de bord';
$string['t20'] = 'Activer la note moyenne du cours';
$string['t21'] = 'Activer le temps passé dans les cours';
$string['t22'] = 'Activer la date de début du cours';
$string['t23'] = 'Activer la colonne [Date de début du cours]';
$string['t24'] = 'Activer la colonne [Date inscription]';
$string['t25'] = 'Activer la colonne [Avancement]';
$string['t26'] = 'Activer la colonne [Note de lettre]';
$string['t27'] = 'Activer la colonne [Activités terminées]';
$string['t28'] = 'Activer la colonne [Score]';
$string['t29'] = 'Activer la colonne [État d\'achèvement du cours]';
$string['t3'] = 'Activer les cours';
$string['t30'] = 'Activer la colonne [Notes d\'activité]';
$string['t31'] = 'Activer la colonne du widget [Devoir] [Note]';
$string['t32'] = 'Activer la colonne du widget [Devoir] [Date d\'échéance]';
$string['t33'] = 'Activer la colonne du widget [Quiz] [Note]';
$string['t34'] = 'Activer la colonne du widget [Quiz] [Date d\'échéance]';
$string['t35'] = 'Activer la colonne du widget [Progression du cours] [Progression]';
$string['t36'] = 'Activer la colonne du widget [Progression du cours] [Note]';
$string['t37'] = 'Activer la colonne du widget [Progression du cours] [Inscrit]';
$string['t38'] = 'Activer la colonne du widget [Progression du cours] [Terminé]';
$string['t52'] = 'Activer la rangée du widget [Progression du cours] [Catégorie]';
$string['t39'] = 'Activer option [Progression] [Note Objectif]';
$string['t4'] = 'Activer les notes';
$string['t40'] = 'Activer option [Progression] [Classe moyenne]';
$string['t41'] = 'Activer [En-tête des notes activité] Terminé le';
$string['t42'] = 'Activer [En-tête des catégories activités] Dernier accès au cours';
$string['t43'] = 'Activer la colonne Type activité [Notes d\'activité]';
$string['t44'] = 'Activer la colonne Score [Catégories d\'activité]';
$string['t45'] = 'Activer la colonne Noté [Notes d\'activité]';
$string['t46'] = 'Activer la colonne complétée [Catégories d\'activité]';
$string['t47'] = 'Cours [grille] couleur de fond';
$string['t48'] = 'Activer les rapports';
$string['t49'] = 'Signaler les colonnes de filtre';
$string['t5'] = 'Activer le graphique [Progression d\'activité]';
$string['t50'] = 'Rôles enseignant';
$string['t51'] = 'Rôles étudiant';
$string['t6'] = 'Activer le graphique [Progression du cours]';
$string['t7'] = 'Activer [Moyenne de mes cours]';
$string['t8'] = 'Activer [Moyenne globale du cours]';
$string['t9'] = 'Activer le widget [Devoirs]';
$string['te1'] = 'Adresse Email';
$string['te12'] = 'Prénom';
$string['te13'] = 'Nom de famille';
$string['te1_desc'] = 'Entrez le e-mail utilisé avec votre abonnement IntelliBoard. Si vous n\'êtes pas nos clients, veuillez nous contacter sur IntelliBoard.net';
$string['teacher'] = 'Enseignant';
$string['tex1'] = 'le Tableau de bord étudiant IntelliBoard n\'est pas activé.';
$string['time'] = 'Temps';
$string['time_period_due'] = 'Période (date d\'échéance)';
$string['time_spent'] = 'Temps passé';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Paramètres avancés: TLS v1.2';
$string['topics'] = 'Sujets';
$string['total'] = 'Total';
$string['total_activities_resources'] = 'Nombre total d\'activités / ressources';
$string['total_numbers'] = 'Date: {$a->timepoint}, Sessions: {$a->sessions}, Visites: {$a->visits}, Temps passé: {$a->timespend}';
$string['total_numbers2'] = 'UTILISATEUR: {$a->userid}, Page: {$a->page}, Param: {$a->param}, Visites: {$a->visits}, Temps passé: {$a->timespend}';
$string['total_time_spent_enrolled_learners'] = 'Temps total passé par les étudiants inscrits dans le cours';
$string['total_values_include'] = 'Les valeurs totales incluent des sessions uniques, des cours, des visites et le temps passé.';
$string['total_visits_enrolled_learners'] = 'Nombre total de visites par les étudiants inscrits dans le cours';
$string['totara'] = 'Totara';
$string['trackadmin'] = 'Suivi des administrateurs';
$string['trackadmin_desc'] = 'Activer le suivi pour les utilisateurs admin (non recommandé)';
$string['tracking'] = 'Suivi de session';
$string['tracking_title'] = 'Suivi du temps';
$string['ts1'] = 'Tableau de bord étudiant';
$string['ts2'] = 'Onglet tableau de bord';
$string['ts3'] = 'Onglet cours';
$string['ts4'] = 'Onglet notes';
$string['ts5'] = 'Rapports du tableau de bord des étudiants';
$string['type'] = 'Type d\'activité';
$string['type_here'] = 'écrivez ici...';
$string['user_enrolments'] = 'Inscriptions des utilisateurs';
$string['user_grade_avg'] = '{$a->user} note: {$a->grade}, note moyenne: {$a->avg_grade_site})';
$string['users'] = 'Utilisateurs';
$string['users_activity'] = 'Activité des utilisateurs';
$string['users_overview'] = 'Aperçu des utilisateurs';
$string['user_visit_avg'] = 'Visites {$a->user}: {$a->visits}, Visites moyennes: {$a->avg_visits_site}';
$string['user_time_avg'] = '{$a->user} time: {$a->timespend}, Temps moyen: {$a->avg_timespend_site}';
$string['view_course_details'] = 'Aller aux détails du cours';
$string['visits'] = 'Visites';
$string['weekly'] = 'Derniers 10 jours';
$string['widget_name27'] = 'Les inscriptions cumulées';
$string['widget_name28'] = 'Engagement';
$string['widget_name29'] = 'Authentifications unique';
$string['widget_name30'] = 'Inscriptions par cours';
$string['x_completions'] = '{$a} Achèvements';
$string['you_have_certificates'] = 'Vous avez des certificats {$a}';
$string['widget_name31'] = 'Registraires et superviseur';
$string['total_numbers3'] = '---- Date: {$a->timecreated}, Track ID: {$a->trackid}, Visites: {$a->visits}, Temps passé: {$a->timespend}';
$string['reportselect'] = 'Veuillez sélectionner au moins un rapport sur App.IntelliBoard.net. Cliquez sur un rapport, puis sur Paramètres du rapport et sélectionnez-le dans "Visible dans Moodle".';
$string['monitorselect'] = 'Veuillez sélectionner au moins un moniteur sur App.IntelliBoard.net. Cliquez sur un moniteur, puis sur paramètres du moniteur et sélectionnez-le dans "Visible dans Moodle"..';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Rel type de record';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Type d\'instance Moodle';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'ID d\'instance Moodle connecté';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Records Horodatage';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'Table ID [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Le nombre de visites et clics par jour';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Le temps passé par heure';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'L\'heure';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'The ID of the table [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Le nombre de visites, clics de souris, par jour';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Temps passé, par jour';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Horodatage du jour de l\'année';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Nombre total de sessions utilisateur dans Moodle';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Nombre total de cours à Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Nombre total de visites de tous les utilisateurs dans Moodle';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Temps total passé par les utilisateurs dans Moodle';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Horodatage du jour de l\'année';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'ID utilisateur qui visite la page Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Identifiant du cours visité par l\'utilisateur';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Type de page [cours, section, profil, site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Type d\'identifiant de page';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Visites d\'utilisateurs sur une page';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Temps passé par les utilisateurs sur une page';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Premier accès des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Dernier accès des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Type de navigateur d\'utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Système d\'exploitation des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Langue du navigateur des utilisateurs';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Utilisateurs Dernière adresse IP';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'ID de notification';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Type de notification';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Notification ID externe';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Notification ID d\'application externe';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Email de notification';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Notification cc';

$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Liste des participants de la session de Collaborate';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID de participation à la session';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Session UUID';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'User UUID (BlackBoard Collaborate service)';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'User ID (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Rôle de session';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Nom d\'utilisateur';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Première participation à la session';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Dernier à quitter la session';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Temps passé dans la session';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Nombre de rejoints à la session';

$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Liste des sessions suivies';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID du log de suivi';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Session UUID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'suivre le temps';

$string['privacy:metadata:local_intelliboard_att_sync'] = 'Liste des sessions synchronisées';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID du log de synchronisation';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Type de session';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'ID de session Moodle';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Données de synchronisation supplémentaires';

$string['support_text1'] = "Toutes vos données Moodle: faciles, partageables, compréhensibles et attrayantes. IntelliBoard est un plugin Moodle qui met <strong>120+</strong> rapports et des moniteurs entre vos mains.";
$string['support_text2'] = "Toutes vos données Moodle: faciles, partageables, compréhensibles et attrayantes. IntelliBoard est votre solution de création de rapports et d\'analyses Moodle. IntelliBoard vous offre plus de 120 rapports et analyses pour vous aider à prendre des décisions éclairées.";
$string['support_info1'] = "Vous pouvez rejoindre nos <a target='_blank' href='https://intelliboard.net/events'>Webinars</a> pendant que nous visitons les rapports et les analyses IntelliBoard 5.0!";
$string['support_info2'] = "Rejoignez nos <a target='_blank' href='https://intelliboard.net/events'>Webinars</a>, ou planifier une visite personnelle de vos propres données. Grâce à notre support et à nos services de classe mondiale, vous verrez votre système de gestion de l\'apprentissage sous un jour entièrement nouveau.";
$string['support_terms'] = "Tous droits réservés.";
$string['support_page'] = "Page de support";
$string['support_demo'] = "planifiez une réunion";
$string['support_trial'] = "Commencer un essai";
$string['support_close'] = "Fermer";
$string['instructor_custom_groups'] = "Groupes personnalisés d\'instructeur";
$string['instructor_show_suspended_enrollments'] = 'Afficher les inscriptions suspendues';
$string['instructor_hide_suspended_enrollments'] = 'Masquer les inscriptions suspendues';
// settings of tables
$string['show_dashboard_tab'] = 'Afficher l\'onglet du tableau de bord';
$string['table_set_icg'] = 'Afficher l\'onglet "Notes de cours"';
$string['table_set_icg_c1'] = 'Nom du cours';
$string['table_set_icg_c2'] = 'Nom court';
$string['table_set_icg_c3'] = 'Catégorie';
$string['table_set_icg_c4'] = 'Étudiants inscrits / ayant achevé';
$string['table_set_icg_c5'] = 'Note moyenne de cours';
$string['table_set_icg_c6'] = 'Sections';
$string['table_set_icg_c7'] = 'Activités / Ressources';
$string['table_set_icg_c8'] = 'Visites';
$string['table_set_icg_c9'] = 'Temps passé';
$string['table_set_icg_c11'] = 'Aller à - Activités';
$string['table_set_icg_c12'] = 'Aller à - étudiants';
$string['percentage_completed_learners'] = 'Pourcentage d\'étudiants ayant achevé';
$string['avg_visits_per_stud'] = 'Visites moyennes par étudiant';
$string['avg_time_spent_per_stud'] = 'Temps moyen passé par étudiant';
$string['table_set_ilg'] = 'Afficher le bouton "Notes des étudiants"';
$string['table_set_ilg_c1'] = 'Nom de l\'étudiant';
$string['table_set_ilg_c2'] = 'adresse email';
$string['table_set_ilg_c3'] = 'Inscrit';
$string['table_set_ilg_c4'] = 'Dernier accès';
$string['table_set_ilg_c5'] = 'Statut';
$string['table_set_ilg_c6'] = 'Note';
$string['table_set_ilg_c7'] = 'Activités / ressources complétées';
$string['table_set_ilg_c8'] = 'Visites';
$string['table_set_ilg_c9'] = 'Temps passé';
$string['table_set_ilg_c10'] = 'Aller à';
$string['table_set_ilg1'] = 'Afficher le bouton "Notes des étudiants"';
$string['table_set_ilg1_c1'] = 'Nom de l\'activité';
$string['table_set_ilg1_c2'] = 'Type';
$string['table_set_ilg1_c3'] = 'note';
$string['table_set_ilg1_c4'] = 'noté';
$string['table_set_ilg1_c5'] = 'Statut';
$string['table_set_ilg1_c6'] = 'Visites';
$string['table_set_ilg1_c7'] = 'Temps passé';
$string['table_set_iag'] = 'Afficher le bouton "Notes d\'activités"';
$string['table_set_iag_c1'] = 'Nom de l\'activité';
$string['table_set_iag_c2'] = 'Type';
$string['table_set_iag_c3'] = 'Étudiants qui ont achevé';
$string['table_set_iag_c4'] = 'La note moyenne';
$string['table_set_iag_c5'] = 'Visites';
$string['table_set_iag_c6'] = 'Temps passé';
$string['table_set_iag_c7'] = 'Actes';
$string['table_set_iag1'] = 'Tableau de l\'instructeur "Notes d\'activité"';
$string['table_set_iag1_c1'] = 'Nom de l\'étudiants';
$string['table_set_iag1_c2'] = 'adresse e-mail';
$string['table_set_iag1_c3'] = 'Statut';
$string['table_set_iag1_c4'] = 'Note';
$string['table_set_iag1_c5'] = 'Noté';
$string['table_set_iag1_c6'] = 'Visites';
$string['table_set_iag1_c7'] = 'Temps passé';
$string['learner_tf_last_week'] = 'filtre temporel: la semaine dernière';
$string['ianalytics'] = 'Analytique IntelliBoard';
$string['in34'] = 'Progression des notes de l\'étudiant';
$string['select_user'] = 'Sélectionner un utilisateur';
$string['allmod'] = 'Toutes les activités';
$string['this_year'] = 'Cette année';
$string['last_year'] = 'Année dernière';
$string['inprogress'] = 'En déroulement';
$string['notstarted'] = 'pas encore commencé';
$string['timespent'] = "temps passé";
$string['viewed'] = "Vu";
$string['grade_activities_overview'] = 'Aperçu des activités notées';
$string['activity'] = 'activité';
$string['date_format'] = 'Format de date';
$string['user_enrollments_sessions_completion'] = 'Inscription des utilisateurs, sections et notes des activités achevés';
$string['user_site_summary_detail'] = 'Résumé de l\'utilisation du site détaillé';
$string['course_enrollment_types'] = 'Types d\'inscription au cours';
$string['user_map'] = 'Carte d\'utilisateurs';
$string['course_enrollments_with_completion_overview'] = 'Aperçu des inscriptions aux cours avec achèvement';

//NEW STRINGS

$string['intelliboard:attendanceadmin'] = "Attendance Admin";
$string['api'] = "API alternative";
$string['api_desc'] = "Utilisez un serveur API alternatif (pour éviter le blocage du pare-feu)";
$string['n18'] = "Widget : Progression des notes des étudiants";
$string['n101'] = "Activer le tableau de bord de l\'Enseignant";
$string['t53'] = "Activer la ligne note moyenne sur le graphique [Progression de l\'activité]";
$string['loading2'] = "Veuillez patienter, chargement...";
$string['select_course'] = "Sélectionnez un cours";
$string['select_quiz'] = "Sélectionnez le quiz";
$string['not_quiz'] = "Zut, il semble que vous n\'ayez créé aucun quiz pour le cours sélectionné.";
$string['enter_course_and_quiz'] = "Veuillez sélectionner votre cours et quiz.";
$string['enter_quiz'] = "Veuillez sélectionner votre quiz.";
$string['analityc_3_name'] = "Aperçu du quiz et détails des questions";
$string['course_name_a'] = 'Cours: {$a}';
$string['quiz_name_a'] = 'Quiz: {$a}';
$string['cor_incor_answers'] = "Réponses correctes/incorrectes";
$string['quiz_finished'] = "Quiz terminé";
$string['quiz_grades'] = "Notes du quiz";
$string['correct_number'] = 'Correcte {$a}';
$string['incorrect_number'] = 'Incorrecte {$a}';
$string['correct'] = "Correcte";
$string['incorrect'] = "Incorrecte";
$string['weekday_0'] = "lundi";
$string['weekday_1'] = "mardi";
$string['weekday_2'] = "mercredi";
$string['weekday_3'] = "jeudi";
$string['weekday_4'] = "vendredi";
$string['weekday_5'] = "samedi";
$string['weekday_6'] = "dimanche";
$string['time_1'] = "matin";
$string['time_2'] = "après-midi";
$string['time_3'] = "soir";
$string['time_4'] = "nuit";
$string['passing_score_for'] = 'Note de passage pour {$a}';
$string['name'] = "Nom";
$string['answers'] = "réponses";
$string['ques_breakdown'] = "Répartition des questions";
$string['n17'] = "Page d\'analyse";
$string['analytics'] = "Analytique";
$string['pdf'] = "PDF";
$string['csv'] = "CSV";
$string['excel'] = "Excel";
$string['grades_alt_text'] = "Texte alternatif pour le menu de navigation";
$string['course_chart'] = "Activer le graphique du cours";
$string['course_activities'] = "Activer les activités du cours";
$string['filter_this_year'] = "Filtre temporel : cette année";
$string['filter_last_year'] = "Filtre temporel : l\'année dernière";
$string['course_max_grade'] = "Note maximale du cours";
$string['no_data_notification'] = "Il n\'y a pas de nouvelles données pour [date]";
$string['last_hour'] = "heure";
$string['last_day'] = "jour";
$string['privacy:metadata:local_intelliboard_assign'] = "Tableau des attributions de sous-comptes Intelliboard";
$string['privacy:metadata:local_intelliboard_details'] = "Intelliboard alternative/journaux/table horaire";
$string['privacy:metadata:local_intelliboard_logs'] = "Intelliboard Alternative/journaux/tableau par jour";
$string['privacy:metadata:local_intelliboard_totals'] = "Intelliboard Alternative/journaux/tableau total";
$string['privacy:metadata:local_intelliboard_tracking'] = "Intelliboard alternative/journaux/tableau de tous les temps";
$string['privacy:metadata:local_intelliboard_reports'] = "Tableau des rapports sql personnalisés d\'Intelliboard";
$string['privacy:metadata:local_intelliboard_ntf'] = "Tableau principal des notifications Intelliboard";
$string['privacy:metadata:local_intelliboard_ntf_hst'] = "Tableau d\'historique des notifications Intelliboard";
$string['privacy:metadata:local_intelliboard_ntf_pms'] = "Intelliboard notifications dynamic params table";
$string['privacy:metadata:local_intelliboard_assign:userid'] = "ID UTILISATEUR de l\'enregistrement";
$string['privacy:metadata:local_intelliboard_reports:status'] = "Statut du rapport - activé/non activé";
$string['privacy:metadata:local_intelliboard_reports:name'] = "Nom du rapport personnalisé";
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = "Code SQL encodé en BASE64";
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = "Date de création";
$string['privacy:metadata:local_intelliboard_ntf:subject'] = "Sujet de la Notification";
$string['privacy:metadata:local_intelliboard_ntf:message'] = "Message de notification";
$string['privacy:metadata:local_intelliboard_ntf:state'] = "État des notifications";
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = "Pièce jointe à la notification";
$string['privacy:metadata:local_intelliboard_ntf:tags'] = "Étiquettes de notifications";
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = "ID de l\'historique des notifications";
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = "ID de notification";
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = "ID de Notification d\'application externe";
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = "Nom de la notification";
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = "E-mail du Historique des notifications";
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = "Horodatage du Historique des notifications";
$string['select_manager_role'] = "Sélectionnez le rôle de gestionnaire";
$string['group_aggregation'] = "Filtre de groupe";
$string['ssodomain'] = "SSO de sous-domaine";
$string['ssodomain_desc'] = "Authentification unique avec serveur/compte séparés";
$string['instructor_redirect'] = "Redirection de l\'enseignant vers le tableau de bord de l\'instructeur";
$string['student_redirect'] = "Redirection des étudiants vers le tableau de bord de l\'étudiant";
$string['myorders'] = "Commandes";
$string['myseats'] = "Places";
$string['mywaitlist'] = "Liste d\'attente";
$string['mysubscriptions'] = "Abonnements";
$string['seatscode'] = "code des places";
$string['numberofseats'] = "Nombre des places";
$string['downloadinvoice'] = "Télécharger l\'ordre d\'achat";
$string['product'] = "Produit";
$string['key'] = "clé";
$string['created'] = "créé à";
$string['seatnumber'] = "Nombre de places";
$string['seatsused'] = "Places utilisés";
$string['details'] = "Détails";
$string['username'] = "Nom d\'utilisateur";
$string['used'] = "Utilisé";
$string['subscriptiondate'] = "Date d\'abonnement";
$string['price'] = "Prix";
$string['recurringperiod'] = "Période récurrente";
$string['billingcycles'] = "Cycles de facturation";
$string['active'] = "Actif";
$string['suspended'] = "Suspendu";
$string['canceled'] = "Annulé";
$string['expired'] = "Expiré";
$string['process'] = "Traiter";
$string['cancel_subscription'] = "Annuler l\'abonnement";
$string['sqlreport'] = "Rapport SQL";
$string['sqlreportcreate'] = "Creer un rapport";
$string['sqlreports'] = "Rapports SQL";
$string['sqlreportname'] = "Nom du rapport";
$string['sqlreportcode'] = "SQL";
$string['sqlreportdate'] = "Créé sur";
$string['sqlreportactive'] = "Activé";
$string['sqlreportinactive'] = "Désactivé";
$string['remove_message'] = "Le rapport SQL a été supprimé";
$string['delete_message'] = "Supprimer le rapport SQL ?";
$string['success_message'] = "Le rapport SQL a été enregistré";
$string['scale_percentage_round'] = "Ronde en pourcentage";
$string['bbbapiendpoint'] = "BBB API endpoint";
$string['bbbserversecret'] = "BBB secret du serveur";
$string['check_active_meetings'] = "Vérifier les réunions actives";
$string['bbbmeetings'] = "Réunions BigBlueButton";
$string['enablebbbmeetings'] = "Activer le suivi des réunions BigBlueButton";
$string['enablebbbdebug'] = "BigBlueButton mode debug";
$string['privacy:metadata:local_intelliboard_bbb_meet'] = "Journal des réunions BigBlueButton";
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = "ID du journal de réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = "Nom de la réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = "ID de la réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = "ID de réunion interne (sur le serveur BBB)";
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = "Heure de création (horodatage)";
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = "Date de création (chaîne)";
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = "Le numéro de poste pour le pont vocal (à utiliser si connecté au système téléphonique)";
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = "Le numéro d\'accès à composer que les participants peuvent appeler à l\'aide d\'un téléphone ordinaire.";
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = "Le mot de passe qui sera demandé aux participants pour rejoindre la réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = "Le mot de passe qui sera demandé aux modérateurs pour rejoindre la réunion ou pour certaines actions administratives";
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = "Statut de la réunion (actif|arrêté)";
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = "Durée de la réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = "! Les utilisateurs ont rejoint la réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = "! La réunion sera enregistrée";
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = "! La réunion a été interrompue de force";
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = "Heure de début de la réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = "Heure de fin de réunion";
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = "Nombre de participants";
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = "Nombre d\'auditeurs";
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = "Nombre de participants avec microphone connecté";
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = "Nombre de participants avec caméra vidéo connectée";
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = "Nombre maximum de participants";
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = "Nombre de modérateurs";
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = "ID du cours";
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = "ID de sujet du cours";
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = "ID de ligne dans la table BBB";
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = "ID du propriétaire (utilisateur qui a créé la réunion)";
$string['privacy:metadata:local_intelliboard_bbb_atten'] = "Journal des participants aux réunions BBB";
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = "ID de participant";
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = "ID utilisateur (ligne dans la table user )";
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = "Nom complet du participant à la réunion";
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = "Rôle du participant à la réunion";
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = "! Le participant est le présentateur";
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = "! Le participant n\'a pas de microphone ou de webcam connecté";
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = "! Le participant a connecté un microphone";
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = "! Le participant a connecté sa webcam";
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = "ID de réunion (ID dans le serveur BigBlueButton)";
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = "ID de réunion (ID dans le tableau local_intelliboard_bbb_meet)";
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = "Heure à laquelle l\'utilisateur s\'est connecté à la réunion";
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = "Heure à laquelle l\'utilisateur à quitté la réunion";
$string['messageprovider:intelliboard_notification'] = "Notification Intelliboard";
$string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
$string['verifypeer_desc'] = "This option determines whether curl verifies the authenticity of the peer's certificate.";
$string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
$string['verifyhost_desc'] = "This option determines whether libcurl verifies that the server cert is for the server it is known as.";
$string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
$string['cipherlist_desc'] = "Specify ciphers to use for TLS";
$string['sslversion'] = "CURLOPT SSLVERSION";
$string['sslversion_desc'] = "Pass a long as parameter to control which version range of SSL/TLS versions to use";
$string['debug'] = "Debug CURL requests";
$string['debug_desc'] = "";
$string['intellicart'] = "Integration IntelliCart";
$string['intellicart_desc'] = "Allow students to see IntelliCart reports.";
$string['intellicart_student_integration'] = 'Intégration avec le tableau de bord étudiant';
$string['intellicart_instructor_integration'] = 'Intégration avec le tableau de bord de l\'instructeur';
$string['intellicart_app_reports_integration'] = 'Intégration avec les rapports IntelliBoard';
$string['coursessessionspage'] = "Page des Séances de cours";
$string['coursessessions'] = "Séances de cours";
$string['session_name'] = "Nom de la séance";
$string['session_time'] = "Date de la séance";
$string['return_to_sessions'] = "Retour aux séances";
$string['customod'] = "Activités personnalisées";
$string['modulename'] = "Nom de la section";
$string['course'] = "Cours";
$string['courseaverage'] = "moyenne du cours";
$string['mygrade'] = "Ma note";
$string['myprogress'] = "Progression de ma note";
$string['instructor_course_shortname'] = "Afficher le nom abrégé du cours à la place du nom complet du cours";
$string['trackmedia'] = "Suivre les médias HTML5";
$string['trackmedia_desc'] = "Suivre la vidéo et l\'audio HTML5";
$string['instructor_course_visibility'] = "Afficher les cours masqués/suspendus pour [instructeur]";
$string['instructor_mode'] = "Afficher tous les cours disponibles pour [instructeur]";
$string['instructor_mode_access'] = "Afficher tous les cours disponibles pour [instructeur] avec les autorisations [mise à jour]";
$string['student_course_visibility'] = "Afficher les cours cachés/suspendus pour [étudiant]";
$string['student_grades'] = "Notes des étudiants";
$string['grid_view'] = "Vue Grille";
$string['list_view'] = "Vue liste";
$string['all_modules'] = 'Toutes les sections';

/* Attendance */
$string['attendance'] = 'Attendance';
$string['enableattendance'] = 'Activer attendance';
$string['attendancetoolurl'] = 'Tool URL';
$string['attendanceconsumerkey'] = 'Consumer key';
$string['attendancesharedsecret'] = 'Shared secret';
$string['sync_data_with_attendance'] = 'Synchroniser les données avec attendance';
$string['attendanceapibase'] = 'Attendance API base path';
$string['attendanceapikey'] = 'Attendance API clé';
$string['attendanceapisecret'] = 'Attendance API secret';
$string['enablesyncattendance'] = 'Activer BB Collaborate sessions synchronization with InAttendance';

/* BlackBoard Collaborate and InAttendance */
$string['bb_col_meetings'] = 'Réunions BlackBoard Collaborate';
$string['enable_bb_col_debug'] = 'Activer BlackBoard Collaborate debug';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API endpoint';
$string['bb_col_consumer_key'] = 'Clé client BlackBoard Collaborate';
$string['bb_col_secret'] = 'Secret de BlackBoard Collaborate';
$string['enable_bb_col_meetings'] = 'Activer les réunions BlackBoard Collaborate';
$string['check_active_bb_col_meetings'] = 'Vérifier la réunion Bb Collaborate active';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Début du suivi de la session BB Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Suivi terminé de la session BB Collaborate';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Demande d\'API terminée pour BB Collaborate';

/* Admin dashboard */
$string['admin_dashboard'] = 'Tableau de bord administrateur';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Inscription des utilisateurs, sessions et réalisation des activités';
$string['adm_dshb_adm_dashb_totals'] = 'Totaux';
$string['adm_dshb_user_site_summary_details'] = 'Rapport récapitulatif de l\'utilisateur';
$string['adm_dshb_course_enrollments_types'] = 'Types d\'inscription aux cours';
$string['adm_dshb_user_map'] = 'Carte des utilisateurs';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Inscriptions aux cours avec aperçu de l\'achèvement';
$string['adm_dshb_report_user_status'] = 'Rapport sur l\'état de l\'utilisateur';
$string['adm_dshb_report_activity_stats_summary'] = 'Rapport Statistiques d\'activité';
$string['adm_dshb_report_quiz_activity_detail'] = 'Rapport détaillé du quiz';

$string['instructor_hide_need_help'] = 'Masquer le bouton "Besoin d\'aide"';
$string['names_order'] = 'Ordre des noms';
$string['firstname_lastname'] = '{Prénom} {Nom de famille}';
$string['lastname_firstname'] = '{Nom de famille} {Prénom}';
$string['issuer'] = 'Émetteur';
$string['criteria_method'] = 'Méthode des critères';
$string['criteria_all_courses'] = 'Tous les cours suivants doivent être achevés';
$string['criteria_any_course'] = 'L\'un des cours suivants doit être achevé';
$string['dashboard_settings'] = 'Paramètres du tableau de bord';

$string['tracklogs'] = 'Suivi du temps par utilisateur - Quotidien';
$string['trackdetails'] = 'Temps de suivi cumulé - toutes les heures';
$string['tracktotals'] = 'Temps de suivi cumulé - Quotidien';

$string['enable_badges_report'] = 'Activer l\'onglet "Badges"';
$string['sizemode'] = 'Mode Taille : Grand ( > 5 000 Utilisateurs)';
$string['cachedef_bb_collaborate_access_token'] = 'Jeton d\'accès Bb Collaborate';

$string['learner_menu'] = 'Afficher le lien dans le menu de navigation uniquement si les étudiants sont inscrits au moins dans un cours';
#new strings
$string['intelliboard_reports'] = 'Rapports IntelliBoard';
$string['n19'] = 'Lien pour les rapports dans les cours';
$string['t54'] = 'Activer [Activity Grades] colonne temps passé';
$string['all_cohorts'] = 'Toutes les cohortes';
$string['privacy_shield_policy'] = 'Politique de sécurité';
$string['privacy_policy'] = 'Politique de confidentialité';
$string['confirm_and_sign_up'] = 'Confirmer et s\'inscrire';
$string['term_of_use'] = 'Conditions d\'utilisation';
$string['setup'] = 'Se connecter maintenant';
$string['protocol'] = 'Protocole';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = 'Suivant';
$string['terms_msg'] = 'En cochant cette case, vous confirmez avoir lu et accepté nos conditions d\'utilisation.';
$string['privacy_msg'] = 'En cochant cette case, vous confirmez avoir lu et accepté notre politique de confidentialité.';
$string['shield_msg'] = 'En cochant cette case, vous confirmez avoir lu et accepté notre politique de sécurité.';
$string['enable_webservice'] = 'Activer les services Web';
$string['you_need_to_enable_at_least_one_protocol'] = 'Vous devez activer au moins un protocole';
$string['invalid_user'] = 'Utilisateur invalide';
$string['sign_in'] = 'S\'identifier';
$string['email'] = 'E-mail';
$string['password'] = 'Mot de passe';
$string['all_fields_required'] = 'Tous les champs sont obligatoires';
$string['server_error'] = 'Erreur du serveur';
$string['country'] = 'Pays';
$string['please_accept_terms_and_conditions'] = 'Veuillez accepter les termes et conditions';
$string['congratulations_intb_register'] = 'Félicitations!';
$string['congratulations_intb_register_msg'] = 'Merci d\'avoir commencé votre essai d\'IntelliBoard ! Veuillez vérifier votre e-mail pour confirmer votre compte IntelliBoard. Pour commencer, utilisez le lien d\'authentification unique (SSO), s\'il est activé depuis Administration du site > IntelliBoard ou connectez-vous <a href="https://eu-app.intelliboard.net/signin">ici</a>. Le lien SSO se lit comme "INTELLIBOARD.NET" et se trouve dans le coin supérieur droit du tableau de bord. Pour toute question, veuillez contacter Support@IntelliBoard.net';
$string['sign_up'] = 'S\'inscrire';
$string['sign_in'] = 'S\'identifier';
$string['intelliboard_settings'] = 'Paramètres IntelliBoard';
$string['moodle_settings'] = 'Paramètres Moodle';
$string['email_is_required'] = 'L\'e-mail est requis';
$string['invalid_email'] = 'E-mail invalide';
$string['intelliboard_terms'] = 'Accords IntelliBoard';
$string['authentication'] = 'Création de compte';
$string['intb_settings_descr'] = "IntelliBoard nécessite un e-mail d\'abonnement principal et unique. Veuillez saisir ci-dessous l\'e-mail que vous souhaitez utiliser comme e-mail d\'abonnement. L\'e-mail doit être vérifié deux fois par le biais d'un e-mail de confirmation avant utilisation. Pour toute question, veuillez contacter <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>. Pour une liste complète des paramètres IntelliBoard, accédez à Administration du site > Plugins > Plugins locaux > IntelliBoard";
$string['hosting_provider'] = 'Hébergeur';
$string['self_hosted'] = 'Auto-hébergé';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'AAAA, "Semaine" SS';
$string['postgremonthyear'] = 'Mois AAAA';
$string['postgreyear'] = 'AAAA';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'Trimestre';
$string['postgredayshortmonthyear'] = 'JJ Mois, AAAA';
$string['postgretimedate'] = 'HH12:MIAM, JJ Mois AAAA';
$string['postgredaymonth'] = 'JJ Mois AAAA';
$string['postgremonthyearday'] = 'Mois AAAA, JJ';
$string['postgrequarteryear'] = 'T AAAA';
$string['postgremonthdayyear'] = 'MM/JJ/AAAA';
$string['postgretimemonthdayyear'] = 'HH24 MM/JJ/AAAA';

// new strings
$string['report1_name'] = 'Statut de l\'utilisateur';
$string['report2_name'] = 'Statistiques du cours';
$string['report3_name'] = 'Statistiques d\'Activité';
$string['report45_name'] = 'Détail de l\'activité Quiz';
$string['report_activity_stats_summary'] = 'Statistiques d\'Activité';
$string['report_user_profile_information'] = 'Informations sur le profil utilisateur';
$string['course_name'] = 'Nom du cours';
$string['course_short_name'] = 'Nom abrégé du cours';
$string['course_idnumber'] = 'ID cours';
$string['course_status'] = 'Statut';
$string['number_of_learners'] = 'Nombre d\'utilisateurs inscrits';
$string['number_of_modules'] = 'Nombre d\'activité(s)';
$string['number_of_completed_learners'] = 'Nombre d\'étudiants ayant achevé';
$string['number_of_visits'] = 'Visite(s)';
$string['num_completed_activity'] = 'Nombre d\'utilisateurs ayant terminé cette activité';
$string['total_time_spent'] = 'Temps total passé';
$string['date_created'] = 'Date de création';
$string['initial_reports'] = 'Rapports initiaux';
$string['avg_score'] = 'Score moyen';
$string['first_access'] = 'Premier accès';
$string['completion_not_enabled'] = 'Achèvement non activé';
$string['first_name'] = 'Prénom';
$string['last_name'] = 'Nom de famille';
$string['num_attempts'] = 'Nombre de tentatives';
$string['highest_grade'] = 'Note la plus élevée';
$string['lowest_grade'] = 'Note la plus basse';
$string['initial_reports_warning'] = 'Pour envoyer par e-mail, programmer et personnaliser davantage ces rapports, cliquez sur "<a href="{$a}">Connect & Upgrade</a>".';
$string['last_access'] = 'Dernier accès';
$string['enrolment_expiration'] = 'Expiration de l\'inscription';
$string['id_number'] = 'Numéro d\'identification';
$string['telephone1'] = 'Téléphone 1';
$string['telephone2'] = 'Téléphone 2';
$string['institution'] = 'Institution';
$string['department'] = 'Département';
$string['address'] = 'Adresse';
$string['city'] = 'Ville';
$string['enroled_on'] = 'Date de l\'inscription';

$string['dashboard_link'] = 'Cliquez pour afficher l\'Analytique IB';
$string['support_connect'] = 'Cliquez sur les boutons de rapport dans le rectangle ci-dessous. Découvrez la puissance d\'IntelliBoard : Un seul clic pour accéder à vos informations LMS. Cliquez sur "Cliquez pour afficher l\'Analytique IB". Souhaitez-vous en voir plus ? <a href="{$a->connect_link}">"Connect & Upgrade"</a> en haut à droite, ou partout où vous voyez le lien.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Besoin de plus d\'informations ? Cliquez sur l\'un des boutons bleus pour nous contacter.';

$string['web_services_descr'] = 'IntelliBoard nécessite l\'activation des services Web. Les services Web permettent à d\'autres systèmes (comme IntelliBoard) d\'accéder à ce système LMS et d\'effectuer des opérations. Pour des raisons de sécurité, cette option doit être désactivée lorsqu\'elle n\'est pas utilisée. Pour en vérifier, accédez à Administration du site > Fonctionnalités avancées > Services Web';
$string['protocol_descr'] = 'IntelliBoard nécessite l\'activation du protocole REST ou SOAP. Pour des raisons de sécurité, seuls les protocoles en cours d\'utilisation doivent être activés. Pour en vérifier, accédez à Administration du site> Plugins> Services Web> Gérer les protocoles';
$string['authorized_user_descr'] = 'IntelliBoard nécessite un utilisateur autorisé. L\'utilisateur autorisé sera probablement un administrateur de site et doit avoir des privilèges pour gérer les services Web, les protocoles et les jetons. Pour en vérifier, accédez à Administration du site > Plugins > Services Web > Services externes > Service IntelliBoard > Utilisateur autorisé';
$string['email_subscr'] = 'E-mail d\'abonnement';
$string['protocols_descr'] = 'IntelliBoard nécessite l\'activation du protocole REST ou SOAP. Pour des raisons de sécurité, seuls les protocoles en cours d\'utilisation doivent être activés. Pour en vérifier, accédez à Administration du site> Plugins> Services Web> Gérer les protocoles';
$string['enable_time_tracking'] = 'Activer le suivi du temps';
$string['enable_time_tracking_descr'] = 'Activez le suivi du temps pour obtenir des informations supplémentaires sur l\'accès des utilisateurs, les visites et le temps passé. IntelliBoard a son propre suivi du temps passé.';
$string['enable_sso'] = 'Activer le lien d\'authentification unique (SSO)';
$string['enable_sso_descr'] = 'Activez le lien d\'authentification unique (SSO) pour un accès en un clic pour les administrateurs du site à l\'accès SuperAdmin sur eu-app.IntelliBoard.net';
$string['join_a_webinar'] = 'Rejoignez un webinaire';
$string['review_support_doc'] = 'Examiner la documentation d\'assistance client';
$string['setup_subheading'] = 'Connectez-vous pour découvrir la puissance de vos données.';

$string['instructor_courses_table_name'] = 'Notes du cours';
$string['instructor_courses_table_name_learner'] = 'Cours {$a->course}, Learner {$a->learner}, Notes';
$string['instructor_courses_table_name_activity'] = 'Cours {$a->course}, Activity {$a->name}, Notes';
$string['instructor_courses_table_name_learners'] = 'Cours {$a->fullname}, Étudiants';
$string['instructor_courses_table_name_activities'] = 'Cours {$a->fullname}, Activités';

$string['successfull_connected'] = 'Connecté';
$string['not_connected'] = 'Pas connecté';

$string['transcripts'] = 'Transcriptions';
$string['enable_transcripts'] = 'Activer les transcriptions';
$string['closed'] = 'Fermé';
$string['synctranscriptstask'] = 'Tâche de synchronisation des transcriptions';
$string['transcriptssyncrecordsnum'] = 'Taille de traitement des transcriptions';
$string['transcriptssyncrecordsnum_desc'] = 'Le nombre d\'enregistrements d\'inscriptions d\'utilisateurs qui seront traités en une seule fois';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Relevés de notes des cours';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'ID Utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Adresse e-mail de l\'utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Prénom de l\'utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Nom de famille de l\'utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'transcriptions ID d\'inscription de l\'utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Méthode d\'inscription';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Méthode d\'inscription';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'ID du cours';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Nom complet du cours';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Date de l\'inscription';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Date de désinscription';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Date d\'achèvement';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'État de la transcription';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'ID d\'élément de note';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'ID de note';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Note maximale';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Note minimale';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Note finale';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Note formatée';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Rôles d\'utilisateur';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Groupes d\'utilisateurs';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Horodatage lors de la création de l\'enregistrement';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Horodatage de la dernière mise à jour de l\'enregistrement';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Relevés de notes des cours';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transcriptions ID d\'inscription de l\'utilisateur';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'ID du cours';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'ID Utilisateur';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'ID du module de cours';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'ID du module';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Nom de l\'activité';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Type de modules';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Date de début';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Date d\'achèvement';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Statut';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'ID d\'élément de note';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'ID de la note';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Note maximale';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Note minimale';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Note finale';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Note formatée';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Horodatage lors de la création de l\'enregistrement';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Horodatage de la dernière mise à jour de l\'enregistrement';
$string['goal_grade'] = 'Note cible';
$string['importtrackingtask'] = 'Tâche de suivi d\'importation';
$string['compresstracking'] = 'Compresser le suivi';
$string['compresstracking_desc'] = 'Écrire les données de suivi du temps dans un fichier et transférer les données dans la base de données avec la tâche cron (par défaut : toutes les 15 minutes)';
$string['cachedef_instructor_course_data'] = 'Cache pour les données de cours';
$string['cachedef_reports_list'] = 'Cache pour la liste des rapports';
$string['do_not_use_compresstracking'] = 'Ne pas utiliser Compress Tracking';
$string['cache_compresstracking'] = 'Enregistrer dans le cache Moodle';
$string['file_compresstracking'] = 'Enregistrer dans MoodleData';
$string['cachedef_tracking'] = 'Données de suivi Intelliboard';
$string['cachedef_track_config'] = 'Données totales Intelliboard Tracking';
$string['coursecontainer_filter'] = 'Activer le filtre du conteneur de cours';
$string['enableexportcustomfont'] = 'Police compatible japonaise/chinoise';
$string['all_selected'] = 'Tous sélectionnés';
$string['custommenuitem'] = 'Afficher dans le menu personnalisé';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
