<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

$string['pluginname'] = 'Плагин IntelliBoard.net';
$string['tracking_title'] = 'Учет времени';
$string['tracking'] = 'Отслеживание сеанса';
$string['dashboard'] = 'Панель инструментов';
$string['settings'] = 'Настройки';
$string['adv_settings'] = 'Расширенные настройки';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intelliboard_reports'] = 'Отчеты IntelliBoard';
$string['report'] = 'Отчет';
$string['reports'] = 'Отчеты';
$string['learners'] = 'Учащиеся';
$string['courses'] = 'Курсы';
$string['load'] = 'Производительность';
$string['inactivity'] = 'неактивность';
$string['inactivity_desc'] = 'Время неактивности пользователя (в секундах)';
$string['ajax'] = 'Частота';
$string['ajax_desc'] = 'Частота сохранения сеанса через AJAX. 0 - AJAX отключен (в секундах) ';
$string['enabled'] = 'Отслеживание включено';
$string['enabled_desc'] = 'Включить отслеживание';
$string['trackadmin'] = 'Администраторы отслеживания';
$string['logs'] = 'Инструмент миграции';
$string['trackadmin_desc'] = 'Включить отслеживание времени для пользователей с правами администратора (не рекомендуется)';
$string['intelliboard:instructors'] = 'IntelliBoard [инструктор]';
$string['intelliboard:students'] = 'IntelliBoard [учащийся]';
$string['intelliboard:view'] = 'IntelliBoard [просмотр]';
$string['intelliboard:manage'] = 'IntelliBoard [управление]';
$string['intelliboard:competency'] = 'IntelliBoard [компетенция]';
$string['intelliboard:attendanceadmin'] = 'Администратор посещаемости';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Просмотреть все глобальные группы]';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Дополнительные настройки: TLS v1.2';
$string['sso'] = 'Ссылка единого входа';
$string['sso_desc'] = 'Ссылка SSO на IntelliBoard.net';
$string['ssomenu'] = 'Пункт меню единого входа';
$string['ssomenu_desc'] = 'Ссылка SSO в меню блока навигации (для не учащихся/не преподавателей)';
$string['api'] = 'Альтернативный API';
$string['api_desc'] = 'Использовать альтернативный сервер API (чтобы избежать блокировки firewall)';
$string['server'] = 'Сервер IntelliBoard';
$string['server_usa'] = 'IntelliBoard USA';
$string['server_au'] = 'IntelliBoard Australia';
$string['server_eu'] = 'IntelliBoard Europe';
$string['show_dashboard_tab'] = 'Страница панели инструментов';
$string['filters'] = 'Фильтры панели инструментов';
$string['filter1'] = 'Удаленные пользователи';
$string['filter2'] = 'Пользователи с приостановленными аккаунтами';
$string['filter3'] = 'Гость';
$string['filter4'] = 'Фильтр курса';
$string['filter5'] = 'Фильтр метода регистрации';
$string['filter6'] = 'Фильтр регистрации пользователей';
$string['filter7'] = 'Фильтр элементов/ресурсов';
$string['filter8'] = 'Фильтр зарегистрированных пользователей';
$string['filter1_desc'] = 'Показать удаленных пользователей';
$string['filter2_desc'] = 'Показать заблокированных пользователей';
$string['filter3_desc'] = 'Показывать [гостя] в отчетах';
$string['filter4_desc'] = 'Показать cкрытые курсы';
$string['filter5_desc'] = 'Показать неактивные методы регистрации';
$string['filter6_desc'] = 'Показывать пользователей с неактивным статусом регистрации';
$string['filter7_desc'] = 'Показывать скрытые элементы/ресурсы';
$string['filter8_desc'] = 'Показывать только зарегистрированных пользователей (не рекомендуется)';
$string['intelliboardaccess'] = 'У вас нет разрешения на просмотр этой страницы. За помощью обратитесь к своему администратору.';
$string['tex1'] = 'Панель инструментов ученика не включена.';
$string['account'] = 'Информация о подписке';
$string['te12'] = 'Имя';
$string['te13'] = 'Фамилия';
$string['te1'] = 'Электронная почта';
$string['te1_desc'] = 'Введите адрес электронной почты, используемый с подпиской IntelliBoard.net. Если у вас нет активной подписки, зарегистрируйтесь на <a target="_blank" href="https://intelliboard.net"> IntelliBoard.net </a>. Панель управления для учащегося и инструктора доступна при подписке уровня 4 и выше.';
$string['n1'] = 'Обзор [Успеваемость]';
$string['n2'] = 'Обзор [Прогресс оценок]';
$string['n3'] = 'Обзор [Ход выполнения]';
$string['n12'] = 'Обзор [Обзор курса]';
$string['n4'] = 'Обзор [Итоги]';
$string['n5'] = 'Текущий прогресс';
$string['n13'] = 'Всего студентов';
$string['n6'] = 'Виджет: Корреляции';
$string['n14'] = 'Виджет: Вовлеченность учащихся';
$string['n18'] = 'Виджет: Успеваемость учащегося';
$string['n7'] = 'Виджет: Использование событий';
$string['n15'] = 'Виджет: Использование элементов';
$string['n16'] = 'Виджет: Использование темы';
$string['n8'] = 'Страница курсов';
$string['n9'] = 'Страница отчетов';
$string['n19'] = 'Ссылка для навигации по курсу для отчетов';
$string['n10'] = 'Панель инструктора';
$string['n101'] = 'Включить панель инструктора';
$string['n11'] = 'Альтернативный текст для меню блока навигации';
$string['ts1'] = 'Панель инструментов учащегося';
$string['ts2'] = 'Страница панели инструментов';
$string['ts3'] = 'Курсы панели инструментов';
$string['ts4'] = 'Оценки на панели инструментов учащегося';
$string['ts5'] = 'Отчеты на панели инструментов учащегося';
$string['learner_tf_last_week'] = 'Фильтр времени: 7 дней';
$string['t01'] = 'Фильтр времени: Последние 30 дней';
$string['t02'] = 'Фильтр времени: Последние 3 месяца';
$string['t03'] = 'Фильтр времени: Последние 6 месяцев';
$string['t04'] = 'Включить [заголовок] Пройденные курсы';
$string['t05'] = 'Включить [заголовок] Текущие курсы';
$string['t06'] = 'Включить [заголовок] Средняя оценка по курсам';
$string['t07'] = 'Включить [заголовок] Сообщения';
$string['t08'] = 'Включить [заголовок] Суммарная оценка по курсам';
$string['t09'] = 'Преподаватель может видеть своих учеников';
$string['t1'] = 'Включить панель инструментов учащегося';
$string['t2'] = 'Включить панель инструментов';
$string['t3'] = 'Включить курсы';
$string['t4'] = 'Включить оценки';
$string['t48'] = 'Включить отчеты';
$string['t5'] = 'Включить график [Прогресс элементов]';
$string['t53'] = 'Включить на графике [Прогресс элементов] среднюю линию';
$string['t6'] = 'Включить график [Прогресс курса]';
$string['t7'] = 'Включить [Мое среднее значение по курса]';
$string['t8'] = 'Включить [Общее среднее значение курса]';
$string['t9'] = 'Включить виджет [Задания]';
$string['t10'] = 'Включить виджет [Тесты]';
$string['t11'] = 'Включить виджет [Прогресс курса]';
$string['t12'] = 'Включить виджет [Участие в элементе]';
$string['t13'] = 'Включить виджет [Обучение]';
$string['t14'] = 'Включить виджет [Успеваемость в курсе]';
$string['t15'] = 'Включить виджет [Корреляции]';
$string['t16'] = 'Включить преподавателя курса';
$string['t17'] = 'Включить категорию курса';
$string['t18'] = 'Разрешить завершение курса';
$string['t19'] = 'Включить оценку за курс';
$string['t20'] = 'Включить среднее значение по курсу';
$string['t21'] = 'Включить затраченное время на курс';
$string['t22'] = 'Включить дату начала курса';
$string['t23'] = 'Включить столбец [Дата начала курса]';
$string['t24'] = 'Включить столбец [Дата регистрации]';
$string['t25'] = 'Включить столбец [Прогресс]';
$string['t26'] = 'Включить столбец [Буква]';
$string['t27'] = 'Включить столбец [Завершенные элементы]';
$string['t28'] = 'Включить столбец [Оценка]';
$string['t29'] = 'Включить столбец [Статус завершения курса]';
$string['t30'] = 'Включить столбец [Оценки элементов]';
$string['t31'] = 'Включить столбец виджета [Задание] [Оценка]';
$string['t32'] = 'Включить столбец виджета [Задание] [Срок сдачи]';
$string['t33'] = 'Включить столбец виджета [Тесты] [Оценка]';
$string['t34'] = 'Включить столбец виджета [Тесты] [Срок сдачи]';
$string['t35'] = 'Включить столбец виджета [Прогресс курса] [Прогресс]';
$string['t36'] = 'Включить столбец виджета [Прогресс курса] [Оценка]';
$string['t37'] = 'Включить столбец виджета [Прогресс курса] [Зачислен]';
$string['t38'] = 'Включить столбец виджета [Прогресс курса] [Завершено]';
$string['t52'] = 'Включить строки виджета [Прогресс курса] [Категория]';
$string['t39'] = 'Включить опцию [Прогресс] [Целевая оценка]';
$string['t40'] = 'Включить опцию [Прогресс] [Среднее по классу]';
$string['t41'] = 'Включить [Заголовок оценок элементов] Завершено';
$string['t42'] = 'Включить [Заголовок оценок элементов] Последний доступ на курсе';
$string['t43'] = 'Включить столбец [Оценки элементов] Тип';
$string['t44'] = 'Включить столбец [Оценки элементов] Оценка';
$string['t45'] = 'Включить столбец [оценки элементов] Оценено';
$string['t46'] = 'Включить столбец [Оценки элементов] Завершено';
$string['t54'] = 'Включить столбец [Оценки элементов] Затраченное время';
$string['t47'] = 'Цвет фона [таблицы] курсов';
$string['t49'] = 'Столбцы фильтра отчета';
$string['t50'] = 'Роли преподавателей';
$string['t51'] = 'Роли учащихся';
$string['current_grade'] = 'Текущая оценка';
$string['average_grade'] = 'Cредняя оценка';
$string['type_here'] = 'Введите здесь ...';
$string['enrolled_date'] = 'Дата зачисления';
$string['teacher'] = 'Преподаватель';
$string['category'] = 'Категория';
$string['current_grade'] = 'Текущая оценка';
$string['completion'] = 'Завершение';
$string['class_average'] = 'Среднее по классу';
$string['time_spent'] = 'Затраченное время';
$string['completed_on'] = 'Завершено {$a}';
$string['passed_on'] = 'Завершено (пройдено) {$a}';
$string['failed_on'] = 'Завершено (не пройдено) {$a}';
$string['last_access_on_course'] = 'Последний доступ на курс: {$a}'.
$string['you_have_certificates'] = 'У вас есть {$a} сертификатов'.
$string['close'] = 'Закрыть';
$string['view_course_details'] = 'Просмотреть подробности курса';
$string['incomplete'] = 'Не завершено';
$string['return_to_grades'] = 'Вернуться к оценкам';
$string['grade'] = 'Оценка';
$string['last_week'] = 'Последние 7 дней';
$string['last_month'] = 'Последние 30 дней';
$string['last_quarter'] = 'Последние 3 месяца';
$string['last_semester'] = 'Последние 6 месяцев';
$string['all_time'] = 'Все время';
$string['activity_progress'] = 'Прогресс элементов';
$string['course_progress'] = 'Прогресс курса';
$string['my_course_average_all'] = 'Мое среднее значение курса (все курсы)';
$string['overall_course_average'] = 'Общее среднее значение курса (все учащиеся; все курсы)';
$string['assignments'] = 'Задания';
$string['quizzes'] = 'Тесты';
$string['assignment_name'] = 'Название задания';
$string['due_date'] = 'Срок сдачи';
$string['no_data'] = 'Нет данных';
$string['quiz_name'] = 'Название теста';
$string['all_courses'] = 'Все курсы';
$string['time_period_due'] = 'Период времени (срок сдачи)';
$string['all_data'] = 'Все данные';
$string['progress'] = 'Прогресс';
$string['enrolled'] = 'Зачислен';
$string['completed'] = 'Завершено';
$string['activity_participation'] = 'Активное участие';
$string['learning'] = 'Обучение';
$string['course_success'] = 'Успеваемость на курсе';
$string['correlations'] = 'Корреляции';
$string['course_start_date'] = 'Дата начала курса';
$string['letter'] = 'Письмо';
$string['completed_activities'] = 'Завершенные элементы';
$string['score'] = 'Оценка';
$string['course_completion_status'] = 'Статус завершения курса';
$string['activity_grades'] = 'Оценки элементов';
$string['completion_is_not_enabled'] = 'Завершение для этого курса не разрешено';
$string['activities'] = 'Элементы';
$string['activity_name'] = 'Название элемента';
$string['type'] = 'Тип';
$string['graded'] = 'Оценено';
$string['passed'] = 'Пройдено';
$string['failed'] = 'Не пройдено';
$string['completed_courses'] = 'Завершенные курсы';
$string['courses_in_progress'] = 'Курсы в процессе';
$string['courses_avg_grade'] = 'Cредняя оценка по курсам';
$string['courses_sum_grade'] = 'Суммарная оценка за курс по значению шкалы оценок';
$string['grades'] = 'Оценки';
$string['messages'] = 'Сообщения';
$string['x_completions'] = '{$a} завершений';
$string['completion_status'] = 'Статус завершения';
$string['users_activity'] = 'Активность пользователей';
$string['daily'] = 'Последние 10 дней';
$string['weekly'] = 'Последние 90 дней';
$string['monthly'] = 'Последние 365 дней';
$string['number_of_sessions'] = 'Количество сеансов';
$string['number_today'] = '{$a} сегодня';
$string['number_this_week'] = '{$a} на этой неделе';
$string['course_completions'] = 'Завершенные курсы';
$string['user_enrolments'] = 'Зачиления пользователей';
$string['users'] = 'Пользователи';
$string['modules'] = 'Модули';
$string['categories'] = 'Категории';
$string['total'] = 'Всего';
$string['users_overview'] = 'Обзор пользователей';
$string['enable_time_and_visits_users_overview'] = 'Включить затраченное время и посещения в обзоре пользователей';
$string['disable_time_and_visits_users_overview'] = 'Отключить затраченное время и посещения в обзоре пользователей';
$string['loading'] = 'Загрузка ...';
$string['loading2'] = 'Подождите, загрузка ...';
$string['enrollments'] = 'Зачисления';
$string['registrations'] = 'Регистрации';
$string['participation'] = 'Участие';
$string['time'] = 'Время';
$string['enrolment_method'] = 'Метод регистрации';
$string['intelliBoard_migration_tool'] = 'Инструмент миграции IntelliBoard';
$string['importing_totals'] = 'Импорт итогов';
$string['total_numbers'] = 'Дата: {$a->timepoint}, Сеансы: {$a->sessions}, Посещения: {$a->visits}, Затраченное время: {$a->timespend}';
$string['total_numbers2'] = 'ПОЛЬЗОВАТЕЛЬ: {$a->userid}, Страница: {$a->page}, Параметр: {$a->param}, Посещения: {$a->visits},  Затраченное время: {$a->timespend}';
$string['total_numbers3'] = '---- Дата: {$a->timecreated}, ID отслеживания: {$a->trackid}, Посещения: {$a->visits},  затраченное время: {$a->timespend}';
$string['logs_to_process'] = 'Журналы для обработки {$a}';
$string['please_wait_or_cancel'] = 'Подождите, чтобы продолжить, или <ahref="{$a}">Отменить</a>';
$string['done'] = 'Готово!';
$string['return_to_home'] = 'Вернуться домой';
$string['importing_logs'] = 'Импорт журналов';
$string['intelliBoard_migration_tool_info'] = 'Инструмент миграции IntelliBoard используется для переноса исторических данных из таблицы журналов Moodle в новый формат. Обратите внимание, порядок хранения логов Moodle не изменится. После переноса исторических данных в новый формат исторические значения, такие как «Затраченное время» и «Посещения», будут доступны для предварительного просмотра на IntelliBoard.net.';
$string['moodle_logs'] = 'Журналы Moodle';
$string['intelliboard_tracking'] = 'Отслеживание IntelliBoard';
$string['intelliboard_logs'] = 'Журналы IntelliBoard';
$string['intelliboard_totals'] = 'Итоги IntelliBoard';
$string['intelliboard_start_tracking'] = 'IntelliBoard начинает отслеживание';
$string['total_values_include'] = 'Общие значения включают уникальные сеансы, курсы, посещения, затраченное время.';
$string['items_per_query'] = 'Элементов по запросу';
$string['import'] = 'Импорт';
$string['log_values_include'] = 'Значения журнала включают журналы для каждого пользователя за день.';
$string['powered_by'] = 'На платформе <a href="https://intelliboard.net/"> IntelliBoard.net </a>';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['visits'] = 'Посещения';
$string['registered'] = 'Зарегистрировано';
$string['disabled'] = 'Отключено';
$string['enrolled_completed'] = 'Зачислено: {$a->курсы}, Завершено: {$a->completed_courses}';
$string['enrolled_users_completed'] = 'Зачисленные пользователи: {$a->users}, Завершившие: {$a->completed}';
$string['user_grade_avg'] = '{$a->user} оценка: {$a->grade}, Средняя оценка: {$a->avg_grade_site})';
$string['user_visit_avg'] = '{$a->user} посещений: {$a->visits}, Среднее количество посещений: {$a->avg_visits_site}';
$string['user_time_avg'] = '{$a->user} время: {$a->timespend}, Среднее время: {$a->avg_timespend_site}';
$string['more_users'] = 'Больше пользователей';
$string['more_courses'] = 'Другие курсы';
$string['showing_1_to_10'] = 'Отображение от 1 до 10';
$string['course_grade'] = 'Оценка за курс';
$string['completed_activities_resourses'] = 'Завершенные элементы/ресурсы';
$string['save'] = 'Сохранить';
$string['help'] = 'Нужна помощь?';
$string['in1'] = 'Обзор';
$string['in2'] = 'Текущий прогресс';
$string['in3'] = 'Всего курсов';
$string['in4'] = 'Всего учащихся';
$string['in5'] = 'Общие оценки за курс';
$string['in6'] = 'Завершившие учащиеся';
$string['in7'] = 'Не завершившие учащиеся';
$string['in8'] = 'Средняя оценка учащегося';
$string['in9'] = 'Корреляции';
$string['in10'] = 'Использование событий';
$string['in11'] = 'Успеваемость ученика';
$string['in12'] = 'Прогресс оценок';
$string['in13'] = 'Затраченное время (%)';
$string['in14'] = '% прогресса';
$string['in15'] = 'Завершения учащихся';
$string['in16'] = 'Последний доступ';
$string['in17'] = 'Общее затраченное время';
$string['in18'] = 'Всего посещений';
$string['in19'] = 'Сред. Оценка';
$string['in20'] = 'Вернуться к учащимся';
$string['in201'] = 'Вернуться к элементам';
$string['in21'] = 'Средняя оценка по курсу';
$string['in22'] = 'Включено';
$string['in23'] = 'У вас нет учащихся для отображения.';
$string['in24'] = 'Модуль';
$string['in25'] = 'Оценка прохождения';
$string['in26'] = 'Активность учащихся';
$string['in34'] = 'Прогресс оценок учащихся';
$string['in27'] = 'Всего студентов';
$string['in28'] = 'Среднее затраченное время';
$string['in29'] = 'Активные студенты';
$string['in30'] = 'Неактивные студенты';
$string['in31'] = 'Использование элемента';
$string['in32'] = 'Среднее время за выбранный период';
$string['in33'] = 'Использование темы';
$string['status'] = 'Статус';
$string['course_category'] = 'Категория курса';
$string['course_started'] = 'Курс начат';
$string['total_time_spent_enrolled_learners'] = 'Общее время, затраченное зачисленными учащимися на курс';
$string['total_visits_enrolled_learners'] = 'Общее количество посещений зачисленных учащихся на курсе';
$string['learners_enrolled'] = 'Учащиеся зачислены';
$string['learners_enrolled_period'] = 'Учащиеся зачислены в течение выбранного периода';
$string['learning_progress'] = 'Прогресс обучения';
$string['sections'] = 'Разделы';
$string['section'] = 'Раздел';
$string['total_activities_resources'] = 'Всего элементов/ресурсов';
$string['completions'] = 'Завершения';
$string['return_to_courses'] = 'Вернуться к курсам';
$string['click_link_below_support_pages'] = 'Щелкните ссылку ниже, чтобы перейти на страницы поддержки IntelliBoard:';
$string['support'] = 'Поддержка';
$string['course_name'] = 'Название курса';
$string['enrolled_completed_learners'] = 'Зачисленные/завершившие учащиеся';
$string['activities_resources'] = 'Элементы/ресурсы';
$string['actions'] = 'Действия';
$string['learner_name'] = 'Имя учащегося';
$string['completed_activities_resources'] = 'Завершенные элементы/ресурсы';
$string['filter_dates'] = 'Фильтровать даты:';
$string['select_date'] = 'Выбрать дату';
$string['select'] = 'Выбрать';
$string['selectall'] = 'Выбрать все';
$string['ok'] = 'ОК';
$string['moodle'] = 'Moodle';
$string['totara'] = 'Totara';
$string['monitors'] = 'Мониторы';
$string['cohorts'] = 'Глобальные группы';
$string['course_overview'] = 'Обзор курса';
$string['topics'] = 'Темы';
$string['a31'] = 'Фреймворки';
$string['a32'] = 'Учебные планы';
$string['a33'] = 'С оценкой, владеет знаниями';
$string['a34'] = 'С оценкой, не владеет знаниями';
$string['a35'] = 'Без оценки';
$string['a36'] = 'Обзор компетенций';
$string['a37'] = 'Компетенция не создана. Пожалуйста, обратитесь к системному администратору.';
$string['a38'] = 'Курсы, связанные с компетенциями';
$string['a39'] = 'Итоги по компетенциям';
$string['a40'] = 'Связанные курсы';
$string['no_competency'] = 'Похоже, на вашем сайте Moodle не включены компетенции.';
$string['scalesettings'] = 'Настройки шкалы';
$string['scales'] = 'Включить настраиваемую шкалу';
$string['scale_raw'] = 'Отключить шкалу';
$string['scale_real'] = 'Показывать реальную оценку вместо процентов';
$string['scale_total'] = 'Итоговая оценка';
$string['scale_value'] = 'Значение';
$string['scale_percentage'] = 'Процент';
$string['a0'] = 'Панель управления компетенциями';
$string['a1'] = 'Компетенции';
$string['a2'] = 'Уровень владения';
$string['a3'] = 'Назначенные элементы';
$string['a4'] = 'Прогресс владения';
$string['a5'] = 'Оцененные компетенции';
$string['a6'] = 'Количество доказательств';
$string['a7'] = 'Оцененные учащиеся';
$string['a8'] = 'Прогресс';
$string['a9'] = 'Овладевшие учащиеся';
$string['a10'] = 'Зачисленные учащиеся';
$string['a11'] = 'Список компетенций, закрепленных за курсом';
$string['a12'] = 'Статус учащегося';
$string['a13'] = 'Название компетенции';
$string['a14'] = 'Дата создания';
$string['a15'] = 'Дата назначения';
$string['a16'] = 'Получили уровень владения';
$string['a17'] = 'Рейтинг';
$string['a18'] = 'Владеет компетенциями';
$string['a19'] = 'Дата присвоения рейтинга компетентности';
$string['a20'] = 'Оценщик компетенций';
$string['a21'] = 'Назначенные элементы';
$string['a22'] = 'Уровень владения достигнут';
$string['a23'] = 'Компетенции оценены';
$string['a24'] = 'Количество доказательств';
$string['a25'] = 'Завершившие обучение';
$string['a27'] = ' вне ';
$string['a28'] = 'Подробности';
$string['a29'] = 'Включить панель управления компетенциями';
$string['a30'] = 'Включить отчеты о компетенциях';
$string['a26'] = 'В этой таблице отображается количество компетенций, присвоенных курсу, учащиеся, получившие оценку (независимо от того, владеют они навыками или нет), и учащиеся, которые были назначены специалистами в данной компетенции.';
$string['s25'] = 'Время, затраченное на элемент';
$string['s45'] = 'Элемент';
$string['s46'] = 'Процент учащихся, пытающихся сделать это';
$string['s47'] = 'Тема';
$string['s48'] = 'Время, затраченное на тему';
$string['completions'] = 'Статус завершения элемента';
$string['completions_completed'] = 'Статус завершения (завершено)';
$string['completions_pass'] = 'Статус завершения (пройдено)';
$string['completions_fail'] = 'Статус завершения (не пройдено)';
$string['completions_desc'] = '1) Пользователь выполнил это действие. Не уточняется, прошли ли они его или нет. <br>
2) Пользователь выполнил это задание с оценкой выше проходной. <br>
3) Пользователь выполнил это действие, но его оценка ниже проходной.';
$string['widget_name27'] = 'Общее количество подписок';
$string['widget_name28'] = 'Активность';
$string['widget_name29'] = 'Уникальные логины';
$string['widget_name30'] = 'Зачисления по курсу';
$string['widget_name31'] = 'Участие регистраторов и руководителей';
$string['role1'] = 'Первая роль';
$string['role2'] = 'Вторая роль';
$string['select_course'] = 'Выбрать курс';
$string['select_quiz'] = 'Выбрать тест';
$string['not_quiz'] = 'К сожалению, похоже, у вас не созданы тесты для выбранного курса.';
$string['enter_course_and_quiz'] = 'Пожалуйста, выберите курс и тест.';
$string['enter_quiz'] = 'Выберите тест.';
$string['analityc_3_name'] = "Обзор теста и детали вопросов";
$string['course_name_a'] = 'Курс: {$a}';
$string['quiz_name_a'] = 'Тест: {$a}';
$string['cor_incor_answers'] = 'Правильные/неправильные ответы';
$string['quiz_finished'] = 'Тест завершен';
$string['quiz_grades'] = 'Оценки за тест';
$string['correct_number'] = 'Верно {$a}';
$string['incorrect_number'] = 'Неверно {$a}';
$string['correct'] = 'Верно';
$string['incorrect'] = 'Неверно';
$string['weekday_0'] = 'Понедельник';
$string['weekday_1'] = 'Вторник';
$string['weekday_2'] = 'Среда';
$string['weekday_3'] = 'Четверг';
$string['weekday_4'] = 'Пятница';
$string['weekday_5'] = 'Суббота';
$string['weekday_6'] = 'Воскресенье';
$string['time_1'] = 'Утро';
$string['time_2'] = 'Полдень';
$string['time_3'] = 'Вечер';
$string['time_4'] = 'Ночь';
$string['passing_score_for'] = 'Проходная оценка за {$a}';
$string['name'] = 'Название';
$string['answers'] = 'Ответы';
$string['ques_breakdown'] = 'Анализ вопросов';
$string['n17'] = 'Страница аналитики';
$string['analytics'] = 'Аналитика';
$string['pdf'] = 'PDF';
$string['csv'] = 'CSV';
$string['excel'] = 'Excel';
$string['grades_alt_text'] = 'Альтернативный текст для меню навигации';
$string['course_chart'] = 'Включить диаграмму курса';
$string['course_activities'] = 'Включить элементы курса';
$string['filter_this_year'] = 'Фильтр времени: Этот год';
$string['filter_last_year'] = 'Фильтр времени: Прошлый год';
$string['filter_all_time'] = 'Фильтр времени: Все время';
$string['this_year'] = 'Этот год';
$string['last_year'] = 'Прошлый год';
$string['reportselect'] = 'Выберите хотя бы один отчет из App.IntelliBoard.net. Щелкните «Отчеты», затем «Персонализировать отчет» и выберите его в «Доступность в СУО».';
$string['monitorselect'] = 'Выберите хотя бы один монитор из App.IntelliBoard.net. Щелкните «Мониторы», затем «Персонализировать набор мониторов» и выберите его в «Доступность в СУО».';
$string['select_user'] = 'Выберите пользователя';
$string['course_max_grade'] = 'Максимальная оценка курса';
$string['no_data_notification'] = 'Нет новых данных за [дата]';
$string['last_hour'] = 'час';
$string['last_day'] = 'день';
$string['privacy:metadata:local_intelliboard_assign'] = 'Таблица назначаемых субаккаунтов Intelliboard';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/logs/почасовая таблица';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/logs/ежедневная таблица';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/logs/итоговая таблица';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/logs/за все время таблица';
$string['privacy:metadata:local_intelliboard_reports'] = 'Таблица пользовательских sql отчетов Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Основная таблица уведомлений Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Таблица истории уведомлений Intelliboard';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Таблица динамических параметров уведомлений Intelliboard';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'ID ПОЛЬЗОВАТЕЛЯ записи';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Относительный тип записи';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Тип подключения Moodle';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'Идентификатор подключения Moodle';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Отметка времени записи';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Статус отчета - активирован / не активирован';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Название пользовательского отчета';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'Код SQL в кодировке BASE64';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Время создания';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'Идентификатор таблицы [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Количество посещений, щелчков мышью, в день';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Количество затраченного времени в час';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'Час';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'Идентификатор таблицы [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Посещения, щелчки мышью, в день';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Затраченное время, в день';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Отметка времени дня в году';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Общее количество сессий пользователей в Moodle';
$string['privacy:metadata:local_intelliboard_totals:courses'] = 'Всего курсов в Moodle';
$string['privacy:metadata:local_intelliboard_totals:visits'] = 'Общее количество посещений всеми пользователями Moodle';
$string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Общее время, проведенное пользователями в Moodle';
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Отметка времени дня в году';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'ID пользователя, который посещает страницу Moodle.';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Идентификатор курса, который посещает пользователь';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Тип страницы [курс, элемент, профиль, сайт]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Тип ID страницы';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Пользователи, посещающие страницу';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Время, затраченное пользователями на странице';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Первый доступ пользователей';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Последний доступ пользователей';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Тип браузера пользователей';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Операционная система пользователей';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Язык браузера пользователей';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Последний IP-адрес пользователя';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'ID уведомления';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Тип уведомления';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Внешний ID уведомления';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Внешний AppID уведомления';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Электронная почта для уведомления';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Копия уведомления';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Тема уведомления';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Сообщение уведомления';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Статус уведомления';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Вложение для уведомления';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Теги уведомления';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'ID истории уведомлений';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'ID уведомления';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Внешний AppID уведомления';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Название уведомления';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Электронная почта истории уведомления';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Временная метка истории уведомления';
$string['select_manager_role'] = 'Выберите роль менеджера';
$string['group_aggregation'] = 'Групповая агрегация';
$string['ssodomain'] = 'SSO субдомена';
$string['ssodomain_desc'] = 'Единый вход (SSO) с разделенным сервером/учетной записью';
$string['instructor_redirect'] = 'Перенаправление инструктора';
$string['student_redirect'] = 'Перенаправление учащегося';
$string['myorders'] = 'Заказы';
$string['myseats'] = 'Места';
$string['mywaitlist'] = 'Список ожидания';
$string['mysubscriptions'] = 'Подписки';
$string['seatscode'] = 'Код мест';
$string['numberofseats'] = 'Количество мест';
$string['downloadinvoice'] = 'Загрузить выставленный счет';
$string['product'] = 'Продукт';
$string['key'] = 'Ключ';
$string['created'] = 'Создано';
$string['seatnumber'] = 'Количество мест';
$string['seatsused'] = 'Количество занятых мест';
$string['details'] = 'Подробности';
$string['username'] = 'Имя пользователя';
$string['used'] = 'Дата занятия';
$string['status'] = 'Статус';
$string['subscriptiondate'] = 'Дата подписки';
$string['price'] = 'Цена';
$string['recurringperiod'] = 'Повторяющийся период';
$string['billingcycles'] = 'Циклы выставления счетов';
$string['active'] = 'Активный';
$string['suspended'] = 'Приостановлено';
$string['canceled'] = 'Отменено';
$string['expired'] = 'Просрочено';
$string['process'] = 'Обрабатывается';
$string['cancel_subscription'] = 'Отменить подписку';
$string['sqlreport'] = 'Отчет SQL';
$string['sqlreportcreate'] = 'Создать отчет';
$string['sqlreports'] = 'Отчеты SQL';
$string['sqlreportname'] = 'Название отчета';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportdate'] = 'Дата создания';
$string['sqlreportactive'] = 'Активировано';
$string['sqlreportinactive'] = 'Деактивировано';
$string['remove_message'] = 'Отчет SQL был удален';
$string['delete_message'] = 'Удалить отчет SQL?';
$string['success_message'] = 'Отчет SQL сохранен';
$string['scale_percentage_round'] = 'Округление в процентах';
$string['instructor_show_suspended_enrollments'] = 'Показать приостановленные зачисления';
$string['instructor_hide_suspended_enrollments'] = 'Скрыть приостановленные зачисления';
// Встречи BigBlueButton
$string['bbbapiendpoint'] = 'Конечная точка BBB API';
$string['bbbserversecret'] = 'Секретный ключ сервера BBB';
$string['check_active_meetings'] = 'Проверить активные встречи';
$string['bbbmeetings'] = 'Встречи BigBlueButton';
$string['enablebbbmeetings'] = 'Включить мониторинг собраний BigBlueButton';
$string['enablebbbdebug'] = 'Режим отладки BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'Журнал о встречах BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'ID журнала встреч';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Название встречи';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'ID встречи';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'Внутренний (на сервере BBB) ID встречи';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Время создания (временная метка)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Дата создания (строка)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Добавочный номер для голосового моста (используется при подключении к телефонной системе)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Номер доступа для набора номера, по которому участники могут звонить с обычного телефона.';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Пароль, который потребуется участникам для присоединения к собранию';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Пароль, который потребуется модераторам для присоединения к собранию или для определенных административных действий';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Статус собрания (активно|остановлено)';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Продолжительность встречи';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Флаг. Пользователи присоединились к встрече';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Флаг. Встреча будет записана';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Флаг. Митинг завершен принудительно';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Время начала встречи';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Время окончания встречи';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Количество участников';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Количество слушателей';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Количество участников с подключенным микрофоном';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Количество участников с подключенной видеокамерой';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Максимальное количество участников';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Количество модераторов';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'ID курса';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'ID элемента курса';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'ID строки в таблице bigbluebuttonbn';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'ID владельца (пользователь, создавший встречу)';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'Журнал о посетителях собраний BigBlueButton';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'ID участника';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'ID пользователя (строка в таблице «пользователь»)';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Полное имя участника встречи';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Роль участника встречи';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Флаг. Участник - ведущий';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Флаг. У участника нет подключенного микрофона или веб-камеры';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Флаг. Посетитель подключил микрофон';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Флаг. Посетитель подключил веб-камеру';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'ID встречи (ID на сервере BigBlueButton)';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'ID встречи (ID в таблице local_intelliboard_bbb_meet)';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Время, когда пользователь подключился к встрече';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Время, когда пользователь отключился от встречи';
$string['messageprovider:intelliboard_notification'] = "Уведомление Intelliboard";
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'Список участников сеанса Collaborate';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'ID участия в сеансе';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'UUID сеанса';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'UUID пользователя (служба BlackBoard Collaborate)';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'ID пользователя (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Роль в сеансе';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Имя пользователя';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Первое присоединение к сеансу';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Последний выход из сеанса';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Затраченное время на сеанс';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Количество повторных подключений к сеансу';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'Список отслеживаемых сеансов';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'ID журнала отслеживания';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'UUID сеанса';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'Отслеживать время';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Список синхронизированных сеансов';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'ID журнала синхронизации';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Тип сеанса';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'ID сеанса Moodle';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Дополнительные данные синхронизации';
$string['verifypeer'] = 'CURLOPT SSL VERIFYPEER';
$string['verifypeer_desc'] = 'Эта опция определяет, проверяет ли curl подлинность сертификата партнера.';
$string['verifyhost'] = 'CURLOPT SSL VERIFY HOST';
$string['verifyhost_desc'] = 'Эта опция определяет, проверяет ли libcurl, что сертификат сервера принадлежит серверу, которому он известен.';
$string['cipherlist'] = 'CURLOPT SSL CIPHER LIST';
$string['cipherlist_desc'] = 'Укажите шифры, которые будут использоваться для TLS';
$string['sslversion'] = 'CURLOPT SSLVERSION';
$string['sslversion_desc'] = 'Передайте параметр long as, чтобы контролировать, какой диапазон версий версий SSL/TLS использовать';
$string['debug'] = 'Отладка запросов CURL';
$string['debug_desc'] = '';
/* IntelliCart */
$string['intellicart'] = 'Интеграция IntelliCart';
$string['intellicart_desc'] = 'Разрешить учащимся просматривать отчеты IntelliCart.';
$string['classessessionspage'] = 'Страница сеансов курсов';
$string['classessessions'] = 'Сеансы курсов';
$string['session_name'] = 'Название сеанса';
$string['session_time'] = 'Время сеанса';
$string['return_to_sessions'] = 'Вернуться к сеансам';
$string['intellicart_student_integration'] = 'Интеграция с панелью инструментов учащегося';
$string['intellicart_instructor_integration'] = 'Интеграция с панелью инструментов инструктора';
$string['intellicart_app_reports_integration'] = 'Интеграция с отчетами IntelliBoard';
/* IntelliCart END */
$string['allmod'] = "Все элементы";
$string['customod'] = "Пользовательские элементы";
$string['timespent'] = "------ Затраченное время ----";
$string['inprogress'] = "Выполняется";
$string['notstarted'] = "Не начато";
$string['modulename'] = "Название элемента";
$string['viewed'] = "Просмотрено";
$string['course'] = "Курс";
$string['courseaverage'] = "Средняя оценка по курсу";
$string['mygrade'] = "Моя оценка";
$string['myprogress'] = "Моя успеваемость";
$string['instructor_course_shortname'] = "Показывать краткое название курса вместо полного";
$string['trackmedia'] = "Отслеживать медиа в формате HTML5";
$string['trackmedia_desc'] = "Отслеживать видео и аудио HTML5";
$string['ianalytics'] = 'IntelliBoard Аналитика';
$string['instructor_course_visibility'] = 'Показать скрытые/приостановленные курсы для [инструктора]';
$string['instructor_mode'] = 'Показать все курсы, доступные для [инструктора]';
$string['instructor_mode_access'] = 'Показать все курсы, доступные для [инструктора] с разрешениями [обновить]';
$string['student_course_visibility'] = 'Показать скрытые/приостановленные курсы для [учащегося]';
$string['support_text1'] = "Все ваши данные Moodle: простые, доступные, понятные и привлекательные. IntelliBoard - это плагин Moodle, который предоставляет вам в руки <strong> 120+ </strong> отчетов и мониторов.";
$string['support_text2'] = "Все ваши данные Moodle: простые, доступные, понятные и привлекательные. IntelliBoard - это ваше решение для отчетности и аналитики Moodle, предоставляющее вам более 120 отчетов и аналитических материалов, которые помогут вам принимать решения в сфере образования.";
$string['support_info1'] = "Вы можете присоединиться к нашим <a target='_blank' href='https://intelliboard.net/events'> вебинарам </a>, где мы познакомим вас с отчетами и аналитикой IntelliBoard!";
$string['support_info2'] = "Присоединяйтесь к нашим <a target='_blank' href='https://intelliboard.net/events'> вебинарам </a> или запланируйте персональный тур по своим собственным данным. С нашей поддержкой и обслуживанием мирового уровня, вы увидите свою LMS в совершенно новом свете.";
$string['support_terms'] = "Все права защищены.";
$string['support_page'] = "Просмотреть документацию";
$string['support_demo'] = "Запланировать демонстрацию";
$string['support_trial'] = "Подключиться и обновить";
$string['support_close'] = "Закрыть";
$string['instructor_custom_groups'] = "Пользовательские группы инструкторов";
// настройки таблиц
$string['table_set_icg'] = 'Курсы для инструкторов';
$string['table_set_icg_c1'] = 'Название курса';
$string['table_set_icg_c2'] = 'Краткое название';
$string['table_set_icg_c3'] = 'Категория';
$string['table_set_icg_c4'] = 'Зачисленные/завершившие учащиеся';
$string['table_set_icg_c5'] = 'Средняя оценка по курсу ';
$string['table_set_icg_c6'] = 'Разделы';
$string['table_set_icg_c7'] = 'Элементы/Ресурсы';
$string['table_set_icg_c8'] = 'Посещения';
$string['table_set_icg_c9'] = 'Затраченное время';
$string['table_set_icg_c11'] = 'Действия - Элементы ';
$string['table_set_icg_c12'] = 'Действия - Учащиеся';
$string['percentage_completed_learners'] = 'Процент завершивших учащихся';
$string['avg_visits_per_stud'] = 'Среднее количество посещений на учащегося';
$string['avg_time_spent_per_stud'] = 'Среднее время, затрачиваемое на одного учащегося';
$string['table_set_ilg'] = 'Курсы инструкторов > Учащиеся';
$string['table_set_ilg_c1'] = 'Имя учащегося';
$string['table_set_ilg_c2'] = 'Адрес электронной почты';
$string['table_set_ilg_c3'] = 'Зачислен';
$string['table_set_ilg_c4'] = 'Последний доступ';
$string['table_set_ilg_c5'] = 'Статус';
$string['table_set_ilg_c6'] = 'Оценка';
$string['table_set_ilg_c7'] = 'Завершенные элементы/ресурсы';
$string['table_set_ilg_c8'] = 'Посещения';
$string['table_set_ilg_c9'] = 'Затраченное время';
$string['table_set_ilg_c10'] = 'Действия';
$string['table_set_ilg1'] = 'Курсы инструктора > Учащиеся > Оценки';
$string['table_set_ilg1_c1'] = 'Название элемента';
$string['table_set_ilg1_c2'] = 'Тип';
$string['table_set_ilg1_c3'] = 'Оценка';
$string['table_set_ilg1_c4'] = 'Оценено';
$string['table_set_ilg1_c5'] = 'Статус';
$string['table_set_ilg1_c6'] = 'Посещения';
$string['table_set_ilg1_c7'] = 'Затраченное время';
$string['table_set_iag'] = 'Курсы инструктора > Элементы';
$string['table_set_iag_c1'] = 'Название элемента';
$string['table_set_iag_c2'] = 'Тип';
$string['table_set_iag_c3'] = 'Завершившие учащиеся';
$string['table_set_iag_c4'] = 'Средняя оценка';
$string['table_set_iag_c5'] = 'Посещения';
$string['table_set_iag_c6'] = 'Затраченное время';
$string['table_set_iag_c7'] = 'Действия';
$string['table_set_iag1'] = 'Курсы инструктора > Элементы > Оценки';
$string['table_set_iag1_c1'] = 'Имя учащегося';
$string['table_set_iag1_c2'] = 'Адрес электронной почты';
$string['table_set_iag1_c3'] = 'Статус';
$string['table_set_iag1_c4'] = 'Оценка';
$string['table_set_iag1_c5'] = 'Оценено';
$string['table_set_iag1_c6'] = 'Посещения';
$string['table_set_iag1_c7'] = 'Затраченное время';
$string['student_grades'] = 'Оценки учащихся';
$string['grid_view'] = 'Вид таблицы';
$string['list_view'] = 'Вид списка';
$string['grade_activities_overview'] = 'Обзор оцененных элементов';
$string['activity'] = 'Элемент';
$string['date_format'] = 'Формат даты';
$string['user_enrollments_sessions_completion'] = 'Зачисление пользователей, сеансы и завершение курсов';
$string['user_site_summary_detail'] = 'Данные использования платформы пользователем';
$string['course_enrollment_types'] = 'Типы зачисления на курсы';
$string['user_map'] = 'Карта пользователей';
$string['course_enrollments_with_completion_overview'] = 'Зачисление на курс с обзором завершения';
$string['all_modules'] = 'Все элементы';

/* Attendance */
$string['attendance'] = 'Посещаемость';
$string['enableattendance'] = 'Включить посещаемость';
$string['attendancetoolurl'] = 'URL-адрес инструмента';
$string['visitanceconsumerkey'] = 'Пользовательский ключ';
$string['tendancesharedsecret '] ='Секретный ключ';
$string['sync_data_with_attendance'] = 'Синхронизировать данные с посещаемостью';
$string['attendanceapibase'] = 'Путь API посещаемости';
$string['attendanceapikey'] = 'Ключ API посещаемости';
$string['attendanceapisecret'] = 'Секретный ключ API посещаемости';
$string['enableyncattendance'] = 'Включить синхронизацию сеансов BB Collaborate с InAttendance';
/* BlackBoard Collaborate и InAttendance */
$string['bb_col_meetings'] = 'Встречи BlackBoard Collaborate ';
$string['enable_bb_col_debug'] = 'Включить отладку BlackBoard Collaborate';
$string['bb_col_api_endpoint'] = 'Конечная точка API BlackBoard Collaborate';
$string['bb_col_consumer_key'] = 'Пользовательский ключ BlackBoard Collaborate';
$string['bb_col_secret'] = 'Секретный ключ BlackBoard Collaborate ';
$string['enable_bb_col_meetings'] = 'Включить встречи BlackBoard Collaborate';
$string['check_active_bb_col_meetings'] = 'Проверить активные встречи BlackBoard Collaborate';
$string['local_intelliboard_bb_collaborate_session_tracking_started'] = 'Started tracking of BB collaborate session';
$string['local_intelliboard_bb_collaborate_session_tracking_finished'] = 'Finished tracking of BB collaborate session';
$string['local_intelliboard_bb_collaborate_api_request_finished'] = 'Finished API request to BB collaborate';

/* Панель администратора */
$string['admin_dashboard'] = 'Панель администратора';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Зачисление пользователей, сеансы и завершение курсов';
$string['adm_dshb_adm_dashb_totals'] = 'Итоги';
$string['adm_dshb_user_site_summary_details'] = 'Данные использования платформы пользователем';
$string['adm_dshb_course_enrollments_types'] = 'Типы зачисления на курсы';
$string['adm_dshb_user_map'] = 'Карта пользователей';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Зачисление на курс с обзором завершения';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = 'Скрыть кнопку «Нужна помощь»';
$string['names_order'] = 'Порядок имен';
$string['firstname_lastname'] = '{Имя} {Фамилия}';
$string['lastname_firstname'] = '{Фамилия} {Имя}';
$string['issuer'] = 'Эмитент';
$string['criteria_method'] = 'Метод критериев';
$string['criterion_all_courses'] = 'Все следующие курсы должны быть завершены';
$string['criterion_any_course'] = 'Любой из следующих курсов должен быть завершен';
$string['dashboard_settings'] = 'Настройки панели инструментов';


$string['tracklogs'] = 'Отслеживать время по пользователю - ежедневно';
$string['trackdetails'] = 'Отслеживать время по пользователю - ежечасно';
$string['tracktotals'] = 'Общее время отслеживания - ежедневно';

$string['enable_badges_report'] = 'Включить отчет «Значки»';
$string['sizemode'] = 'Размер: большой (> 5000 пользователей)';
$string['cachedef_bb_collaborate_access_token'] = 'Маркер доступа BB Collaborate';


$string['learner_menu'] = 'Показывать «Панель инструментов учащегося» в меню блока навигации только для зарегистрированных учащихся';
$string['learning_plan_filter'] = 'Фильтр учебных планов';
$string['learning_plan_viewer_role'] = 'Роль "Наблюдателя за учебным планом"';
$string['all_cohorts'] = 'Все глобальные группы';
$string['privacy_shield_policy'] = 'Дополнение по обработке данных';
$string['privacy_policy'] = 'Политика конфиденциальности';
$string['confirm_and_sign_up'] = 'Подтвердить и зарегистрироваться';
$string['term_of_use'] = 'Условия использования';
$string['setup'] = 'Подключиться сейчас';
$string['protocol'] = 'Протокол';
$string['REST'] = 'REST';
$string['SOAP'] = 'SOAP';
$string['next'] = 'Далее';
$string['terms_msg'] = 'Устанавливая этот флажок, вы подтверждаете, что прочитали наши Условия использования и согласны с ними.';
$string['privacy_msg'] = 'Установив этот флажок, вы подтверждаете, что прочитали и согласны с нашей Политикой конфиденциальности.';
$string['shield_msg'] = 'Устанавливая этот флажок, вы подтверждаете, что прочитали и принимаете наше Дополнение по обработке данных.';
$string['enable_webservice'] = 'Включить веб-службы';
$string['you_need_to_enable_at_least_one_protocol'] = 'Вам необходимо включить хотя бы один протокол';
$string['invalid_user'] = 'Недействительный пользователь';
$string['sign_in'] = 'Войти';
$string['email'] = 'Электронная почта';
$string['password'] = 'Пароль';
$string['all_fields_required'] = 'Все поля обязательны';
$string['server_error'] = 'Произошла ошибка. Свяжитесь с нами по адресу support@intelliboard.net';
$string['country'] = 'Страна';
$string['please_accept_terms_and_conditions'] = 'Пожалуйста, примите положения и условия';
$string['congratulations_intb_register'] = 'Поздравляем';
$string['congratulations_intb_register_msg'] = 'Благодарим вас за начало использования 15-дневной бесплатной пробной версии IntelliBoard! Пожалуйста, проверьте свою электронную почту, чтобы подтвердить свою учетную запись IntelliBoard. Для начала используйте ссылку единого входа (SSO), если она активирована в разделе Администрирование > IntelliBoard, или войдите <a href="https://app.intelliboard.net/signin">здесь</a>. Ссылка SSO читается как «INTELLIBOARD.NET» и находится в правом верхнем углу панели управления. По вопросам обращайтесь на Support@IntelliBoard.net.';
$string['sign_up'] = 'Зарегистрироваться';
$string['sign_in'] = 'Войти';
$string['intelliboard_settings'] = 'Настройки IntelliBoard';
$string['moodle_settings'] = 'Настройки Moodle';
$string['email_is_required'] = 'Требуется адрес электронной почты';
$string['invalid_email'] = 'Неверный адрес электронной почты';
$string['intelliboard_terms'] = 'Соглашения IntelliBoard';
$string['authentication'] = 'Создание учетной записи';
$string['intb_settings_descr'] = "IntelliBoard требует одного основного уникального адреса электронной почты для подписки. Пожалуйста, введите ниже адрес электронной почты, который вы хотите использовать в качестве электронной почты для подписки. Перед использованием электронной почты необходимо дважды подтвердить электронное письмо с подтверждением. По вопросам, пожалуйста, обращайтесь на <a href='mailto: Support@IntelliBoard.net'>Support@IntelliBoard.net</a>. Для получения полного списка настроек IntelliBoard, перейдите на страницу Администрирование > Плагины > Локальные плагины > IntelliBoard";
$string['hosting_provider'] = 'Хостинг-провайдер';
$string['self_hosted'] = 'Самостоятельное размещение';

// форматы даты
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// новые строки
$string['report1_name'] = 'Статус пользователя';
$string['report2_name'] = 'Статистика курса';
$string['report3_name'] = 'Статистика элементов';
$string['report45_name'] = 'Активность на тестах';
$string['report_activity_stats_summary'] = 'Статистика элементов';
$string['report_user_profile_information'] = 'Информация профиля пользователей';
$string['course_name'] = 'Название курса';
$string['course_short_name'] = 'Краткое название курса';
$string['course_idnumber'] = 'ID курса';
$string['course_status'] = 'Статус';
$string['number_of_learners'] = 'Количество зачисленных пользователей';
$string['number_of_modules'] = 'Количество элеметов';
$string['number_of_completed_learners'] = 'Количество завершивших пользователей';
$string['number_of_visits'] = 'Посещение(я)';
$string['num_completed_activity'] = 'Количество пользователей, завершивших этот элемент';
$string['total_time_spent'] = 'Общее затраченное время';
$string['date_created'] = 'Дата создания';
$string['initial_reports'] = 'Первоначальные отчеты';
$string['avg_score'] = 'Средняя оценка';
$string['first_access'] = 'Первый доступ';
$string['completion_not_enabled'] = 'Завершение не разрешено';
$string['first_name'] = 'Имя';
$string['last_name'] = 'Фамилия';
$string['num_attempts'] = 'Количество попыток';
$string['high_grade'] = 'Самая высокая оценка';
$string['low_grade'] = 'Самая низкая оценка';
$string['initial_reports_warning'] = 'Чтобы отправить эти отчеты по электронной почте, запланировать и дополнительно настроить эти отчеты, нажмите «<a href="{$a}">Подключить и обновить</a>».';
$string['last_access'] = 'Последний доступ';
$string['enrolment_expiration'] = 'Истечение срока зачисления';
$string['id_number'] = 'ID';
$string['phone1'] = 'Телефон 1';
$string['phone2'] = 'Телефон 2';
$string['institution'] = 'Учреждение';
$string['department'] = 'Отдел';
$string['address'] = 'Адрес';
$string['city'] = 'Город';
$string['enroled_on'] = 'Дата зачисления';

$string['dashboard_link'] = 'Нажмите, чтобы просмотреть аналитику';
$string['support_connect'] = 'Нажмите кнопки отчета в прямоугольнике ниже. Узнайте о возможностях IntelliBoard: 1 кнопка для доступа к вашим аналитическим данным LMS. Хотите узнать  больше? Нажмите «Нажмите, чтобы просмотреть аналитику». Все еще хотите больше? <a href="{$a->connect_link}">«Подключиться и обновить»</a> в правом верхнем углу или в любом месте, где вы видите ссылку.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Нужна дополнительная информация? Нажмите любую из синих кнопок, чтобы связаться с нами.';

$string['web_services_descr'] = 'IntelliBoard рекомендует, чтобы были включены веб-службы. Веб-службы позволяют другим системам (например, IntelliBoard) получать доступ к этой системе LMS и выполнять операции с платформами. В целях безопасности их следует отключать, когда они не используются. Для дополнительного обзора перейдите в Администрирование > Расширенные возможности > Веб-службы';
$string['protocol_descr'] = 'IntelliBoard рекомендует, чтобы был включен протокол REST или SOAP. В целях безопасности должны быть включены только используемые протоколы. Для дополнительного обзора перейдите в Администрирование > Плагины > Веб-службы > Управление протоколами';
$string['authorized_user_descr'] = 'IntelliBoard требует наличия авторизованного пользователя. Авторизованный пользователь, скорее всего, будет администратором сайта и должен иметь права на управление веб-службами, протоколами и токенами. Для дополнительной проверки перейдите в Администрирование > Плагины > Веб-службы > Внешние службы > Служба IntelliBoard > Авторизованные пользователи';
$string['email_subscr'] = 'Электронная почта подписки';
$string['protocol_descr'] = 'Использование IntelliBoard требует, чтобы был включен протокол REST или SOAP. В целях безопасности должны быть включены только используемые протоколы. Для дополнительного обзора перейдите в Администрирование > Плагины > Веб-службы > Управление протоколами';
$string['enable_time_tracking'] = 'Включить отслеживание времени';
$string['enable_time_tracking_descr'] = 'Включите отслеживание времени для получения дополнительных сведений о доступе пользователей, посещениях и затраченном времени. IntelliBoard предоставляет дополнительную информацию об отслеживании времени отдельно от таблиц затраченного времени Moodle.';
$string['enable_sso'] = 'Включить ссылку для единого входа (SSO)';
$string['enable_sso_descr'] = 'Включить ссылку для единого входа для доступа в один клик для администраторов сайта к главному аккаунту IntelliBoard на app.IntelliBoard.net';
$string['join_a_webinar'] = 'Присоединиться к вебинару';
$string['review_support_doc'] = 'Просмотреть вспомогательную документацию';
$string['setup_subheading'] = 'Подключитесь, чтобы ощутить всю мощь ваших данных. Кредитная карта не требуется. Без обязательств. Целых 15 дней бесплатного использования данных.';

$string['instructor_courses_table_name'] = 'Оценки за курс';
$string['instructor_courses_table_name_learner'] = 'Курс {$a->course}, учащийся {$a->learner}, Оценки';
$string['instructor_courses_table_name_activity'] = 'Курс {$a->course}, Элемент {$a->name}, Оценки';
$string['instructor_courses_table_name_learners'] = 'Курс {$a->fullname}, Учащиеся';
$string['instructor_courses_table_name_activities'] = 'Курс {$a->fullname}, Элементы';

$string['successfull_connected'] = 'Успешно подключено';
$string['not_connected'] = 'Не подключен';

$string['transcripts'] = 'Transcripts';
$string['enable_transcripts'] = 'Включить Trancripts';
$string['closed'] = 'Закрыто';
$string['synctranscriptstask'] = 'Задача синхронизации Trancripts';
$string['transcriptssyncrecordsnum'] = 'Размер обработки Transcripts';
$string['transcriptssyncrecordsnum_desc'] = 'Количество записей о регистрации пользователей, которые будут обработаны за один раз';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Расшифровывает записи курсов';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'ID пользователя';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Электронная почта пользователя';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Имя пользователя';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Фамилия пользователя';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Расшифровывает ID зачисления пользователя';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'ID записи зачисления';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Метод зачисления';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'ID курса';
$string['privacy:metadata:local_intelliboard_trns_c:Coursename'] = 'Полное название курса';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Дата зачисления';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Дата отмены зачисления';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Дата завершения';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Статус Transcripts';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'ID предмета оценки';
$string['privacy:metadata:local_intelliboard_trns_c:Gradeid'] = 'ID Оценки';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'Максимальная оценка';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'Минимальная оценка';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Итоговая оценка';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Редактированная оценка';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Роли пользователей';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Группы пользователей';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Отметка времени при создании записи';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Отметка времени, когда запись была обновлена в последний раз';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Расшифровывает записи курсов';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Расшифровывает ID зачисления пользователя';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'ID курса';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'ID пользователя';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'ID элемента курса';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'ID элемента';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Название элемента';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Тип элемента';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Дата начала';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Дата завершения';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Статус';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'ID предмета оценки';
$string['privacy:metadata:local_intelliboard_trns_m:Gradeid'] = 'ID Оценки';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'Максимальная оценка';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'Минимальная оценка';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Итоговая оценка';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Редактированная оценка';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Отметка времени при создании записи';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Отметка времени, когда запись была обновлена в последний раз';
$string['goal_grade'] = 'Целевая оценка';
$string['importtrackingtask'] = 'Задача отслеживания импорта';
$string['compresstracking'] = 'Отслеживание сжатия';
$string['compresstracking_desc'] = 'Записывать данные отслеживания времени в файл или перезаписывать и передавать данные в базу данных с помощью cron job (по умолчанию: каждые 15 минут)';
$string['cachedef_instructor_course_data'] = 'Кеш для данных курса';
$string['cachedef_reports_list'] = 'Кеш для списка отчетов';
$string['do_not_use_compresstracking'] = 'Не использовать отслеживание сжатия';
$string['cache_compresstracking'] = 'Сохранить в кэш Moodle';
$string['file_compresstracking'] = 'Сохранить в MoodleData';
$string['cachedef_tracking'] = 'Данные отслеживания Intelliboard';
$string['cachedef_track_config'] = 'Общие данные отслеживания Intelliboard';
$string['coursecontainer_filter'] = 'Использовать фильтр для course container';
$string['enableexportcustomfont'] = 'Японский/китайский совместимый шрифт';
$string['all_selected'] = 'Все выбраны';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
