<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

$string['pluginname'] = 'IntelliBoard.net Eklenti';
$string['tracking_title'] = 'Zaman Takibi';
$string['tracking'] = 'Oturum Takibi';
$string['dashboard'] = 'Panel';
$string['settings'] = 'Ayarlar';
$string['adv_settings'] = 'Gelişmiş Ayarlar';
$string['intelliboardroot'] = 'IntelliBoard';
$string['intelliboard_reports'] = 'IntelliBoard Raporlar';
$string['report'] = 'Rapor';
$string['reports'] = 'Raporlar';
$string['learners'] = 'Öğrenenler';
$string['courses'] = 'Kurs';
$string['load'] = 'Verim';
$string['inactivity'] = 'Hareketsizlik';
$string['inactivity_desc'] = 'Kullanıcının hareketsizlik süresi (saniye cinsinden)';
$string['ajax'] = 'Sıklık';
$string['ajax_desc'] = 'AJAX aracılığıyla frekansı depolayan oturum. 0 - AJAX devre dışı (saniye cinsinden)';
$string['enabled'] = 'Takibi Etkinleştir';
$string['enabled_desc'] = 'Takibi Etkinleştir';
$string['trackadmin'] = 'İzleme Öneticileri';
$string['logs'] = 'Taşıma Aracı';
$string['trackadmin_desc'] = 'Yönetici Kullanıcılar için Zaman Takibini Etkinleştirin (önerilmez)';
$string['intelliboard:instructors'] = 'IntelliBoard [eğitmen]';
$string['intelliboard:students'] = 'IntelliBoard [öğrenci]';
$string['intelliboard:view'] = 'IntelliBoard [görünüm]';
$string['intelliboard:manage'] = 'IntelliBoard [yönet]';
$string['intelliboard:competency'] = 'IntelliBoard [yeterlik]';
$string['intelliboard:attendanceadmin'] = 'Katılım Yöneticisi';
$string['intelliboard:browseallcohorts'] = 'IntelliBoard [Tüm Gruplara Göz At]';
$string['tls12'] = 'TLS v1.2';
$string['tls12_desc'] = 'Gelişmiş ayarlar: TLS v1.2';
$string['sso'] = 'SSO bağlantısı';
$string['sso_desc'] = 'IntelliBoard.net için SSO Bağlantısı';
$string['ssomenu'] = 'SSO Menü Öğesi';
$string['ssomenu_desc'] = 'Tarayıcı Bloğu menüsünde SSO Bağlantısı (öğrenci / eğitmen olmayanlar için)';
$string['api'] = 'Alternatif API';
$string['api_desc'] = 'Alternatif API sunucusu kullanın (güvenlik duvarının engellenmesini önlemek için)';
$string['server'] = 'IntelliBoard Sunucu';
$string['server_usa'] = 'IntelliBoard Amerika';
$string['server_au'] = 'IntelliBoard Avustralya';
$string['server_eu'] = 'IntelliBoard Avrupa';
$string['show_dashboard_tab'] = 'Kontrol Paneli';
$string['filters'] = 'Panel Süzgeçleri';
$string['filter1'] = 'Kullanıcıları sil';
$string['filter2'] = 'Askıya alınan kullanıcılar';
$string['filter3'] = 'Misafir Kullanıcı';
$string['filter4'] = 'Kurs süzgeci';
$string['filter5'] = 'Kayıt yöntemi süzgeci';
$string['filter6'] = 'Kullanıcı kayıt süzgeci';
$string['filter7'] = 'Faaliyetler / Kaynaklar süzgeci';
$string['filter8'] = 'Kayıtlı kullanıcılar süzgeci';
$string['filter1_desc'] = 'Silinmiş kullanıcıları göster';
$string['filter2_desc'] = 'Askıya alınmış kullanıcıları göster';
$string['filter3_desc'] = 'Raporlarda [misafir] kullanıcıyı göster';
$string['filter4_desc'] = 'Görünmeyen kursları göster';
$string['filter5_desc'] = 'Etkin olmayan kayıt yöntemlerini göster';
$string['filter6_desc'] = 'Etkin kayıt durumu olmayan kullanıcıları göster';
$string['filter7_desc'] = 'Görünmeyen Faaliyetleri / Kaynakları Göster';
$string['filter8_desc'] = 'Yalnızca kayıtlı kullanıcıları göster (önerilmez)';
$string['intelliboardaccess'] = 'Bu sayfayı görme izniniz yok. Lütfen yardım için Yöneticinize başvurun.';
$string['tex1'] = 'IntelliBoard Öğrenci Gösterge Tablosu etkin değil.';
$string['account'] = 'Abonelik Bilgileri';
$string['te12'] = 'Ad';
$string['te13'] = 'Soyad';
$string['te1'] = 'eposta';
$string['te1_desc'] = 'IntelliBoard.net aboneliği için kullandığınız E-postayı girin. Etkin bir aboneliğiniz yoksa lütfen <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a> adresinden kaydolun. Öğrenci ve Eğitmen Kontrol Paneli, Seviye 4 ve üzeri abonelikle kullanılabilir.';
$string['n1'] = 'Genel Bakış [Öğrenci Gelişimi]';
$string['n2'] = 'Genel Bakış [Not Gelişimi]';
$string['n3'] = 'Genel Bakış [Etkinlik Gelişimi]';
$string['n12'] = 'Genel Bakış [Kurslara]';
$string['n4'] = 'Genel Bakış [Toplamlar]';
$string['n5'] = 'Mevcut Gelişim';
$string['n13'] = 'Toplam Öğrenci';
$string['n6'] = 'Widget: Korelasyonlar';
$string['n14'] = 'Widget: Öğrenci Katılımı';
$string['n18'] = 'Widget: Öğrenci Derecelendirme Gelişimi';
$string['n7'] = 'Widget: Etkinlik Katılımı';
$string['n15'] = 'Widget: Faaliyet Katılımı';
$string['n16'] = 'Widget: Konu Katılımı';
$string['n8'] = 'Kurslar Sayfası';
$string['n9'] = 'Raporlar Sayfası';
$string['n19'] = 'Raporlar için Kurs Gezinme Bağlantısı';
$string['n10'] = 'Eğitmen Paneli';
$string['n101'] = 'Eğitmen Panelini Etkinleştir';
$string['n11'] = 'Gezinti Bloğu menüsü için alternatif metin';
$string['ts1'] = 'Öğrenci Paneli';
$string['ts2'] = 'Öğrenci Paneli Sayfası';
$string['ts3'] = 'Öğrenci Paneli Kurslar';
$string['ts4'] = 'Öğrenci Paneli Dereceler';
$string['ts5'] = 'Öğrenci Paneli Raporlar';
$string['learner_tf_last_week'] = 'Zaman filtresi: 7 Gün';
$string['t01'] = 'Zaman  filtresi: Son 30 Gün';
$string['t02'] = 'Zaman  filtresi: Son 3 Ay';
$string['t03'] = 'Zaman  filtresi: Son 6 Ay';
$string['t04'] = '[başlık] Tamamlanmış kursları etkinleştir';
$string['t05'] = '[başlık] Devam eden Kursları etkinleştir';
$string['t06'] = '[başlık] Kurs ort. derecesini etkinleştir';
$string['t07'] = '[başlık] Mesajları Etkinleştir';
$string['t08'] = '[başlık] Toplam kurs derecelendirmesini etkinleştir';
$string['t09'] = 'Eğitmen kendi öğrencilerini görebilir';
$string['t1'] = 'Öğrenci Panelini Etkinleştir';
$string['t2'] = 'Paneli Etkinleştir';
$string['t3'] = 'Kursları Etkinleştir';
$string['t4'] = 'Derecelendirmeyi Etkinleştir';
$string['t48'] = 'Raporları Etkinleştir';
$string['t5'] = '[Aktivite ilerlemesi] grafiğini etkinleştir';
$string['t53'] = '[Aktivite ilerlemesi] grafik ortalama çizgisini etkinleştir';
$string['t6'] = '[Kurs ilerlemesi] grafiğini etkinleştir';
$string['t7'] = '[Kurs ortamam] etkinleştir';
$string['t8'] = '[Genel kurs ortalaması] etkinleştir';
$string['t9'] = '[Ödevler] widget etkinleştir';
$string['t10'] = '[Sınavlar] widget etkinleştir';
$string['t11'] = '[Kurs ilerlemesi] widget etkinleştir';
$string['t12'] = '[Aktivite katılımı] widget etkinleştir';
$string['t13'] = '[Öğrenme] widget etkinleştir';
$string['t14'] = '[Kurs başarısı] widget etkinleştir';
$string['t15'] = '[Korelayonlar] widget etkinleştir';
$string['t16'] = 'Kurs öğretmeni etkinleştir';
$string['t17'] = 'Kurs kategorisi etkinleştir';
$string['t18'] = 'Kurs tamamlama etkinleştir';
$string['t19'] = 'Kurs derecelendirme etkinleştir';
$string['t20'] = 'Kurs sınıf ortalaması etkinleştir';
$string['t21'] = 'Harcanan kurs süresi etkinleştir';
$string['t22'] = 'Kurs başlama tarihi etkinleştir';
$string['t23'] = 'Etkinleştir [Kurs başlama tarihi] sütunu etkinleştir';
$string['t24'] = 'Etkinleştir [Kayıt tarihi] sütunu';
$string['t25'] = 'Etkinleştir [İlerleme] sütunu';
$string['t26'] = 'Etkinleştir [Harf] sütunu';
$string['t27'] = 'Etkinleştir [Tamamlanmış Aktiviteler] sütunu';
$string['t28'] = 'Etkinleştir [Derecelendirme] sütunu';
$string['t29'] = 'Etkinleştir [Kurs tamamlanma durumu] sütunu';
$string['t30'] = 'Etkinleştir [Aktivite Derecelendirme] sütunu';
$string['t31'] = 'Etkinleştir [Ödevler][Derecelendirme] widget sütunu';
$string['t32'] = 'Etkinleştir [Ödevler][Bitiş Tarihi] widget sütunu';
$string['t33'] = 'Etkinleştir [Sınavlar][Derecelendirme] widget sütunu';
$string['t34'] = 'Etkinleştir [Sınavlar][Bitiş Tarihi] widget sütunu';
$string['t35'] = 'Etkinleştir [Kurs İlerleme][İlerleme] widget sütunu';
$string['t36'] = 'Etkinleştir [Kurs İlerleme][Derecelendirme] widget sütunu';
$string['t37'] = 'Etkinleştir [Kurs İlerleme][Kayıt] widget sütunu';
$string['t38'] = 'Etkinleştir [Kurs İlerleme][Tamamlanmış] widget sütunu';
$string['t52'] = 'Etkinleştir [Kurs İlerleme][Kategori] widget satırları';
$string['t39'] = 'Etkinleştir [İlerleme][Hedef Not] seçenek';
$string['t40'] = 'Etkinleştir [İlerleme][Sınıf ort.] seçenek';
$string['t41'] = 'Etkinleştir [Etkinlik Notları başlık] da Tamamlandı';
$string['t42'] = 'Etkinleştir [Etkinlik Notları başlık] Kursa son erişim';
$string['t43'] = 'Etkinleştir [Etkinlik Notları] Tür sütunu';
$string['t44'] = 'Etkinleştir [Etkinlik Notları] Not sütunu';
$string['t45'] = 'Etkinleştir [Etkinlik Notları] Notlanan sütunu';
$string['t46'] = 'Etkinleştir [Etkinlik Notları] Tamamlanan sütunu';
$string['t54'] = 'Etkinleştir [Etkinlik Notları] Harcanan zaman sütunu';
$string['t47'] = 'Kurslar [grid] arkaplan rengi';
$string['t49'] = 'Rapor süzme sütunları';
$string['t50'] = 'Öğretmen rolleri';
$string['t51'] = 'Öğrenci rolleri';
$string['current_grade'] = 'mevcut not';
$string['average_grade'] = 'aortalama not';
$string['type_here'] = 'Buraya yazın...';
$string['enrolled_date'] = 'Kayıt tarihi';
$string['teacher'] = 'Öğretmen';
$string['category'] = 'Kategori';
$string['current_grade'] = 'Mevcut not';
$string['completion'] = 'Tamamlama';
$string['class_average'] = 'Sınıf ortalaması';
$string['time_spent'] = 'Harcanan zaman';
$string['completed_on'] = '{$a} da Tamamlandı';
$string['passed_on'] = '{$a} da Tamamlandı(geçti)';
$string['failed_on'] = ' {$a} da Tamamlandı(kaldı)';
$string['last_access_on_course'] = 'Kursa son erişim: {$a}';
$string['you_have_certificates'] = '{$a} sertifikanız var';
$string['close'] = 'Kapat';
$string['view_course_details'] = 'Kurs detaylarını gör';
$string['incomplete'] = 'Tamamlanmamış';
$string['return_to_grades'] = 'Notlara geri dön';
$string['grade'] = 'Not';
$string['last_week'] = 'Son 7 Gün';
$string['last_month'] = 'Son 30 Gün';
$string['last_quarter'] = 'Son 3 Ay';
$string['last_semester'] = 'Son 6 Ay';
$string['all_time'] = 'Her zaman';
$string['activity_progress'] = 'Aktivite ilerlemesi';
$string['course_progress'] = 'Kurs ilerlrmrsi';
$string['my_course_average_all'] = 'kurs ortalamam (tüm kurslar)';
$string['overall_course_average'] = 'genel kurs ortalaması (tüm öğrenciler; tüm kurslar)';
$string['assignments'] = 'Ödevler';
$string['quizzes'] = 'Sınavlar';
$string['assignment_name'] = 'Ödev Adı';
$string['due_date'] = 'Bitiş tarihi';
$string['no_data'] = 'Veri yok';
$string['quiz_name'] = 'Sınav Adı';
$string['all_courses'] = 'Tüm Kurslar';
$string['time_period_due'] = 'Zaman aralığı (Bitiş Tarihi)';
$string['all_data'] = 'Tüm veri';
$string['progress'] = 'İlerleme';
$string['enrolled'] = 'Kayıtlı';
$string['completed'] = 'Tamamlanmış';
$string['activity_participation'] = 'Aktivite katılımı';
$string['learning'] = 'Öğrenme';
$string['course_success'] = 'Kurs başarısı';
$string['correlations'] = 'Korelasyonlar';
$string['course_start_date'] = 'Kurs başlama tarihi';
$string['letter'] = 'Harf';
$string['completed_activities'] = 'Tamamlanmış Aktiviteler';
$string['score'] = 'Not';
$string['course_completion_status'] = 'Kurs tamamlama dururmu';
$string['activity_grades'] = 'Aktivite Notları';
$string['completion_is_not_enabled'] = 'Bu kurs için tamamlama etkinleştirilmedi';
$string['activities'] = 'Aktiviteler';
$string['activity_name'] = 'Aktivite Adı';
$string['type'] = 'Tür';
$string['graded'] = 'Notlandırıldı';
$string['passed'] = 'Geçti';
$string['failed'] = 'Kaldı';
$string['completed_courses'] = 'Tamamlanmış kurslar';
$string['courses_in_progress'] = 'Devam eden kurslar';
$string['courses_avg_grade'] = 'Kursların ort. notu';
$string['courses_sum_grade'] = 'Not Ölçek Değerine göre kurs toplam notu';
$string['grades'] = 'Notlar';
$string['messages'] = 'Mesajlar';
$string['x_completions'] = '{$a} Tamamlama';
$string['completion_status'] = 'Tamamlama durumu';
$string['users_activity'] = 'Kullanıcı aktiviteleri';
$string['daily'] = 'Son 10 Gün';
$string['weekly'] = 'Son 90 Gün';
$string['monthly'] = 'Son 365 Gün';
$string['number_of_sessions'] = 'Oturum sayısı';
$string['number_today'] = '{$a} bugün';
$string['number_this_week'] = '{$a} bu hafta';
$string['course_completions'] = 'Kurs tamamlamaları';
$string['user_enrolments'] = 'Kullanıcı Kayıtları';
$string['users'] = 'Kullanıcılar';
$string['modules'] = 'Modüller';
$string['categories'] = 'Kategoriler';
$string['total'] = 'Toplam';
$string['users_overview'] = 'Kullanıcılara Genel Bakış';
$string['enable_time_and_visits_users_overview'] = "Kullanıcılara Genel Bakış'ta harcanan zamanı ve ziyaretleri etkinleştirin";
$string['disable_time_and_visits_users_overview'] = "Kullanıcılara Genel Bakış'ta harcanan zamanı ve ziyaretleri devre dışı bırakın";
$string['loading'] = 'Yükleniyor...';
$string['loading2'] = 'Lütfen bekleyin, yükleniyor...';
$string['enrollments'] = 'önkayıtlar';
$string['registrations'] = 'Kayıtlar';
$string['participation'] = 'Katılımcı';
$string['time'] = 'Zaman';
$string['enrolment_method'] = 'Önkayıt Yöntemi';
$string['intelliBoard_migration_tool'] = 'IntelliBoard Geçiş Aracı';
$string['importing_totals'] = 'Toplamları içe aktarma';
$string['total_numbers'] = 'Tarih: {$a->timepoint}, Oturum: {$a->sessions}, Ziyaretler: {$a->visits},  Harcanan zaman: {$a->timespend}';
$string['total_numbers2'] = 'KULLANICI: {$a->userid}, Sayfa: {$a->page}, Parametre:{$a->param}, Ziyaretler: {$a->visits},  Harcanan Zaman: {$a->timespend}';
$string['total_numbers3'] = '----Tarih: {$a->timecreated}, Takip Kimliği ID: {$a->trackid}, Ziyaretler: {$a->visits},  Harcanan Zaman: {$a->timespend}';
$string['logs_to_process'] = '{$a} işlenecek kayıt dosyaları';
$string['please_wait_or_cancel'] = 'Devam etmek için lütfen bekleyin veya <a href="{$a}">İptal Edin</a>';
$string['done'] = 'Tamamlandı!';
$string['return_to_home'] = 'Ana sayfaya dön';
$string['importing_logs'] = 'Kayıt dosyaları içe aktarılıyor';
$string['intelliBoard_migration_tool_info'] = "IntelliBoard geçiş aracı, Moodle kayıt dosyaları tablosundaki geçmiş verileri yeni biçime taşımak için kullanılır. Lütfen Moodle kayıt dosyalarını saklama prosedürünün değişmeyeceğini unutmayın. Geçmiş veriler yeni biçime taşındığında, \'Harcanan Zaman\' ve \'Ziyaretler\' gibi geçmiş değerler IntelliBoard.net'te önizleme için mevcut olacaktır.";
$string['moodle_logs'] = 'Moodle kayıt dosyaları';
$string['intelliboard_tracking'] = 'IntelliBoard izleme';
$string['intelliboard_logs'] = 'IntelliBoard kayıt dosyaları';
$string['intelliboard_totals'] = 'IntelliBoard toplamlar';
$string['intelliboard_start_tracking'] = 'IntelliBoard izleme başlat';
$string['total_values_include'] = 'Toplam Değerler, benzersiz oturumları, kursları, ziyaretleri, harcanan zamanı içerir.';
$string['items_per_query'] = 'Sorgu başına öğe';
$string['import'] = 'İçe aktar';
$string['log_values_include'] = 'Kayıt  dosyaları değerleri, her kullanıcı için günlük kayıtları içerir.';
$string['powered_by'] = '<a href="https://intelliboard.net/">IntelliBoard.net</a> tarafından desteklenmektedir.';
$string['intelliboardnet'] = 'IntelliBoard.net';
$string['visits'] = 'Ziyaretler';
$string['registered'] = 'Kaydedildi';
$string['disabled'] = 'Devre dışı';
$string['enrolled_completed'] = 'Kaydedildi: {$a->courses}, Tamamlandı: {$a->completed_courses}';
$string['enrolled_users_completed'] = 'Kayıtlı kullanıcılar: {$a->users}, Tamamlantı: {$a->completed}';
$string['user_grade_avg'] = '{$a->user} Not: {$a->grade}, Ortalama not: {$a->avg_grade_site})';
$string['user_visit_avg'] = '{$a->user} ziyaretler: {$a->visits}, Ortalama ziyaret: {$a->avg_visits_site}';
$string['user_time_avg'] = '{$a->user} harcanan zaman: {$a->timespend}, Ortalama Harcanan Zaman: {$a->avg_timespend_site}';
$string['more_users'] = 'Daha fazla kullanıcı';
$string['more_courses'] = 'Daha fazla kurs';
$string['showing_1_to_10'] = '1 den 10 a kadar gösteriliyor';
$string['course_grade'] = 'Kurs Notu';
$string['completed_activities_resourses'] = 'Tamamlanan Aktiviteler/Kaynaklar';
$string['save'] = 'Kaydet';
$string['help'] = 'Yardım?';
$string['in1'] = 'Genel Bakış';
$string['in2'] = 'Mevcut İlerleme';
$string['in3'] = 'Tüm Kurslar';
$string['in4'] = 'Tüm Öğrenciler';
$string['in5'] = 'Tüm Kurs Notları';
$string['in6'] = 'Tamamlayan Öğrenciler';
$string['in7'] = 'Tamamlamayan Öğrenciler';
$string['in8'] = 'Öğrenci Ortalam Notu';
$string['in9'] = 'Korelasyonlar';
$string['in10'] = 'Etkinlik Kullanımı';
$string['in11'] = 'Öğrenci İlerlemesi';
$string['in12'] = 'Not İlerlemesi';
$string['in13'] = 'Harcanan Zaman (%)';
$string['in14'] = '% İlerlendi';
$string['in15'] = 'Öğrenci Tamamlamaları';
$string['in16'] = 'Son Erişim';
$string['in17'] = 'Toplam Harcanan Zaman';
$string['in18'] = 'Toplam Ziyaret';
$string['in19'] = 'Ort. Not';
$string['in20'] = 'Öğrencilere Dön';
$string['in201'] = 'Aktivitelere Dön';
$string['in21'] = 'Kurs ort. notu';
$string['in22'] = 'Etkin';
$string['in23'] = 'Gösterilecek öğrenci yok.';
$string['in24'] = 'Modül';
$string['in25'] = 'Geçme Notu';
$string['in26'] = 'Öğrenci Katılımı';
$string['in34'] = 'Öğrenci Not İlerlemesi';
$string['in27'] = 'Toplam Öğrenci';
$string['in28'] = 'Ortalama Harcanan Zaman';
$string['in29'] = 'Aktif Öğrenciler';
$string['in30'] = 'Aktif Olmayan Öğrenciler';
$string['in31'] = 'Aktivite Kullanımı';
$string['in32'] = 'Seçilen dönem içinde Aktivite Kullanımı';
$string['in33'] = 'Konu Kullanımı';
$string['status'] = 'Durum';
$string['course_category'] = 'Kurs Kategorisi';
$string['course_started'] = 'Başlayan Kurs';
$string['total_time_spent_enrolled_learners'] = 'Kayıtlı Öğrencilerin Kursta Harcadığı Toplam Süre';
$string['total_visits_enrolled_learners'] = 'Kursa Kayıtlı Öğrencilerin Toplam Ziyareti';
$string['learners_enrolled'] = 'Önkayıtlı Öğrenciler';
$string['learners_enrolled_period'] = 'Seçilen dönem içinde önkayıtlı öğrenciler';
$string['learning_progress'] = 'Öğrenme İlerlemesi';
$string['sections'] = 'Bölümler';
$string['section'] = 'Bölüm';
$string['total_activities_resources'] = 'Toplam Aktiviteler/Kaynaklar';
$string['completions'] = 'Tamamlamalar';
$string['return_to_courses'] = 'Kurslara Dön';
$string['click_link_below_support_pages'] = 'IntelliBoard destek sayfalarına erişmek için aşağıdaki bağlantıya tıklayın:';
$string['support'] = 'Destek';
$string['course_name'] = 'Kurs Adı';
$string['enrolled_completed_learners'] = 'Önkayıtlı/Tamamlamış Öğrenciler';
$string['activities_resources'] = 'Aktiviteler/Kaynaklar';
$string['actions'] = 'Eylemler';
$string['learner_name'] = 'Öğrenci Adı';
$string['completed_activities_resources'] = 'Tamamlanmış Aktiviteler/Kaynaklar';
$string['filter_dates'] = 'Tarih süzmesi:';
$string['select_date'] = 'Tarih Seç';
$string['select'] = 'Seç';
$string['selectall'] = 'Tümünü Seç';
$string['ok'] = 'OK';
$string['moodle'] = 'Moodle';
$string['totara'] = 'Totara';
$string['monitors'] = 'Monitors';
$string['cohorts'] = 'Cohorts';
$string['course_overview'] = 'Kursa Genel Bakış';
$string['topics'] = 'Konular';
$string['a31'] = 'Frameworks';
$string['a32'] = 'Öğrenim Planları';
$string['a33'] = 'Değerlendirildi, Yeterli';
$string['a34'] = 'Değerlendirildi, Yetersiz';
$string['a35'] = 'Değerlendirilmedi';
$string['a36'] = 'Yetkinliklere Genel Bakış';
$string['a37'] = 'Bir yetkinlik oluşturulmamıştır. Lütfen Sistem Yöneticinize başvurun.';
$string['a38'] = 'Yetkinliklerle Bağlantılı Kurslar';
$string['a39'] = 'Yetkinlik Toplamları';
$string['a40'] = 'Bağlantılı Kurslar';
$string['no_competency'] = 'Görünüşe göre Moodle sitenizde yetkinlikler etkinleştirilmemiş.';
$string['scalesettings'] = 'Ölçek ayarları';
$string['scales'] = 'Özel ölçeği etkinleştir';
$string['scale_raw'] = 'Ölçeği devre dışı bırak';
$string['scale_real'] = 'Oran yerine gerçek notu göster';
$string['scale_total'] = 'Toplam Not';
$string['scale_value'] = 'Değer';
$string['scale_percentage'] = 'Oran';
$string['a0'] = 'Yetkinlik Kontrol Paneli';
$string['a1'] = 'Yetkinlik';
$string['a2'] = 'Uzmanlık';
$string['a3'] = 'Atanan Faaliyetler';
$string['a4'] = 'Yetkinlik İlerlemesi';
$string['a5'] = 'Derecelendirilmiş Yetkinlikler';
$string['a6'] = '# Kanıtlar';
$string['a7'] = 'Derecelendirilen Öğrenciler';
$string['a8'] = 'İlerleme';
$string['a9'] = 'Yetkin Öğrenciler';
$string['a10'] = 'Önkayıtlı Öğrenciler';
$string['a11'] = 'Kurslara atanan yetkinliklerin listesie';
$string['a12'] = 'Öğrenci Durumu';
$string['a13'] = 'Yetkinlik Adı';
$string['a14'] = 'Oluşturma Tarihi';
$string['a15'] = 'Atanma Tarihi';
$string['a16'] = 'Belirtilen Yetkinlik';
$string['a17'] = 'Değerlendirme';
$string['a18'] = 'Yetkinlikler Yeterli';
$string['a19'] = 'Yetkinlik Derecelendirme Tarihi';
$string['a20'] = 'Yetkinlik Değerlendiricisi';
$string['a21'] = 'Atatnan Faaliyetler';
$string['a22'] = 'Kazanılan Yetkinlik';
$string['a23'] = 'Derecelendirilen Yetkinlikler';
$string['a24'] = '# Kanıtlar';
$string['a25'] = 'Tamamlanan Öğrenciler';
$string['a27'] = ' dışında ';
$string['a28'] = 'Detaylar';
$string['a29'] = 'Yetkinlik Kontrol Panelini Etkinleştir';
$string['a30'] = 'Yetkinlik Raporlarını Etkinleştir';
$string['a26'] = 'Bu tablo, bir kursa atanan yetkinliklerin sayısını, derecelendirilen öğrencileri (yeterli olsun ya da olmasın) ve yetkinlik konusunda yetkin olarak belirlenen öğrenicileri gösterir.';
$string['s25'] = 'Aktivite için harcanan zaman';
$string['s45'] = 'Aktivite';
$string['s46'] = 'Deneyen öğrencilerin oranı';
$string['s47'] = 'Konu';
$string['s48'] = 'Konuya harcanan zaman';
$string['completions'] = 'Etkinlik tamamlama durumu';
$string['completions_completed'] = 'Tamamlanma durumu (tamamlandı)';
$string['completions_pass'] = 'Tamamlanma durumu (geçti))';
$string['completions_fail'] = 'Tamamlanma durumu (kaldı)';
$string['completions_desc'] = '1) Kullanıcı bu etkinliği tamamladı. Geçip geçmedikleri belirtilmemiştir. <br>
2) Kullanıcı bu aktiviteyi geçer notun üzerinde bir notla tamamlamıştır. <br>
3) Kullanıcı bu aktiviteyi tamamlamıştır ancak notu geçme notunun altındadır.';
$string['widget_name27'] = "Toplanan Kayıtlar";
$string['widget_name28'] = "Katılım";
$string['widget_name29'] = "Benzersiz Girişler";
$string['widget_name30'] = "Kursa Göre Önkayıtlar";
$string['widget_name31'] = "Registrars & Supervisor up take";
$string['role1'] = "Birinci Rol";
$string['role2'] = "İkinci Rol";
$string['select_course'] = "Kurs Seç";
$string['select_quiz'] = "Sınav Seç";
$string['not_quiz'] = "Hata, seçili kurs için oluşturulmuş herhangi bir testiniz yok gibi görünüyor.";
$string['enter_course_and_quiz'] = "Lütfen kursunuzu ve testinizi seçin.";
$string['enter_quiz'] = "Lütfen testinizi seçin.";
$string['analityc_3_name'] = "Sınava Genel Bakış ve Soru Detayı";
$string['course_name_a'] = 'Kurs: {$a}';
$string['quiz_name_a'] = 'Sınav: {$a}';
$string['cor_incor_answers'] = 'Doğru/Yanlış Yanıtlar';
$string['quiz_finished'] = 'Sınav bitti';
$string['quiz_grades'] = 'Sınav notları';
$string['correct_number'] = 'Doğru {$a}';
$string['incorrect_number'] = 'Yanlış {$a}';
$string['correct'] = 'Doğru';
$string['incorrect'] = 'Yanlış';
$string['weekday_0'] = "Pazartesi";
$string['weekday_1'] = "Salı";
$string['weekday_2'] = "Çarşamba";
$string['weekday_3'] = "Perşembe";
$string['weekday_4'] = "Cuma";
$string['weekday_5'] = "Cumartesi";
$string['weekday_6'] = "Pazar";
$string['time_1'] = "Sabah";
$string['time_2'] = "Öğleden sonra";
$string['time_3'] = "Akşam";
$string['time_4'] = "Kapalı Saatler";
$string['passing_score_for'] = '{$a} için Geçme notu';
$string['name'] = 'Ad';
$string['answers'] = 'Yanıtlar';
$string['ques_breakdown'] = 'Soru Dağılımı';
$string['n17'] = 'Analitik Sayfası';
$string['analytics'] = 'Analitik';
$string['pdf'] = 'PDF';
$string['csv'] = 'CSV';
$string['excel'] = 'Excel';
$string['grades_alt_text'] = 'Gezinme menüsü için alternatif metin';
$string['course_chart'] = 'Kurs grafiğini etkinleştir';
$string['course_activities'] = 'Kurs etkinliklerini etkinleştir';
$string['filter_this_year'] = 'Zaman süzgeci: Bu Yıl';
$string['filter_last_year'] = 'Zaman süzgeci: Geçen Yıl';
$string['filter_all_time'] = 'Zaman süzgeci: Her zaman';
$string['this_year'] = 'Bu Yıl';
$string['last_year'] = 'Geçen Yıl';
$string['reportselect'] = "Lütfen App.IntelliBoard.net'ten en az bir rapor seçin. Bir Rapor'a, ardından Rapor Ayarları'na tıklayın ve ”Moodle'da Görünür” seçeneğini seçin.";
$string['monitorselect'] = "Lütfen App.IntelliBoard.net'ten en az bir grafik seçin. Grafiğe, ardından Grafik Ayarlarına tıklayın ve ”Moodle'da Görünür” seçeneğini seçin.";
$string['select_user'] = 'Kullanıcı seç';
$string['course_max_grade'] = 'Kurs maksimum notu';
$string['no_data_notification'] = '[tarih] için yeni veri yok';
$string['last_hour'] = 'saat';
$string['last_day'] = 'gün';
$string['privacy:metadata:local_intelliboard_assign'] = 'Intelliboard assigns-subaccounts table';
$string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/logs/by-hour table';
$string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/logs/by-day table';
$string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/logs/total table';
$string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/logs/all-time table';
$string['privacy:metadata:local_intelliboard_reports'] = 'Intelliboard özel sql raporları tablosu';
$string['privacy:metadata:local_intelliboard_ntf'] = 'Intelliboard notifications main table';
$string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Intelliboard bildirimleri ana tablosu';
$string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Intelliboard bildirimleri dinamik parametreler tablosu';
$string['privacy:metadata:local_intelliboard_assign:userid'] = 'Kaydın KULLANICI Kimliği';
$string['privacy:metadata:local_intelliboard_assign:rel'] = 'Rel kayıt türü';
$string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodle Örnek Türü';
$string['privacy:metadata:local_intelliboard_assign:instance'] = 'Bağlı Moodle Örnek Kimliği';
$string['privacy:metadata:local_intelliboard_assign:timecreated'] = 'Kayıt Zaman Damgası';
$string['privacy:metadata:local_intelliboard_reports:status'] = 'Rapor durumu - etkinleştirildi/etkinleştirilmedi';
$string['privacy:metadata:local_intelliboard_reports:name'] = 'Özel raporun adı';
$string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64 şifrelenmiş SQL kodu';
$string['privacy:metadata:local_intelliboard_reports:timecreated'] = 'Oluşturma zamanı';
$string['privacy:metadata:local_intelliboard_details:logid'] = 'Tablo kimliği [local_intelliboard_logs]';
$string['privacy:metadata:local_intelliboard_details:visits'] = 'Günlük ziyaret, tıklama sayısı';
$string['privacy:metadata:local_intelliboard_details:timespend'] = 'Saat başına harcanan zaman miktarı';
$string['privacy:metadata:local_intelliboard_details:timepoint'] = 'Saat';
$string['privacy:metadata:local_intelliboard_logs:trackid'] = 'Tablonun kimliği [local_intelliboard_tracking]';
$string['privacy:metadata:local_intelliboard_logs:visits'] = 'Ziyaretler, tıklamalar, günlük';
$string['privacy:metadata:local_intelliboard_logs:timespend'] = 'Harcanan zaman, günlük';
$string['privacy:metadata:local_intelliboard_logs:timepoint'] = 'Yıl içinde günün zaman damgası';
$string['privacy:metadata:local_intelliboard_totals:sessions'] = "Moodle'daki Toplam Kullanıcı Oturumu Sayısı";
$string['privacy:metadata:local_intelliboard_totals:courses'] = "Moodle'daki Toplam Kurslar";
$string['privacy:metadata:local_intelliboard_totals:visits'] = "Moodle'daki Tüm Kullanıcıların Toplam Ziyareti";
$string['privacy:metadata:local_intelliboard_totals:timespend'] = "Moodle'da Harcanan Toplam Kullanıcı Süresi";
$string['privacy:metadata:local_intelliboard_totals:timepoint'] = 'Yıl içinde günün zaman damgası';
$string['privacy:metadata:local_intelliboard_tracking:userid'] = 'Moodle Sayfasını ziyaret eden kullanıcı kimliği.';
$string['privacy:metadata:local_intelliboard_tracking:courseid'] = 'Kullanıcının Ziyaret Ettiği Kurs Kimliği';
$string['privacy:metadata:local_intelliboard_tracking:page'] = 'Sayfa Türü [kurs,modül,profil,site]';
$string['privacy:metadata:local_intelliboard_tracking:param'] = 'Sayfa Kimliği Türü';
$string['privacy:metadata:local_intelliboard_tracking:visits'] = 'Bir Sayfadaki Kullanıcı Ziyaretleri';
$string['privacy:metadata:local_intelliboard_tracking:timespend'] = 'Kullanıcıların Bir Sayfada Harcadıkları Zaman';
$string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = 'Kullanıcılar İlk Erişim';
$string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = 'Kullanıcılar Son Erişim';
$string['privacy:metadata:local_intelliboard_tracking:useragent'] = 'Kullanıcı Tarayıcı Türü';
$string['privacy:metadata:local_intelliboard_tracking:useros'] = 'Kullanıcı İşletim Sistemi';
$string['privacy:metadata:local_intelliboard_tracking:userlang'] = 'Kullanıcı Tarayıcı Dili';
$string['privacy:metadata:local_intelliboard_tracking:userip'] = 'Kullanıcı son IP adresi';
$string['privacy:metadata:local_intelliboard_ntf:id'] = 'Bildirim Kimliği';
$string['privacy:metadata:local_intelliboard_ntf:type'] = 'Bildirim Türü';
$string['privacy:metadata:local_intelliboard_ntf:externalid'] = 'Bildirim Harici Kimliği';
$string['privacy:metadata:local_intelliboard_ntf:userid'] = 'Bildirim Harici Uygulama Kimliği';
$string['privacy:metadata:local_intelliboard_ntf:email'] = 'Bildirim ePosta';
$string['privacy:metadata:local_intelliboard_ntf:cc'] = 'Bildirim cc';
$string['privacy:metadata:local_intelliboard_ntf:subject'] = 'Bildirim konu';
$string['privacy:metadata:local_intelliboard_ntf:message'] = 'Bildirim mesaj';
$string['privacy:metadata:local_intelliboard_ntf:state'] = 'Bildirim durum';
$string['privacy:metadata:local_intelliboard_ntf:attachment'] = 'Bildirim eklentileri';
$string['privacy:metadata:local_intelliboard_ntf:tags'] = 'Bildirim etiketleri';
$string['privacy:metadata:local_intelliboard_ntf_hst:id'] = 'Bildirim geçmişi kimliği';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = 'Bildirim kimliği';
$string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = 'Bildirim Harici Uygulama Kimliği';
$string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = 'Bildirim adı';
$string['privacy:metadata:local_intelliboard_ntf_hst:email'] = 'Bildirim geçmişi e-postası';
$string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = 'Bildirim geçmişi zaman damgası';
$string['select_manager_role'] = 'Yönetici rolü seçin';
$string['group_aggregation'] = 'Grup toplama';
$string['ssodomain'] = 'Alt alan TOA';
$string['ssodomain_desc'] = 'Ayrılmış Sunucu/Hesap ile Tek Oturum Açma';
$string['instructor_redirect'] = 'Eğitmen yönlendirmesi';
$string['student_redirect'] = 'Öğrenci yönlendirmesi';
$string['myorders'] = 'Siparişler';
$string['myseats'] = 'Koltuklar';
$string['mywaitlist'] = 'Bekleme listesi';
$string['mysubscriptions'] = 'Abonelikler';
$string['seatscode'] = 'Koltuk kodu';
$string['numberofseats'] = 'Koltuk sayısı';
$string['downloadinvoice'] = 'Faturayı İndir';
$string['product'] = 'Ürün';
$string['key'] = 'Anahtar';
$string['created'] = 'Oluşturuldu';
$string['seatnumber'] = 'Koltuk Sayısı';
$string['seatsused'] = 'Koltuk Kullanılmış';
$string['details'] = 'Ayrıntılar';
$string['username'] = 'Kullanıcı adı';
$string['used'] = 'Kullanılmış';
$string['status'] = 'Durum';
$string['subscriptiondate'] = 'Abonelik tarihi';
$string['price'] = 'Fiyat';
$string['recurringperiod'] = 'Yinelenen dönem';
$string['billingcycles'] = 'Faturalandırma döngüleri';
$string['active'] = 'Aktif';
$string['suspended'] = 'Askıya alınmış';
$string['canceled'] = 'İptal edilmiş';
$string['expired'] = 'Süresi dolmuş';
$string['process'] = 'Süreç';
$string['cancel_subscription'] = 'Aboneliği iptal et';
$string['sqlreport'] = 'SQL rapor';
$string['sqlreportcreate'] = 'Rapor oluştur';
$string['sqlreports'] = 'SQL rapor';
$string['sqlreportname'] = 'Rapor adı';
$string['sqlreportcode'] = 'SQL';
$string['sqlreportdate'] = 'da oluşturldu';
$string['sqlreportactive'] = 'Aktif';
$string['sqlreportinactive'] = 'Devre dışı';
$string['remove_message'] = 'SQL rapor silindi';
$string['delete_message'] = 'SQL rapor silinsin mi?';
$string['success_message'] = 'SQL rapor kaydedildi';
$string['scale_percentage_round'] = 'Oran yuvarlama';
$string['instructor_show_suspended_enrollments'] = 'Askıya alınan kayıtları göster';
$string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
// BigBlueButton meetings
$string['bbbapiendpoint'] = 'BBB API uçnokta';
$string['bbbserversecret'] = 'BBB sunucu sırrı';
$string['check_active_meetings'] = 'Etkin toplantıları kontrol edin';
$string['bbbmeetings'] = 'BigBlueButton toplantıları';
$string['enablebbbmeetings'] = 'BigBlueButton toplantılarının izlenmesini etkinleştirin';
$string['enablebbbdebug'] = 'BigBlueButton hata ayıklama modu';
$string['privacy:metadata:local_intelliboard_bbb_meet'] = 'BigBlueButton toplantıları kayıt dosyası hakkında';
$string['privacy:metadata:local_intelliboard_bbb_meet:id'] = 'Toplantı kayıt dosyası kimliği';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = 'Toplantı adı';
$string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = 'Toplantı kimliği';
$string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = 'İçsel (BBB sunucusu) toplantı kimliği';
$string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = 'Zaman oluştur (zaman damgası)';
$string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = 'Tarih oluştur (dize)';
$string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = 'Ses bağlantısının dahili numarası (telefon sistemine bağlıysa kullanın)';
$string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = 'Katılımcıların normal telefon kullanarak arayabilecekleri çevirme erişim numarası.';
$string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = 'Katılımcıların toplantıya katılması için gerekli olacak parola';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = 'Moderatörlerin toplantıya katılması veya belirli idari işlemler için gerekli olacak parola';
$string['privacy:metadata:local_intelliboard_bbb_meet:running'] = 'Toplantı durumu (aktif|durdurlmuş)';
$string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = 'Toplantı süresi';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = 'Bayrak. Toplantıya katılan kullanıcılar';
$string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = 'Bayrak. Toplantı kaydedilecek';
$string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = 'Bayrak. Toplantı zorla sonlandırıldı';
$string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = 'Toplantının başlama zamanı';
$string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = 'Toplantının bitiş zamanı';
$string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = 'Katılımcı sayısı';
$string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = 'Dinyelici sayısı';
$string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = 'Mikrofonu bağlı katılımcı sayısı';
$string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = 'Kamerası bağlı katılımcı sayısı';
$string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = 'Maksimum katılımcı sayısı';
$string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = 'Moderatör sayısı';
$string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = 'Kurs Kimliği';
$string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = 'Kurs modülü kimliği';
$string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'bigbluebuttonbn tablosunda satıt kimliği';
$string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = 'Sahip Kimliği (toplantıyı oluşturan kullanıcı)';
$string['privacy:metadata:local_intelliboard_bbb_atten'] = 'BigBlueButton toplantılarının katılımcıları hakkında kayıt dosyası';
$string['privacy:metadata:local_intelliboard_bbb_atten:id'] = 'Katılımcı Kimliği';
$string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = 'Kullanıcı kimliği ("kullanıcı" tablosundaki satır)';
$string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = 'Toplantı katılımcısının tam adı';
$string['privacy:metadata:local_intelliboard_bbb_atten:role'] = 'Toplantı katılımcısının rolü';
$string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = 'Bayrak. Katılımcı sunum yapan kişidir';
$string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = 'Bayrak. Katılımcının bağlı mikrofonu veya web kamerası yok';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = 'Bayrak. Katılımcı mikrofon bağladı';
$string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = 'Bayrak. Katılımcının bağlı web kamerası var';
$string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = 'Toplantı Kimliği (BigBlueButton sunucusundaki kimlik)';
$string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = 'Toplantı Kimliği (local_intelliboard_bbb_meet tablosundaki kimlik)';
$string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = 'Kullanıcının toplantıya bağlandığı saat';
$string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = 'Kullanıcının toplantıyla bağlantısının kesildiği saat';
$string['messageprovider:intelliboard_notification'] = "Intelliboard bildirimi";
$string['privacy:metadata:local_intelliboard_bb_partic'] = 'İşbirliği oturumunun katılımcılarının listesi';
$string['privacy:metadata:local_intelliboard_bb_partic:id'] = 'Oturum katılımının kimliği';
$string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = 'Oturum UUID';
$string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = 'Kullanıcı UUID (BlackBoard Collaborate servisi)';
$string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = 'Kullanıcı kimliği (Moodle)';
$string['privacy:metadata:local_intelliboard_bb_partic:role'] = 'Oturum rolü';
$string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = 'Kullanıcı adı';
$string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = 'Oturuma ilk katılım';
$string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = 'Oturumdan son ayrılış';
$string['privacy:metadata:local_intelliboard_bb_partic:duration'] = 'Oturumda harcanan zaman';
$string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = 'Oturuma yeniden katılma sayısı';
$string['privacy:metadata:local_intelliboard_bb_trck_m'] = 'İzlenen oturumların listesi';
$string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = 'İzleme kayıt dosyasının kimliği';
$string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = 'Oturum UUID';
$string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = 'İzleme süresi';
$string['privacy:metadata:local_intelliboard_att_sync'] = 'Eşzamanlı oturumların listesi';
$string['privacy:metadata:local_intelliboard_att_sync:id'] = 'Eşitleme kayıt dosyası kimliği';
$string['privacy:metadata:local_intelliboard_att_sync:type'] = 'Oturum Türü';
$string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle oturum kimliği';
$string['privacy:metadata:local_intelliboard_att_sync:data'] = 'Ek eşleştirme verileri';
$string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
$string['verifypeer_desc'] = "Bu seçenek, curl'ün eşleştirilenlerin sertifikasının gerçekliğini doğrulayıp doğrulamayacağını belirler.";
$string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
$string['verifyhost_desc'] = "Bu seçenek, libcurl'un sunucu sertifikasının bilinen sunucu için olduğunu doğrulayıp doğrulamadığını belirler.";
$string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
$string['cipherlist_desc'] = "TLS için kullanılacak şifreleri belirtin";
$string['sslversion'] = "CURLOPT SSLVERSION";
$string['sslversion_desc'] = "SSL/TLS sürümlerinin hangi sürüm aralığının kullanılacağını kontrol etmek için parametre olarak uzun süre iletin";
$string['debug'] = "CURL isteklerinde hata ayıklama";
$string['debug_desc'] = "";
/* IntelliCart */
$string['intellicart'] = "IntelliCart entegrasyonu";
$string['intellicart_desc'] = "Öğrencilerin IntelliCart raporlarını görmelerine izin verin.";
$string['coursessessionspage'] = "Kurs oturumları sayfası";
$string['coursessessions'] = "Kurs oturumları";
$string['session_name'] = "Oturum adı";
$string['session_time'] = "Oturum zamanı";
$string['return_to_sessions'] = "Oturuma dön";
$string['intellicart_student_integration'] = 'Öğrenci Kontrol Paneli ile Entegrasyon';
$string['intellicart_instructor_integration'] = 'Eğitmen Panosu ile Entegrasyon';
$string['intellicart_app_reports_integration'] = 'IntelliBoard Raporları ile Entegrasyon';
/* IntelliCart END*/
$string['allmod'] = "Tüm aktiviteler";
$string['customod'] = "Özel aktiviteler";
$string['timespent'] = "------ Harcanan Zaman ----";
$string['inprogress'] = "Devam etmekte";
$string['notstarted'] = "Başlamadı";
$string['modulename'] = "Modül adı";
$string['viewed'] = "Görüntülendi";
$string['course'] = "Kurs";
$string['courseaverage'] = "Kurs Ortalaması";
$string['mygrade'] = "Notum";
$string['myprogress'] = "Not ilerlemem";
$string['instructor_course_shortname'] = "Kursun tam adı yerine kursun kısa adını göster";
$string['trackmedia'] = "HTML5 içeriğini izle";
$string['trackmedia_desc'] = "HTML5 video ve ses dosyası izle";
$string['ianalytics'] = 'IntelliBoard Analilik';
$string['instructor_course_visibility'] = '[eğitmen] için gizli/askıya alınmış kursları göster';
$string['instructor_mode'] = '[eğitmen]  için uygun olan tüm kursları göster';
$string['instructor_mode_access'] = '[eğitmen] için uygun olan tüm kursları [Güncelleme] izinleriyle göster';
$string['student_course_visibility'] = '[öğrenci] için gizli/askıya alınmış dersleri göster';
$string['support_text1'] = "Tüm Moodle verileriniz: kolay, paylaşılabilir, anlaşılabilir ve çekici. IntelliBoard <strong>120+</strong> rapor ve grafiği elinizin altında bulundurmanızı sağlayan bir Moodle eklentisidir.";
$string['support_text2'] = "Tüm Moodle verileriniz: kolay, paylaşılabilir, anlaşılabilir ve çekici. IntelliBoard, eğitim iş kararlarınızı bilgilendirmeye yardımcı olmak için, 120+ rapor ve analiz sağlayan, Moodle raporlama ve analitik çözümünüzdür.";
$string['support_info1'] = "Sizleri IntelliBoard 5.0 Raporlama ve Analitikleri ile ilgili bir tura çıkarabileceğimiz <a target='_blank' href='https://intelliboard.net/events'>Web Seminerlerimize</a> katılabilirsiniz!";
$string['support_info2'] = "Katılın <a target='_blank' href='C";
$string['support_terms'] = "Tüm hakları Saklıdır.";
$string['support_page'] = "Belgeleri Gözden Geçirin";
$string['support_demo'] = "Demo takvimi Planlayın";
$string['support_trial'] = "Bağlan & Yükselt";
$string['support_close'] = "Kapa";
$string['instructor_custom_groups'] = "Eğitmen özel grupları";
// settings of tables
$string['table_set_icg'] = 'Eğitmen Kursları';
$string['table_set_icg_c1'] = 'Kurs Adı';
$string['table_set_icg_c2'] = 'Kısa Ad';
$string['table_set_icg_c3'] = 'Kategori';
$string['table_set_icg_c4'] = 'Önkayıtlı/Tamamlanmış Öğrenciler';
$string['table_set_icg_c5'] = 'Kurs Ort. Notu';
$string['table_set_icg_c6'] = 'Bölümler';
$string['table_set_icg_c7'] = 'Faaliyetler/Kaynaklar';
$string['table_set_icg_c8'] = 'Ziyaretler';
$string['table_set_icg_c9'] = 'Harcanan zaman';
$string['table_set_icg_c11'] = 'Eylemler - Etkinlikler';
$string['table_set_icg_c12'] = 'Eylemler - Öğrenciler';
$string['percentage_completed_learners'] = 'Tamamlayan Öğrencilerin Oranı';
$string['avg_visits_per_stud'] = 'Öğrenci Başına Ortalama Ziyaret';
$string['avg_time_spent_per_stud'] = 'Öğrenci Başına Harcanan Ortalama Zaman';
$string['table_set_ilg'] = 'Eğitmen Kursları > Öğrenciler';
$string['table_set_ilg_c1'] = 'Öğrenci Adı';
$string['table_set_ilg_c2'] = 'E-posta adresi';
$string['table_set_ilg_c3'] = 'Önkayıtlı';
$string['table_set_ilg_c4'] = 'Son Erişim';
$string['table_set_ilg_c5'] = 'Durum';
$string['table_set_ilg_c6'] = 'Not';
$string['table_set_ilg_c7'] = 'Tamamlanmış Faaliyetler/Kaynaklar';
$string['table_set_ilg_c8'] = 'Ziyaretler';
$string['table_set_ilg_c9'] = 'Harcanan zaman';
$string['table_set_ilg_c10'] = 'Etlemler';
$string['table_set_ilg1'] = 'Eğitmen Kursları > Öğrenciler > Notlar';
$string['table_set_ilg1_c1'] = 'Etkinlik Adı';
$string['table_set_ilg1_c2'] = 'Tür';
$string['table_set_ilg1_c3'] = 'Not';
$string['table_set_ilg1_c4'] = 'Notlandırıldı';
$string['table_set_ilg1_c5'] = 'Durum';
$string['table_set_ilg1_c6'] = 'Ziyaretler';
$string['table_set_ilg1_c7'] = 'Harcanan Zaman';
$string['table_set_iag'] = 'Eğitmen Kursları > Etkinlikler';
$string['table_set_iag_c1'] = 'Etkinlik adı';
$string['table_set_iag_c2'] = 'Tür';
$string['table_set_iag_c3'] = 'Tamamlayan Öğrenciler';
$string['table_set_iag_c4'] = 'Ortalama Not';
$string['table_set_iag_c5'] = 'Ziyaretler';
$string['table_set_iag_c6'] = 'Harcanan Zaman';
$string['table_set_iag_c7'] = 'Eylemler';
$string['table_set_iag1'] = 'Eğitmen Kursları > Etkinlikler > Notlar';
$string['table_set_iag1_c1'] = 'Öğrenci adı';
$string['table_set_iag1_c2'] = 'E-posta adresi';
$string['table_set_iag1_c3'] = 'Durum';
$string['table_set_iag1_c4'] = 'Not';
$string['table_set_iag1_c5'] = 'Notlandırıldı';
$string['table_set_iag1_c6'] = 'Ziyaretler';
$string['table_set_iag1_c7'] = 'Harcanan Zaman';
$string['student_grades'] = 'Öğrenci notları';
$string['grid_view'] = 'Izgara görünümü';
$string['list_view'] = 'Liste görünümü';
$string['grade_activities_overview'] = 'Not Verilmiş Etkinliklere Genel Bakış';
$string['activity'] = 'Etkinlik';
$string['date_format'] = 'Tarih biçimi';
$string['user_enrollments_sessions_completion'] = 'Kullanıcı Kaydı, Oturum, Etkinliği Tamamlama Düzeyleri';
$string['user_site_summary_detail'] = 'Kullanıcı Sitesi Özet Detayı';
$string['course_enrollment_types'] = 'Kurs Kayıt Türleri';
$string['user_map'] = 'Kullanıcı Haritası';
$string['course_enrollments_with_completion_overview'] = 'Tamamlamaya Genel Bakış ile Ders Kayıtları';
$string['all_modules'] = 'Tüm modüller';

/* Attendance */
$string['attendance'] = 'Katılım';
$string['enableattendance'] = 'Katılımı etkinleştir';
$string['attendancetoolurl'] = 'Araç URL';
$string['attendanceconsumerkey'] = 'Müşteri anahtarı';
$string['attendancesharedsecret'] = 'Paylaşılmış sır';
$string['sync_data_with_attendance'] = 'Verileri katılımla eşzamanla';
$string['attendanceapibase'] = 'Katılımcı API temel yol';
$string['attendanceapikey'] = 'Katılım API anahtarı';
$string['attendanceapisecret'] = 'Katılım API sırrı';
$string['enablesyncattendance'] = 'InAttendance ile BB Collaborate oturumları eşzamanlamayı etkinleştirin';
/* BlackBoard Collaborate and InAttendance */
$string['bb_col_meetings'] = 'BlackBoard Collaborate toplantıları';
$string['enable_bb_col_debug'] = 'BlackBoard Collaborate hata ayıklamayı etkinleştir';
$string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API uç noktası';
$string['bb_col_consumer_key'] = 'BlackBoard Collaborate tüketici anahtarı';
$string['bb_col_secret'] = 'BlackBoard Collaborate sırrı';
$string['enable_bb_col_meetings'] = 'BlackBoard Collaborate toplantılarını etkinleştirin';
$string['check_active_bb_col_meetings'] = 'Etkin BlackBoard Collaborate toplantısını kontrol edin';

/* Admin dashboard */
$string['admin_dashboard'] = 'Yönetici kontrol paneli';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = 'Kullanıcı Kaydı, Oturum, Etkinliği Tamamlama Düzeyleri';
$string['adm_dshb_adm_dashb_totals'] = 'Toplamlar';
$string['adm_dshb_user_site_summary_details'] = 'Kullanıcı Sitesi Özet Detayı';
$string['adm_dshb_course_enrollments_types'] = 'Kurs Kayıt Türleri';
$string['adm_dshb_user_map'] = 'Kullanıcı Haritası';
$string['adm_dshb_user_enrol_with_compl_overview'] = 'Tamamlamaya Genel Bakış ile Ders Kayıtları';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = ' "Yardım ihtiyacı" butonunu gizle';
$string['names_order'] = 'Names order';
$string['firstname_lastname'] = '{Ad} {Soyad}';
$string['lastname_firstname'] = '{Soyad} {Ad}';
$string['issuer'] = 'Yayınlayan';
$string['criteria_method'] = 'Kriter yöntemi';
$string['criteria_all_courses'] = 'Aşağıdaki kursların tümü tamamlanmalıdır';
$string['criteria_any_course'] = 'Aşağıdaki kurslardan herhangi birinin tamamlanması gerekir';
$string['dashboard_settings'] = 'Kontrol Paneli ayarları';


$string['tracklogs'] = 'Kullanıcıya Göre İzleme Süresi - Günlük';
$string['trackdetails'] = 'Kullanıcıya Göre İzleme Süresi - Saatlik';
$string['tracktotals'] = 'İzleme Süresi Toplamı - Günlük';

$string['enable_badges_report'] = '"Rozetler" raporunu etkinleştir';
$string['sizemode'] = 'Boyut Modu: Büyük (> 5.000 Kullanıcı)';
$string['cachedef_bb_collaborate_access_token'] = 'BB collaborate erişim belirteci';


$string['learner_menu'] = 'Yalnızca kayıtlı öğrenciler için Gezinme Bloğu menüsünde "Öğrenci Kontrol Paneli"ni göster';
$string['learning_plan_filter'] = 'Öğrenme Planı Süzgeci';
$string['learning_plan_viewer_role'] = '"Öğrenme Planı Görüntüleyici" rolü';
$string['all_cohorts'] = 'Tüm gruplar';
$string['privacy_shield_policy'] = 'Veri İşleme Eki';
$string['privacy_policy'] = 'Gizlilik Politikası';
$string['confirm_and_sign_up'] = 'Onaylayın ve Kaydolun';
$string['term_of_use'] = 'Kullanım Şartları';
$string['setup'] = 'Şimdi Bağlan';
$string['protocol'] = 'Protocol';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = 'Sonraki';
$string['terms_msg'] = 'Bu kutuyu işaretleyerek Kullanım Koşullarımızı okuyup kabul ettiğinizi onaylıyorsunuz.';
$string['privacy_msg'] = 'Bu kutuyu işaretleyerek Gizlilik Politikamızı okuduğunuzu ve kabul ettiğinizi onaylıyorsunuz.';
$string['shield_msg'] = 'Bu kutuyu işaretleyerek, Veri İşleme Ek Sözleşmemizi okuyup kabul ettiğinizi onaylıyorsunuz.';
$string['enable_webservice'] = 'Web hizmetlerini etkinleştir';
$string['you_need_to_enable_at_least_one_protocol'] = 'En az bir protokolü etkinleştirmeniz gerekiyor';
$string['invalid_user'] = 'Geçersiz kullanıcı';
$string['sign_in'] = 'Oturum aç';
$string['email'] = 'E-posta';
$string['password'] = 'Şifre';
$string['all_fields_required'] = 'Tüm alanlar gerekli';
$string['server_error'] = 'Hata! Beklenmedik bir şey oldu. Lütfen support@intelliboard.net adresinden bizimle iletişime geçin.';
$string['country'] = 'Ülke';
$string['please_accept_terms_and_conditions'] = 'Lütfen şartlar ve koşulları kabul edin';
$string['congratulations_intb_register'] = 'Tebrikler';
$string['congratulations_intb_register_msg'] = "IntelliBoard ile 15 günlük ücretsiz denemenizi başlattığınız için teşekkür ederiz! IntelliBoard hesabınızı onaylamak için lütfen e-postanızı kontrol edin. Başlamak için, Site Yönetimi > IntelliBoard'dan veya etkinleştirildiyse Tek Oturum Açma (TOA) Bağlantısını kullanın <a href='https://app.intelliboard.net/signin'>buradan</a> oturum açın. SSO Bağlantısı ”INTELLIBOARD.NET” olarak okunur ve Gösterge Tablosunun sağ üst köşesindedir. Sorularınız için lütfen Support@IntelliBoard.net ile iletişime geçin.";
$string['sign_up'] = 'Kaydol';
$string['sign_in'] = 'Oturum aç';
$string['intelliboard_settings'] = 'IntelliBoard Ayarları';
$string['moodle_settings'] = 'Moodle Ayarları';
$string['email_is_required'] = 'E-posta gereklidir';
$string['invalid_email'] = 'Geçersiz e-posta';
$string['intelliboard_terms'] = 'IntelliBoard Sözleşmesi';
$string['authentication'] = 'Hesap Oluşturma';
$string['intb_settings_descr'] = "IntelliBoard, bir ana, benzersiz abonelik e-postası gerektirir. Lütfen abonelik e-postanız olarak kullanmak istediğiniz e-postayı aşağıya girin. E-posta, kullanımdan önce bir e-posta onayı ile iki kez doğrulanmalıdır. Sorularınız için lütfen <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a> ile iletişime geçin. IntelliBoard Ayarlarının tam listesi için Site Yönetimi > Eklentiler > Yerel Eklentiler > IntelliBoard bölümüne gidin.";
$string['hosting_provider'] = 'Barındırma Sağlayıcı';
$string['self_hosted'] = 'Kendi sunucuları';

// date formats
$string['mysqlweek'] = '%Y, hafta %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'çeyrek';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = 'Kullanıcı Durumu';
$string['report2_name'] = 'Kurs İstatistikleri';
$string['report3_name'] = 'Etkinlik İstatistikleri Özeti';
$string['report45_name'] = 'Sınav Etkinliği Detayı';
$string['report_activity_stats_summary'] = 'Etkinlik İstatistikleri Özeti';
$string['report_user_profile_information'] = 'Kullanıcı Profili Bilgileri';
$string['course_name'] = 'Kurs Adı';
$string['course_short_name'] = 'Kurs Kısa Adı';
$string['course_idnumber'] = 'Kimlik No';
$string['course_status'] = 'Durum';
$string['number_of_learners'] = '# Kayıtlı Kullanıcı(lar)';
$string['number_of_modules'] = '# Faaliyet(ler)';
$string['number_of_completed_learners'] = '# Tamamlanan Kullanıcı(lar)';
$string['number_of_visits'] = 'Visit(s)';
$string['num_completed_activity'] = '# bu Etkinliği Tamamlayan Kullanıcı Sayısı';
$string['total_time_spent'] = 'Harcanan Toplam Zaman';
$string['date_created'] = 'Tarih oluşturuldu';
$string['initial_reports'] = 'İlk Raporlar';
$string['avg_score'] = 'Not ortalaması';
$string['first_access'] = 'İlk Erişim';
$string['completion_not_enabled'] = 'Tamamlama Etkin Değil';
$string['first_name'] = 'Ad';
$string['last_name'] = 'Soyad';
$string['num_attempts'] = '# Deneme';
$string['highest_grade'] = 'En Yüksek Not';
$string['lowest_grade'] = 'En Düşük Not';
$string['initial_reports_warning'] = 'Bu raporları e-postayla göndermek, planlamak ve daha fazla kişiselleştirmek için ”<a href="{$a}">Bağlan ve Yükselt</a>”i tıklayın.';
$string['last_access'] = 'Son Erişim';
$string['enrolment_expiration'] = 'Kayıt Süresi Sonu';
$string['id_number'] = 'Kimlik No	';
$string['telephone1'] = 'Telefon 1';
$string['telephone2'] = 'Telefon 2';
$string['institution'] = 'Kuruluş';
$string['department'] = 'Birim';
$string['address'] = 'Adres';
$string['city'] = 'İlçe/İl';
$string['enroled_on'] = 'Önkayıt Tarihi';

$string['dashboard_link'] = 'Analitikleri görmek için tıklayın';
$string['support_connect'] = 'Aşağıdaki dikdörtgenin içindeki rapor düğmelerini tıklayın. IntelliBoard\'un gücüne bir göz atın: LMS içgörülerinize 1 düğme erişimi. Daha fazla istemek? ”Analytics\'i görüntülemek için tıklayın\'ı tıklayın. Hala daha fazlasını istiyor musun? Sağ üstte veya bağlantıyı gördüğünüz herhangi bir yerde ”<a href="{$a->connect_link}">Bağlan ve Yükselt</a>”.';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = 'Daha fazla bilgiye mi ihtiyacınız var? Bizimle bağlantı kurmak için mavi düğmelerden herhangi birine tıklayın.';

$string['web_services_descr'] = 'IntelliBoard, Web hizmetlerinin etkinleştirilmesini gerektirir. Web hizmetleri, diğer sistemlerin (örn. IntelliBoard) bu LMS sistemine erişmesini ve işlemleri gerçekleştirmesini sağlar. Güvenlik amacıyla, kullanılmadığında bu devre dışı bırakılmalıdır. Ek inceleme için Site Yönetimi > Gelişmiş özellikler > Web hizmetleri\'ne gidin.';
$string['protocol_descr'] = 'IntelliBoard, REST veya SOAP Protokolünün etkinleştirilmesini gerektirir. Güvenlik amacıyla, yalnızca kullanımda olan protokoller etkinleştirilmelidir. Ek inceleme için Site Yönetimi > Eklentiler > Web hizmetleri > Protokolleri yönet\'e gidin';
$string['authorized_user_descr'] = 'IntelliBoard, Yetkili bir kullanıcı gerektirir. Yetkili kullanıcı muhtemelen bir Site Yöneticisi olacaktır ve web hizmetlerini, protokolleri ve belirteçleri yönetme ayrıcalıklarına sahip olmalıdır. Ek inceleme için Site Yönetimi > Eklentiler > Web hizmetleri > Dış Hizmetler > IntelliBoard hizmeti > Yetkili kullanıcı\'ya gidin';
$string['email_subscr'] = 'Abonelik epostası';
$string['protocols_descr'] = 'IntelliBoard, REST veya SOAP Protokolünün etkinleştirilmesini gerektirir. Güvenlik amacıyla, yalnızca kullanımda olan protokoller etkinleştirilmelidir. Ek inceleme için Site Yönetimi > Eklentiler > Web hizmetleri > Protokolleri yönet\'e gidin';
$string['enable_time_tracking'] = 'Zaman İzlemeyi Etkinleştir';
$string['enable_time_tracking_descr'] = 'Kullanıcı erişimi, ziyaretler ve harcanan süre hakkında ek bilgiler için Zaman İzlemeyi etkinleştirin. IntelliBoard, Moodle harcanan zaman tablolarından ayrı olarak zaman takibi hakkında ek bilgiler sağlar.';
$string['enable_sso'] = 'Tek Şifre ile Giriş (SSO) Bağlantısını etkinleştir';
$string['enable_sso_descr'] = 'Site Yöneticileri için app.IntelliBoard.net\'te IntelliBoard SuperAdmin erişimine tek tıkla erişim  için Tekli Oturum Açma (SSO) Bağlantısını etkinleştirin';
$string['join_a_webinar'] = 'Web Seminerine katılın';
$string['review_support_doc'] = 'Destek Belgelerini İnceleyin';
$string['setup_subheading'] = 'Verilerinizin gücünü deneyimlemek için bağlanın. Kredi kartı yok. Mecburiyet yok. Sadece 15 gün ücretsiz veri keyfi.';

$string['instructor_courses_table_name'] = 'Kurs Notları';
$string['instructor_courses_table_name_learner'] = 'Kurs {$a->course}, Öğrenci {$a->learner}, Notlar';
$string['instructor_courses_table_name_activity'] = 'Kurs {$a->course}, Etkinlik {$a->name}, Notlar';
$string['instructor_courses_table_name_learners'] = 'Kurs {$a->fullname}, Öğrenciler';
$string['instructor_courses_table_name_activities'] = 'Kurs {$a->fullname}, Etkinlikler';

$string['successfull_connected'] = 'Başarıyla bağlandı';
$string['not_connected'] = 'Bağlı değil';

$string['transcripts'] = 'Transcripts';
$string['enable_transcripts'] = 'Transkriptleri Etkinleştir';
$string['closed'] = 'Kapalı';
$string['synctranscriptstask'] = 'Transkript Görevi eşleştirme';
$string['transcriptssyncrecordsnum'] = 'Transkript İşleme Boyutu';
$string['transcriptssyncrecordsnum_desc'] = 'Tek seferde işlenecek kullanıcı kayıt kayıtlarının sayısı';
$string['privacy:metadata:local_intelliboard_trns_c'] = 'Transkript kurs kayıtları';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = 'Kullanıcı Kimliği';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = 'Kullanıcı e-posta';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = 'Kullanıcı adı';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = 'Kullanıcı soyadı';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = 'Transkript kullanıcı kayıt kimliği';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = 'Önkayıt kayıt kimliği';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = 'Önkayıt yöntemi';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = 'Kurs Kimliği';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = 'Kurs tam adı';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = 'Önkayıt Tarihi';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = 'Kayıt Silme Tarihi';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = 'Tamamlanma Tarihi';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = 'Transkript Durumu';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = 'Not Öğesi Kimliği';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = 'Not Sınıf Kimliği';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = 'En yüksek Not';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = 'En düşük Not';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = 'Final Notu';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = 'Biçimlendirilmiş Not';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = 'Kullanıcı Rolleri';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = 'Kullanıcı Grupları';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = 'Kayıt oluşturulduğunda zaman damgası';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = 'Kaydın en son güncellendiği zaman damgası';
$string['privacy:metadata:local_intelliboard_trns_m'] = 'Transkript kursları kayıtları';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = 'Transkript kullanıcı kayıt kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = 'Kurs Kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = 'Kullanıcı Kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = 'Kurs Modülü Kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = 'Modül kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = 'Etkinlik adı';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = 'Modül Türü';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = 'Başlangıç tarihi';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = 'Tamamlama tarihi';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = 'Durum';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = 'Not Öğesi Kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = 'Not Sınıf Kimliği';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = 'En yüksek not';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = 'En düşük Not';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = 'Final notu';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = 'Formatted Grade';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = 'Kayıt oluşturulduğunda zaman damgası';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = 'Kaydın en son güncellendiği zaman damgası';
$string['goal_grade'] = 'Hedef Notu';
$string['importtrackingtask'] = 'İzleme Görevini İçe Aktar';
$string['compresstracking'] = 'Sıkıştırma İzleme';
$string['compresstracking_desc'] = 'Zaman İzleme verilerini dosyaya yazın veya yeniden düzenleyin ve verileri cron işi ile veritabanına aktarın (varsayılan: her 15 dakikada bir)';
$string['cachedef_instructor_course_data'] = 'Kurs verileri için önbellek';
$string['cachedef_reports_list'] = 'Rapor listesi için önbellek';
$string['do_not_use_compresstracking'] = 'Sıkıştırılmış İzlemeyi kullanmayın';
$string['cache_compresstracking'] = 'Moodle Cache e kaydedin';
$string['file_compresstracking'] = 'MoodleData ya kaydedin';
$string['cachedef_tracking'] = 'Intelliboard İzleme verileri';
$string['cachedef_track_config'] = 'Intelliboard İzleme toplam verileri';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = 'Japonca/Çin uyumlu yazı tipi';
$string['all_selected'] = 'Hepsi seçili';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
