<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

 $string['pluginname'] = 'IntelliBoard.net 报表外挂';
 $string['tracking_title'] = '时间追踪';
 $string['tracking'] = '联机追踪';
 $string['dashboard'] = '报表页眉页';
 $string['settings'] = '设定';
 $string['adv_settings'] = '进阶设定';
 $string['intelliboardroot'] = 'IntelliBoard';
 $string['intelliboard_reports'] = 'IntelliBoard 报表';
 $string['report'] = '报表';
 $string['reports'] = '报表';
 $string['learners'] = '学员';
 $string['courses'] = '课程';
 $string['load'] = '效能';
 $string['inactivity'] = '不活跃';
 $string['inactivity_desc'] = '用户不活跃的时间(以秒为单位)';
 $string['ajax'] = '频率';
 $string['ajax_desc'] = '透过AJAX储存联机次数。 0：停用AJAX(以秒为单位)';
 $string['enabled'] = '启用追踪';
 $string['enabled_desc'] = '启用追踪';
 $string['trackadmin'] = '追踪网站管理员';
 $string['logs'] = '迁移工具';
 $string['trackadmin_desc'] = '启用追踪网站管理员(不建议)';
 $string['intelliboard:instructors'] = 'IntelliBoard [教师]';
 $string['intelliboard:students'] = 'IntelliBoard [学员]';
 $string['intelliboard:view'] = 'IntelliBoard [查看]';
 $string['intelliboard:manage'] = 'IntelliBoard [管理]';
 $string['intelliboard:competency'] = 'IntelliBoard [职能]';
 $string['intelliboard:attendanceadmin'] = '出勤管理';
 $string['intelliboard:browseallcohorts'] = 'IntelliBoard [浏览所有班级群组]';
 $string['tls12'] = 'TLS v1.2';
 $string['tls12_desc'] = '进阶设定: TLS v1.2';
 $string['sso'] = 'SSO 连结';
 $string['sso_desc'] = 'SSO连结到IntelliBoard.net';
 $string['ssomenu'] = 'SSO选单项目';
 $string['ssomenu_desc'] = '在导览区块选单显示SSO链接 (对于非学员/非教师)';
 $string['api'] = '替代API';
 $string['api_desc'] = '使用替代的API服务器（以避免防火墙阻挡）';
 $string['server'] = 'IntelliBoard 服务器';
 $string['server_usa'] = 'IntelliBoard 美国';
 $string['server_au'] = 'IntelliBoard 澳洲';
 $string['server_eu'] = 'IntelliBoard 欧洲';
 $string['show_dashboard_tab'] = '仪表板页面';
 $string['filters'] = '仪表板过滤器';
 $string['filter1'] = '已删除的用户';
 $string['filter2'] = '已暂停的用户';
 $string['filter3'] = '访客';
 $string['filter4'] = '课程过滤器';
 $string['filter5'] = '选课方式过滤器';
 $string['filter6'] = '用户选课过滤器';
 $string['filter7'] = '学习活动/资源过滤器';
 $string['filter8'] = '选课用户过滤器';
 $string['filter1_desc'] = '显示已删除的用户';
 $string['filter2_desc'] = '显示已暂停的用户';
 $string['filter3_desc'] = '在报表中显示[访客]用户';
 $string['filter4_desc'] = '显示隐藏的课程';
 $string['filter5_desc'] = '显示不活耀的选课方式';
 $string['filter6_desc'] = '显示选课状态不活跃的用户';
 $string['filter7_desc'] = '显示隐藏的学习活动/资源';
 $string['filter8_desc'] = '仅显示已选课用户(不建议)';
 $string['intelliboardaccess'] = '您无权查看此页面。请联系您的网站管理员寻求协助。';
 $string['tex1'] = 'IntelliBoard 学员报表个人首页未启用。.';
 $string['account'] = '订阅信息';
 $string['te12'] = '名字';
 $string['te13'] = '姓氏';
 $string['te1'] = '电子邮件';
 $string['te1_desc'] = '输入在 IntelliBoard.net 上订阅的电子邮件信箱。如果您尚未订阅，请在 <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a> 中注册。学员和教师报表个人首页可在订阅了 4 级或更高等级的情况下使用。';
 $string['n1'] = '总览[学员进度]';
 $string['n2'] = '总览[成绩进度]';
 $string['n3'] = '总览[活动进度]';
 $string['n12'] = '总览[课程概况]';
 $string['n4'] = '总览[总计]';
 $string['n5'] = '目前进度';
 $string['n13'] = '学生总数';
 $string['n6'] = '工具：相关性';
 $string['n14'] = '工具：学员参与';
 $string['n18'] = '工具：学生成绩进度';
 $string['n7'] = '工具：事件使用率';
 $string['n15'] = '工具：学习活动使用率';
 $string['n16'] = '工具：学习单元使用率';
 $string['n8'] = '课程页面';
 $string['n9'] = '报表页面';
 $string['n19'] = '报表的课程导览链接';
 $string['n10'] = '课程管理报表';
 $string['n101'] = '启用课程管理报表';
 $string['n11'] = '导览区块选单的替换文字';
 $string['ts1'] = '我的学习报表';
 $string['ts2'] = '我的学习报表 页面';
 $string['ts3'] = '我的学习报表 课程';
 $string['ts4'] = '我的学习报表 成绩';
 $string['ts5'] = '我的学习报表 报告';
 $string['learner_tf_last_week'] = '时间筛选：7天内';
 $string['t01'] = '时间筛选：最近30天';
 $string['t02'] = '时间筛选：最近3个月';
 $string['t03'] = '时间筛选：最近6个月';
 $string['t04'] = '启用[标头]已完成的课程';
 $string['t05'] = '启用[标头]进行中的课程';
 $string['t06'] = '启用[标头]课程平均成绩';
 $string['t07'] = '启用[标头]讯息';
 $string['t08'] = '启用[标头]课程平均成绩';
 $string['t09'] = '教师可以看到自己的学生';
 $string['t1'] = '启用我的学习报表';
 $string['t2'] = '启用报表个人首页';
 $string['t3'] = '启用课程';
 $string['t4'] = '启用成绩';
 $string['t48'] = '启用报告';
 $string['t5'] = '启用[学习活动进度]图表';
 $string['t53'] = '启用[活动进度]图表平均线';
 $string['t6'] = '启用[课程进度]图表';
 $string['t7'] = '启用[我的课程平均]';
 $string['t8'] = '启用[总体课程平均]';
 $string['t9'] = '启用[作业]小工具';
 $string['t10'] = '启用[测验]小工具';
 $string['t11'] = '启用[课程进度]小工具';
 $string['t12'] = '启用[学习活动参与]小工具';
 $string['t13'] = '启用[学习]小工具';
 $string['t14'] = '启用[课程进度]小工具';
 $string['t15'] = '启用[相关性]小工具';
 $string['t16'] = '启用课程教师';
 $string['t17'] = '启用课程类别';
 $string['t18'] = '启用课程完成';
 $string['t19'] = '启用课程成绩';
 $string['t20'] = '启用课程班级平均';
 $string['t21'] = '启用课程花费时间';
 $string['t22'] = '启用课程开始日期';
 $string['t23'] = '启用[课程开始日期]字段';
 $string['t24'] = '启用[选课日期]字段';
 $string['t25'] = '启用[进度]字段';
 $string['t26'] = '启用[字母等级]字段';
 $string['t27'] = '启用[完成的学习活动]字段';
 $string['t28'] = '启用[成绩]字段';
 $string['t29'] = '启用[课程完成状态]字段';
 $string['t30'] = '启用[学习活动成绩]字段';
 $string['t31'] = '启用[作业][成绩]小工具字段';
 $string['t32'] = '启用[作业][截止日期]小工具字段';
 $string['t33'] = '启用[测验][成绩]小工具字段';
 $string['t34'] = '启用[测验][截止日期]小工具字段';
 $string['t35'] = '启用[课程进度][进度]小工具字段';
 $string['t36'] = '启用[课程进度][成绩]小工具字段';
 $string['t37'] = '启用[课程进度][已选课]小工具字段';
 $string['t38'] = '启用[课程进度][已完成]小工具字段';
 $string['t52'] = '启用[课程进度][课程类别]小工具行˙';
 $string['t39'] = '启用[进度][目标成绩]选项';
 $string['t40'] = '启用[进度][班级平均]选项';
 $string['t41'] = '启用[学习活动成绩标头]完成时间';
 $string['t42'] = '启用[学习活动成绩标头]最后进入课程时间';
 $string['t43'] = '启用[学习活动成绩]类型字段';
 $string['t44'] = '启用[学习活动成绩]成绩字段';
 $string['t45'] = '启用[学习活动成绩]已评分字段';
 $string['t46'] = '启用[学习活动成绩]已完成字段';
 $string['t54'] = '启用[学习活动成绩]花费时间字段';
 $string['t47'] = '课程[网格]背景颜色';
 $string['t49'] = '报告筛选栏';
 $string['t50'] = '教师角色';
 $string['t51'] = '学生角色';
 $string['current_grade'] = '目前成绩';
 $string['average_grade'] = '平均成绩';
 $string['type_here'] = '在此输入...';
 $string['enrolled_date'] = '选课日期';
 $string['teacher'] = '教师';
 $string['category'] = '课程类别';
 $string['current_grade'] = '目前成绩';
 $string['completion'] = '完成情况';
 $string['class_average'] = '班级平均';
 $string['time_spent'] = '花费时间';
 $string['completed_on'] = '完成时间{$a}';
 $string['passed_on'] = '完成时间(通过){$a}';
 $string['failed_on'] = '完成时间(未通过){$a}';
 $string['last_access_on_course'] = '最后进入课程时间：{$a}';
 $string['you_have_certificates'] = '您有{$a}张证书';
 $string['close'] = '关闭';
 $string['view_course_details'] = '浏览课程详情';
 $string['incomplete'] = '未完成';
 $string['return_to_grades'] = '返回成绩';
 $string['grade'] = '成绩';
 $string['last_week'] = '最近7天';
 $string['last_month'] = '最近30天';
 $string['last_quarter'] = '最近3个月';
 $string['last_semester'] = '最近6个月';
 $string['all_time'] = '所有时间';
 $string['activity_progress'] = '学习活动进度';
 $string['course_progress'] = '课程进度';
 $string['my_course_average_all'] = '我的课程平均(所有课程)';
 $string['overall_course_average'] = '整体课程平均(所有学员；所有课程)';
 $string['assignments'] = '作业';
 $string['quizzes'] = '测验';
 $string['assignment_name'] = '作业名称';
 $string['due_date'] = '截止日期';
 $string['no_data'] = '无可用资料';
 $string['quiz_name'] = '测验名称';
 $string['all_courses'] = '所有课程';
 $string['time_period_due'] = '时间期限(截止日期)';
 $string['all_data'] = '所有数据';
 $string['progress'] = '进度';
 $string['enrolled'] = '选课人数';
 $string['completed'] = '完成人数';
 $string['activity_participation'] = '活动参与情况';
 $string['learning'] = '学习';
 $string['course_success'] = '课程进度';
 $string['correlations'] = '相关性';
 $string['course_start_date'] = '课程开始日期';
 $string['letter'] = '字母等级';
 $string['completed_activities'] = '已完成的学习活动';
 $string['score'] = '成绩';
 $string['course_completion_status'] = '课程完成状态';
 $string['activity_grades'] = '学习活动成绩';
 $string['completion_is_not_enabled'] = '此课程未启用完成进度追踪';
 $string['activities'] = '学习活动';
 $string['activity_name'] = '学习活动名称';
 $string['type'] = '类型';
 $string['graded'] = '取得成绩时间';
 $string['passed'] = '通过';
 $string['failed'] = '失败';
 $string['completed_courses'] = '已完成的课程';
 $string['courses_in_progress'] = '进行中的课程';
 $string['courses_avg_grade'] = '课程平均成绩';
 $string['courses_sum_grade'] = '依成绩量尺计算的课程总成绩';
 $string['grades'] = '成绩';
 $string['messages'] = '讯息';
 $string['x_completions'] = '{$a}完成';
 $string['completion_status'] = '完成情况';
 $string['users_activity'] = '用户学习活动';
 $string['daily'] = '最近10天';
 $string['weekly'] = '最近90天';
 $string['monthly'] = '最近1年';
 $string['number_of_sessions'] = '访问次数';
 $string['number_today'] = '本日{$a}';
 $string['number_this_week'] = '本周{$a} ';
 $string['course_completions'] = '课程完成度';
 $string['user_enrolments'] = '用户选课';
 $string['users'] = '用户';
 $string['modules'] = '活动模块';
 $string['categories'] = '课程类别';
 $string['total'] = '总计';
 $string['users_overview'] = '用户概观';
 $string['enable_time_and_visits_users_overview'] = '在用户概观中启用花费和访问时间';
 $string['disable_time_and_visits_users_overview'] = '在用户概观中停用花费和访问时间';
 $string['loading'] = '载入中...';
 $string['loading2'] = '请稍候，正在载入中...';
 $string['enrollments'] = '选课方式';
 $string['registrations'] = '选课人数（以国家区分）';
 $string['participation'] = '课程参与度';
 $string['time'] = '时间';
 $string['enrolment_method'] = '选课方式';
 $string['intelliBoard_migration_tool'] = 'IntelliBoard 迁移工具';
 $string['importing_totals'] = '汇入总计';
 $string['total_numbers'] = '日期：{$a->timepoint}，联机数：{$a->sessions}，访问：{$a->visits}，花费时间：{$a->timespend}';
 $string['total_numbers2'] = '用户：{$a->userid}，页面：{$a->page}，参数：{$a->param}，访问：{$a->visits}，花费时间：{$a->timespend}';
 $string['total_numbers3'] = '----日期：{$a->timecreated}，追踪 ID：{$a->trackid}，访问：{$a->visits}，花费时间：{$a->timespend}';
 $string['logs_to_process'] = '日志处理{$a}';
 $string['please_wait_or_cancel'] = '请等待以继续或<a href="{$a}">取消</a>';
 $string['done'] = '完成！';
 $string['return_to_home'] = '返回首页';
 $string['importing_logs'] = '汇入纪录';
 $string['intelliBoard_migration_tool_info'] = 'IntelliBoard 迁移工具用于将Moodle日志中的历史数据迁移到新格式。请注意，Moodle 日志储存过程不会改变。一旦历史数据迁移到新格式，像「花费时间」和「访问」这样的历史数据将在 IntelliBoard.net 上提供预览。';
 $string['moodle_logs'] = 'Moodle 日志';
 $string['intelliboard_tracking'] = 'IntelliBoard 追踪';
 $string['intelliboard_logs'] = 'IntelliBoard 日志';
 $string['intelliboard_totals'] = 'IntelliBoard 总计';
 $string['intelliboard_start_tracking'] = 'IntelliBoard 开始追踪';
 $string['total_values_include'] = '所有数值包括单一联机数、课程、访问、和花费时间。';
 $string['items_per_query'] = '每个查询的项目数';
 $string['import'] = '汇入';
 $string['log_values_include'] = '日志值包括每个用户每天的日志';
 $string['powered_by'] = '由<a href="https://intelliboard.net/">IntelliBoard</a>提供技术支持';
 $string['intelliboardnet'] = 'IntelliBoard.net';
 $string['visits'] = '访问数';
 $string['registered'] = '已选课';
 $string['disabled'] = '停用';
 $string['enrolled_completed'] = '已选课: {$a->courses}，已完成：{$a->completed_courses}';
 $string['enrolled_users_completed'] = '已选课用户：{$a->users}，已完成：{$a->completed}';
 $string['user_grade_avg'] = '{$a->user} 成绩：{$a->grade}，平均成绩：{$a->avg_grade_site})';
 $string['user_visit_avg'] = '{$a->user} 访问数：{$a->visits}，平均访问数：{$a->avg_visits_site}';
 $string['user_time_avg'] = '{$a->user} 花费时间：{$a->timespend}，平均花费时间：{$a->avg_timespend_site}';
 $string['more_users'] = '更多用户';
 $string['more_courses'] = '更多课程';
 $string['showing_1_to_10'] = '显示 1 到 10';
 $string['course_grade'] = '课程成绩';
 $string['completed_activities_resourses'] = '已完成的学习活动/资源';
 $string['save'] = '储存';
 $string['help'] = '需要帮助？';
 $string['in1'] = '概述';
 $string['in2'] = '目前进度';
 $string['in3'] = '课程总数';
 $string['in4'] = '学员总数';
 $string['in5'] = '取得成绩学员数';
 $string['in6'] = '已完成的学员';
 $string['in7'] = '未完成的学员';
 $string['in8'] = '学员平均成绩';
 $string['in9'] = '相关性';
 $string['in10'] = '事件使用情况';
 $string['in11'] = '学员进度';
 $string['in12'] = '成绩进度';
 $string['in13'] = '花费时间(%)';
 $string['in14'] = '进度%';
 $string['in15'] = '学员完成度';
 $string['in16'] = '上次访问';
 $string['in17'] = '总花费时间';
 $string['in18'] = '总访问数';
 $string['in19'] = '平均成绩';
 $string['in20'] = '返回学员';
 $string['in201'] = '返回学习活动';
 $string['in21'] = '课程平均成绩';
 $string['in22'] = '启用';
 $string['in23'] = '您没有学员可以显示。';
 $string['in24'] = '模块';
 $string['in25'] = '及格成绩';
 $string['in26'] = '学员参与度';
 $string['in34'] = '学生成绩进度';
 $string['in27'] = '学生总数';
 $string['in28'] = '平均花费时间';
 $string['in29'] = '活跃的学生';
 $string['in30'] = '不活跃的学生';
 $string['in31'] = '学习活动使用率';
 $string['in32'] = '在选定时间内的平均时间';
 $string['in33'] = '单元主题使用率';
 $string['status'] = '状态';
 $string['course_category'] = '课程类别';
 $string['course_started'] = '已开始的课程';
 $string['total_time_spent_enrolled_learners'] = '选课学员在课程中的总花费时间';
 $string['total_visits_enrolled_learners'] = '选课学员在课程中的总访问量';
 $string['learners_enrolled'] = '已选课学员';
 $string['learners_enrolled_period'] = '在选定时间内的选课学员';
 $string['learning_progress'] = '学习进度';
 $string['sections'] = '单元数';
 $string['section'] = '单元';
 $string['total_activities_resources'] = '学习活动/资源总计';
 $string['completions'] = '完成情况';
 $string['return_to_courses'] = '返回课程';
 $string['click_link_below_support_pages'] = '点击下方连结来访问 IntelliBoard 支持与帮助页面：';
 $string['support'] = '支持与帮助';
 $string['course_name'] = '课程名称';
 $string['enrolled_completed_learners'] = '已选课/已完成的学员';
 $string['activities_resources'] = '学习活动/资源';
 $string['actions'] = '动作';
 $string['learner_name'] = '学员名称';
 $string['completed_activities_resources'] = '已完成的学习活动/资源';
 $string['filter_dates'] = '筛选日期：';
 $string['select_date'] = '选择日期';
 $string['select'] = '选择';
 $string['selectall'] = '选择全部';
 $string['ok'] = 'OK';
 $string['moodle'] = 'Moodle';
 $string['totara'] = 'Totara';
 $string['monitors'] = '图表分析';
 $string['cohorts'] = '校定班级群组';
 $string['course_overview'] = '课程概述';
 $string['topics'] = '单元主题';
 $string['a31'] = '职能架构';
 $string['a32'] = '学习计划';
 $string['a33'] = '熟练';
 $string['a34'] = '不熟练';
 $string['a35'] = '尚未评等';
 $string['a36'] = '职能概述';
 $string['a37'] = '尚未建立职能。 请联系您的系统管理员。';
 $string['a38'] = '与职能连结的课程';
 $string['a39'] = '职能总数';
 $string['a40'] = '连结课程';
 $string['no_competency'] = '看起来您没有在您的 Moodle 网站上启用职能。';
 $string['scalesettings'] = '职能量尺设定';
 $string['scales'] = '启用自定义职能量尺';
 $string['scale_raw'] = '停用职能量尺';
 $string['scale_real'] = '显示实际成绩而不是百分比';
 $string['scale_total'] = '总成绩';
 $string['scale_value'] = '数值';
 $string['scale_percentage'] = '百分比';
 $string['a0'] = '职能进度报表';
 $string['a1'] = '职能';
 $string['a2'] = '熟练度';
 $string['a3'] = '分配的学习活动';
 $string['a4'] = '熟练进度';
 $string['a5'] = '已评等职能';
 $string['a6'] = '职能证据';
 $string['a7'] = '已评等学员';
 $string['a8'] = '进度';
 $string['a9'] = '熟练的学员';
 $string['a10'] = '已登记学员';
 $string['a11'] = '已指配给课程的职能列表';
 $string['a12'] = '学员状态';
 $string['a13'] = '职能名称';
 $string['a14'] = '建立时间';
 $string['a15'] = '分配时间';
 $string['a16'] = '熟练度';
 $string['a17'] = '评等';
 $string['a18'] = '职能熟练';
 $string['a19'] = '职能评等日期';
 $string['a20'] = '职能评等者';
 $string['a21'] = '已分配的学习活动';
 $string['a22'] = '已获得熟练';
 $string['a23'] = '已评等职能';
 $string['a24'] = '证据';
 $string['a25'] = '已完成的学员';
 $string['a27'] = ' 之于 ';
 $string['a28'] = '详细内容';
 $string['a29'] = '启用职能进度报表';
 $string['a30'] = '启用职能报告';
 $string['a26'] = '此表格显示分配给课程的职能数量，已评分的学员（无论是否熟练）以及已被指定为职能熟练的学员。';
 $string['s25'] = '花费在学习活动上的时间';
 $string['s45'] = '学习活动';
 $string['s46'] = '尝试的学生百分比';
 $string['s47'] = '单元主题';
 $string['s48'] = '花费在单元主题上的时间';
 $string['completions'] = '学习活动完成状态';
 $string['completions_completed'] = '完成状态(已完成)';
 $string['completions_pass'] = '完成状态 (通过)';
 $string['completions_fail'] = '完成状态 (失败)';
 $string['completions_desc'] = '1) 用户已完成此学习活动。 没有说明他们是否通过或失败。<br>
 2) 用户已完成此学习活动，其成绩高于合格标准。<br>
 3) 用户已完成此学习活动，但其成绩低于合格标准。';
 $string['widget_name27'] = "累计注册人数";
 $string['widget_name28'] = "参与度";
 $string['widget_name29'] = "登入人数";
 $string['widget_name30'] = "各课程的选课学员";
 $string['widget_name31'] = "注册员及主管";
 $string['role1'] = "第一个角色";
 $string['role2'] = "第二个角色";
 $string['select_course'] = "选择课程";
 $string['select_quiz'] = "选择测验";
 $string['not_quiz'] = "哎呀，看来您所选的课程没有建立任何测验。";
 $string['enter_course_and_quiz'] = "请选择您的课程和测验。";
 $string['enter_quiz'] = "请选择您的测验。";
 $string['analityc_3_name'] = "测验概述 & 问题详细内容";
 $string['course_name_a'] = '课程：{$a}';
 $string['quiz_name_a'] = '测验：{$a}';
 $string['cor_incor_answers'] = '正确/错误的答案';
 $string['quiz_finished'] = '测验结束';
 $string['quiz_grades'] = '测验成绩';
 $string['correct_number'] = '正确{$a}';
 $string['incorrect_number'] = '不正确{$a}';
 $string['correct'] = '正确';
 $string['incorrect'] = '不正确';
 $string['weekday_0'] = "星期一";
 $string['weekday_1'] = "星期二";
 $string['weekday_2'] = "星期三";
 $string['weekday_3'] = "星期四";
 $string['weekday_4'] = "星期五";
 $string['weekday_5'] = "星期六";
 $string['weekday_6'] = "星期天";
 $string['time_1'] = "早上";
 $string['time_2'] = "下午";
 $string['time_3'] = "晚上";
 $string['time_4'] = "休息时间";
 $string['passing_score_for'] = '将及格分数给 {$a}';
 $string['name'] = '名称';
 $string['answers'] = '答案';
 $string['ques_breakdown'] = '问题分析';
 $string['n17'] = '分析页面';
 $string['analytics'] = '分析';
 $string['pdf'] = 'PDF';
 $string['csv'] = 'CSV';
 $string['excel'] = 'Excel';
 $string['grades_alt_text'] = '导览选单的替换文字';
 $string['course_chart'] = '启用课程图表';
 $string['course_activities'] = '启用课程活动';
 $string['filter_this_year'] = '时间筛选：今年';
 $string['filter_last_year'] = '时间筛选：去年';
 $string['filter_all_time'] = '时间筛选：所有时间';
 $string['this_year'] = '今年';
 $string['last_year'] = '去年';
 $string['reportselect'] = '请从 App.IntelliBoard.net 中选择至少一个报告。点选“报告”，然后再点选“个人化报告”，并在“在Moodle中可见”中选择它。';
 $string['monitorselect'] = '请从 App.IntelliBoard.net 中选择至少一个图表。 点选“图表分析”，然后再点选“个人化图表分析组”，并在“在Moodle中可见”中选择它。';
 $string['select_user'] = '选择用户';
 $string['course_max_grade'] = '课程最高成绩';
 $string['no_data_notification'] = '[日期]没有新数据';
 $string['last_hour'] = '小时';
 $string['last_day'] = '天';
 $string['privacy:metadata:local_intelliboard_assign'] = 'Intelliboard 分配子账户列表';
 $string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/日志/每小时列表';
 $string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/日志/每天列表';
 $string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/日志/总表';
 $string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/日志/所有时间列表';
 $string['privacy:metadata:local_intelliboard_reports'] = 'Intelliboard 自定义SQL报告列表';
 $string['privacy:metadata:local_intelliboard_ntf'] = 'Intelliboard 事件通知主表';
 $string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Intelliboard 事件通知历史记录表';
 $string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Intelliboard 事件通知动态参数表';
 $string['privacy:metadata:local_intelliboard_assign:userid'] = '记录的用户编号(ID)';
 $string['privacy:metadata:local_intelliboard_assign:rel'] = '记录类型';
 $string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodle实例类型';
 $string['privacy:metadata:local_intelliboard_assign:instance'] = '连接的Moodle实例ID';
 $string['privacy:metadata:local_intelliboard_assign:timecreated'] = '记录时间戳';
 $string['privacy:metadata:local_intelliboard_reports:status'] = '报告状态 - 已启用/未启用';
 $string['privacy:metadata:local_intelliboard_reports:name'] = '自定义报告名称';
 $string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64编码的SQL代码';
 $string['privacy:metadata:local_intelliboard_reports:timecreated'] = '创建时间';
 $string['privacy:metadata:local_intelliboard_details:logid'] = '数据表ID [local_intelliboard_logs]';
 $string['privacy:metadata:local_intelliboard_details:visits'] = '每天的访问次数，鼠标点击次数';
 $string['privacy:metadata:local_intelliboard_details:timespend'] = '每小时花费的时间';
 $string['privacy:metadata:local_intelliboard_details:timepoint'] = '小时';
 $string['privacy:metadata:local_intelliboard_logs:trackid'] = '数据表的ID [local_intelliboard_tracking]';
 $string['privacy:metadata:local_intelliboard_logs:visits'] = '每天的访问次数，鼠标点击次数';
 $string['privacy:metadata:local_intelliboard_logs:timespend'] = '每日的花费时间';
 $string['privacy:metadata:local_intelliboard_logs:timepoint'] = '一年中的一天的时间戳';
 $string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Moodle中用户的联机总数';
 $string['privacy:metadata:local_intelliboard_totals:courses'] = 'Moodle的所有课程';
 $string['privacy:metadata:local_intelliboard_totals:visits'] = 'Moodle中所有用户的总访问量';
 $string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Moodle中所有用户的总花费时间';
 $string['privacy:metadata:local_intelliboard_totals:timepoint'] = '一年中的一天的时间戳';
 $string['privacy:metadata:local_intelliboard_tracking:userid'] = '访问Moodle页面的用户编号(ID)。';
 $string['privacy:metadata:local_intelliboard_tracking:courseid'] = '用户访问的课程编号';
 $string['privacy:metadata:local_intelliboard_tracking:page'] = '页面类型 [course,module,profile,site]';
 $string['privacy:metadata:local_intelliboard_tracking:param'] = '页面编号类型';
 $string['privacy:metadata:local_intelliboard_tracking:visits'] = '用户访问页面';
 $string['privacy:metadata:local_intelliboard_tracking:timespend'] = '用户在页面上花费的时间';
 $string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = '用户首次访问时间';
 $string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = '用户最后访问时间';
 $string['privacy:metadata:local_intelliboard_tracking:useragent'] = '用户浏览器类型';
 $string['privacy:metadata:local_intelliboard_tracking:useros'] = '用户操作系统';
 $string['privacy:metadata:local_intelliboard_tracking:userlang'] = '用户使用的浏览器语系';
 $string['privacy:metadata:local_intelliboard_tracking:userip'] = '用户最后登录的IP地址';
 $string['privacy:metadata:local_intelliboard_ntf:id'] = '事件通知编号';
 $string['privacy:metadata:local_intelliboard_ntf:type'] = '事件通知类型';
 $string['privacy:metadata:local_intelliboard_ntf:externalid'] = '事件通知外部NID';
 $string['privacy:metadata:local_intelliboard_ntf:userid'] = '事件通知外部AppID';
 $string['privacy:metadata:local_intelliboard_ntf:email'] = '事件通知的电子邮件';
 $string['privacy:metadata:local_intelliboard_ntf:cc'] = '事件通知副本';
 $string['privacy:metadata:local_intelliboard_ntf:subject'] = '事件通知标题';
 $string['privacy:metadata:local_intelliboard_ntf:message'] = '事件通知内容';
 $string['privacy:metadata:local_intelliboard_ntf:state'] = '事件通知状态';
 $string['privacy:metadata:local_intelliboard_ntf:attachment'] = '事件通知附件';
 $string['privacy:metadata:local_intelliboard_ntf:tags'] = '事件通知标记';
 $string['privacy:metadata:local_intelliboard_ntf_hst:id'] = '事件通知历史纪录编号';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = '事件通知编号';
 $string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = '事件通知外部AppID';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = '事件通知名称';
 $string['privacy:metadata:local_intelliboard_ntf_hst:email'] = '事件通知历史邮件';
 $string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = '事件通知历史时间';
 $string['select_manager_role'] = '选择管理员角色';
 $string['group_aggregation'] = '群组聚合';
 $string['ssodomain'] = '子域 SSO';
 $string['ssodomain_desc'] = '使用分开的服务器/账户进行单一登录';
 $string['instructor_redirect'] = '教师重新导向';
 $string['student_redirect'] = '学生重新导向';
 $string['myorders'] = '订单';
 $string['myseats'] = '授权';
 $string['mywaitlist'] = '等候名单';
 $string['mysubscriptions'] = '订阅';
 $string['seatscode'] = '授权代码';
 $string['numberofseats'] = '授权数';
 $string['downloadinvoice'] = '下载发票';
 $string['product'] = '产品';
 $string['key'] = 'Key';
 $string['created'] = '建立时间';
 $string['seatnumber'] = '授权数量';
 $string['seatsused'] = '已用户许可证';
 $string['details'] = '详细内容';
 $string['username'] = '账号';
 $string['used'] = '已使用';
 $string['status'] = '状态';
 $string['subscriptiondate'] = '订阅日期';
 $string['price'] = '价格';
 $string['recurringperiod'] = '重复周期';
 $string['billingcycles'] = '账单周期';
 $string['active'] = '启用';
 $string['suspended'] = '已暂停';
 $string['canceled'] = '取消';
 $string['expired'] = '已过期';
 $string['process'] = '过程';
 $string['cancel_subscription'] = '取消订阅';
 $string['sqlreport'] = 'SQL报告';
 $string['sqlreportcreate'] = '建立报告';
 $string['sqlreports'] = 'SQL报告';
 $string['sqlreportname'] = '报表名称';
 $string['sqlreportcode'] = 'SQL';
 $string['sqlreportdate'] = '建立时间';
 $string['sqlreportactive'] = '已启用';
 $string['sqlreportinactive'] = '已停用';
 $string['remove_message'] = 'SQL报告已被删除';
 $string['delete_message'] = '确定要删除SQL报告？';
 $string['success_message'] = 'SQL报告已经保存';
 $string['scale_percentage_round'] = '百分比四舍五入';
 $string['instructor_show_suspended_enrollments'] = '显示已暂停的选课';
 $string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
 // BigBlueButton meetings
 $string['bbbapiendpoint'] = 'BBB API端点';
 $string['bbbserversecret'] = 'BBB 服务器密钥';
 $string['check_active_meetings'] = '查看进行中的会议';
 $string['bbbmeetings'] = 'BigBlueButton会议';
 $string['enablebbbmeetings'] = '启用监看BigBlueButton会议';
 $string['enablebbbdebug'] = 'BigBlueButton 除错模式';
 $string['privacy:metadata:local_intelliboard_bbb_meet'] = 'BigBlueButton会议日志';
 $string['privacy:metadata:local_intelliboard_bbb_meet:id'] = '会议日志编号';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = '会议名称';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = '会议编号';
 $string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = '内部（在BBB服务器中）会议编号';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = '创建时间 (时间戳)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = '创建日期 (字符串)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = '语音桥接的分机号（连接到电话系统时使用）';
 $string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = '参与者可以使用普通电话拨打的拨号接入号码。';
 $string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = '参与者加入会议所需的密码';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = '主持人加入会议或进行某些管理操作所需的密码';
 $string['privacy:metadata:local_intelliboard_bbb_meet:running'] = '会议状态 (进行中|已停止)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = '会议时间';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = '旗标。加入会议的用户';
 $string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = '旗标。会议将被记录';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = '旗标。会议被强制结束';
 $string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = '会议开始时间';
 $string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = '会议结束时间';
 $string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = '参加人数';
 $string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = '听众人数';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = '有连接麦克风的参与者人数';
 $string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = '有连接摄影机的参与者人数';
 $string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = '参加人数上限';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = '主持人人数';
 $string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = '课程编号';
 $string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = '课程模块编号';
 $string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'BigBlueButtonbn数据表的ID';
 $string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = '拥有者编号（创建会议的用户）';
 $string['privacy:metadata:local_intelliboard_bbb_atten'] = '记录BigBlueButton会议的参与者';
 $string['privacy:metadata:local_intelliboard_bbb_atten:id'] = '出席者ID';
 $string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = '用户ID (User数据表的ID)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = '参与会议人员的全名';
 $string['privacy:metadata:local_intelliboard_bbb_atten:role'] = '会议参与者的角色';
 $string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = '旗标。参与者为主持人';
 $string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = '旗标。没有连接麦克风或网络摄影机的参与人员';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = '旗标。 已连接麦克风的参与人员';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = '旗标。已连接网络摄影机的参与人员';
 $string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = '会议编号 (BigBlueButton服务器中的编号)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = '会议编号 (在local_intelliboard_bbb_meet数据表中的编号)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = '用户连接会议的时间';
 $string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = '用户断开会议的时间';
 $string['messageprovider:intelliboard_notification'] = "Intelliboard 事件通知";
 $string['privacy:metadata:local_intelliboard_bb_partic'] = '协作课程参与者名单';
 $string['privacy:metadata:local_intelliboard_bb_partic:id'] = '参与课程的ID';
 $string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = '课程UUID';
 $string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = '用户UUID (BlackBoard协作服务)';
 $string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = '用户ID (Moodle)';
 $string['privacy:metadata:local_intelliboard_bb_partic:role'] = '课程角色';
 $string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = '用户名称';
 $string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = '首次参加课程时间';
 $string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = '最后离开课程时间';
 $string['privacy:metadata:local_intelliboard_bb_partic:duration'] = '课程花费时间';
 $string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = '重新加入课程的次数';
 $string['privacy:metadata:local_intelliboard_bb_trck_m'] = '追踪的课程清单';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = '追踪日志ID';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = '课程 UUID';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = '追踪时间';
 $string['privacy:metadata:local_intelliboard_att_sync'] = '已同步的课程清单';
 $string['privacy:metadata:local_intelliboard_att_sync:id'] = '同步日志ID';
 $string['privacy:metadata:local_intelliboard_att_sync:type'] = '课程';
 $string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle联机ID';
 $string['privacy:metadata:local_intelliboard_att_sync:data'] = '额外的同步数据';
 $string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
 $string['verifypeer_desc'] = "此选项判断curl是否验证对等方证书的真实性。";
 $string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
 $string['verifyhost_desc'] = "此选项判断libcurl是否验证服务器证书是为它所知道的服务器准备的。";
 $string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
 $string['cipherlist_desc'] = "指定TLS使用的密码";
 $string['sslversion'] = "CURLOPT SSLVERSION";
 $string['sslversion_desc'] = "传递long参数来控制要使用的SSL/TLS版本版本范围";
 $string['debug'] = "CURL 请求除错";
 $string['debug_desc'] = "";
 /* IntelliCart */
 $string['intellicart'] = "IntelliCart整合";
 $string['intellicart_desc'] = "允许学生查看IntelliCart报告。";
 $string['coursessessionspage'] = "课程时段页面";
 $string['coursessessions'] = "课程时段";
 $string['session_name'] = "课程时段名称";
 $string['session_time'] = "课程时段时间";
 $string['return_to_sessions'] = "返回课程时段";
 $string['intellicart_student_integration'] = '与我的学习报表整合';
 $string['intellicart_instructor_integration'] = '与课程管理报表整合';
 $string['intellicart_app_reports_integration'] = '与IntelliBoard报告整合';
 /* IntelliCart END*/
 $string['allmod'] = "所有学习活动";
 $string['customod'] = "自定义学习活动";
 $string['timespent'] = "------ 花费时间 ----";
 $string['inprogress'] = "进行中";
 $string['notstarted'] = "尚未开始";
 $string['modulename'] = "模块名称";
 $string['viewed'] = "已浏览";
 $string['course'] = "课程名称";
 $string['courseaverage'] = "课程平均";
 $string['mygrade'] = "我的成绩";
 $string['myprogress'] = "我的成绩进展";
 $string['instructor_course_shortname'] = "显示课程简称而不是课程全名";
 $string['trackmedia'] = "追踪HTML5媒体";
 $string['trackmedia_desc'] = "追踪HTML5影片和音讯";
 $string['ianalytics'] = 'IntelliBoard分析';
 $string['instructor_course_visibility'] = '显示[教师]隐藏/暂停的课程';
 $string['instructor_mode'] = '显示[教师]所有可用的课程';
 $string['instructor_mode_access'] = '显示[教师]有[更新]权限的所有可用课程';
 $string['student_course_visibility'] = '显示[学生]隐藏/暂停的课程';
 $string['support_text1'] = "您所有的Moodle数据：简单、可共享、可理解并有吸引力。IntelliBoard是一个Moodle外挂，可将<strong> 120+ </strong>个报告和图表分析置于您的手中。";
 $string['support_text2'] = "您所有的Moodle数据：简单、可共享、可理解并有吸引力。IntelliBoard是您的Moodle报告和分析解决方案，可为您提供120多种报告和分析，帮助您制定教育工作决策。";
 $string['support_info1'] = "您可以加入我们的 <a target='_blank' href='https://intelliboard.net/events'>网络研讨会</a> ，我们将带您浏览IntelliBoard 5.0报告和分析！";
 $string['support_info2'] = "加入我们的 <a target='_blank' href='https://intelliboard.net/events'>网络研讨会</a>，或安排一次您个人的数据之旅。有了我们世界级的支持和服务，您将以全新的视角看到您的学习平台。";
 $string['support_terms'] = "版权所有。";
 $string['support_page'] = "文件审查";
 $string['support_demo'] = "安排展示";
 $string['support_trial'] = "连接与升级";
 $string['support_close'] = "关闭";
 $string['instructor_custom_groups'] = "教师自定群组";
 // settings of tables
 $string['table_set_icg'] = '教师课程';
 $string['table_set_icg_c1'] = '课程名称';
 $string['table_set_icg_c2'] = '课程简称';
 $string['table_set_icg_c3'] = '课程类别';
 $string['table_set_icg_c4'] = '已选课/已完成的学员';
 $string['table_set_icg_c5'] = '课程平均分数';
 $string['table_set_icg_c6'] = '章节';
 $string['table_set_icg_c7'] = '学习活动/资源';
 $string['table_set_icg_c8'] = '访问次数';
 $string['table_set_icg_c9'] = '花费时间';
 $string['table_set_icg_c11'] = '动作 – 学习活动';
 $string['table_set_icg_c12'] = '动作 – 学员';
 $string['percentage_completed_learners'] = '已完成学生百分比';
 $string['avg_visits_per_stud'] = '学生平均访问次数';
 $string['avg_time_spent_per_stud'] = '学生平均花费时间';
 $string['table_set_ilg'] = '教师课程 > 学员';
 $string['table_set_ilg_c1'] = '学员名称';
 $string['table_set_ilg_c2'] = '电子邮件地址';
 $string['table_set_ilg_c3'] = '已选课';
 $string['table_set_ilg_c4'] = '最后访问时间';
 $string['table_set_ilg_c5'] = '状态';
 $string['table_set_ilg_c6'] = '成绩';
 $string['table_set_ilg_c7'] = '完成的学习活动/资源';
 $string['table_set_ilg_c8'] = '访问次数';
 $string['table_set_ilg_c9'] = '花费时间';
 $string['table_set_ilg_c10'] = '动作';
 $string['table_set_ilg1'] = '教师课程 > 学员 > 成绩';
 $string['table_set_ilg1_c1'] = '学习活动名称';
 $string['table_set_ilg1_c2'] = '类型';
 $string['table_set_ilg1_c3'] = '成绩';
 $string['table_set_ilg1_c4'] = '评分';
 $string['table_set_ilg1_c5'] = '状态';
 $string['table_set_ilg1_c6'] = '访问次数';
 $string['table_set_ilg1_c7'] = '花费时间';
 $string['table_set_iag'] = '教师课程 > 学习活动';
 $string['table_set_iag_c1'] = '学习活动名称';
 $string['table_set_iag_c2'] = '类型';
 $string['table_set_iag_c3'] = '已完成学员';
 $string['table_set_iag_c4'] = '平均成绩';
 $string['table_set_iag_c5'] = '访问次数';
 $string['table_set_iag_c6'] = '花费时间';
 $string['table_set_iag_c7'] = '动作';
 $string['table_set_iag1'] = '教师课程 > 学习活动 > 成绩';
 $string['table_set_iag1_c1'] = '学员名称';
 $string['table_set_iag1_c2'] = '电子邮件地址';
 $string['table_set_iag1_c3'] = '状态';
 $string['table_set_iag1_c4'] = '成绩';
 $string['table_set_iag1_c5'] = '评分';
 $string['table_set_iag1_c6'] = '访问次数';
 $string['table_set_iag1_c7'] = '花费时间';
 $string['student_grades'] = '学生成绩';
 $string['grid_view'] = '网格视图';
 $string['list_view'] = '列表显示';
 $string['grade_activities_overview'] = '评分活动总览';
 $string['activity'] = '学习活动名称';
 $string['date_format'] = '日期格式';
 $string['user_enrollments_sessions_completion'] = '用户「选课、联机、完成度」图表';
 $string['user_site_summary_detail'] = '用户概要';
 $string['course_enrollment_types'] = '课程选课类型';
 $string['user_map'] = '用户地图';
 $string['course_enrollments_with_completion_overview'] = '课程完成概况';
 $string['all_modules'] = '所有模块';

 /* Attendance */
 $string['attendance'] = '出缺席纪录';
 $string['enableattendance'] = '启用出缺席纪录';
 $string['attendancetoolurl'] = '工具网址';
 $string['attendanceconsumerkey'] = '客户端密钥';
 $string['attendancesharedsecret'] = '共享密钥';
 $string['sync_data_with_attendance'] = '同步出缺席纪录数据';
 $string['attendanceapibase'] = '出缺席纪录 API 基本路径';
 $string['attendanceapikey'] = '出缺席纪录 API 密钥';
 $string['attendanceapisecret'] = '出缺席纪录 API 密钥';
 $string['enablesyncattendance'] = '启用Blackboard Collaborate 课程与出缺席纪录同步';
 /* BlackBoard Collaborate and InAttendance */
 $string['bb_col_meetings'] = 'BlackBoard Collaborate 会议';
 $string['enable_bb_col_debug'] = '启用 BlackBoard Collaborate 除错模式';
 $string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API 端点';
 $string['bb_col_consumer_key'] = 'BlackBoard Collaborate 客户端密钥';
 $string['bb_col_secret'] = 'BlackBoard Collaborate 密钥';
 $string['enable_bb_col_meetings'] = '启用 BlackBoard Collaborate 会议';
 $string['check_active_bb_col_meetings'] = '查看活跃的 BlackBoard Collaborate 会议';
 $string['local_intelliboard_bb_collaborate_session_tracking_started'] = '开始追踪的 BlackBoard 协作会话';
 $string['local_intelliboard_bb_collaborate_session_tracking_finished'] = '完成追踪的 BlackBoard 协作会话';
 $string['local_intelliboard_bb_collaborate_api_request_finished'] = '完成的 BlackBoard 协作 API 请求';

/* Admin dashboard */
$string['admin_dashboard'] = '管理员仪表板';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = '用户「选课、联机、完成度」图表';
$string['adm_dshb_adm_dashb_totals'] = '总计';
$string['adm_dshb_user_site_summary_details'] = '用户概要';
$string['adm_dshb_course_enrollments_types'] = '课程选课类型';
$string['adm_dshb_user_map'] = '用户地图';
$string['adm_dshb_user_enrol_with_compl_overview'] = '课程完成度概况';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = '隐藏"需要帮助？"按钮';
$string['names_order'] = '名称顺序';
$string['firstname_lastname'] = '{名字} {姓氏}';
$string['lastname_firstname'] = '{姓氏} {名字}';
$string['issuer'] = '发行人';
$string['criteria_method'] = '准则方法';
$string['criteria_all_courses'] = '必须完成以下所有课程';
$string['criteria_any_course'] = '必须完成以下任何一门课程';
$string['dashboard_settings'] = '仪表板设定';


$string['tracklogs'] = '依用户追踪时间 - 每日';
$string['trackdetails'] = '依用户追踪时间 - 每小时';
$string['tracktotals'] = '追踪时间汇总 - 每日';

$string['enable_badges_report'] = '启用"奖章"报告';
$string['sizemode'] = '规模大小: 大 ( > 5,000 个用户)';
$string['cachedef_bb_collaborate_access_token'] = 'BlackBoard Collaborate 访问许可(token)';


$string['learner_menu'] = '在导航块菜单中显示 "我的学习报表"，只对已选课的学员开放';
$string['learning_plan_filter'] = '学习计划筛选器';
$string['learning_plan_viewer_role'] = '"学习计划监看员"角色';
$string['all_cohorts'] = '所有群组';
$string['privacy_shield_policy'] = '数据处理附录';
$string['privacy_policy'] = '隐私政策';
$string['confirm_and_sign_up'] = '确认并注册';
$string['term_of_use'] = '使用条款';
$string['setup'] = '开始连接';
$string['protocol'] = '协定';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = '下一页';
$string['terms_msg'] = '勾选此框，即表示您已经阅读并同意我们的使用条款。';
$string['privacy_msg'] = '勾选此框，即表示您已阅读并同意我们的隐私政策。';
$string['shield_msg'] = '勾选此框，即表示您已阅读并同意我们的数据处理附录。';
$string['enable_webservice'] = '启用网络服务';
$string['you_need_to_enable_at_least_one_protocol'] = '您需要启用至少一个协议';
$string['invalid_user'] = '无效的用户';
$string['sign_in'] = '登入';
$string['email'] = '电子邮件';
$string['password'] = '密码';
$string['all_fields_required'] = '所有字段均为必填';
$string['server_error'] = '糟糕！发生了意外情况。请透过 support@intelliboard.net 与我们联系';
$string['country'] = '国家';
$string['please_accept_terms_and_conditions'] = '请接受条款和条件';
$string['congratulations_intb_register'] = '恭喜';
$string['congratulations_intb_register_msg'] = '感谢您开始使用 IntelliBoard 的15天免费试用版! 请检查您的电子邮件以确认您的 IntelliBoard 账户。首先，请使用单一登录 (SSO) 连结（如果已启用），从网站管理 > IntelliBoard 或登录 <a href="https://app.intelliboard.net/signin">此处</a>。 SSO 链接显示为 "INTELLIBOARD.NET"，位于仪表板的右上角。如有疑问，请联系 Support@IntelliBoard.net。';
$string['sign_up'] = '注册';
$string['sign_in'] = '登入';
$string['intelliboard_settings'] = 'IntelliBoard 设定';
$string['moodle_settings'] = 'Moodle 设定';
$string['email_is_required'] = '电子邮件为必填项目';
$string['invalid_email'] = '无效的电子邮件';
$string['intelliboard_terms'] = 'IntelliBoard 协议';
$string['authentication'] = '账号创建';
$string['intb_settings_descr'] = "IntelliBoard 需要一个主要、唯一的订阅电子邮件。请在下面输入您希望用作订阅的电子邮件信箱。该电子邮件必须在使用前通过电子邮件确认进行双重验证。如有疑问，请联系 <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>。有关 IntelliBoard 设置的完整列表，请转到网站管理 > 外挂 > 本地端外挂 > IntelliBoard。";
$string['hosting_provider'] = '托管服务商';
$string['self_hosted'] = '自行托管';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = '学员状态';
$string['report2_name'] = '课程统计';
$string['report3_name'] = '学习活动统计';
$string['report45_name'] = '测验卷活动统计';
$string['report_activity_stats_summary'] = '学习活动统计概要';
$string['report_user_profile_information'] = '用户个人资料';
$string['course_name'] = '课程名称';
$string['course_short_name'] = '课程简称';
$string['course_idnumber'] = 'ID 号码';
$string['course_status'] = '状态';
$string['number_of_learners'] = '选课人数';
$string['number_of_modules'] = '学习活动数量';
$string['number_of_completed_learners'] = '已完成用户数';
$string['number_of_visits'] = '访问次数';
$string['num_completed_activity'] = '完成活动的用户数';
$string['total_time_spent'] = '花费时间总计';
$string['date_created'] = '建立日期';
$string['initial_reports'] = 'Initial Reports初步报告';
$string['avg_score'] = '平均分数';
$string['first_access'] = '首次访问';
$string['completion_not_enabled'] = '完成度追踪未启用';
$string['first_name'] = '名字';
$string['last_name'] = '姓氏';
$string['num_attempts'] = '尝试次数';
$string['highest_grade'] = '最高成绩';
$string['lowest_grade'] = '最低成绩';
$string['initial_reports_warning'] = '要透过电子邮件发送、排程和进一步个人化这些报告，请点击 “<a href="{$a}">连接和升级</a>”。';
$string['last_access'] = '最后访问';
$string['enrolment_expiration'] = '选课截止日期';
$string['id_number'] = 'ID 号码';
$string['telephone1'] = '电话 1';
$string['telephone2'] = '电话 2';
$string['institution'] = '院校/机构';
$string['department'] = '科系/部门';
$string['address'] = '地址';
$string['city'] = '城市/乡镇';
$string['enroled_on'] = '选课日期';

$string['dashboard_link'] = '点击查看分析';
$string['support_connect'] = '点击下方矩形内的报告按钮。了解 IntelliBoard 的强大功能。一键浏览您的学习平台洞察力。想要了解更多？点击 "点击查看分析"。还想了解更多？ 在右上方<a href="{$a->connect_link}">"连接和升级"</a>，或您看到链接的任何位置。';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = '需要更多信息？请点击任何蓝色按钮与我们联系。';

$string['web_services_descr'] = 'IntelliBoard 需要启用网络服务。 网络服务使其他系统（如 IntelliBoard）能够访问该学习平台系统并预先执行操作。为了安全起见，在不使用时应将其禁用。有关其他审查，请转到网站管理 > 进阶功能 > 网络服务。';
$string['protocol_descr'] = 'IntelliBoard 需要启用 REST 或 SOAP 协议。为了安全起见，只应启用正在使用的协议。有关其他审查，请转到网站管理 > 外挂 > 网络服务 > 管理传输协议。';
$string['authorized_user_descr'] = 'IntelliBoard 需要一个授权用户。授权用户很可能是网站管理员，并且必须拥有管理网络服务、传输协议和通行凭证的权限。有关其他审查，请转到网站管理 > 外挂 > 网络服务 > 外部服务 > IntelliBoard 服务 > 已授权的用户。';
$string['email_subscr'] = '订阅电子邮件信箱';
$string['protocols_descr'] = 'IntelliBoard 需要启用 REST 或 SOAP 协议。为了安全起见，只应启用正在使用的协议。有关其他审查，请转到网站管理 > 外挂 > 网络服务 > 管理传输协议。';
$string['enable_time_tracking'] = '启用时间追踪';
$string['enable_time_tracking_descr'] = '启用时间追踪，以获得更多关于使用者存取、浏览和花费时间的信息。IntelliBoard 提供了与 Moodle 时间花费表不同的关于时间追踪的其他洞察。';
$string['enable_sso'] = '启用(SSO)单一登录连结';
$string['enable_sso_descr'] = '启用网站管理员使用单一登录连结，进入app.IntelliBoard.net上的IntelliBoard SuperAdmin访问权限';
$string['join_a_webinar'] = '参加网络研讨会';
$string['review_support_doc'] = '查看支持文件';
$string['setup_subheading'] = '连接并体验您数据的力量。无需信用卡、没有义务。仅有15天的免费数据体验。';

$string['instructor_courses_table_name'] = '课程成绩';
$string['instructor_courses_table_name_learner'] = '课程 {$a->course}, 学员 {$a->learner}, 成绩';
$string['instructor_courses_table_name_activity'] = '课程 {$a->course}, 学习活动 {$a->name}, 成绩';
$string['instructor_courses_table_name_learners'] = '课程 {$a->fullname}, 学员';
$string['instructor_courses_table_name_activities'] = '课程 {$a->fullname}, 学习活动';

$string['successfull_connected'] = '连接成功';
$string['not_connected'] = '尚未连接';

$string['transcripts'] = '成绩单';
$string['enable_transcripts'] = '启用成绩单';
$string['closed'] = '关闭';
$string['synctranscriptstask'] = '同步成绩单任务';
$string['transcriptssyncrecordsnum'] = '成绩单处理大小';
$string['transcriptssyncrecordsnum_desc'] = '一次处理的用户选课记录数量';
$string['privacy:metadata:local_intelliboard_trns_c'] = '成绩单课程记录';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = '用户ID';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = '用户电子邮件';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = '用户名字';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = '用户姓氏';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = '成绩单用户选课ID';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = '选课纪录ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = '选课方式';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = '课程编号';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = '课程名称';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = '选课日期';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = '退选日期';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = '完成日期';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = '成绩单状态';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = '成绩项目ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = '成绩编号';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = '最高成绩';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = '最低成绩';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = '最后成绩';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = '格式化成绩';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = '用户角色';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = '用户群组';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = '建立记录时的时间';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = '上次更新记录的时间';
$string['privacy:metadata:local_intelliboard_trns_m'] = '成绩单课程记录';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = '成绩单用户选课ID';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = '课程ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = '用户ID';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = '课程模块ID';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = '模块ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = '学习活动名称';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = '模块类型';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = '开始日期';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = '完成日期';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = '状态';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = '成绩项目ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = '成绩ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = '最高成绩';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = '最低成绩';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = '最后成绩';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = '格式化成绩';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = '建立记录时的时间';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = '上次更新记录的时间';
$string['goal_grade'] = '目标成绩';
$string['importtrackingtask'] = '汇入追踪任务';
$string['compresstracking'] = '压缩追踪';
$string['compresstracking_desc'] = '将时间追踪数据写入档案或Redis，并使用cron作业将数据传输到数据库库（默认值：每15分钟一次）';
$string['cachedef_instructor_course_data'] = '课程数据快取';
$string['cachedef_reports_list'] = '报告列表快取';
$string['do_not_use_compresstracking'] = '不要使用压缩追踪';
$string['cache_compresstracking'] = '保存到Moodle快取';
$string['file_compresstracking'] = '保存到MoodleData';
$string['cachedef_tracking'] = 'Intelliboard追踪数据';
$string['cachedef_track_config'] = 'Intelliboard追踪总数据';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = '日本/中国兼容字体';
$string['all_selected'] = '全选';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
