<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This plugin provides access to Moodle data in form of analytics and reports in real time.
 *
 *
 * @package    local_intelliboard
 * @copyright  2017 IntelliBoard, Inc
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @website    http://intelliboard.net/
 */

 $string['pluginname'] = 'IntelliBoard.net 報表外掛';
 $string['tracking_title'] = '時間追蹤';
 $string['tracking'] = '連線追蹤';
 $string['dashboard'] = '報表首頁';
 $string['settings'] = '設定';
 $string['adv_settings'] = '進階設定';
 $string['intelliboardroot'] = 'IntelliBoard';
 $string['intelliboard_reports'] = 'IntelliBoard 報表';
 $string['report'] = '報表';
 $string['reports'] = '報表';
 $string['learners'] = '學員';
 $string['courses'] = '課程';
 $string['load'] = '效能';
 $string['inactivity'] = '不活躍';
 $string['inactivity_desc'] = '用戶不活躍的時間(以秒為單位)';
 $string['ajax'] = '頻率';
 $string['ajax_desc'] = '透過AJAX儲存連線次數。 0：停用AJAX(以秒為單位)';
 $string['enabled'] = '啟用追蹤';
 $string['enabled_desc'] = '啟用追蹤';
 $string['trackadmin'] = '追蹤網站管理員';
 $string['logs'] = '遷移工具';
 $string['trackadmin_desc'] = '啟用追蹤網站管理員(不建議)';
 $string['intelliboard:instructors'] = 'IntelliBoard [教師]';
 $string['intelliboard:students'] = 'IntelliBoard [學員]';
 $string['intelliboard:view'] = 'IntelliBoard [查看]';
 $string['intelliboard:manage'] = 'IntelliBoard [管理]';
 $string['intelliboard:competency'] = 'IntelliBoard [職能]';
 $string['intelliboard:attendanceadmin'] = '出勤管理';
 $string['intelliboard:browseallcohorts'] = 'IntelliBoard [瀏覽所有班級群組]';
 $string['tls12'] = 'TLS v1.2';
 $string['tls12_desc'] = '進階設定: TLS v1.2';
 $string['sso'] = 'SSO 連結';
 $string['sso_desc'] = 'SSO連結到IntelliBoard.net';
 $string['ssomenu'] = 'SSO選單項目';
 $string['ssomenu_desc'] = '在導覽區塊選單顯示SSO連結 (對於非學員/非教師)';
 $string['api'] = '替代API';
 $string['api_desc'] = '使用替代的API伺服器（以避免防火牆阻擋）';
 $string['server'] = 'IntelliBoard 伺服器';
 $string['server_usa'] = 'IntelliBoard 美國';
 $string['server_au'] = 'IntelliBoard 澳洲';
 $string['server_eu'] = 'IntelliBoard 歐洲';
 $string['show_dashboard_tab'] = '儀表板頁面';
 $string['filters'] = '儀表板過濾器';
 $string['filter1'] = '已刪除的用戶';
 $string['filter2'] = '已暫停的用戶';
 $string['filter3'] = '訪客';
 $string['filter4'] = '課程過濾器';
 $string['filter5'] = '選課方式過濾器';
 $string['filter6'] = '用戶選課過濾器';
 $string['filter7'] = '學習活動/資源過濾器';
 $string['filter8'] = '選課用戶過濾器';
 $string['filter1_desc'] = '顯示已刪除的用戶';
 $string['filter2_desc'] = '顯示已暫停的用戶';
 $string['filter3_desc'] = '在報表中顯示[訪客]用戶';
 $string['filter4_desc'] = '顯示隱藏的課程';
 $string['filter5_desc'] = '顯示不活耀的選課方式';
 $string['filter6_desc'] = '顯示選課狀態不活躍的用戶';
 $string['filter7_desc'] = '顯示隱藏的學習活動/資源';
 $string['filter8_desc'] = '僅顯示已選課用戶(不建議)';
 $string['intelliboardaccess'] = '您無權查看此頁面。請聯繫您的網站管理員尋求協助。';
 $string['tex1'] = 'IntelliBoard 學員報表個人首頁未啟用。.';
 $string['account'] = '訂閱資訊';
 $string['te12'] = '名字';
 $string['te13'] = '姓氏';
 $string['te1'] = '電子郵件';
 $string['te1_desc'] = '輸入在 IntelliBoard.net 上訂閱的電子郵件信箱。如果您尚未訂閱，請在 <a target="_blank" href="https://intelliboard.net">IntelliBoard.net</a> 中註冊。學員和教師報表個人首頁可在訂閱了 4 級或更高等級的情況下使用。';
 $string['n1'] = '總覽[學員進度]';
 $string['n2'] = '總覽[成績進度]';
 $string['n3'] = '總覽[活動進度]';
 $string['n12'] = '總覽[課程概況]';
 $string['n4'] = '總覽[總計]';
 $string['n5'] = '目前進度';
 $string['n13'] = '學生總數';
 $string['n6'] = '工具：相關性';
 $string['n14'] = '工具：學員參與';
 $string['n18'] = '工具：學生成績進度';
 $string['n7'] = '工具：事件使用率';
 $string['n15'] = '工具：學習活動使用率';
 $string['n16'] = '工具：學習單元使用率';
 $string['n8'] = '課程頁面';
 $string['n9'] = '報表頁面';
 $string['n19'] = '報表的課程導覽連結';
 $string['n10'] = '課程管理報表';
 $string['n101'] = '啟用課程管理報表';
 $string['n11'] = '導覽區塊選單的替代文字';
 $string['ts1'] = '我的學習報表';
 $string['ts2'] = '我的學習報表 頁面';
 $string['ts3'] = '我的學習報表 課程';
 $string['ts4'] = '我的學習報表 成績';
 $string['ts5'] = '我的學習報表 報告';
 $string['learner_tf_last_week'] = '時間篩選：7天內';
 $string['t01'] = '時間篩選：最近30天';
 $string['t02'] = '時間篩選：最近3個月';
 $string['t03'] = '時間篩選：最近6個月';
 $string['t04'] = '啟用[標頭]已完成的課程';
 $string['t05'] = '啟用[標頭]進行中的課程';
 $string['t06'] = '啟用[標頭]課程平均成績';
 $string['t07'] = '啟用[標頭]訊息';
 $string['t08'] = '啟用[標頭]課程平均成績';
 $string['t09'] = '教師可以看到自己的學生';
 $string['t1'] = '啟用我的學習報表';
 $string['t2'] = '啟用報表個人首頁';
 $string['t3'] = '啟用課程';
 $string['t4'] = '啟用成績';
 $string['t48'] = '啟用報告';
 $string['t5'] = '啟用[學習活動進度]圖表';
 $string['t53'] = '啟用[活動進度]圖表平均線';
 $string['t6'] = '啟用[課程進度]圖表';
 $string['t7'] = '啟用[我的課程平均]';
 $string['t8'] = '啟用[總體課程平均]';
 $string['t9'] = '啟用[作業]小工具';
 $string['t10'] = '啟用[測驗]小工具';
 $string['t11'] = '啟用[課程進度]小工具';
 $string['t12'] = '啟用[學習活動參與]小工具';
 $string['t13'] = '啟用[學習]小工具';
 $string['t14'] = '啟用[課程進度]小工具';
 $string['t15'] = '啟用[相關性]小工具';
 $string['t16'] = '啟用課程教師';
 $string['t17'] = '啟用課程類別';
 $string['t18'] = '啟用課程完成';
 $string['t19'] = '啟用課程成績';
 $string['t20'] = '啟用課程班級平均';
 $string['t21'] = '啟用課程花費時間';
 $string['t22'] = '啟用課程開始日期';
 $string['t23'] = '啟用[課程開始日期]欄位';
 $string['t24'] = '啟用[選課日期]欄位';
 $string['t25'] = '啟用[進度]欄位';
 $string['t26'] = '啟用[字母等級]欄位';
 $string['t27'] = '啟用[完成的學習活動]欄位';
 $string['t28'] = '啟用[成績]欄位';
 $string['t29'] = '啟用[課程完成狀態]欄位';
 $string['t30'] = '啟用[學習活動成績]欄位';
 $string['t31'] = '啟用[作業][成績]小工具欄位';
 $string['t32'] = '啟用[作業][截止日期]小工具欄位';
 $string['t33'] = '啟用[測驗][成績]小工具欄位';
 $string['t34'] = '啟用[測驗][截止日期]小工具欄位';
 $string['t35'] = '啟用[課程進度][進度]小工具欄位';
 $string['t36'] = '啟用[課程進度][成績]小工具欄位';
 $string['t37'] = '啟用[課程進度][已選課]小工具欄位';
 $string['t38'] = '啟用[課程進度][已完成]小工具欄位';
 $string['t52'] = '啟用[課程進度][課程類別]小工具行˙';
 $string['t39'] = '啟用[進度][目標成績]選項';
 $string['t40'] = '啟用[進度][班級平均]選項';
 $string['t41'] = '啟用[學習活動成績標頭]完成時間';
 $string['t42'] = '啟用[學習活動成績標頭]最後進入課程時間';
 $string['t43'] = '啟用[學習活動成績]類型欄位';
 $string['t44'] = '啟用[學習活動成績]成績欄位';
 $string['t45'] = '啟用[學習活動成績]已評分欄位';
 $string['t46'] = '啟用[學習活動成績]已完成欄位';
 $string['t54'] = '啟用[學習活動成績]花費時間欄位';
 $string['t47'] = '課程[網格]背景顏色';
 $string['t49'] = '報告篩選欄';
 $string['t50'] = '教師角色';
 $string['t51'] = '學生角色';
 $string['current_grade'] = '目前成績';
 $string['average_grade'] = '平均成績';
 $string['type_here'] = '在此輸入...';
 $string['enrolled_date'] = '選課日期';
 $string['teacher'] = '教師';
 $string['category'] = '課程類別';
 $string['current_grade'] = '目前成績';
 $string['completion'] = '完成情況';
 $string['class_average'] = '班級平均';
 $string['time_spent'] = '花費時間';
 $string['completed_on'] = '完成時間{$a}';
 $string['passed_on'] = '完成時間(通過){$a}';
 $string['failed_on'] = '完成時間(未通過){$a}';
 $string['last_access_on_course'] = '最後進入課程時間：{$a}';
 $string['you_have_certificates'] = '您有{$a}張證書';
 $string['close'] = '關閉';
 $string['view_course_details'] = '瀏覽課程詳情';
 $string['incomplete'] = '未完成';
 $string['return_to_grades'] = '返回成績';
 $string['grade'] = '成績';
 $string['last_week'] = '最近7天';
 $string['last_month'] = '最近30天';
 $string['last_quarter'] = '最近3個月';
 $string['last_semester'] = '最近6個月';
 $string['all_time'] = '所有時間';
 $string['activity_progress'] = '學習活動進度';
 $string['course_progress'] = '課程進度';
 $string['my_course_average_all'] = '我的課程平均(所有課程)';
 $string['overall_course_average'] = '整體課程平均(所有學員；所有課程)';
 $string['assignments'] = '作業';
 $string['quizzes'] = '測驗';
 $string['assignment_name'] = '作業名稱';
 $string['due_date'] = '截止日期';
 $string['no_data'] = '無可用資料';
 $string['quiz_name'] = '測驗名稱';
 $string['all_courses'] = '所有課程';
 $string['time_period_due'] = '時間期限(截止日期)';
 $string['all_data'] = '所有資料';
 $string['progress'] = '進度';
 $string['enrolled'] = '選課人數';
 $string['completed'] = '完成人數';
 $string['activity_participation'] = '活動參與情況';
 $string['learning'] = '學習';
 $string['course_success'] = '課程進度';
 $string['correlations'] = '相關性';
 $string['course_start_date'] = '課程開始日期';
 $string['letter'] = '字母等級';
 $string['completed_activities'] = '已完成的學習活動';
 $string['score'] = '成績';
 $string['course_completion_status'] = '課程完成狀態';
 $string['activity_grades'] = '學習活動成績';
 $string['completion_is_not_enabled'] = '此課程未啟用完成進度追蹤';
 $string['activities'] = '學習活動';
 $string['activity_name'] = '學習活動名稱';
 $string['type'] = '類型';
 $string['graded'] = '取得成績時間';
 $string['passed'] = '通過';
 $string['failed'] = '失敗';
 $string['completed_courses'] = '已完成的課程';
 $string['courses_in_progress'] = '進行中的課程';
 $string['courses_avg_grade'] = '課程平均成績';
 $string['courses_sum_grade'] = '依成績量尺計算的課程總成績';
 $string['grades'] = '成績';
 $string['messages'] = '訊息';
 $string['x_completions'] = '{$a}完成';
 $string['completion_status'] = '完成情況';
 $string['users_activity'] = '用戶學習活動';
 $string['daily'] = '最近10天';
 $string['weekly'] = '最近90天';
 $string['monthly'] = '最近1年';
 $string['number_of_sessions'] = '訪問次數';
 $string['number_today'] = '本日{$a}';
 $string['number_this_week'] = '本週{$a} ';
 $string['course_completions'] = '課程完成度';
 $string['user_enrolments'] = '用戶選課';
 $string['users'] = '用戶';
 $string['modules'] = '活動模組';
 $string['categories'] = '課程類別';
 $string['total'] = '總計';
 $string['users_overview'] = '用戶概觀';
 $string['enable_time_and_visits_users_overview'] = '在用戶概觀中啟用花費和訪問時間';
 $string['disable_time_and_visits_users_overview'] = '在用戶概觀中停用花費和訪問時間';
 $string['loading'] = '載入中...';
 $string['loading2'] = '請稍候，正在載入中...';
 $string['enrollments'] = '選課方式';
 $string['registrations'] = '選課人數（以國家區分）';
 $string['participation'] = '課程參與度';
 $string['time'] = '時間';
 $string['enrolment_method'] = '選課方式';
 $string['intelliBoard_migration_tool'] = 'IntelliBoard 遷移工具';
 $string['importing_totals'] = '匯入總計';
 $string['total_numbers'] = '日期：{$a->timepoint}，連線數：{$a->sessions}，訪問：{$a->visits}，花費時間：{$a->timespend}';
 $string['total_numbers2'] = '用戶：{$a->userid}，頁面：{$a->page}，參數：{$a->param}，訪問：{$a->visits}，花費時間：{$a->timespend}';
 $string['total_numbers3'] = '----日期：{$a->timecreated}，追蹤 ID：{$a->trackid}，訪問：{$a->visits}，花費時間：{$a->timespend}';
 $string['logs_to_process'] = '日誌處理{$a}';
 $string['please_wait_or_cancel'] = '請等待以繼續或<a href="{$a}">取消</a>';
 $string['done'] = '完成！';
 $string['return_to_home'] = '返回首頁';
 $string['importing_logs'] = '匯入紀錄';
 $string['intelliBoard_migration_tool_info'] = 'IntelliBoard 遷移工具用於將Moodle日誌中的歷史數據遷移到新格式。請注意，Moodle 日誌儲存過程不會改變。一旦歷史數據遷移到新格式，像「花費時間」和「訪問」這樣的歷史數據將在 IntelliBoard.net 上提供預覽。';
 $string['moodle_logs'] = 'Moodle 日誌';
 $string['intelliboard_tracking'] = 'IntelliBoard 追蹤';
 $string['intelliboard_logs'] = 'IntelliBoard 日誌';
 $string['intelliboard_totals'] = 'IntelliBoard 總計';
 $string['intelliboard_start_tracking'] = 'IntelliBoard 開始追蹤';
 $string['total_values_include'] = '所有數值包括單一連線數、課程、訪問、和花費時間。';
 $string['items_per_query'] = '每個查詢的項目數';
 $string['import'] = '匯入';
 $string['log_values_include'] = '日誌值包括每個用戶每天的日誌';
 $string['powered_by'] = '由<a href="https://intelliboard.net/">IntelliBoard</a>提供技術支援';
 $string['intelliboardnet'] = 'IntelliBoard.net';
 $string['visits'] = '訪問數';
 $string['registered'] = '已選課';
 $string['disabled'] = '停用';
 $string['enrolled_completed'] = '已選課: {$a->courses}，已完成：{$a->completed_courses}';
 $string['enrolled_users_completed'] = '已選課用戶：{$a->users}，已完成：{$a->completed}';
 $string['user_grade_avg'] = '{$a->user} 成績：{$a->grade}，平均成績：{$a->avg_grade_site})';
 $string['user_visit_avg'] = '{$a->user} 訪問數：{$a->visits}，平均訪問數：{$a->avg_visits_site}';
 $string['user_time_avg'] = '{$a->user} 花費時間：{$a->timespend}，平均花費時間：{$a->avg_timespend_site}';
 $string['more_users'] = '更多用戶';
 $string['more_courses'] = '更多課程';
 $string['showing_1_to_10'] = '顯示 1 到 10';
 $string['course_grade'] = '課程成績';
 $string['completed_activities_resourses'] = '已完成的學習活動/資源';
 $string['save'] = '儲存';
 $string['help'] = '需要幫助？';
 $string['in1'] = '概述';
 $string['in2'] = '目前進度';
 $string['in3'] = '課程總數';
 $string['in4'] = '學員總數';
 $string['in5'] = '取得成績學員數';
 $string['in6'] = '已完成的學員';
 $string['in7'] = '未完成的學員';
 $string['in8'] = '學員平均成績';
 $string['in9'] = '相關性';
 $string['in10'] = '事件使用情況';
 $string['in11'] = '學員進度';
 $string['in12'] = '成績進度';
 $string['in13'] = '花費時間(%)';
 $string['in14'] = '進度%';
 $string['in15'] = '學員完成度';
 $string['in16'] = '上次訪問';
 $string['in17'] = '總花費時間';
 $string['in18'] = '總訪問數';
 $string['in19'] = '平均成績';
 $string['in20'] = '返回學員';
 $string['in201'] = '返回學習活動';
 $string['in21'] = '課程平均成績';
 $string['in22'] = '啟用';
 $string['in23'] = '您沒有學員可以顯示。';
 $string['in24'] = '模組';
 $string['in25'] = '及格成績';
 $string['in26'] = '學員參與度';
 $string['in34'] = '學生成績進度';
 $string['in27'] = '學生總數';
 $string['in28'] = '平均花費時間';
 $string['in29'] = '活躍的學生';
 $string['in30'] = '不活躍的學生';
 $string['in31'] = '學習活動使用率';
 $string['in32'] = '在選定時間內的平均時間';
 $string['in33'] = '單元主題使用率';
 $string['status'] = '狀態';
 $string['course_category'] = '課程類別';
 $string['course_started'] = '已開始的課程';
 $string['total_time_spent_enrolled_learners'] = '選課學員在課程中的總花費時間';
 $string['total_visits_enrolled_learners'] = '選課學員在課程中的總訪問量';
 $string['learners_enrolled'] = '已選課學員';
 $string['learners_enrolled_period'] = '在選定時間內的選課學員';
 $string['learning_progress'] = '學習進度';
 $string['sections'] = '單元數';
 $string['section'] = '單元';
 $string['total_activities_resources'] = '學習活動/資源總計';
 $string['completions'] = '完成情況';
 $string['return_to_courses'] = '返回課程';
 $string['click_link_below_support_pages'] = '點擊下方連結來訪問 IntelliBoard 支持與幫助頁面：';
 $string['support'] = '支持與幫助';
 $string['course_name'] = '課程名稱';
 $string['enrolled_completed_learners'] = '已選課/已完成的學員';
 $string['activities_resources'] = '學習活動/資源';
 $string['actions'] = '動作';
 $string['learner_name'] = '學員名稱';
 $string['completed_activities_resources'] = '已完成的學習活動/資源';
 $string['filter_dates'] = '篩選日期：';
 $string['select_date'] = '選擇日期';
 $string['select'] = '選擇';
 $string['selectall'] = '選擇全部';
 $string['ok'] = 'OK';
 $string['moodle'] = 'Moodle';
 $string['totara'] = 'Totara';
 $string['monitors'] = '圖表分析';
 $string['cohorts'] = '校定班級群組';
 $string['course_overview'] = '課程概述';
 $string['topics'] = '單元主題';
 $string['a31'] = '職能架構';
 $string['a32'] = '學習計畫';
 $string['a33'] = '熟練';
 $string['a34'] = '不熟練';
 $string['a35'] = '尚未評等';
 $string['a36'] = '職能概述';
 $string['a37'] = '尚未建立職能。 請聯繫您的系統管理員。';
 $string['a38'] = '與職能連結的課程';
 $string['a39'] = '職能總數';
 $string['a40'] = '連結課程';
 $string['no_competency'] = '看起來您沒有在您的 Moodle 網站上啟用職能。';
 $string['scalesettings'] = '職能量尺設定';
 $string['scales'] = '啟用自訂職能量尺';
 $string['scale_raw'] = '停用職能量尺';
 $string['scale_real'] = '顯示實際成績而不是百分比';
 $string['scale_total'] = '總成績';
 $string['scale_value'] = '數值';
 $string['scale_percentage'] = '百分比';
 $string['a0'] = '職能進度報表';
 $string['a1'] = '職能';
 $string['a2'] = '熟練度';
 $string['a3'] = '分配的學習活動';
 $string['a4'] = '熟練進度';
 $string['a5'] = '已評等職能';
 $string['a6'] = '職能證據';
 $string['a7'] = '已評等學員';
 $string['a8'] = '進度';
 $string['a9'] = '熟練的學員';
 $string['a10'] = '已登記學員';
 $string['a11'] = '已指配給課程的職能列表';
 $string['a12'] = '學員狀態';
 $string['a13'] = '職能名稱';
 $string['a14'] = '建立時間';
 $string['a15'] = '分配時間';
 $string['a16'] = '熟練度';
 $string['a17'] = '評等';
 $string['a18'] = '職能熟練';
 $string['a19'] = '職能評等日期';
 $string['a20'] = '職能評等者';
 $string['a21'] = '已分配的學習活動';
 $string['a22'] = '已獲得熟練';
 $string['a23'] = '已評等職能';
 $string['a24'] = '證據';
 $string['a25'] = '已完成的學員';
 $string['a27'] = ' 之於 ';
 $string['a28'] = '詳細內容';
 $string['a29'] = '啟用職能進度報表';
 $string['a30'] = '啟用職能報告';
 $string['a26'] = '此表格顯示分配給課程的職能數量，已評分的學員（無論是否熟練）以及已被指定為職能熟練的學員。';
 $string['s25'] = '花費在學習活動上的時間';
 $string['s45'] = '學習活動';
 $string['s46'] = '嘗試的學生百分比';
 $string['s47'] = '單元主題';
 $string['s48'] = '花費在單元主題上的時間';
 $string['completions'] = '學習活動完成狀態';
 $string['completions_completed'] = '完成狀態(已完成)';
 $string['completions_pass'] = '完成狀態 (通過)';
 $string['completions_fail'] = '完成狀態 (失敗)';
 $string['completions_desc'] = '1) 用戶已完成此學習活動。 沒有說明他們是否通過或失敗。<br>
 2) 用戶已完成此學習活動，其成績高於合格標準。<br>
 3) 用戶已完成此學習活動，但其成績低於合格標準。';
 $string['widget_name27'] = "累計註冊人數";
 $string['widget_name28'] = "參與度";
 $string['widget_name29'] = "登入人數";
 $string['widget_name30'] = "各課程的選課學員";
 $string['widget_name31'] = "註冊員及主管";
 $string['role1'] = "第一個角色";
 $string['role2'] = "第二個角色";
 $string['select_course'] = "選擇課程";
 $string['select_quiz'] = "選擇測驗";
 $string['not_quiz'] = "哎呀，看來您所選的課程沒有建立任何測驗。";
 $string['enter_course_and_quiz'] = "請選擇您的課程和測驗。";
 $string['enter_quiz'] = "請選擇您的測驗。";
 $string['analityc_3_name'] = "測驗概述 & 問題詳細內容";
 $string['course_name_a'] = '課程：{$a}';
 $string['quiz_name_a'] = '測驗：{$a}';
 $string['cor_incor_answers'] = '正確/錯誤的答案';
 $string['quiz_finished'] = '測驗結束';
 $string['quiz_grades'] = '測驗成績';
 $string['correct_number'] = '正確{$a}';
 $string['incorrect_number'] = '不正確{$a}';
 $string['correct'] = '正確';
 $string['incorrect'] = '不正確';
 $string['weekday_0'] = "星期一";
 $string['weekday_1'] = "星期二";
 $string['weekday_2'] = "星期三";
 $string['weekday_3'] = "星期四";
 $string['weekday_4'] = "星期五";
 $string['weekday_5'] = "星期六";
 $string['weekday_6'] = "星期天";
 $string['time_1'] = "早上";
 $string['time_2'] = "下午";
 $string['time_3'] = "晚上";
 $string['time_4'] = "休息時間";
 $string['passing_score_for'] = '將及格分數給 {$a}';
 $string['name'] = '名稱';
 $string['answers'] = '答案';
 $string['ques_breakdown'] = '問題分析';
 $string['n17'] = '分析頁面';
 $string['analytics'] = '分析';
 $string['pdf'] = 'PDF';
 $string['csv'] = 'CSV';
 $string['excel'] = 'Excel';
 $string['grades_alt_text'] = '導覽選單的替代文字';
 $string['course_chart'] = '啟用課程圖表';
 $string['course_activities'] = '啟用課程活動';
 $string['filter_this_year'] = '時間篩選：今年';
 $string['filter_last_year'] = '時間篩選：去年';
 $string['filter_all_time'] = '時間篩選：所有時間';
 $string['this_year'] = '今年';
 $string['last_year'] = '去年';
 $string['reportselect'] = '請從 App.IntelliBoard.net 中選擇至少一個報告。點選“報告”，然後再點選“個人化報告”，並在“在Moodle中可見”中選擇它。';
 $string['monitorselect'] = '請從 App.IntelliBoard.net 中選擇至少一個圖表。 點選“圖表分析”，然後再點選“個人化圖表分析組”，並在“在Moodle中可見”中選擇它。';
 $string['select_user'] = '選擇用戶';
 $string['course_max_grade'] = '課程最高成績';
 $string['no_data_notification'] = '[日期]沒有新數據';
 $string['last_hour'] = '小時';
 $string['last_day'] = '天';
 $string['privacy:metadata:local_intelliboard_assign'] = 'Intelliboard 分配子帳戶列表';
 $string['privacy:metadata:local_intelliboard_details'] = 'Intelliboard alt/日誌/每小時列表';
 $string['privacy:metadata:local_intelliboard_logs'] = 'Intelliboard alt/日誌/每天列表';
 $string['privacy:metadata:local_intelliboard_totals'] = 'Intelliboard alt/日誌/總表';
 $string['privacy:metadata:local_intelliboard_tracking'] = 'Intelliboard alt/日誌/所有時間列表';
 $string['privacy:metadata:local_intelliboard_reports'] = 'Intelliboard 自定義SQL報告列表';
 $string['privacy:metadata:local_intelliboard_ntf'] = 'Intelliboard 事件通知主表';
 $string['privacy:metadata:local_intelliboard_ntf_hst'] = 'Intelliboard 事件通知歷史記錄表';
 $string['privacy:metadata:local_intelliboard_ntf_pms'] = 'Intelliboard 事件通知動態參數表';
 $string['privacy:metadata:local_intelliboard_assign:userid'] = '記錄的用戶編號(ID)';
 $string['privacy:metadata:local_intelliboard_assign:rel'] = '記錄類型';
 $string['privacy:metadata:local_intelliboard_assign:type'] = 'Moodle實例類型';
 $string['privacy:metadata:local_intelliboard_assign:instance'] = '連接的Moodle實例ID';
 $string['privacy:metadata:local_intelliboard_assign:timecreated'] = '記錄時間戳';
 $string['privacy:metadata:local_intelliboard_reports:status'] = '報告狀態 - 已啟用/未啟用';
 $string['privacy:metadata:local_intelliboard_reports:name'] = '自定義報告名稱';
 $string['privacy:metadata:local_intelliboard_reports:sqlcode'] = 'BASE64編碼的SQL代碼';
 $string['privacy:metadata:local_intelliboard_reports:timecreated'] = '創建時間';
 $string['privacy:metadata:local_intelliboard_details:logid'] = '資料表ID [local_intelliboard_logs]';
 $string['privacy:metadata:local_intelliboard_details:visits'] = '每天的訪問次數，滑鼠點擊次數';
 $string['privacy:metadata:local_intelliboard_details:timespend'] = '每小時花費的時間';
 $string['privacy:metadata:local_intelliboard_details:timepoint'] = '小時';
 $string['privacy:metadata:local_intelliboard_logs:trackid'] = '資料表的ID [local_intelliboard_tracking]';
 $string['privacy:metadata:local_intelliboard_logs:visits'] = '每天的訪問次數，滑鼠點擊次數';
 $string['privacy:metadata:local_intelliboard_logs:timespend'] = '每日的花費時間';
 $string['privacy:metadata:local_intelliboard_logs:timepoint'] = '一年中的一天的時間戳';
 $string['privacy:metadata:local_intelliboard_totals:sessions'] = 'Moodle中用戶的連線總數';
 $string['privacy:metadata:local_intelliboard_totals:courses'] = 'Moodle的所有課程';
 $string['privacy:metadata:local_intelliboard_totals:visits'] = 'Moodle中所有用戶的總訪問量';
 $string['privacy:metadata:local_intelliboard_totals:timespend'] = 'Moodle中所有用戶的總花費時間';
 $string['privacy:metadata:local_intelliboard_totals:timepoint'] = '一年中的一天的時間戳';
 $string['privacy:metadata:local_intelliboard_tracking:userid'] = '訪問Moodle頁面的用戶編號(ID)。';
 $string['privacy:metadata:local_intelliboard_tracking:courseid'] = '用戶訪問的課程編號';
 $string['privacy:metadata:local_intelliboard_tracking:page'] = '頁面類型 [course,module,profile,site]';
 $string['privacy:metadata:local_intelliboard_tracking:param'] = '頁面編號類型';
 $string['privacy:metadata:local_intelliboard_tracking:visits'] = '用戶訪問頁面';
 $string['privacy:metadata:local_intelliboard_tracking:timespend'] = '用戶在頁面上花費的時間';
 $string['privacy:metadata:local_intelliboard_tracking:firstaccess'] = '用戶首次訪問時間';
 $string['privacy:metadata:local_intelliboard_tracking:lastaccess'] = '用戶最後訪問時間';
 $string['privacy:metadata:local_intelliboard_tracking:useragent'] = '用戶瀏覽器類型';
 $string['privacy:metadata:local_intelliboard_tracking:useros'] = '用戶作業系統';
 $string['privacy:metadata:local_intelliboard_tracking:userlang'] = '用戶使用的瀏覽器語系';
 $string['privacy:metadata:local_intelliboard_tracking:userip'] = '用戶最後登錄的IP位址';
 $string['privacy:metadata:local_intelliboard_ntf:id'] = '事件通知編號';
 $string['privacy:metadata:local_intelliboard_ntf:type'] = '事件通知類型';
 $string['privacy:metadata:local_intelliboard_ntf:externalid'] = '事件通知外部NID';
 $string['privacy:metadata:local_intelliboard_ntf:userid'] = '事件通知外部AppID';
 $string['privacy:metadata:local_intelliboard_ntf:email'] = '事件通知的電子郵件';
 $string['privacy:metadata:local_intelliboard_ntf:cc'] = '事件通知副本';
 $string['privacy:metadata:local_intelliboard_ntf:subject'] = '事件通知標題';
 $string['privacy:metadata:local_intelliboard_ntf:message'] = '事件通知內容';
 $string['privacy:metadata:local_intelliboard_ntf:state'] = '事件通知狀態';
 $string['privacy:metadata:local_intelliboard_ntf:attachment'] = '事件通知附件';
 $string['privacy:metadata:local_intelliboard_ntf:tags'] = '事件通知標記';
 $string['privacy:metadata:local_intelliboard_ntf_hst:id'] = '事件通知歷史紀錄編號';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationid'] = '事件通知編號';
 $string['privacy:metadata:local_intelliboard_ntf_hst:userid'] = '事件通知外部AppID';
 $string['privacy:metadata:local_intelliboard_ntf_hst:notificationname'] = '事件通知名稱';
 $string['privacy:metadata:local_intelliboard_ntf_hst:email'] = '事件通知歷史郵件';
 $string['privacy:metadata:local_intelliboard_ntf_hst:timesent'] = '事件通知歷史時間';
 $string['select_manager_role'] = '選擇管理員角色';
 $string['group_aggregation'] = '群組聚合';
 $string['ssodomain'] = '子網域 SSO';
 $string['ssodomain_desc'] = '使用分開的伺服器/帳戶進行單一登錄';
 $string['instructor_redirect'] = '教師重新導向';
 $string['student_redirect'] = '學生重新導向';
 $string['myorders'] = '訂單';
 $string['myseats'] = '授權';
 $string['mywaitlist'] = '等候名單';
 $string['mysubscriptions'] = '訂閱';
 $string['seatscode'] = '授權代碼';
 $string['numberofseats'] = '授權數';
 $string['downloadinvoice'] = '下載發票';
 $string['product'] = '產品';
 $string['key'] = 'Key';
 $string['created'] = '建立時間';
 $string['seatnumber'] = '授權數量';
 $string['seatsused'] = '已使用授權';
 $string['details'] = '詳細內容';
 $string['username'] = '帳號';
 $string['used'] = '已使用';
 $string['status'] = '狀態';
 $string['subscriptiondate'] = '訂閱日期';
 $string['price'] = '價格';
 $string['recurringperiod'] = '重複週期';
 $string['billingcycles'] = '帳單週期';
 $string['active'] = '啟用';
 $string['suspended'] = '已暫停';
 $string['canceled'] = '取消';
 $string['expired'] = '已過期';
 $string['process'] = '過程';
 $string['cancel_subscription'] = '取消訂閱';
 $string['sqlreport'] = 'SQL報告';
 $string['sqlreportcreate'] = '建立報告';
 $string['sqlreports'] = 'SQL報告';
 $string['sqlreportname'] = '報表名稱';
 $string['sqlreportcode'] = 'SQL';
 $string['sqlreportdate'] = '建立時間';
 $string['sqlreportactive'] = '已啟用';
 $string['sqlreportinactive'] = '已停用';
 $string['remove_message'] = 'SQL報告已被刪除';
 $string['delete_message'] = '確定要刪除SQL報告？';
 $string['success_message'] = 'SQL報告已經保存';
 $string['scale_percentage_round'] = '百分比四捨五入';
 $string['instructor_show_suspended_enrollments'] = '顯示已暫停的選課';
 $string['instructor_hide_suspended_enrollments'] = 'Hide suspended enrollments';
 // BigBlueButton meetings
 $string['bbbapiendpoint'] = 'BBB API端點';
 $string['bbbserversecret'] = 'BBB 伺服器金鑰';
 $string['check_active_meetings'] = '查看進行中的會議';
 $string['bbbmeetings'] = 'BigBlueButton會議';
 $string['enablebbbmeetings'] = '啟用監看BigBlueButton會議';
 $string['enablebbbdebug'] = 'BigBlueButton 除錯模式';
 $string['privacy:metadata:local_intelliboard_bbb_meet'] = 'BigBlueButton會議日誌';
 $string['privacy:metadata:local_intelliboard_bbb_meet:id'] = '會議日誌編號';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingname'] = '會議名稱';
 $string['privacy:metadata:local_intelliboard_bbb_meet:meetingid'] = '會議編號';
 $string['privacy:metadata:local_intelliboard_bbb_meet:internalmeetingid'] = '內部（在BBB服務器中）會議編號';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createtime'] = '創建時間 (時間戳)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:createdate'] = '創建日期 (字串)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voicebridge'] = '語音橋接的分機號（連接到電話系統時使用）';
 $string['privacy:metadata:local_intelliboard_bbb_meet:dialnumber'] = '參與者可以使用普通電話撥打的撥號接入號碼。';
 $string['privacy:metadata:local_intelliboard_bbb_meet:attendeepw'] = '參與者加入會議所需的密碼';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorpw'] = '主持人加入會議或進行某些管理操作所需的密碼';
 $string['privacy:metadata:local_intelliboard_bbb_meet:running'] = '會議狀態 (進行中|已停止)';
 $string['privacy:metadata:local_intelliboard_bbb_meet:duration'] = '會議時間';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasuserjoined'] = '旗標。加入會議的用戶';
 $string['privacy:metadata:local_intelliboard_bbb_meet:recording'] = '旗標。會議將被記錄';
 $string['privacy:metadata:local_intelliboard_bbb_meet:hasbeenforciblyended'] = '旗標。會議被強制結束';
 $string['privacy:metadata:local_intelliboard_bbb_meet:starttime'] = '會議開始時間';
 $string['privacy:metadata:local_intelliboard_bbb_meet:endtime'] = '會議結束時間';
 $string['privacy:metadata:local_intelliboard_bbb_meet:participantcount'] = '參加人數';
 $string['privacy:metadata:local_intelliboard_bbb_meet:listenercount'] = '聽眾人數';
 $string['privacy:metadata:local_intelliboard_bbb_meet:voiceparticipantcount'] = '有連接麥克風的參與者人數';
 $string['privacy:metadata:local_intelliboard_bbb_meet:videocount'] = '有連接攝影機的參與者人數';
 $string['privacy:metadata:local_intelliboard_bbb_meet:maxusers'] = '參加人數上限';
 $string['privacy:metadata:local_intelliboard_bbb_meet:moderatorcount'] = '主持人人數';
 $string['privacy:metadata:local_intelliboard_bbb_meet:courseid'] = '課程編號';
 $string['privacy:metadata:local_intelliboard_bbb_meet:cmid'] = '課程模組編號';
 $string['privacy:metadata:local_intelliboard_bbb_meet:bigbluebuttonbnid'] = 'BigBlueButtonbn資料表的ID';
 $string['privacy:metadata:local_intelliboard_bbb_meet:ownerid'] = '擁有者編號（創建會議的用戶）';
 $string['privacy:metadata:local_intelliboard_bbb_atten'] = '記錄BigBlueButton會議的參與者';
 $string['privacy:metadata:local_intelliboard_bbb_atten:id'] = '出席者ID';
 $string['privacy:metadata:local_intelliboard_bbb_atten:userid'] = '用戶ID (User資料表的ID)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:fullname'] = '參與會議人員的全名';
 $string['privacy:metadata:local_intelliboard_bbb_atten:role'] = '會議參與者的角色';
 $string['privacy:metadata:local_intelliboard_bbb_atten:ispresenter'] = '旗標。參與者為主持人';
 $string['privacy:metadata:local_intelliboard_bbb_atten:islisteningonly'] = '旗標。沒有連接麥克風或網路攝影機的參與人員';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasjoinedvoice'] = '旗標。 已連接麥克風的參與人員';
 $string['privacy:metadata:local_intelliboard_bbb_atten:hasvideo'] = '旗標。已連接網路攝影機的參與人員';
 $string['privacy:metadata:local_intelliboard_bbb_atten:meetingid'] = '會議編號 (BigBlueButton伺服器中的編號)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:localmeetingid'] = '會議編號 (在local_intelliboard_bbb_meet資料表中的編號)';
 $string['privacy:metadata:local_intelliboard_bbb_atten:arrivaltime'] = '用戶連接會議的時間';
 $string['privacy:metadata:local_intelliboard_bbb_atten:departuretime'] = '用戶斷開會議的時間';
 $string['messageprovider:intelliboard_notification'] = "Intelliboard 事件通知";
 $string['privacy:metadata:local_intelliboard_bb_partic'] = '協作課程參與者名單';
 $string['privacy:metadata:local_intelliboard_bb_partic:id'] = '參與課程的ID';
 $string['privacy:metadata:local_intelliboard_bb_partic:sessionuid'] = '課程UUID';
 $string['privacy:metadata:local_intelliboard_bb_partic:useruid'] = '用戶UUID (BlackBoard協作服務)';
 $string['privacy:metadata:local_intelliboard_bb_partic:external_user_id'] = '用戶ID (Moodle)';
 $string['privacy:metadata:local_intelliboard_bb_partic:role'] = '課程角色';
 $string['privacy:metadata:local_intelliboard_bb_partic:display_name'] = '用戶名稱';
 $string['privacy:metadata:local_intelliboard_bb_partic:first_join_time'] = '首次參加課程時間';
 $string['privacy:metadata:local_intelliboard_bb_partic:last_left_time'] = '最後離開課程時間';
 $string['privacy:metadata:local_intelliboard_bb_partic:duration'] = '課程花費時間';
 $string['privacy:metadata:local_intelliboard_bb_partic:rejoins'] = '重新加入課程的次數';
 $string['privacy:metadata:local_intelliboard_bb_trck_m'] = '追蹤的課程清單';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:id'] = '追蹤日誌ID';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:sessionuid'] = '課程 UUID';
 $string['privacy:metadata:local_intelliboard_bb_trck_m:track_time'] = '追蹤時間';
 $string['privacy:metadata:local_intelliboard_att_sync'] = '已同步的課程清單';
 $string['privacy:metadata:local_intelliboard_att_sync:id'] = '同步日誌ID';
 $string['privacy:metadata:local_intelliboard_att_sync:type'] = '課程';
 $string['privacy:metadata:local_intelliboard_att_sync:instance'] = 'Moodle連線ID';
 $string['privacy:metadata:local_intelliboard_att_sync:data'] = '額外的同步數據';
 $string['verifypeer'] = "CURLOPT SSL VERIFYPEER";
 $string['verifypeer_desc'] = "此選項判斷curl是否驗證對等方證書的真實性。";
 $string['verifyhost'] = "CURLOPT SSL VERIFYHOST";
 $string['verifyhost_desc'] = "此選項判斷libcurl是否驗證伺服器憑證是為它所知道的服務器準備的。";
 $string['cipherlist'] = "CURLOPT SSL CIPHER LIST";
 $string['cipherlist_desc'] = "指定TLS使用的密碼";
 $string['sslversion'] = "CURLOPT SSLVERSION";
 $string['sslversion_desc'] = "傳遞long參數來控制要使用的SSL/TLS版本版本範圍";
 $string['debug'] = "CURL 請求除錯";
 $string['debug_desc'] = "";
 /* IntelliCart */
 $string['intellicart'] = "IntelliCart整合";
 $string['intellicart_desc'] = "允許學生查看IntelliCart報告。";
 $string['coursessessionspage'] = "課程時段頁面";
 $string['coursessessions'] = "課程時段";
 $string['session_name'] = "課程時段名稱";
 $string['session_time'] = "課程時段時間";
 $string['return_to_sessions'] = "返回課程時段";
 $string['intellicart_student_integration'] = '與我的學習報表整合';
 $string['intellicart_instructor_integration'] = '與課程管理報表整合';
 $string['intellicart_app_reports_integration'] = '與IntelliBoard報告整合';
 /* IntelliCart END*/
 $string['allmod'] = "所有學習活動";
 $string['customod'] = "自定義學習活動";
 $string['timespent'] = "------ 花費時間 ----";
 $string['inprogress'] = "進行中";
 $string['notstarted'] = "尚未開始";
 $string['modulename'] = "模組名稱";
 $string['viewed'] = "已瀏覽";
 $string['course'] = "課程名稱";
 $string['courseaverage'] = "課程平均";
 $string['mygrade'] = "我的成績";
 $string['myprogress'] = "我的成績進展";
 $string['instructor_course_shortname'] = "顯示課程簡稱而不是課程全名";
 $string['trackmedia'] = "追蹤HTML5媒體";
 $string['trackmedia_desc'] = "追蹤HTML5影片和音訊";
 $string['ianalytics'] = 'IntelliBoard分析';
 $string['instructor_course_visibility'] = '顯示[教師]隱藏/暫停的課程';
 $string['instructor_mode'] = '顯示[教師]所有可用的課程';
 $string['instructor_mode_access'] = '顯示[教師]有[更新]權限的所有可用課程';
 $string['student_course_visibility'] = '顯示[學生]隱藏/暫停的課程';
 $string['support_text1'] = "您所有的Moodle數據：簡單、可共享、可理解並有吸引力。IntelliBoard是一個Moodle外掛，可將<strong> 120+ </strong>個報告和圖表分析置於您的手中。";
 $string['support_text2'] = "您所有的Moodle數據：簡單、可共享、可理解並有吸引力。IntelliBoard是您的Moodle報告和分析解決方案，可為您提供120多種報告和分析，幫助您制定教育工作決策。";
 $string['support_info1'] = "您可以加入我們的 <a target='_blank' href='https://intelliboard.net/events'>網路研討會</a> ，我們將帶您瀏覽IntelliBoard 5.0報告和分析！";
 $string['support_info2'] = "加入我們的 <a target='_blank' href='https://intelliboard.net/events'>網路研討會</a>，或安排一次您個人的數據之旅。有了我們世界級的支持和服務，您將以全新的視角看到您的學習平台。";
 $string['support_terms'] = "版權所有。";
 $string['support_page'] = "文件審查";
 $string['support_demo'] = "安排展示";
 $string['support_trial'] = "連接與升級";
 $string['support_close'] = "關閉";
 $string['instructor_custom_groups'] = "教師自定群組";
 // settings of tables
 $string['table_set_icg'] = '教師課程';
 $string['table_set_icg_c1'] = '課程名稱';
 $string['table_set_icg_c2'] = '課程簡稱';
 $string['table_set_icg_c3'] = '課程類別';
 $string['table_set_icg_c4'] = '已選課/已完成的學員';
 $string['table_set_icg_c5'] = '課程平均分數';
 $string['table_set_icg_c6'] = '章節';
 $string['table_set_icg_c7'] = '學習活動/資源';
 $string['table_set_icg_c8'] = '訪問次數';
 $string['table_set_icg_c9'] = '花費時間';
 $string['table_set_icg_c11'] = '動作 – 學習活動';
 $string['table_set_icg_c12'] = '動作 – 學員';
 $string['percentage_completed_learners'] = '已完成學生百分比';
 $string['avg_visits_per_stud'] = '學生平均訪問次數';
 $string['avg_time_spent_per_stud'] = '學生平均花費時間';
 $string['table_set_ilg'] = '教師課程 > 學員';
 $string['table_set_ilg_c1'] = '學員名稱';
 $string['table_set_ilg_c2'] = '電子郵件地址';
 $string['table_set_ilg_c3'] = '已選課';
 $string['table_set_ilg_c4'] = '最後訪問時間';
 $string['table_set_ilg_c5'] = '狀態';
 $string['table_set_ilg_c6'] = '成績';
 $string['table_set_ilg_c7'] = '完成的學習活動/資源';
 $string['table_set_ilg_c8'] = '訪問次數';
 $string['table_set_ilg_c9'] = '花費時間';
 $string['table_set_ilg_c10'] = '動作';
 $string['table_set_ilg1'] = '教師課程 > 學員 > 成績';
 $string['table_set_ilg1_c1'] = '學習活動名稱';
 $string['table_set_ilg1_c2'] = '類型';
 $string['table_set_ilg1_c3'] = '成績';
 $string['table_set_ilg1_c4'] = '評分';
 $string['table_set_ilg1_c5'] = '狀態';
 $string['table_set_ilg1_c6'] = '訪問次數';
 $string['table_set_ilg1_c7'] = '花費時間';
 $string['table_set_iag'] = '教師課程 > 學習活動';
 $string['table_set_iag_c1'] = '學習活動名稱';
 $string['table_set_iag_c2'] = '類型';
 $string['table_set_iag_c3'] = '已完成學員';
 $string['table_set_iag_c4'] = '平均成績';
 $string['table_set_iag_c5'] = '訪問次數';
 $string['table_set_iag_c6'] = '花費時間';
 $string['table_set_iag_c7'] = '動作';
 $string['table_set_iag1'] = '教師課程 > 學習活動 > 成績';
 $string['table_set_iag1_c1'] = '學員名稱';
 $string['table_set_iag1_c2'] = '電子郵件地址';
 $string['table_set_iag1_c3'] = '狀態';
 $string['table_set_iag1_c4'] = '成績';
 $string['table_set_iag1_c5'] = '評分';
 $string['table_set_iag1_c6'] = '訪問次數';
 $string['table_set_iag1_c7'] = '花費時間';
 $string['student_grades'] = '學生成績';
 $string['grid_view'] = '網格視圖';
 $string['list_view'] = '列表顯示';
 $string['grade_activities_overview'] = '評分活動總覽';
 $string['activity'] = '學習活動名稱';
 $string['date_format'] = '日期格式';
 $string['user_enrollments_sessions_completion'] = '用戶「選課、連線、完成度」圖表';
 $string['user_site_summary_detail'] = '用戶概要';
 $string['course_enrollment_types'] = '課程選課類型';
 $string['user_map'] = '用戶地圖';
 $string['course_enrollments_with_completion_overview'] = '課程完成概況';
 $string['all_modules'] = '所有模組';

 /* Attendance */
 $string['attendance'] = '出缺席紀錄';
 $string['enableattendance'] = '啟用出缺席紀錄';
 $string['attendancetoolurl'] = '工具網址';
 $string['attendanceconsumerkey'] = '客戶端密鑰';
 $string['attendancesharedsecret'] = '共享金鑰';
 $string['sync_data_with_attendance'] = '同步出缺席紀錄數據';
 $string['attendanceapibase'] = '出缺席紀錄 API 基本路徑';
 $string['attendanceapikey'] = '出缺席紀錄 API 密鑰';
 $string['attendanceapisecret'] = '出缺席紀錄 API 金鑰';
 $string['enablesyncattendance'] = '啟用Blackboard Collaborate 課程與出缺席紀錄同步';
 /* BlackBoard Collaborate and InAttendance */
 $string['bb_col_meetings'] = 'BlackBoard Collaborate 會議';
 $string['enable_bb_col_debug'] = '啟用 BlackBoard Collaborate 除錯模式';
 $string['bb_col_api_endpoint'] = 'BlackBoard Collaborate API 端點';
 $string['bb_col_consumer_key'] = 'BlackBoard Collaborate 客戶端密鑰';
 $string['bb_col_secret'] = 'BlackBoard Collaborate 金鑰';
 $string['enable_bb_col_meetings'] = '啟用 BlackBoard Collaborate 會議';
 $string['check_active_bb_col_meetings'] = '查看活躍的 BlackBoard Collaborate 會議';
 $string['local_intelliboard_bb_collaborate_session_tracking_started'] = '開始追蹤的 BlackBoard 協作會話';
 $string['local_intelliboard_bb_collaborate_session_tracking_finished'] = '完成追蹤的 BlackBoard 協作會話';
 $string['local_intelliboard_bb_collaborate_api_request_finished'] = '完成的 BlackBoard 協作 API 請求';

/* Admin dashboard */
$string['admin_dashboard'] = '管理員儀表板';
$string['adm_dshb_user_enr_sess_compl_act_lvls'] = '用戶「選課、連線、完成度」圖表';
$string['adm_dshb_adm_dashb_totals'] = '總計';
$string['adm_dshb_user_site_summary_details'] = '用戶概要';
$string['adm_dshb_course_enrollments_types'] = '課程選課類型';
$string['adm_dshb_user_map'] = '用戶地圖';
$string['adm_dshb_user_enrol_with_compl_overview'] = '課程完成度概況';
$string['adm_dshb_report_user_status'] = 'Report User status';
$string['adm_dshb_report_activity_stats_summary'] = 'Report Activity Stats Summary';
$string['adm_dshb_report_quiz_activity_detail'] = 'Report Quiz Activity Detail';

$string['instructor_hide_need_help'] = '隱藏"需要幫助？"按鈕';
$string['names_order'] = '名稱順序';
$string['firstname_lastname'] = '{名字} {姓氏}';
$string['lastname_firstname'] = '{姓氏} {名字}';
$string['issuer'] = '發行人';
$string['criteria_method'] = '準則方法';
$string['criteria_all_courses'] = '必須完成以下所有課程';
$string['criteria_any_course'] = '必須完成以下任何一門課程';
$string['dashboard_settings'] = '儀表板設定';


$string['tracklogs'] = '依用戶追蹤時間 - 每日';
$string['trackdetails'] = '依用戶追蹤時間 - 每小時';
$string['tracktotals'] = '追蹤時間匯總 - 每日';

$string['enable_badges_report'] = '啟用"獎章"報告';
$string['sizemode'] = '規模大小: 大 ( > 5,000 個用戶)';
$string['cachedef_bb_collaborate_access_token'] = 'BlackBoard Collaborate 訪問許可(token)';


$string['learner_menu'] = '在導航塊菜單中顯示 "我的學習報表"，只對已選課的學員開放';
$string['learning_plan_filter'] = '學習計畫篩選器';
$string['learning_plan_viewer_role'] = '"學習計畫監看員"角色';
$string['all_cohorts'] = '所有群組';
$string['privacy_shield_policy'] = '數據處理附錄';
$string['privacy_policy'] = '隱私政策';
$string['confirm_and_sign_up'] = '確認並註冊';
$string['term_of_use'] = '使用條款';
$string['setup'] = '開始連接';
$string['protocol'] = '協定';
$string['rest'] = 'REST';
$string['soap'] = 'SOAP';
$string['next'] = '下一頁';
$string['terms_msg'] = '勾選此框，即表示您已經閱讀並同意我們的使用條款。';
$string['privacy_msg'] = '勾選此框，即表示您已閱讀並同意我們的隱私政策。';
$string['shield_msg'] = '勾選此框，即表示您已閱讀並同意我們的數據處理附錄。';
$string['enable_webservice'] = '啟用網路服務';
$string['you_need_to_enable_at_least_one_protocol'] = '您需要啟用至少一個協議';
$string['invalid_user'] = '無效的用戶';
$string['sign_in'] = '登入';
$string['email'] = '電子郵件';
$string['password'] = '密碼';
$string['all_fields_required'] = '所有欄位均為必填';
$string['server_error'] = '糟糕！發生了意外情況。請透過 support@intelliboard.net 與我們聯繫';
$string['country'] = '國家';
$string['please_accept_terms_and_conditions'] = '請接受條款和條件';
$string['congratulations_intb_register'] = '恭喜';
$string['congratulations_intb_register_msg'] = '感謝您開始使用 IntelliBoard 的15天免費試用版! 請檢查您的電子郵件以確認您的 IntelliBoard 帳戶。首先，請使用單一登錄 (SSO) 連結（如果已啟用），從網站管理 > IntelliBoard 或登錄 <a href="https://app.intelliboard.net/signin">此處</a>。 SSO 鏈接顯示為 "INTELLIBOARD.NET"，位於儀表板的右上角。如有疑問，請聯繫 Support@IntelliBoard.net。';
$string['sign_up'] = '註冊';
$string['sign_in'] = '登入';
$string['intelliboard_settings'] = 'IntelliBoard 設定';
$string['moodle_settings'] = 'Moodle 設定';
$string['email_is_required'] = '電子郵件為必填項目';
$string['invalid_email'] = '無效的電子郵件';
$string['intelliboard_terms'] = 'IntelliBoard 協議';
$string['authentication'] = '帳號創建';
$string['intb_settings_descr'] = "IntelliBoard 需要一個主要、唯一的訂閱電子郵件。請在下面輸入您希望用作訂閱的電子郵件信箱。該電子郵件必須在使用前通過電子郵件確認進行雙重驗證。如有疑問，請聯繫 <a href='mailto:Support@IntelliBoard.net'>Support@IntelliBoard.net</a>。有關 IntelliBoard 設置的完整列表，請轉到網站管理 > 外掛 > 本地端外掛 > IntelliBoard。";
$string['hosting_provider'] = '託管服務商';
$string['self_hosted'] = '自行託管';

// date formats
$string['mysqlweek'] = '%Y, week %v';
$string['mysqlmonthyear'] = '%M %Y';
$string['mysqlyear'] = '%Y';
$string['mysqlmonth'] = '%c';
$string['mysqlhour'] = '%h:%i %p';
$string['mysqlquarter'] = 'quarter';
$string['mysqldayshortmonthyear'] = '%d %b, %Y';
$string['mysqltimedate'] = '%h:%i%p, %d %b %Y';
$string['mysqldaymonth'] = '%d %b %Y';
$string['mysqlmonthyearday'] = '%M %Y, %d';
$string['mysqlmonthdayyear'] = '%m/%d/%Y';
$string['mysqltimemonthdayyear'] = '%H %m/%d/%Y';

$string['postgreweek'] = 'YYYY, "week" WW';
$string['postgremonthyear'] = 'Month YYYY';
$string['postgreyear'] = 'YYYY';
$string['postgremonth'] = 'MM';
$string['postgrehour'] = 'HH12:MI AM';
$string['postgrequarter'] = 'quarter';
$string['postgredayshortmonthyear'] = 'DD Mon, YYYY';
$string['postgretimedate'] = 'HH12:MIAM, DD Mon YYYY';
$string['postgredaymonth'] = 'DD Mon YYYY';
$string['postgremonthyearday'] = 'Month YYYY, DD';
$string['postgrequarteryear'] = 'Q YYYY';
$string['postgremonthdayyear'] = 'MM/DD/YYYY';
$string['postgretimemonthdayyear'] = 'HH24 MM/DD/YYYY';

// new strings
$string['report1_name'] = '學員狀態';
$string['report2_name'] = '課程統計';
$string['report3_name'] = '學習活動統計';
$string['report45_name'] = '測驗卷活動統計';
$string['report_activity_stats_summary'] = '學習活動統計概要';
$string['report_user_profile_information'] = '用戶個人資料';
$string['course_name'] = '課程名稱';
$string['course_short_name'] = '課程簡稱';
$string['course_idnumber'] = 'ID 號碼';
$string['course_status'] = '狀態';
$string['number_of_learners'] = '選課人數';
$string['number_of_modules'] = '學習活動數量';
$string['number_of_completed_learners'] = '已完成用戶數';
$string['number_of_visits'] = '訪問次數';
$string['num_completed_activity'] = '完成活動的用戶數';
$string['total_time_spent'] = '花費時間總計';
$string['date_created'] = '建立日期';
$string['initial_reports'] = 'Initial Reports初步報告';
$string['avg_score'] = '平均分數';
$string['first_access'] = '首次訪問';
$string['completion_not_enabled'] = '完成度追蹤未啟用';
$string['first_name'] = '名字';
$string['last_name'] = '姓氏';
$string['num_attempts'] = '嘗試次數';
$string['highest_grade'] = '最高成績';
$string['lowest_grade'] = '最低成績';
$string['initial_reports_warning'] = '要透過電子郵件發送、排程和進一步個人化這些報告，請點擊 “<a href="{$a}">連接和升級</a>”。';
$string['last_access'] = '最後訪問';
$string['enrolment_expiration'] = '選課截止日期';
$string['id_number'] = 'ID 號碼';
$string['telephone1'] = '電話 1';
$string['telephone2'] = '電話 2';
$string['institution'] = '院校/機構';
$string['department'] = '科系/部門';
$string['address'] = '地址';
$string['city'] = '城市/鄉鎮';
$string['enroled_on'] = '選課日期';

$string['dashboard_link'] = '點擊查看分析';
$string['support_connect'] = '點擊下方矩形內的報告按鈕。了解 IntelliBoard 的強大功能。一鍵瀏覽您的學習平台洞察力。想要了解更多？點擊 "點擊查看分析"。還想了解更多？ 在右上方<a href="{$a->connect_link}">"連接和升級"</a>，或您看到連結的任何位置。';
$string['support_text3'] = 'Thank you for installing IntelliBoard Lite!';
$string['support_text4'] = 'Meet an easy-to-use reporting and visualization platform that will help you achieve your retention, engagement, and compliance goals.';
$string['support_text6'] = '需要更多資訊？請點擊任何藍色按鈕與我們聯繫。';

$string['web_services_descr'] = 'IntelliBoard 需要啟用網路服務。 網路服務使其他系統（如 IntelliBoard）能夠訪問該學習平台系統並預先執行操作。為了安全起見，在不使用時應將其禁用。有關其他審查，請轉到網站管理 > 進階功能 > 網路服務。';
$string['protocol_descr'] = 'IntelliBoard 需要啟用 REST 或 SOAP 協議。為了安全起見，只應啟用正在使用的協議。有關其他審查，請轉到網站管理 > 外掛 > 網路服務 > 管理傳輸協定。';
$string['authorized_user_descr'] = 'IntelliBoard 需要一個授權用戶。授權用戶很可能是網站管理員，並且必須擁有管理網路服務、傳輸協定和通行憑證的權限。有關其他審查，請轉到網站管理 > 外掛 > 網路服務 > 外部服務 > IntelliBoard 服務 > 已授權的用戶。';
$string['email_subscr'] = '訂閱電子郵件信箱';
$string['protocols_descr'] = 'IntelliBoard 需要啟用 REST 或 SOAP 協議。為了安全起見，只應啟用正在使用的協議。有關其他審查，請轉到網站管理 > 外掛 > 網路服務 > 管理傳輸協定。';
$string['enable_time_tracking'] = '啟用時間追蹤';
$string['enable_time_tracking_descr'] = '啟用時間追蹤，以獲得更多關於使用者存取、瀏覽和花費時間的資訊。IntelliBoard 提供了與 Moodle 時間花費表不同的關於時間追蹤的其他洞察。';
$string['enable_sso'] = '啟用(SSO)單一登入連結';
$string['enable_sso_descr'] = '啟用網站管理員使用單一登入連結，進入app.IntelliBoard.net上的IntelliBoard SuperAdmin訪問權限';
$string['join_a_webinar'] = '參加網路研討會';
$string['review_support_doc'] = '查看支持文件';
$string['setup_subheading'] = '連接並體驗您數據的力量。無需信用卡、沒有義務。僅有15天的免費數據體驗。';

$string['instructor_courses_table_name'] = '課程成績';
$string['instructor_courses_table_name_learner'] = '課程 {$a->course}, 學員 {$a->learner}, 成績';
$string['instructor_courses_table_name_activity'] = '課程 {$a->course}, 學習活動 {$a->name}, 成績';
$string['instructor_courses_table_name_learners'] = '課程 {$a->fullname}, 學員';
$string['instructor_courses_table_name_activities'] = '課程 {$a->fullname}, 學習活動';

$string['successfull_connected'] = '連接成功';
$string['not_connected'] = '尚未連接';

$string['transcripts'] = '成績單';
$string['enable_transcripts'] = '啟用成績單';
$string['closed'] = '關閉';
$string['synctranscriptstask'] = '同步成績單任務';
$string['transcriptssyncrecordsnum'] = '成績單處理大小';
$string['transcriptssyncrecordsnum_desc'] = '一次處理的用戶選課記錄數量';
$string['privacy:metadata:local_intelliboard_trns_c'] = '成績單課程記錄';
$string['privacy:metadata:local_intelliboard_trns_c:userid'] = '用戶ID';
$string['privacy:metadata:local_intelliboard_trns_c:useremail'] = '用戶電子郵件';
$string['privacy:metadata:local_intelliboard_trns_c:firstname'] = '用戶名字';
$string['privacy:metadata:local_intelliboard_trns_c:lastname'] = '用戶姓氏';
$string['privacy:metadata:local_intelliboard_trns_c:userenrolid'] = '成績單用戶選課ID';
$string['privacy:metadata:local_intelliboard_trns_c:enrolid'] = '選課紀錄ID';
$string['privacy:metadata:local_intelliboard_trns_c:enroltype'] = '選課方式';
$string['privacy:metadata:local_intelliboard_trns_c:courseid'] = '課程編號';
$string['privacy:metadata:local_intelliboard_trns_c:coursename'] = '課程名稱';
$string['privacy:metadata:local_intelliboard_trns_c:enroldate'] = '選課日期';
$string['privacy:metadata:local_intelliboard_trns_c:unenroldate'] = '退選日期';
$string['privacy:metadata:local_intelliboard_trns_c:completeddate'] = '完成日期';
$string['privacy:metadata:local_intelliboard_trns_c:status'] = '成績單狀態';
$string['privacy:metadata:local_intelliboard_trns_c:gradeitemid'] = '成績項目ID';
$string['privacy:metadata:local_intelliboard_trns_c:gradeid'] = '成績編號';
$string['privacy:metadata:local_intelliboard_trns_c:grademax'] = '最高成績';
$string['privacy:metadata:local_intelliboard_trns_c:grademin'] = '最低成績';
$string['privacy:metadata:local_intelliboard_trns_c:finalgrade'] = '最後成績';
$string['privacy:metadata:local_intelliboard_trns_c:formattedgrade'] = '格式化成績';
$string['privacy:metadata:local_intelliboard_trns_c:rolesids'] = '用戶角色';
$string['privacy:metadata:local_intelliboard_trns_c:groupsids'] = '用戶群組';
$string['privacy:metadata:local_intelliboard_trns_c:timecreated'] = '建立記錄時的時間';
$string['privacy:metadata:local_intelliboard_trns_c:timemodified'] = '上次更新記錄的時間';
$string['privacy:metadata:local_intelliboard_trns_m'] = '成績單課程記錄';
$string['privacy:metadata:local_intelliboard_trns_m:userenrolid'] = '成績單用戶選課ID';
$string['privacy:metadata:local_intelliboard_trns_m:courseid'] = '課程ID';
$string['privacy:metadata:local_intelliboard_trns_m:userid'] = '用戶ID';
$string['privacy:metadata:local_intelliboard_trns_m:cmid'] = '課程模組ID';
$string['privacy:metadata:local_intelliboard_trns_m:moduleid'] = '模組ID';
$string['privacy:metadata:local_intelliboard_trns_m:modulename'] = '學習活動名稱';
$string['privacy:metadata:local_intelliboard_trns_m:moduletype'] = '模組類型';
$string['privacy:metadata:local_intelliboard_trns_m:startdate'] = '開始日期';
$string['privacy:metadata:local_intelliboard_trns_m:completeddate'] = '完成日期';
$string['privacy:metadata:local_intelliboard_trns_m:status'] = '狀態';
$string['privacy:metadata:local_intelliboard_trns_m:gradeitemid'] = '成績項目ID';
$string['privacy:metadata:local_intelliboard_trns_m:gradeid'] = '成績ID';
$string['privacy:metadata:local_intelliboard_trns_m:grademax'] = '最高成績';
$string['privacy:metadata:local_intelliboard_trns_m:grademin'] = '最低成績';
$string['privacy:metadata:local_intelliboard_trns_m:finalgrade'] = '最後成績';
$string['privacy:metadata:local_intelliboard_trns_m:formattedgrade'] = '格式化成績';
$string['privacy:metadata:local_intelliboard_trns_m:timecreated'] = '建立記錄時的時間';
$string['privacy:metadata:local_intelliboard_trns_m:timemodified'] = '上次更新記錄的時間';
$string['goal_grade'] = '目標成績';
$string['importtrackingtask'] = '匯入追蹤任務';
$string['compresstracking'] = '壓縮追蹤';
$string['compresstracking_desc'] = '將時間追蹤數據寫入檔案或Redis，並使用cron作業將數據傳輸到資料庫庫（預設值：每15分鐘一次）';
$string['cachedef_instructor_course_data'] = '課程數據快取';
$string['cachedef_reports_list'] = '報告列表快取';
$string['do_not_use_compresstracking'] = '不要使用壓縮追蹤';
$string['cache_compresstracking'] = '保存到Moodle快取';
$string['file_compresstracking'] = '保存到MoodleData';
$string['cachedef_tracking'] = 'Intelliboard追蹤數據';
$string['cachedef_track_config'] = 'Intelliboard追蹤總數據';
$string['coursecontainer_filter'] = 'Enable course container filter';
$string['enableexportcustomfont'] = '日本/中國兼容字體';
$string['all_selected'] = '全選';
$string['custommenuitem'] = 'Display in Custom Menu';
$string['support_text7'] = 'To get started with <strong>IntelliBoard Lite</strong>, please <a href="{$a->meeting_link}">schedule a consultation</a> with one of our learning analytics experts.';
$string['support_text8'] = 'If you have <strong>already purchased</strong> a license and see this screen, please contact your Account Manager for assistance.';
$string['support_text9'] = 'Need predictive models, notifications, and intervention tracking?';
$string['support_text10'] = 'Switch to <a href="{$a->intelliboard_pro_link}"><strong>IntelliBoard Pro</strong></a>';
$string['support_text11'] = '<a href="{$a->intelliboard_pro_onepager}">Click here</a> to download the IntelliBoard Pro one-pager.';
$string['enable_vendor_frontpage_course'] = 'Enable the frontpage course in the reports for vendors';
