<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace quizaccess_quilgo\local;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/mod/quiz/accessrule/quilgo/lib.php');

/**
 * Utility or helper class that ontains reusable simple logic
 * @package     quizaccess_quilgo
 * @copyright   2025 Native Platform Ltd <hello@quilgo.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class utils {
    /**
     * Build question pattern array steps
     * @param string $type
     * @return array
     */
    public static function build_pattern_array_steps($type) {
        $steps = [];
        if ($type == QUIZACCESS_QUILGO_PATTERN_TYPE_COPY_PASTE) {
            $steps = [
                get_string('report_patterns_step_copy_question', 'quizaccess_quilgo'),
                get_string('report_patterns_step_leave_test', 'quizaccess_quilgo'),
                get_string('report_patterns_step_return', 'quizaccess_quilgo'),
                get_string('report_patterns_step_paste_answer', 'quizaccess_quilgo'),
            ];
        } else if ($type == QUIZACCESS_QUILGO_PATTERN_TYPE_COPY_CHANGE) {
            $steps = [
                get_string('report_patterns_step_copy_question', 'quizaccess_quilgo'),
                get_string('report_patterns_step_leave_test', 'quizaccess_quilgo'),
                get_string('report_patterns_step_return', 'quizaccess_quilgo'),
                get_string('report_patterns_step_change_answer', 'quizaccess_quilgo'),
            ];
        }

        return $steps;
    }
}
