<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * English (en) language strings.
 *
 * @package    theme_adaptable
 * @copyright  2015-2019 Jeremy Hopkins (Coventry University)
 * @copyright  2015-2019 Fernando Acedo (3-bits.com)
 * @copyright  2017-2019 Manoj Solanki (Coventry University)
 * @copyright  2020 G J Barnard
 *               {@link https://moodle.org/user/profile.php?id=442195}
 *               {@link https://gjbarnard.co.uk}
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later.
 */

// phpcs:disable moodle.Files.LangFilesOrdering

// General.
$string['choosereadme'] = '<div class="clearfix">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
<h3>About</h3>
<p>Adaptable is a responsive and highly customizable theme based upon the popular BCU theme.  Boost is the parent theme, which in turn utilises the Bootstrap framework.</p>
<p>The theme is licensed under the GPL (GNU General Public License) version 3. You can find the full details \'<a href="https://www.gnu.org/licenses/gpl-3.0.html" target="_blank">here</a>\'.</p>
<br>
<h3>Credits</h3>
<p>This version of the theme has been developed by:<br>
G J Barnard (<a href="https://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).
</p>
<p>This theme has previously been developed by:<ul>
<li>Jeremy Hopkins (Coventry University).</li>
<li>Fernando Acedo (<a href="https://3-bits.com" target="_blank">3-bits.com</a>).</li>
<li>Manoj Solanki (Coventry University).</li>
</ul></p>
<h3>Other credits</h3>
<p>Collaborators for version 2:<ul>
<li>G J Barnard (<a href="https://moodle.org/user/profile.php?id=442195" target="_blank">moodle.org/user/profile.php?id=442195</a>).</li>
<li>Stuart Lamour.</li>
<li>Alistair Spark (University College London).</li>
</ul><p>amongst many other developers, testers, translators and volunteers (please see the <a href="adaptable/Readme.md" target="_blank">Readme.md</a> file).</p>
<br>
<h3>Reporting bugs</h3>
<p>You can report bugs and enhancements you wish to fund in our \'<a href="https://gitlab.com/jezhops/moodle-theme_adaptable/-/issues" target="_blank">repository</a>\'.</p>
<br>
<h3>Technical Support</h3>
<p>You can ask your questions on the moodle forum:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/view.php?id=46" target="_blank">Themes forum</a>.</li>
</ul>
</div>';

$string['pluginname'] = 'Adaptable';
$string['configtitle'] = 'Adaptable';
$string['configtabtitle'] = 'Settings';

$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['region-information'] = 'Information';
$string['side-post1'] = 'Side bar in footer';

$string['cachedef_adaptablefontawesomeiconmapping'] = 'Caches font awesome icons';

// Dashboard and Frontpage regions.
$string['region-frnt-market-a'] = 'Page region one';
$string['region-frnt-market-b'] = 'Page region two';
$string['region-frnt-market-c'] = 'Page region three';
$string['region-frnt-market-d'] = 'Page region four';
$string['region-frnt-market-e'] = 'Page region five';
$string['region-frnt-market-f'] = 'Page region six';
$string['region-frnt-market-g'] = 'Page region seven';
$string['region-frnt-market-h'] = 'Page region eight';
$string['region-frnt-market-i'] = 'Page region nine';
$string['region-frnt-market-j'] = 'Page region ten';
$string['region-frnt-market-k'] = 'Page region eleven';
$string['region-frnt-market-l'] = 'Page region twelve';
$string['region-frnt-market-m'] = 'Page region thirteen';
$string['region-frnt-market-n'] = 'Page region fourteen';
$string['region-frnt-market-o'] = 'Page region fifteen';
$string['region-frnt-market-p'] = 'Page region sixteen';
$string['region-frnt-market-q'] = 'Page region seventeen';
$string['region-frnt-market-r'] = 'Page region eighteen';
$string['region-frnt-market-s'] = 'Page region nineteen';
$string['region-frnt-market-t'] = 'Page region twenty';
$string['region-frnt-footer'] = 'Footer';
$string['frnt-footer'] = 'Blocks in this area will only be visible to admin users';

// Dashboard regions.
$string['region-content'] = 'Content';

// Course page block regions.
$string['region-course-top-a'] = 'Course page top region one';
$string['region-course-top-b'] = 'Course page top region two';
$string['region-course-top-c'] = 'Course page top region three';
$string['region-course-top-d'] = 'Course page top region four';

$string['region-news-slider-a'] = 'Course page slider region';

$string['region-course-section-a'] = 'Course page activity end bottom region';

$string['region-course-bottom-a'] = 'Course page bottom region five';
$string['region-course-bottom-b'] = 'Course page bottom region six';
$string['region-course-bottom-c'] = 'Course page bottom region seven';
$string['region-course-bottom-d'] = 'Course page bottom region eight';

$string['orphanedblock'] = '<em>ORPHANED BLOCK - Originally displays in: <strong>{$a}</strong></em>';

$string['skipblock'] = 'Skip block {$a}';

// Settings page headings ******************************************.
$string['settingsmaincolors'] = 'Main colours';
$string['settingsheadercolors'] = 'Header colours';
$string['settingsmobilecolors'] = 'Mobile colours';
$string['settingsinfoboxcolors'] = 'Info box colours';
$string['settingssecondinfoboxcolors'] = 'Second info box colours';
$string['settingsmarketingcolors'] = 'Marketing block colours';
$string['settingsoverlaycolors'] = 'Overlay tiles colours';
$string['settingsnavbarcolors'] = 'Navigation bar (navbar) colours';
$string['settingsalertbox'] = 'Alert box';
$string['settingsbreadcrumbcolors'] = 'Breadcrumb colours';
$string['settingsmessagescolors'] = 'Messages pop-up colours';
$string['settingsfootercolors'] = 'Footer colours';
$string['settingsfonts'] = 'Fonts';
$string['settingsanalytics'] = 'Analytics';
$string['settingsblocksconfiguration'] = 'Configuration';
$string['settingsborders'] = 'Borders';
$string['settingscolors'] = 'Colours';
$string['settingscourses'] = 'Courses';
$string['settingstopicsweeks'] = 'Topics / Weeks';
$string['settingsblockicons'] = 'Icons';

// Admin Settings Strings.
$string['settingspagealertsettings'] = 'Alerts';
$string['settingspageblocksettings'] = 'Block';
$string['coursepageblockregionsettings'] = 'Course page block region builder';
$string['dashboardblockregionsettings'] = 'Dashboard block region builder';
$string['settingspagefrontpageblockregionsettings'] = 'Frontpage block region builder';
$string['frontpageslidersettings'] = 'Frontpage slider';
$string['frontpagecoursesettings'] = 'Frontpage courses list';
$string['frontpagesettingsheading'] = 'Frontpage rendering';
$string['frontpagedesc'] = 'Configure the way that the course boxes are rendered on the frontpage.';
$string['frontpagerenderer'] = 'Frontpage course boxes';
$string['frontpagerendererdesc'] = 'Control the way that the course boxes on the front page are rendered.';
$string['frontpagerendereroption1'] = 'Tiles';
$string['frontpagerendereroption2'] = 'Tiles w/ overlay';
$string['frontpagerendereroption3'] = 'Moodle default';
$string['frontpagerendereroption4'] = 'Coventry tiles';
$string['frontpageblocksettings'] = 'Marketing blocks';
$string['settingspagegeneralsettings'] = 'General';
$string['informationblocksettings'] = 'Information blocks';
$string['newstickersettings'] = 'News ticker';

// Information.
$string['settingsinformation'] = 'Information';
$string['themesupportsponsorship'] = 'Support and sponsorship';
$string['themechanges'] = 'Changes';
$string['themereadme'] = 'Readme';

// Ticker.
$string['tickersettings'] = 'News ticker';
$string['tickersettingsheading'] = 'Setup news ticker';
$string['tickerdesc'] = 'Here you can set a news ticker to run across the of your Moodle site.
  It is intended as a less intrusive alternative to the slider taking up very little space.
  To setup your ticker simply enter a paragraph list and include any hyperlinks you need to in that text.
  <strong>Note:</strong> If your ticker does not load properly switch to HTML view and ensure you have only p tags:
  <pre>
  &lt;p&gt;News item one.....&lt;/p&gt;
  &lt;p&gt;News item two.....&lt;/p&gt;
  </pre>';

$string['tickerdefault'] = 'No news items to display';

$string['enableticker'] = 'Enable the news ticker on the homepage?';
$string['enabletickerdesc'] = 'Check to enable the homepage ticker.';

$string['enabletickermy'] = 'Enable the news ticker?';
$string['enabletickermydesc'] = 'Check to enable the ticker on the \'My Home\' / \'Dashboard\' pages.';

$string['enabletickerc'] = 'Enable the news ticker on internal pages?';
$string['enabletickercdesc'] = 'Check to enable the ticker on internal pages.';

$string['tickerheaderbackgroundcolour'] = 'News ticker header background colour';
$string['tickerheaderbackgroundcolourdesc'] = 'Set the backgound colour of the ticker header.';

$string['tickerheadertextcolour'] = 'News ticker header text colour';
$string['tickerheadertextcolourdesc'] = 'Set the text colour of the ticker header.';

$string['tickerconstainerbackgroundcolour'] = 'News ticker container background colour';
$string['tickerconstainerbackgroundcolourdesc'] = 'Set the backgound colour of the ticker container.';

$string['tickerconstainertextcolour'] = 'News ticker container text colour';
$string['tickerconstainertextcolourdesc'] = 'Set the text colour of the ticker container.';

$string['tickerwidth'] = 'News ticker width';
$string['tickerwidthdesc'] = 'You can use this setting to fix the news ticker at 100% width.';

$string['newstickercount'] = 'Number of news ticker sections';
$string['newstickercountdesc'] = 'Define multiple news ticker sections with access rules to target different audiences.';

$string['tickertext'] = 'News ticker text';
$string['tickertextdesc'] = 'Add news ticker text in list format.  See the read me for more info.';

$string['tickertextprofilefield'] = 'Custom Profile Field Name=Value (optional)';
$string['tickertextprofilefielddesc'] = 'Add access rule using for custom profile field eg: usertype=student';

$string['ticker'] = 'Announcements';

$string['tickerwidth'] = 'Fixed width';
$string['tickerfullscreen'] = 'Full view width';

// Slideshow.
$string['slideshowsettings'] = 'Slideshow';
$string['slideshowsettingsheading'] = 'Customize the carousel on the front page.';
$string['slideshowdesc'] = 'Upload the images, add the links and description for the carousel on the front page.';

$string['sliderimage'] = 'Slider picture';
$string['sliderimagedesc'] = 'Add an image for your slide.  The recommended size is 1600px x 400px or higher.';

$string['slidercaption'] = 'Slider caption';
$string['slidercaptiondesc'] = 'Add a caption for your slide';

$string['sliderurl'] = 'Slide link URL';
$string['sliderurldesc'] = 'Add a URL to which your slide links to when clicked.';

$string['slidermargintop'] = 'Margin above slider';
$string['slidermargintopdesc'] = 'Set the size of the margin above the slider.';

$string['slidermarginbottom'] = 'Margin below slider';
$string['slidermarginbottomdesc'] = 'Set the size of the margin below the slider.';

$string['sliderenabled'] = 'Enable slider';
$string['sliderenableddesc'] = 'Enable a slider at the top of your home page.';

$string['slidervisible'] = 'Show the slider when';
$string['slidervisibledesc'] = 'Show the slider when \'Logged out\', \'Logged in\' or \'Logged in or out\'.';
$string['slidervisibleloggedout'] = 'Logged out';
$string['slidervisibleloggedin'] = 'Logged in';
$string['slidervisibleloggedinout'] = 'Logged in or out';

$string['sliderfullscreen'] = 'Slider full view';
$string['sliderfullscreendesc'] = 'Check this box to make the slider full view (100% width).';

$string['slideroption2'] = 'Choose slider type';
$string['slideroption2desc'] = 'Choose slider type <strong>and then click SAVE</strong> to see colour settings for your chosen slider.';

$string['slidercount'] = 'Slider count';
$string['slidercountdesc'] = 'Select how many slides you want to add <strong>then click SAVE</strong> to load the input fields.';

$string['sliderh3color'] = 'Slider one H3 colour';
$string['sliderh3colordesc'] = 'Choose the colour you want for the slider one H3 tag.';

$string['sliderh4color'] = 'Slider one H4 colour';
$string['sliderh4colordesc'] = 'Choose the colour you want for the slider one H4 tag.';

$string['slidersubmitcolor'] = 'Slider one submit text';
$string['slidersubmitcolordesc'] = 'Choose the text colour of the Slider one submit button.';

$string['slidersubmitbgcolor'] = 'Slider one submit bg';
$string['slidersubmitbgcolordesc'] = 'Choose the background colour of the Slider one submit button.';

$string['slider2h3color'] = 'Slider two H3 text colour';
$string['slider2h3colordesc'] = 'Choose the text colour you want for the slider two H3 tag.';

$string['slider2h4color'] = 'Slider two H4 text colour';
$string['slider2h4colordesc'] = 'Choose the text colour you want for the slider two H4 tag.';

$string['slider2h3bgcolor'] = 'Slider two H3 bg colour';
$string['slider2h3bgcolordesc'] = 'Choose the background colour you want for the slider two H3 tag.';

$string['slider2h4bgcolor'] = 'Slider two H4 bg colour';
$string['slider2h4bgcolordesc'] = 'Choose the background colour you want for the slider two H4 tag.';

$string['slideroption2submitcolor'] = 'Slider two submit text';
$string['slideroption2submitcolordesc'] = 'Set a background colour for the submit text in slider style option two colour.';

$string['slideroption2color'] = 'Slider two submit bg';
$string['slideroption2colordesc'] = 'Set a background colour for the submit text in slider style option.';

$string['slideroption2a'] = 'Slider style option two arrow background colour';
$string['slideroption2adesc'] = 'Set the slider style option two arrow background colour';

$string['sliderstyle1'] = 'Slider style one';
$string['sliderstyle2'] = 'Slider style two';

// Block Regions.
$string['blocklayoutbuilder'] = 'Frontpage block regions';
$string['blocklayoutbuilderdesc'] = 'Below you can build your own layout for block regions on the front page.<br/>To add content these regions you will need to <strong> turn editing on on the front page of Moodle</strong>.<br/>Then you can begin to drag/drop blocks into the regions you create!';

$string['dashblocklayoutbuilder'] = 'Dashboard block regions';
$string['dashblocklayoutbuilderdesc'] = 'Below you can build your own layout for block regions on the dashboard page.<br/>To add content these regions you will need to <strong> turn editing on, on the dashboard page of Moodle</strong>.<br/>Then you can begin to drag/drop blocks into the regions you create!';

$string['coursepagesidebarinfooterenabledsection'] = 'Common settings';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Common settings for most of the course formats.';

$string['coursepageblocklayoutbuilder'] = 'Course page block regions';
$string['coursepageblocklayoutbuilderdesc'] = 'Below you can build your own layout for block regions on the course page.<br/>To add content these regions you will need to <strong> turn editing on, on the course page of Moodle</strong>.<br/>Then you can begin to drag/drop blocks into the regions you create!';

$string['blocklayoutlayoutcheck'] = 'Check your layout';
$string['blocklayoutlayoutcheckdesc'] = 'Use the tool below to check the number of blocks you have used and see a representation of your new layout.';
$string['blocklayoutlayoutcount1'] = 'You can set a maximum of ';
$string['blocklayoutlayoutcount2'] = ' block regions. You are currently using: ';

$string['blocklayoutlayoutrow'] = 'Block region row';
$string['blocklayoutlayoutrowdesc'] = 'Add / set layout for block region row on front page.';

$string['blockregioneditingtitleshown'] = 'Show the block region title when editing';
$string['blockregioneditingtitleshowndesc'] = 'You can show / hide the block region title when editing.';

$string['dashblocklayoutlayoutrow'] = 'Dashboard block region row ';
$string['dashblocklayoutlayoutrowdesc'] = 'Add / set layout for block region row on Dashboard page.';

$string['coursepageblocklayoutlayouttoprow'] = 'Course page block top region row ';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Add / set layout for block region row on Course page.';

$string['coursepageblocklayoutlayoutbottomrow'] = 'Course page block bottom region row ';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Add / set layout for block region row on the course page.';

$string['frontpageblocksenabled'] = 'Enable custom block region on front page';
$string['frontpageblocksenableddesc'] = 'You can enable / disable custom block regions on the front page.  You can then drag and drop blocks into the regions you created.';

$string['frontpageuserblocksenabled'] = 'Enable side-post block region on front page for users';
$string['frontpageuserblocksenableddesc'] = 'You can enable / disable the side-post block region on the front page for users.  Note: \'Users\' here means guest and authenticated users, Admins will always see the region.';

$string['dashblocksenabled'] = 'Enable custom block region on the \'Dashboard\' page';
$string['dashblocksenableddesc'] = 'You can enable / disable custom block regions on the \'Dashboard\' page.  You can then drag and drop blocks into the regions you created.';

$string['dashblocksposition'] = 'Custom block region position';
$string['dashblockspositiondesc'] = 'When custom block regions are enabled for the dashboard page, choose the position.';
$string['dashblocksabovecontent'] = 'Show above main content';
$string['dashblocksbelowcontent'] = 'Show below main content';

$string['coursepageblocksenabled'] = 'Enable custom block regions on the course page';
$string['coursepageblocksenableddesc'] = 'You can enable / disable custom block regions (top and bottom) on the Course page.  You can then drag and drop blocks into the regions you created.';

$string['coursepagenewssliderblockregionheading'] = 'Custom news slider block region';
$string['coursepagenewssliderblockregionheadingdesc'] = 'A custom block region designed for use with the news slider that is part of Adaptable UI.  This region appears above course activities on a Course page.  To add news slider block, first install the <strong><a href="{$a}" target="_blank">Adaptable UI news slider</a></strong> and configure it to appear in the region "course page slider region" on all course pages.';

$string['coursepageblocksliderenabled'] = 'Enable custom slider block region on Course page';
$string['coursepageblocksliderenableddesc'] = 'Enable this region on all course pages.';

$string['coursepageactivitybottomblockregionheading'] = 'Custom course activity bottom block region';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'A custom block region that appears after the end of activities.';

$string['coursepageblockactivitybottomenabled'] = 'Enable course activity bottom block region on course page';
$string['coursepageblockactivitybottomenableddesc'] = 'Enable this region on all course pages.';

$string['layoutcheck'] = 'Check your layout';
$string['layoutcheckdesc'] = 'Use the tool below to check the number of blocks you have used and see a representation of your new layout.';
$string['layoutcount1'] = 'You can set a maximum of ';
$string['layoutcount2'] = ' block regions. You are currently using: ';

$string['sidebaricon'] = 'Show / hide the sidebar';

// Flexible blocks.
$string['flexibleblocksoverflow'] = 'Overflow';

// Information Blocks.
$string['informationsettingsheading'] = 'Customize the information block region that appears on the front page.';
$string['informationsettingsdesc'] = 'There is a layout builder allowing you to decide how many blocks you need and define your own layout.<br>Please see the \'Readme\' section on the \'Information\' settings tab for additional information.';

$string['informationblocksenabled'] = 'Enable information blocks';
$string['informationblocksenableddesc'] = 'Set the information blocks in the frontpage.';
$string['informationblocksvisible'] = 'Show the information blocks when';
$string['informationblocksvisibledesc'] = 'Show the information blocks when \'Logged out\', \'Logged in\' or \'Logged in or out\'.';
$string['informationblocksvisibleloggedout'] = 'Logged out';
$string['informationblocksvisibleloggedin'] = 'Logged in';
$string['informationblocksvisibleloggedinout'] = 'Logged in or out';

$string['informationblocksbuilderheading'] = 'Information block layout builder';
$string['informationblocksbuilderdesc'] = 'Use the tool below to setup your information blocks.  Once defined the blocks will follow the layout when editing is off and window width is greater than 575 px.  Overflow will always be four blocks per row.';

$string['informationblockslayoutrow'] = 'Information block row';
$string['informationblockslayoutrowdesc'] = 'Add / set the layout for this information block row on front page.';

// Marketing Blocks & Info Box.
$string['marketingsettings'] = 'Marketing blocks';
$string['marketingsettingsheading'] = 'Customize the marketing blocks that appear on the front page.';
$string['marketingdesc'] = 'There are two full width info boxes with differing styles you can use.<br>In addition to this there is a layout builder allowing you to decide how many blocks you need and define your own layout.<br>Please see the \'Readme\' section on the \'Information\' settings tab for additional information.';

$string['marketingvisible'] = 'Show the marketing blocks when';
$string['marketingvisibledesc'] = 'Show the marketing blocks when \'Logged out\', \'Logged in\' or \'Logged in or out\'.';
$string['marketingvisibleloggedout'] = 'Logged out';
$string['marketingvisibleloggedin'] = 'Logged in';
$string['marketingvisibleloggedinout'] = 'Logged in or out';

$string['marketingbuilderheading'] = 'Marketing block layout builder - deprecated, please transition to using the Information block region';
$string['marketingbuilderdesc'] = 'Use the tool below to setup your marketing blocks. Once defined the block settings will appear further down the page.';

$string['marketlayoutrow'] = 'Marketing block row';
$string['marketlayoutrowdesc'] = 'Add / set layout for marketing block row on front page';

$string['market'] = 'Marketing block ';
$string['marketdesc'] = 'Add html for marketing block.  Please see the \'Readme\' section on the \'Information\' settings tab for additional information.';

$string['layoutaddcontent'] = 'Happy with your layout?  Now add content to your blocks:';
$string['layoutaddcontentdesc1'] = 'You have configured ';
$string['layoutaddcontentdesc2'] = ' blocks. If you are happy with this layout add content to the blocks below.<br>If you are not happy use the layout builder above to make changes.';

$string['marketingdeprecated'] = 'Marketing blocks are deprecated, please migrate to using the Information block region.';

$string['infobox'] = 'Frontpage info box';
$string['infoboxdesc'] = 'Frontpage info block HTML.  Please see the \'Readme\' section on the \'Information\' settings tab for additional information.<br><strong>Note: </strong><i>This element is only used for compatibility with BCU and will be removed in coming versions.</i>';

$string['infoboxfullscreen'] = 'Make infobox full view';
$string['infoboxfullscreendesc'] = 'Turning this option on will make the infobox full view.';

$string['infobox2'] = 'Frontpage secondary info box';
$string['infobox2desc'] = 'Frontpage secondary info box.  Please see the \'Readme\' section on the \'Information\' settings tab for additional information.<br><strong>Note: </strong><i>This element is only used for compatibility with BCU and will be removed in coming versions.</i>';

$string['frontpagemarketenabled'] = 'Enable marketing blocks - deprecated, please transition to using the Information block region';
$string['frontpagemarketenableddesc'] = 'Set the marketing blocks in the frontpage.';

$string['frontpagemarketoption'] = 'Choose style for marketing blocks';
$string['frontpagemarketoptiondesc'] = 'You can apply different styles to marketing blocks.
Note: BCU style is designed to work with images at top of block.';

$string['bcustyle'] = 'BCU style';
$string['coventrystyle'] = 'Coventry style';
$string['nostyle'] = 'No style';
$string['disabled'] = 'Disabled';
$string['expandable'] = 'Expandable';
$string['static'] = 'Static';

// Footer.
$string['footersettings'] = 'Footer';
$string['footersettingsheading'] = 'Set the content that should appear in the footer.';

$string['footerdesc'] = 'Control the content that appears in the 4 footer sections of the page.';

$string['showfooterblocks'] = 'Show footer blocks';
$string['showfooterblocksdesc'] = 'Show / hide the configurable footer blocks.';

$string['footerblocksplacement'] = 'Footer blocks placement ';
$string['footerblocksplacementdesc'] = 'Control where the upper footer blocks are displayed. Sitewide is default.';
$string['footerblocksplacement1'] = 'Sitewide';
$string['footerblocksplacement2'] = 'Homepage only';
$string['footerblocksplacement3'] = 'Never';

$string['footerlayoutrow'] = 'Footer layout builder';
$string['footerlayoutrowdesc'] = 'Design your layout for footer block regions.';

$string['footerbuilderheading'] = 'Footer block layout builder';
$string['footerbuilderdesc'] = 'Use the tool below to setup your footer blocks.  Once defined the blocks will follow the layout when editing is off and window width is greater than 575 px.  Overflow will always be four blocks per row.';

$string['footnote'] = 'Footnote';
$string['footnotedesc'] = 'Add text to the footer.';

$string['footerheader'] = 'Footer title section';
$string['footerdesc'] = 'Add a title for footer section.';

$string['footercontent'] = 'Footer content section';
$string['footercontentdesc'] = 'Add content to footer section.';

$string['hidefootersocial'] = 'Show social icons';
$string['hidefootersocialdesc'] = 'Show social icons in the footer below the blocks.';

// Data Retention Summary Button.
$string['gdprbutton'] = 'Data retention summary button';
$string['gdprbuttondesc'] = 'Display the data retention summary button in the footer.';

// Moodle Docs link.
$string['moodledocs'] = 'Moodle docs link';
$string['moodledocsdesc'] = 'Display the Moodle docs link in the footer.';

// NavBar.
$string['stickynavbar'] = 'Sticky navbar at the top';
$string['stickynavbardesc'] = 'Stick the navbar at the top of the view when scrolling down.';

$string['navbarcachetime'] = 'Navbar cache time';
$string['navbarcachetimedesc'] = 'The number of minutes the navigation bar is cached for.';

$string['navbarsettings'] = 'Navbar';
$string['navbarsettingsheading'] = 'Customize the navigation bar';
$string['navbardesc'] = 'Allows you to control all of the elements that appear on the navigation bar.';

$string['navbarstyles'] = 'Navbar styles';
$string['navbarstylesheading'] = 'Customize the navigation bar styles';
$string['navbarstylesdesc'] = 'Allows you to control the styles of the elements that appear on the navigation bar.';

$string['navbarlinkssettings'] = 'Navbar links';
$string['navbarlinksettingsheading'] = 'Customize the links on the navigation bar';
$string['navbarlinksettingsdesc'] = 'Allows you to control the links that appear on the navigation bar.';

$string['navbardisplayicons'] = 'Display icons';
$string['navbardisplayiconsdesc'] = 'Display an icon next to the menu title.  Note: This is ignored when \'custommenutitle\' isn\'t set for the custom menu.';

$string['navbardisplaytitles'] = 'Display titles';
$string['navbardisplaytitlesdesc'] = 'Display the menu title.  Notes: Ignored when \'navbardisplayicons\' is unset and also ignored when \'custommenutitle\' isn\'t set for the custom menu.';

$string['navbardisplaymenuarrow'] = 'Display menu arrow';
$string['navbardisplaymenuarrowdesc'] = 'Display menu arrow (downward facing) for a menu title.';

$string['home'] = 'Home';
$string['enablemy'] = 'Dashboard';
$string['enablemydesc'] = 'Display a link to the Dashboard page.';

$string['enableprofile'] = 'User profile';
$string['enableprofiledesc'] = 'Display a link to the users profile.';

$string['enableeditprofile'] = 'Edit profile';
$string['enableeditprofiledesc'] = 'Display a link to edit the users profile.';

$string['enablebadges'] = 'Badges';
$string['enablebadgesdesc'] = 'Display a link to the users badges.';

$string['enablegrades'] = 'Grades';
$string['enablegradesdesc'] = 'Display a link to the users grades.';

$string['enablecalendar'] = 'User calendar';
$string['enablecalendardesc'] = 'Display a link to the users calendar.';

$string['enableprivatefiles'] = 'Private files';
$string['enableprivatefilesdesc'] = 'Display a link to the users private files.';

$string['enablepref'] = 'My preferences';
$string['enableprefdesc'] = 'Display a link to the user preferences page.';

$string['enablenote'] = 'My notifications';
$string['enablenotedesc'] = 'Display a link to the user notifications page.';

$string['enableblog'] = 'Enable my blogs';
$string['enableblogdesc'] = 'Display a link to the users blogs page.';

$string['enableposts'] = 'My posts';
$string['enablepostsdesc'] = 'Display a link to the my posts page.';

$string['enablefeed'] = 'My feedback';
$string['enablefeeddesc'] = 'Display a link to the users "My Feedback" page - Note:  This requires the \'<a href="{$a}" target="_blank">My Feedback Plugin</a>\'.';

$string['enableaccesstool'] = 'Accessibility tool';
$string['enableaccesstooldesc'] = 'Display a link to the users "Accessibility Tool" preferences page - Note:  This requires the \'<a href="{$a}" target="_blank">Accessibility Tool Plugin</a>\'.';

$string['myblogs'] = 'My blogs';

$string['noenrolments'] = 'No enrolments found.';

$string['enableeventsdesc'] = 'Display a link to the calendar.';

$string['enablethiscoursedesc'] = 'Display a dropdown with activities from the current course.';
$string['enablecoursesectionsdesc'] = 'Display a sub-menu on the \'This course\' menu containing links to each shown section.';
$string['sections'] = 'Sections';

$string['enablecompetencieslink'] = 'Competencies link';
$string['enablecompetencieslinkdesc'] = 'Display competencies link in the \'This course\' menu.  Note: \'core_competency|enabled\' needs to be ticked.';

$string['togglenavigation'] = 'Toggle navigation';

$string['custommenu'] = 'Custom';

// Navbar styling.
$string['navbardropdownborderradius'] = 'Dropdown menu border radius';
$string['navbardropdownborderradiusdesc'] = 'Controls the border radius for dropdown menus (e.g. rounded corners).';
$string['navbardropdownhovercolor'] = 'Dropdown menu background hover colour';
$string['navbardropdownhovercolordesc'] = 'Dropdown menu background colour when hovering over menu items.';
$string['navbardropdowntextcolor'] = 'Dropdown menu text colour';
$string['navbardropdowntextcolordesc'] = 'Dropdown menu item text colour.';
$string['navbardropdowntexthovercolor'] = 'Dropdown menu text hover colour';
$string['navbardropdowntexthovercolordesc'] = 'Dropdown menu text colour when hovering over menu items.';
$string['navbardropdowntransitiontime'] = 'Navbar transition time';
$string['navbardropdowntransitiontimedesc'] = 'Navbar transition effect time in seconds.  Provides a fade-in animation effect when hovering over a menu that has sub-menus.';

// This Course menu.
$string['headernavbarthiscourseheading'] = 'This Course Menu';
$string['headernavbarthiscourseheadingdesc'] = 'In this menu the student can access directly all the course activities and the participants list and their grades.';

$string['displayparticipants'] = 'Display participants';
$string['displayparticipantsdesc'] = 'Display the participants item in the menu.';
$string['displaygrades'] = 'Display grades';
$string['displaygradesdesc'] = 'Display the grades item in the menu.';

// My courses menu.
$string['navbarmycourses'] = 'Navbar my courses';
$string['headernavbarmycoursesheading'] = 'My courses menu';
$string['headernavbarmycoursesheadingdesc'] = 'All options for the \'My courses\' (\'My sites\') menu option that displays list of current user\'s courses.';

$string['enablemysitesdesc'] = 'Display a dropdown with a users courses';

$string['enablemysitesrestriction'] = 'Restrict user\'s courses dropdown to a custom profile field';
$string['enablemysitesrestrictiondesc'] = 'Restrict dropdown with a user\'s courses by custom profile field. E.g. usertype=staff.';

$string['mysitessortoverride'] = 'My courses custom sort';
$string['mysitessortoverridedesc'] = 'Use custom profile fields or generic strings (year etc) to collapse past courses in sub menu.';
$string['mysitessortoverridefield'] = 'My Courses Custom Profile Field(s) or Strings';
$string['mysitessortoverridefielddesc'] = 'Comma delimited list of profile fields or strings to check for in course short codes.';

$string['enableusermysitessortoverride'] = 'Enable user my courses custom sort';
$string['enableusermysitessortoverridedesc'] = 'Allow the user to set their own value for \'My courses custom sort\', including defaulting to the theme setting value set by \'mysitessortoverride\'.';

$string['mysitessortoverrideoff'] = 'Display all enrolled courses in single flat list';
$string['mysitessortoverridestrings'] = 'Display enrolled containing strings in first list, others in sub menu';
$string['mysitessortoverrideprofilefields'] = 'Display courses found in profile fields in first list, others in sub menu';
$string['mysitessortoverrideprofilefieldscohort'] = 'Display courses found in profile fields + cohorts in first list, others in sub menu';
$string['mysitessortoverridemyoverview'] = 'Use list from my overview';
$string['mysitessortoverridelast'] = 'Last accessed time or enrolment start time if never accessed';

$string['mysitesmaxlength'] = 'My courses max length';
$string['mysitesmaxlengthdesc'] = 'Adjust the max length of coursenames in the My Courses dropdown to optimise for your font.';

$string['mycoursesmenulimit'] = 'My courses menu limit';
$string['mycoursesmenulimitdesc'] = 'Adjust the max number of courses that appear in the My Courses dropdown. 0 will show all courses.';

$string['mysitesmenudisplay'] = 'My courses menu display';
$string['mysitesmenudisplaydesc'] = 'Choose what text to display for a menu item and on hover.';
$string['mysitesmenudisplayshortcodenohover'] = 'Show short code and no text on hover.';
$string['mysitesmenudisplayshortcodefullnameonhover'] = 'Show short code and full course name on hover.';
$string['mysitesmenudisplayfullnamenohover'] = 'Show full course title and no text on hover.';
$string['mysitesmenudisplayfullnamefullnameonhover'] = 'Show full course title and full title on hover.';

$string['enablehomedesc'] = 'Display a link to the frontpage.';

$string['enablehomeredirect'] = 'Enable home redirect=0';
$string['enablehomeredirectdesc'] = 'Enable redirect=0 on home.  This is for use on sites where where My Home is default homepage. It prevents users clicking the Home link from being redirected back to \'My Home\' / \'Dashboard\'.';

$string['chiddenicon'] = 'My courses hidden icon';
$string['chiddenicondesc'] = 'The Font Awesome icon without the prefixing \'fa-\' to be used for hidden courses.  If empty, the default will be used.';
$string['cfrozenicon'] = 'My courses frozen icon';
$string['cfrozenicondesc'] = 'The Font Awesome icon without the prefixing \'fa-\' to be used for frozen courses.  If empty, the default will be used.';
$string['cneveraccessedicon'] = 'My courses never accessed icon';
$string['cneveraccessedicondesc'] = 'The Font Awesome icon without the prefixing \'fa-\' to be used for courses that the user is enrolled on but not accessed.  If empty, the default will be used.';
$string['cdefaulticon'] = 'My courses default icon';
$string['cdefaulticondesc'] = 'The Font Awesome icon without the prefixing \'fa-\' to be used for courses when they don\'t already have an icon.  If empty, the default will be used.';

// Colours.
$string['colorsettings'] = 'Colours';
$string['colorsettingsheading'] = 'Modify the main colours used throughout the theme.';
$string['colordesc'] = 'You can select the colours that you would like to use throughout the theme. Use Hex or any other standard notation. As an alternate option you can use transparent and inherited as a value.';
$string['linkcolor'] = 'Link colour';
$string['linkcolordesc'] = 'Set the colour of links in the theme, use html hex code.';

$string['linkhover'] = 'Link hover colour';
$string['linkhoverdesc'] = 'Set the colour of links (on hover) in the theme, use html hex code.';

$string['dimmedtextcolor'] = 'Dimmed text colour';
$string['dimmedtextcolordesc'] = 'The dimmed text CSS class (dimmed_text) is used by Moodle to indicate when something is disabled / not visible.  To set that colour in the theme, use html hex code.';

$string['backcolor'] = 'Background colour';
$string['backcolordesc'] = 'Set the background colour.';

$string['primarycolour'] = 'Primary colour';
$string['primarycolourdesc'] = 'Set the primary colour.  This is the Bootstrap \'primary\' colour that is used within the SCSS.';

$string['secondarycolour'] = 'Secondary colour';
$string['secondarycolourdesc'] = 'Set the secondary colour.  This is the Bootstrap \'secondary\' colour that is used within the SCSS.';

$string['regionmaincolor'] = 'Main region colour';
$string['regionmaincolordesc'] = 'Set the background colour for main content area.';

$string['regionmaintextcolor'] = 'Main region text colour';
$string['regionmaintextcolordesc'] = 'Set the text colour for main content area.';

$string['maincolor'] = 'Main colour';
$string['maincolordesc'] = 'Set the main colour.';

$string['fontcolor'] = 'Main font colour';
$string['fontcolordesc'] = 'Set the colour of the font in the theme, use html hex code.';

$string['footertextcolor'] = 'Footer text colour';
$string['footertextcolordesc'] = 'The colour of the text in the footer, use html hex code.';

$string['footerbkcolor'] = 'Footer background colour';
$string['footerbkcolordesc'] = 'Set the footer background colour.';

$string['footertextcolor2'] = 'Lower footer text colour';
$string['footertextcolor2desc'] = 'Lower footer text colour.';

$string['footerlinkcolor'] = 'Footer blocks link colour';
$string['footerlinkcolordesc'] = 'Footer blocks link colour.';

$string['headerbkcolor'] = 'Top header background colour';
$string['headerbkcolordesc'] = 'Set the top header background colour.';

$string['notbadgecolour'] = 'Notifications badge colour';
$string['notbadgecolourdesc'] = 'Set the colour for the notifications badge / bubble in the header (displays number of unread notifications)';

$string['notbadgebackgroundcolour'] = 'Notifications badge background colour';
$string['notbadgebackgroundcolourdesc'] = 'Set the background colour for the notifications badge / bubble in the header (displays number of unread notifications)';

$string['messagingbackgroundcolor'] = 'Messages main window background colour';
$string['messagingbackgroundcolordesc'] = 'Set the background colour for the messages main chat window.';

$string['headerbkcolor2'] = 'Lower header background colour';
$string['headerbkcolor2desc'] = 'Set the lower header background colour.  Note that this also sets the colour for the background in Header style 2.';

$string['headertextcolor'] = 'Header text and link colour';
$string['headertextcolordesc'] = 'Set the header text and link colour.';

$string['headertextcolor2'] = 'Bottom header text colour';
$string['headertextcolor2desc'] = 'Set the bottom header text colour.';

$string['blockheadercolor'] = 'Block header font colour';
$string['blockheadercolordesc'] = 'Set the block header font colour.';

$string['blockbackgroundcolor'] = 'Block background colour';
$string['blockbackgroundcolordesc'] = 'Set the background colour for all blocks.';

$string['blockheaderbackgroundcolor'] = 'Block heading background colour';
$string['blockheaderbackgroundcolordesc'] = 'Set the heading background colour for all blocks.';

$string['blockbordercolor'] = 'Block border colour';
$string['blockbordercolordesc'] = 'Set the block border colour.';

$string['blockregionbackground'] = 'Block region backround colour';
$string['blockregionbackgrounddesc'] = 'Background colour of the container holding custom block layouts on the front page.';

$string['blockheaderbordertop'] = 'Block header top border thickness';
$string['blockheaderbordertopdesc'] = 'Set the thickness of the top border of block headers.';

$string['blockheaderborderleft'] = 'Block header left border thickness';
$string['blockheaderborderleftdesc'] = 'Set the thickness of the left hand border of block headers.';

$string['blockheaderborderright'] = 'Block header right border thickness';
$string['blockheaderborderrightdesc'] = 'Set the thickness of the right hand border of block headers.';

$string['blockheaderborderbottom'] = 'Block header bottom border thickness';
$string['blockheaderborderbottomdesc'] = 'Set the thickness of the bottom border of block headers.';

$string['blockmainbordertop'] = 'Block main top border thickness';
$string['blockmainbordertopdesc'] = 'Set the thickness of the top border of the main block area.';

$string['blockmainborderleft'] = 'Block main left border thickness';
$string['blockmainborderleftdesc'] = 'Set the thickness of the left hand border of the main block area.';

$string['blockmainborderright'] = 'Block main right border thickness';
$string['blockmainborderrightdesc'] = 'Set the thickness of the right hand border of the main block area.';

$string['blockmainborderbottom'] = 'Block main bottom border thickness';
$string['blockmainborderbottomdesc'] = 'Set the thickness of the bottom border of the main block area.';

$string['blockheaderbordertopstyle'] = 'Block header border style';
$string['blockheaderbordertopstyledesc'] = 'Set the style of the border of block headers.';

$string['blockmainbordertopstyle'] = 'Block main border style';
$string['blockmainbordertopstyledesc'] = 'Set the style of the border of block content area.';

$string['blockheadertopradius'] = 'Block header top radius';
$string['blockheadertopradiusdesc'] = 'Set the radius of top header block to achieve a curved / rounded effect.';

$string['blockheaderbottomradius'] = 'Block header bottom radius';
$string['blockheaderbottomradiusdesc'] = 'Set the radius of bottom header block to achieve a curved / rounded effect.';

$string['blockmaintopradius'] = 'Block main top radius';
$string['blockmaintopradiusdesc'] = 'Set the top radius of main block area to achieve a curved / rounded effect.';

$string['blockmainbottomradius'] = 'Block main bottom radius';
$string['blockmainbottomradiusdesc'] = 'Set the bottom radius of main block area to achieve a curved / rounded effect.';

$string['marketblockbordercolor'] = 'Marketing block border line colour';
$string['marketblockbordercolordesc'] = 'Set the marketing block border line colour.';

$string['marketblocksbackgroundcolor'] = 'Marketing blocks region background colour';
$string['marketblocksbackgroundcolordesc'] = 'Set the Marketing blocks region background colour.';

$string['sectionheadingcolor'] = 'Section heading text colour';
$string['sectionheadingcolordesc'] = 'Set the colour for section headings text.';

$string['collapsedtopicscoloursenabled'] = 'Collapsed Topics toggle fore and backgound colour settings';
$string['collapsedtopicscoloursenableddesc'] = 'Use Collapsed Topics fore and bacground colour settings instead of Adaptable\'s \'sectionheadingcolor\' and \'coursesectionheaderbg\' settings.';

$string['homebk'] = 'Frontpage background image';
$string['homebkdesc'] = 'Upload an image that will be a background image on the homepage.';

$string['editonbk'] = 'Editing and customise this page button background';
$string['editonbkdesc'] = 'Set the background colour for the editing and customize this page button.';

$string['editoffbk'] = 'Editing and customize this page \'Off\' button background';
$string['editoffbkdesc'] = 'Set the background colour for the editing and customize this page button in \'Off\' state.';

$string['dividingline'] = 'Dividing line in header';
$string['dividinglinedesc'] = 'The colour for the dividing line found in the header.';

$string['dividingline2'] = 'Dividing line in footer';
$string['dividingline2desc'] = 'The colour for the dividing line found in the footer.';

$string['breadcrumbbackgroundcolor'] = 'Breadcrumb background colour';
$string['breadcrumbbackgroundcolordesc'] = 'Set the background colour of the breadcrumb.';

$string['breadcrumbtextcolor'] = 'Breadcrumb text colour';
$string['breadcrumbtextcolordesc'] = 'Set the text colour of the breadcrumb.';

$string['activebreadcrumb'] = 'Active breadcrumb background colour';
$string['activebreadcrumbdesc'] = 'Set the background colour of the active breadcrumb colour, and remainder of the breadcrumb bar.';

$string['messagepopupbackground'] = 'Messages pop-up background colour';
$string['messagepopupbackgrounddesc'] = 'Set the background colour of messages pop-up header.';

$string['messagepopupcolor'] = 'Messages pop-up text colour';
$string['messagepopupcolordesc'] = 'Set the text colour of messages pop-up header.';

$string['menubkcolor'] = 'Main menu background colour';
$string['menubkcolordesc'] = 'Set a main menu background colour.';

$string['menubkhovercolor'] = 'Main menu background hover colour';
$string['menubkhovercolordesc'] = 'Set a main menu background hover colour.';

$string['menufontcolor'] = 'Main menu font colour';
$string['menufontcolordesc'] = 'Set a main menu font colour.';

$string['menufonthovercolor'] = 'Main menu hover colour';
$string['menufonthovercolordesc'] = 'Set a main menu hover colour.';

$string['menubordercolor'] = 'Main menu bottom border colour';
$string['menubordercolordesc'] = 'Set a main menu border bottom colour.';

$string['mobilemenubkcolor'] = 'Mobile menu background colour';
$string['mobilemenubkcolordesc'] = 'Set the main menu background colour on mobile devices (collapsed).';

$string['selectiontext'] = 'Selection text colour';
$string['selectiontextdesc'] = 'Set the text colour when a text is selected.';

$string['selectionbackground'] = 'Selection background colour';
$string['selectionbackgrounddesc'] = 'Set the background colour when a text is selected.';

// Courses.
$string['coursesettings'] = 'Courses';
$string['coursesettingsheading'] = 'Course settings';
$string['coursesettingsdesc'] = 'Customize the courses.';

$string['coursepagesidebarinfooterenabled'] = 'Move sidebar to footer on Course page';
$string['coursepagesidebarinfooterenableddesc'] = 'Wide course page layout by moving sidebar to footer.';

$string['courseactivitynavigationenabled'] = 'Activity navigation';
$string['courseactivitynavigationenableddesc'] = 'Activity navigation enabled.';

// Course Section background color.
$string['coursesectionbgcolor'] = 'Course section background';
$string['coursesectionbgcolordesc'] = 'Set the background colour of the course section.';

// Topics / Weeks Settings.
$string['topicsweeks'] = 'Topics / Weeks course format';
$string['topicsweeksdesc'] = 'Set styles for the \'Topics\' / \'Weeks\' course format.';

$string['coursesectionheaderbg'] = 'Course section header background';
$string['coursesectionheaderbgdesc'] = 'Set the background colour of the course section headers.';

$string['currentcolor'] = 'Current course section highlight colour';
$string['currentcolordesc'] = 'Set the colour for the current course section highlight.';

$string['coursesectionheaderborderstyle'] = 'Course section header border style';
$string['coursesectionheaderborderstyledesc'] = 'Set the style of the course section header border (only bottom border is used as outer container also has a border).';

$string['coursesectionheaderbordercolor'] = 'Course section header border colour';
$string['coursesectionheaderbordercolordesc'] = 'Set the colour of the course section header border (only bottom border is used as outer container also has a border).';

$string['coursesectionheaderborderwidth'] = 'Course section header border width';
$string['coursesectionheaderborderwidthdesc'] = 'Set the width of the course section header border (only bottom border is used as outer container also has a border).';

$string['coursesectionheaderborderradiustop'] = 'Course header section border radius top';
$string['coursesectionheaderborderradiustopdesc'] = 'Set the top radius of course section header borders (rounded corners).';

$string['coursesectionheaderborderradiusbottom'] = 'Course header section border radius bottom';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Set the bottom radius of course section header borders (rounded corners).';

$string['coursesectionborderstyle'] = 'Course section border style';
$string['coursesectionborderstyledesc'] = 'Set the border style of course sections.';

$string['coursesectionborderwidth'] = 'Course section border width';
$string['coursesectionborderwidthdesc'] = 'Set the width of course section borders.';

$string['coursesectionbordercolor'] = 'Course section border colour';
$string['coursesectionbordercolordesc'] = 'Set the border colour of course sections.';

$string['coursesectionborderradius'] = 'Course section border radius';
$string['coursesectionborderradiusdesc'] = 'Set the radius of course section borders (rounded corners).';

$string['coursesectionactivityiconsize'] = 'Course section activity icon size';
$string['coursesectionactivityiconsizedesc'] = 'Set the icon size for activities / resources (e.g. a value of 16px will set it at 16px by 16px).';

$string['coursesectionactivityheadingcolour'] = 'Course section activity heading colour';
$string['coursesectionactivityheadingcolourdesc'] = 'The colour for clickable activities displayed on the course homepage.';

// These four settings actually refer to bottom border (it was originally all around border, but naming kept as it was originally).
$string['coursesectionactivityborderwidth'] = 'Course section activity bottom border width';
$string['coursesectionactivityborderwidthdesc'] = 'Set width of the border that appears at the bottom of a course section activity.';
$string['coursesectionactivityborderstyle'] = 'Course section activity bottom border style';
$string['coursesectionactivityborderstyledesc'] = 'Set the style of the course section activity bottom border.';
$string['coursesectionactivitybordercolor'] = 'Course section activity bottom border colour ';
$string['coursesectionactivitybordercolordesc'] = 'Set the colour of the course section activity bottom border.';
$string['coursesectionactivityleftborderwidth'] = 'Course section activity left border width';
$string['coursesectionactivityleftborderwidthdesc'] = 'Set width of the border that appears on the left of a course section activity.';

$string['coursesectionactivitycolors'] = 'Course section activity options';

$string['coursesectionactivityassignleftbordercolor'] = 'Assignment activity left border display colour';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Set the colour of the left border.';
$string['coursesectionactivityassignbgcolor'] = 'Assignment activity background colour';
$string['coursesectionactivityassignbgcolordesc'] = 'Set the Assignment activity background colour.  Type <strong>transparent</strong> in the box for transparency.';

$string['coursesectionactivityforumleftbordercolor'] = 'Forum activity left border display colour';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Set the colour of the left border.';
$string['coursesectionactivityforumbgcolor'] = 'Forum activity background colour';
$string['coursesectionactivityforumbgcolordesc'] = 'Set the forum activity background colour.  Type <strong>transparent</strong> in the box for transparency.';

$string['coursesectionactivityquizleftbordercolor'] = 'Quiz activity left border display colour';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Set the colour of the left border.';
$string['coursesectionactivityquizbgcolor'] = 'Quiz activity background colour';
$string['coursesectionactivityquizbgcolordesc'] = 'Set the quiz activity background colour.  Type <strong>transparent</strong> in the box for transparency.';

// Course Index.
$string['courseindexsettings'] = 'Course index';
$string['courseindexsettingsheading'] = 'Course index settings';
$string['courseindexsettingsdesc'] = 'Customize the Course index.';

$string['courseindexenabled'] = 'Enabled';
$string['courseindexenableddesc'] = 'Enable or disable the \'Course Index\'.';

$string['courseindexitemcolor'] = 'Item colour';
$string['courseindexitemcolordesc'] = 'The item colour on the \'Course Index\' in a course.';
$string['courseindexitemhovercolor'] = 'Item hover colour';
$string['courseindexitemhovercolordesc'] = 'The item hover colour on the \'Course Index\' in a course.';

$string['courseindexpageitemcolor'] = 'Page item colour';
$string['courseindexpageitemcolordesc'] = 'The page item colour on the \'Course Index\' in a course.';
$string['courseindexpageitembgcolor'] = 'Page item background colour';
$string['courseindexpageitembgcolordesc'] = 'The page item background colour on the \'Course Index\' in a course.';

// One Topic Settings.
$string['onetopicheading'] = 'One Topic';
$string['onetopicdesc'] = 'Customise the appearance of the \'<a href="{$a}" target="_blank">One Topic Course Format</a>\' (if in use on your site).';

$string['onetopicactivetabbackgroundcolor'] = 'Active tab background colour';
$string['onetopicactivetabbackgroundcolordesc'] = 'The background colour of the active tab on a \'One Topic\' course.';

$string['onetopicactivetabtextcolor'] = 'Active tab text colour';
$string['onetopicactivetabtextcolordesc'] = 'The text colour of the active tab on a \'One Topic\' course.';

// Blocks General.
$string['shownavigationblockoncoursepage'] = 'Show navigation block on course page';
$string['shownavigationblockoncoursepagedesc'] = 'Set this to show the navigation block on the course page.';

// Fonts.
$string['fontsettings'] = 'Fonts';
$string['fontsettingsheading'] = 'Modify the fonts used throughout the theme.';
$string['fontdesc'] = 'You can select the fonts that you would like to use throughout the theme.';

$string['fontdefault'] = 'Default';

$string['fav'] = 'FontAwesome 6 Free';
$string['favdesc'] = 'Use the themes version of FontAwesome 6 Free for icons.  Note: Please see the license in the fonts folder of the theme.';
$string['favoff'] = 'Core FontAwesome 6 Free version';
$string['fa6name'] = 'Theme FontAwesome 6 Free version';
$string['faiv'] = 'FontAwesome Free v4 shims';
$string['faivdesc'] = 'When using the themes FontAwesome 6 Free for the icons add support for version 4 icon class names.';

$string['googlefonts'] = 'Google fonts';
$string['googlefontsdesc'] = 'Enable <a href="{$a}" target="_blank">Google Fonts</a> for the font names you stipulate except for \'Default\'.  When \'disabled\', you have the opportunity to serve the fonts yourself through CSS / theme modification or have them already installed on the users devices.  When \'enabled\' select the subset needed (latin is always included) and enter the right font weight or the font will not displayed.  <b>NOTE: Adaptable is GPLv3 licensed and may contain bugs, please verify for yourself that when disabled that Google fonts are not being used!</b>';

$string['fontname'] = 'Main font';
$string['fontnamedesc'] = 'Select the main font for the site.';

$string['fontsize'] = 'Main font size';
$string['fontsizedesc'] = 'Select the default font size (in percentage) used in the whole site.';

$string['fontheadername'] = 'Headers font';
$string['fontheadernamedesc'] = 'Select the font used in the text and blocks headers.';

$string['fontheadercolor'] = 'Headers font colour';
$string['fontheadercolordesc'] = 'Set the colour of the headers font in the theme, use html hex code.';

$string['fontweight'] = 'Main font weight';
$string['fontweightdesc'] = 'Font weight used in site.  Select a value from 100 to 900 depending on the font selected.';

$string['fontheaderweight'] = 'Headers font weight';
$string['fontheaderweightdesc'] = 'Headers font weight used in the site.  Select a value from 100 to 900 depending on the font selected.';

$string['fonttitlename'] = 'Site / Course title font';
$string['fonttitlenamedesc'] = 'Select the font used in the site and course titles.';

$string['fonttitlecolor'] = 'Site / course title font colour';
$string['fonttitlecolordesc'] = 'Set the colour of the site title and course title font in the theme, use html hex code.';

$string['fonttitleweight'] = 'Site / course title font weight';
$string['fonttitleweightdesc'] = 'Set the font weight used in the site title and course titles.  Select a value from 100 to 900 depending the font selected.';

$string['fonttitlesize'] = 'Site / course title font size';
$string['fonttitlesizedesc'] = 'Site title and course title font size used in site.  Select a value fron the list.';

$string['fonttitlecolorcourse'] = 'Course title font colour';
$string['fonttitlecolorcoursedesc'] = 'Set the colour of the course title font in the theme, use html hex code.';

$string['fontsubset'] = 'Google fonts subset';
$string['fontsubsetdesc'] = 'Select other character subset than latin to be applied to all the fonts.  Latin subset is already included by default.';

$string['menufontsize'] = 'Font size for navigation bar';
$string['menufontsizedesc'] = 'Set the size of the font used in the main navigation bar.';

$string['menufontpadding'] = 'Padding for navigation items';
$string['menufontpaddingdesc'] = 'Set the padding of the items in the main navigation bar.';

$string['fontblockheadercolor'] = 'Blocks header font colour';
$string['fontblockheadercolordesc'] = 'Set the colour of the header font moodle blocks, use html hex code. Note that this affects icon colour too.';

$string['fontblockheaderweight'] = 'Blocks header font weight';
$string['fontblockheaderweightdesc'] = 'Set the font weight used in the moodle blocks header.  Select a value from 100 to 900 depending the font selected.';

$string['fontblockheadersize'] = 'Blocks header font size';
$string['fontblockheadersizedesc'] = 'Set the font size used in the moodle blocks header.  Select a value fron the list.';

// Icons.
$string['blockicons'] = 'Block icons';
$string['blockiconsdesc'] = 'Set this to show block icons in the block header area.';

$string['blockiconsheadersize'] = 'Blocks header icon size';
$string['blockiconsheadersizedesc'] = 'Set the font icon size used in the moodle blocks header.  Select a value fron the list.';

// Buttons.
$string['buttonsettings'] = 'Buttons';
$string['buttonsettingsheading'] = 'Customize the buttons of this theme.';
$string['buttondesc'] = 'Alter the appearance of buttons used in this theme.';

$string['buttonradius'] = 'Set the button radius';
$string['buttonradiusdesc'] = 'Higher radius = curved buttons, lower radius = square buttons.';

$string['buttoncolor'] = 'Button colour';
$string['buttoncolordesc'] = 'The colour of the main buttons used throughout the site.';

$string['buttontextcolor'] = 'Button text colour';
$string['buttontextcolordesc'] = 'The colour of text used on buttons.';

$string['buttonhovercolor'] = 'Button background hover colour';
$string['buttonhovercolordesc'] = 'The colour that the button background changes to when hovering over the button.';

$string['buttontexthovercolor'] = 'Button text hover colour';
$string['buttontexthovercolordesc'] = 'The colour that the button text changes to when hovering over the button.';

$string['buttonfocuscolour'] = 'Button focus background colour';
$string['buttonfocuscolourdesc'] = 'The colour that the button uses when focusing on the button.';

$string['buttontextfocuscolour'] = 'Button focus text colour';
$string['buttontextfocuscolourdesc'] = 'The text colour that the button uses when focusing on the button.';

$string['inputbuttonfocuscolour'] = 'Input button focus colour';
$string['inputbuttonfocuscolourdesc'] = 'The colour that the button uses when focusing on the input button.';

$string['inputbuttonfocuscolouropacity'] = 'Input button focus colour opacity';
$string['inputbuttonfocuscolouropacitydesc'] = 'The opacity that the button uses for the colour when focusing on the input button.';

$string['buttoncolorscnd'] = 'Secondary button colour';
$string['buttoncolordescscnd'] = 'The colour of the secondary buttons used throughout the site.';

$string['buttonhovercolorscnd'] = 'Secondary button hover colour';
$string['buttonhovercolordescscnd'] = 'The colour that the secondary button changes to when hovering over the button.';

$string['buttontextcolorscnd'] = 'Secondary button text colour';
$string['buttontextcolordescscnd'] = 'The colour of text used on secondary buttons.';

$string['buttoncolorcancel'] = 'Cancel button colour';
$string['buttoncolordesccancel'] = 'Background colour for Cancel button.<br />Type transparent in the box for transparency.';

$string['buttonhovercolorcancel'] = 'Cancel button hover colour';
$string['buttonhovercolordesccancel'] = 'The colour that the cancel button changes to when hovering over the button. <br />Type transparent in the box for transparency.';

$string['buttontextcolorcancel'] = 'Cancel button text colour';
$string['buttontextcolordesccancel'] = 'The colour of text used on the cancel buttons.';

$string['editfont'] = 'Editing and customize this page button font colour';
$string['editfontdesc'] = 'Set the editing and customize this page button font colour';

$string['edithorizontalpadding'] = 'Set horizontal padding of the editing buttons';

$string['buttondropshadow'] = 'Drop shadow decoration on bottom of button';
$string['buttondropshadowdesc'] = 'Show a drop shadow (shading) on bottom of button.';
$string['none'] = 'None';
$string['slight'] = 'Slight';
$string['standard'] = 'Standard';

// General.
$string['pageloadingprogress'] = 'Page loading progress';
$string['pageloadingprogressdesc'] = 'Show the page loading progress.';

$string['pageloadingprogresstheme'] = 'Page loading theme';
$string['pageloadingprogressthemedesc'] = 'Set the page loading theme.';

$string['pageloadingprogressthemebarbershop'] = 'Barber shop';
$string['pageloadingprogressthemebigcounter'] = 'Big counter';
$string['pageloadingprogressthemebounce'] = 'Bounce';
$string['pageloadingprogressthemecenteratom'] = 'Center atom';
$string['pageloadingprogressthemecentercircle'] = 'Center circle';
$string['pageloadingprogressthemecenterradar'] = 'Center radar';
$string['pageloadingprogressthemecentersimple'] = 'Center simple';
$string['pageloadingprogressthemecornerindicator'] = 'Corner indicator';
$string['pageloadingprogressthemefillleft'] = 'Fill left';
$string['pageloadingprogressthemeflash'] = 'Flash';
$string['pageloadingprogressthemeflattop'] = 'Flat top';
$string['pageloadingprogressthemeloadingbar'] = 'Loading bar';
$string['pageloadingprogressthememacosx'] = 'Mac OSX';
$string['pageloadingprogressthememinimal'] = 'Minimal';

$string['loadingcolor'] = 'Page loading colour';
$string['loadingcolordesc'] = 'The loading bar colour.';

// Login button.
$string['logintextbutton'] = 'Log in';
$string['logintextbuttonwhenoidc'] = 'Guest/Manual Login';
$string['logintextmanualbutton'] = 'Test account log in';

$string['buttonlogincolor'] = 'Login button colour';
$string['buttonlogincolordesc'] = 'The colour of the login button.';

$string['buttonloginhovercolor'] = 'Login button hover colour';
$string['buttonloginhovercolordesc'] = 'The hover colour of the login button.';

$string['buttonlogintextcolor'] = 'Login button text colour';
$string['buttonlogintextcolordesc'] = 'The colour of text used on the login button.';

$string['buttonloginpadding'] = 'Set the padding for the log in button';
$string['buttonloginpaddingdesc'] = 'Higher number = bigger button.';

$string['buttonloginheight'] = 'Set the height for the login button';
$string['buttonloginheightdesc'] = 'Only effective if using a login form in the upper header.';

$string['buttonloginmargintop'] = 'Set the top margin for the login button';
$string['buttonloginmargintopdesc'] = 'Allows spacing / position of the login button to be altered.';

$string['loginplaceholder'] = 'Username';
$string['passwordplaceholder'] = 'Password';

// Header.
$string['headersettings'] = 'Header';
$string['headersettingsheading'] = 'Customize the header of this theme.';
$string['headerdesc'] = 'Upload your logo, set login form in header, adjust titles in header.<br />You can set font size and styles for titles in the \'<a href="./../admin/settings.php?section=theme_adaptable_font">fonts</a>\' settings page.';

$string['headerbgimage'] = 'Background image';
$string['headerbgimagedesc'] = 'Set a background image in the header. Minimum size is 1600x180px (1900x180px recommended). The image cover the full header. You can add a colour in \'Top header background colour\' or use <i>transparent</i> to show the background image. In that case, modify the text colour to get displayed correctly over the image.';

$string['headerbgimagetextcolour'] = 'Background image text colour';
$string['headerbgimagetextcolourdesc'] = 'If you have a background image, then use this setting to set the colour of the text that is placed upon it.';

$string['enableheading'] = 'Header course title';
$string['enableheadingdesc'] = 'DEPRECATED, use \'enablecoursetitle\' instead.';

$string['enablecoursetitle'] = 'Course title';
$string['enablecoursetitledesc'] = 'Set the mode to display the course title.';

$string['sitetitlecoursesdisabled'] = 'Disabled - only show course titles in course pages';
$string['sitetitlecoursesenabled'] = 'Enabled - show site title and course titles in course pages';

$string['coursetitlemaxwidth'] = 'Course title maximum length';
$string['coursetitlemaxwidthdesc'] = 'Set the maximum number of characters of the course title area.';

$string['coursetitlefullname'] = 'Course full name';
$string['coursetitleshortname'] = 'Course short name / code';

$string['pageheaderheight'] = 'Page header height';
$string['pageheaderheightdesc'] = 'Set the height of the main header area (containing logo and titles).';

$string['mobileprimarynav'] = "Mobile primary navigation";
$string['mobileprimarynavdesc'] = "Enable or disable.  Note: This is the menu controlled by the hamburger icon";

$string['coursepageheaderhidetitle'] = 'Hide header title on course pages';
$string['coursepageheaderhidetitledesc'] = 'Hide header title, logo and search bar on course pages.  Use this along with page header height setting to show a smaller header on course related pages.';

$string['coursepageheaderhidesitetitle'] = 'Hide site title on course pages';
$string['coursepageheaderhidesitetitledesc'] = 'DEPRECATED, use \'coursepageheaderhidetitle\' instead.';

$string['breadcrumb'] = 'Breadcrumb';
$string['breadcrumbtitle'] = 'Breadcrumb course name';
$string['breadcrumbtitledesc'] = 'Set the mode to display the course title in the breadcrumb.';

$string['breadcrumbdisplay'] = 'Breadcrumb display';
$string['breadcrumbdisplaydesc'] = 'Set the display of what should be in the breadcrumb area.';

$string['headerstyleheading'] = 'Header style settings';
$string['headerstyleheadingdesc'] = 'Adaptable supports two header styles, the original three row header and a newer simplified two row header.<br/>Be aware that if you switch to the newer two row header you will <strong>NOT</strong> be able to:<br /><ol><li>Show social icons in the header.</li><li>Display the site logo on mobile devices.</li></ol>';

$string['headerstyle'] = 'Header style';
$string['headerstyledesc'] = 'Choose the style of header.  Header one refers to the original three row Adaptable header.  Header two is a minimal two row header with a search box.';
$string['headerstyle1'] = 'Header one (original three row header)';
$string['headerstyle2'] = 'Header two (two row header)';

$string['headersearchandsocial'] = 'Header search and social';
$string['headersearchandsocialdesc'] = 'Set the position of the search box and social icons in the header for header style one.<br />
You can set social icons under the <a href="./../admin/settings.php?section=themesettingadaptable#theme_adaptable_social">Header social</a> settings page</strong>.';
$string['headersearchandsocialnone'] = 'None';
$string['headersearchandsocialsearchmobilenav'] = 'Search in header and navbar for mobiles';
$string['headersearchandsocialsearchheader'] = 'Search in header';
$string['headersearchandsocialsocialheader'] = 'Social in header';
$string['headersearchandsocialsearchnavbar'] = 'Search on navbar';
$string['headersearchandsocialsearchnavbarsocialheader'] = 'Search on navbar, social in header';

$string['coursesearch'] = 'Course search';

$string['searchboxpadding'] = 'Header search box padding';
$string['searchboxpaddingdesc'] = 'Set padding for the search box when it is in the header (if being used instead of social icons) <br />E.g. 5px 10px 5px 10px (top, right, bottom, left).<br> You can set social icons under the <a href="./../admin/settings.php?section=theme_adaptable_social">Header Social</a> settings page</strong>.';

$string['enablesavecanceloverlay'] = 'Enable save / cancel overlay on settings pages';
$string['enablesavecanceloverlaydesc'] = 'Display a save / cancel button overlay at the top of a settings page to make it easier to save settings.';
$string['enablesavecanceloverlayresetconfirm'] = 'This resets any changes made since loading this page.  Are you sure?';

$string['usernavheading'] = 'Customise the user navigation dropdown';
$string['usernav'] = 'Header user';
$string['usernavdesc'] = 'Allows you to control all of the elements that appear in the user navigation dropdown.';

$string['showusername'] = 'Show username';
$string['showusernamedesc'] = 'Show the username on the user menu on the navbar.';

$string['usernameposition'] = 'User name position';
$string['usernamepositiondesc'] = 'Set the postion of the userame, \'Left\' or \'Right\'.';

$string['menusettings'] = 'Header menus';
$string['menusettingsheading'] = 'Customize menus in the upper header the header of this theme.';

$string['logo'] = 'Logo';
$string['logodesc'] = 'Upload a logo for use on your site.  Recommended size is 200px by 80px.';

$string['logoalt'] = 'Logo description';
$string['logoaltdesc'] = 'Provide a description of your logo for accessibility.  Multilang compatible.';

$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Upload a favicon for use on your site using the core setting \'core_admin | favicon\' under \'Site Administration\' -> \'Appearance\' -> \'Logos\'.';

$string['enableavailablecourses'] = 'Display "Available Courses"';
$string['enableavailablecoursesdesc'] = 'Display "Available Courses" text in the frontpage.';

$string['thiscourse'] = 'This course';
$string['coursesections'] = 'Course sections';

$string['sitetitle'] = 'Display site title';
$string['sitetitledesc'] = 'Display the default Moodle site title from <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Front Page Settings</a> or enter a custom site title in the text box below.';

$string['sitetitleoff'] = 'Disable site title';
$string['sitetitledefault'] = 'Use Moodle site title (site name)';
$string['sitetitlecustom'] = 'Use custom site title (enter in the \'sitetitletext\' box below)';

$string['pageheaderlayout'] = 'Header one, page header layout';
$string['pageheaderlayoutdesc'] = 'The page header layout for header style one.';
$string['pageheaderlayouttwo'] = 'Header two, page header layout';
$string['pageheaderlayouttwodesc'] = 'The page header layout for header style two.';

$string['pageheaderalternative'] = 'Alternative';
$string['pageheadernosearch'] = 'No search';
$string['pageheaderoriginal'] = 'Original';

$string['sitetitletext'] = 'Site title';
$string['sitetitletextdesc'] = 'Site title displayed in the header. You can use any HTML tag and apply inline styles. It is recommended to use an h1 HTML tag around the title, instead of the p tag that gets added as default when you type something in this field.';

$string['displaylogin'] = 'Display login';
$string['displaylogindesc'] = 'Select how to display the login box in header.';

$string['displayloginbutton'] = 'Button';
$string['displayloginbox'] = 'Login Box';
$string['displayloginno'] = 'No Login Box';

$string['fullscreen'] = 'Full view';
$string['standardview'] = 'Standard view';
$string['sitelinkslabel'] = 'Site links';

$string['enablezoom'] = 'Enable Zoom';
$string['enablezoomdesc'] = 'Allow users to toggle between full view and fixed width.';
$string['enablezoomshowtext'] = 'Show text for Enable Zoom';
$string['enablezoomshowtextdesc'] = 'DEPRECATED, use \'navbardisplaytitles\' instead.';

$string['defaultzoom'] = 'Default Zoom';
$string['defaultzoomdesc'] = 'Default view size when enable zoom is disabled or the user has not made a preference.  Choose between full view and fixed width.';
$string['normal'] = 'Fixed width';
$string['wide'] = 'Full view';

$string['enableshowhideblocks'] = 'Enable Show Hide Blocks';
$string['enableshowhideblocksdesc'] = 'Allows users to show / hide all blocks.';
$string['enableshowhideblockstext'] = 'Show text for Show Hide Blocks';
$string['enableshowhideblockstextdesc'] = 'Shows the text beside the button.';
$string['blockshowhide'] = 'Show / hide the block';

$string['enablenavbarwhenloggedout'] = 'Enable navbar when logged out';
$string['enablenavbarwhenloggedoutdesc'] = 'Shows the navbar even when logged out.  Limited to help and tools menu only.';

$string['fullscreenwidth'] = 'Full view width';
$string['fullscreenwidthdesc'] = 'Set the max width of the theme when it is in full view mode / zoom.';

$string['standardscreenwidth'] = 'Standard view width.';
$string['standardscreenwidthdesc'] = 'Set the width of the view when toggled to "standard" view (also see related enablezoom and defaultzoom settings).';

// Help Links.
$string['headernavbarhelpheading'] = 'Help links and options';
$string['headernavbarhelpheadingdesc'] = 'Options for help menu links.';

$string['helplinkscount'] = 'Number of help links';
$string['helplinkscountdesc'] = 'Set the number of help links you want to add to the main navigation bar.';

$string['enablehelp'] = 'Help link \'{$a->number}\'';
$string['enablehelpdesc'] = 'Add a help link \'{$a->number}\' in the navbar.';

$string['helplinktitle'] = 'Help link \'{$a->number}\' title';
$string['helplinktitledesc'] = 'The title for help link \'{$a->number}\' in the navbar.  If empty then defaults to \'Help {$a->number}\'.';

$string['helptitle'] = 'Help {$a->number}';

$string['helpprofilefield'] = 'Help link \'{$a->number}\' custom profile field (optional)';
$string['helpprofilefielddesc'] = 'Add help link \'{$a->number}\' access rule using for custom profile field eg: usertype=student.';

// Courses Overlay.
$string['rendereroverlaycolor'] = 'Overlay colour';
$string['rendereroverlaycolordesc'] = 'The colour of the overlay, when the "Tiles w/ overlay" renderer is selected.';

$string['rendereroverlayfontcolor'] = 'Overlay font colour';
$string['rendereroverlayfontcolordesc'] = 'The colour of the font, when hovering over a coursebox with "Tiles w/ overlay" renderer enabled.';

$string['covbkcolor'] = 'Coventry tiles title background colour';
$string['covbkcolordesc'] = 'Set the title background colour with the Coventry Tiles renderer is selected.';

$string['covfontcolor'] = 'Coventry tiles title font colour';
$string['covfontcolordesc'] = 'Set the title font colour with the Coventry Tiles renderer is selected.';

$string['covhidebutton'] = 'Coventry tiles course button';
$string['covhidebuttondesc'] = 'Set this to hide the course button when Coventry Tiles is selected.';

$string['frontpagerendererdefaultimage'] = 'Default course image';
$string['frontpagerendererdefaultimagedesc'] = 'The default image to use when no course image is found, (only applies for Tiles w/ overlay).';

$string['tilesshowcontacts'] = 'Show course contacts';
$string['tilesshowcontactsdesc'] = 'Show / hide course contacts.';

$string['tilesbordercolor'] = 'Coursebox tiles border colour';
$string['tilesbordercolordesc'] = 'Set a colour for the coursebox tiles border.';

$string['tilescontactstitle'] = 'Show course contacts role';
$string['tilescontactstitledesc'] = 'Show / hide the role of a course contact. If not displayed, an image will be displayed before each contact.';

$string['tilesshowallcontacts'] = 'Show all course contacts';
$string['tilesshowallcontactsdesc'] = 'Show all course contacts or just one.';

$string['course'] = 'Course';

// Alerts.
// Alert message if acting as another role.
$string['actingasrole'] = 'You are currently acting as a different role';

// Alert Hidden Course.
$string['alerthiddencourse'] = 'Hidden course alert';
$string['alerthiddencoursedesc'] = 'Warn teachers that courses are hidden.';

$string['alerthiddencoursetext-start'] = 'This course is hidden and cannot be accessed by students, ';
$string['alerthiddencoursetext-link'] = 'click here to update settings';
$string['alerthiddencoursetext-end'] = '.';

// Alert Enable.
$string['enablealert'] = 'Enable alert {$a}';
$string['enablealertdesc'] = 'Enable alert {$a}.';

// Alert Generic Strings.
$string['alerttype'] = 'Alert type';
$string['alerttypedesc'] = 'Select the type of alert: info (blue), warning (yellow) or announcement (green).';

$string['alerttext'] = 'Alert text';
$string['alerttextdesc'] = 'Enter the text to display in the alert.';

$string['enablealerts'] = 'Enable / disable alerts';
$string['enablealertsdesc'] = 'Enable / disable site alerts, not course, see the \'alerthiddencourse\' setting.';

$string['enablealertstriptags'] = 'Automatically strip html tags from alerts';
$string['enablealertstriptagsdesc'] = 'Enable will clean up the alert messages automatically and disable to allow you to use html / links in messages but you will have to clean up manually in html view.';

$string['alertkeyvalue'] = 'Alert key';
$string['alertkeyvalue_details'] = 'The key that identifies this alert.  You only need to change this if you want to show the same alert again, i.e. the content has not changed or has been used before.  Note: Formatting changes do not count as a change to the content.';

$string['alertsettingscourse'] = 'Course alert settings';

$string['alertsettingsgeneral'] = 'General alert settings';
$string['alertsettings'] = 'Alert {$a}';

$string['alertcount'] = 'Alert count';
$string['alertcountdesc'] = 'The number of alerts to show in the edit area below.';

$string['alertsettingsheading'] = 'Alerts';
$string['alertdesc'] = 'Enter and customize a text to be displayed in the top of the site as an alert.  It is possible to set more than one alert to target different user types.';

// Alerts Types.
$string['alertdisabled'] = 'Disabled';
$string['alertdisabledesc'] = 'Disable this alert.';

$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Display information in the alert.';

$string['alertwarning'] = 'Warning';
$string['alertwarningdesc'] = 'Display a warning in the alert.';

$string['alertannounce'] = 'Announcement';
$string['alertannouncedesc'] = 'Display an announcement in the alert.';

$string['alertprofilefield'] = 'Custom profile field name=Value (optional)';
$string['alertprofilefielddesc'] = 'Add access rule using for custom profile field eg: usertype=student.';

// Alert Access - Visibility.
$string['alertaccessglobal'] = 'Visible to everyone';
$string['alertaccessusers'] = 'Visible to logged in users';
$string['alertaccessadmins'] = 'Visible to administrators';
$string['alertaccessprofile'] = 'Add custom profile field restriction';

$string['alertaccess'] = 'Alert visibility';
$string['alertaccessdesc'] = 'Set access restriction type for alert visibility.  Note: if using "Add custom profile field restriction" you will need to add values for profile fields below.';

// Alert Colours.
$string['alertcolorsheading'] = 'Alert colours and icon';

$string['alertcolorinfo'] = 'Info colour';
$string['alertcolorinfodesc'] = 'Icon colour of the Info type alerts.';
$string['alertbackgroundcolorinfo'] = 'Info background colour';
$string['alertbackgroundcolorinfodesc'] = 'Background colour of the info type alerts.';
$string['alertbordercolorinfo'] = 'Info border colour';
$string['alertbordercolorinfodesc'] = 'Border colour of the info type alerts.';
$string['alerticoninfo'] = 'Info Icon';
$string['alerticoninfodesc'] = 'Set the \'<a href="{$a}" target="_blank">Font Awesome Icons</a>\' to be used in info type alerts.  Enter the icon name without the \'fa-\' prefix.';

$string['alertcolorwarning'] = 'Warning colour';
$string['alertcolorwarningdesc'] = 'Icon colour of the warning type alerts.';
$string['alertbackgroundcolorwarning'] = 'Warning background colour';
$string['alertbackgroundcolorwarningdesc'] = 'Background colour of the Warning type alerts.';
$string['alertbordercolorwarning'] = 'Warning border colour';
$string['alertbordercolorwarningdesc'] = 'Border colour of the Warning type alerts.';
$string['alerticonwarning'] = 'Warning icon';
$string['alerticonwarningdesc'] = 'Set the \'<a href="{$a}" target="_blank">Font Awesome Icons</a>\' to be used in warning type alerts.  Enter the icon name without the \'fa-\' prefix.';

$string['alertcolorsuccess'] = 'Announcement colour';
$string['alertcolorsuccessdesc'] = 'Icon colour of the announcement type alerts.';
$string['alertbackgroundcolorsuccess'] = 'Announcement background colour';
$string['alertbackgroundcolorsuccessdesc'] = 'Background colour of the announcement type alerts.';
$string['alertbordercolorsuccess'] = 'Announcement border colour';
$string['alertbordercolorsuccessdesc'] = 'Border colour of the announcement type alerts.';
$string['alerticonsuccess'] = 'Announcement icon';
$string['alerticonsuccessdesc'] = 'Set the \'<a href="{$a}" target="_blank">Font Awesome Icons</a>\' to be used in announcement type alerts.  Enter the icon name without the \'fa-\' prefix.';

// Mobile.
$string['responsivesettings'] = 'Layout responsive';
$string['responsivesettingsheading'] = 'Control how your site behaves at different screen sizes';
$string['responsivesettingsdesc'] = 'Here you can control the responsive behaviour of your site (which elements appear on screens of different sizes).  By default most non essential items are hidden on mobile devices, being set to appear only on larger screens.  You can make elements appears on smaller screens by choosing to display them on "Extra Small" or "Small screens".  To gain a better understanding of how these settings work please refer to the Bootstrap \'<a href="{$a}" target="_blank">Display property</a>\' documentation.';

$string['responsivesocial'] = 'Social icons';
$string['responsivesocialdesc'] = 'What sized screens would you like social icons to be displayed on?';

$string['responsivecoursetitle'] = 'Course / site title';
$string['responsivecoursetitledesc'] = 'DEPRECATED, use \'responsivesitetitle\' instead.';

$string['responsiveheadertitle'] = 'Header title';
$string['responsiveheadertitledesc'] = 'What sized screens would you like the header title to be displayed on?';

$string['responsivesitetitle'] = 'Site title';
$string['responsivesitetitledesc'] = 'DEPRECATED, use \'responsiveheadertitle\' instead.';

$string['responsivesectionnav'] = 'Activity / section navigation';
$string['responsivesectionnavdesc'] = 'Show / hide the the <strong>text</strong> for "prev" "next" activity / section navigation on small screens.  By default we hide this text on smaller screens so only the icons for <prev> <next> links display and not the full section / activity name.';

$string['responsivelogo'] = 'Logo';
$string['responsivelogodesc'] = 'What sized screens would you like the logo to be displayed on?';

$string['responsiveheaderdesc'] = 'What sized screens would you like the main header to be displayed on?<br/>Removing the header entirely will also remove elements contained within it:<br/><ul><li>Social Icons</li><li>Logo</li><li>Site / Course Title</li></ul>';
$string['responsiveheader'] = 'Main header';

$string['responsiveticker'] = 'News ticker';
$string['responsivetickerdesc'] = 'What sized screens would you like the news ticker to be displayed on?';

$string['responsivepagefooter'] = 'Footer';
$string['responsivepagefooterdesc'] = 'What sized screens would you like the footer to be displayed on?';

$string['responsiveslider'] = 'Frontpage slider';
$string['responsivesliderdesc'] = 'What sized screens would you like the Frontpage Slider to be displayed on?';

$string['responsivebreadcrumb'] = 'Beadcrumb navigation';
$string['responsivebreadcrumbdesc'] = 'What sized screens would you like Breadcrumb Navigation to be displayed on?';

// Bootstrap class descriptions used in array definitions.
$string['bs4all'] = 'Extra small - Extra large';
$string['bs4small'] = 'Small - Extra large';
$string['bs4medium'] = 'Medium - Extra large';
$string['bs4large'] = 'Large - Extra large';
$string['bs4extralarge'] = 'Extra large only';
$string['bs4none'] = 'None';

// Layout.
$string['layoutsettings'] = 'Layout';
$string['layoutdesc'] = 'Set the default layout that users see.';
$string['layoutsettingsheading'] = 'Control aspects of the site\'s layout';

$string['blockside'] = 'Location of the blocks';
$string['blocksidedesc'] = 'Control whether blocks appear on the left or right of the page.';

$string['rightblocks'] = 'Right side';
$string['leftblocks'] = 'Left side';

$string['emoticonsize'] = 'Emoticons size';
$string['emoticonsizedesc'] = 'Set the height and width of the moodle emoticons.';

$string['infoiconcolor'] = 'Help icon colour';
$string['infoiconcolordesc'] = 'Set the colour of the info/help icon used by tooltips.';

$string['dangericoncolor'] = 'Warning icon colour';
$string['dangericoncolordesc'] = 'Set the colour of the warning/danger icon mainly used in mandatory fields.';

$string['helptarget'] = 'Help target';
$string['helptargetdesc'] = 'Do you want the help link to open in a new window?';

$string['hideinforum'] = 'Hide help, user favourites and tools in forums';
$string['hideinforumdesc'] = 'When using fixed width and all menu options the forum search box spills onto the line below.  Turning this option on will hide help, user favourites and tools menu items in forums allowing it to display properly.';

$string['targetnewwindow'] = 'New window';
$string['targetsamewindow'] = 'Same window';

$string['events'] = 'Events';
$string['future'] = 'Future';
$string['hiddencourses'] = 'Hidden courses';
$string['hiddenfromview'] = 'Hidden from view';
$string['inprogress'] = 'In progress';
$string['mysites'] = 'My courses';
$string['past'] = 'Past';
$string['pastcourses'] = 'Past courses';
$string['people'] = 'Participants';
$string['help'] = 'Help';

$string['breadcrumbseparator'] = 'Breadcrumb separator';
$string['breadcrumbseparatordesc'] = 'Set the \'Font Awesome Icon\' to be used as item separator in the breadcrumb.  To find the FontAwesome(Free) classes for the icon you wish to use, go to <a href="{$a}" target="_blank">Font Awesome free</a> and search for the icon.  You can use the name, such as \'angle-right\' or the complete list of classes, e.g. \'fa-solid fa-angle-right\'.';

$string['breadcrumbhome'] = 'Breadcrumb home';
$string['breadcrumbhomedesc'] = 'Display home breadcrumb as an icon, or as a text, or off.';

$string['breadcrumbhomeicon'] = 'Icon';
$string['breadcrumbhomeoff'] = 'Off';
$string['breadcrumbhometext'] = 'Text';

$string['mysitesexclude'] = 'Enable excluding hidden courses';
$string['mysitesinclude'] = 'Enable including hidden courses';
$string['mysitesdisabled'] = 'Disable';

$string['menusheading'] = 'Configure navigation for link menus in the upper header';
$string['menustitledesc'] = 'Top menus can be restricted based on custom profile fields (optional).  To add a restriction enter the name of the profile field and expected value.';

$string['menusession'] = 'Store access details in session';
$string['menusessiondesc'] = 'For performance reasons it is suggested this is enabled. You may want to disable when testing.';

$string['menusessionttl'] = 'Minutes to store access rules in session';
$string['menusessionttldesc'] = 'Number of minutes after which menu access rules are refreshed in the users session.';

// Custom menus.
$string['headernavbarcustommenuheading'] = 'Custom menu';
$string['headernavbarcustommenuheadingdesc'] = 'The custom menu as set by the core \'custommenuitems\' setting, duplicated below.';

$string['disablecustommenu'] = 'Disable Moodle custom menu';
$string['disablecustommenudesc'] = 'Disable Moodle custom menus in the navigation bar (will still render in other themes you may have installed).';

$string['custommenutitle'] = 'Custom menu title';
$string['custommenutitledesc'] = 'Set the title of the custom menu title that will contain all of the custom menus on the navbar.  If empty then each top level entry will create a new menu on the navbar.';

$string['headernavbarcustommenucoreheading'] = 'Core settings';
$string['headernavbarcustommenucoreheadingdesc'] = 'Shown for convenience.  Please navigate to \'Advanced theme settings\' under \'Appearance\'.';

$string['custommenuitemscoredesc'] = 'A custom menu may be configured in the core setting.  Enter each menu item on a new line.  Lines starting with a hyphen will appear as menu items in the previous top level menu and ### makes a divider.';
$string['customusermenuitemscoredesc'] = 'You can configure the contents of the user menu (with the exception of the log out link, which is automatically added).  Each line is separated by pipe characters and consists of 1) a string in "langstringname, componentname" form or as plain text, 2) a URL, and 3) a Font Awesome icon name or CSS classes (optional).  Dividers can be used by adding a line of one or more # characters where desired.  To find the FontAwesome(Free) classes for the icon you wish to use, go to <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> and search for the icon.  You can use the name, such as \'graduation-cap\' or the complete list of classes \'fa-solid fa-graduation-cap\'.  For example:
<pre>
messages,message|/message/index.php|fa-regular fa-comment
privatefiles,moodle|/user/files.php|folder-tree
</pre>
Note: The default core value may contain duplicates, please adjust as desired.
';
$string['headernavbarcustommenucoreempty'] = 'Setting \'<small>{$a}</small>\' is empty.';
$string['headernavbarcustommenucorenotempty'] = 'Setting \'<small>{$a}</small>\' is:<br><br>';

// Tool menus.
$string['newmenudesc'] = 'Configure links to be shown under a top header menu.';
$string['newmenufield'] = 'Custom profile field name=Value (optional)';
$string['newmenufielddesc'] = 'Add access rule using for custom profile field eg: usertype=student.';
$string['newmenurequirelogin'] = 'Require login';
$string['newmenurequirelogindesc'] = 'If enabled this menu will only be visible to logged in users.';

$string['menusdesc'] = '';

$string['enablemenus'] = 'Enable menus';
$string['enablemenusdesc'] = 'It is recommended you leave this off if menus are not in use for preformance reasons.';

$string['menuslinkright'] = 'Show menus link in topright';
$string['menuslinkrightdesc'] = 'If checked, show the link to the menus on the top right next to the messages menu.';

$string['menuslinkicon'] = "Links menu icon";
$string['menuslinkicondesc'] = "Choose a custom font awesome icon.";

$string['disablemenuscoursepages'] = 'Disable menus on course pages';
$string['disablemenuscoursepagesdesc'] = 'Turning this option on will limit the display of top menus to site pages, the homepage, and dashboard (\'My Home\') etc. and will not show in any course pages.';

$string['topmenufontsize'] = 'Top menu font size';
$string['topmenufontsizedesc'] = 'Adjust the font size of the top menus.';

$string['menuuseroverride'] = 'Allow user override';
$string['menuuseroverridedesc'] = 'These settings can be used to give users control over where menus appear via a custom profile field. To use this option you will need to create a custom profile field in the "list" format with values in the corresponding order:<br/><pre>1. Sitewide (the first item in the list will be for sitewide menu visibility)
2. Homepages Only (the second item in the list will set visibility to only site / homepages)
3. Hidden (the third value in the list will hide menus entirely)</pre>
You should NOT use the "Disable Menus on Course Pages" option in conjuction with profile field settings, instead use set the default value to your "Homepages Only" entry when setting up your profile field list.

Note: Users will have to log out of Moodle and back in again for this change to take effect, you may want to add a note explaining this in the custom profile field.';

$string['menuoverrideprofilefield'] = 'Custom profile field name';
$string['menuoverrideprofilefielddesc'] = 'The name of the custom profile "list" field used for user override.';
$string['menuoverrideprofilefielddefault'] = 'topmenusettings';

$string['topmenuscount'] = 'Number of top menus';
$string['topmenuscountdesc'] = 'Set the number of top menus you want to add to the theme header.';

$string['menusheadingvisibility'] = 'General settings for top menu visibility';
$string['menusheadingvisibilitydesc'] = 'The following settings allow you to control where menus appear and optionally allow users to customise their settings.';

$string['newmenuheading'] = 'Top menu';
$string['newmenu'] = 'Top menu dropdown';
$string['newmenutitle'] = 'Top menu title';
$string['newmenutitledesc'] = 'The title of the dropdown list that will appear in the header of your site.';
$string['newmenutitledefault'] = 'Menu';

$string['navbaruserfavtoolsmenus'] = 'Navbar user favourites and tools menus';

$string['userfavmenu'] = 'User favourites menu';
$string['userfavmenudesc'] = 'The user will be able to create their own favourites menu saved as a user preference.  The format of each line is \'text|url|title|langs|fontawesome classes\'.  Only enter what you require.  If you don\'t need something but do need another thing further along then leave it blank but still use the \'|\' delimiter.  For example: \'text|url|||fontawesome classes\'.  To find the FontAwesome(Free) classes for the icon you wish to use, go to <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> and search for the icon.  You can use the name, such as \'graduation-cap\' or the complete list of classes \'fa-solid fa-graduation-cap\'.  For example:<pre>
Courses
-All courses|/course/|||graduation-cap
-Course search|/course/search.php
-###
-FAQ|https://example.org/faq
-Exam Clock|https://mysite.localhost|Exam Clock||clock
</pre>';

$string['enableuserfavmenu'] = 'Enable user favourites menu';
$string['enableuserfavmenudesc'] = 'It is recommended you leave this off if the menu is not in use for preformance reasons.';

$string['enabletoolsmenus'] = 'Enable tool menus';
$string['enabletoolsmenusdesc'] = 'It is recommended you leave this off if menus are not in use for preformance reasons.';

$string['toolsmenuscount'] = 'Number of tool menus';
$string['toolsmenuscountdesc'] = 'Set the number of tools menus you want to add to the main navigation bar.';

$string['toolsmenuheading'] = 'Tools menu';
$string['toolsmenuheadingdesc'] = 'Add a drop down menu to the main navigation bar.  You can configure links to be shown under a tools menu (in main navigation bar).  In the format of \'text|url|title|langs|fontawesome classes|capability to check\'.  Only enter what you require.  If you don\'t need something but do need another thing further along then leave it blank but still use the \'|\' delimiter.  For example: \'text|url|||fontawesome classes\'.  To find the FontAwesome(Free) classes for the icon you wish to use, go to <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> and search for the icon.  You can use the name, such as \'graduation-cap\' or the complete list of classes \'fa-solid fa-graduation-cap\'.  For example:<pre>
Record Screen|https://mysite.localhost|Record Screen||video
Photos|https://mysite.localhost|Photos||fa-solid fa-image
Exam Clock|https://mysite.localhost|Exam Clock|en|clock
Cloc arholiad|https://mysite.localhost|Cloc arholiad|cy|clock
</pre>';

$string['fontawesomesettingdesc'] = 'The format of each line is \'text|url|title|langs|fontawesome classes|capability to check\'.  Only enter what you require.  If you don\'t need something but do need another thing further along then leave it blank but still use the \'|\' delimiter.  For example: \'text|url|||fontawesome classes\'.  To find the FontAwesome(Free) classes for the icon you wish to use, go to <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome free</a> and search for the icon.  You can use the name, such as \'graduation-cap\' or the complete list of classes \'fa-solid fa-graduation-cap\'.  For example:<pre>
Courses
-All courses|/course/
-Course search|/course/search.php
-###
-FAQ|https://example.org/faq
-Exam Clock|https://mysite.localhost|Exam Clock|en|clock
-Cloc arholiad|https://mysite.localhost|Cloc arholiad|cy|clock
Educators|https://mysite.localhost|Educators only|en|graduation-cap|moodle/course:manageactivities
</pre>';

$string['toolsmenuheadingindex'] = 'Tools menu {$a}';
$string['toolsmenu'] = 'Tools menu';
$string['toolsmenudesc'] = 'Add the links here.';
$string['toolsmenutitle'] = 'Tools menu title';
$string['toolsmenutitledefault'] = 'Tools';
$string['toolsmenutitledesc'] = 'Add the title of the menu you would like to display in the main navigation bar.';

$string['toolsmenufield'] = 'Custom profile field name=Value (optional)';
$string['toolsmenufielddesc'] = 'Add access rule using for custom profile field eg: usertype=student.';

// Social settings.
$string['socialsettings'] = 'Header social';
$string['socialheading'] = 'Social icon settings';
$string['socialtitledesc'] = 'You can disable the sitewide search box and enable social icons / links in its place.  To setup icons enter a delimited list into the "Social Icon List" field below.';

$string['socialsize'] = 'Set the font size of the social icons';
$string['socialsizedesc'] = 'For a better view, the size needs to be 5px greater than the desired actual size.';
$string['responsivesocialsize'] = 'Set the font size of the social icons on Mobile';
$string['responsivesocialsizedesc'] = 'For a better view, the size needs to be 5px greater than the desired actual size.';
$string['socialpaddingside'] = 'Adjust padding for the side of the social icon';
$string['socialpaddingsidedesc'] = 'This will be space between the icon and another element or the gap between two icons.  i.e. the padding on the icon will be this value divided by two.  Default value follows Instagram branding guidelines.';
$string['socialpaddingtop'] = 'Adjust padding above social icons (alters vertical position)';
$string['socialpaddingtopdesc'] = 'This will be the minimum of 15px (set using the margin) plus this value.';

$string['socialtarget'] = 'Social links open target';
$string['socialtargetdesc'] = 'How would you like social links to open (same or new window).';

$string['socialsearchicon'] = 'Search Moodle';
$string['socialsearchicondesc'] = 'Enable to put a search link alongside social icons (as using social disables sitewide search box).';

$string['socialicondesc'] = 'Set Font Awesome icon for example: fa-facebook.';

$string['socialiconlist'] = 'Social icon list';
$string['socialiconlistdesc'] = 'Enter a delimited list to setup the social icons / links you need.  This should be in the format:

url|title|icon

For example:
<pre>
https://example.com/course/search.php|Search Moodle|search
https://facebook.com/|Facebook|fa-brands fa-facebook-f
https://X.com/|X|fa-brands fa-x-twitter
https://twitter.com/|Twitter|fa-brands fa-twitter
https://instagram.com|Instagram|fa-brands fa-instagram
https://example.com|My Web|globe
</pre>
Where the Font Awesome icon can be its name or CSS classes.  For reference you can find the full list of Font Awesome Icons see \'<a href="{$a}" target="_blank">here</a>\'.';

// Templates.
$string['templatessettings'] = 'Templates';
$string['templatesheading'] = 'Templates settings';
$string['templatesheadingdesc'] = 'Override templates.';
$string['templatessel'] = 'Templates to override';
$string['templatesseldesc'] = 'Select the templates to override, then each will be shown on their own page.  If not selected here, then the template will not be overridden even if it is enabled.  To select none, use the \'Ctrl\' key.';
$string['overridetemplate'] = 'Override template: {$a}';
$string['activatetemplateoverride'] = 'Activate template override for \'{$a}\'';
$string['activatetemplateoverridedesc'] = 'When ticked then the value in the \'{$a->setting}\' setting will be used as the \'{$a->template}\' template if it contains text.';
$string['overriddentemplate'] = 'Overridden template: {$a}';
$string['overriddentemplatedesc'] = 'If set then the text here will be used as the template \'{$a}\'.  To ensure that the preview works, there needs to be the standard example context in JSON format.';
$string['overriddentemplatepreview'] = 'Setting overridden preview';
$string['overriddentemplatenopreview'] = 'No preview because of missing JSON example';
$string['originaltemplatepreview'] = 'Original / overridden theme file preview';
$string['originaltemplatesource'] = 'Original / overridden theme file source';

// Analytics.
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsheading'] = 'Setup Google Analytics and/or Matomo';
$string['analyticssettingsdesc'] = 'You can setup multiple codes for Google Analytics and targed them to user profile fields. Or you can use Matomo, the open source analytics.';

// GA.
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsheading'] = 'Setup Google Analytics for your site';
$string['googleanalyticssettingsdesc'] = 'You can setup multiple codes for Google Analytics and targed them to user profile fields.';

$string['enableanalytics'] = 'Enable Google Analytics';
$string['enableanalyticsdesc'] = 'Enable Google Analytics settings on your Moodle site';

$string['analyticstext'] = 'Analytics ID';
$string['analyticstextdesc'] = 'Enter Google Analytics ID.';

$string['analyticscount'] = 'Analytics count';
$string['analyticscountdesc'] = 'The number of analytics fields to show in the edit area below.';

$string['analyticsprofilefield'] = 'Custom Profile Field Name=Value (optional)';
$string['analyticsprofilefielddesc'] = 'Add access rule using for custom profile field eg: usertype=student.';

$string['anonymizega'] = 'Anonymize the user IP';
$string['anonymizegadesc'] = 'Anonymize the user IP send to Google Analytics.';

// Matomo (formerly Piwik).
$string['piwiksettings'] = 'Matomo (formely Piwik) analytics';
$string['piwiksettingsheading'] = 'Setup Matomo';
$string['piwiksettingsdesc'] = 'Generate clean URL for in advanced tracking.';

$string['piwikenabled'] = 'Enabled';
$string['piwikenableddesc'] = 'Enable Matomo tracking for Moodle.';

$string['piwiksiteid'] = 'Site ID';
$string['piwiksiteiddesc'] = 'Enter your Site ID.';

$string['piwikimagetrack'] = 'Image tracking';
$string['piwikimagetrackdesc'] = 'Enable image tracking for Moodle for browsers with JavaScript disabled.';

$string['piwiksiteurl'] = 'Matomo URL';
$string['piwiksiteurldesc'] = 'Enter your Matomo analytics URL without http(s) or a trailing slash.';

$string['piwiktrackadmin'] = 'Tracking admins';
$string['piwiktrackadmindesc'] = 'Enable tracking of admin users (not recommended).';

// Custom CSS and Javascript.
$string['customcsssettings'] = 'Custom CSS';
$string['customjssettings'] = 'Custom JS';
$string['customcssjssettingsheading'] = 'Apply your own modifications';
$string['customcsssettingsdescription'] = 'Here you can find various settings to add your own CSS to the theme.';
$string['customjssettingsdescription'] = 'Here you can find various settings to add your own JavaScript to the theme.  Note: Script tags are automatically added, do not add yourself.';

$string['customcss'] = 'Custom CSS';
$string['customcssdesc'] = 'Whatever CSS rules you add to this textarea will be reflected in every page, making for easier customization of this theme.';

$string['hvpcustomcss'] = 'H5P Custom CSS';
$string['hvpcustomcssdesc'] = 'Custom CSS for the H5P module.';

$string['customjs'] = 'Custom JavaScript';
$string['customjsdesc'] = 'Add JavaScript to the site.';

$string['customjsfiles'] = 'Custom JavaScript files';
$string['customjsfilesdesc'] = 'Add JavaScript files to the site.';

$string['jssection'] = 'Javascript section';
$string['jssectiondesc'] = 'DEPRECATED, use \'customjs\' instead.';

$string['customjsrestricted'] = 'Conditional JavaScript';
$string['customjsrestricteddesc'] = 'Add JavaScript to the site conditionally based on a custom profile field.  This JavaScript will only appear if this condition is met.';

$string['jssectionrestricted'] = 'Conditional javascript section';
$string['jssectionrestricteddesc'] = 'DEPRECATED, use \'customjsrestricted\' instead.';

$string['jssectionrestrictedprofilefield'] = 'Javascript section custom profile field';
$string['jssectionrestrictedprofilefielddesc'] = 'Show the javascript above ONLY when user matches this custom profile field value, eg: faculty=fbl.';

$string['jssectionrestricteddashboardonly'] = 'Include javascript only on dashboard page';
$string['jssectionrestricteddashboardonlydesc'] = 'Show the javascript only on the dashboard page.  Otherwise this displays sitewide.';

// Activity and section navigation.
$string['nextactivity'] = 'Next activity';
$string['previousactivity'] = 'Previous activity';

$string['nextsection'] = 'Next section';
$string['previoussection'] = 'Previous section';

$string['maincoursepage'] = 'Main course page';
$string['jumpto'] = 'Jump to...';

// General.
$string['dashed'] = 'Dashed';
$string['dotted'] = 'Dotted';
$string['double'] = 'Double';
$string['hide'] = 'Hide';
$string['show'] = 'Show';
$string['solid'] = 'Solid';
$string['versioninfo'] = 'Release {$a->release}, version {$a->version} on Moodle {$a->moodle}';
$string['versionalpha'] = 'Alpha version - Almost certainly contains bugs.  This is a development version for developers \'only\'!  Don\'t even think of installing on a production server!';
$string['versionbeta'] = 'Beta version - Likely to contain bugs.  Ready for testing by administrators on a test server only.';
$string['versionrc'] = 'Release candidate version - May contain bugs.  Check completely on a test server before considering on a production server.';
$string['versionstable'] = 'Stable version - Could contain bugs as there is not enough time left in the universe to find them all.  Check on a test server before installing on your production server, seriously do!  You won\'t regret it and you\'ll be able to customise until you\'re happy, then use the \'Import / export settings\' functionality to transfer the setting values.';

// Grade editing.
$string['turngradereditingoff'] = 'Turn grader editing off';
$string['turngradereditingon'] = 'Turn grader editing on';

// Navbar Links menu.
$string['linksmenu'] = 'Links menu';

// Navbar user menu.
$string['usermenu'] = 'User menu';

// Save / Discard button text.
$string['savebuttontext'] = 'Save changes';
$string['discardbuttontext'] = 'Cancel';

// Activity settings.
$string['activitiesheading'] = 'Activities';
$string['introboxbackgroundcolor'] = 'Intro box background color';
$string['introboxbackgroundcolordesc'] = 'Background colour for the intro box (highlights activity description) used in forums and other activities';

// Forum settings.
$string['settingsforumheading'] = 'Forum';
$string['forumheaderbackgroundcolor'] = 'Forum post header background';
$string['forumheaderbackgroundcolordesc'] = 'Background colour for a forum post.';
$string['forumbodybackgroundcolor'] = 'Forum post body background';
$string['forumbodybackgroundcolordesc'] = 'Background colour for a forum post.';

// Activity display margins.
$string['coursesectionactivitymargintop'] = 'Top margin activity spacing';
$string['coursesectionactivitymargintopdesc'] = 'Top margin spacing between activities.';
$string['coursesectionactivitymarginbottom'] = 'Bottom margin activity spacing.';
$string['coursesectionactivitymarginbottomdesc'] = 'Bottom margin spacing between activities.';

// Properties.
$string['properties'] = 'Import / export settings';
$string['propertiessub'] = 'Current theme settings';
$string['propertiesdesc'] = 'In this section you can import / export current Adaptable theme settings (properties) in JSON format. You can also view all current settings on this Moodle installation.';
$string['propertiesproperty'] = 'Property';
$string['propertiesvalue'] = 'Value';
$string['propertiesexport'] = 'Export properties without files<br>as a JSON string';
$string['propertiesexporthelp'] = 'After exporting, copy the JSON from the screen and paste it into the \'putprops\' setting (after clearing it) on the destination installation and click on \'Save changes\'.  A report will then be generated and put in the \'putprops\' setting.  It will list any file settings that need their files manually transferred.';
$string['propertiesexportfilestoo'] = 'Export properties with files<br>as a JSON string';
$string['propertiesexportfilestoohelp'] = 'After exporting, copy the JSON from the screen and paste it into the \'putprops\' setting (after clearing it) on the destination installation and click on \'Save changes\'.  A report will then be generated and put in the \'putprops\' setting.';
$string['propertiesexportfilestoofile'] = 'Export properties with files<br>as a JSON file';
$string['propertiesexportfilestoofilehelp'] = 'After exporting, download the generated JSON file with today\'s date and time from the \'propertyfiles\' setting and upload it into the \'fileputprops\' setting on the destination installation and click on \'Save changes\'.  A report will then be generated and put in the \'putprops\' setting.';
$string['propertiesexportfilestoofilesuccess'] = 'Properties with files as a JSON file exported as {$a}.';
$string['propertiesexportfilestoofilefail'] = 'Maximum properties with files as a JSON file reached.  Please delete one or more.';
$string['propertiesreturn'] = 'Return';
$string['propertyfileadded'] = 'File \'{$a->filename}\' added to setting \'{$a->settingname}\'.';
$string['propertyfileremoved'] = 'File \'{$a->filename}\' removed from setting \'{$a->settingname}\'.';
$string['propertyfiles'] = 'Property files';
$string['propertyfilesdesc'] = 'When the maximum is reached no more will be added until one or more are deleted.';
$string['putpropertiesheading'] = 'Import theme settings';
$string['putpropertiesname'] = 'Import properties';
$string['putpropertiesdesc'] = 'Paste the JSON string and \'Save changes\'.  Warning!  Does not validate setting values and performs a \'Purge all caches\'.';
$string['putpropertiesfilename'] = 'Import properties from a file';
$string['putpropertiesfiledesc'] = 'Drag and drop or upload the JSON file and \'Save changes\'.  Warning!  Does not validate setting values and performs a \'Purge all caches\'.  The report will be in \'putprops\'.';
$string['putpropertyreport'] = 'Report:';
$string['putpropertyversion'] = 'version:';
$string['putpropertyproperties'] = 'Properties';
$string['putpropertyour'] = 'Our';
$string['putpropertiesignorecti'] = 'Ignoring all course title image settings.';
$string['putpropertiesreportfiles'] = 'Remember to upload the following files to their settings:';
$string['putpropertiesreportfileschanged'] = 'Files changed:';
$string['putpropertiessettingsreport'] = 'Settings report:';
$string['putpropertiesvalue'] = '->';
$string['putpropertiesfrom'] = 'from';
$string['putpropertieschanged'] = 'Changed:';
$string['putpropertiesunchanged'] = 'Unchanged:';
$string['putpropertiesadded'] = 'Added:';
$string['putpropertiesignored'] = 'Ignored:';

// Privacy.
$string['privacy:note'] = 'Note: The Adaptable theme has settings that pertain to its configuration.  Specific user settings are described in the \'Plugin privacy registry\' and when installed, will also be for the Adaptable local plugin.  For the other settings, it is your responsibility to ensure that no user data is entered in any of the free text fields.  Setting a setting will result in that action being logged within the core Moodle logging system against the user whom changed it, this is outside of the themes control, please see the core logging system for privacy compliance for this.  When uploading images, you should avoid uploading images with embedded location data (EXIF GPS) included or other such personal data.  It would be possible to extract any location / personal data from the images.  Please examine the code carefully to be sure that it complies with your interpretation of your privacy laws.  I am not a lawyer and my analysis is based on my interpretation.  If you have any doubt then remove the theme forthwith.';
$string['privacy:closed'] = 'Closed';
$string['privacy:open'] = 'Open';
$string['privacy:nofull'] = 'Not full';
$string['privacy:fullin'] = 'Full in';
$string['privacy:metadata:preference:collapseblock'] = 'The state of the blocks on a page.';
$string['privacy:request:preference:collapseblock'] = 'The user preference "{$a->name}" for block id "{$a->blockid}" has the value "{$a->value}" which represents "{$a->decoded}" for the state of the block.';
$string['privacy:metadata:preference:draweropenindex'] = 'The state of the course index.';
$string['privacy:request:preference:draweropenindex'] = 'The user preference "{$a->name}" has the value "{$a->value}" which represents "{$a->decoded}" for the state of the course index.';
$string['privacy:metadata:preference:draweropenblock'] = 'The state of the block drawer.';
$string['privacy:request:preference:draweropenblock'] = 'The user preference "{$a->name}" has the value "{$a->value}" which represents "{$a->decoded}" for the state of the block drawer.';
$string['privacy:metadata:preference:themeadaptablezoom'] = 'The state of the zoom.';
$string['privacy:request:preference:themeadaptablezoom'] = 'The user preference "{$a->name}" has the value "{$a->value}" which represents "{$a->decoded}" for the state of the zoom.';
$string['privacy:metadata:preference:themeadaptablefull'] = 'The state of the full view.';
$string['privacy:request:preference:themeadaptablefull'] = 'The user preference "{$a->name}" has the value "{$a->value}" which represents "{$a->decoded}" for the state of the zoom.';
$string['privacy:metadata:preference:themeadaptablealertkey'] = 'The the given alert.';
$string['privacy:request:preference:themeadaptablealertkey'] = 'The user preference "{$a->name}" for alert id "{$a->alertid}" has the value "{$a->value}" for the given alert, \'undismissable\' or any other \'alertkey\' representing that the alert existed for the user.';

// Adaptable Tabbed layout changes.
$string['tabbedlayoutheading'] = 'Adaptable tabbed layout';
$string['tabbedlayoutcoursepage'] = 'Course page tabbed layout';
$string['tabbedlayoutcoursepagedesc'] = 'Use a tabbed layout for the course page.  This displays all content in tabs, with course content in one tab and allowing you to tailor the content in other tabs. Use this setting to configure the order of tabs.';
$string['tabbedlayoutcoursepagelink'] = 'Course page tabbed layout course link';
$string['tabbedlayoutcoursepagelinkdesc'] = 'Have a tab link back to the course page in the course tabs.';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Selected tab colour for course page';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Choose the colour for the currently selected tab.';
$string['tabbedlayoutcoursepagetabcolorunselected'] = 'Unselected tab colour for course page';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Choose the colour for any other tab.';
$string['tabbedlayoutcoursepagetabpersistencetime'] = 'Course tab persistence time';
$string['tabbedlayoutcoursepagetabpersistencetimedesc'] = 'Course tab persists on the selected tab when refreshing for a period of inactivity.  Set the inactivity period here.  For example, set to 30 so that the first tab is selected after 30 minutes of inactivity.';
$string['tabbedlayoutdashboard'] = 'Dashboard page tabbed layout';
$string['tabbedlayoutdashboarddesc'] = 'Use a tabbed layout for the Dashboard page.  This displays all content in tabs, with course content in one tab and allowing you to tailor the content in other tabs. Use this setting to configure the order of tabs.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Selected tab colour for dashboard';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Choose the colour for the currently selected tab.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Unselected tab colour for dashboard';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Choose the colour for any other tab.';
$string['tabbedlayoutdashboardtab1condition'] = 'Tab one Custom Profile Field Restriction (optional)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Add access rule for displaying Tab 1 using custom profile field eg: showtab1=true.';
$string['tabbedlayoutdashboardtab2condition'] = 'Tab two Custom Profile Field Restriction (optional)';
$string['tabbedlayoutdashboardtab2conditiondesc'] = 'Add access rule for displaying Tab 2 using custom profile field eg: showtab2=true.';

$string['tabbedlayouttablabelcourse'] = 'Course content';
$string['tabbedlayouttablabelcourse1'] = 'Tab one';
$string['tabbedlayouttablabelcourse2'] = 'Tab two';
$string['tabbedlayouttablabeldashboard'] = 'Dashboard content';
$string['tabbedlayouttablabeldashboard1'] = 'Tab one';
$string['tabbedlayouttablabeldashboard2'] = 'Tab two';

$string['region-course-tab-one-a'] = 'Course page tab region one';
$string['region-course-tab-two-a'] = 'Course page tab region two';
$string['region-my-tab-one-a'] = 'Dashboard page tab region one';
$string['region-my-tab-two-a'] = 'Dashboard page tab region two';

// Number of course tiles in front page.
$string['frontpagenumbertiles'] = 'Number of course tiles per row';
$string['frontpagenumbertilesdesc'] = 'Number of course tiles to display per row in the front page courses list.';
$string['frontpagetiles1'] = 'One tile';
$string['frontpagetiles2'] = 'Two tiles';
$string['frontpagetiles3'] = 'Three tiles';
$string['frontpagetiles4'] = 'Four tiles';
$string['frontpagetiles6'] = 'Six tiles';

// Edit settings.
$string['editsettingsbutton'] = 'Edit settings and button display';
$string['editsettingsbuttondesc'] = 'Configure here what should appear in the Navbar for editing settings.  Note that these options do not apply to pages for which there are no related settings, such as the dashboard page.';
$string['editsettingsbuttonshowcog'] = 'Show edit settings icon (cog / gear wheel icon) only.';
$string['editsettingsbuttonshowbutton'] = 'Show edit button only. E.g. "Turn Editing on" button on course page.';
$string['editsettingsbuttonshowcogandbutton'] = 'Show edit settings icon and cog.  Note that this takes up more space in navigation.';
$string['editcognocourseupdate'] = 'Show the cog / gear wheel to no course update users';
$string['editcognocourseupdatedesc'] = 'Show the cog / gear wheel to users who do not the the \'moodle/course:update\' capability, i.e. the \'Non-editing teacher\' role.';
$string['displayeditingbuttontext'] = 'Editing button text';
$string['displayeditingbuttontextdesc'] = 'Show or hide the text on the editing button.  Note: Only applies to the course editing button.';

// Login.
$string['loginsettings'] = 'Login page';
$string['loginsettingsheading'] = 'Customize the login page';
$string['logindesc'] = 'Customize the login page with adding an image background and texts above and below the login box.';

$string['loginsettingsheading'] = 'Customize the login page.';
$string['loginbgimage'] = 'Background image';
$string['loginbgimagedesc'] = 'Add a background image to the full size page.';
$string['loginbgstyle'] = 'Login background style';
$string['loginbgstyledesc'] = 'Select the style for the uploaded image.';
$string['loginbgopacity'] = 'Login page header, navbar, login box and footer background opacity when there is a background image';
$string['loginbgopacitydesc'] = 'Login background opacity for the header, navbar, login box and footer when there is a background image.';
$string['loginheader'] = 'Login page header';
$string['loginheaderdesc'] = 'Show the login page header.';
$string['loginfooter'] = 'Login page footer';
$string['loginfooterdesc'] = 'Show the login page footer.';
$string['logintextboxtop'] = 'Top text box';
$string['logintextboxtopdesc'] = 'Add a custom text above the login box.';
$string['logintextboxbottom'] = 'Bottom text box';
$string['logintextboxbottomdesc'] = 'Add a custom text below the login box.';

$string['stylecover'] = 'Cover';
$string['stylestretch'] = 'Stretch';

// User profile.
$string['aboutme'] = 'About me';
$string['course'] = 'Course';
$string['courses'] = 'Courses';
$string['more'] = 'More';

// User & user profile settings.
$string['usersettings'] = 'User profile';
$string['usersettingsdesc'] = 'Set settings for the user profile.';
$string['usersettingsheading'] = 'Control aspects of the user profile';
$string['customcoursetitle'] = 'Custom course title';
$string['customcoursetitledesc'] = 'Name of the user profile custom field for the course title.';
$string['customcoursesubtitle'] = 'Custom course sub title';
$string['customcoursesubtitledesc'] = 'Name of the user profile custom field for the course sub title.';
$string['enabletabbedprofile'] = 'Enable tabbed profile';
$string['enabletabbedprofiledesc'] = 'Enable the tabbed profile functionality.';
$string['enabledtabbedprofileeditprofilelink'] = 'Enable edit profile link';
$string['enabledtabbedprofileeditprofilelinkdesc'] = 'Enable the tabbed profile edit profile link.  Note: When enabled will only show if the viewing user has permission to edit the profile.';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Enable preferences link';
$string['enabledtabbedprofileuserpreferenceslinkdesc'] = 'Enable the tabbed profile user preferences link.';

$string['usernodescription'] = 'User has not updated their description yet.';
$string['usernointerests'] = 'User has not updated their interests yet.';

// Category headers settings.
$string['categoryheaderssettings'] = 'Category headers';
$string['categoryheaderssettingsdesc'] = 'Set settings for the headers within a category.';
$string['categoryheaderssettingsheading'] = 'Change the header for one or more top level categories and below.';

$string['categoryhavecustomheader'] = 'Category custom header';
$string['categoryhavecustomheaderdesc'] = 'Select the top level categories that will have a custom header.  To select more than one or deselect a category, use the \'Ctrl\' key.  Save and refesh the page to update  Note: Sub-categories of the selected will inherit the setting values.';
$string['categoryheaderheader'] = 'Settings for the top level category \'{$a->name}\' with id \'{$a->id}\'.';
$string['categoryheaderheaderdesc'] = 'Set the settings for the top level category \'{$a->name}\' with id \'{$a->id}\'.';
$string['categoryheaderheaderdescchildren'] = 'Set the settings for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\'.';
$string['categoryheaderbgimage'] = 'Category \'{$a->name}\' with id \'{$a->id}\' background image';
$string['categoryheaderbgimagedesc'] = 'Set a background image for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.  Minimum size is 1600x180px (1900x180px recommended).  The image will cover the full header.';
$string['categoryheaderbgimagedescchildren'] = 'Set a background image for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.  Minimum size is 1600x180px (1900x180px recommended).  The image will cover the full header.';
$string['categoryheaderbgimagetextcolour'] = 'Category \'{$a->name}\' with id \'{$a->id}\' background image text colour';
$string['categoryheaderbgimagetextcolourdesc'] = 'Set a background image text colour for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.';
$string['categoryheaderbgimagetextcolourdescchildren'] = 'Set a background image text colour for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.';
$string['categoryheaderlogo'] = 'Category \'{$a->name}\' with id \'{$a->id}\' logo';
$string['categoryheaderlogodesc'] = 'Set a logo for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.  Recommended size is 200px by 80px.';
$string['categoryheaderlogodescchildren'] = 'Set a logo for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.  Recommended size is 200px by 80px.';
$string['categoryheadercustomtitle'] = 'Category \'{$a->name}\' with id \'{$a->id}\' custom title';
$string['categoryheadercustomtitledesc'] = 'Set the custom title for the top level category \'{$a->name}\' with id \'{$a->id}\' in the header.  If blank then you will be presented with what has been configured by the \'sitetitle\' and \'sitetitletext\' settings on non-course pages or on course pages when \'enableheading\' is \'off\'.  When populated on non-course category linked pages then this will replace the site title.  When populated on course pages then will appear above the title as established by the \'enableheading\' setting.  But on mobiles any \'title\' will only appear depending on the \'responsivecoursetitle\' setting.';
$string['categoryheadercustomtitledescchildren'] = 'Set the custom title for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\' in the header.  If blank then you will be presented with what has been configured by the \'sitetitle\' and \'sitetitletext\' settings on non-course pages or on course pages when \'enableheading\' is \'off\'.  When populated on non-course category linked pages then this will replace the site title.  When populated on course pages then will appear above the title as established by the \'enableheading\' setting.  But on mobiles any \'title\' will only appear depending on the \'responsivecoursetitle\' setting.';
$string['categoryheadercustomcss'] = 'Category \'{$a->name}\' with id \'{$a->id}\' custom SCSS';
$string['categoryheadercustomcssdesc'] = 'Set custom SCSS for the top level category \'{$a->name}\' with id \'{$a->id}\'.  This will generate SCSS for the theme selector prefixed with \'.category-{$a->id}\'.  If the SCSS does not appear to be applied, then use the browser development tools to investigate and check the PHP log file.';
$string['categoryheadercustomcssdescchildren'] = 'Set custom SCSS for the top level category \'{$a->name}\' with id \'{$a->id}\' and its children \'{$a->children}\'.  This will generate SCSS for the theme selector prefixed with \'.category-{$a->id}\' and for all child ids.  If the SCSS does not appear to be applied, then use the browser development tools to investigate and check the PHP log file.';
$string['invalidcategoryscss'] = 'Invalid category custom SCSS for category \'{$a->topcatname}\' with id \'{$a->topcatid}\': \'{$a->scss}\'.';
$string['invalidcategorygeneratedscss'] = 'Invalid category custom generated CSS: \'{$a->scss}\'.';

// Print settings.
$string['printsettings'] = 'Print';
$string['printsettingsdesc'] = 'Set the settings for printing.';
$string['printsettingsheading'] = 'Print settings';

$string['printpageorientation'] = 'Page orientation';
$string['printpageorientationdesc'] = 'Set orientation of the page to \'Portrait\' or \'Landscape\'.';
$string['landscape'] = 'Landscape';
$string['portrait'] = 'Portrait';

$string['printbodyfontsize'] = 'Body font size';
$string['printbodyfontsizedesc'] = 'Set the size of the body font.';
$string['printmargin'] = 'Margin';
$string['printmargindesc'] = 'Set the margin.';
$string['printlineheight'] = 'Line height';
$string['printlineheightdesc'] = 'Set the line height.';
