<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   core
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['activityisscheduledfordeletion'] = 'Activity deletion in progress...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" is not a valid value for age.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" has more or less than one comma separator.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" is not a valid value for country.';
$string['agedigitalconsentmapinvaliddefault'] = 'Default (*) value is missing.';
$string['agelocationverificationdisabled'] = 'Age and location verification disabled';
$string['authnotexisting'] = 'The autorization plugin doesn\'t exist';
$string['backupcontainexternal'] = 'This backup file contains external Moodle Network Hosts that are not configured locally';
$string['backuptablefail'] = 'Backup tables could NOT be set up successfully!';
$string['blockcannotconfig'] = 'This block does not support global configuration';
$string['blockcannotinistantiate'] = 'Problem in instantiating block object';
$string['blockcannotread'] = 'Could not read data for blockid= {$a}';
$string['blockdoesnotexist'] = 'This block does not exist';
$string['blockdoesnotexistonpage'] = 'This block (id={$a->instanceid}) does not exist on this page ({$a->url}).';
$string['blocknameconflict'] = 'Naming conflict: block {$a->name} has the same title with an existing block: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Comment callback rejected this comment.';
$string['cannotaddcoursemodule'] = 'Could not add a new course module';
$string['cannotaddcoursemoduletosection'] = 'Could not add the new course module to that section';
$string['cannotaddmodule'] = '{$a} module could not be added to the module list!';
$string['cannotaddnewmodule'] = 'Could not add a new module of {$a}';
$string['cannotaddrss'] = 'You do not have permission to add rss feeds';
$string['cannotaddthisblocktype'] = 'You cannot add a {$a} block to this page.';
$string['cannotassignrole'] = 'Cannot assign role in course';
$string['cannotassignrolehere'] = 'You are not allowed to assign this role (id = {$a->roleid}) in this context ({$a->context})';
$string['cannotassignselfasparent'] = 'Cannot assign self as parent!';
$string['cannotcallscript'] = 'You cannot call this script in that way';
$string['cannotcallusgetselecteduser'] = 'You cannot call user_selector::get_selected_user if multi select is true.';
$string['cannotcreatebackupdir'] = 'Could not create backupdata folder.  The site administrator needs to fix the file permissions';
$string['cannotcreatecategory'] = 'The category was not inserted';
$string['cannotcreatedboninstall'] = '<p>Cannot create the database.</p>
<p>The specified database does not exist and the given user does not have permission to create the database.</p>
<p>The site administrator should verify database configuration.</p>';
$string['cannotcreategroup'] = 'Error creating group';
$string['cannotcreatelangbase'] = 'Error: Could not create base lang directory';
$string['cannotcreatelangdir'] = 'Cannot create lang directory';
$string['cannotcreateorfindstructs'] = 'Error finding or creating section structures for this course';
$string['cannotcreatepopupwin'] = 'Undefined element - cannot create pop-up window';
$string['cannotcreatesitedir'] = 'Cannot create site folder. The site administrator needs to fix the file permissions.';
$string['cannotcreatetempdir'] = 'Cannot create temp directory';
$string['cannotcreateuploaddir'] = 'Cannot create upload folder. The site administrator needs to fix the file permissions.';
$string['cannotcustomisefiltersblockuser'] = 'You cannot customise filters settings in user or block contexts.';
$string['cannotdeletebackupids'] = 'Couldn\'t delete previous backup ids';
$string['cannotdeletecategorycourse'] = 'Course \'{$a}\' failed to be deleted.';
$string['cannotdeletecategoryquestions'] = 'Could not delete questions from category \'{$a}\'';
$string['cannotdeletecourse'] = 'You do not have the permission to delete this course';
$string['cannotdeletecustomfield'] = 'Error deleting custom field data';
$string['cannotdeletedir'] = 'Cannot delete ({$a})';
$string['cannotdeletefile'] = 'Cannot delete this file';
$string['cannotdeleterole'] = 'It cannot be deleted, because {$a}';
$string['cannotdeleterolewithid'] = 'Could not delete role with ID {$a}';
$string['cannotdeletethisrole'] = 'You cannot delete this role because it is used by the system, or because it is the last role with administrator capabilities.';
$string['cannotdisableformat'] = 'The default format cannot be disabled.';
$string['cannotdownloadcomponents'] = 'Cannot download components';
$string['cannotdownloadlanguageupdatelist'] = 'Cannot download list of language updates from download.moodle.org';
$string['cannotdownloadzipfile'] = 'Cannot download ZIP file';
$string['cannoteditcomment'] = 'This comment is not yours to edit!';
$string['cannoteditcommentexpired'] = 'You can\'t edit this. The time has expired!';
$string['cannoteditpostorblog'] = 'You cannot post or edit blogs';
$string['cannoteditsiteform'] = 'You cannot edit the site course using this form';
$string['cannotedituserpreferences'] = 'Cannot edit this user\'s preferences';
$string['cannotedityourprofile'] = 'Sorry, you cannot edit own profile';
$string['cannotexecduringupgrade'] = 'Cannot be executed during upgrade';
$string['cannotfindcategory'] = 'Cannot find category record from database by ID - {$a}';
$string['cannotfindcomponent'] = 'Cannot find component';
$string['cannotfindcontext'] = 'Could not find context';
$string['cannotfindcourse'] = 'Cannot find course';
$string['cannotfinddocs'] = 'Cannot find "{$a}" language docs files';
$string['cannotfindgradeitem'] = 'Cannot find grade_item';
$string['cannotfindgroup'] = 'Unable to find group';
$string['cannotfindhelp'] = 'Cannot find "{$a}" language help files';
$string['cannotfindinfo'] = 'Cannot find info for: "{$a}"';
$string['cannotfindlang'] = 'Cannot find "{$a}" language pack!';
$string['cannotfindteacher'] = 'Cannot find teacher';
$string['cannotfinduser'] = 'Cannot find user named "{$a}"';
$string['cannotgeoplugin'] = 'Cannot connect to the geoPlugin server at https://www.geoplugin.com. Please check your proxy settings or install the MaxMind GeoLite City data file.';
$string['cannotgetblock'] = 'Could not retrieve blocks from the database';
$string['cannotgetcats'] = 'Cannot get category record';
$string['cannotgetdata'] = 'Cannot get data';
$string['cannotgradeuser'] = 'Cannot grade this user';
$string['cannothaveparentcate'] = 'Course category cannot have parent!';
$string['cannotimport'] = 'Import error';
$string['cannotimportformat'] = 'Sorry, importing this format is not yet implemented!';
$string['cannotimportgrade'] = 'Grade import error';
$string['cannotinsertgrade'] = 'Cannot insert grade item without course id!';
$string['cannotinsertrate'] = 'Could not insert a new rating ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Could not insert new record ID {$a}';
$string['cannotmailconfirm'] = 'Error sending password change confirmation email';
$string['cannotmanualctrack'] = 'Activity does not provide manual completion tracking';
$string['cannotmapfield'] = 'Mapping collision detected - two fields maps to the same grade item {$a}';
$string['cannotmigratedatacomments'] = 'Cannot migrate data module comments';
$string['cannotmodulename'] = 'Cannot get the module name in build navigation';
$string['cannotmoduletype'] = 'Cannot get the module type in build navigation';
$string['cannotmovecategory'] = 'Cannot move category';
$string['cannotmovecourses'] = 'Cannot move courses from the category they are in to another.';
$string['cannotmoverolewithid'] = 'Cannot move role with ID {$a}';
$string['cannotopencsv'] = 'Cannot open CSV file';
$string['cannotopenfile'] = 'Cannot open file ({$a})';
$string['cannotopenforwrit'] = 'Cannot open for writing: {$a}';
$string['cannotopentemplate'] = 'Cannot open template file ({$a})';
$string['cannotopenzip'] = 'Cannot open zip file, probably because of a zip extension bug on 64-bit OS.';
$string['cannotoverridebaserole'] = 'Cannot override base role capabilities';
$string['cannotoverriderolehere'] = 'You are not allowed to override this role (id = {$a->roleid}) in this context ({$a->context})';
$string['cannotreadfile'] = 'Cannot read file ({$a})';
$string['cannotreadtmpfile'] = 'Error reading temporary file';
$string['cannotreaduploadfile'] = 'Could not read uploaded file';
$string['cannotremovefrommeta'] = 'Could not remove the selected course from this meta course!';
$string['cannotreprocessgrades'] = 'Could not reprocess grades for this activity {$a}';
$string['cannotresetguestpwd'] = 'You cannot reset the guest password';
$string['cannotresetmail'] = 'Error resetting password and mailing you';
$string['cannotresetthisrole'] = 'Cannot reset this role';
$string['cannotrestore'] = 'An error has occurred and the restore could not be completed!';
$string['cannotrestoreadminorcreator'] = 'You need to be a creator or admin user to restore into new course!';
$string['cannotrestoreadminoredit'] = 'You need to be a editing teacher or admin user to restore into selected course!';
$string['cannotsaveagreement'] = 'Could not save your agreement';
$string['cannotsaveblock'] = 'Error saving block configuration';
$string['cannotsavecomment'] = 'Cannot save comment';
$string['cannotsavedata'] = 'Cannot save data';
$string['cannotsavefile'] = 'Cannot save the file "{$a}"!';
$string['cannotsavemd5file'] = 'Cannot save md5 file';
$string['cannotsavezipfile'] = 'Cannot save ZIP file';
$string['cannotservefile'] = 'Cannot serve file due to a server configuration problem.';
$string['cannotsetparentforcatoritem'] = 'Cannot set parent for category or course item!';
$string['cannotsetpassword'] = 'Could not set user password!';
$string['cannotsetprefgrade'] = 'Could not set preference aggregationview to {$a} for this grade category';
$string['cannotsettheme'] = 'Could not set the theme!';
$string['cannotsetupblock'] = 'Blocks tables could NOT be set up successfully!';
$string['cannotsetupcapformod'] = 'Could not set up the capabilities for {$a}';
$string['cannotsetupcapforplugin'] = 'Could not set up the capabilities for {$a}';
$string['cannotshowhidecoursesincategory'] = 'Cannot show/hide the courses in category {$a}.';
$string['cannotsignup'] = 'You cannot create a new account because you are already logged in as {$a}.';
$string['cannotunassigncap'] = 'Could not unassign deprecated capability {$a->cap} from role {$a->role}';
$string['cannotunassignrolefrom'] = 'Cannot unassign this user from role id: {$a}';
$string['cannotunzipfile'] = 'Cannot unzip file';
$string['cannotupdatemod'] = 'Could not update {$a}';
$string['cannotupdatepasswordonextauth'] = 'Failed to update password on external auth: {$a}. See the server logs for more details.';
$string['cannotupdateprofile'] = 'Error updating user record';
$string['cannotupdaterecord'] = 'Could not update record ID {$a}';
$string['cannotupdaterss'] = 'Cannot update RSS';
$string['cannotupdatesubcourse'] = 'Could not update a child course!';
$string['cannotupdateusermsgpref'] = 'Cannot update user message preferences';
$string['cannotupdateuseronexauth'] = 'Failed to update user data on external auth: {$a}. See the server logs for more details.';
$string['cannotuploadfile'] = 'Error processing upload file';
$string['cannotuseadmin'] = 'You need to be an admin user to use this page';
$string['cannotuseadminadminorteacher'] = 'You need to be a teacher or admin user to use this page';
$string['cannotusepage'] = 'Only teachers and administrators can use this page';
$string['cannotusepage2'] = 'Sorry, you may not use this page';
$string['cannotviewcategory'] = 'You don\'t have permission to view this list of courses.';
$string['cannotviewprofile'] = 'You cannot view the profile of this user';
$string['cannotviewreport'] = 'You cannot view this report';
$string['cannotwritefile'] = 'Cannot write to file ({$a})';
$string['categoryerror'] = 'Category error';
$string['categorynamerequired'] = 'Category name is required';
$string['categorytoolong'] = 'Category name too long';
$string['categoryidnumbertaken'] = 'ID number is already used for another category';
$string['commentmisconf'] = 'Comment ID is misconfigured';
$string['componentisuptodate'] = 'Component is up-to-date';
$string['confirmationnotenabled'] = 'User confirmation is not enabled on this site';
$string['confirmsesskeybad'] = 'Sorry, but your session key could not be confirmed to carry out this action.  This security feature prevents against accidental or malicious execution of important functions in your name.  Please make sure you really wanted to execute this function.';
$string['contenttypenotfound'] = 'The \'{$a}\' content bank type doesn\'t exist or is not recognised.';
$string['contentvisibilitynotfound'] = 'The content visibility with value \'{$a}\' doesn\'t exist or is not recognised.';
$string['couldnotassignrole'] = 'A serious but unspecified error occurred while trying to assign a role to you';
$string['couldnotupdatenoexistinguser'] = 'Cannot update the user - user doesn\'t exist';
$string['couldnotverifyagedigitalconsent'] = 'An error occurred while trying to verify the age of digital consent.<br />Please contact administrator.';
$string['countriesphpempty'] = 'Error: The file countries.php in language pack {$a} is empty or missing.';
$string['coursedoesnotbelongtocategory'] = 'The course doesn\'t belong to this category';
$string['courseformatnotfound'] = 'The course format \'{$a}\' doesn\'t exist or is not recognised.';
$string['coursegroupunknown'] = 'Course corresponding to group {$a} not specified';
$string['courseidnotfound'] = 'The course ID doesn\'t exist.';
$string['courseidnumbertaken'] = 'ID number is already used for another course ({$a})';
$string['coursemisconf'] = 'Course is misconfigured';
$string['courserequestdisabled'] = 'Sorry, but course requests have been disabled by the administrator.';
$string['csvcolumnduplicates'] = 'Duplicate columns detected';
$string['csvemptyfile'] = 'The CSV file is empty';
$string['csvfileerror'] = 'There is something wrong with the format of the CSV file. Please check the number of headings and columns match, and that the separator and file encoding are correct. {$a}';
$string['csvfewcolumns'] = 'Not enough columns, please verify the separator setting';
$string['csvinvalidcols'] = '<b>Invalid CSV file:</b> First line must include "Header Fields" and the file must be type of <br />"Expanded Fields/Comma Separated"<br />or<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Invalid CSV file - each line must include 49 or 70 fields';
$string['csvloaderror'] = 'An error occurred while loading the CSV file: {$a}';
$string['csvnodata'] = 'Invalid CSV file - The CSV file has headers but does not contain any data.';
$string['csvweirdcolumns'] = 'Invalid CSV file format - number of columns is not constant!';
$string['dbconnectionfailed'] = '<p>Error: Database connection failed</p>
<p>It is possible that the database is overloaded or otherwise not running properly.</p>
<p>The site administrator should also check that the database details have been correctly specified in config.php</p>';
$string['dbdriverproblem'] = '<p>Error: database driver problem detected</p>
<p>The site administrator should verify server configuration</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Serious database session problem detected.<br /><br />Please notify server administrator.';
$string['dbsessionhandlerproblem'] = 'Setting up of database session failed. Please notify the server administrator.';
$string['dbsessionmysqlpacketsize'] = 'A serious session error was detected. Please notify the site administrator. The problem is most probably caused by small value in max_allowed_packet MySQL setting.';
$string['dbupdatefailed'] = 'Database update failed';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" cannot be modified. Dependency found with {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql execution error';
$string['ddlfieldalreadyexists'] = 'Field "{$a}" already exists';
$string['ddlfieldnotexist'] = 'Field "{$a->fieldname}" does not exist in table "{$a->tablename}"';
$string['ddsequenceerror'] = 'Incorrect table "{$a}" definition; there can be only one auto column and it must be defined as a key.';
$string['ddltablealreadyexists'] = 'Table "{$a}" already exists';
$string['ddltablenotexist'] = 'Table "{$a}" does not exist';
$string['ddlunknownerror'] = 'Unknown DDL library error';
$string['ddlxmlfileerror'] = 'XML database file errors found';
$string['destinationcmnotexit'] = 'The destination course module does not exist';
$string['detectedbrokenplugin'] = 'The plugin {$a} is defective or outdated; sorry you cannot continue.';
$string['dmlexceptiononinstall'] = '<p>A database error has occurred [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Error parsing SQL query';
$string['dmlreadexception'] = 'Error reading from database';
$string['dmltransactionexception'] = 'Database transaction error';
$string['dmlwriteexception'] = 'Error writing to database';
$string['dndmaxbytes'] = 'The file is too large. The maximum size allowed is {$a->size}.';
$string['dndread'] = 'Error reading the file';
$string['dndupload'] = 'An unknown error ocurred while uploading the file';
$string['dndunkownfile'] = 'This file type is not supported';
$string['downgradedcore'] = 'ERROR!!!  The code you are using is OLDER than the version that made these databases!';
$string['downloadedfilecheckfailed'] = 'Downloaded file check failed';
$string['duplicatefieldname'] = 'Duplicate field name "{$a}" detected';
$string['duplicatenosupport'] = '\'{$a->modname}\' activity could not be duplicated because the {$a->modtype} module does not support backup and restore.';
$string['duplicateparaminsql'] = 'ERROR: duplicate parameter name in query';
$string['duplicaterolename'] = 'There is already a role with this name!';
$string['duplicateroleshortname'] = 'There is already a role with this short name!';
$string['duplicateusername'] = 'Duplicate username - skipping record';
$string['editedpagenotfound'] = 'The system couldn\'t determine the page you are on. Please refresh the page and try again.';
$string['emailfail'] = 'Emailing failed';
$string['encryption_encryptfailed'] = 'Encryption failed';
$string['encryption_decryptfailed'] = 'Decryption failed';
$string['encryption_invalidkey'] = 'Invalid key';
$string['encryption_keyalreadyexists'] = 'Key already exists';
$string['encryption_nokey'] = 'Key not found';
$string['encryption_wrongmethod'] = 'Data does not match a supported encryption method';
$string['enddatebeforestartdate'] = 'The course end date must be after the start date.';
$string['error'] = 'Error occurred';
$string['error_question_answers_missing_in_db'] = 'Failed to find an answer matching "{$a->answer}" in the question_answers database table. This occurred while restoring the question with id {$a->filequestionid} in the backup file, which has been matched to the existing question with id {$a->dbquestionid} in the database.';
$string['errorprocessingarchive'] = 'Error processing archive file';
$string['errorcleaningdirectory'] = 'Error cleaning directory "{$a}"';
$string['errorcopyingfiles'] = 'Error copying files';
$string['errorcreatingdirectory'] = 'Error creating directory "{$a}"';
$string['errorcreatingfile'] = 'Error creating file "{$a}"';
$string['errorcreatingrole'] = 'Error creating role';
$string['errorfetchingrssfeed'] = 'Error fetching RSS feed.';
$string['erroronline'] = 'Error on line {$a}';
$string['erroroutput'] = 'Error output, so disabling automatic redirect.';
$string['errorparsingxml'] = 'Error parsing XML: {$a->errorstring} at line {$a->errorline}, char {$a->errorchar}';
$string['errorreadingfile'] = 'Error reading file "{$a}"';
$string['errorsavingrequest'] = 'An error occurred when trying to save your request.';
$string['errorsettinguserpref'] = 'Error setting user preference';
$string['errorunzippingfiles'] = 'Error unzipping files';
$string['expiredkey'] = 'Expired key';
$string['externalauthpassworderror'] = 'Non-empty password for external authentication';
$string['externalfilenolocation'] = 'External file has no location path';
$string['failtoloadblocks'] = 'One or more blocks are registered in the database, but they all failed to load!';
$string['fieldrequired'] = '"{$a}" is a required field';
$string['fileexists'] = 'File exists';
$string['filemismatch'] = 'Non-core file name mismatch. The file "{$a->current}" should be {$a->file}';
$string['filenotfound'] = 'Sorry, the requested file could not be found';
$string['filenotreadable'] = 'File is not readable';
$string['filterdoesnothavelocalconfig'] = 'The filter {$a} does not allow local configuration.';
$string['filternotactive'] = 'Filter {$a} is not currently active';
$string['filternotenabled'] = 'Filter not enabled!';
$string['filternotinstalled'] = 'Filter {$a} is not currently installed';
$string['forumblockingtoomanyposts'] = 'You have exceeded the posting threshold set for this forum';
$string['functionalityremoved'] = 'You are trying to access functionality that has been removed.';
$string['generalexceptionmessage'] = 'Exception - {$a}';
$string['gradepubdisable'] = 'Grade publishing disabled';
$string['gradesneedregrading'] = 'The course grades need to be recalculated';
$string['gradecantregrade'] = 'An error occurred during grade calculation: {$a}';
$string['groupalready'] = 'User already belongs to group {$a}';
$string['groupexistforcourse'] = 'Group "{$a}" already exists for this course';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Group "{$a->name}" with an idnumber of "{$a->idnumber}" already exists for this course';
$string['grouphasidnumber'] = 'Group "{$a}" has an idnumber and may have been automatically created by an external system. You do not have permission to remove this group.';
$string['groupinghasidnumber'] = 'Grouping "{$a}" has an idnumber and may have been automatically created by an external system. You do not have permission to remove this grouping.';
$string['groupnotaddederror'] = 'Group "{$a}" not added';
$string['groupnotaddedtogroupingerror'] = 'Group "{$a->groupname}" not added to grouping "{$a->groupingname}"';
$string['groupingnotaddederror'] = 'Grouping "{$a}" not added';
$string['groupunknown'] = 'Group {$a} not associated to specified course';
$string['groupusernotmember'] = 'User is not member of this group.';
$string['guestcantaccessprofiles'] = 'Guests cannot access user profiles. Log in with a full user account to continue.';
$string['guestnocomment'] = 'Guests are not allowed to post comments!';
$string['guestnoeditprofile'] = 'The guest user cannot edit their profile';
$string['guestnoeditprofileother'] = 'The guest user profile cannot be edited';
$string['guestnorate'] = 'Guests are not allowed to rate entries';
$string['guestsarenotallowed'] = 'The guest user is not allowed to do this';
$string['hackdetected'] = 'Hack attack detected!';
$string['hashpoolproblem'] = 'Incorrect pool file content {$a}.';
$string['headersent'] = 'Headers already sent';
$string['idnumbertaken'] = 'This ID number is already in use';
$string['idnumbertoolong'] = 'ID number is too long';
$string['importformatnotimplement'] = 'Sorry, importing this format is not yet implemented!';
$string['incorrectext'] = 'File has an incorrect extension';
$string['inplaceeditableerror'] = 'Error calling update processor';
$string['installproblem'] = 'It is usually not possible to recover from errors triggered during installation, you may need to create a new database or use a different database prefix if you want to retry the installation.';
$string['internalauthpassworderror'] = 'Missing password or invalid password policy for internal authentication';
$string['invalidaccess'] = 'This page was not accessed correctly';
$string['invalidaccessparameter'] = 'Invalid access parameter';
$string['invalidaction'] = 'Invalid action parameter';
$string['invalidactivityid'] = 'Invalid activity ID';
$string['invalidadminsettingname'] = 'Invalid admin setting ({$a})';
$string['invalidargorconf'] = 'No valid arguments supplied or incorrect server configuration';
$string['invalidarguments'] = 'No valid arguments supplied';
$string['invalidblockinstance'] = 'Invalid block instance for: {$a}';
$string['invalidbulkenrolop'] = 'Invalid bulk enrolment operation requested.';
$string['invalidcategory'] = 'Incorrect category!';
$string['invalidcategoryid'] = 'Incorrect category ID!';
$string['invalidcomment'] = 'Comment is incorrect';
$string['invalidcommentid'] = 'Invalid comment ID';
$string['invalidcommentitemid'] = 'Invalid comment item ID';
$string['invalidcommentarea'] = 'Invalid comment area';
$string['invalidcommentparam'] = 'Invalid comment parameters';
$string['invalidcomponent'] = 'Invalid component name';
$string['invalidconfirmdata'] = 'Invalid confirmation data';
$string['invalidcontentid'] = 'Invalid content ID';
$string['invalidcontext'] = 'Invalid context';
$string['invalidcourse'] = 'Invalid course';
$string['invalidcourseid'] = 'You are trying to use an invalid course ID';
$string['invalidcourselevel'] = 'Incorrect context level';
$string['invalidcourseformat'] = 'Invalid course format';
$string['invalidcoursemodule'] = 'Invalid course module ID';
$string['invalidcoursemoduleid'] = 'Invalid course module ID: {$a}';
$string['invalidcoursenameshort'] = 'Invalid short course name';
$string['invalidcountrycode'] = 'Invalid country code: {$a}';
$string['invaliddata'] = 'Data submitted is invalid';
$string['invaliddatarootpermissions'] = 'Invalid permissions detected when trying to create a directory. Turn debugging on for further details.';
$string['invaliddevicetype'] = 'Invalid device type';
$string['invalidelementid'] = 'Incorrect element ID!';
$string['invalidentry'] = 'This is not valid entry!';
$string['invalidevent'] = 'Invalid event';
$string['invalidfieldname'] = '"{$a}" is not a valid field name';
$string['invalidfiletype'] = '"{$a}" is not a valid file type';
$string['invalidformatpara'] = 'Incorrect format for choose parameter';
$string['invalidformdata'] = 'Incorrect form data';
$string['invalidfunction'] = 'Incorrect function';
$string['invalidgradeitemid'] = 'Incorrect grade item ID';
$string['invalidgroupid'] = 'Incorrect group ID specified';
$string['invalidipformat'] = 'Invalid IP address format';
$string['invaliditemid'] = 'Incorrect item ID';
$string['invalidkey'] = 'Incorrect key';
$string['invalidlanguagecode'] = 'Invalid language code: {$a}';
$string['invalidlegacy'] = 'Incorrect legacy role definition for type: {$a}';
$string['invalidmd5'] = 'The check variable was wrong - try again';
$string['invalidmode'] = 'Invalid mode ({$a})';
$string['invalidmodule'] = 'Invalid module';
$string['invalidmoduleid'] = 'Invalid module ID: {$a}';
$string['invalidmodulename'] = 'Invalid module name: {$a}';
$string['invalidnum'] = 'Invalid numeric value';
$string['invalidnumkey'] = 'The array $conditions may not contain numeric keys. Please fix the code!';
$string['invalidoutcome'] = 'Incorrect outcome ID';
$string['invalidpagesize'] = 'Invalid page size';
$string['invalidpasswordpolicy'] = 'Invalid password policy';
$string['invalidpaymentmethod'] = 'Invalid payment method: {$a}';
$string['invalidpersistenterror'] = 'Error: {$a}';
$string['invalidqueryparam'] = 'ERROR: Incorrect number of query parameters. Expected {$a->expected}, got {$a->actual}.';
$string['invalidratingarea'] = 'Invalid rating area';
$string['invalidrecord'] = 'Can\'t find data record in database table {$a}.';
$string['invalidrecordunknown'] = 'Can\'t find data record in database.';
$string['invalidrequest'] = 'Invalid request';
$string['invalidrole'] = 'Invalid role';
$string['invalidroleid'] = 'Invalid role ID';
$string['invalidscaleid'] = 'Incorrect scale ID';
$string['invalidsection'] = 'Course module record contains invalid section';
$string['invalidsesskey'] = 'Your session has most likely timed out. Please check if you are logged in or go back to the previous screen and reload the page.';
$string['invalidshortname'] = 'Invalid short course name';
$string['invalidstatedetected'] = 'Something has gone wrong: {$a}. This should never normally happen.';
$string['invalidsourcefield'] = 'Draft file\'s source field is invalid';
$string['invalidurl'] = 'Invalid URL';
$string['invaliduser'] = 'Invalid user';
$string['invaliduserid'] = 'Invalid user ID';
$string['invaliduserfield'] = 'Invalid user field: {$a}';
$string['invaliduserdata'] = 'Invalid user data: {$a}';
$string['invalidusername'] = 'The given username contains invalid characters';
$string['invalidusernameblank'] = 'The username cannot be blank';
$string['invalidxmlfile'] = '"{$a}" is not a valid XML file';
$string['iplookupfailed'] = 'Cannot find geo information about this IP address {$a}';
$string['iplookupprivate'] = 'Cannot display lookup of private IP address';
$string['ipmismatch'] = 'Client IP address mismatch';
$string['listcantmovedown'] = 'Failed to move item down, as it is the last of its peers.';
$string['listcantmoveleft'] = 'Failed to move item left, as it has no parent';
$string['listcantmoveright'] = 'Failed to move item right, as there is no peer to make it a child of. Move it below another peer and then you can move it right.';
$string['listcantmoveup'] = 'Failed to move item up, as it is the first of its peers.';
$string['listnochildren'] = 'No children of item found';
$string['listnoitem'] = 'Item not found';
$string['listnopeers'] = 'No peers of item found';
$string['listupdatefail'] = 'DB operation failed when editing list hierarchy';
$string['logfilenotavailable'] = 'Logs not available';
$string['loginasnoenrol'] = 'You cannot use enrol or unenrol when in course "Login as" session';
$string['loginasonecourse'] = 'You cannot enter this course.<br /> You have to terminate the "Login as" session before entering any other course.';
$string['maxbytesfile'] = 'The file {$a->file} is too large. The maximum size you can upload is {$a->size}.';
$string['maxareabytes'] = 'The file is larger than the space remaining in this area.';
$string['maxdraftitemids'] = 'Your file uploads are temporarily limited after you uploaded a high volume of files. Please wait then try again.';
$string['messageundeliveredbynotificationsettings'] = 'The message could not be sent because personal messages between users (in Notification settings) has been disabled by a site administrator.';
$string['messagingdisable'] = 'Messaging is disabled on this site';
$string['mimetexisnotexist'] = 'Your system is not configured to run mimeTeX. You need to obtain the C source from <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, compile it and put the executable into your moodle/filter/tex/ directory.';
$string['mimetexnotexecutable'] = 'Custom mimetex is not executable!';
$string['missingcategoryrole'] = 'Could not assign role to user: missing role for category.';
$string['missingfield'] = 'Field "{$a}" is missing';
$string['missingkeyinsql'] = 'ERROR: missing param "{$a}" in query';
$string['missingparam'] = 'A required parameter ({$a}) was missing';
$string['missingparameter'] = 'Parameter missing';
$string['missingrequiredfield'] = 'Some required field is missing';
$string['missinguseranditemid'] = 'Missing userid and itemid';
$string['missingvarname'] = 'Required variable name is missing!';
$string['missing_moodle_backup_xml_file'] = 'Backup is missing XML file: {$a}';
$string['mixedtypesqlparam'] = 'ERROR: Mixed types of sql query parameters!!';
$string['mnetdisable'] = 'MNET is disabled';
$string['mnetlocal'] = 'Remote MNET users cannot log in locally';
$string['moduledisable'] = 'This module ({$a}) has been disabled for this particular course';
$string['moduledoesnotexist'] = 'This module does not exist';
$string['moduleinstancedoesnotexist'] = 'The instance of this module does not exist';
$string['modulemissingcode'] = 'Module {$a} is missing the code needed to perform this function';
$string['moodlenet:invalidshareformat'] = 'Incorrect MoodleNet share format';
$string['moodlenet:invalidsharestatus'] = 'Incorrect MoodleNet share status';
$string['moodlenet:invalidsharetype'] = 'Invalid MoodleNet share type';
$string['moodlenet:usernotconfigured'] = 'You do not have permission to share content to MoodleNet, or your account is incorrectly configured.';
$string['movecatcontentstoroot'] = 'Moving the category content to root is not allowed. You must move the contents to an existing category!';
$string['movecatcontentstoselected'] = 'Some category content cannot be moved into the selected category.';
$string['movecategorynotpossible'] = 'You cannot move category \'{$a}\' into the selected category.';
$string['movecategoryownparent'] = 'You cannot make category \'{$a}\' a parent of itself.';
$string['movecategoryparentconflict'] = 'You cannot make category \'{$a}\' a subcategory of one of its own subcategories.';
$string['mssqlrcsmodemissing'] = 'The database is not using the expected READ_COMMITTED_SNAPSHOT mode which can lead to wrong results, especially under high concurrency scenarios. Please enable it for correct behaviour. For further information, see the documentation <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a>.';
$string['multiplerecordsfound'] = 'Multiple records found, only one record expected.';
$string['multiplerestorenotallow'] = 'Multiple restore execution not allowed!';
$string['mustbeloggedin'] = 'You must be logged in to do this';
$string['mustbeteacher'] = 'You must be a teacher to look at this page';
$string['myisamproblem'] = 'Database tables are using MyISAM database engine, it is recommended to use ACID compliant engine with full transaction support such as InnoDB.';
$string['needcopy'] = 'You need to copy something first!';
$string['needcoursecategroyid'] = 'Either course id or category must be specified';
$string['needphpext'] = 'You need to add {$a} support to your PHP installation';
$string['noadmins'] = 'No administrators!';
$string['noblocks'] = 'No blocks found!';
$string['nocapabilitytousethisservice'] = 'The user hasn\'t the required capability to use this service';
$string['nocategorydelete'] = 'Category \'{$a}\' cannot be deleted!';
$string['nocontext'] = 'Sorry, but that course is not a valid context';
$string['nodata'] = 'No data';
$string['noexistingcategory'] = 'No existing category';
$string['nofile'] = 'File not specified';
$string['nofiltersenabled'] = 'No filters are enabled.';
$string['nofolder'] = 'Requested directory does not exist';
$string['noformdesc'] = 'No formslib form description file found for this activity.';
$string['noguest'] = 'No guests here!';
$string['noinstances'] = 'There are no instances of {$a} in this course!';
$string['nologinas'] = 'You are not allowed to log in as that user';
$string['nonmeaningfulcontent'] = 'Non meaningful content';
$string['noparticipants'] = 'No participants found for this course';
$string['noparticipatorycms'] = 'Sorry, but you have no participatory course modules to report on';
$string['nopermissions'] = 'Sorry, but you do not currently have permissions to do that ({$a}).';
$string['nopermissiontoaccesspage'] = 'You don\'t have permission to access this page.';
$string['nopermissiontocomment'] = 'You can\'t add comments';
$string['nopermissiontodelentry'] = 'You can\'t delete this comment!';
$string['nopermissiontoeditcomment'] = 'You can\'t edit other people\'s comments!';
$string['nopermissiontohide'] = 'No permission to hide!';
$string['nopermissiontoimportact'] = 'You do not have the required permissions to import activities to this course';
$string['nopermissiontolock'] = 'No permission to lock!';
$string['nopermissiontomanagegroup'] = 'You do not have the required permissions to manage groups';
$string['nopermissiontorate'] = 'Rating of items not allowed!';
$string['nopermissiontoshow'] = 'No permission to see this!';
$string['nopermissiontounlock'] = 'No permission to unlock!';
$string['nopermissiontoupdatecalendar'] = 'Sorry, but you do not have permission to update the calendar event.';
$string['nopermissiontoviewcalendar'] = 'Sorry, but you do not have permission to view the calendar event.';
$string['nopermissiontoviewgrades'] = 'Cannot view grades.';
$string['nopermissiontoviewletergrade'] = 'Missing permission to view letter grades';
$string['nopermissiontoviewpage'] = 'You are not allowed to look at this page';
$string['nosite'] = 'Could not find a top-level course!';
$string['nositeid'] = 'No site ID';
$string['nostartdatenoenddate'] = 'A course end date can only be set if a start date is also set.';
$string['nostatstodisplay'] = 'Sorry, there is no available data to display';
$string['notallowedtoupdateprefremotely'] = 'You are not allowed to update this user preference remotely';
$string['notavailable'] = 'That is not currently available';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'You are not a member of this course group';
$string['notownerofkey'] = 'You are not owner of this key';
$string['nousers'] = 'No such user!';
$string['oauth1accesstoken'] = 'OAuth 1.0 error: We did not obtain the access token.';
$string['oauth1requesttoken'] = 'OAuth 1.0 error: We did not obtain the request token - the service provider may be temporarily down.';
$string['oauth2upgradetokenerror'] = 'Could not upgrade OAuth 2 token. HTTP status for remote endpoint: {$a}';
$string['oauth2refreshtokenerror'] = 'Could not refresh OAuth 2 token. HTTP status for remote endpoint: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Could not refresh OAuth 2 token for one or more issuers. View task output for details.';
$string['onlyadmins'] = 'Only administrators can do that';
$string['onlyeditingteachers'] = 'Only editing teachers can do that';
$string['onlyeditown'] = 'You can only edit your own information';
$string['orderidnotfound'] = 'Order ID {$a} not found';
$string['opensslsignerror'] = 'OpenSSL unable to sign data';
$string['opensslsealerror'] = 'OpenSSL unable to seal data';
$string['pagenotexisttitle'] = '404 Error: File not found';
$string['pagenotexist'] = '<p>An unusual error occurred trying to view a page that does not exist:</p>{$a}';
$string['passwordexceeded'] = 'The password can\'t be more than {$a} characters.';
$string['pathdoesnotstartslash'] = 'No valid arguments supplied, path does not start with slash!';
$string['pleasereport'] = 'If you have time, please let us know what you were trying to do when the error occurred:';
$string['pluginnotexist'] = '{$a} plugin doesn\'t exist';
$string['pluginrequirementsnotmet'] = 'Plugin "{$a->pluginname}" ({$a->pluginversion}) could not be installed.  It requires a newer version of Moodle (currently you are using {$a->currentmoodle}, you need {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Plugin "{$a->pluginname}" {$a->pluginversion} does not support this version of Moodle {$a->moodleversion}. Seek plugin information to find supported versions.';
$string['prefixcannotbeempty'] = '<p>Error: database table prefix cannot be empty ({$a})</p>
<p>The site administrator must fix this problem.</p>';
$string['privatefilesupload'] = 'Uploading directly to user private files area is no longer supported. Upload to a draft area and then move the files with core_user::add_user_private_files';
$string['processingstops'] = 'Processing stops here. Remaining records ignored.';
$string['querystringcannotbeempty'] = 'The query string cannot be empty.';
$string['redirecterrordetected'] = 'Unsupported redirect detected, script execution terminated';
$string['redissessionhandlerproblem'] = 'Setting up of redis session failed. Please notify the server administrator.';
$string['refoundto'] = 'Can be refunded to {$a}';
$string['refoundtoorigi'] = 'Refunded to original amount: {$a}';
$string['registrationdisabled'] = 'Registration is disabled on this site';
$string['remotedownloaderror'] = '<p>The download of the component to your server failed. Please verify proxy settings; the PHP cURL extension is highly recommended.</p>
<p>You must download the <a href="{$a->url}">{$a->url}</a> file manually, copy it to "{$a->dest}" in your server and unzip it there.</p>';
$string['remotedownloadnotallowed'] = 'Download of components to your server isn\'t allowed (allow_url_fopen is disabled).<br /><br />You must download the <a href="{$a->url}">{$a->url}</a> file manually, copy it to "{$a->dest}" in your server and unzip it there.';
$string['reportnotavailable'] = 'This type of report is only available for the site course';
$string['requirecorrectaccess'] = 'Invalid url or port.';
$string['requireloginerror'] = 'Course or activity not accessible.';
$string['restorechecksumfailed'] = 'Some problem happened with the restore information stored in your session. Please check your PHP memory/DB package size limits. Restore stopped.';
$string['restore_path_element_missingmethod'] = 'Restore method {$a} is missing. It must be defined by a developer.';
$string['restore_path_element_noobject'] = 'Restore object {$a} is not an object.';
$string['restrictedcontextexception'] = 'Sorry, execution of external function violates context restriction.';
$string['restricteduser'] = 'Sorry, but your current account "{$a}" is restricted from doing that';
$string['reverseproxyabused'] = 'Reverse proxy enabled so the server cannot be accessed directly.<br />Please contact the server administrator.';
$string['rpcerror'] = 'Ooops! Your MNET communication has failed! Here\'s that error message to pass on to your administrator: {$a}';
$string['secretalreadyused'] = 'Change password confirmation link was already used, password was not changed';
$string['sectionnotexist'] = 'This section does not exist';
$string['sendmessage'] = 'Send message';
$string['sendmessagesent'] = 'Thanks for your feedback about:<br>{$a}';
$string['serverconnection'] = 'Error connecting to the server';
$string['servicedonotexist'] = 'The service does not exist';
$string['sessionwaiterr'] = 'Timed out while waiting for session lock.<br />Wait for your current requests to finish and try again later.';
$string['sessionexpired'] = 'Session expired';
$string['sessioncookiesdisable'] = 'Incorrect use of require_key_login() - session cookies must be disabled!';
$string['sessiondiskfull'] = 'The session partition is full. It is not possible to log in at this time. Please notify the server administrator.';
$string['sessionhandlerproblem'] = 'Session handler is misconfigured';
$string['sessionerroruser'] = 'Your session has timed out. Please log in again.';
$string['sessionerroruser2'] = 'A server error that affects your login session was detected. Please log in again or restart your browser.';
$string['sessionipnomatch'] = 'Sorry, but your IP number seems to have changed from when you first logged in.  This security feature prevents crackers stealing your identity while logged in to this site.  Normal users should not be seeing this message - please ask the site administrator for help.';
$string['sessionipnomatch2'] = '<p>Sorry, but your IP number seems to have changed from when you first logged in. This security feature prevents crackers stealing your identity while logged in to this site. You may see this error if you use wireless networks or if you are roaming between different networks. Please ask the site administrator for more help.</p>
<p>If you want to continue please press F5 key to refresh this page.</p>';
$string['sessioncannotobtainlock'] = '<p>Unable to obtain lock for session id {$a->id} within {$a->acquiretimeout}.</p>
<p>It is likely that another page ({$a->whohaslock}) is still running in another browser tab, or it did not release the lock due to an error.</p>
<p>You can wait until the session lock timeout ({$a->lockexpire}) or you can restart your browser session. If this error persists, please notify the server administrator.</p>';
$string['shortnametaken'] = 'Short name is already used for another course ({$a})';
$string['sitepolicynotagreed'] = 'Site policy not agreed: <a href="{$a}">Click here to open the site policy.</a>';
$string['scheduledbackupsdisabled'] = 'Scheduled backups have been disabled by the server admin';
$string['socksnotsupported'] = 'SOCKS5 proxy is not supported in PHP4';
$string['spellcheckernotconf'] = 'Spellchecker not configured';
$string['sslonlyaccess'] = 'For security reasons only https connections are allowed, sorry.';
$string['statscatchupmode'] = 'Statistics is currently in catchup mode. So far {$a->daysdone} day(s) have been processed and {$a->dayspending} are pending. Check back soon!';
$string['statsdisable'] = 'Statistics are not enabled.';
$string['statsnodata'] = 'There is no available data for that combination of course and time period';
$string['storedfilecannotcreatefile'] = 'Cannot create local file pool file. Please verify permissions in dataroot and available disk space.';
$string['storedfilecannotcreatefiledirs'] = 'Cannot create local file pool directories. Please verify permissions in dataroot.';
$string['storedfilecannotread'] = 'Cannot read file. Either the file does not exist or there is a permission problem.';
$string['storedfilecannotreadfile'] = 'Cannot read file \'{$a}\'. Either the file does not exist or there is a permission problem.';
$string['storedfilenotcreated'] = 'Cannot create file {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Unknown exception related to local files ({$a})';
$string['tagdisabled'] = 'Tags are disabled!';
$string['tagnotfound'] = 'The specified tag was not found in the database';
$string['targetdatabasenotempty'] = 'The target database is not empty. Transfer aborted for safety reasons.';
$string['textconditionsnotallowed'] = 'Comparisons of text column conditions are not allowed. Please use sql_compare_text() in your query.';
$string['themenotinstall'] = 'This theme is not installed!';
$string['TODO'] = 'TODO';
$string['tokengenerationfailed'] = 'Cannot generate a new token.';
$string['transactionvoid'] = 'Transaction cannot be voided because it has already been voided';
$string['unenrolerror'] = 'An error occurred while trying to unenrol that person';
$string['unicodeupgradeerror'] = 'Sorry, but your database is not already in Unicode, and this version of Moodle is not able to migrate your database to Unicode.  Please upgrade to Moodle 1.7.x first and perform the Unicode migration from the Admin page.  After that is done you should be able to migrate to Moodle {$a}';
$string['unknowaction'] = 'Unknown action!';
$string['unknowcategory'] = 'Category not known!';
$string['unknowcontext'] = 'This is an unknown context ({$a}) in get_child_contexts!';
$string['unknowformat'] = 'Format not known ({$a})';
$string['unknownbackupexporterror'] = 'Unknown error preparing information for import';
$string['unknownblockregion'] = 'The block region \'{$a}\' is not recognised on this page.';
$string['unknowncategory'] = 'Unknown category with category ID number "{$a}"';
$string['unknowncontext'] = 'This is an unknown context.';
$string['unknowncourse'] = 'Unknown course named "{$a}"';
$string['unknowncourseidnumber'] = 'Unknown course ID "{$a}"';
$string['unknowncoursesection'] = 'Unknown course section in course "{$a}"';
$string['unknowncourserequest'] = 'Unknown course request';
$string['unknownevent'] = 'Unknown event';
$string['unknownfiletype'] = 'Error unknown filtertype';
$string['unknowngroup'] = 'Unknown group "{$a}"';
$string['unknownjsinrequirejs'] = 'Cannot find JavaScript library {$a}.';
$string['unknownmodulename'] = 'Unknown module name for form';
$string['unknownrole'] = 'Unknown role "{$a}"';
$string['unknownsortcolumn'] = 'Unknown sort column {$a}';
$string['unknownuseraction'] = 'Sorry, I do not understand this user action';
$string['unknownuserselector'] = 'Unknown user selector';
$string['unknoworder'] = 'Unknown ordering';
$string['unknowparamtype'] = 'Unknown parameter type: {$a}';
$string['unknowquestiontype'] = 'Unsupported question type {$a}';
$string['unknowuploadaction'] = 'Error: Unknown upload action ({$a})';
$string['unspecifycourseid'] = 'Must specify course id, short name or idnumber';
$string['unsupportedevent'] = 'Unsupported event type';
$string['unsupportedstate'] = 'Unsupported completion state';
$string['unsupportedwebserver'] = 'Web server software ({$a}) is not supported, sorry.';
$string['upgraderequires19'] = 'Error: New Moodle version was installed on server, unfortunately upgrade from the previous version is not supported.<br />Please upgrade first to latest 1.9.x release. You can also return to previous version by reinstalling original files.';
$string['upgraderunning'] = 'Site is being upgraded, please retry later.';
$string['urlnotdefinerss'] = 'URL not defined for RSS feed';
$string['useradmineditadmin'] = 'Only administrators are allowed to modify other administrator accounts';
$string['useradminodelete'] = 'Administrator accounts cannot be deleted.';
$string['userautherror'] = 'Unknown auth plugin';
$string['userauthunsupported'] = 'Auth plugin not supported here';
$string['useremailduplicate'] = 'Duplicate address';
$string['userisfilteredout'] = 'This user does not match filters and table preferences!';
$string['usermustbemnet'] = 'Users in the MNET access control list must be remote MNET users';
$string['usernamelowercase'] = 'The username must be in lower case';
$string['usernotaddederror'] = 'User not added - error';
$string['usernotaddedregistered'] = 'User not added - already registered';
$string['usernotaddedusernameexists'] = 'User not added - username already exists under a different email';
$string['usernotavailable'] = 'The details of this user are not available to you';
$string['usernotdeletedadmin'] = 'User not deleted as administrator accounts cannot be deleted.';
$string['usernotdeleteddeleted'] = 'This user has already been deleted.';
$string['usernotdeletederror'] = 'User not deleted - error';
$string['usernotdeletedmissing'] = 'User not deleted - could not find the username';
$string['usernotdeletedoff'] = 'User not deleted - deleting not allowed';
$string['usernotfullysetup'] = 'User not fully set-up';
$string['usernotincourse'] = 'This user is not in this course!';
$string['usernotrenamedadmin'] = 'Cannot rename admin accounts';
$string['usernotrenamedexists'] = 'User not renamed - the new username is already in use';
$string['usernotrenamedmissing'] = 'User not renamed - could not find the old username';
$string['usernotrenamedoff'] = 'User not renamed - renaming not allowed';
$string['usernotupdatedadmin'] = 'Cannot update admin accounts';
$string['usernotupdatederror'] = 'User not updated - error';
$string['usernotupdatednotexists'] = 'User not updated - does not exist';
$string['userquotalimit'] = 'You have reached your file quota limit.';
$string['userselectortoomany'] = 'user_selector got more than one selected user, even though multiselect is false.';
$string['verifyagedigitalconsentnotpossible'] = 'Sorry, digital age consent verification is not possible at this time.';
$string['wrongcall'] = 'This script is called wrongly';
$string['wrongcontextid'] = 'Context ID was incorrect (cannot find it)';
$string['wrongdestpath'] = 'Wrong destination path';
$string['wrongroleid'] = 'Incorrect role ID!';
$string['wrongsourcebase'] = 'Wrong source URL base';
$string['wrongusernamepassword'] = 'Wrong user/password';
$string['wrongzipfilename'] = 'Wrong ZIP file name';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Could not create course - No permission';
$string['wwwrootmismatch'] = 'Incorrect access detected, this server may be accessed only through "{$a}" address, sorry.<br />Please notify server administrator.';
$string['wwwrootslash'] = 'Detected incorrect $CFG->wwwroot in config.php, it must not contain trailing slash.<br />Please notify server administrator.';
$string['xmldberror'] = 'XMLDB error!';
$string['alreadyloggedin'] = 'You are already logged in as {$a}, you need to log out before logging in as different user.';
$string['youcannotdeletecategory'] = 'You cannot delete category \'{$a}\' because you can neither delete the contents, nor move them elsewhere.';
$string['protected_cc_not_supported'] = 'Protected cartridges not supported.';

// Deprecated since Moodle 4.1.
$string['cannotswitcheditmodeon'] = 'Could not switch edit mode on';

// Deprecated since Moodle 4.3.
$string['prefixtoolong'] = '<p>Error: database table prefix is too long ({$a->dbfamily})</p>
<p>The site administrator must fix this problem. Maximum length for table prefixes in {$a->dbfamily} is {$a->maxlength} characters.</p>';

// Deprecated since Moodle 4.4.
$string['cannotmarktopic'] = 'Could not mark that section for this course';
$string['unknownhelp'] = 'Unknown help section {$a}';
